/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Environment;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.storage.StorageManager;
import android.util.ArraySet;
import android.util.Log;
import android.util.StatsLog;
import com.android.internal.util.ArrayUtils;
import com.android.server.LocalServices;
import com.android.server.PinnerService;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.dex.DexManager;
import com.android.server.pm.dex.DexoptOptions;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class BackgroundDexOptService
extends JobService {
    private static final String TAG = "BackgroundDexOptService";
    private static final boolean DEBUG = Log.isLoggable("BackgroundDexOptService", 3);
    private static final int JOB_IDLE_OPTIMIZE = 800;
    private static final int JOB_POST_BOOT_UPDATE = 801;
    private static final long IDLE_OPTIMIZATION_PERIOD = DEBUG ? TimeUnit.MINUTES.toMillis(1L) : TimeUnit.DAYS.toMillis(1L);
    private static ComponentName sDexoptServiceName = new ComponentName("android", BackgroundDexOptService.class.getName());
    private static final int OPTIMIZE_PROCESSED = 0;
    private static final int OPTIMIZE_CONTINUE = 1;
    private static final int OPTIMIZE_ABORT_BY_JOB_SCHEDULER = 2;
    private static final int OPTIMIZE_ABORT_NO_SPACE_LEFT = 3;
    private static final int LOW_THRESHOLD_MULTIPLIER_FOR_DOWNGRADE = 2;
    static final ArraySet<String> sFailedPackageNamesPrimary = new ArraySet();
    static final ArraySet<String> sFailedPackageNamesSecondary = new ArraySet();
    private final AtomicBoolean mAbortPostBootUpdate = new AtomicBoolean(false);
    private final AtomicBoolean mAbortIdleOptimization = new AtomicBoolean(false);
    private final AtomicBoolean mExitPostBootUpdate = new AtomicBoolean(false);
    private final File mDataDir = Environment.getDataDirectory();
    private static final long mDowngradeUnusedAppsThresholdInMillis = BackgroundDexOptService.getDowngradeUnusedAppsThresholdInMillis();

    public static void schedule(Context context) {
        if (BackgroundDexOptService.isBackgroundDexoptDisabled()) {
            return;
        }
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        js.schedule(new JobInfo.Builder(801, sDexoptServiceName).setMinimumLatency(TimeUnit.MINUTES.toMillis(1L)).setOverrideDeadline(TimeUnit.MINUTES.toMillis(1L)).build());
        js.schedule(new JobInfo.Builder(800, sDexoptServiceName).setRequiresDeviceIdle(true).setRequiresCharging(true).setPeriodic(IDLE_OPTIMIZATION_PERIOD).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyPackageChanged(String packageName) {
        ArraySet<String> arraySet = sFailedPackageNamesPrimary;
        synchronized (arraySet) {
            sFailedPackageNamesPrimary.remove(packageName);
        }
        arraySet = sFailedPackageNamesSecondary;
        synchronized (arraySet) {
            sFailedPackageNamesSecondary.remove(packageName);
        }
    }

    private int getBatteryLevel() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = this.registerReceiver(null, filter);
        int level = intent.getIntExtra("level", -1);
        int scale = intent.getIntExtra("scale", -1);
        boolean present = intent.getBooleanExtra("present", true);
        if (!present) {
            return 100;
        }
        if (level < 0 || scale <= 0) {
            return 0;
        }
        return 100 * level / scale;
    }

    private long getLowStorageThreshold(Context context) {
        long lowThreshold = StorageManager.from(context).getStorageLowBytes(this.mDataDir);
        if (lowThreshold == 0L) {
            Log.e(TAG, "Invalid low storage threshold");
        }
        return lowThreshold;
    }

    private boolean runPostBootUpdate(final JobParameters jobParams, final PackageManagerService pm, final ArraySet<String> pkgs) {
        if (this.mExitPostBootUpdate.get()) {
            return false;
        }
        new Thread("BackgroundDexOptService_PostBootUpdate"){

            @Override
            public void run() {
                BackgroundDexOptService.this.postBootUpdate(jobParams, pm, pkgs);
            }
        }.start();
        return true;
    }

    private void postBootUpdate(JobParameters jobParams, PackageManagerService pm, ArraySet<String> pkgs) {
        int lowBatteryThreshold = this.getResources().getInteger(17694827);
        long lowThreshold = this.getLowStorageThreshold(this);
        this.mAbortPostBootUpdate.set(false);
        ArraySet<String> updatedPackages = new ArraySet<String>();
        for (String pkg : pkgs) {
            if (this.mAbortPostBootUpdate.get()) {
                return;
            }
            if (this.mExitPostBootUpdate.get() || this.getBatteryLevel() < lowBatteryThreshold) break;
            long usableSpace = this.mDataDir.getUsableSpace();
            if (usableSpace < lowThreshold) {
                Log.w(TAG, "Aborting background dex opt job due to low storage: " + usableSpace);
                break;
            }
            int result = pm.performDexOptWithStatus(new DexoptOptions(pkg, 1, 4));
            if (result != 1) continue;
            updatedPackages.add(pkg);
        }
        this.notifyPinService(updatedPackages);
        this.jobFinished(jobParams, false);
    }

    private boolean runIdleOptimization(final JobParameters jobParams, final PackageManagerService pm, final ArraySet<String> pkgs) {
        new Thread("BackgroundDexOptService_IdleOptimization"){

            @Override
            public void run() {
                int result = BackgroundDexOptService.this.idleOptimization(pm, pkgs, BackgroundDexOptService.this);
                if (result != 2) {
                    Log.w(BackgroundDexOptService.TAG, "Idle optimizations aborted because of space constraints.");
                    BackgroundDexOptService.this.jobFinished(jobParams, false);
                }
            }
        }.start();
        return true;
    }

    private int idleOptimization(PackageManagerService pm, ArraySet<String> pkgs, Context context) {
        Log.i(TAG, "Performing idle optimizations");
        this.mExitPostBootUpdate.set(true);
        this.mAbortIdleOptimization.set(false);
        long lowStorageThreshold = this.getLowStorageThreshold(context);
        int result = this.optimizePackages(pm, pkgs, lowStorageThreshold, true);
        if (result == 2) {
            return result;
        }
        if (this.supportSecondaryDex()) {
            result = this.reconcileSecondaryDexFiles(pm.getDexManager());
            if (result == 2) {
                return result;
            }
            result = this.optimizePackages(pm, pkgs, lowStorageThreshold, false);
        }
        return result;
    }

    private long getDirectorySize(File f) {
        long size = 0L;
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                size += this.getDirectorySize(file);
            }
        } else {
            size = f.length();
        }
        return size;
    }

    private long getPackageSize(PackageManagerService pm, String pkg) {
        PackageInfo info = pm.getPackageInfo(pkg, 0, 0);
        long size = 0L;
        if (info != null && info.applicationInfo != null) {
            File path = Paths.get(info.applicationInfo.sourceDir, new String[0]).toFile();
            if (path.isFile()) {
                path = path.getParentFile();
            }
            size += this.getDirectorySize(path);
            if (!ArrayUtils.isEmpty(info.applicationInfo.splitSourceDirs)) {
                for (String splitSourceDir : info.applicationInfo.splitSourceDirs) {
                    path = Paths.get(splitSourceDir, new String[0]).toFile();
                    if (path.isFile()) {
                        path = path.getParentFile();
                    }
                    size += this.getDirectorySize(path);
                }
            }
            return size;
        }
        return 0L;
    }

    private int optimizePackages(PackageManagerService pm, ArraySet<String> pkgs, long lowStorageThreshold, boolean isForPrimaryDex) {
        ArraySet<String> updatedPackages = new ArraySet<String>();
        Set<String> unusedPackages = pm.getUnusedPackages(mDowngradeUnusedAppsThresholdInMillis);
        Log.d(TAG, "Unsused Packages " + String.join((CharSequence)",", unusedPackages));
        long lowStorageThresholdForDowngrade = 2L * lowStorageThreshold;
        boolean shouldDowngrade = this.shouldDowngrade(lowStorageThresholdForDowngrade);
        Log.d(TAG, "Should Downgrade " + shouldDowngrade);
        boolean dex_opt_performed = false;
        for (String pkg : pkgs) {
            int abort_code = this.abortIdleOptimizations(lowStorageThreshold);
            if (abort_code == 2) {
                return abort_code;
            }
            if (unusedPackages.contains(pkg) && shouldDowngrade) {
                dex_opt_performed = this.downgradePackage(pm, pkg, isForPrimaryDex);
            } else {
                if (abort_code == 3) continue;
                dex_opt_performed = this.optimizePackage(pm, pkg, isForPrimaryDex);
            }
            if (!dex_opt_performed) continue;
            updatedPackages.add(pkg);
        }
        this.notifyPinService(updatedPackages);
        return 0;
    }

    private boolean downgradePackage(PackageManagerService pm, String pkg, boolean isForPrimaryDex) {
        Log.d(TAG, "Downgrading " + pkg);
        boolean dex_opt_performed = false;
        int reason = 5;
        int dexoptFlags = 548;
        long package_size_before = this.getPackageSize(pm, pkg);
        if (isForPrimaryDex) {
            if (!pm.canHaveOatDir(pkg)) {
                pm.deleteOatArtifactsOfPackage(pkg);
            } else {
                dex_opt_performed = this.performDexOptPrimary(pm, pkg, reason, dexoptFlags);
            }
        } else {
            dex_opt_performed = this.performDexOptSecondary(pm, pkg, reason, dexoptFlags);
        }
        if (dex_opt_performed) {
            StatsLog.write(128, pkg, package_size_before, this.getPackageSize(pm, pkg), false);
        }
        return dex_opt_performed;
    }

    private boolean supportSecondaryDex() {
        return SystemProperties.getBoolean("dalvik.vm.dexopt.secondary", false);
    }

    private int reconcileSecondaryDexFiles(DexManager dm) {
        for (String p : dm.getAllPackagesWithSecondaryDexFiles()) {
            if (this.mAbortIdleOptimization.get()) {
                return 2;
            }
            dm.reconcileSecondaryDexFiles(p);
        }
        return 0;
    }

    private boolean optimizePackage(PackageManagerService pm, String pkg, boolean isForPrimaryDex) {
        int reason = 3;
        int dexoptFlags = 517;
        return isForPrimaryDex ? this.performDexOptPrimary(pm, pkg, reason, dexoptFlags) : this.performDexOptSecondary(pm, pkg, reason, dexoptFlags);
    }

    private boolean performDexOptPrimary(PackageManagerService pm, String pkg, int reason, int dexoptFlags) {
        int result = this.trackPerformDexOpt(pkg, false, () -> pm.performDexOptWithStatus(new DexoptOptions(pkg, reason, dexoptFlags)));
        return result == 1;
    }

    private boolean performDexOptSecondary(PackageManagerService pm, String pkg, int reason, int dexoptFlags) {
        DexoptOptions dexoptOptions = new DexoptOptions(pkg, reason, dexoptFlags | 8);
        int result = this.trackPerformDexOpt(pkg, true, () -> pm.performDexOpt(dexoptOptions) ? 1 : -1);
        return result == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int trackPerformDexOpt(String pkg, boolean isForPrimaryDex, Supplier<Integer> performDexOptWrapper) {
        ArraySet<String> sFailedPackageNames;
        ArraySet<String> arraySet = sFailedPackageNames = isForPrimaryDex ? sFailedPackageNamesPrimary : sFailedPackageNamesSecondary;
        synchronized (arraySet) {
            if (sFailedPackageNames.contains(pkg)) {
                return 0;
            }
            sFailedPackageNames.add(pkg);
        }
        int result = performDexOptWrapper.get();
        if (result != -1) {
            ArraySet<String> arraySet2 = sFailedPackageNames;
            synchronized (arraySet2) {
                sFailedPackageNames.remove(pkg);
            }
        }
        return result;
    }

    private int abortIdleOptimizations(long lowStorageThreshold) {
        if (this.mAbortIdleOptimization.get()) {
            return 2;
        }
        long usableSpace = this.mDataDir.getUsableSpace();
        if (usableSpace < lowStorageThreshold) {
            Log.w(TAG, "Aborting background dex opt job due to low storage: " + usableSpace);
            return 3;
        }
        return 1;
    }

    private boolean shouldDowngrade(long lowStorageThresholdForDowngrade) {
        long usableSpace = this.mDataDir.getUsableSpace();
        return usableSpace < lowStorageThresholdForDowngrade;
    }

    public static boolean runIdleOptimizationsNow(PackageManagerService pm, Context context, List<String> packageNames) {
        BackgroundDexOptService bdos = new BackgroundDexOptService();
        ArraySet<String> packagesToOptimize = packageNames == null ? pm.getOptimizablePackages() : new ArraySet<String>(packageNames);
        int result = bdos.idleOptimization(pm, packagesToOptimize, context);
        return result == 0;
    }

    @Override
    public boolean onStartJob(JobParameters params) {
        PackageManagerService pm = (PackageManagerService)ServiceManager.getService("package");
        if (pm.isStorageLow()) {
            return false;
        }
        ArraySet<String> pkgs = pm.getOptimizablePackages();
        if (pkgs.isEmpty()) {
            return false;
        }
        boolean result = params.getJobId() == 801 ? this.runPostBootUpdate(params, pm, pkgs) : this.runIdleOptimization(params, pm, pkgs);
        return result;
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        if (params.getJobId() == 801) {
            this.mAbortPostBootUpdate.set(true);
            return false;
        }
        this.mAbortIdleOptimization.set(true);
        return true;
    }

    private void notifyPinService(ArraySet<String> updatedPackages) {
        PinnerService pinnerService = LocalServices.getService(PinnerService.class);
        if (pinnerService != null) {
            Log.i(TAG, "Pinning optimized code " + updatedPackages);
            pinnerService.update(updatedPackages, false);
        }
    }

    private static long getDowngradeUnusedAppsThresholdInMillis() {
        String sysPropKey = "pm.dexopt.downgrade_after_inactive_days";
        String sysPropValue = SystemProperties.get("pm.dexopt.downgrade_after_inactive_days");
        if (sysPropValue == null || sysPropValue.isEmpty()) {
            Log.w(TAG, "SysProp pm.dexopt.downgrade_after_inactive_days not set");
            return Long.MAX_VALUE;
        }
        return TimeUnit.DAYS.toMillis(Long.parseLong(sysPropValue));
    }

    private static boolean isBackgroundDexoptDisabled() {
        return SystemProperties.getBoolean("pm.dexopt.disable_bg_dexopt", false);
    }
}

