/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.pm.AbstractStatsBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import libcore.io.IoUtils;

class CompilerStats
extends AbstractStatsBase<Void> {
    private static final String COMPILER_STATS_VERSION_HEADER = "PACKAGE_MANAGER__COMPILER_STATS__";
    private static final int COMPILER_STATS_VERSION = 1;
    private final Map<String, PackageStats> packageStats = new HashMap<String, PackageStats>();

    public CompilerStats() {
        super("package-cstats.list", "CompilerStats_DiskWriter", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageStats getPackageStats(String packageName) {
        Map<String, PackageStats> map = this.packageStats;
        synchronized (map) {
            return this.packageStats.get(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageStats(String packageName, PackageStats stats) {
        Map<String, PackageStats> map = this.packageStats;
        synchronized (map) {
            this.packageStats.put(packageName, stats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageStats createPackageStats(String packageName) {
        Map<String, PackageStats> map = this.packageStats;
        synchronized (map) {
            PackageStats newStats = new PackageStats(packageName);
            this.packageStats.put(packageName, newStats);
            return newStats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageStats getOrCreatePackageStats(String packageName) {
        Map<String, PackageStats> map = this.packageStats;
        synchronized (map) {
            PackageStats existingStats = this.packageStats.get(packageName);
            if (existingStats != null) {
                return existingStats;
            }
            return this.createPackageStats(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePackageStats(String packageName) {
        Map<String, PackageStats> map = this.packageStats;
        synchronized (map) {
            this.packageStats.remove(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer out) {
        FastPrintWriter fpw = new FastPrintWriter(out);
        fpw.print(COMPILER_STATS_VERSION_HEADER);
        fpw.println(1);
        Map<String, PackageStats> map = this.packageStats;
        synchronized (map) {
            for (PackageStats pkg : this.packageStats.values()) {
                Map map2 = pkg.compileTimePerCodePath;
                synchronized (map2) {
                    if (!pkg.compileTimePerCodePath.isEmpty()) {
                        fpw.println(pkg.getPackageName());
                        for (Map.Entry e : pkg.compileTimePerCodePath.entrySet()) {
                            fpw.println("-" + (String)e.getKey() + ":" + e.getValue());
                        }
                    }
                }
            }
        }
        fpw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(Reader r) {
        Map<String, PackageStats> map = this.packageStats;
        synchronized (map) {
            this.packageStats.clear();
            try {
                BufferedReader in = new BufferedReader(r);
                String versionLine = in.readLine();
                if (versionLine == null) {
                    throw new IllegalArgumentException("No version line found.");
                }
                if (!versionLine.startsWith(COMPILER_STATS_VERSION_HEADER)) {
                    throw new IllegalArgumentException("Invalid version line: " + versionLine);
                }
                int version = Integer.parseInt(versionLine.substring(COMPILER_STATS_VERSION_HEADER.length()));
                if (version != 1) {
                    throw new IllegalArgumentException("Unexpected version: " + version);
                }
                PackageStats currentPackage = new PackageStats("fake package");
                String s = null;
                while ((s = in.readLine()) != null) {
                    if (s.startsWith("-")) {
                        int colonIndex = s.indexOf(58);
                        if (colonIndex == -1 || colonIndex == 1) {
                            throw new IllegalArgumentException("Could not parse data " + s);
                        }
                        String codePath = s.substring(1, colonIndex);
                        long time = Long.parseLong(s.substring(colonIndex + 1));
                        currentPackage.setCompileTime(codePath, time);
                        continue;
                    }
                    currentPackage = this.getOrCreatePackageStats(s);
                }
            }
            catch (Exception e) {
                Log.e("PackageManager", "Error parsing compiler stats", e);
                return false;
            }
            return true;
        }
    }

    void writeNow() {
        this.writeNow(null);
    }

    boolean maybeWriteAsync() {
        return this.maybeWriteAsync(null);
    }

    @Override
    protected void writeInternal(Void data) {
        AtomicFile file = this.getFile();
        FileOutputStream f = null;
        try {
            f = file.startWrite();
            OutputStreamWriter osw = new OutputStreamWriter(f);
            this.write(osw);
            osw.flush();
            file.finishWrite(f);
        }
        catch (IOException e) {
            if (f != null) {
                file.failWrite(f);
            }
            Log.e("PackageManager", "Failed to write compiler stats", e);
        }
    }

    void read() {
        this.read((Void)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void readInternal(Void data) {
        AtomicFile file = this.getFile();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(file.openRead()));
            this.read(in);
        }
        catch (FileNotFoundException fileNotFoundException) {
            IoUtils.closeQuietly(in);
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
    }

    static class PackageStats {
        private final String packageName;
        private final Map<String, Long> compileTimePerCodePath;

        public PackageStats(String packageName) {
            this.packageName = packageName;
            this.compileTimePerCodePath = new ArrayMap<String, Long>(2);
        }

        public String getPackageName() {
            return this.packageName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getCompileTime(String codePath) {
            String storagePath = PackageStats.getStoredPathFromCodePath(codePath);
            Map<String, Long> map = this.compileTimePerCodePath;
            synchronized (map) {
                Long l = this.compileTimePerCodePath.get(storagePath);
                if (l == null) {
                    return 0L;
                }
                return l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCompileTime(String codePath, long compileTimeInMs) {
            String storagePath = PackageStats.getStoredPathFromCodePath(codePath);
            Map<String, Long> map = this.compileTimePerCodePath;
            synchronized (map) {
                if (compileTimeInMs <= 0L) {
                    this.compileTimePerCodePath.remove(storagePath);
                } else {
                    this.compileTimePerCodePath.put(storagePath, compileTimeInMs);
                }
            }
        }

        private static String getStoredPathFromCodePath(String codePath) {
            int lastSlash = codePath.lastIndexOf(File.separatorChar);
            return codePath.substring(lastSlash + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(IndentingPrintWriter ipw) {
            Map<String, Long> map = this.compileTimePerCodePath;
            synchronized (map) {
                if (this.compileTimePerCodePath.size() == 0) {
                    ipw.println("(No recorded stats)");
                } else {
                    for (Map.Entry<String, Long> e : this.compileTimePerCodePath.entrySet()) {
                        ipw.println(" " + e.getKey() + " - " + e.getValue());
                    }
                }
            }
        }
    }
}

