/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.AuxiliaryResolveInfo;
import android.content.pm.InstantAppResolveInfo;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.PackageUserState;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.IntentResolver;
import com.android.server.pm.DumpState;
import com.android.server.pm.PackageManagerException;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.UserManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComponentResolver {
    private static final boolean DEBUG = false;
    private static final String TAG = "PackageManager";
    private static final boolean DEBUG_FILTERS = false;
    private static final boolean DEBUG_SHOW_INFO = false;
    private static final Set<String> PROTECTED_ACTIONS = new ArraySet<String>();
    static final Comparator<ResolveInfo> RESOLVE_PRIORITY_SORTER;
    private static UserManagerService sUserManager;
    private static PackageManagerInternal sPackageManagerInternal;
    private final Object mLock;
    @GuardedBy(value={"mLock"})
    private final ActivityIntentResolver mActivities = new ActivityIntentResolver();
    @GuardedBy(value={"mLock"})
    private final ProviderIntentResolver mProviders = new ProviderIntentResolver();
    @GuardedBy(value={"mLock"})
    private final ActivityIntentResolver mReceivers = new ActivityIntentResolver();
    @GuardedBy(value={"mLock"})
    private final ServiceIntentResolver mServices = new ServiceIntentResolver();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<String, PackageParser.Provider> mProvidersByAuthority = new ArrayMap();
    private boolean mDeferProtectedFilters = true;
    private List<PackageParser.ActivityIntentInfo> mProtectedFilters;

    ComponentResolver(UserManagerService userManager, PackageManagerInternal packageManagerInternal, Object lock) {
        sPackageManagerInternal = packageManagerInternal;
        sUserManager = userManager;
        this.mLock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageParser.Activity getActivity(ComponentName component) {
        Object object = this.mLock;
        synchronized (object) {
            return (PackageParser.Activity)this.mActivities.mActivities.get(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageParser.Provider getProvider(ComponentName component) {
        Object object = this.mLock;
        synchronized (object) {
            return (PackageParser.Provider)this.mProviders.mProviders.get(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageParser.Activity getReceiver(ComponentName component) {
        Object object = this.mLock;
        synchronized (object) {
            return (PackageParser.Activity)this.mReceivers.mActivities.get(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageParser.Service getService(ComponentName component) {
        Object object = this.mLock;
        synchronized (object) {
            return (PackageParser.Service)this.mServices.mServices.get(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> queryActivities(Intent intent, String resolvedType, int flags, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mActivities.queryIntent(intent, resolvedType, flags, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> queryActivities(Intent intent, String resolvedType, int flags, List<PackageParser.Activity> activities, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mActivities.queryIntentForPackage(intent, resolvedType, flags, activities, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> queryProviders(Intent intent, String resolvedType, int flags, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mProviders.queryIntent(intent, resolvedType, flags, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> queryProviders(Intent intent, String resolvedType, int flags, List<PackageParser.Provider> providers, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mProviders.queryIntentForPackage(intent, resolvedType, flags, providers, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ProviderInfo> queryProviders(String processName, String metaDataKey, int uid, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        ArrayList<ProviderInfo> providerList = null;
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mProviders.mProviders.size() - 1; i >= 0; --i) {
                ProviderInfo info;
                PackageParser.Provider p = (PackageParser.Provider)this.mProviders.mProviders.valueAt(i);
                PackageSetting ps = (PackageSetting)p.owner.mExtras;
                if (ps == null || p.info.authority == null || processName != null && (!p.info.processName.equals(processName) || !UserHandle.isSameApp(p.info.applicationInfo.uid, uid)) || metaDataKey != null && (p.metaData == null || !p.metaData.containsKey(metaDataKey)) || (info = PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                if (providerList == null) {
                    providerList = new ArrayList<ProviderInfo>(i + 1);
                }
                providerList.add(info);
            }
        }
        return providerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProviderInfo queryProvider(String authority, int flags, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            PackageParser.Provider p = this.mProvidersByAuthority.get(authority);
            if (p == null) {
                return null;
            }
            PackageSetting ps = (PackageSetting)p.owner.mExtras;
            if (ps == null) {
                return null;
            }
            return PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void querySyncProviders(List<String> outNames, List<ProviderInfo> outInfo, boolean safeMode, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mProvidersByAuthority.size() - 1; i >= 0; --i) {
                ProviderInfo info;
                PackageParser.Provider p = this.mProvidersByAuthority.valueAt(i);
                PackageSetting ps = (PackageSetting)p.owner.mExtras;
                if (ps == null || !p.syncable || safeMode && (p.info.applicationInfo.flags & 1) == 0 || (info = PackageParser.generateProviderInfo(p, 0, ps.readUserState(userId), userId)) == null) continue;
                outNames.add(this.mProvidersByAuthority.keyAt(i));
                outInfo.add(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> queryReceivers(Intent intent, String resolvedType, int flags, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mReceivers.queryIntent(intent, resolvedType, flags, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> queryReceivers(Intent intent, String resolvedType, int flags, List<PackageParser.Activity> receivers, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mReceivers.queryIntentForPackage(intent, resolvedType, flags, receivers, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> queryServices(Intent intent, String resolvedType, int flags, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mServices.queryIntent(intent, resolvedType, flags, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> queryServices(Intent intent, String resolvedType, int flags, List<PackageParser.Service> services, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mServices.queryIntentForPackage(intent, resolvedType, flags, services, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActivityDefined(ComponentName component) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mActivities.mActivities.get(component) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertProvidersNotDefined(PackageParser.Package pkg) throws PackageManagerException {
        Object object = this.mLock;
        synchronized (object) {
            this.assertProvidersNotDefinedLocked(pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAllComponents(PackageParser.Package pkg, boolean chatty) {
        ArrayList<PackageParser.ActivityIntentInfo> newIntents = new ArrayList<PackageParser.ActivityIntentInfo>();
        Object object = this.mLock;
        synchronized (object) {
            this.addActivitiesLocked(pkg, newIntents, chatty);
            this.addReceiversLocked(pkg, chatty);
            this.addProvidersLocked(pkg, chatty);
            this.addServicesLocked(pkg, chatty);
        }
        String setupWizardPackage = sPackageManagerInternal.getKnownPackageName(1, 0);
        for (int i = newIntents.size() - 1; i >= 0; --i) {
            PackageParser.ActivityIntentInfo intentInfo = newIntents.get(i);
            PackageParser.Package disabledPkg = sPackageManagerInternal.getDisabledSystemPackage(intentInfo.activity.info.packageName);
            ArrayList<PackageParser.Activity> systemActivities = disabledPkg != null ? disabledPkg.activities : null;
            this.adjustPriority(systemActivities, intentInfo, setupWizardPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllComponents(PackageParser.Package pkg, boolean chatty) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeAllComponentsLocked(pkg, chatty);
        }
    }

    void fixProtectedFilterPriorities() {
        if (!this.mDeferProtectedFilters) {
            return;
        }
        this.mDeferProtectedFilters = false;
        if (this.mProtectedFilters == null || this.mProtectedFilters.size() == 0) {
            return;
        }
        List<PackageParser.ActivityIntentInfo> protectedFilters = this.mProtectedFilters;
        this.mProtectedFilters = null;
        String setupWizardPackage = sPackageManagerInternal.getKnownPackageName(1, 0);
        for (int i = protectedFilters.size() - 1; i >= 0; --i) {
            PackageParser.ActivityIntentInfo filter = protectedFilters.get(i);
            if (filter.activity.info.packageName.equals(setupWizardPackage)) continue;
            filter.setPriority(0);
        }
    }

    void dumpActivityResolvers(PrintWriter pw, DumpState dumpState, String packageName) {
        if (this.mActivities.dump(pw, dumpState.getTitlePrinted() ? "\nActivity Resolver Table:" : "Activity Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
            dumpState.setTitlePrinted(true);
        }
    }

    void dumpProviderResolvers(PrintWriter pw, DumpState dumpState, String packageName) {
        if (this.mProviders.dump(pw, dumpState.getTitlePrinted() ? "\nProvider Resolver Table:" : "Provider Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
            dumpState.setTitlePrinted(true);
        }
    }

    void dumpReceiverResolvers(PrintWriter pw, DumpState dumpState, String packageName) {
        if (this.mReceivers.dump(pw, dumpState.getTitlePrinted() ? "\nReceiver Resolver Table:" : "Receiver Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
            dumpState.setTitlePrinted(true);
        }
    }

    void dumpServiceResolvers(PrintWriter pw, DumpState dumpState, String packageName) {
        if (this.mServices.dump(pw, dumpState.getTitlePrinted() ? "\nService Resolver Table:" : "Service Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
            dumpState.setTitlePrinted(true);
        }
    }

    void dumpContentProviders(PrintWriter pw, DumpState dumpState, String packageName) {
        boolean printedSomething = false;
        for (PackageParser.Provider provider : this.mProviders.mProviders.values()) {
            if (packageName != null && !packageName.equals(provider.info.packageName)) continue;
            if (!printedSomething) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Registered ContentProviders:");
                printedSomething = true;
            }
            pw.print("  ");
            provider.printComponentShortName(pw);
            pw.println(":");
            pw.print("    ");
            pw.println(provider.toString());
        }
        printedSomething = false;
        for (Map.Entry entry : this.mProvidersByAuthority.entrySet()) {
            PackageParser.Provider p = (PackageParser.Provider)entry.getValue();
            if (packageName != null && !packageName.equals(p.info.packageName)) continue;
            if (!printedSomething) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("ContentProvider Authorities:");
                printedSomething = true;
            }
            pw.print("  [");
            pw.print((String)entry.getKey());
            pw.println("]:");
            pw.print("    ");
            pw.println(p.toString());
            if (p.info == null || p.info.applicationInfo == null) continue;
            String appInfo = p.info.applicationInfo.toString();
            pw.print("      applicationInfo=");
            pw.println(appInfo);
        }
    }

    void dumpServicePermissions(PrintWriter pw, DumpState dumpState, String packageName) {
        if (dumpState.onTitlePrinted()) {
            pw.println();
        }
        pw.println("Service permissions:");
        Iterator filterIterator = this.mServices.filterIterator();
        while (filterIterator.hasNext()) {
            PackageParser.ServiceIntentInfo info = (PackageParser.ServiceIntentInfo)filterIterator.next();
            ServiceInfo serviceInfo = info.service.info;
            String permission2 = serviceInfo.permission;
            if (permission2 == null) continue;
            pw.print("    ");
            pw.print(serviceInfo.getComponentName().flattenToShortString());
            pw.print(": ");
            pw.println(permission2);
        }
    }

    @GuardedBy(value={"mLock"})
    private void addActivitiesLocked(PackageParser.Package pkg, List<PackageParser.ActivityIntentInfo> newIntents, boolean chatty) {
        int activitiesSize = pkg.activities.size();
        Object r = null;
        for (int i = 0; i < activitiesSize; ++i) {
            PackageParser.Activity a = pkg.activities.get(i);
            a.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, a.info.processName);
            this.mActivities.addActivity(a, "activity", newIntents);
        }
    }

    @GuardedBy(value={"mLock"})
    private void addProvidersLocked(PackageParser.Package pkg, boolean chatty) {
        int providersSize = pkg.providers.size();
        Object r = null;
        for (int i = 0; i < providersSize; ++i) {
            PackageParser.Provider p = pkg.providers.get(i);
            p.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, p.info.processName);
            this.mProviders.addProvider(p);
            p.syncable = p.info.isSyncable;
            if (p.info.authority == null) continue;
            String[] names = p.info.authority.split(";");
            p.info.authority = null;
            for (int j = 0; j < names.length; ++j) {
                if (j == 1 && p.syncable) {
                    p = new PackageParser.Provider(p);
                    p.syncable = false;
                }
                if (!this.mProvidersByAuthority.containsKey(names[j])) {
                    this.mProvidersByAuthority.put(names[j], p);
                    if (p.info.authority == null) {
                        p.info.authority = names[j];
                        continue;
                    }
                    p.info.authority = p.info.authority + ";" + names[j];
                    continue;
                }
                PackageParser.Provider other = this.mProvidersByAuthority.get(names[j]);
                ComponentName component = other != null && other.getComponentName() != null ? other.getComponentName() : null;
                String packageName = component != null ? component.getPackageName() : "?";
                Slog.w(TAG, "Skipping provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + "): name already used by " + packageName);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void addReceiversLocked(PackageParser.Package pkg, boolean chatty) {
        int receiversSize = pkg.receivers.size();
        Object r = null;
        for (int i = 0; i < receiversSize; ++i) {
            PackageParser.Activity a = pkg.receivers.get(i);
            a.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, a.info.processName);
            this.mReceivers.addActivity(a, "receiver", null);
        }
    }

    @GuardedBy(value={"mLock"})
    private void addServicesLocked(PackageParser.Package pkg, boolean chatty) {
        int servicesSize = pkg.services.size();
        Object r = null;
        for (int i = 0; i < servicesSize; ++i) {
            PackageParser.Service s = pkg.services.get(i);
            s.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, s.info.processName);
            this.mServices.addService(s);
        }
    }

    private static <T> void getIntentListSubset(List<PackageParser.ActivityIntentInfo> intentList, IterGenerator<T> generator, Iterator<T> searchIterator) {
        while (searchIterator.hasNext() && intentList.size() != 0) {
            T searchAction = searchIterator.next();
            Iterator<PackageParser.ActivityIntentInfo> intentIter = intentList.iterator();
            while (intentIter.hasNext()) {
                PackageParser.ActivityIntentInfo intentInfo = intentIter.next();
                boolean selectionFound = false;
                Iterator<T> intentSelectionIter = generator.generate(intentInfo);
                while (intentSelectionIter != null && intentSelectionIter.hasNext()) {
                    T intentSelection = intentSelectionIter.next();
                    if (intentSelection == null || !intentSelection.equals(searchAction)) continue;
                    selectionFound = true;
                    break;
                }
                if (selectionFound) continue;
                intentIter.remove();
            }
        }
    }

    private static boolean isProtectedAction(PackageParser.ActivityIntentInfo filter) {
        Iterator<String> actionsIter = filter.actionsIterator();
        while (actionsIter != null && actionsIter.hasNext()) {
            String filterAction = actionsIter.next();
            if (!PROTECTED_ACTIONS.contains(filterAction)) continue;
            return true;
        }
        return false;
    }

    private static PackageParser.Activity findMatchingActivity(List<PackageParser.Activity> activityList, ActivityInfo activityInfo) {
        for (PackageParser.Activity sysActivity : activityList) {
            if (sysActivity.info.name.equals(activityInfo.name)) {
                return sysActivity;
            }
            if (sysActivity.info.name.equals(activityInfo.targetActivity)) {
                return sysActivity;
            }
            if (sysActivity.info.targetActivity == null) continue;
            if (sysActivity.info.targetActivity.equals(activityInfo.name)) {
                return sysActivity;
            }
            if (!sysActivity.info.targetActivity.equals(activityInfo.targetActivity)) continue;
            return sysActivity;
        }
        return null;
    }

    private void adjustPriority(List<PackageParser.Activity> systemActivities, PackageParser.ActivityIntentInfo intent, String setupWizardPackage) {
        Iterator<IntentFilter.AuthorityEntry> authoritiesIterator;
        Iterator<String> schemesIterator;
        Iterator<String> categoriesIterator;
        boolean privilegedApp;
        if (intent.getPriority() <= 0) {
            return;
        }
        ActivityInfo activityInfo = intent.activity.info;
        ApplicationInfo applicationInfo = activityInfo.applicationInfo;
        boolean bl = privilegedApp = (applicationInfo.privateFlags & 8) != 0;
        if (!privilegedApp) {
            intent.setPriority(0);
            return;
        }
        if (systemActivities == null) {
            if (ComponentResolver.isProtectedAction(intent)) {
                if (this.mDeferProtectedFilters) {
                    if (this.mProtectedFilters == null) {
                        this.mProtectedFilters = new ArrayList<PackageParser.ActivityIntentInfo>();
                    }
                    this.mProtectedFilters.add(intent);
                    return;
                }
                if (intent.activity.info.packageName.equals(setupWizardPackage)) {
                    return;
                }
                intent.setPriority(0);
                return;
            }
            return;
        }
        PackageParser.Activity foundActivity = ComponentResolver.findMatchingActivity(systemActivities, activityInfo);
        if (foundActivity == null) {
            intent.setPriority(0);
            return;
        }
        ArrayList<PackageParser.ActivityIntentInfo> intentListCopy = new ArrayList<PackageParser.ActivityIntentInfo>(foundActivity.intents);
        ArrayList foundFilters = this.mActivities.findFilters(intent);
        Iterator<String> actionsIterator = intent.actionsIterator();
        if (actionsIterator != null) {
            ComponentResolver.getIntentListSubset(intentListCopy, new ActionIterGenerator(), actionsIterator);
            if (intentListCopy.size() == 0) {
                intent.setPriority(0);
                return;
            }
        }
        if ((categoriesIterator = intent.categoriesIterator()) != null) {
            ComponentResolver.getIntentListSubset(intentListCopy, new CategoriesIterGenerator(), categoriesIterator);
            if (intentListCopy.size() == 0) {
                intent.setPriority(0);
                return;
            }
        }
        if ((schemesIterator = intent.schemesIterator()) != null) {
            ComponentResolver.getIntentListSubset(intentListCopy, new SchemesIterGenerator(), schemesIterator);
            if (intentListCopy.size() == 0) {
                intent.setPriority(0);
                return;
            }
        }
        if ((authoritiesIterator = intent.authoritiesIterator()) != null) {
            ComponentResolver.getIntentListSubset(intentListCopy, new AuthoritiesIterGenerator(), authoritiesIterator);
            if (intentListCopy.size() == 0) {
                intent.setPriority(0);
                return;
            }
        }
        int cappedPriority = 0;
        for (int i = intentListCopy.size() - 1; i >= 0; --i) {
            cappedPriority = Math.max(cappedPriority, ((PackageParser.ActivityIntentInfo)intentListCopy.get(i)).getPriority());
        }
        if (intent.getPriority() > cappedPriority) {
            intent.setPriority(cappedPriority);
            return;
        }
    }

    @GuardedBy(value={"mLock"})
    private void removeAllComponentsLocked(PackageParser.Package pkg, boolean chatty) {
        PackageParser.Activity a;
        int i;
        int componentSize = pkg.activities.size();
        Object r = null;
        for (i = 0; i < componentSize; ++i) {
            a = pkg.activities.get(i);
            this.mActivities.removeActivity(a, "activity");
        }
        componentSize = pkg.providers.size();
        r = null;
        for (i = 0; i < componentSize; ++i) {
            PackageParser.Provider p = pkg.providers.get(i);
            this.mProviders.removeProvider(p);
            if (p.info.authority == null) continue;
            String[] names = p.info.authority.split(";");
            for (int j = 0; j < names.length; ++j) {
                if (this.mProvidersByAuthority.get(names[j]) != p) continue;
                this.mProvidersByAuthority.remove(names[j]);
            }
        }
        componentSize = pkg.receivers.size();
        r = null;
        for (i = 0; i < componentSize; ++i) {
            a = pkg.receivers.get(i);
            this.mReceivers.removeActivity(a, "receiver");
        }
        componentSize = pkg.services.size();
        r = null;
        for (i = 0; i < componentSize; ++i) {
            PackageParser.Service s = pkg.services.get(i);
            this.mServices.removeService(s);
        }
    }

    @GuardedBy(value={"mLock"})
    private void assertProvidersNotDefinedLocked(PackageParser.Package pkg) throws PackageManagerException {
        int providersSize = pkg.providers.size();
        for (int i = 0; i < providersSize; ++i) {
            PackageParser.Provider p = pkg.providers.get(i);
            if (p.info.authority == null) continue;
            String[] names = p.info.authority.split(";");
            for (int j = 0; j < names.length; ++j) {
                String otherPackageName;
                if (!this.mProvidersByAuthority.containsKey(names[j])) continue;
                PackageParser.Provider other = this.mProvidersByAuthority.get(names[j]);
                String string2 = otherPackageName = other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?";
                if (otherPackageName.equals(pkg.packageName)) continue;
                throw new PackageManagerException(-13, "Can't install because provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + ") is already used by " + otherPackageName);
            }
        }
    }

    static {
        PROTECTED_ACTIONS.add("android.intent.action.SEND");
        PROTECTED_ACTIONS.add("android.intent.action.SENDTO");
        PROTECTED_ACTIONS.add("android.intent.action.SEND_MULTIPLE");
        PROTECTED_ACTIONS.add("android.intent.action.VIEW");
        RESOLVE_PRIORITY_SORTER = (r1, r2) -> {
            int v1 = r1.priority;
            int v2 = r2.priority;
            if (v1 != v2) {
                return v1 > v2 ? -1 : 1;
            }
            v1 = r1.preferredOrder;
            v2 = r2.preferredOrder;
            if (v1 != v2) {
                return v1 > v2 ? -1 : 1;
            }
            if (r1.isDefault != r2.isDefault) {
                return r1.isDefault ? -1 : 1;
            }
            v1 = r1.match;
            v2 = r2.match;
            if (v1 != v2) {
                return v1 > v2 ? -1 : 1;
            }
            if (r1.system != r2.system) {
                return r1.system ? -1 : 1;
            }
            if (r1.activityInfo != null) {
                return r1.activityInfo.packageName.compareTo(r2.activityInfo.packageName);
            }
            if (r1.serviceInfo != null) {
                return r1.serviceInfo.packageName.compareTo(r2.serviceInfo.packageName);
            }
            if (r1.providerInfo != null) {
                return r1.providerInfo.packageName.compareTo(r2.providerInfo.packageName);
            }
            return 0;
        };
    }

    static class AuthoritiesIterGenerator
    extends IterGenerator<IntentFilter.AuthorityEntry> {
        AuthoritiesIterGenerator() {
        }

        @Override
        public Iterator<IntentFilter.AuthorityEntry> generate(PackageParser.ActivityIntentInfo info) {
            return info.authoritiesIterator();
        }
    }

    static class SchemesIterGenerator
    extends IterGenerator<String> {
        SchemesIterGenerator() {
        }

        @Override
        public Iterator<String> generate(PackageParser.ActivityIntentInfo info) {
            return info.schemesIterator();
        }
    }

    static class CategoriesIterGenerator
    extends IterGenerator<String> {
        CategoriesIterGenerator() {
        }

        @Override
        public Iterator<String> generate(PackageParser.ActivityIntentInfo info) {
            return info.categoriesIterator();
        }
    }

    static class ActionIterGenerator
    extends IterGenerator<String> {
        ActionIterGenerator() {
        }

        @Override
        public Iterator<String> generate(PackageParser.ActivityIntentInfo info) {
            return info.actionsIterator();
        }
    }

    static class IterGenerator<E> {
        IterGenerator() {
        }

        public Iterator<E> generate(PackageParser.ActivityIntentInfo info) {
            return null;
        }
    }

    static final class InstantAppIntentResolver
    extends IntentResolver<AuxiliaryResolveInfo.AuxiliaryFilter, AuxiliaryResolveInfo.AuxiliaryFilter> {
        final ArrayMap<String, Pair<Integer, InstantAppResolveInfo>> mOrderResult = new ArrayMap();

        InstantAppIntentResolver() {
        }

        protected AuxiliaryResolveInfo.AuxiliaryFilter[] newArray(int size) {
            return new AuxiliaryResolveInfo.AuxiliaryFilter[size];
        }

        @Override
        protected boolean isPackageForFilter(String packageName, AuxiliaryResolveInfo.AuxiliaryFilter responseObj) {
            return true;
        }

        @Override
        protected AuxiliaryResolveInfo.AuxiliaryFilter newResult(AuxiliaryResolveInfo.AuxiliaryFilter responseObj, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            String packageName = responseObj.resolveInfo.getPackageName();
            Integer order = responseObj.getOrder();
            Pair<Integer, InstantAppResolveInfo> lastOrderResult = this.mOrderResult.get(packageName);
            if (lastOrderResult != null && (Integer)lastOrderResult.first >= order) {
                return null;
            }
            InstantAppResolveInfo res = responseObj.resolveInfo;
            if (order > 0) {
                this.mOrderResult.put(packageName, new Pair<Integer, InstantAppResolveInfo>(order, res));
            }
            return responseObj;
        }

        @Override
        protected void filterResults(List<AuxiliaryResolveInfo.AuxiliaryFilter> results) {
            if (this.mOrderResult.size() == 0) {
                return;
            }
            int resultSize = results.size();
            for (int i = 0; i < resultSize; ++i) {
                InstantAppResolveInfo info = results.get((int)i).resolveInfo;
                String packageName = info.getPackageName();
                Pair<Integer, InstantAppResolveInfo> savedInfo = this.mOrderResult.get(packageName);
                if (savedInfo == null) continue;
                if (savedInfo.second == info) {
                    this.mOrderResult.remove(packageName);
                    if (this.mOrderResult.size() != 0) continue;
                    break;
                }
                results.remove(i);
                --resultSize;
                --i;
            }
        }
    }

    private static final class ServiceIntentResolver
    extends IntentResolver<PackageParser.ServiceIntentInfo, ResolveInfo> {
        private final ArrayMap<ComponentName, PackageParser.Service> mServices = new ArrayMap();
        private int mFlags;

        private ServiceIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, List<PackageParser.Service> packageServices, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageServices == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int servicesSize = packageServices.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(servicesSize);
            for (int i = 0; i < servicesSize; ++i) {
                ArrayList intentFilters = packageServices.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ServiceIntentInfo[] array2 = new PackageParser.ServiceIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        void addService(PackageParser.Service s) {
            this.mServices.put(s.getComponentName(), s);
            int intentsSize = s.intents.size();
            for (int j = 0; j < intentsSize; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w(ComponentResolver.TAG, "==> For Service " + s.info.name);
                }
                this.addFilter(intent);
            }
        }

        void removeService(PackageParser.Service s) {
            this.mServices.remove(s.getComponentName());
            int intentsSize = s.intents.size();
            for (int j = 0; j < intentsSize; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ServiceIntentInfo filter, List<ResolveInfo> dest) {
            ServiceInfo filterSi = filter.service.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ServiceInfo destAi = dest.get((int)i).serviceInfo;
                if (destAi.name != filterSi.name || destAi.packageName != filterSi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ServiceIntentInfo[] newArray(int size) {
            return new PackageParser.ServiceIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ServiceIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.service.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ServiceIntentInfo info) {
            return packageName.equals(info.service.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ServiceIntentInfo filter, int match, int userId) {
            boolean isInstantApp;
            if (!sUserManager.exists(userId)) {
                return null;
            }
            PackageParser.ServiceIntentInfo info = filter;
            if (!sPackageManagerInternal.isEnabledAndMatches(info.service.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Service service = info.service;
            PackageSetting ps = (PackageSetting)service.owner.mExtras;
            if (ps == null) {
                return null;
            }
            PackageUserState userState = ps.readUserState(userId);
            ServiceInfo si = PackageParser.generateServiceInfo(service, this.mFlags, userState, userId);
            if (si == null) {
                return null;
            }
            boolean matchVisibleToInstantApp = (this.mFlags & 0x1000000) != 0;
            boolean bl = isInstantApp = (this.mFlags & 0x800000) != 0;
            if (matchVisibleToInstantApp && !info.isVisibleToInstantApp() && !userState.instantApp) {
                return null;
            }
            if (!isInstantApp && userState.instantApp) {
                return null;
            }
            if (userState.instantApp && ps.isUpdateAvailable()) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.serviceInfo = si;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = service.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = res.serviceInfo.applicationInfo.isSystemApp();
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            results.sort(RESOLVE_PRIORITY_SORTER);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ServiceIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.service)));
            out.print(' ');
            filter.service.printComponentShortName(out);
            out.print(" filter ");
            out.print(Integer.toHexString(System.identityHashCode(filter)));
            if (filter.service.info.permission != null) {
                out.print(" permission ");
                out.println(filter.service.info.permission);
            } else {
                out.println();
            }
        }

        @Override
        protected Object filterToLabel(PackageParser.ServiceIntentInfo filter) {
            return filter.service;
        }

        @Override
        protected void dumpFilterLabel(PrintWriter out, String prefix, Object label, int count) {
            PackageParser.Service service = (PackageParser.Service)label;
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(service)));
            out.print(' ');
            service.printComponentShortName(out);
            if (count > 1) {
                out.print(" (");
                out.print(count);
                out.print(" filters)");
            }
            out.println();
        }
    }

    private static final class ProviderIntentResolver
    extends IntentResolver<PackageParser.ProviderIntentInfo, ResolveInfo> {
        private final ArrayMap<ComponentName, PackageParser.Provider> mProviders = new ArrayMap();
        private int mFlags;

        private ProviderIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, List<PackageParser.Provider> packageProviders, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageProviders == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int providersSize = packageProviders.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(providersSize);
            for (int i = 0; i < providersSize; ++i) {
                ArrayList intentFilters = packageProviders.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ProviderIntentInfo[] array2 = new PackageParser.ProviderIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        void addProvider(PackageParser.Provider p) {
            if (this.mProviders.containsKey(p.getComponentName())) {
                Slog.w(ComponentResolver.TAG, "Provider " + p.getComponentName() + " already defined; ignoring");
                return;
            }
            this.mProviders.put(p.getComponentName(), p);
            int intentsSize = p.intents.size();
            for (int j = 0; j < intentsSize; ++j) {
                PackageParser.ProviderIntentInfo intent = (PackageParser.ProviderIntentInfo)p.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w(ComponentResolver.TAG, "==> For Provider " + p.info.name);
                }
                this.addFilter(intent);
            }
        }

        void removeProvider(PackageParser.Provider p) {
            this.mProviders.remove(p.getComponentName());
            int intentsSize = p.intents.size();
            for (int j = 0; j < intentsSize; ++j) {
                PackageParser.ProviderIntentInfo intent = (PackageParser.ProviderIntentInfo)p.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ProviderIntentInfo filter, List<ResolveInfo> dest) {
            ProviderInfo filterPi = filter.provider.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ProviderInfo destPi = dest.get((int)i).providerInfo;
                if (destPi.name != filterPi.name || destPi.packageName != filterPi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ProviderIntentInfo[] newArray(int size) {
            return new PackageParser.ProviderIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ProviderIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.provider.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ProviderIntentInfo info) {
            return packageName.equals(info.provider.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ProviderIntentInfo filter, int match, int userId) {
            boolean isInstantApp;
            if (!sUserManager.exists(userId)) {
                return null;
            }
            PackageParser.ProviderIntentInfo info = filter;
            if (!sPackageManagerInternal.isEnabledAndMatches(info.provider.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Provider provider = info.provider;
            PackageSetting ps = (PackageSetting)provider.owner.mExtras;
            if (ps == null) {
                return null;
            }
            PackageUserState userState = ps.readUserState(userId);
            boolean matchVisibleToInstantApp = (this.mFlags & 0x1000000) != 0;
            boolean bl = isInstantApp = (this.mFlags & 0x800000) != 0;
            if (matchVisibleToInstantApp && !info.isVisibleToInstantApp() && !userState.instantApp) {
                return null;
            }
            if (!isInstantApp && userState.instantApp) {
                return null;
            }
            if (userState.instantApp && ps.isUpdateAvailable()) {
                return null;
            }
            ProviderInfo pi = PackageParser.generateProviderInfo(provider, this.mFlags, userState, userId);
            if (pi == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.providerInfo = pi;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = provider.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = res.providerInfo.applicationInfo.isSystemApp();
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            results.sort(RESOLVE_PRIORITY_SORTER);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ProviderIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.provider)));
            out.print(' ');
            filter.provider.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }

        @Override
        protected Object filterToLabel(PackageParser.ProviderIntentInfo filter) {
            return filter.provider;
        }

        @Override
        protected void dumpFilterLabel(PrintWriter out, String prefix, Object label, int count) {
            PackageParser.Provider provider = (PackageParser.Provider)label;
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(provider)));
            out.print(' ');
            provider.printComponentShortName(out);
            if (count > 1) {
                out.print(" (");
                out.print(count);
                out.print(" filters)");
            }
            out.println();
        }
    }

    private static final class ActivityIntentResolver
    extends IntentResolver<PackageParser.ActivityIntentInfo, ResolveInfo> {
        private final ArrayMap<ComponentName, PackageParser.Activity> mActivities = new ArrayMap();
        private int mFlags;

        private ActivityIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, List<PackageParser.Activity> packageActivities, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageActivities == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int activitiesSize = packageActivities.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(activitiesSize);
            for (int i = 0; i < activitiesSize; ++i) {
                ArrayList intentFilters = packageActivities.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ActivityIntentInfo[] array2 = new PackageParser.ActivityIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        private void addActivity(PackageParser.Activity a, String type, List<PackageParser.ActivityIntentInfo> newIntents) {
            this.mActivities.put(a.getComponentName(), a);
            int intentsSize = a.intents.size();
            for (int j = 0; j < intentsSize; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                if (newIntents != null && "activity".equals(type)) {
                    newIntents.add(intent);
                }
                if (!intent.debugCheck()) {
                    Log.w(ComponentResolver.TAG, "==> For Activity " + a.info.name);
                }
                this.addFilter(intent);
            }
        }

        private void removeActivity(PackageParser.Activity a, String type) {
            this.mActivities.remove(a.getComponentName());
            int intentsSize = a.intents.size();
            for (int j = 0; j < intentsSize; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ActivityIntentInfo filter, List<ResolveInfo> dest) {
            ActivityInfo filterAi = filter.activity.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ActivityInfo destAi = dest.get((int)i).activityInfo;
                if (destAi.name != filterAi.name || destAi.packageName != filterAi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ActivityIntentInfo[] newArray(int size) {
            return new PackageParser.ActivityIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ActivityIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.activity.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ActivityIntentInfo info) {
            return packageName.equals(info.activity.owner.packageName);
        }

        private void log(String reason, PackageParser.ActivityIntentInfo info, int match, int userId) {
            Slog.w(ComponentResolver.TAG, reason + "; match: " + DebugUtils.flagsToString(IntentFilter.class, "MATCH_", match) + "; userId: " + userId + "; intent info: " + info);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ActivityIntentInfo info, int match, int userId) {
            boolean matchInstantApp;
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (!sPackageManagerInternal.isEnabledAndMatches(info.activity.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Activity activity = info.activity;
            PackageSetting ps = (PackageSetting)activity.owner.mExtras;
            if (ps == null) {
                return null;
            }
            PackageUserState userState = ps.readUserState(userId);
            ActivityInfo ai = PackageParser.generateActivityInfo(activity, this.mFlags, userState, userId);
            if (ai == null) {
                return null;
            }
            boolean matchExplicitlyVisibleOnly = (this.mFlags & 0x2000000) != 0;
            boolean matchVisibleToInstantApp = (this.mFlags & 0x1000000) != 0;
            boolean componentVisible = matchVisibleToInstantApp && info.isVisibleToInstantApp() && (!matchExplicitlyVisibleOnly || info.isExplicitlyVisibleToInstantApp());
            boolean bl = matchInstantApp = (this.mFlags & 0x800000) != 0;
            if (matchVisibleToInstantApp && !componentVisible && !userState.instantApp) {
                return null;
            }
            if (!matchInstantApp && userState.instantApp) {
                return null;
            }
            if (userState.instantApp && ps.isUpdateAvailable()) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.activityInfo = ai;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = info;
            }
            res.handleAllWebDataURI = info.handleAllWebDataURI();
            res.priority = info.getPriority();
            res.preferredOrder = activity.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            if (sPackageManagerInternal.userNeedsBadging(userId)) {
                res.noResourceId = true;
            } else {
                res.icon = info.icon;
            }
            res.iconResourceId = info.icon;
            res.system = res.activityInfo.applicationInfo.isSystemApp();
            res.isInstantAppAvailable = userState.instantApp;
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            results.sort(RESOLVE_PRIORITY_SORTER);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ActivityIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.activity)));
            out.print(' ');
            filter.activity.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }

        @Override
        protected Object filterToLabel(PackageParser.ActivityIntentInfo filter) {
            return filter.activity;
        }

        @Override
        protected void dumpFilterLabel(PrintWriter out, String prefix, Object label, int count) {
            PackageParser.Activity activity = (PackageParser.Activity)label;
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(activity)));
            out.print(' ');
            activity.printComponentShortName(out);
            if (count > 1) {
                out.print(" (");
                out.print(count);
                out.print(" filters)");
            }
            out.println();
        }
    }
}

