/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityOptions;
import android.app.AppOpsManager;
import android.app.IApplicationThread;
import android.app.admin.DevicePolicyEventLogger;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ICrossProfileApps;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.wm.ActivityTaskManagerInternal;
import java.util.ArrayList;
import java.util.List;

public class CrossProfileAppsServiceImpl
extends ICrossProfileApps.Stub {
    private static final String TAG = "CrossProfileAppsService";
    private Context mContext;
    private Injector mInjector;

    public CrossProfileAppsServiceImpl(Context context) {
        this(context, new InjectorImpl(context));
    }

    @VisibleForTesting
    CrossProfileAppsServiceImpl(Context context, Injector injector) {
        this.mContext = context;
        this.mInjector = injector;
    }

    @Override
    public List<UserHandle> getTargetUserProfiles(String callingPackage) {
        Preconditions.checkNotNull(callingPackage);
        this.verifyCallingPackage(callingPackage);
        DevicePolicyEventLogger.createEvent(125).setStrings(callingPackage).write();
        return this.getTargetUserProfilesUnchecked(callingPackage, this.mInjector.getCallingUserId());
    }

    @Override
    public void startActivityAsUser(IApplicationThread caller, String callingPackage, ComponentName component, int userId, boolean launchMainActivity) throws RemoteException {
        Preconditions.checkNotNull(callingPackage);
        Preconditions.checkNotNull(component);
        this.verifyCallingPackage(callingPackage);
        DevicePolicyEventLogger.createEvent(126).setStrings(callingPackage).write();
        int callerUserId = this.mInjector.getCallingUserId();
        int callingUid = this.mInjector.getCallingUid();
        List<UserHandle> allowedTargetUsers = this.getTargetUserProfilesUnchecked(callingPackage, callerUserId);
        if (!allowedTargetUsers.contains(UserHandle.of(userId))) {
            throw new SecurityException(callingPackage + " cannot access unrelated user " + userId);
        }
        if (!callingPackage.equals(component.getPackageName())) {
            throw new SecurityException(callingPackage + " attempts to start an activity in other package - " + component.getPackageName());
        }
        Intent launchIntent = new Intent();
        if (launchMainActivity) {
            launchIntent.setAction("android.intent.action.MAIN");
            launchIntent.addCategory("android.intent.category.LAUNCHER");
            launchIntent.addFlags(0x10200000);
            launchIntent.setPackage(component.getPackageName());
        } else {
            int permissionFlag;
            if (!(callerUserId == userId || (permissionFlag = ActivityManager.checkComponentPermission("android.permission.INTERACT_ACROSS_PROFILES", callingUid, -1, true)) == 0 && this.isSameProfileGroup(callerUserId, userId))) {
                throw new SecurityException("Attempt to launch activity without required android.permission.INTERACT_ACROSS_PROFILES permission or target user is not in the same profile group.");
            }
            launchIntent.setComponent(component);
        }
        this.verifyActivityCanHandleIntentAndExported(launchIntent, component, callingUid, userId);
        launchIntent.setPackage(null);
        launchIntent.setComponent(component);
        this.mInjector.getActivityTaskManagerInternal().startActivityAsUser(caller, callingPackage, launchIntent, launchMainActivity ? ActivityOptions.makeOpenCrossProfileAppsAnimation().toBundle() : null, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UserHandle> getTargetUserProfilesUnchecked(String callingPackage, int callingUserId) {
        long ident = this.mInjector.clearCallingIdentity();
        try {
            int[] enabledProfileIds = this.mInjector.getUserManager().getEnabledProfileIds(callingUserId);
            ArrayList<UserHandle> targetProfiles = new ArrayList<UserHandle>();
            for (int userId : enabledProfileIds) {
                if (userId == callingUserId || !this.isPackageEnabled(callingPackage, userId)) continue;
                targetProfiles.add(UserHandle.of(userId));
            }
            ArrayList<UserHandle> arrayList = targetProfiles;
            return arrayList;
        }
        finally {
            this.mInjector.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPackageEnabled(String packageName, int userId) {
        int callingUid = this.mInjector.getCallingUid();
        long ident = this.mInjector.clearCallingIdentity();
        try {
            PackageInfo info = this.mInjector.getPackageManagerInternal().getPackageInfo(packageName, 786432, callingUid, userId);
            boolean bl = info != null && info.applicationInfo.enabled;
            return bl;
        }
        finally {
            this.mInjector.restoreCallingIdentity(ident);
        }
    }

    private void verifyActivityCanHandleIntentAndExported(Intent launchIntent, ComponentName component, int callingUid, int userId) {
        long ident = this.mInjector.clearCallingIdentity();
        try {
            List<ResolveInfo> apps = this.mInjector.getPackageManagerInternal().queryIntentActivities(launchIntent, 786432, callingUid, userId);
            int size = apps.size();
            for (int i = 0; i < size; ++i) {
                ActivityInfo activityInfo = apps.get((int)i).activityInfo;
                if (!TextUtils.equals(activityInfo.packageName, component.getPackageName()) || !TextUtils.equals(activityInfo.name, component.getClassName()) || !activityInfo.exported) continue;
                return;
            }
            throw new SecurityException("Attempt to launch activity without  category Intent.CATEGORY_LAUNCHER or activity is not exported" + component);
        }
        finally {
            this.mInjector.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSameProfileGroup(int callerUserId, int userId) {
        long ident = this.mInjector.clearCallingIdentity();
        try {
            boolean bl = this.mInjector.getUserManager().isSameProfileGroup(callerUserId, userId);
            return bl;
        }
        finally {
            this.mInjector.restoreCallingIdentity(ident);
        }
    }

    private void verifyCallingPackage(String callingPackage) {
        this.mInjector.getAppOpsManager().checkPackage(this.mInjector.getCallingUid(), callingPackage);
    }

    @VisibleForTesting
    public static interface Injector {
        public int getCallingUid();

        public int getCallingUserId();

        public UserHandle getCallingUserHandle();

        public long clearCallingIdentity();

        public void restoreCallingIdentity(long var1);

        public UserManager getUserManager();

        public PackageManagerInternal getPackageManagerInternal();

        public PackageManager getPackageManager();

        public AppOpsManager getAppOpsManager();

        public ActivityManagerInternal getActivityManagerInternal();

        public ActivityTaskManagerInternal getActivityTaskManagerInternal();
    }

    private static class InjectorImpl
    implements Injector {
        private Context mContext;

        public InjectorImpl(Context context) {
            this.mContext = context;
        }

        @Override
        public int getCallingUid() {
            return Binder.getCallingUid();
        }

        @Override
        public int getCallingUserId() {
            return UserHandle.getCallingUserId();
        }

        @Override
        public UserHandle getCallingUserHandle() {
            return Binder.getCallingUserHandle();
        }

        @Override
        public long clearCallingIdentity() {
            return Binder.clearCallingIdentity();
        }

        @Override
        public void restoreCallingIdentity(long token) {
            Binder.restoreCallingIdentity(token);
        }

        @Override
        public UserManager getUserManager() {
            return this.mContext.getSystemService(UserManager.class);
        }

        @Override
        public PackageManagerInternal getPackageManagerInternal() {
            return LocalServices.getService(PackageManagerInternal.class);
        }

        @Override
        public PackageManager getPackageManager() {
            return this.mContext.getPackageManager();
        }

        @Override
        public AppOpsManager getAppOpsManager() {
            return this.mContext.getSystemService(AppOpsManager.class);
        }

        @Override
        public ActivityManagerInternal getActivityManagerInternal() {
            return LocalServices.getService(ActivityManagerInternal.class);
        }

        @Override
        public ActivityTaskManagerInternal getActivityTaskManagerInternal() {
            return LocalServices.getService(ActivityTaskManagerInternal.class);
        }
    }
}

