/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.Process;
import android.os.ServiceManager;
import android.util.ByteStringUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.dex.DynamicCodeLogger;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynamicCodeLoggingService
extends JobService {
    private static final String TAG = DynamicCodeLoggingService.class.getName();
    private static final boolean DEBUG = false;
    private static final int IDLE_LOGGING_JOB_ID = 2030028;
    private static final int AUDIT_WATCHING_JOB_ID = 203142925;
    private static final long IDLE_LOGGING_PERIOD_MILLIS = TimeUnit.DAYS.toMillis(1L);
    private static final long AUDIT_WATCHING_PERIOD_MILLIS = TimeUnit.HOURS.toMillis(2L);
    private static final int AUDIT_AVC = 1400;
    private static final String AVC_PREFIX = "type=1400 ";
    private static final Pattern EXECUTE_NATIVE_AUDIT_PATTERN = Pattern.compile(".*\\bavc: granted \\{ execute(?:_no_trans|) \\} .*\\bpath=(?:\"([^\" ]*)\"|([0-9A-F]+)) .*\\bscontext=u:r:untrusted_app(?:_25|_27)?:.*\\btcontext=u:object_r:app_data_file:.*\\btclass=file\\b.*");
    private volatile boolean mIdleLoggingStopRequested = false;
    private volatile boolean mAuditWatchingStopRequested = false;

    public static void schedule(Context context) {
        ComponentName serviceName = new ComponentName("android", DynamicCodeLoggingService.class.getName());
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        js.schedule(new JobInfo.Builder(2030028, serviceName).setRequiresDeviceIdle(true).setRequiresCharging(true).setPeriodic(IDLE_LOGGING_PERIOD_MILLIS).build());
        js.schedule(new JobInfo.Builder(203142925, serviceName).setRequiresDeviceIdle(true).setRequiresBatteryNotLow(true).setPeriodic(AUDIT_WATCHING_PERIOD_MILLIS).build());
    }

    @Override
    public boolean onStartJob(JobParameters params) {
        int jobId = params.getJobId();
        switch (jobId) {
            case 2030028: {
                this.mIdleLoggingStopRequested = false;
                new IdleLoggingThread(params).start();
                return true;
            }
            case 203142925: {
                this.mAuditWatchingStopRequested = false;
                new AuditWatchingThread(params).start();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        int jobId = params.getJobId();
        switch (jobId) {
            case 2030028: {
                this.mIdleLoggingStopRequested = true;
                return true;
            }
            case 203142925: {
                this.mAuditWatchingStopRequested = true;
                return true;
            }
        }
        return false;
    }

    private static DynamicCodeLogger getDynamicCodeLogger() {
        PackageManagerService pm = (PackageManagerService)ServiceManager.getService("package");
        return pm.getDexManager().getDynamicCodeLogger();
    }

    private static String unhex(String hexEncodedPath) {
        byte[] bytes = ByteStringUtils.fromHexToByteArray(hexEncodedPath);
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        return new String(bytes);
    }

    private class AuditWatchingThread
    extends Thread {
        private final JobParameters mParams;

        AuditWatchingThread(JobParameters params) {
            super("DynamicCodeLoggingService_AuditWatchingJob");
            this.mParams = params;
        }

        @Override
        public void run() {
            if (this.processAuditEvents()) {
                DynamicCodeLoggingService.this.jobFinished(this.mParams, false);
            }
        }

        private boolean processAuditEvents() {
            try {
                int[] tags = new int[]{EventLog.getTagCode("auditd")};
                if (tags[0] == -1) {
                    return true;
                }
                DynamicCodeLogger dynamicCodeLogger = DynamicCodeLoggingService.getDynamicCodeLogger();
                ArrayList<EventLog.Event> events = new ArrayList<EventLog.Event>();
                EventLog.readEvents(tags, events);
                for (int i = 0; i < events.size(); ++i) {
                    Matcher matcher;
                    String message;
                    Object data;
                    if (DynamicCodeLoggingService.this.mAuditWatchingStopRequested) {
                        Log.w(TAG, "Stopping AuditWatchingJob run at scheduler request");
                        return false;
                    }
                    EventLog.Event event = (EventLog.Event)events.get(i);
                    int uid = event.getUid();
                    if (!Process.isApplicationUid(uid) || !((data = event.getData()) instanceof String) || !(message = (String)data).startsWith(DynamicCodeLoggingService.AVC_PREFIX) || !(matcher = EXECUTE_NATIVE_AUDIT_PATTERN.matcher(message)).matches()) continue;
                    String path = matcher.group(1);
                    if (path == null) {
                        path = DynamicCodeLoggingService.unhex(matcher.group(2));
                    }
                    dynamicCodeLogger.recordNative(uid, path);
                }
                return true;
            }
            catch (Exception e) {
                Log.e(TAG, "AuditWatchingJob failed", e);
                return true;
            }
        }
    }

    private class IdleLoggingThread
    extends Thread {
        private final JobParameters mParams;

        IdleLoggingThread(JobParameters params) {
            super("DynamicCodeLoggingService_IdleLoggingJob");
            this.mParams = params;
        }

        @Override
        public void run() {
            DynamicCodeLogger dynamicCodeLogger = DynamicCodeLoggingService.getDynamicCodeLogger();
            for (String packageName : dynamicCodeLogger.getAllPackagesWithDynamicCodeLoading()) {
                if (DynamicCodeLoggingService.this.mIdleLoggingStopRequested) {
                    Log.w(TAG, "Stopping IdleLoggingJob run at scheduler request");
                    return;
                }
                dynamicCodeLogger.logDynamicCodeLoading(packageName);
            }
            DynamicCodeLoggingService.this.jobFinished(this.mParams, false);
        }
    }
}

