/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.IInstantAppResolver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.InstantAppResolveInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Slog;
import android.util.TimedRemoteCaller;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;

final class InstantAppResolverConnection
implements IBinder.DeathRecipient {
    private static final String TAG = "PackageManager";
    private static final long BIND_SERVICE_TIMEOUT_MS = Build.IS_ENG ? 500L : 300L;
    private static final long CALL_SERVICE_TIMEOUT_MS = Build.IS_ENG ? 200L : 100L;
    private static final boolean DEBUG_INSTANT = Build.IS_DEBUGGABLE;
    private final Object mLock = new Object();
    private final GetInstantAppResolveInfoCaller mGetInstantAppResolveInfoCaller = new GetInstantAppResolveInfoCaller();
    private final ServiceConnection mServiceConnection = new MyServiceConnection();
    private final Context mContext;
    private final Intent mIntent;
    private static final int STATE_IDLE = 0;
    private static final int STATE_BINDING = 1;
    private static final int STATE_PENDING = 2;
    private final Handler mBgHandler;
    @GuardedBy(value={"mLock"})
    private int mBindState = 0;
    @GuardedBy(value={"mLock"})
    private IInstantAppResolver mRemoteInstance;

    public InstantAppResolverConnection(Context context, ComponentName componentName, String action) {
        this.mContext = context;
        this.mIntent = new Intent(action).setComponent(componentName);
        this.mBgHandler = BackgroundThread.getHandler();
    }

    /*
     * Exception decompiling
     */
    public List<InstantAppResolveInfo> getInstantAppResolveInfoList(Intent sanitizedIntent, int[] hashPrefix, int userId, String token) throws ConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void getInstantAppIntentFilterList(Intent sanitizedIntent, int[] hashPrefix, int userId, String token, final PhaseTwoCallback callback, final Handler callbackHandler, final long startTime) throws ConnectionException {
        IRemoteCallback.Stub remoteCallback = new IRemoteCallback.Stub(){

            @Override
            public void sendResult(Bundle data) throws RemoteException {
                ArrayList resolveList = data.getParcelableArrayList("android.app.extra.RESOLVE_INFO");
                callbackHandler.post(() -> callback.onPhaseTwoResolved(resolveList, startTime));
            }
        };
        try {
            this.getRemoteInstanceLazy(token).getInstantAppIntentFilterList(sanitizedIntent, hashPrefix, userId, token, remoteCallback);
        }
        catch (TimeoutException e) {
            throw new ConnectionException(1);
        }
        catch (InterruptedException e) {
            throw new ConnectionException(3);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IInstantAppResolver getRemoteInstanceLazy(String token) throws ConnectionException, TimeoutException, InterruptedException {
        long binderToken = Binder.clearCallingIdentity();
        try {
            IInstantAppResolver iInstantAppResolver = this.bind(token);
            return iInstantAppResolver;
        }
        finally {
            Binder.restoreCallingIdentity(binderToken);
        }
    }

    @GuardedBy(value={"mLock"})
    private void waitForBindLocked(String token) throws TimeoutException, InterruptedException {
        long startMillis = SystemClock.uptimeMillis();
        while (this.mBindState != 0 && this.mRemoteInstance == null) {
            long elapsedMillis = SystemClock.uptimeMillis() - startMillis;
            long remainingMillis = BIND_SERVICE_TIMEOUT_MS - elapsedMillis;
            if (remainingMillis <= 0L) {
                throw new TimeoutException("[" + token + "] Didn't bind to resolver in time!");
            }
            this.mLock.wait(remainingMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IInstantAppResolver bind(String token) throws ConnectionException, TimeoutException, InterruptedException {
        boolean doUnbind = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRemoteInstance != null) {
                return this.mRemoteInstance;
            }
            if (this.mBindState == 2) {
                if (DEBUG_INSTANT) {
                    Slog.i(TAG, "[" + token + "] Previous bind timed out; waiting for connection");
                }
                try {
                    this.waitForBindLocked(token);
                    if (this.mRemoteInstance != null) {
                        return this.mRemoteInstance;
                    }
                }
                catch (TimeoutException e) {
                    doUnbind = true;
                }
            }
            if (this.mBindState == 1) {
                if (DEBUG_INSTANT) {
                    Slog.i(TAG, "[" + token + "] Another thread is binding; waiting for connection");
                }
                this.waitForBindLocked(token);
                if (this.mRemoteInstance != null) {
                    return this.mRemoteInstance;
                }
                throw new ConnectionException(1);
            }
            this.mBindState = 1;
        }
        boolean wasBound = false;
        IInstantAppResolver instance = null;
        if (doUnbind) {
            if (DEBUG_INSTANT) {
                Slog.i(TAG, "[" + token + "] Previous connection never established; rebinding");
            }
            this.mContext.unbindService(this.mServiceConnection);
        }
        if (DEBUG_INSTANT) {
            Slog.v(TAG, "[" + token + "] Binding to instant app resolver");
        }
        int flags = 0x4000001;
        wasBound = this.mContext.bindServiceAsUser(this.mIntent, this.mServiceConnection, 0x4000001, UserHandle.SYSTEM);
        if (wasBound) {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.waitForBindLocked(token);
                IInstantAppResolver iInstantAppResolver = instance = this.mRemoteInstance;
                return iInstantAppResolver;
            }
        }
        Slog.w(TAG, "[" + token + "] Failed to bind to: " + this.mIntent);
        throw new ConnectionException(1);
        finally {
            Object object3 = this.mLock;
            synchronized (object3) {
                this.mBindState = wasBound && instance == null ? 2 : 0;
                this.mLock.notifyAll();
            }
        }
    }

    private void throwIfCalledOnMainThread() {
        if (Thread.currentThread() == this.mContext.getMainLooper().getThread()) {
            throw new RuntimeException("Cannot invoke on the main thread");
        }
    }

    void optimisticBind() {
        this.mBgHandler.post(() -> {
            try {
                if (this.bind("Optimistic Bind") != null && DEBUG_INSTANT) {
                    Slog.i(TAG, "Optimistic bind succeeded.");
                }
            }
            catch (ConnectionException | InterruptedException | TimeoutException e) {
                Slog.e(TAG, "Optimistic bind failed.", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binderDied() {
        if (DEBUG_INSTANT) {
            Slog.d(TAG, "Binder to instant app resolver died");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.handleBinderDiedLocked();
        }
        this.optimisticBind();
    }

    @GuardedBy(value={"mLock"})
    private void handleBinderDiedLocked() {
        if (this.mRemoteInstance != null) {
            try {
                this.mRemoteInstance.asBinder().unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        this.mRemoteInstance = null;
    }

    private static final class GetInstantAppResolveInfoCaller
    extends TimedRemoteCaller<List<InstantAppResolveInfo>> {
        private final IRemoteCallback mCallback = new IRemoteCallback.Stub(){

            @Override
            public void sendResult(Bundle data) throws RemoteException {
                ArrayList resolveList = data.getParcelableArrayList("android.app.extra.RESOLVE_INFO");
                int sequence = data.getInt("android.app.extra.SEQUENCE", -1);
                this.onRemoteMethodResult(resolveList, sequence);
            }
        };

        public GetInstantAppResolveInfoCaller() {
            super(CALL_SERVICE_TIMEOUT_MS);
        }

        public List<InstantAppResolveInfo> getInstantAppResolveInfoList(IInstantAppResolver target, Intent sanitizedIntent, int[] hashPrefix, int userId, String token) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            target.getInstantAppResolveInfoList(sanitizedIntent, hashPrefix, userId, token, sequence, this.mCallback);
            return (List)this.getResultTimed(sequence);
        }
    }

    private final class MyServiceConnection
    implements ServiceConnection {
        private MyServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            if (DEBUG_INSTANT) {
                Slog.d(InstantAppResolverConnection.TAG, "Connected to instant app resolver");
            }
            Object object = InstantAppResolverConnection.this.mLock;
            synchronized (object) {
                InstantAppResolverConnection.this.mRemoteInstance = IInstantAppResolver.Stub.asInterface(service);
                if (InstantAppResolverConnection.this.mBindState == 2) {
                    InstantAppResolverConnection.this.mBindState = 0;
                }
                try {
                    service.linkToDeath(InstantAppResolverConnection.this, 0);
                }
                catch (RemoteException e) {
                    InstantAppResolverConnection.this.handleBinderDiedLocked();
                }
                InstantAppResolverConnection.this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            if (DEBUG_INSTANT) {
                Slog.d(InstantAppResolverConnection.TAG, "Disconnected from instant app resolver");
            }
            Object object = InstantAppResolverConnection.this.mLock;
            synchronized (object) {
                InstantAppResolverConnection.this.handleBinderDiedLocked();
            }
        }
    }

    public static class ConnectionException
    extends Exception {
        public static final int FAILURE_BIND = 1;
        public static final int FAILURE_CALL = 2;
        public static final int FAILURE_INTERRUPTED = 3;
        public final int failure;

        public ConnectionException(int _failure) {
            this.failure = _failure;
        }
    }

    public static abstract class PhaseTwoCallback {
        abstract void onPhaseTwoResolved(List<InstantAppResolveInfo> var1, long var2);
    }
}

