/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.IApplicationThread;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManager;
import android.app.usage.UsageStatsManagerInternal;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ILauncherApps;
import android.content.pm.IOnAppsChangedListener;
import android.content.pm.IPackageInstallerCallback;
import android.content.pm.LauncherApps;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutServiceInternal;
import android.content.pm.UserInfo;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IInterface;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.provider.Settings;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.pm.PackageInstallerService;
import com.android.server.pm.PackageManagerService;
import com.android.server.wm.ActivityTaskManagerInternal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class LauncherAppsService
extends SystemService {
    private final LauncherAppsImpl mLauncherAppsImpl;

    public LauncherAppsService(Context context) {
        super(context);
        this.mLauncherAppsImpl = new LauncherAppsImpl(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("launcherapps", this.mLauncherAppsImpl);
    }

    @VisibleForTesting
    static class LauncherAppsImpl
    extends ILauncherApps.Stub {
        private static final boolean DEBUG = false;
        private static final String TAG = "LauncherAppsService";
        private final Context mContext;
        private final UserManager mUm;
        private final UserManagerInternal mUserManagerInternal;
        private final UsageStatsManagerInternal mUsageStatsManagerInternal;
        private final ActivityManagerInternal mActivityManagerInternal;
        private final ActivityTaskManagerInternal mActivityTaskManagerInternal;
        private final ShortcutServiceInternal mShortcutServiceInternal;
        private final PackageCallbackList<IOnAppsChangedListener> mListeners = new PackageCallbackList();
        private final DevicePolicyManager mDpm;
        private final MyPackageMonitor mPackageMonitor = new MyPackageMonitor();
        private final Handler mCallbackHandler;
        private PackageInstallerService mPackageInstallerService;

        public LauncherAppsImpl(Context context) {
            this.mContext = context;
            this.mUm = (UserManager)this.mContext.getSystemService("user");
            this.mUserManagerInternal = Preconditions.checkNotNull(LocalServices.getService(UserManagerInternal.class));
            this.mUsageStatsManagerInternal = Preconditions.checkNotNull(LocalServices.getService(UsageStatsManagerInternal.class));
            this.mActivityManagerInternal = Preconditions.checkNotNull(LocalServices.getService(ActivityManagerInternal.class));
            this.mActivityTaskManagerInternal = Preconditions.checkNotNull(LocalServices.getService(ActivityTaskManagerInternal.class));
            this.mShortcutServiceInternal = Preconditions.checkNotNull(LocalServices.getService(ShortcutServiceInternal.class));
            this.mShortcutServiceInternal.addListener(this.mPackageMonitor);
            this.mCallbackHandler = BackgroundThread.getHandler();
            this.mDpm = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        }

        @VisibleForTesting
        int injectBinderCallingUid() {
            return LauncherAppsImpl.getCallingUid();
        }

        @VisibleForTesting
        int injectBinderCallingPid() {
            return LauncherAppsImpl.getCallingPid();
        }

        final int injectCallingUserId() {
            return UserHandle.getUserId(this.injectBinderCallingUid());
        }

        @VisibleForTesting
        long injectClearCallingIdentity() {
            return Binder.clearCallingIdentity();
        }

        @VisibleForTesting
        void injectRestoreCallingIdentity(long token) {
            Binder.restoreCallingIdentity(token);
        }

        private int getCallingUserId() {
            return UserHandle.getUserId(this.injectBinderCallingUid());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOnAppsChangedListener(String callingPackage, IOnAppsChangedListener listener) throws RemoteException {
            this.verifyCallingPackage(callingPackage);
            PackageCallbackList<IOnAppsChangedListener> packageCallbackList = this.mListeners;
            synchronized (packageCallbackList) {
                if (this.mListeners.getRegisteredCallbackCount() == 0) {
                    this.startWatchingPackageBroadcasts();
                }
                this.mListeners.unregister(listener);
                this.mListeners.register(listener, new BroadcastCookie(UserHandle.of(this.getCallingUserId()), callingPackage, this.injectBinderCallingPid(), this.injectBinderCallingUid()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeOnAppsChangedListener(IOnAppsChangedListener listener) throws RemoteException {
            PackageCallbackList<IOnAppsChangedListener> packageCallbackList = this.mListeners;
            synchronized (packageCallbackList) {
                this.mListeners.unregister(listener);
                if (this.mListeners.getRegisteredCallbackCount() == 0) {
                    this.stopWatchingPackageBroadcasts();
                }
            }
        }

        @Override
        public void registerPackageInstallerCallback(String callingPackage, IPackageInstallerCallback callback) {
            this.verifyCallingPackage(callingPackage);
            UserHandle callingIdUserHandle = new UserHandle(this.getCallingUserId());
            this.getPackageInstallerService().registerCallback(callback, eventUserId -> this.isEnabledProfileOf(callingIdUserHandle, new UserHandle(eventUserId), "shouldReceiveEvent"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<PackageInstaller.SessionInfo> getAllSessions(String callingPackage) {
            this.verifyCallingPackage(callingPackage);
            ArrayList sessionInfos = new ArrayList();
            int[] userIds = this.mUm.getEnabledProfileIds(this.getCallingUserId());
            long token = Binder.clearCallingIdentity();
            try {
                for (int userId : userIds) {
                    sessionInfos.addAll(this.getPackageInstallerService().getAllSessions(userId).getList());
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return new ParceledListSlice<PackageInstaller.SessionInfo>(sessionInfos);
        }

        private PackageInstallerService getPackageInstallerService() {
            if (this.mPackageInstallerService == null) {
                this.mPackageInstallerService = (PackageInstallerService)((PackageManagerService)ServiceManager.getService("package")).getPackageInstaller();
            }
            return this.mPackageInstallerService;
        }

        private void startWatchingPackageBroadcasts() {
            this.mPackageMonitor.register(this.mContext, UserHandle.ALL, true, this.mCallbackHandler);
        }

        private void stopWatchingPackageBroadcasts() {
            this.mPackageMonitor.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkCallbackCount() {
            PackageCallbackList<IOnAppsChangedListener> packageCallbackList = this.mListeners;
            synchronized (packageCallbackList) {
                if (this.mListeners.getRegisteredCallbackCount() == 0) {
                    this.stopWatchingPackageBroadcasts();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean canAccessProfile(int targetUserId, String message) {
            int callingUserId = this.injectCallingUserId();
            if (targetUserId == callingUserId) {
                return true;
            }
            long ident = this.injectClearCallingIdentity();
            try {
                UserInfo callingUserInfo = this.mUm.getUserInfo(callingUserId);
                if (callingUserInfo != null && callingUserInfo.isManagedProfile()) {
                    Slog.w(TAG, message + " for another profile " + targetUserId + " from " + callingUserId + " not allowed");
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.injectRestoreCallingIdentity(ident);
            }
            return this.mUserManagerInternal.isProfileAccessible(this.injectCallingUserId(), targetUserId, message, true);
        }

        @VisibleForTesting
        void verifyCallingPackage(String callingPackage) {
            int packageUid = -1;
            try {
                packageUid = AppGlobals.getPackageManager().getPackageUid(callingPackage, 794624, UserHandle.getUserId(LauncherAppsImpl.getCallingUid()));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (packageUid < 0) {
                Log.e(TAG, "Package not found: " + callingPackage);
            }
            if (packageUid != this.injectBinderCallingUid()) {
                throw new SecurityException("Calling package name mismatch");
            }
        }

        private ResolveInfo getHiddenAppActivityInfo(String packageName, int callingUid, UserHandle user) {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName(packageName, PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME));
            PackageManagerInternal pmInt = LocalServices.getService(PackageManagerInternal.class);
            List<ResolveInfo> apps = pmInt.queryIntentActivities(intent, 786432, callingUid, user.getIdentifier());
            if (apps.size() > 0) {
                return apps.get(0);
            }
            return null;
        }

        @Override
        public boolean shouldHideFromSuggestions(String packageName, UserHandle user) {
            if (!this.canAccessProfile(user.getIdentifier(), "cannot get shouldHideFromSuggestions")) {
                return false;
            }
            PackageManagerInternal pmi = LocalServices.getService(PackageManagerInternal.class);
            int flags = pmi.getDistractingPackageRestrictions(packageName, user.getIdentifier());
            return (flags & 1) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<ResolveInfo> getLauncherActivities(String callingPackage, String packageName, UserHandle user) throws RemoteException {
            ParceledListSlice<ResolveInfo> launcherActivities = this.queryActivitiesForUser(callingPackage, new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER").setPackage(packageName), user);
            if (Settings.Global.getInt(this.mContext.getContentResolver(), "show_hidden_icon_apps_enabled", 1) == 0) {
                return launcherActivities;
            }
            if (launcherActivities == null) {
                return null;
            }
            int callingUid = this.injectBinderCallingUid();
            long ident = this.injectClearCallingIdentity();
            try {
                if (this.mUm.getUserInfo(user.getIdentifier()).isManagedProfile()) {
                    ParceledListSlice<ResolveInfo> parceledListSlice = launcherActivities;
                    return parceledListSlice;
                }
                if (this.mDpm.getDeviceOwnerComponentOnAnyUser() != null) {
                    ParceledListSlice<ResolveInfo> parceledListSlice = launcherActivities;
                    return parceledListSlice;
                }
                ArrayList<Parcelable> result = new ArrayList<Parcelable>(launcherActivities.getList());
                PackageManagerInternal pmInt = LocalServices.getService(PackageManagerInternal.class);
                if (packageName != null) {
                    ParceledListSlice<ResolveInfo> info;
                    if (result.size() > 0) {
                        ParceledListSlice<ResolveInfo> parceledListSlice = launcherActivities;
                        return parceledListSlice;
                    }
                    ApplicationInfo appInfo = pmInt.getApplicationInfo(packageName, 0, callingUid, user.getIdentifier());
                    if (this.shouldShowSyntheticActivity(user, appInfo) && (info = this.getHiddenAppActivityInfo(packageName, callingUid, user)) != null) {
                        result.add(info);
                    }
                    info = new ParceledListSlice(result);
                    return info;
                }
                HashSet<String> visiblePackages = new HashSet<String>();
                for (ResolveInfo parceledListSlice : result) {
                    visiblePackages.add(parceledListSlice.activityInfo.packageName);
                }
                List<ApplicationInfo> installedPackages = pmInt.getInstalledApplications(0, user.getIdentifier(), callingUid);
                for (ApplicationInfo applicationInfo : installedPackages) {
                    ResolveInfo info;
                    if (visiblePackages.contains(applicationInfo.packageName) || !this.shouldShowSyntheticActivity(user, applicationInfo) || (info = this.getHiddenAppActivityInfo(applicationInfo.packageName, callingUid, user)) == null) continue;
                    result.add(info);
                }
                ParceledListSlice<ResolveInfo> parceledListSlice = new ParceledListSlice<ResolveInfo>(result);
                return parceledListSlice;
            }
            finally {
                this.injectRestoreCallingIdentity(ident);
            }
        }

        private boolean shouldShowSyntheticActivity(UserHandle user, ApplicationInfo appInfo) {
            if (appInfo == null || appInfo.isSystemApp() || appInfo.isUpdatedSystemApp()) {
                return false;
            }
            if (this.isManagedProfileAdmin(user, appInfo.packageName)) {
                return false;
            }
            return this.hasComponentsAndRequestsPermissions(appInfo.packageName);
        }

        private boolean hasComponentsAndRequestsPermissions(String packageName) {
            PackageManagerInternal pmInt = LocalServices.getService(PackageManagerInternal.class);
            PackageParser.Package pkg = pmInt.getPackage(packageName);
            if (pkg == null) {
                return false;
            }
            if (ArrayUtils.isEmpty(pkg.requestedPermissions)) {
                return false;
            }
            return this.hasApplicationDeclaredActivities(pkg) || !ArrayUtils.isEmpty(pkg.receivers) || !ArrayUtils.isEmpty(pkg.providers) || !ArrayUtils.isEmpty(pkg.services);
        }

        private boolean hasApplicationDeclaredActivities(PackageParser.Package pkg) {
            if (pkg.activities == null) {
                return false;
            }
            if (ArrayUtils.isEmpty(pkg.activities)) {
                return false;
            }
            return pkg.activities.size() != 1 || !PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME.equals(pkg.activities.get((int)0).className);
        }

        private boolean isManagedProfileAdmin(UserHandle user, String packageName) {
            List<UserInfo> userInfoList = this.mUm.getProfiles(user.getIdentifier());
            for (int i = 0; i < userInfoList.size(); ++i) {
                ComponentName componentName;
                UserInfo userInfo = userInfoList.get(i);
                if (!userInfo.isManagedProfile() || (componentName = this.mDpm.getProfileOwnerAsUser(userInfo.getUserHandle())) == null || !componentName.getPackageName().equals(packageName)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActivityInfo resolveActivity(String callingPackage, ComponentName component, UserHandle user) throws RemoteException {
            if (!this.canAccessProfile(user.getIdentifier(), "Cannot resolve activity")) {
                return null;
            }
            int callingUid = this.injectBinderCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PackageManagerInternal pmInt = LocalServices.getService(PackageManagerInternal.class);
                ActivityInfo activityInfo = pmInt.getActivityInfo(component, 786432, callingUid, user.getIdentifier());
                return activityInfo;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public ParceledListSlice getShortcutConfigActivities(String callingPackage, String packageName, UserHandle user) throws RemoteException {
            return this.queryActivitiesForUser(callingPackage, new Intent("android.intent.action.CREATE_SHORTCUT").setPackage(packageName), user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ParceledListSlice<ResolveInfo> queryActivitiesForUser(String callingPackage, Intent intent, UserHandle user) {
            if (!this.canAccessProfile(user.getIdentifier(), "Cannot retrieve activities")) {
                return null;
            }
            int callingUid = this.injectBinderCallingUid();
            long ident = this.injectClearCallingIdentity();
            try {
                PackageManagerInternal pmInt = LocalServices.getService(PackageManagerInternal.class);
                List<ResolveInfo> apps = pmInt.queryIntentActivities(intent, 786432, callingUid, user.getIdentifier());
                ParceledListSlice<ResolveInfo> parceledListSlice = new ParceledListSlice<ResolveInfo>(apps);
                return parceledListSlice;
            }
            finally {
                this.injectRestoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IntentSender getShortcutConfigActivityIntent(String callingPackage, ComponentName component, UserHandle user) throws RemoteException {
            this.ensureShortcutPermission(callingPackage);
            if (!this.canAccessProfile(user.getIdentifier(), "Cannot check package")) {
                return null;
            }
            Preconditions.checkNotNull(component);
            Intent intent = new Intent("android.intent.action.CREATE_SHORTCUT").setComponent(component);
            long identity = Binder.clearCallingIdentity();
            try {
                PendingIntent pi = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x54000000, null, user);
                IntentSender intentSender = pi == null ? null : pi.getIntentSender();
                return intentSender;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPackageEnabled(String callingPackage, String packageName, UserHandle user) throws RemoteException {
            if (!this.canAccessProfile(user.getIdentifier(), "Cannot check package")) {
                return false;
            }
            int callingUid = this.injectBinderCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PackageManagerInternal pmInt = LocalServices.getService(PackageManagerInternal.class);
                PackageInfo info = pmInt.getPackageInfo(packageName, 786432, callingUid, user.getIdentifier());
                boolean bl = info != null && info.applicationInfo.enabled;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public Bundle getSuspendedPackageLauncherExtras(String packageName, UserHandle user) {
            if (!this.canAccessProfile(user.getIdentifier(), "Cannot get launcher extras")) {
                return null;
            }
            PackageManagerInternal pmi = LocalServices.getService(PackageManagerInternal.class);
            return pmi.getSuspendedPackageLauncherExtras(packageName, user.getIdentifier());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ApplicationInfo getApplicationInfo(String callingPackage, String packageName, int flags, UserHandle user) throws RemoteException {
            if (!this.canAccessProfile(user.getIdentifier(), "Cannot check package")) {
                return null;
            }
            int callingUid = this.injectBinderCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                ApplicationInfo info;
                PackageManagerInternal pmInt = LocalServices.getService(PackageManagerInternal.class);
                ApplicationInfo applicationInfo = info = pmInt.getApplicationInfo(packageName, flags, callingUid, user.getIdentifier());
                return applicationInfo;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public LauncherApps.AppUsageLimit getAppUsageLimit(String callingPackage, String packageName, UserHandle user) {
            this.verifyCallingPackage(callingPackage);
            if (!this.canAccessProfile(user.getIdentifier(), "Cannot access usage limit")) {
                return null;
            }
            if (!this.mActivityTaskManagerInternal.isCallerRecents(Binder.getCallingUid())) {
                throw new SecurityException("Caller is not the recents app");
            }
            UsageStatsManagerInternal.AppUsageLimitData data = this.mUsageStatsManagerInternal.getAppUsageLimit(packageName, user);
            if (data == null) {
                return null;
            }
            return new LauncherApps.AppUsageLimit(data.getTotalUsageLimit(), data.getUsageRemaining());
        }

        private void ensureShortcutPermission(String callingPackage) {
            this.verifyCallingPackage(callingPackage);
            if (!this.mShortcutServiceInternal.hasShortcutHostPermission(this.getCallingUserId(), callingPackage, this.injectBinderCallingPid(), this.injectBinderCallingUid())) {
                throw new SecurityException("Caller can't access shortcut information");
            }
        }

        @Override
        public ParceledListSlice getShortcuts(String callingPackage, long changedSince, String packageName, List shortcutIds, ComponentName componentName, int flags, UserHandle targetUser) {
            this.ensureShortcutPermission(callingPackage);
            if (!this.canAccessProfile(targetUser.getIdentifier(), "Cannot get shortcuts")) {
                return new ParceledListSlice(Collections.EMPTY_LIST);
            }
            if (shortcutIds != null && packageName == null) {
                throw new IllegalArgumentException("To query by shortcut ID, package name must also be set");
            }
            return new ParceledListSlice<ShortcutInfo>(this.mShortcutServiceInternal.getShortcuts(this.getCallingUserId(), callingPackage, changedSince, packageName, shortcutIds, componentName, flags, targetUser.getIdentifier(), this.injectBinderCallingPid(), this.injectBinderCallingUid()));
        }

        @Override
        public void pinShortcuts(String callingPackage, String packageName, List<String> ids, UserHandle targetUser) {
            this.ensureShortcutPermission(callingPackage);
            if (!this.canAccessProfile(targetUser.getIdentifier(), "Cannot pin shortcuts")) {
                return;
            }
            this.mShortcutServiceInternal.pinShortcuts(this.getCallingUserId(), callingPackage, packageName, ids, targetUser.getIdentifier());
        }

        @Override
        public int getShortcutIconResId(String callingPackage, String packageName, String id2, int targetUserId) {
            this.ensureShortcutPermission(callingPackage);
            if (!this.canAccessProfile(targetUserId, "Cannot access shortcuts")) {
                return 0;
            }
            return this.mShortcutServiceInternal.getShortcutIconResId(this.getCallingUserId(), callingPackage, packageName, id2, targetUserId);
        }

        @Override
        public ParcelFileDescriptor getShortcutIconFd(String callingPackage, String packageName, String id2, int targetUserId) {
            this.ensureShortcutPermission(callingPackage);
            if (!this.canAccessProfile(targetUserId, "Cannot access shortcuts")) {
                return null;
            }
            return this.mShortcutServiceInternal.getShortcutIconFd(this.getCallingUserId(), callingPackage, packageName, id2, targetUserId);
        }

        @Override
        public boolean hasShortcutHostPermission(String callingPackage) {
            this.verifyCallingPackage(callingPackage);
            return this.mShortcutServiceInternal.hasShortcutHostPermission(this.getCallingUserId(), callingPackage, this.injectBinderCallingPid(), this.injectBinderCallingUid());
        }

        @Override
        public boolean startShortcut(String callingPackage, String packageName, String shortcutId, Rect sourceBounds, Bundle startActivityOptions, int targetUserId) {
            Intent[] intents;
            this.verifyCallingPackage(callingPackage);
            if (!this.canAccessProfile(targetUserId, "Cannot start activity")) {
                return false;
            }
            if (!this.mShortcutServiceInternal.isPinnedByCaller(this.getCallingUserId(), callingPackage, packageName, shortcutId, targetUserId)) {
                this.ensureShortcutPermission(callingPackage);
            }
            if ((intents = this.mShortcutServiceInternal.createShortcutIntents(this.getCallingUserId(), callingPackage, packageName, shortcutId, targetUserId, this.injectBinderCallingPid(), this.injectBinderCallingUid())) == null || intents.length == 0) {
                return false;
            }
            intents[0].addFlags(0x10000000);
            intents[0].setSourceBounds(sourceBounds);
            return this.startShortcutIntentsAsPublisher(intents, packageName, startActivityOptions, targetUserId);
        }

        private boolean startShortcutIntentsAsPublisher(Intent[] intents, String publisherPackage, Bundle startActivityOptions, int userId) {
            try {
                int code = this.mActivityTaskManagerInternal.startActivitiesAsPackage(publisherPackage, userId, intents, startActivityOptions);
                if (ActivityManager.isStartResultSuccessful(code)) {
                    return true;
                }
                Log.e(TAG, "Couldn't start activity, code=" + code);
                return false;
            }
            catch (SecurityException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isActivityEnabled(String callingPackage, ComponentName component, UserHandle user) throws RemoteException {
            if (!this.canAccessProfile(user.getIdentifier(), "Cannot check component")) {
                return false;
            }
            int callingUid = this.injectBinderCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PackageManagerInternal pmInt = LocalServices.getService(PackageManagerInternal.class);
                ActivityInfo info = pmInt.getActivityInfo(component, 786432, callingUid, user.getIdentifier());
                boolean bl = info != null && info.isEnabled();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public void startSessionDetailsActivityAsUser(IApplicationThread caller, String callingPackage, PackageInstaller.SessionInfo sessionInfo, Rect sourceBounds, Bundle opts, UserHandle userHandle) throws RemoteException {
            int userId = userHandle.getIdentifier();
            if (!this.canAccessProfile(userId, "Cannot start details activity")) {
                return;
            }
            Intent i = new Intent("android.intent.action.VIEW").setData(new Uri.Builder().scheme("market").authority("details").appendQueryParameter("id", sessionInfo.appPackageName).build()).putExtra("android.intent.extra.REFERRER", new Uri.Builder().scheme("android-app").authority(callingPackage).build());
            i.setSourceBounds(sourceBounds);
            this.mActivityTaskManagerInternal.startActivityAsUser(caller, callingPackage, i, opts, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startActivityAsUser(IApplicationThread caller, String callingPackage, ComponentName component, Rect sourceBounds, Bundle opts, UserHandle user) throws RemoteException {
            if (!this.canAccessProfile(user.getIdentifier(), "Cannot start activity")) {
                return;
            }
            Intent launchIntent = new Intent("android.intent.action.MAIN");
            launchIntent.addCategory("android.intent.category.LAUNCHER");
            launchIntent.setSourceBounds(sourceBounds);
            launchIntent.addFlags(0x10200000);
            launchIntent.setPackage(component.getPackageName());
            boolean canLaunch = false;
            int callingUid = this.injectBinderCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PackageManagerInternal pmInt = LocalServices.getService(PackageManagerInternal.class);
                List<ResolveInfo> apps = pmInt.queryIntentActivities(launchIntent, 786432, callingUid, user.getIdentifier());
                int size = apps.size();
                for (int i = 0; i < size; ++i) {
                    ActivityInfo activityInfo = apps.get((int)i).activityInfo;
                    if (!activityInfo.packageName.equals(component.getPackageName()) || !activityInfo.name.equals(component.getClassName())) continue;
                    if (!activityInfo.exported) {
                        throw new SecurityException("Cannot launch non-exported components " + component);
                    }
                    launchIntent.setPackage(null);
                    launchIntent.setComponent(component);
                    canLaunch = true;
                    break;
                }
                if (!canLaunch) {
                    throw new SecurityException("Attempt to launch activity without  category Intent.CATEGORY_LAUNCHER " + component);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            this.mActivityTaskManagerInternal.startActivityAsUser(caller, callingPackage, launchIntent, opts, user.getIdentifier());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void showAppDetailsAsUser(IApplicationThread caller, String callingPackage, ComponentName component, Rect sourceBounds, Bundle opts, UserHandle user) throws RemoteException {
            Intent intent;
            if (!this.canAccessProfile(user.getIdentifier(), "Cannot show app details")) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                String packageName = component.getPackageName();
                intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts("package", packageName, null));
                intent.setFlags(0x10008000);
                intent.setSourceBounds(sourceBounds);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            this.mActivityTaskManagerInternal.startActivityAsUser(caller, callingPackage, intent, opts, user.getIdentifier());
        }

        private boolean isEnabledProfileOf(UserHandle listeningUser, UserHandle user, String debugMsg) {
            return this.mUserManagerInternal.isProfileAccessible(listeningUser.getIdentifier(), user.getIdentifier(), debugMsg, false);
        }

        @VisibleForTesting
        void postToPackageMonitorHandler(Runnable r) {
            this.mCallbackHandler.post(r);
        }

        class PackageCallbackList<T extends IInterface>
        extends RemoteCallbackList<T> {
            PackageCallbackList() {
            }

            @Override
            public void onCallbackDied(T callback, Object cookie) {
                LauncherAppsImpl.this.checkCallbackCount();
            }
        }

        private class MyPackageMonitor
        extends PackageMonitor
        implements ShortcutServiceInternal.ShortcutChangeListener {
            private MyPackageMonitor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageAdded(String packageName, int uid) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                try {
                    for (int i = 0; i < n; ++i) {
                        IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                        BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                        if (!LauncherAppsImpl.this.isEnabledProfileOf(cookie.user, user, "onPackageAdded")) continue;
                        try {
                            listener.onPackageAdded(user, packageName);
                            continue;
                        }
                        catch (RemoteException re) {
                            Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                        }
                    }
                }
                finally {
                    LauncherAppsImpl.this.mListeners.finishBroadcast();
                }
                super.onPackageAdded(packageName, uid);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageRemoved(String packageName, int uid) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                try {
                    for (int i = 0; i < n; ++i) {
                        IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                        BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                        if (!LauncherAppsImpl.this.isEnabledProfileOf(cookie.user, user, "onPackageRemoved")) continue;
                        try {
                            listener.onPackageRemoved(user, packageName);
                            continue;
                        }
                        catch (RemoteException re) {
                            Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                        }
                    }
                }
                finally {
                    LauncherAppsImpl.this.mListeners.finishBroadcast();
                }
                super.onPackageRemoved(packageName, uid);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageModified(String packageName) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                try {
                    for (int i = 0; i < n; ++i) {
                        IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                        BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                        if (!LauncherAppsImpl.this.isEnabledProfileOf(cookie.user, user, "onPackageModified")) continue;
                        try {
                            listener.onPackageChanged(user, packageName);
                            continue;
                        }
                        catch (RemoteException re) {
                            Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                        }
                    }
                }
                finally {
                    LauncherAppsImpl.this.mListeners.finishBroadcast();
                }
                super.onPackageModified(packageName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackagesAvailable(String[] packages) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                try {
                    for (int i = 0; i < n; ++i) {
                        IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                        BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                        if (!LauncherAppsImpl.this.isEnabledProfileOf(cookie.user, user, "onPackagesAvailable")) continue;
                        try {
                            listener.onPackagesAvailable(user, packages, this.isReplacing());
                            continue;
                        }
                        catch (RemoteException re) {
                            Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                        }
                    }
                }
                finally {
                    LauncherAppsImpl.this.mListeners.finishBroadcast();
                }
                super.onPackagesAvailable(packages);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackagesUnavailable(String[] packages) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                try {
                    for (int i = 0; i < n; ++i) {
                        IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                        BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                        if (!LauncherAppsImpl.this.isEnabledProfileOf(cookie.user, user, "onPackagesUnavailable")) continue;
                        try {
                            listener.onPackagesUnavailable(user, packages, this.isReplacing());
                            continue;
                        }
                        catch (RemoteException re) {
                            Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                        }
                    }
                }
                finally {
                    LauncherAppsImpl.this.mListeners.finishBroadcast();
                }
                super.onPackagesUnavailable(packages);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackagesSuspended(String[] packages, Bundle launcherExtras) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                try {
                    for (int i = 0; i < n; ++i) {
                        IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                        BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                        if (!LauncherAppsImpl.this.isEnabledProfileOf(cookie.user, user, "onPackagesSuspended")) continue;
                        try {
                            listener.onPackagesSuspended(user, packages, launcherExtras);
                            continue;
                        }
                        catch (RemoteException re) {
                            Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                        }
                    }
                }
                finally {
                    LauncherAppsImpl.this.mListeners.finishBroadcast();
                }
                super.onPackagesSuspended(packages, launcherExtras);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackagesUnsuspended(String[] packages) {
                UserHandle user = new UserHandle(this.getChangingUserId());
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                try {
                    for (int i = 0; i < n; ++i) {
                        IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                        BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                        if (!LauncherAppsImpl.this.isEnabledProfileOf(cookie.user, user, "onPackagesUnsuspended")) continue;
                        try {
                            listener.onPackagesUnsuspended(user, packages);
                            continue;
                        }
                        catch (RemoteException re) {
                            Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                        }
                    }
                }
                finally {
                    LauncherAppsImpl.this.mListeners.finishBroadcast();
                }
                super.onPackagesUnsuspended(packages);
            }

            @Override
            public void onShortcutChanged(String packageName, int userId) {
                LauncherAppsImpl.this.postToPackageMonitorHandler(() -> this.onShortcutChangedInner(packageName, userId));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void onShortcutChangedInner(String packageName, int userId) {
                int n = LauncherAppsImpl.this.mListeners.beginBroadcast();
                try {
                    UserHandle user = UserHandle.of(userId);
                    for (int i = 0; i < n; ++i) {
                        IOnAppsChangedListener listener = (IOnAppsChangedListener)LauncherAppsImpl.this.mListeners.getBroadcastItem(i);
                        BroadcastCookie cookie = (BroadcastCookie)LauncherAppsImpl.this.mListeners.getBroadcastCookie(i);
                        if (!LauncherAppsImpl.this.isEnabledProfileOf(cookie.user, user, "onShortcutChanged")) continue;
                        int launcherUserId = cookie.user.getIdentifier();
                        if (!LauncherAppsImpl.this.mShortcutServiceInternal.hasShortcutHostPermission(launcherUserId, cookie.packageName, cookie.callingPid, cookie.callingUid)) continue;
                        List<ShortcutInfo> list = LauncherAppsImpl.this.mShortcutServiceInternal.getShortcuts(launcherUserId, cookie.packageName, 0L, packageName, null, null, 1039, userId, cookie.callingPid, cookie.callingUid);
                        try {
                            listener.onShortcutChanged(user, packageName, new ParceledListSlice<ShortcutInfo>(list));
                            continue;
                        }
                        catch (RemoteException re) {
                            Slog.d(LauncherAppsImpl.TAG, "Callback failed ", re);
                        }
                    }
                }
                catch (RuntimeException e) {
                    Log.w(LauncherAppsImpl.TAG, e.getMessage(), e);
                }
                finally {
                    LauncherAppsImpl.this.mListeners.finishBroadcast();
                }
            }
        }
    }

    static class BroadcastCookie {
        public final UserHandle user;
        public final String packageName;
        public final int callingUid;
        public final int callingPid;

        BroadcastCookie(UserHandle userHandle, String packageName, int callingPid, int callingUid) {
            this.user = userHandle;
            this.packageName = packageName;
            this.callingUid = callingUid;
            this.callingPid = callingPid;
        }
    }
}

