/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.IPackageManager;
import android.content.pm.ModuleInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

@VisibleForTesting
public class ModuleInfoProvider {
    private static final String TAG = "PackageManager.ModuleInfoProvider";
    private static final String MODULE_METADATA_KEY = "android.content.pm.MODULE_METADATA";
    private final Context mContext;
    private final IPackageManager mPackageManager;
    private final Map<String, ModuleInfo> mModuleInfo;
    private volatile boolean mMetadataLoaded;
    private volatile String mPackageName;

    ModuleInfoProvider(Context context, IPackageManager packageManager) {
        this.mContext = context;
        this.mPackageManager = packageManager;
        this.mModuleInfo = new ArrayMap<String, ModuleInfo>();
    }

    @VisibleForTesting
    public ModuleInfoProvider(XmlResourceParser metadata, Resources resources) {
        this.mContext = null;
        this.mPackageManager = null;
        this.mModuleInfo = new ArrayMap<String, ModuleInfo>();
        this.loadModuleMetadata(metadata, resources);
    }

    public void systemReady() {
        Resources packageResources;
        PackageInfo pi;
        this.mPackageName = this.mContext.getResources().getString(17039705);
        if (TextUtils.isEmpty(this.mPackageName)) {
            Slog.w(TAG, "No configured module metadata provider.");
            return;
        }
        try {
            pi = this.mPackageManager.getPackageInfo(this.mPackageName, 128, 0);
            Context packageContext = this.mContext.createPackageContext(this.mPackageName, 0);
            packageResources = packageContext.getResources();
        }
        catch (PackageManager.NameNotFoundException | RemoteException e) {
            Slog.w(TAG, "Unable to discover metadata package: " + this.mPackageName, e);
            return;
        }
        XmlResourceParser parser = packageResources.getXml(pi.applicationInfo.metaData.getInt(MODULE_METADATA_KEY));
        this.loadModuleMetadata(parser, packageResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModuleMetadata(XmlResourceParser parser, Resources packageResources) {
        try {
            XmlUtils.beginDocument(parser, "module-metadata");
            while (true) {
                XmlUtils.nextElement(parser);
                if (parser.getEventType() == 1) {
                    break;
                }
                if (!"module".equals(parser.getName())) {
                    Slog.w(TAG, "Unexpected metadata element: " + parser.getName());
                    this.mModuleInfo.clear();
                    break;
                }
                CharSequence moduleName = packageResources.getText(Integer.parseInt(parser.getAttributeValue(null, "name").substring(1)));
                String modulePackageName = XmlUtils.readStringAttribute(parser, "packageName");
                boolean isHidden = XmlUtils.readBooleanAttribute(parser, "isHidden");
                ModuleInfo mi = new ModuleInfo();
                mi.setHidden(isHidden);
                mi.setPackageName(modulePackageName);
                mi.setName(moduleName);
                this.mModuleInfo.put(modulePackageName, mi);
            }
        }
        catch (IOException | XmlPullParserException e) {
            Slog.w(TAG, "Error parsing module metadata", e);
            this.mModuleInfo.clear();
        }
        finally {
            parser.close();
            this.mMetadataLoaded = true;
        }
    }

    List<ModuleInfo> getInstalledModules(int flags) {
        List allPackages;
        if (!this.mMetadataLoaded) {
            throw new IllegalStateException("Call to getInstalledModules before metadata loaded");
        }
        if ((flags & 0x20000) != 0) {
            return new ArrayList<ModuleInfo>(this.mModuleInfo.values());
        }
        try {
            allPackages = this.mPackageManager.getInstalledPackages(flags | 0x40000000, 0).getList();
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Unable to retrieve all package names", e);
            return Collections.emptyList();
        }
        ArrayList<ModuleInfo> installedModules = new ArrayList<ModuleInfo>(allPackages.size());
        for (PackageInfo p : allPackages) {
            ModuleInfo m = this.mModuleInfo.get(p.packageName);
            if (m == null) continue;
            installedModules.add(m);
        }
        return installedModules;
    }

    ModuleInfo getModuleInfo(String packageName, int flags) {
        if (!this.mMetadataLoaded) {
            throw new IllegalStateException("Call to getModuleInfo before metadata loaded");
        }
        return this.mModuleInfo.get(packageName);
    }

    String getPackageName() {
        if (!this.mMetadataLoaded) {
            throw new IllegalStateException("Call to getVersion before metadata loaded");
        }
        return this.mPackageName;
    }
}

