/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppOpsManager;
import android.app.BroadcastOptions;
import android.app.IActivityManager;
import android.app.ResourcesManager;
import android.app.admin.IDevicePolicyManager;
import android.app.admin.SecurityLog;
import android.app.backup.IBackupManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.AppsQueryHelper;
import android.content.pm.AuxiliaryResolveInfo;
import android.content.pm.ChangedPackages;
import android.content.pm.ComponentInfo;
import android.content.pm.FallbackCategoryProvider;
import android.content.pm.FeatureInfo;
import android.content.pm.IDexModuleRegisterCallback;
import android.content.pm.IOnPermissionsChangeListener;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageDeleteObserver2;
import android.content.pm.IPackageInstallObserver2;
import android.content.pm.IPackageInstaller;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageManagerNative;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstantAppInfo;
import android.content.pm.InstantAppRequest;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.KeySet;
import android.content.pm.ModuleInfo;
import android.content.pm.PackageBackwardCompatibility;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInfoLite;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageList;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.PackageUserState;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.SELinuxUtil;
import android.content.pm.ServiceInfo;
import android.content.pm.SharedLibraryInfo;
import android.content.pm.Signature;
import android.content.pm.SuspendDialogInfo;
import android.content.pm.UserInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.pm.VerifierInfo;
import android.content.pm.VersionedPackage;
import android.content.pm.dex.ArtManager;
import android.content.pm.dex.DexMetadataHelper;
import android.content.pm.dex.IArtManager;
import android.content.res.Resources;
import android.content.rollback.IRollbackManager;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.os.storage.DiskInfo;
import android.os.storage.IStorageManager;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageManager;
import android.os.storage.StorageManagerInternal;
import android.os.storage.VolumeInfo;
import android.provider.DeviceConfig;
import android.provider.MediaStore;
import android.provider.Settings;
import android.security.KeyStore;
import android.security.SystemKeyStore;
import android.system.ErrnoException;
import android.system.Os;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Base64;
import android.util.ByteStringUtils;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.ExceptionUtils;
import android.util.IntArray;
import android.util.Log;
import android.util.LogPrinter;
import android.util.LongSparseArray;
import android.util.LongSparseLongArray;
import android.util.MathUtils;
import android.util.PackageUtils;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.StatsLog;
import android.util.TimingsTraceLog;
import android.util.Xml;
import android.util.jar.StrictJarFile;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.content.NativeLibraryHelper;
import com.android.internal.content.PackageHelper;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.SomeArgs;
import com.android.internal.telephony.CarrierAppUtils;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.ConcurrentUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.IntPair;
import com.android.internal.util.Preconditions;
import com.android.server.AttributeCache;
import com.android.server.DeviceIdleController;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.LockGuard;
import com.android.server.PackageWatchdog;
import com.android.server.ServiceThread;
import com.android.server.SystemConfig;
import com.android.server.SystemServerInitThreadPool;
import com.android.server.Watchdog;
import com.android.server.net.NetworkPolicyManagerInternal;
import com.android.server.pm.ApexManager;
import com.android.server.pm.BackgroundDexOptService;
import com.android.server.pm.CompilerStats;
import com.android.server.pm.ComponentResolver;
import com.android.server.pm.CrossProfileIntentFilter;
import com.android.server.pm.CrossProfileIntentResolver;
import com.android.server.pm.DumpState;
import com.android.server.pm.Installer;
import com.android.server.pm.InstantAppRegistry;
import com.android.server.pm.InstantAppResolver;
import com.android.server.pm.InstantAppResolverConnection;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.IntentFilterVerificationResponse;
import com.android.server.pm.IntentFilterVerificationState;
import com.android.server.pm.KeySetHandle;
import com.android.server.pm.KeySetManagerService;
import com.android.server.pm.ModuleInfoProvider;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageInstallerService;
import com.android.server.pm.PackageManagerException;
import com.android.server.pm.PackageManagerServiceCompilerMapping;
import com.android.server.pm.PackageManagerServiceUtils;
import com.android.server.pm.PackageManagerShellCommand;
import com.android.server.pm.PackageSender;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSettingBase;
import com.android.server.pm.PackageUsage;
import com.android.server.pm.PackageVerificationResponse;
import com.android.server.pm.PackageVerificationState;
import com.android.server.pm.ParallelPackageParser;
import com.android.server.pm.PersistentPreferredActivity;
import com.android.server.pm.PersistentPreferredIntentResolver;
import com.android.server.pm.PreferredActivity;
import com.android.server.pm.PreferredIntentResolver;
import com.android.server.pm.ProcessLoggingHandler;
import com.android.server.pm.ProtectedPackages;
import com.android.server.pm.SELinuxMMAC;
import com.android.server.pm.SettingBase;
import com.android.server.pm.Settings;
import com.android.server.pm.SharedUserSetting;
import com.android.server.pm.UserDataPreparer;
import com.android.server.pm.UserManagerService;
import com.android.server.pm.dex.ArtManagerService;
import com.android.server.pm.dex.DexManager;
import com.android.server.pm.dex.DexoptOptions;
import com.android.server.pm.dex.PackageDexUsage;
import com.android.server.pm.dex.ViewCompiler;
import com.android.server.pm.permission.BasePermission;
import com.android.server.pm.permission.DefaultPermissionGrantPolicy;
import com.android.server.pm.permission.PermissionManagerService;
import com.android.server.pm.permission.PermissionManagerServiceInternal;
import com.android.server.pm.permission.PermissionsState;
import com.android.server.policy.PermissionPolicyInternal;
import com.android.server.security.VerityUtils;
import com.android.server.storage.DeviceStorageMonitorInternal;
import com.android.server.wm.ActivityTaskManagerInternal;
import dalvik.system.CloseGuard;
import dalvik.system.VMRuntime;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.security.DigestException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageManagerService
extends IPackageManager.Stub
implements PackageSender {
    static final String TAG = "PackageManager";
    public static final boolean DEBUG_SETTINGS = false;
    static final boolean DEBUG_PREFERRED = false;
    static final boolean DEBUG_UPGRADE = false;
    static final boolean DEBUG_DOMAIN_VERIFICATION = false;
    private static final boolean DEBUG_BACKUP = false;
    public static final boolean DEBUG_INSTALL = false;
    public static final boolean DEBUG_REMOVE = false;
    private static final boolean DEBUG_BROADCASTS = false;
    private static final boolean DEBUG_PACKAGE_INFO = false;
    private static final boolean DEBUG_INTENT_MATCHING = false;
    public static final boolean DEBUG_PACKAGE_SCANNING = false;
    private static final boolean DEBUG_VERIFY = false;
    public static final boolean DEBUG_PERMISSIONS = false;
    private static final boolean DEBUG_SHARED_LIBRARIES = false;
    public static final boolean DEBUG_COMPRESSION = Build.IS_DEBUGGABLE;
    public static final boolean DEBUG_DEXOPT = false;
    private static final boolean DEBUG_ABI_SELECTION = false;
    private static final boolean DEBUG_INSTANT = Build.IS_DEBUGGABLE;
    private static final boolean DEBUG_APP_DATA = false;
    static final boolean CLEAR_RUNTIME_PERMISSIONS_ON_UPGRADE = false;
    private static final boolean HIDE_EPHEMERAL_APIS = false;
    private static final boolean ENABLE_FREE_CACHE_V2 = SystemProperties.getBoolean("fw.free_cache_v2", true);
    private static final String PRECOMPILE_LAYOUTS = "pm.precompile_layouts";
    private static final int RADIO_UID = 1001;
    private static final int LOG_UID = 1007;
    private static final int NFC_UID = 1027;
    private static final int BLUETOOTH_UID = 1002;
    private static final int SHELL_UID = 2000;
    private static final int SE_UID = 1068;
    private static final int NETWORKSTACK_UID = 1073;
    static final int SCAN_NO_DEX = 1;
    static final int SCAN_UPDATE_SIGNATURE = 2;
    static final int SCAN_NEW_INSTALL = 4;
    static final int SCAN_UPDATE_TIME = 8;
    static final int SCAN_BOOTING = 16;
    static final int SCAN_REQUIRE_KNOWN = 128;
    static final int SCAN_MOVE = 256;
    static final int SCAN_INITIAL = 512;
    static final int SCAN_CHECK_ONLY = 1024;
    static final int SCAN_DONT_KILL_APP = 2048;
    static final int SCAN_IGNORE_FROZEN = 4096;
    static final int SCAN_FIRST_BOOT_OR_UPGRADE = 8192;
    static final int SCAN_AS_INSTANT_APP = 16384;
    static final int SCAN_AS_FULL_APP = 32768;
    static final int SCAN_AS_VIRTUAL_PRELOAD = 65536;
    static final int SCAN_AS_SYSTEM = 131072;
    static final int SCAN_AS_PRIVILEGED = 262144;
    static final int SCAN_AS_OEM = 524288;
    static final int SCAN_AS_VENDOR = 0x100000;
    static final int SCAN_AS_PRODUCT = 0x200000;
    static final int SCAN_AS_PRODUCT_SERVICES = 0x400000;
    static final int SCAN_AS_ODM = 0x800000;
    private static final String STATIC_SHARED_LIB_DELIMITER = "_";
    public static final String COMPRESSED_EXTENSION = ".gz";
    public static final String STUB_SUFFIX = "-Stub";
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_ACTIVITY = 1;
    private static final int TYPE_RECEIVER = 2;
    private static final int TYPE_SERVICE = 3;
    private static final int TYPE_PROVIDER = 4;
    static final long WATCHDOG_TIMEOUT = 600000L;
    private static final long DEFAULT_MANDATORY_FSTRIM_INTERVAL = 259200000L;
    private static final boolean DEFAULT_VERIFY_ENABLE = true;
    private static final long DEFAULT_VERIFICATION_TIMEOUT = 10000L;
    private static final String PROPERTY_ENABLE_ROLLBACK_TIMEOUT_MILLIS = "enable_rollback_timeout";
    private static final long DEFAULT_ENABLE_ROLLBACK_TIMEOUT_MILLIS = 10000L;
    private static final int DEFAULT_VERIFICATION_RESPONSE = 1;
    public static final String PLATFORM_PACKAGE_NAME = "android";
    private static final String KILL_APP_REASON_GIDS_CHANGED = "permission grant or revoke changed gids";
    private static final String KILL_APP_REASON_PERMISSIONS_REVOKED = "permissions revoked";
    private static final String PACKAGE_MIME_TYPE = "application/vnd.android.package-archive";
    private static final String PACKAGE_SCHEME = "package";
    private static final String VENDOR_OVERLAY_DIR = "/vendor/overlay";
    private static final String PRODUCT_OVERLAY_DIR = "/product/overlay";
    private static final String PRODUCT_SERVICES_OVERLAY_DIR = "/product_services/overlay";
    private static final String ODM_OVERLAY_DIR = "/odm/overlay";
    private static final String OEM_OVERLAY_DIR = "/oem/overlay";
    private static final Intent sBrowserIntent = new Intent();
    public static final int REASON_UNKNOWN = -1;
    public static final int REASON_FIRST_BOOT = 0;
    public static final int REASON_BOOT = 1;
    public static final int REASON_INSTALL = 2;
    public static final int REASON_BACKGROUND_DEXOPT = 3;
    public static final int REASON_AB_OTA = 4;
    public static final int REASON_INACTIVE_PACKAGE_DOWNGRADE = 5;
    public static final int REASON_SHARED = 6;
    public static final int REASON_LAST = 6;
    private static final boolean DEFAULT_PACKAGE_PARSER_CACHE_ENABLED = true;
    private static final String[] INSTANT_APP_BROADCAST_PERMISSION;
    final ServiceThread mHandlerThread;
    final PackageHandler mHandler;
    private final ProcessLoggingHandler mProcessLoggingHandler;
    final int mSdkVersion = Build.VERSION.SDK_INT;
    final Context mContext;
    final boolean mFactoryTest;
    final boolean mOnlyCore;
    final DisplayMetrics mMetrics;
    final int mDefParseFlags;
    final String[] mSeparateProcesses;
    final boolean mIsUpgrade;
    final boolean mIsPreNUpgrade;
    final boolean mIsPreNMR1Upgrade;
    final boolean mIsPreQUpgrade;
    @GuardedBy(value={"mPackages"})
    private boolean mDexOptDialogShown;
    @GuardedBy(value={"mInstallLock"})
    final Installer mInstaller;
    private static final File sAppInstallDir;
    private static final File sAppLib32InstallDir;
    final Object mInstallLock = new Object();
    @GuardedBy(value={"mPackages"})
    final ArrayMap<String, PackageParser.Package> mPackages = new ArrayMap();
    @GuardedBy(value={"mPackages"})
    final SparseIntArray mIsolatedOwners = new SparseIntArray();
    private final ArrayMap<String, File> mExpectingBetter = new ArrayMap();
    private final ArraySet<String> mExistingSystemPackages = new ArraySet();
    boolean mPromoteSystemApps;
    @GuardedBy(value={"mPackages"})
    final Settings mSettings;
    @GuardedBy(value={"mPackages"})
    final ArraySet<String> mFrozenPackages = new ArraySet();
    final ProtectedPackages mProtectedPackages;
    @GuardedBy(value={"mLoadedVolumes"})
    final ArraySet<String> mLoadedVolumes = new ArraySet();
    boolean mFirstBoot;
    PackageManagerInternal.ExternalSourcesPolicy mExternalSourcesPolicy;
    @GuardedBy(value={"mAvailableFeatures"})
    final ArrayMap<String, FeatureInfo> mAvailableFeatures;
    private final InstantAppRegistry mInstantAppRegistry;
    @GuardedBy(value={"mPackages"})
    int mChangedPackagesSequenceNumber;
    @GuardedBy(value={"mPackages"})
    final SparseArray<SparseArray<String>> mChangedPackages = new SparseArray();
    @GuardedBy(value={"mPackages"})
    final SparseArray<Map<String, Integer>> mChangedPackagesSequenceNumbers = new SparseArray();
    @GuardedBy(value={"mPackages"})
    private final ArraySet<PackageManagerInternal.PackageListObserver> mPackageListObservers = new ArraySet();
    @GuardedBy(value={"mPackages"})
    private final SparseIntArray mDefaultPermissionsGrantedUsers = new SparseIntArray();
    private final ModuleInfoProvider mModuleInfoProvider;
    private final ApexManager mApexManager;
    final PackageParser.Callback mPackageParserCallback = new PackageParserCallback();
    final ParallelPackageParserCallback mParallelPackageParserCallback = new ParallelPackageParserCallback();
    final ArrayMap<String, LongSparseArray<SharedLibraryInfo>> mSharedLibraries = new ArrayMap();
    final ArrayMap<String, LongSparseArray<SharedLibraryInfo>> mStaticLibsByDeclaringPackage = new ArrayMap();
    final ArrayMap<ComponentName, PackageParser.Instrumentation> mInstrumentation = new ArrayMap();
    final ArraySet<String> mTransferedPackages = new ArraySet();
    @GuardedBy(value={"mProtectedBroadcasts"})
    final ArraySet<String> mProtectedBroadcasts = new ArraySet();
    final SparseArray<PackageVerificationState> mPendingVerification = new SparseArray();
    final SparseArray<InstallParams> mPendingEnableRollback = new SparseArray();
    final PackageInstallerService mInstallerService;
    final ArtManagerService mArtManagerService;
    private final PackageDexOptimizer mPackageDexOptimizer;
    private final DexManager mDexManager;
    private final ViewCompiler mViewCompiler;
    private AtomicInteger mNextMoveId = new AtomicInteger();
    private final MoveCallbacks mMoveCallbacks;
    private final OnPermissionChangeListeners mOnPermissionChangeListeners;
    private final SparseBooleanArray mUserNeedsBadging = new SparseBooleanArray();
    private int mPendingVerificationToken = 0;
    private int mPendingEnableRollbackToken = 0;
    volatile boolean mSystemReady;
    volatile boolean mSafeMode;
    volatile boolean mHasSystemUidErrors;
    private volatile SparseBooleanArray mWebInstantAppsDisabled = new SparseBooleanArray();
    ApplicationInfo mAndroidApplication;
    final ActivityInfo mResolveActivity = new ActivityInfo();
    final ResolveInfo mResolveInfo = new ResolveInfo();
    ComponentName mResolveComponentName;
    PackageParser.Package mPlatformPackage;
    ComponentName mCustomResolverComponentName;
    boolean mResolverReplaced = false;
    private final ComponentName mIntentFilterVerifierComponent;
    private final IntentFilterVerifier<PackageParser.ActivityIntentInfo> mIntentFilterVerifier;
    private int mIntentFilterVerificationToken = 0;
    final InstantAppResolverConnection mInstantAppResolverConnection;
    final ComponentName mInstantAppResolverSettingsComponent;
    ActivityInfo mInstantAppInstallerActivity;
    final ResolveInfo mInstantAppInstallerInfo = new ResolveInfo();
    private final Map<String, Pair<PackageInstalledInfo, IPackageInstallObserver2>> mNoKillInstallObservers = Collections.synchronizedMap(new HashMap());
    final SparseArray<IntentFilterVerificationState> mIntentFilterVerificationStates = new SparseArray();
    final DefaultPermissionGrantPolicy mDefaultPermissionPolicy;
    private final PermissionManagerServiceInternal mPermissionManager;
    private final ComponentResolver mComponentResolver;
    private List<String> mKeepUninstalledPackages;
    private UserManagerInternal mUserManagerInternal;
    private ActivityManagerInternal mActivityManagerInternal;
    private ActivityTaskManagerInternal mActivityTaskManagerInternal;
    private StorageManagerInternal mStorageManagerInternal;
    private DeviceIdleController.LocalService mDeviceIdleController;
    private File mCacheDir;
    private Future<?> mPrepareAppDataFuture;
    @GuardedBy(value={"mPackages"})
    private PackageManagerInternal.CheckPermissionDelegate mCheckPermissionDelegate;
    @GuardedBy(value={"mPackages"})
    private PackageManagerInternal.DefaultBrowserProvider mDefaultBrowserProvider;
    @GuardedBy(value={"mPackages"})
    private PackageManagerInternal.DefaultDialerProvider mDefaultDialerProvider;
    @GuardedBy(value={"mPackages"})
    private PackageManagerInternal.DefaultHomeProvider mDefaultHomeProvider;
    final PendingPackageBroadcasts mPendingBroadcasts = new PendingPackageBroadcasts();
    static final int SEND_PENDING_BROADCAST = 1;
    static final int INIT_COPY = 5;
    static final int POST_INSTALL = 9;
    static final int WRITE_SETTINGS = 13;
    static final int WRITE_PACKAGE_RESTRICTIONS = 14;
    static final int PACKAGE_VERIFIED = 15;
    static final int CHECK_PENDING_VERIFICATION = 16;
    static final int START_INTENT_FILTER_VERIFICATIONS = 17;
    static final int INTENT_FILTER_VERIFIED = 18;
    static final int WRITE_PACKAGE_LIST = 19;
    static final int INSTANT_APP_RESOLUTION_PHASE_TWO = 20;
    static final int ENABLE_ROLLBACK_STATUS = 21;
    static final int ENABLE_ROLLBACK_TIMEOUT = 22;
    static final int DEFERRED_NO_KILL_POST_DELETE = 23;
    static final int DEFERRED_NO_KILL_INSTALL_OBSERVER = 24;
    static final int DEFERRED_NO_KILL_POST_DELETE_DELAY_MS = 3000;
    static final int DEFERRED_NO_KILL_INSTALL_OBSERVER_DELAY_MS = 500;
    static final int WRITE_SETTINGS_DELAY = 10000;
    private static final long BROADCAST_DELAY_DURING_STARTUP = 10000L;
    private static final long BROADCAST_DELAY = 1000L;
    private long mServiceStartWithDelay;
    private static final long DEFAULT_UNUSED_STATIC_SHARED_LIB_MIN_CACHE_PERIOD = 0x6DDD00L;
    static UserManagerService sUserManager;
    private ArraySet<Integer> mDirtyUsers = new ArraySet();
    final SparseArray<PostInstallData> mRunningInstalls = new SparseArray();
    int mNextInstallToken = 1;
    private static final String TAG_PREFERRED_BACKUP = "pa";
    private static final String TAG_DEFAULT_APPS = "da";
    private static final String TAG_INTENT_FILTER_VERIFICATION = "iv";
    private static final String TAG_PERMISSION_BACKUP = "perm-grant-backup";
    private static final String TAG_ALL_GRANTS = "rt-grants";
    private static final String TAG_GRANT = "grant";
    private static final String ATTR_PACKAGE_NAME = "pkg";
    private static final String TAG_PERMISSION = "perm";
    private static final String ATTR_PERMISSION_NAME = "name";
    private static final String ATTR_IS_GRANTED = "g";
    private static final String ATTR_USER_SET = "set";
    private static final String ATTR_USER_FIXED = "fixed";
    private static final String ATTR_REVOKE_ON_UPGRADE = "rou";
    private static final int SYSTEM_RUNTIME_GRANT_MASK = 52;
    private static final int USER_RUNTIME_GRANT_MASK = 11;
    final String mRequiredVerifierPackage;
    final String mRequiredInstallerPackage;
    final String mRequiredUninstallerPackage;
    final String mRequiredPermissionControllerPackage;
    final String mSetupWizardPackage;
    final String mStorageManagerPackage;
    final String mSystemTextClassifierPackage;
    final String mWellbeingPackage;
    final String mDocumenterPackage;
    final String mConfiguratorPackage;
    final String mAppPredictionServicePackage;
    final String mIncidentReportApproverPackage;
    final String mServicesSystemSharedLibraryPackageName;
    final String mSharedSystemSharedLibraryPackageName;
    private final PackageUsage mPackageUsage = new PackageUsage();
    private final CompilerStats mCompilerStats = new CompilerStats();
    private PermissionManagerServiceInternal.PermissionCallback mPermissionCallback = new PermissionManagerServiceInternal.PermissionCallback(){

        @Override
        public void onGidsChanged(int appId, int userId) {
            PackageManagerService.this.mHandler.post(() -> PackageManagerService.this.killUid(appId, userId, PackageManagerService.KILL_APP_REASON_GIDS_CHANGED));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPermissionGranted(int uid, int userId) {
            PackageManagerService.this.mOnPermissionChangeListeners.onPermissionsChanged(uid);
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInstallPermissionGranted() {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.scheduleWriteSettingsLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPermissionRevoked(int uid, int userId) {
            PackageManagerService.this.mOnPermissionChangeListeners.onPermissionsChanged(uid);
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mSettings.writeRuntimePermissionsForUserLPr(userId, true);
            }
            int appId = UserHandle.getAppId(uid);
            PackageManagerService.this.killUid(appId, userId, PackageManagerService.KILL_APP_REASON_PERMISSIONS_REVOKED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInstallPermissionRevoked() {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.scheduleWriteSettingsLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPermissionUpdated(int[] updatedUserIds, boolean sync) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                for (int userId : updatedUserIds) {
                    PackageManagerService.this.mSettings.writeRuntimePermissionsForUserLPr(userId, sync);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInstallPermissionUpdated() {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.scheduleWriteSettingsLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPermissionRemoved() {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mSettings.writeLPr();
            }
        }
    };
    private StorageEventListener mStorageListener = new StorageEventListener(){

        @Override
        public void onVolumeStateChanged(VolumeInfo vol, int oldState, int newState) {
            if (vol.type == 1) {
                if (vol.state == 2) {
                    String volumeUuid = vol.getFsUuid();
                    sUserManager.reconcileUsers(volumeUuid);
                    PackageManagerService.this.reconcileApps(volumeUuid);
                    PackageManagerService.this.mInstallerService.onPrivateVolumeMounted(volumeUuid);
                    PackageManagerService.this.loadPrivatePackages(vol);
                } else if (vol.state == 5) {
                    PackageManagerService.this.unloadPrivatePackages(vol);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVolumeForgotten(String fsUuid) {
            if (TextUtils.isEmpty(fsUuid)) {
                Slog.e(PackageManagerService.TAG, "Forgetting internal storage is probably a mistake; ignoring");
                return;
            }
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                List<PackageSetting> packages = PackageManagerService.this.mSettings.getVolumePackagesLPr(fsUuid);
                for (PackageSetting ps : packages) {
                    Slog.d(PackageManagerService.TAG, "Destroying " + ps.name + " because volume was forgotten");
                    PackageManagerService.this.deletePackageVersioned(new VersionedPackage(ps.name, -1), new PackageManager.LegacyPackageDeleteObserver(null).getBinder(), 0, 2);
                    AttributeCache.instance().removePackage(ps.name);
                }
                PackageManagerService.this.mSettings.onVolumeForgotten(fsUuid);
                PackageManagerService.this.mSettings.writeLPr();
            }
        }
    };
    private static final Comparator<ProviderInfo> sProviderInitOrderSorter;
    static final boolean DEBUG_SD_INSTALL = false;
    private static final String SD_ENCRYPTION_KEYSTORE_NAME = "AppsOnSD";
    private static final String SD_ENCRYPTION_ALGORITHM = "AES";
    private boolean mMediaMounted = false;

    private static boolean hasValidDomains(PackageParser.ActivityIntentInfo filter) {
        return filter.hasCategory("android.intent.category.BROWSABLE") && (filter.hasDataScheme("http") || filter.hasDataScheme("https"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackagePostInstall(PackageInstalledInfo res, boolean grantPermissions, boolean killApp, boolean virtualPreload, String[] grantedPermissions, List<String> whitelistedRestrictedPermissions, boolean launchedForRestore, String installerPackage, IPackageInstallObserver2 installObserver) {
        boolean deferInstallObserver;
        boolean update;
        boolean succeeded = res.returnCode == 1;
        boolean bl = update = res.removedInfo != null && res.removedInfo.removedPackage != null;
        if (succeeded) {
            InstallArgs args;
            String installerPackageName;
            if (res.removedInfo != null) {
                res.removedInfo.sendPackageRemovedBroadcasts(killApp);
            }
            if (whitelistedRestrictedPermissions != null && !whitelistedRestrictedPermissions.isEmpty()) {
                this.mPermissionManager.setWhitelistedRestrictedPermissions(res.pkg, res.newUsers, whitelistedRestrictedPermissions, Process.myUid(), 2, this.mPermissionCallback);
            }
            if (grantPermissions) {
                int callingUid = Binder.getCallingUid();
                this.mPermissionManager.grantRequestedRuntimePermissions(res.pkg, res.newUsers, grantedPermissions, callingUid, this.mPermissionCallback);
            }
            String string2 = res.installerPackageName != null ? res.installerPackageName : (installerPackageName = res.removedInfo != null ? res.removedInfo.installerPackageName : null);
            if (res.pkg.parentPackage != null) {
                int callingUid = Binder.getCallingUid();
                this.mPermissionManager.grantRuntimePermissionsGrantedToDisabledPackage(res.pkg, callingUid, this.mPermissionCallback);
            }
            ArrayMap<String, PackageParser.Package> callingUid = this.mPackages;
            synchronized (callingUid) {
                this.mInstantAppRegistry.onPackageInstalledLPw(res.pkg, res.newUsers);
            }
            String packageName = res.pkg.applicationInfo.packageName;
            int[] firstUserIds = EMPTY_INT_ARRAY;
            int[] firstInstantUserIds = EMPTY_INT_ARRAY;
            int[] updateUserIds = EMPTY_INT_ARRAY;
            int[] instantUserIds = EMPTY_INT_ARRAY;
            boolean allNewUsers = res.origUsers == null || res.origUsers.length == 0;
            PackageSetting ps = (PackageSetting)res.pkg.mExtras;
            for (int newUser : res.newUsers) {
                boolean isInstantApp = ps.getInstantApp(newUser);
                if (allNewUsers) {
                    if (isInstantApp) {
                        firstInstantUserIds = ArrayUtils.appendInt(firstInstantUserIds, newUser);
                        continue;
                    }
                    firstUserIds = ArrayUtils.appendInt(firstUserIds, newUser);
                    continue;
                }
                boolean isNew = true;
                for (int origUser : res.origUsers) {
                    if (origUser != newUser) continue;
                    isNew = false;
                    break;
                }
                if (isNew) {
                    if (isInstantApp) {
                        firstInstantUserIds = ArrayUtils.appendInt(firstInstantUserIds, newUser);
                        continue;
                    }
                    firstUserIds = ArrayUtils.appendInt(firstUserIds, newUser);
                    continue;
                }
                if (isInstantApp) {
                    instantUserIds = ArrayUtils.appendInt(instantUserIds, newUser);
                    continue;
                }
                updateUserIds = ArrayUtils.appendInt(updateUserIds, newUser);
            }
            if (res.pkg.staticSharedLibName == null) {
                boolean notifyVerifier;
                this.mProcessLoggingHandler.invalidateProcessLoggingBaseApkHash(res.pkg.baseCodePath);
                int appId = UserHandle.getAppId(res.uid);
                boolean isSystem = res.pkg.applicationInfo.isSystemApp();
                this.sendPackageAddedForNewUsers(packageName, isSystem || virtualPreload, virtualPreload, appId, firstUserIds, firstInstantUserIds);
                Bundle extras = new Bundle(1);
                extras.putInt("android.intent.extra.UID", res.uid);
                if (update) {
                    extras.putBoolean("android.intent.extra.REPLACING", true);
                }
                this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, 0, null, null, updateUserIds, instantUserIds);
                if (installerPackageName != null) {
                    this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, 0, installerPackageName, null, updateUserIds, instantUserIds);
                }
                boolean bl2 = notifyVerifier = this.mRequiredVerifierPackage != null && !this.mRequiredVerifierPackage.equals(installerPackageName);
                if (notifyVerifier) {
                    this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, 0, this.mRequiredVerifierPackage, null, updateUserIds, instantUserIds);
                }
                if (this.mRequiredInstallerPackage != null) {
                    this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, 0x1000000, this.mRequiredInstallerPackage, null, firstUserIds, instantUserIds);
                }
                if (update) {
                    this.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", packageName, extras, 0, null, null, updateUserIds, instantUserIds);
                    if (installerPackageName != null) {
                        this.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", packageName, extras, 0, installerPackageName, null, updateUserIds, instantUserIds);
                    }
                    if (notifyVerifier) {
                        this.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", packageName, extras, 0, this.mRequiredVerifierPackage, null, updateUserIds, instantUserIds);
                    }
                    this.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, 0, packageName, null, updateUserIds, instantUserIds);
                } else if (launchedForRestore && !PackageManagerService.isSystemApp(res.pkg)) {
                    this.sendFirstLaunchBroadcast(packageName, installerPackage, firstUserIds, firstInstantUserIds);
                }
                if (PackageManagerService.isExternal(res.pkg)) {
                    StorageManager storage;
                    VolumeInfo volume;
                    int packageExternalStorageType;
                    if (!update && (packageExternalStorageType = PackageManagerService.getPackageExternalStorageType(volume = (storage = this.mContext.getSystemService(StorageManager.class)).findVolumeByUuid(res.pkg.applicationInfo.storageUuid.toString()), PackageManagerService.isExternal(res.pkg))) != 0) {
                        StatsLog.write(181, packageExternalStorageType, res.pkg.packageName);
                    }
                    int[] uidArray = new int[]{res.pkg.applicationInfo.uid};
                    ArrayList<String> pkgList = new ArrayList<String>(1);
                    pkgList.add(packageName);
                    this.sendResourcesChangedBroadcast(true, true, pkgList, uidArray, null);
                }
            }
            if (firstUserIds != null && firstUserIds.length > 0) {
                for (int userId : firstUserIds) {
                    if (this.packageIsBrowser(packageName, userId)) {
                        ArrayMap<String, PackageParser.Package> uidArray = this.mPackages;
                        synchronized (uidArray) {
                            PackageSetting pkgSetting = this.mSettings.mPackages.get(packageName);
                            if (pkgSetting.getInstallReason(userId) != 2) {
                                this.setDefaultBrowserAsyncLPw(null, userId);
                            }
                        }
                    }
                    this.mPermissionManager.restoreDelayedRuntimePermissions(packageName, UserHandle.of(userId));
                    this.updateDefaultHomeNotLocked(userId);
                }
            }
            if (allNewUsers && !update) {
                this.notifyPackageAdded(packageName, res.uid);
            } else {
                this.notifyPackageChanged(packageName, res.uid);
            }
            EventLog.writeEvent(3110, this.getUnknownSourcesSettings());
            InstallArgs installArgs = args = res.removedInfo != null ? res.removedInfo.args : null;
            if (args != null) {
                if (!killApp) {
                    this.scheduleDeferredNoKillPostDelete(args);
                } else {
                    Object object = this.mInstallLock;
                    synchronized (object) {
                        args.doPostDeleteLI(true);
                    }
                }
            } else {
                VMRuntime.getRuntime().requestConcurrentGC();
            }
            for (int userId : firstUserIds) {
                PackageInfo info = this.getPackageInfo(packageName, 0, userId);
                if (info == null) continue;
                this.mDexManager.notifyPackageInstalled(info, userId);
            }
        }
        boolean bl3 = deferInstallObserver = succeeded && update && !killApp;
        if (deferInstallObserver) {
            this.scheduleDeferredNoKillInstallObserver(res, installObserver);
        } else {
            this.notifyInstallObserver(res, installObserver);
        }
    }

    @Override
    public void notifyPackagesReplacedReceived(String[] packages) {
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        for (String packageName : packages) {
            PackageSetting setting = this.mSettings.mPackages.get(packageName);
            if (setting == null || !this.filterAppAccessLPr(setting, callingUid, callingUserId)) continue;
            this.notifyInstallObserver(packageName);
        }
    }

    private void notifyInstallObserver(String packageName) {
        Pair<PackageInstalledInfo, IPackageInstallObserver2> pair = this.mNoKillInstallObservers.remove(packageName);
        if (pair != null) {
            this.notifyInstallObserver((PackageInstalledInfo)pair.first, (IPackageInstallObserver2)pair.second);
        }
    }

    private void notifyInstallObserver(PackageInstalledInfo info, IPackageInstallObserver2 installObserver) {
        if (installObserver != null) {
            try {
                Bundle extras = this.extrasForInstallResult(info);
                installObserver.onPackageInstalled(info.name, info.returnCode, info.returnMsg, extras);
            }
            catch (RemoteException e) {
                Slog.i(TAG, "Observer no longer exists.");
            }
        }
    }

    private void scheduleDeferredNoKillPostDelete(InstallArgs args) {
        Message message = this.mHandler.obtainMessage(23, args);
        this.mHandler.sendMessageDelayed(message, 3000L);
    }

    private void scheduleDeferredNoKillInstallObserver(PackageInstalledInfo info, IPackageInstallObserver2 observer) {
        String packageName = info.pkg.packageName;
        this.mNoKillInstallObservers.put(packageName, Pair.create(info, observer));
        Message message = this.mHandler.obtainMessage(24, packageName);
        this.mHandler.sendMessageDelayed(message, 500L);
    }

    private static int getPackageExternalStorageType(VolumeInfo packageVolume, boolean packageIsExternal) {
        DiskInfo disk;
        if (packageVolume != null && (disk = packageVolume.getDisk()) != null) {
            if (disk.isSd()) {
                return 1;
            }
            if (disk.isUsb()) {
                return 2;
            }
            if (packageIsExternal) {
                return 3;
            }
        }
        return 0;
    }

    Bundle extrasForInstallResult(PackageInstalledInfo res) {
        Bundle extras = null;
        switch (res.returnCode) {
            case -112: {
                extras = new Bundle();
                extras.putString("android.content.pm.extra.FAILURE_EXISTING_PERMISSION", res.origPermission);
                extras.putString("android.content.pm.extra.FAILURE_EXISTING_PACKAGE", res.origPackage);
                break;
            }
            case 1: {
                extras = new Bundle();
                extras.putBoolean("android.intent.extra.REPLACING", res.removedInfo != null && res.removedInfo.removedPackage != null);
            }
        }
        return extras;
    }

    void scheduleWriteSettingsLocked() {
        if (!this.mHandler.hasMessages(13)) {
            this.mHandler.sendEmptyMessageDelayed(13, 10000L);
        }
    }

    void scheduleWritePackageListLocked(int userId) {
        if (!this.mHandler.hasMessages(19)) {
            Message msg = this.mHandler.obtainMessage(19);
            msg.arg1 = userId;
            this.mHandler.sendMessageDelayed(msg, 10000L);
        }
    }

    void scheduleWritePackageRestrictionsLocked(UserHandle user) {
        int userId = user == null ? -1 : user.getIdentifier();
        this.scheduleWritePackageRestrictionsLocked(userId);
    }

    void scheduleWritePackageRestrictionsLocked(int userId) {
        int[] userIds;
        int[] nArray;
        if (userId == -1) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userId;
        }
        for (int nextUserId : userIds = nArray) {
            if (!sUserManager.exists(nextUserId)) {
                return;
            }
            this.mDirtyUsers.add(nextUserId);
            if (this.mHandler.hasMessages(14)) continue;
            this.mHandler.sendEmptyMessageDelayed(14, 10000L);
        }
    }

    public static PackageManagerService main(Context context, Installer installer, boolean factoryTest, boolean onlyCore) {
        PackageManagerServiceCompilerMapping.checkProperties();
        PackageManagerService m = new PackageManagerService(context, installer, factoryTest, onlyCore);
        m.enableSystemUserPackages();
        ServiceManager.addService(PACKAGE_SCHEME, m);
        PackageManagerService packageManagerService = m;
        Objects.requireNonNull(packageManagerService);
        PackageManagerNative pmn = packageManagerService.new PackageManagerNative();
        ServiceManager.addService("package_native", pmn);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableSystemUserPackages() {
        if (!UserManager.isSplitSystemUser()) {
            return;
        }
        AppsQueryHelper queryHelper = new AppsQueryHelper(this);
        ArraySet<String> enableApps = new ArraySet<String>();
        enableApps.addAll(queryHelper.queryApps(AppsQueryHelper.GET_NON_LAUNCHABLE_APPS | AppsQueryHelper.GET_APPS_WITH_INTERACT_ACROSS_USERS_PERM | AppsQueryHelper.GET_IMES, true, UserHandle.SYSTEM));
        ArraySet<String> wlApps = SystemConfig.getInstance().getSystemUserWhitelistedApps();
        enableApps.addAll((Collection<String>)wlApps);
        enableApps.addAll(queryHelper.queryApps(AppsQueryHelper.GET_REQUIRED_FOR_SYSTEM_USER, false, UserHandle.SYSTEM));
        ArraySet<String> blApps = SystemConfig.getInstance().getSystemUserBlacklistedApps();
        enableApps.removeAll((Collection<?>)blApps);
        Log.i(TAG, "Applications installed for system user: " + enableApps);
        List<String> allAps = queryHelper.queryApps(0, false, UserHandle.SYSTEM);
        int allAppsSize = allAps.size();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (int i = 0; i < allAppsSize; ++i) {
                String pName = allAps.get(i);
                PackageSetting pkgSetting = this.mSettings.mPackages.get(pName);
                if (pkgSetting == null) continue;
                boolean install = enableApps.contains(pName);
                if (pkgSetting.getInstalled(0) == install) continue;
                Log.i(TAG, (install ? "Installing " : "Uninstalling ") + pName + " for system user");
                pkgSetting.setInstalled(install, 0);
            }
            this.scheduleWritePackageRestrictionsLocked(0);
        }
    }

    private static void getDefaultDisplayMetrics(Context context, DisplayMetrics metrics) {
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        displayManager.getDisplay(0).getMetrics(metrics);
    }

    private static void requestCopyPreoptedFiles() {
        int WAIT_TIME_MS = 100;
        String CP_PREOPT_PROPERTY = "sys.cppreopt";
        if (SystemProperties.getInt("ro.cp_system_other_odex", 0) == 1) {
            SystemProperties.set("sys.cppreopt", "requested");
            long timeStart = SystemClock.uptimeMillis();
            long timeEnd = timeStart + 100000L;
            long timeNow = timeStart;
            while (!SystemProperties.get("sys.cppreopt").equals("finished")) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((timeNow = SystemClock.uptimeMillis()) <= timeEnd) continue;
                SystemProperties.set("sys.cppreopt", "timed-out");
                Slog.wtf(TAG, "cppreopt did not finish!");
                break;
            }
            Slog.i(TAG, "cppreopts took " + (timeNow - timeStart) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageManagerService(Context context, Installer installer, boolean factoryTest, boolean onlyCore) {
        LockGuard.installLock(this.mPackages, 3);
        Trace.traceBegin(262144L, "create package manager");
        EventLog.writeEvent(3060, SystemClock.uptimeMillis());
        if (this.mSdkVersion <= 0) {
            Slog.w(TAG, "**** ro.build.version.sdk not set!");
        }
        this.mContext = context;
        this.mFactoryTest = factoryTest;
        this.mOnlyCore = onlyCore;
        this.mMetrics = new DisplayMetrics();
        this.mInstaller = installer;
        Object object = this.mInstallLock;
        synchronized (object) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                LocalServices.addService(PackageManagerInternal.class, new PackageManagerInternalImpl());
                sUserManager = new UserManagerService(context, this, new UserDataPreparer(this.mInstaller, this.mInstallLock, this.mContext, this.mOnlyCore), this.mPackages);
                this.mComponentResolver = new ComponentResolver(sUserManager, LocalServices.getService(PackageManagerInternal.class), this.mPackages);
                this.mPermissionManager = PermissionManagerService.create(context, this.mPackages);
                this.mDefaultPermissionPolicy = this.mPermissionManager.getDefaultPermissionGrantPolicy();
                this.mSettings = new Settings(Environment.getDataDirectory(), this.mPermissionManager.getPermissionSettings(), this.mPackages);
            }
        }
        this.mSettings.addSharedUserLPw("android.uid.system", 1000, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.phone", 1001, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.log", 1007, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.nfc", 1027, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.bluetooth", 1002, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.shell", 2000, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.se", 1068, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.networkstack", 1073, 1, 8);
        String separateProcesses = SystemProperties.get("debug.separate_processes");
        if (separateProcesses != null && separateProcesses.length() > 0) {
            if ("*".equals(separateProcesses)) {
                this.mDefParseFlags = 2;
                this.mSeparateProcesses = null;
                Slog.w(TAG, "Running with debug.separate_processes: * (ALL)");
            } else {
                this.mDefParseFlags = 0;
                this.mSeparateProcesses = separateProcesses.split(",");
                Slog.w(TAG, "Running with debug.separate_processes: " + separateProcesses);
            }
        } else {
            this.mDefParseFlags = 0;
            this.mSeparateProcesses = null;
        }
        this.mPackageDexOptimizer = new PackageDexOptimizer(installer, this.mInstallLock, context, "*dexopt*");
        this.mDexManager = new DexManager(this.mContext, this, this.mPackageDexOptimizer, installer, this.mInstallLock);
        this.mArtManagerService = new ArtManagerService(this.mContext, this, installer, this.mInstallLock);
        this.mMoveCallbacks = new MoveCallbacks(FgThread.get().getLooper());
        this.mViewCompiler = new ViewCompiler(this.mInstallLock, this.mInstaller);
        this.mOnPermissionChangeListeners = new OnPermissionChangeListeners(FgThread.get().getLooper());
        PackageManagerService.getDefaultDisplayMetrics(context, this.mMetrics);
        Trace.traceBegin(262144L, "get system config");
        SystemConfig systemConfig = SystemConfig.getInstance();
        this.mAvailableFeatures = systemConfig.getAvailableFeatures();
        Trace.traceEnd(262144L);
        this.mProtectedPackages = new ProtectedPackages(this.mContext);
        this.mApexManager = new ApexManager(context);
        Object object2 = this.mInstallLock;
        synchronized (object2) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                boolean sdkUpdated;
                int i;
                String customResolverActivityName;
                this.mHandlerThread = new ServiceThread(TAG, 10, true);
                this.mHandlerThread.start();
                this.mHandler = new PackageHandler(this.mHandlerThread.getLooper());
                this.mProcessLoggingHandler = new ProcessLoggingHandler();
                Watchdog.getInstance().addThread(this.mHandler, 600000L);
                this.mInstantAppRegistry = new InstantAppRegistry(this);
                ArrayMap<String, SystemConfig.SharedLibraryEntry> libConfig = systemConfig.getSharedLibraries();
                int builtInLibCount = libConfig.size();
                for (int i2 = 0; i2 < builtInLibCount; ++i2) {
                    String name = libConfig.keyAt(i2);
                    SystemConfig.SharedLibraryEntry entry = libConfig.valueAt(i2);
                    this.addBuiltInSharedLibraryLocked(entry.filename, name);
                }
                long undefinedVersion = -1L;
                for (int i3 = 0; i3 < builtInLibCount; ++i3) {
                    String name = libConfig.keyAt(i3);
                    SystemConfig.SharedLibraryEntry entry = libConfig.valueAt(i3);
                    int dependencyCount = entry.dependencies.length;
                    for (int j = 0; j < dependencyCount; ++j) {
                        SharedLibraryInfo dependency = this.getSharedLibraryInfoLPr(entry.dependencies[j], undefinedVersion);
                        if (dependency == null) continue;
                        this.getSharedLibraryInfoLPr(name, undefinedVersion).addDependency(dependency);
                    }
                }
                SELinuxMMAC.readInstallPolicy();
                Trace.traceBegin(262144L, "loadFallbacks");
                FallbackCategoryProvider.loadFallbacks();
                Trace.traceEnd(262144L);
                Trace.traceBegin(262144L, "read user settings");
                this.mFirstBoot = !this.mSettings.readLPw(sUserManager.getUsers(false));
                Trace.traceEnd(262144L);
                int packageSettingCount = this.mSettings.mPackages.size();
                for (int i4 = packageSettingCount - 1; i4 >= 0; --i4) {
                    PackageSetting ps = this.mSettings.mPackages.valueAt(i4);
                    if (PackageManagerService.isExternal(ps) || ps.codePath != null && ps.codePath.exists() || this.mSettings.getDisabledSystemPkgLPr(ps.name) == null) continue;
                    this.mSettings.mPackages.removeAt(i4);
                    this.mSettings.enableSystemPackageLPw(ps.name);
                }
                if (!this.mOnlyCore && this.mFirstBoot) {
                    PackageManagerService.requestCopyPreoptedFiles();
                }
                if (!TextUtils.isEmpty(customResolverActivityName = Resources.getSystem().getString(17039690))) {
                    this.mCustomResolverComponentName = ComponentName.unflattenFromString(customResolverActivityName);
                }
                long startTime = SystemClock.uptimeMillis();
                EventLog.writeEvent(3070, startTime);
                String bootClassPath = System.getenv("BOOTCLASSPATH");
                String systemServerClassPath = System.getenv("SYSTEMSERVERCLASSPATH");
                if (bootClassPath == null) {
                    Slog.w(TAG, "No BOOTCLASSPATH found!");
                }
                if (systemServerClassPath == null) {
                    Slog.w(TAG, "No SYSTEMSERVERCLASSPATH found!");
                }
                File frameworkDir = new File(Environment.getRootDirectory(), "framework");
                Settings.VersionInfo ver = this.mSettings.getInternalVersion();
                boolean bl = this.mIsUpgrade = !Build.FINGERPRINT.equals(ver.fingerprint);
                if (this.mIsUpgrade) {
                    PackageManagerServiceUtils.logCriticalInfo(4, "Upgrading from " + ver.fingerprint + " to " + Build.FINGERPRINT);
                }
                this.mPromoteSystemApps = this.mIsUpgrade && ver.sdkVersion <= 22;
                this.mIsPreNUpgrade = this.mIsUpgrade && ver.sdkVersion < 24;
                this.mIsPreNMR1Upgrade = this.mIsUpgrade && ver.sdkVersion < 25;
                this.mIsPreQUpgrade = this.mIsUpgrade && ver.sdkVersion < 29;
                int preUpgradeSdkVersion = ver.sdkVersion;
                if (this.mPromoteSystemApps) {
                    for (PackageSetting ps : this.mSettings.mPackages.values()) {
                        if (!PackageManagerService.isSystemApp(ps)) continue;
                        this.mExistingSystemPackages.add(ps.name);
                    }
                }
                this.mCacheDir = PackageManagerService.preparePackageParserCache();
                int scanFlags = 528;
                if (this.mIsUpgrade || this.mFirstBoot) {
                    scanFlags |= 0x2000;
                }
                this.scanDirTracedLI(new File(VENDOR_OVERLAY_DIR), this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x100000, 0L);
                this.scanDirTracedLI(new File(PRODUCT_OVERLAY_DIR), this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x200000, 0L);
                this.scanDirTracedLI(new File(PRODUCT_SERVICES_OVERLAY_DIR), this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x400000, 0L);
                this.scanDirTracedLI(new File(ODM_OVERLAY_DIR), this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x800000, 0L);
                this.scanDirTracedLI(new File(OEM_OVERLAY_DIR), this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x80000, 0L);
                this.mParallelPackageParserCallback.findStaticOverlayPackages();
                this.scanDirTracedLI(frameworkDir, this.mDefParseFlags | 0x10, scanFlags | 1 | 0x20000 | 0x40000, 0L);
                if (!this.mPackages.containsKey(PLATFORM_PACKAGE_NAME)) {
                    throw new IllegalStateException("Failed to load frameworks package; check log for warnings");
                }
                File privilegedAppDir = new File(Environment.getRootDirectory(), "priv-app");
                this.scanDirTracedLI(privilegedAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x40000, 0L);
                File systemAppDir = new File(Environment.getRootDirectory(), "app");
                this.scanDirTracedLI(systemAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000, 0L);
                File privilegedVendorAppDir = new File(Environment.getVendorDirectory(), "priv-app");
                try {
                    privilegedVendorAppDir = privilegedVendorAppDir.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.scanDirTracedLI(privilegedVendorAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x100000 | 0x40000, 0L);
                File vendorAppDir = new File(Environment.getVendorDirectory(), "app");
                try {
                    vendorAppDir = vendorAppDir.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.scanDirTracedLI(vendorAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x100000, 0L);
                File privilegedOdmAppDir = new File(Environment.getOdmDirectory(), "priv-app");
                try {
                    privilegedOdmAppDir = privilegedOdmAppDir.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.scanDirTracedLI(privilegedOdmAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x100000 | 0x40000, 0L);
                File odmAppDir = new File(Environment.getOdmDirectory(), "app");
                try {
                    odmAppDir = odmAppDir.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.scanDirTracedLI(odmAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x100000, 0L);
                File oemAppDir = new File(Environment.getOemDirectory(), "app");
                this.scanDirTracedLI(oemAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x80000, 0L);
                File privilegedProductAppDir = new File(Environment.getProductDirectory(), "priv-app");
                try {
                    privilegedProductAppDir = privilegedProductAppDir.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.scanDirTracedLI(privilegedProductAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x200000 | 0x40000, 0L);
                File productAppDir = new File(Environment.getProductDirectory(), "app");
                try {
                    productAppDir = productAppDir.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.scanDirTracedLI(productAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x200000, 0L);
                File privilegedProductServicesAppDir = new File(Environment.getProductServicesDirectory(), "priv-app");
                try {
                    privilegedProductServicesAppDir = privilegedProductServicesAppDir.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.scanDirTracedLI(privilegedProductServicesAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x400000 | 0x40000, 0L);
                File productServicesAppDir = new File(Environment.getProductServicesDirectory(), "app");
                try {
                    productServicesAppDir = productServicesAppDir.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.scanDirTracedLI(productServicesAppDir, this.mDefParseFlags | 0x10, scanFlags | 0x20000 | 0x400000, 0L);
                ArrayList<String> possiblyDeletedUpdatedSystemApps = new ArrayList<String>();
                ArrayList<String> stubSystemApps = new ArrayList<String>();
                if (!this.mOnlyCore) {
                    for (PackageParser.Package pkg : this.mPackages.values()) {
                        if (!pkg.isStub) continue;
                        stubSystemApps.add(pkg.packageName);
                    }
                    Iterator<PackageSetting> psit = this.mSettings.mPackages.values().iterator();
                    while (psit.hasNext()) {
                        PackageSetting ps = psit.next();
                        if ((ps.pkgFlags & 1) == 0) continue;
                        PackageParser.Package scannedPkg = this.mPackages.get(ps.name);
                        if (scannedPkg != null) {
                            if (!this.mSettings.isDisabledSystemPackageLPr(ps.name)) continue;
                            PackageManagerServiceUtils.logCriticalInfo(5, "Expecting better updated system app for " + ps.name + "; removing system app.  Last known codePath=" + ps.codePathString + ", versionCode=" + ps.versionCode + "; scanned versionCode=" + scannedPkg.getLongVersionCode());
                            this.removePackageLI(scannedPkg, true);
                            this.mExpectingBetter.put(ps.name, ps.codePath);
                            continue;
                        }
                        if (!this.mSettings.isDisabledSystemPackageLPr(ps.name)) {
                            psit.remove();
                            PackageManagerServiceUtils.logCriticalInfo(5, "System package " + ps.name + " no longer exists; it's data will be wiped");
                            continue;
                        }
                        PackageSetting disabledPs = this.mSettings.getDisabledSystemPkgLPr(ps.name);
                        if (disabledPs.codePath == null || !disabledPs.codePath.exists() || disabledPs.pkg == null) {
                            possiblyDeletedUpdatedSystemApps.add(ps.name);
                            continue;
                        }
                        this.mExpectingBetter.put(disabledPs.name, disabledPs.codePath);
                    }
                }
                this.deleteTempPackageFiles();
                int cachedSystemApps = PackageParser.sCachedPackageReadCount.get();
                this.mSettings.pruneSharedUsersLPw();
                long systemScanTime = SystemClock.uptimeMillis() - startTime;
                int systemPackagesCount = this.mPackages.size();
                Slog.i(TAG, "Finished scanning system apps. Time: " + systemScanTime + " ms, packageCount: " + systemPackagesCount + " , timePerPackage: " + (systemPackagesCount == 0 ? 0L : systemScanTime / (long)systemPackagesCount) + " , cached: " + cachedSystemApps);
                if (this.mIsUpgrade && systemPackagesCount > 0) {
                    MetricsLogger.histogram(null, "ota_package_manager_system_app_avg_scan_time", (int)systemScanTime / systemPackagesCount);
                }
                if (!this.mOnlyCore) {
                    String packageName;
                    int i5;
                    EventLog.writeEvent(3080, SystemClock.uptimeMillis());
                    this.scanDirTracedLI(sAppInstallDir, 0, scanFlags | 0x80, 0L);
                    for (i5 = possiblyDeletedUpdatedSystemApps.size() - 1; i5 >= 0; --i5) {
                        String msg;
                        packageName = (String)possiblyDeletedUpdatedSystemApps.get(i5);
                        PackageParser.Package pkg = this.mPackages.get(packageName);
                        this.mSettings.removeDisabledSystemPackageLPw(packageName);
                        if (pkg == null) {
                            msg = "Updated system package " + packageName + " no longer exists; removing its data";
                        } else {
                            msg = "Updated system package " + packageName + " no longer exists; rescanning package on data";
                            this.removePackageLI(pkg, true);
                            try {
                                File codePath = new File(pkg.applicationInfo.getCodePath());
                                this.scanPackageTracedLI(codePath, 0, scanFlags, 0L, null);
                            }
                            catch (PackageManagerException e) {
                                Slog.e(TAG, "Failed to parse updated, ex-system package: " + e.getMessage());
                            }
                        }
                        PackageSetting ps = this.mSettings.mPackages.get(packageName);
                        if (ps != null && this.mPackages.get(packageName) == null) {
                            this.removePackageDataLIF(ps, null, null, 0, false);
                        }
                        PackageManagerServiceUtils.logCriticalInfo(5, msg);
                    }
                    for (i5 = 0; i5 < this.mExpectingBetter.size(); ++i5) {
                        int rescanFlags;
                        int reparseFlags;
                        packageName = this.mExpectingBetter.keyAt(i5);
                        if (this.mPackages.containsKey(packageName)) continue;
                        File scanFile = this.mExpectingBetter.valueAt(i5);
                        PackageManagerServiceUtils.logCriticalInfo(5, "Expected better " + packageName + " but never showed up; reverting to system");
                        if (FileUtils.contains(privilegedAppDir, scanFile)) {
                            reparseFlags = this.mDefParseFlags | 0x10;
                            rescanFlags = scanFlags | 0x20000 | 0x40000;
                        } else if (FileUtils.contains(systemAppDir, scanFile)) {
                            reparseFlags = this.mDefParseFlags | 0x10;
                            rescanFlags = scanFlags | 0x20000;
                        } else if (FileUtils.contains(privilegedVendorAppDir, scanFile) || FileUtils.contains(privilegedOdmAppDir, scanFile)) {
                            reparseFlags = this.mDefParseFlags | 0x10;
                            rescanFlags = scanFlags | 0x20000 | 0x100000 | 0x40000;
                        } else if (FileUtils.contains(vendorAppDir, scanFile) || FileUtils.contains(odmAppDir, scanFile)) {
                            reparseFlags = this.mDefParseFlags | 0x10;
                            rescanFlags = scanFlags | 0x20000 | 0x100000;
                        } else if (FileUtils.contains(oemAppDir, scanFile)) {
                            reparseFlags = this.mDefParseFlags | 0x10;
                            rescanFlags = scanFlags | 0x20000 | 0x80000;
                        } else if (FileUtils.contains(privilegedProductAppDir, scanFile)) {
                            reparseFlags = this.mDefParseFlags | 0x10;
                            rescanFlags = scanFlags | 0x20000 | 0x200000 | 0x40000;
                        } else if (FileUtils.contains(productAppDir, scanFile)) {
                            reparseFlags = this.mDefParseFlags | 0x10;
                            rescanFlags = scanFlags | 0x20000 | 0x200000;
                        } else if (FileUtils.contains(privilegedProductServicesAppDir, scanFile)) {
                            reparseFlags = this.mDefParseFlags | 0x10;
                            rescanFlags = scanFlags | 0x20000 | 0x400000 | 0x40000;
                        } else if (FileUtils.contains(productServicesAppDir, scanFile)) {
                            reparseFlags = this.mDefParseFlags | 0x10;
                            rescanFlags = scanFlags | 0x20000 | 0x400000;
                        } else {
                            Slog.e(TAG, "Ignoring unexpected fallback path " + scanFile);
                            continue;
                        }
                        this.mSettings.enableSystemPackageLPw(packageName);
                        try {
                            this.scanPackageTracedLI(scanFile, reparseFlags, rescanFlags, 0L, null);
                            continue;
                        }
                        catch (PackageManagerException e) {
                            Slog.e(TAG, "Failed to parse original system package: " + e.getMessage());
                        }
                    }
                    this.installSystemStubPackages(stubSystemApps, scanFlags);
                    int cachedNonSystemApps = PackageParser.sCachedPackageReadCount.get() - cachedSystemApps;
                    long dataScanTime = SystemClock.uptimeMillis() - systemScanTime - startTime;
                    int dataPackagesCount = this.mPackages.size() - systemPackagesCount;
                    Slog.i(TAG, "Finished scanning non-system apps. Time: " + dataScanTime + " ms, packageCount: " + dataPackagesCount + " , timePerPackage: " + (dataPackagesCount == 0 ? 0L : dataScanTime / (long)dataPackagesCount) + " , cached: " + cachedNonSystemApps);
                    if (this.mIsUpgrade && dataPackagesCount > 0) {
                        MetricsLogger.histogram(null, "ota_package_manager_data_app_avg_scan_time", (int)dataScanTime / dataPackagesCount);
                    }
                }
                this.mExpectingBetter.clear();
                this.mStorageManagerPackage = this.getStorageManagerPackageName();
                this.mSetupWizardPackage = this.getSetupWizardPackageName();
                this.mComponentResolver.fixProtectedFilterPriorities();
                this.mSystemTextClassifierPackage = this.getSystemTextClassifierPackageName();
                this.mWellbeingPackage = this.getWellbeingPackageName();
                this.mDocumenterPackage = this.getDocumenterPackageName();
                this.mConfiguratorPackage = this.mContext.getString(17039716);
                this.mAppPredictionServicePackage = this.getAppPredictionServicePackageName();
                this.mIncidentReportApproverPackage = this.getIncidentReportApproverPackageName();
                this.updateAllSharedLibrariesLocked(null, Collections.unmodifiableMap(this.mPackages));
                for (SharedUserSetting setting : this.mSettings.getAllSharedUsersLPw()) {
                    List<String> changedAbiCodePath = PackageManagerService.adjustCpuAbisForSharedUserLPw(setting.packages, null);
                    if (changedAbiCodePath != null && changedAbiCodePath.size() > 0) {
                        for (i = changedAbiCodePath.size() - 1; i >= 0; --i) {
                            String codePathString = changedAbiCodePath.get(i);
                            try {
                                this.mInstaller.rmdex(codePathString, InstructionSets.getDexCodeInstructionSet(InstructionSets.getPreferredInstructionSet()));
                                continue;
                            }
                            catch (Installer.InstallerException e) {
                                // empty catch block
                            }
                        }
                    }
                    setting.fixSeInfoLocked();
                }
                this.mPackageUsage.read(this.mPackages);
                this.mCompilerStats.read();
                EventLog.writeEvent(3090, SystemClock.uptimeMillis());
                Slog.i(TAG, "Time to scan packages: " + (float)(SystemClock.uptimeMillis() - startTime) / 1000.0f + " seconds");
                boolean bl2 = sdkUpdated = ver.sdkVersion != this.mSdkVersion;
                if (sdkUpdated) {
                    Slog.i(TAG, "Platform changed from " + ver.sdkVersion + " to " + this.mSdkVersion + "; regranting permissions for internal storage");
                }
                this.mPermissionManager.updateAllPermissions(StorageManager.UUID_PRIVATE_INTERNAL, sdkUpdated, this.mPackages.values(), this.mPermissionCallback);
                ver.sdkVersion = this.mSdkVersion;
                if (!onlyCore && (this.mPromoteSystemApps || this.mFirstBoot)) {
                    for (UserInfo user : sUserManager.getUsers(true)) {
                        this.mSettings.applyDefaultPreferredAppsLPw(user.id);
                        this.primeDomainVerificationsLPw(user.id);
                    }
                }
                int storageFlags = StorageManager.isFileEncryptedNativeOrEmulated() ? 1 : 3;
                List<String> deferPackages = this.reconcileAppsDataLI(StorageManager.UUID_PRIVATE_INTERNAL, 0, storageFlags, true, true);
                this.mPrepareAppDataFuture = SystemServerInitThreadPool.get().submit(() -> {
                    TimingsTraceLog traceLog = new TimingsTraceLog("SystemServerTimingAsync", 262144L);
                    traceLog.traceBegin("AppDataFixup");
                    try {
                        this.mInstaller.fixupAppData(StorageManager.UUID_PRIVATE_INTERNAL, 3);
                    }
                    catch (Installer.InstallerException e) {
                        Slog.w(TAG, "Trouble fixing GIDs", e);
                    }
                    traceLog.traceEnd();
                    traceLog.traceBegin("AppDataPrepare");
                    if (deferPackages == null || deferPackages.isEmpty()) {
                        return;
                    }
                    int count = 0;
                    for (String pkgName : deferPackages) {
                        PackageParser.Package pkg = null;
                        Object object = this.mPackages;
                        synchronized (object) {
                            PackageSetting ps = this.mSettings.getPackageLPr(pkgName);
                            if (ps != null && ps.getInstalled(0)) {
                                pkg = ps.pkg;
                            }
                        }
                        if (pkg == null) continue;
                        object = this.mInstallLock;
                        synchronized (object) {
                            this.prepareAppDataAndMigrateLIF(pkg, 0, storageFlags, true);
                        }
                        ++count;
                    }
                    traceLog.traceEnd();
                    Slog.i(TAG, "Deferred reconcileAppsData finished " + count + " packages");
                }, "prepareAppData");
                if (this.mIsUpgrade && !onlyCore) {
                    Slog.i(TAG, "Build fingerprint changed; clearing code caches");
                    for (i = 0; i < this.mSettings.mPackages.size(); ++i) {
                        PackageSetting ps = this.mSettings.mPackages.valueAt(i);
                        if (!Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, ps.volumeUuid)) continue;
                        this.clearAppDataLIF(ps.pkg, -1, 39);
                    }
                    ver.fingerprint = Build.FINGERPRINT;
                }
                if (!onlyCore && this.mIsPreQUpgrade) {
                    Slog.i(TAG, "Whitelisting all existing apps to hide their icons");
                    int size = this.mSettings.mPackages.size();
                    for (int i6 = 0; i6 < size; ++i6) {
                        PackageSetting ps = this.mSettings.mPackages.valueAt(i6);
                        if ((ps.pkgFlags & 1) != 0) continue;
                        ps.disableComponentLPw(PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME, 0);
                    }
                }
                this.mExistingSystemPackages.clear();
                this.mPromoteSystemApps = false;
                ver.databaseVersion = 3;
                Trace.traceBegin(262144L, "write settings");
                this.mSettings.writeLPr();
                Trace.traceEnd(262144L);
                EventLog.writeEvent(3100, SystemClock.uptimeMillis());
                if (!this.mOnlyCore) {
                    this.mRequiredVerifierPackage = this.getRequiredButNotReallyRequiredVerifierLPr();
                    this.mRequiredInstallerPackage = this.getRequiredInstallerLPr();
                    this.mRequiredUninstallerPackage = this.getRequiredUninstallerLPr();
                    this.mIntentFilterVerifierComponent = this.getIntentFilterVerifierComponentNameLPr();
                    this.mIntentFilterVerifier = this.mIntentFilterVerifierComponent != null ? new IntentVerifierProxy(this.mContext, this.mIntentFilterVerifierComponent) : null;
                    this.mServicesSystemSharedLibraryPackageName = this.getRequiredSharedLibraryLPr("android.ext.services", -1);
                    this.mSharedSystemSharedLibraryPackageName = this.getRequiredSharedLibraryLPr("android.ext.shared", -1);
                } else {
                    this.mRequiredVerifierPackage = null;
                    this.mRequiredInstallerPackage = null;
                    this.mRequiredUninstallerPackage = null;
                    this.mIntentFilterVerifierComponent = null;
                    this.mIntentFilterVerifier = null;
                    this.mServicesSystemSharedLibraryPackageName = null;
                    this.mSharedSystemSharedLibraryPackageName = null;
                }
                this.mRequiredPermissionControllerPackage = this.getRequiredPermissionControllerLPr();
                int[] userIds = UserManagerService.getInstance().getUserIds();
                for (PackageParser.Package pkg : this.mPackages.values()) {
                    if (pkg.isSystem()) continue;
                    for (int userId : userIds) {
                        PackageSetting ps = (PackageSetting)pkg.mExtras;
                        if (ps == null || !ps.getInstantApp(userId) || !ps.getInstalled(userId)) continue;
                        this.mInstantAppRegistry.addInstantAppLPw(userId, ps.appId);
                    }
                }
                this.mInstallerService = new PackageInstallerService(context, this, this.mApexManager);
                Pair<ComponentName, String> instantAppResolverComponent = this.getInstantAppResolverLPr();
                if (instantAppResolverComponent != null) {
                    if (DEBUG_INSTANT) {
                        Slog.d(TAG, "Set ephemeral resolver: " + instantAppResolverComponent);
                    }
                    this.mInstantAppResolverConnection = new InstantAppResolverConnection(this.mContext, (ComponentName)instantAppResolverComponent.first, (String)instantAppResolverComponent.second);
                    this.mInstantAppResolverSettingsComponent = this.getInstantAppResolverSettingsLPr((ComponentName)instantAppResolverComponent.first);
                } else {
                    this.mInstantAppResolverConnection = null;
                    this.mInstantAppResolverSettingsComponent = null;
                }
                this.updateInstantAppInstallerLocked(null);
                HashMap<Integer, List<PackageInfo>> userPackages = new HashMap<Integer, List<PackageInfo>>();
                for (int userId : userIds) {
                    userPackages.put(userId, this.getInstalledPackages(0, userId).getList());
                }
                this.mDexManager.load(userPackages);
                if (this.mIsUpgrade) {
                    MetricsLogger.histogram(null, "ota_package_manager_init_time", (int)(SystemClock.uptimeMillis() - startTime));
                }
            }
        }
        this.mModuleInfoProvider = new ModuleInfoProvider(this.mContext, this);
        Trace.traceBegin(262144L, "GC");
        Runtime.getRuntime().gc();
        Trace.traceEnd(262144L);
        this.mInstaller.setWarnIfHeld(this.mPackages);
        PackageParser.readConfigUseRoundIcon(this.mContext.getResources());
        this.mServiceStartWithDelay = SystemClock.uptimeMillis() + 60000L;
        Trace.traceEnd(262144L);
    }

    private void installSystemStubPackages(List<String> systemStubPackageNames, int scanFlags) {
        int i;
        for (i = systemStubPackageNames.size() - 1; i >= 0; --i) {
            int enabledState;
            String packageName = systemStubPackageNames.get(i);
            if (this.mSettings.isDisabledSystemPackageLPr(packageName)) {
                systemStubPackageNames.remove(i);
                continue;
            }
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                systemStubPackageNames.remove(i);
                continue;
            }
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps != null && (enabledState = ps.getEnabled(0)) == 3) {
                systemStubPackageNames.remove(i);
                continue;
            }
            try {
                this.installStubPackageLI(pkg, 0, scanFlags);
                ps.setEnabled(0, 0, PLATFORM_PACKAGE_NAME);
                systemStubPackageNames.remove(i);
                continue;
            }
            catch (PackageManagerException e) {
                Slog.e(TAG, "Failed to parse uncompressed system package: " + e.getMessage());
            }
        }
        for (i = systemStubPackageNames.size() - 1; i >= 0; --i) {
            String pkgName = systemStubPackageNames.get(i);
            PackageSetting ps = this.mSettings.mPackages.get(pkgName);
            ps.setEnabled(2, 0, PLATFORM_PACKAGE_NAME);
            PackageManagerServiceUtils.logCriticalInfo(6, "Stub disabled; pkg: " + pkgName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enableCompressedPackage(PackageParser.Package stubPkg) {
        int parseFlags = this.mDefParseFlags | Integer.MIN_VALUE | 0x40;
        Object object = this.mInstallLock;
        synchronized (object) {
            PackageParser.Package pkg;
            try (PackageFreezer freezer = this.freezePackage(stubPkg.packageName, "setEnabledSetting");){
                pkg = this.installStubPackageLI(stubPkg, parseFlags, 0);
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    this.prepareAppDataAfterInstallLIF(pkg);
                    try {
                        this.updateSharedLibrariesLocked(pkg, null, this.mPackages);
                    }
                    catch (PackageManagerException e) {
                        Slog.e(TAG, "updateAllSharedLibrariesLPw failed: ", e);
                    }
                    this.mPermissionManager.updatePermissions(pkg.packageName, pkg, true, this.mPackages.values(), this.mPermissionCallback);
                    this.mSettings.writeLPr();
                }
            }
            catch (PackageManagerException e) {
                try (PackageFreezer freezer2 = this.freezePackage(stubPkg.packageName, "setEnabledSetting");){
                    ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                    synchronized (arrayMap) {
                        this.enableSystemPackageLPw(stubPkg);
                    }
                    this.installPackageFromSystemLIF(stubPkg.codePath, null, null, null, true);
                }
                catch (PackageManagerException pme) {
                    Slog.wtf(TAG, "Failed to restore system package:" + stubPkg.packageName, pme);
                }
                finally {
                    ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                    synchronized (arrayMap) {
                        PackageSetting stubPs = this.mSettings.mPackages.get(stubPkg.packageName);
                        if (stubPs != null) {
                            stubPs.setEnabled(2, 0, PLATFORM_PACKAGE_NAME);
                        }
                        this.mSettings.writeLPr();
                    }
                }
                return false;
            }
            this.clearAppDataLIF(pkg, -1, 39);
            this.mDexManager.notifyPackageUpdated(pkg.packageName, pkg.baseCodePath, pkg.splitCodePaths);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package installStubPackageLI(PackageParser.Package stubPkg, int parseFlags, int scanFlags) throws PackageManagerException {
        File scanFile;
        if (DEBUG_COMPRESSION) {
            Slog.i(TAG, "Uncompressing system stub; pkg: " + stubPkg.packageName);
        }
        if ((scanFile = this.decompressPackage(stubPkg.packageName, stubPkg.codePath)) == null) {
            throw new PackageManagerException("Unable to decompress stub at " + stubPkg.codePath);
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mSettings.disableSystemPackageLPw(stubPkg.packageName, true);
        }
        this.removePackageLI(stubPkg, true);
        try {
            return this.scanPackageTracedLI(scanFile, parseFlags, scanFlags, 0L, null);
        }
        catch (PackageManagerException e) {
            Slog.w(TAG, "Failed to install compressed system package:" + stubPkg.packageName, e);
            this.removeCodePathLI(scanFile);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File decompressPackage(String packageName, String codePath) {
        File[] compressedFiles = PackageManagerServiceUtils.getCompressedFiles(codePath);
        if (compressedFiles == null || compressedFiles.length == 0) {
            if (DEBUG_COMPRESSION) {
                Slog.i(TAG, "No files to decompress: " + codePath);
            }
            return null;
        }
        File dstCodePath = this.getNextCodePath(Environment.getDataAppDirectory(null), packageName);
        int ret = 1;
        try {
            Os.mkdir(dstCodePath.getAbsolutePath(), 493);
            Os.chmod(dstCodePath.getAbsolutePath(), 493);
            for (File srcFile : compressedFiles) {
                String srcFileName = srcFile.getName();
                String dstFileName = srcFileName.substring(0, srcFileName.length() - COMPRESSED_EXTENSION.length());
                File dstFile = new File(dstCodePath, dstFileName);
                ret = PackageManagerServiceUtils.decompressFile(srcFile, dstFile);
                if (ret == 1) continue;
                PackageManagerServiceUtils.logCriticalInfo(6, "Failed to decompress; pkg: " + packageName + ", file: " + dstFileName);
                break;
            }
        }
        catch (ErrnoException e) {
            PackageManagerServiceUtils.logCriticalInfo(6, "Failed to decompress; pkg: " + packageName + ", err: " + e.errno);
        }
        if (ret == 1) {
            File libraryRoot = new File(dstCodePath, "lib");
            NativeLibraryHelper.Handle handle = null;
            try {
                handle = NativeLibraryHelper.Handle.create(dstCodePath);
                ret = NativeLibraryHelper.copyNativeBinariesWithOverride(handle, libraryRoot, null);
            }
            catch (IOException e) {
                PackageManagerServiceUtils.logCriticalInfo(6, "Failed to extract native libraries; pkg: " + packageName);
                ret = -110;
            }
            finally {
                IoUtils.closeQuietly(handle);
            }
        }
        if (ret != 1) {
            if (!dstCodePath.exists()) {
                return null;
            }
            this.removeCodePathLI(dstCodePath);
            return null;
        }
        return dstCodePath;
    }

    @GuardedBy(value={"mPackages"})
    private void updateInstantAppInstallerLocked(String modifiedPackage) {
        if (this.mInstantAppInstallerActivity != null && !this.mInstantAppInstallerActivity.getComponentName().getPackageName().equals(modifiedPackage)) {
            return;
        }
        this.setUpInstantAppInstallerActivityLP(this.getInstantAppInstallerLPr());
    }

    private static File preparePackageParserCache() {
        if (Build.IS_ENG) {
            return null;
        }
        if (SystemProperties.getBoolean("pm.boot.disable_package_cache", false)) {
            Slog.i(TAG, "Disabling package parser cache due to system property.");
            return null;
        }
        File cacheBaseDir = Environment.getPackageCacheDirectory();
        if (!FileUtils.createDir(cacheBaseDir)) {
            return null;
        }
        String cacheName = SystemProperties.digestOf("ro.build.fingerprint", "persist.sys.isolated_storage", "sys.isolated_storage_snapshot");
        for (File cacheDir : FileUtils.listFilesOrEmpty(cacheBaseDir)) {
            if (Objects.equals(cacheName, cacheDir.getName())) {
                Slog.d(TAG, "Keeping known cache " + cacheDir.getName());
                continue;
            }
            Slog.d(TAG, "Destroying unknown cache " + cacheDir.getName());
            FileUtils.deleteContentsAndDir(cacheDir);
        }
        File cacheDir = FileUtils.createDir(cacheBaseDir, cacheName);
        if (cacheDir == null) {
            Slog.wtf(TAG, "Cache directory cannot be created - wiping base dir " + cacheBaseDir);
            FileUtils.deleteContentsAndDir(cacheBaseDir);
            return null;
        }
        if (Build.IS_USERDEBUG && Build.VERSION.INCREMENTAL.startsWith("eng.")) {
            Slog.w(TAG, "Wiping cache directory because the system partition changed.");
            File frameworkDir = new File(Environment.getRootDirectory(), "framework");
            if (cacheDir.lastModified() < frameworkDir.lastModified()) {
                FileUtils.deleteContents(cacheBaseDir);
                cacheDir = FileUtils.createDir(cacheBaseDir, cacheName);
            }
        }
        return cacheDir;
    }

    @Override
    public boolean isFirstBoot() {
        return this.mFirstBoot;
    }

    @Override
    public boolean isOnlyCoreApps() {
        return this.mOnlyCore;
    }

    @Override
    public boolean isDeviceUpgrading() {
        return this.mIsUpgrade || SystemProperties.getBoolean("persist.pm.mock-upgrade", false);
    }

    private String getRequiredButNotReallyRequiredVerifierLPr() {
        Intent intent = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
        List<ResolveInfo> matches = this.queryIntentReceiversInternal(intent, PACKAGE_MIME_TYPE, 0x1C0000, 0, false);
        if (matches.size() == 1) {
            return matches.get((int)0).getComponentInfo().packageName;
        }
        if (matches.size() == 0) {
            Log.e(TAG, "There should probably be a verifier, but, none were found");
            return null;
        }
        throw new RuntimeException("There must be exactly one verifier; found " + matches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequiredSharedLibraryLPr(String name, int version) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SharedLibraryInfo libraryInfo = this.getSharedLibraryInfoLPr(name, version);
            if (libraryInfo == null) {
                throw new IllegalStateException("Missing required shared library:" + name);
            }
            String packageName = libraryInfo.getPackageName();
            if (packageName == null) {
                throw new IllegalStateException("Expected a package for shared library " + name);
            }
            return packageName;
        }
    }

    private String getRequiredInstallerLPr() {
        Intent intent = new Intent("android.intent.action.INSTALL_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setDataAndType(Uri.parse("content://com.example/foo.apk"), PACKAGE_MIME_TYPE);
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, PACKAGE_MIME_TYPE, 0x1C0000, 0);
        if (matches.size() == 1) {
            ResolveInfo resolveInfo = matches.get(0);
            if (!resolveInfo.activityInfo.applicationInfo.isPrivilegedApp()) {
                throw new RuntimeException("The installer must be a privileged app");
            }
            return matches.get((int)0).getComponentInfo().packageName;
        }
        throw new RuntimeException("There must be exactly one installer; found " + matches);
    }

    private String getRequiredUninstallerLPr() {
        Intent intent = new Intent("android.intent.action.UNINSTALL_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setData(Uri.fromParts(PACKAGE_SCHEME, "foo.bar", null));
        ResolveInfo resolveInfo = this.resolveIntent(intent, null, 0x1C0000, 0);
        if (resolveInfo == null || this.mResolveActivity.name.equals(resolveInfo.getComponentInfo().name)) {
            throw new RuntimeException("There must be exactly one uninstaller; found " + resolveInfo);
        }
        return resolveInfo.getComponentInfo().packageName;
    }

    private String getRequiredPermissionControllerLPr() {
        Intent intent = new Intent("android.intent.action.MANAGE_PERMISSIONS");
        intent.addCategory("android.intent.category.DEFAULT");
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, null, 0x1C0000, 0);
        if (matches.size() == 1) {
            ResolveInfo resolveInfo = matches.get(0);
            if (!resolveInfo.activityInfo.applicationInfo.isPrivilegedApp()) {
                throw new RuntimeException("The permissions manager must be a privileged app");
            }
            return matches.get((int)0).getComponentInfo().packageName;
        }
        throw new RuntimeException("There must be exactly one permissions manager; found " + matches);
    }

    private ComponentName getIntentFilterVerifierComponentNameLPr() {
        Intent intent = new Intent("android.intent.action.INTENT_FILTER_NEEDS_VERIFICATION");
        List<ResolveInfo> matches = this.queryIntentReceiversInternal(intent, PACKAGE_MIME_TYPE, 0x1C0000, 0, false);
        ResolveInfo best = null;
        int N = matches.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo cur = matches.get(i);
            String packageName = cur.getComponentInfo().packageName;
            if (this.checkPermission("android.permission.INTENT_FILTER_VERIFICATION_AGENT", packageName, 0) != 0 || best != null && cur.priority <= best.priority) continue;
            best = cur;
        }
        if (best != null) {
            return best.getComponentInfo().getComponentName();
        }
        Slog.w(TAG, "Intent filter verifier not found");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getInstantAppResolverComponent() {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Pair<ComponentName, String> instantAppResolver = this.getInstantAppResolverLPr();
            if (instantAppResolver == null) {
                return null;
            }
            return (ComponentName)instantAppResolver.first;
        }
    }

    private Pair<ComponentName, String> getInstantAppResolverLPr() {
        int callingUid;
        String[] packageArray = this.mContext.getResources().getStringArray(17236020);
        if (packageArray.length == 0 && !Build.IS_DEBUGGABLE) {
            if (DEBUG_INSTANT) {
                Slog.d(TAG, "Ephemeral resolver NOT found; empty package list");
            }
            return null;
        }
        String actionName = "android.intent.action.RESOLVE_INSTANT_APP_PACKAGE";
        Intent resolverIntent = new Intent(actionName);
        int resolveFlags = 0xC0000 | (!Build.IS_DEBUGGABLE ? 0x100000 : 0);
        List<ResolveInfo> resolvers = this.queryIntentServicesInternal(resolverIntent, null, resolveFlags, 0, callingUid = Binder.getCallingUid(), false);
        int N = resolvers.size();
        if (N == 0) {
            if (DEBUG_INSTANT) {
                Slog.d(TAG, "Ephemeral resolver NOT found; no matching intent filters");
            }
            return null;
        }
        ArraySet<String> possiblePackages = new ArraySet<String>(Arrays.asList(packageArray));
        for (int i = 0; i < N; ++i) {
            ResolveInfo info = resolvers.get(i);
            if (info.serviceInfo == null) continue;
            String packageName = info.serviceInfo.packageName;
            if (!possiblePackages.contains(packageName) && !Build.IS_DEBUGGABLE) {
                if (!DEBUG_INSTANT) continue;
                Slog.d(TAG, "Ephemeral resolver not in allowed package list; pkg: " + packageName + ", info:" + info);
                continue;
            }
            if (DEBUG_INSTANT) {
                Slog.v(TAG, "Ephemeral resolver found; pkg: " + packageName + ", info:" + info);
            }
            return new Pair<ComponentName, String>(new ComponentName(packageName, info.serviceInfo.name), actionName);
        }
        if (DEBUG_INSTANT) {
            Slog.v(TAG, "Ephemeral resolver NOT found");
        }
        return null;
    }

    @GuardedBy(value={"mPackages"})
    private ActivityInfo getInstantAppInstallerLPr() {
        String[] stringArray;
        if (Build.IS_ENG) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "android.intent.action.INSTALL_INSTANT_APP_PACKAGE_TEST";
            stringArray = stringArray2;
            stringArray2[1] = "android.intent.action.INSTALL_INSTANT_APP_PACKAGE";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "android.intent.action.INSTALL_INSTANT_APP_PACKAGE";
        }
        String[] orderedActions = stringArray;
        int resolveFlags = 0xC0200 | (!Build.IS_ENG ? 0x100000 : 0);
        Intent intent = new Intent();
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setDataAndType(Uri.fromFile(new File("foo.apk")), PACKAGE_MIME_TYPE);
        List<ResolveInfo> matches = null;
        for (String action : orderedActions) {
            intent.setAction(action);
            matches = this.queryIntentActivitiesInternal(intent, PACKAGE_MIME_TYPE, resolveFlags, 0);
            if (!matches.isEmpty()) break;
            if (!DEBUG_INSTANT) continue;
            Slog.d(TAG, "Instant App installer not found with " + action);
        }
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            PermissionsState permissionsState;
            ResolveInfo rInfo = (ResolveInfo)iter.next();
            PackageSetting ps = this.mSettings.mPackages.get(rInfo.activityInfo.packageName);
            if (ps != null && ((permissionsState = ps.getPermissionsState()).hasPermission("android.permission.INSTALL_PACKAGES", 0) || Build.IS_ENG)) continue;
            iter.remove();
        }
        if (matches.size() == 0) {
            return null;
        }
        if (matches.size() == 1) {
            return (ActivityInfo)matches.get(0).getComponentInfo();
        }
        throw new RuntimeException("There must be at most one ephemeral installer; found " + matches);
    }

    private ComponentName getInstantAppResolverSettingsLPr(ComponentName resolver) {
        Intent intent = new Intent("android.intent.action.INSTANT_APP_RESOLVER_SETTINGS").addCategory("android.intent.category.DEFAULT").setPackage(resolver.getPackageName());
        int resolveFlags = 786432;
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, null, 786432, 0);
        if (matches.isEmpty()) {
            return null;
        }
        return matches.get(0).getComponentInfo().getComponentName();
    }

    @GuardedBy(value={"mPackages"})
    private void primeDomainVerificationsLPw(int userId) {
        SystemConfig systemConfig = SystemConfig.getInstance();
        ArraySet<String> packages = systemConfig.getLinkedApps();
        for (String packageName : packages) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg != null) {
                if (!pkg.isSystem()) {
                    Slog.w(TAG, "Non-system app '" + packageName + "' in sysconfig <app-link>");
                    continue;
                }
                ArraySet<String> domains = null;
                for (PackageParser.Activity a : pkg.activities) {
                    for (PackageParser.ActivityIntentInfo filter : a.intents) {
                        if (!PackageManagerService.hasValidDomains(filter)) continue;
                        if (domains == null) {
                            domains = new ArraySet<String>();
                        }
                        domains.addAll(filter.getHostsList());
                    }
                }
                if (domains != null && domains.size() > 0) {
                    IntentFilterVerificationInfo ivi = this.mSettings.createIntentFilterVerificationIfNeededLPw(packageName, domains);
                    ivi.setStatus(0);
                    this.mSettings.updateIntentFilterVerificationStatusLPw(packageName, 2, userId);
                    continue;
                }
                Slog.w(TAG, "Sysconfig <app-link> package '" + packageName + "' does not handle web links");
                continue;
            }
            Slog.w(TAG, "Unknown package " + packageName + " in sysconfig <app-link>");
        }
        this.scheduleWritePackageRestrictionsLocked(userId);
        this.scheduleWriteSettingsLocked();
    }

    private boolean packageIsBrowser(String packageName, int userId) {
        List<ResolveInfo> list = this.queryIntentActivitiesInternal(sBrowserIntent, null, 131072, userId);
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo info = list.get(i);
            if (info.priority < 0 || !packageName.equals(info.activityInfo.packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException) && !(e instanceof IllegalArgumentException)) {
                Slog.wtf(TAG, "Package Manager Crash", e);
            }
            throw e;
        }
    }

    private boolean canViewInstantApps(int callingUid, int userId) {
        if (callingUid < 10000) {
            return true;
        }
        if (this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_INSTANT_APPS") == 0) {
            return true;
        }
        if (this.mContext.checkCallingOrSelfPermission("android.permission.VIEW_INSTANT_APPS") == 0) {
            ComponentName homeComponent = this.getDefaultHomeActivity(userId);
            if (homeComponent != null && this.isCallerSameApp(homeComponent.getPackageName(), callingUid)) {
                return true;
            }
            if (this.mAppPredictionServicePackage != null && this.isCallerSameApp(this.mAppPredictionServicePackage, callingUid)) {
                return true;
            }
        }
        return false;
    }

    private PackageInfo generatePackageInfo(PackageSetting ps, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        if (ps == null) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        if (this.filterAppAccessLPr(ps, callingUid, userId)) {
            return null;
        }
        if ((flags & 0x2000) != 0 && ps.isSystem()) {
            flags |= 0x400000;
        }
        PackageUserState state = ps.readUserState(userId);
        PackageParser.Package p = ps.pkg;
        if (p != null) {
            Set<String> permissions;
            PermissionsState permissionsState = ps.getPermissionsState();
            int[] gids = (flags & 0x100) == 0 ? EMPTY_INT_ARRAY : permissionsState.computeGids(userId);
            PackageInfo packageInfo = PackageParser.generatePackageInfo(p, gids, flags, ps.firstInstallTime, ps.lastUpdateTime, permissions = ArrayUtils.isEmpty(p.requestedPermissions) ? Collections.emptySet() : permissionsState.getPermissions(userId), state, userId);
            if (packageInfo == null) {
                return null;
            }
            packageInfo.packageName = packageInfo.applicationInfo.packageName = this.resolveExternalPackageNameLPr(p);
            return packageInfo;
        }
        if ((flags & 0x2000) != 0 && state.isAvailable(flags)) {
            PackageInfo pi = new PackageInfo();
            pi.packageName = ps.name;
            pi.setLongVersionCode(ps.versionCode);
            pi.sharedUserId = ps.sharedUser != null ? ps.sharedUser.name : null;
            pi.firstInstallTime = ps.firstInstallTime;
            pi.lastUpdateTime = ps.lastUpdateTime;
            ApplicationInfo ai = new ApplicationInfo();
            ai.packageName = ps.name;
            ai.uid = UserHandle.getUid(userId, ps.appId);
            ai.primaryCpuAbi = ps.primaryCpuAbiString;
            ai.secondaryCpuAbi = ps.secondaryCpuAbiString;
            ai.setVersionCode(ps.versionCode);
            ai.flags = ps.pkgFlags;
            ai.privateFlags = ps.pkgPrivateFlags;
            pi.applicationInfo = PackageParser.generateApplicationInfo(ai, flags, state, userId);
            return pi;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPackageStartable(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            throw new SecurityException("Instant applications don't have access to this method");
        }
        boolean userKeyUnlocked = StorageManager.isUserKeyUnlocked(userId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || this.filterAppAccessLPr(ps, callingUid, userId)) {
                throw new SecurityException("Package " + packageName + " was not found!");
            }
            if (!ps.getInstalled(userId)) {
                throw new SecurityException("Package " + packageName + " was not installed for user " + userId + "!");
            }
            if (this.mSafeMode && !ps.isSystem()) {
                throw new SecurityException("Package " + packageName + " not a system app!");
            }
            if (this.mFrozenPackages.contains(packageName)) {
                throw new SecurityException("Package " + packageName + " is currently frozen!");
            }
            if (!userKeyUnlocked && !ps.pkg.applicationInfo.isEncryptionAware()) {
                throw new SecurityException("Package " + packageName + " is not encryption aware!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageAvailable(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return false;
        }
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "is package available");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageUserState state;
                PackageSetting ps = (PackageSetting)p.mExtras;
                if (this.filterAppAccessLPr(ps, callingUid, userId)) {
                    return false;
                }
                if (ps != null && (state = ps.readUserState(userId)) != null) {
                    return PackageParser.isAvailable(state);
                }
            }
            return false;
        }
    }

    @Override
    public PackageInfo getPackageInfo(String packageName, int flags, int userId) {
        return this.getPackageInfoInternal(packageName, -1L, flags, Binder.getCallingUid(), userId);
    }

    @Override
    public PackageInfo getPackageInfoVersioned(VersionedPackage versionedPackage, int flags, int userId) {
        return this.getPackageInfoInternal(versionedPackage.getPackageName(), versionedPackage.getLongVersionCode(), flags, Binder.getCallingUid(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageInfo getPackageInfoInternal(String packageName, long versionCode, int flags, int filterCallingUid, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        flags = this.updateFlagsForPackage(flags, userId, packageName);
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get package info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean matchFactoryOnly;
            packageName = this.resolveInternalPackageNameLPr(packageName, versionCode);
            boolean bl = matchFactoryOnly = (flags & 0x200000) != 0;
            if (matchFactoryOnly) {
                if ((flags & 0x40000000) != 0) {
                    return this.mApexManager.getPackageInfo(packageName, 2);
                }
                PackageSetting ps = this.mSettings.getDisabledSystemPkgLPr(packageName);
                if (ps != null) {
                    if (this.filterSharedLibPackageLPr(ps, filterCallingUid, userId, flags)) {
                        return null;
                    }
                    if (this.filterAppAccessLPr(ps, filterCallingUid, userId)) {
                        return null;
                    }
                    return this.generatePackageInfo(ps, flags, userId);
                }
            }
            PackageParser.Package p = this.mPackages.get(packageName);
            if (matchFactoryOnly && p != null && !PackageManagerService.isSystemApp(p)) {
                return null;
            }
            if (p != null) {
                PackageSetting ps = (PackageSetting)p.mExtras;
                if (this.filterSharedLibPackageLPr(ps, filterCallingUid, userId, flags)) {
                    return null;
                }
                if (ps != null && this.filterAppAccessLPr(ps, filterCallingUid, userId)) {
                    return null;
                }
                return this.generatePackageInfo((PackageSetting)p.mExtras, flags, userId);
            }
            if (!matchFactoryOnly && (flags & 0x402000) != 0) {
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) {
                    return null;
                }
                if (this.filterSharedLibPackageLPr(ps, filterCallingUid, userId, flags)) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, filterCallingUid, userId)) {
                    return null;
                }
                return this.generatePackageInfo(ps, flags, userId);
            }
            if (!matchFactoryOnly && (flags & 0x40000000) != 0) {
                return this.mApexManager.getPackageInfo(packageName, 1);
            }
            return null;
        }
    }

    private boolean isComponentVisibleToInstantApp(ComponentName component) {
        if (this.isComponentVisibleToInstantApp(component, 1)) {
            return true;
        }
        if (this.isComponentVisibleToInstantApp(component, 3)) {
            return true;
        }
        return this.isComponentVisibleToInstantApp(component, 4);
    }

    private boolean isComponentVisibleToInstantApp(ComponentName component, int type) {
        if (type == 1) {
            PackageParser.Activity activity = this.mComponentResolver.getActivity(component);
            if (activity == null) {
                return false;
            }
            boolean visibleToInstantApp = (activity.info.flags & 0x100000) != 0;
            boolean explicitlyVisibleToInstantApp = (activity.info.flags & 0x200000) == 0;
            return visibleToInstantApp && explicitlyVisibleToInstantApp;
        }
        if (type == 2) {
            PackageParser.Activity activity = this.mComponentResolver.getReceiver(component);
            if (activity == null) {
                return false;
            }
            boolean visibleToInstantApp = (activity.info.flags & 0x100000) != 0;
            boolean explicitlyVisibleToInstantApp = (activity.info.flags & 0x200000) == 0;
            return visibleToInstantApp && !explicitlyVisibleToInstantApp;
        }
        if (type == 3) {
            PackageParser.Service service = this.mComponentResolver.getService(component);
            return service != null ? (service.info.flags & 0x100000) != 0 : false;
        }
        if (type == 4) {
            PackageParser.Provider provider = this.mComponentResolver.getProvider(component);
            return provider != null ? (provider.info.flags & 0x100000) != 0 : false;
        }
        if (type == 0) {
            return this.isComponentVisibleToInstantApp(component);
        }
        return false;
    }

    @GuardedBy(value={"mPackages"})
    private boolean filterAppAccessLPr(PackageSetting ps, int callingUid, ComponentName component, int componentType, int userId) {
        String instantAppPkgName;
        boolean callerIsInstantApp;
        if (Process.isIsolated(callingUid)) {
            callingUid = this.mIsolatedOwners.get(callingUid);
        }
        boolean bl = callerIsInstantApp = (instantAppPkgName = this.getInstantAppPackageName(callingUid)) != null;
        if (ps == null) {
            return callerIsInstantApp;
        }
        if (this.isCallerSameApp(ps.name, callingUid)) {
            return false;
        }
        if (callerIsInstantApp) {
            if (ps.getInstantApp(userId)) {
                return true;
            }
            if (component != null) {
                PackageParser.Instrumentation instrumentation = this.mInstrumentation.get(component);
                if (instrumentation != null && this.isCallerSameApp(instrumentation.info.targetPackage, callingUid)) {
                    return false;
                }
                return !this.isComponentVisibleToInstantApp(component, componentType);
            }
            return !ps.pkg.visibleToInstantApps;
        }
        if (ps.getInstantApp(userId)) {
            if (this.canViewInstantApps(callingUid, userId)) {
                return false;
            }
            if (component != null) {
                return true;
            }
            return !this.mInstantAppRegistry.isInstantAccessGranted(userId, UserHandle.getAppId(callingUid), ps.appId);
        }
        return false;
    }

    @GuardedBy(value={"mPackages"})
    private boolean filterAppAccessLPr(PackageSetting ps, int callingUid, int userId) {
        return this.filterAppAccessLPr(ps, callingUid, null, 0, userId);
    }

    @GuardedBy(value={"mPackages"})
    private boolean filterSharedLibPackageLPr(PackageSetting ps, int uid, int userId, int flags) {
        if ((flags & 0x4000000) != 0) {
            int appId = UserHandle.getAppId(uid);
            if (appId == 1000 || appId == 2000 || appId == 0) {
                return false;
            }
            if (0 == this.checkUidPermission("android.permission.INSTALL_PACKAGES", uid)) {
                return false;
            }
        }
        if (ps == null || ps.pkg == null || !ps.pkg.applicationInfo.isStaticSharedLibrary()) {
            return false;
        }
        SharedLibraryInfo libraryInfo = this.getSharedLibraryInfoLPr(ps.pkg.staticSharedLibName, ps.pkg.staticSharedLibVersion);
        if (libraryInfo == null) {
            return false;
        }
        int resolvedUid = UserHandle.getUid(userId, UserHandle.getAppId(uid));
        String[] uidPackageNames = this.getPackagesForUid(resolvedUid);
        if (uidPackageNames == null) {
            return true;
        }
        for (String uidPackageName : uidPackageNames) {
            int index;
            if (ps.name.equals(uidPackageName)) {
                return false;
            }
            PackageSetting uidPs = this.mSettings.getPackageLPr(uidPackageName);
            if (uidPs == null || (index = ArrayUtils.indexOf(uidPs.usesStaticLibraries, libraryInfo.getName())) < 0 || uidPs.pkg.usesStaticLibrariesVersions[index] != libraryInfo.getLongVersion()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] currentToCanonicalPackageNames(String[] names) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return names;
        }
        String[] out = new String[names.length];
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int callingUserId = UserHandle.getUserId(callingUid);
            boolean canViewInstantApps = this.canViewInstantApps(callingUid, callingUserId);
            for (int i = names.length - 1; i >= 0; --i) {
                PackageSetting ps = this.mSettings.mPackages.get(names[i]);
                boolean translateName = false;
                if (ps != null && ps.realName != null) {
                    boolean targetIsInstantApp = ps.getInstantApp(callingUserId);
                    translateName = !targetIsInstantApp || canViewInstantApps || this.mInstantAppRegistry.isInstantAccessGranted(callingUserId, UserHandle.getAppId(callingUid), ps.appId);
                }
                out[i] = translateName ? ps.realName : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] canonicalToCurrentPackageNames(String[] names) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return names;
        }
        String[] out = new String[names.length];
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int callingUserId = UserHandle.getUserId(callingUid);
            boolean canViewInstantApps = this.canViewInstantApps(callingUid, callingUserId);
            for (int i = names.length - 1; i >= 0; --i) {
                String cur = this.mSettings.getRenamedPackageLPr(names[i]);
                boolean translateName = false;
                if (cur != null) {
                    PackageSetting ps = this.mSettings.mPackages.get(names[i]);
                    boolean targetIsInstantApp = ps != null && ps.getInstantApp(callingUserId);
                    translateName = !targetIsInstantApp || canViewInstantApps || this.mInstantAppRegistry.isInstantAccessGranted(callingUserId, UserHandle.getAppId(callingUid), ps.appId);
                }
                out[i] = translateName ? cur : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageUid(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return -1;
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForPackage(flags, userId, packageName);
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "getPackageUid");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null && p.isMatch(flags)) {
                PackageSetting ps2 = (PackageSetting)p.mExtras;
                if (this.filterAppAccessLPr(ps2, callingUid, userId)) {
                    return -1;
                }
                return UserHandle.getUid(userId, p.applicationInfo.uid);
            }
            if ((flags & 0x402000) != 0 && (ps = this.mSettings.mPackages.get(packageName)) != null && ps.isMatch(flags) && !this.filterAppAccessLPr(ps, callingUid, userId)) {
                return UserHandle.getUid(userId, ps.appId);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTargetSdkInUidLowerThan(int uid, int higherTargetSDK) {
        int userId = UserHandle.getUserId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SettingBase obj = this.mSettings.getSettingLPr(UserHandle.getAppId(uid));
            if (obj == null) {
                return false;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                if (!ps.getInstalled(userId)) {
                    return false;
                }
                return ps.pkg.applicationInfo.targetSdkVersion < higherTargetSDK;
            }
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                int numPkgs = sus.packages.size();
                for (int i = 0; i < numPkgs; ++i) {
                    PackageSetting ps = sus.packages.valueAt(i);
                    if (!ps.getInstalled(userId) || ps.pkg.applicationInfo.targetSdkVersion >= higherTargetSDK) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getPackageGids(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForPackage(flags, userId, packageName);
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "getPackageGids");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null && p.isMatch(flags)) {
                PackageSetting ps2 = (PackageSetting)p.mExtras;
                if (this.filterAppAccessLPr(ps2, callingUid, userId)) {
                    return null;
                }
                return ps2.getPermissionsState().computeGids(userId);
            }
            if ((flags & 0x402000) != 0 && (ps = this.mSettings.mPackages.get(packageName)) != null && ps.isMatch(flags) && !this.filterAppAccessLPr(ps, callingUid, userId)) {
                return ps.getPermissionsState().computeGids(userId);
            }
            return null;
        }
    }

    @Override
    public PermissionInfo getPermissionInfo(String name, String packageName, int flags) {
        return this.mPermissionManager.getPermissionInfo(name, packageName, flags, PackageManagerService.getCallingUid());
    }

    @Override
    public ParceledListSlice<PermissionInfo> queryPermissionsByGroup(String groupName, int flags) {
        List<PermissionInfo> permissionList = this.mPermissionManager.getPermissionInfoByGroup(groupName, flags, PackageManagerService.getCallingUid());
        return permissionList == null ? null : new ParceledListSlice<PermissionInfo>(permissionList);
    }

    @Override
    public PermissionGroupInfo getPermissionGroupInfo(String groupName, int flags) {
        return this.mPermissionManager.getPermissionGroupInfo(groupName, flags, PackageManagerService.getCallingUid());
    }

    @Override
    public ParceledListSlice<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        List<PermissionGroupInfo> permissionList = this.mPermissionManager.getAllPermissionGroups(flags, PackageManagerService.getCallingUid());
        return permissionList == null ? ParceledListSlice.emptyList() : new ParceledListSlice<PermissionGroupInfo>(permissionList);
    }

    @GuardedBy(value={"mPackages"})
    private ApplicationInfo generateApplicationInfoFromSettingsLPw(String packageName, int flags, int filterCallingUid, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null) {
            if (this.filterSharedLibPackageLPr(ps, filterCallingUid, userId, flags)) {
                return null;
            }
            if (this.filterAppAccessLPr(ps, filterCallingUid, userId)) {
                return null;
            }
            if (ps.pkg == null) {
                PackageInfo pInfo = this.generatePackageInfo(ps, flags, userId);
                if (pInfo != null) {
                    return pInfo.applicationInfo;
                }
                return null;
            }
            ApplicationInfo ai = PackageParser.generateApplicationInfo(ps.pkg, flags, ps.readUserState(userId), userId);
            if (ai != null) {
                ai.packageName = this.resolveExternalPackageNameLPr(ps.pkg);
            }
            return ai;
        }
        return null;
    }

    @Override
    public ApplicationInfo getApplicationInfo(String packageName, int flags, int userId) {
        return this.getApplicationInfoInternal(packageName, flags, Binder.getCallingUid(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationInfo getApplicationInfoInternal(String packageName, int flags, int filterCallingUid, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        flags = this.updateFlagsForApplication(flags, userId, packageName);
        if (!this.isRecentsAccessingChildProfiles(Binder.getCallingUid(), userId)) {
            this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get application info");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            packageName = this.resolveInternalPackageNameLPr(packageName, -1L);
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) {
                    return null;
                }
                if (this.filterSharedLibPackageLPr(ps, filterCallingUid, userId, flags)) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, filterCallingUid, userId)) {
                    return null;
                }
                ApplicationInfo ai = PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId);
                if (ai != null) {
                    ai.packageName = this.resolveExternalPackageNameLPr(p);
                }
                return ai;
            }
            if (PLATFORM_PACKAGE_NAME.equals(packageName) || "system".equals(packageName)) {
                return this.mAndroidApplication;
            }
            if ((flags & 0x402000) != 0) {
                return this.generateApplicationInfoFromSettingsLPw(packageName, flags, filterCallingUid, userId);
            }
            return null;
        }
    }

    @GuardedBy(value={"mPackages"})
    private String normalizePackageNameLPr(String packageName) {
        String normalizedPackageName = this.mSettings.getRenamedPackageLPr(packageName);
        return normalizedPackageName != null ? normalizedPackageName : packageName;
    }

    @Override
    public void deletePreloadsFileCache() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", "deletePreloadsFileCache");
        File dir = Environment.getDataPreloadsFileCacheDirectory();
        Slog.i(TAG, "Deleting preloaded file cache " + dir);
        FileUtils.deleteContents(dir);
    }

    @Override
    public void freeStorageAndNotify(String volumeUuid, long freeStorageSize, int storageFlags, IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", null);
        this.mHandler.post(() -> {
            boolean success = false;
            try {
                this.freeStorage(volumeUuid, freeStorageSize, storageFlags);
                success = true;
            }
            catch (IOException e) {
                Slog.w(TAG, e);
            }
            if (observer != null) {
                try {
                    observer.onRemoveCompleted(null, success);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, e);
                }
            }
        });
    }

    @Override
    public void freeStorage(String volumeUuid, long freeStorageSize, int storageFlags, IntentSender pi) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", TAG);
        this.mHandler.post(() -> {
            boolean success = false;
            try {
                this.freeStorage(volumeUuid, freeStorageSize, storageFlags);
                success = true;
            }
            catch (IOException e) {
                Slog.w(TAG, e);
            }
            if (pi != null) {
                try {
                    pi.sendIntent(null, success ? 1 : 0, null, null, null);
                }
                catch (IntentSender.SendIntentException e) {
                    Slog.w(TAG, e);
                }
            }
        });
    }

    public void freeStorage(String volumeUuid, long bytes, int storageFlags) throws IOException {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        File file = storage.findPathForUuid(volumeUuid);
        if (file.getUsableSpace() >= bytes) {
            return;
        }
        if (ENABLE_FREE_CACHE_V2) {
            boolean internalVolume = Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, volumeUuid);
            boolean aggressive = (storageFlags & 1) != 0;
            long reservedBytes = storage.getStorageCacheBytes(file, storageFlags);
            if (internalVolume && (aggressive || SystemProperties.getBoolean("persist.sys.preloads.file_cache_expired", false))) {
                this.deletePreloadsFileCache();
                if (file.getUsableSpace() >= bytes) {
                    return;
                }
            }
            if (internalVolume && aggressive) {
                FileUtils.deleteContents(this.mCacheDir);
                if (file.getUsableSpace() >= bytes) {
                    return;
                }
            }
            try {
                this.mInstaller.freeCache(volumeUuid, bytes, reservedBytes, 256);
            }
            catch (Installer.InstallerException installerException) {
                // empty catch block
            }
            if (file.getUsableSpace() >= bytes) {
                return;
            }
            if (internalVolume && this.pruneUnusedStaticSharedLibraries(bytes, Settings.Global.getLong(this.mContext.getContentResolver(), "unused_static_shared_lib_min_cache_period", 0x6DDD00L))) {
                return;
            }
            if (internalVolume && this.mInstantAppRegistry.pruneInstalledInstantApps(bytes, Settings.Global.getLong(this.mContext.getContentResolver(), "installed_instant_app_min_cache_period", 604800000L))) {
                return;
            }
            try {
                this.mInstaller.freeCache(volumeUuid, bytes, reservedBytes, 768);
            }
            catch (Installer.InstallerException installerException) {
                // empty catch block
            }
            if (file.getUsableSpace() >= bytes) {
                return;
            }
            if (internalVolume && this.mInstantAppRegistry.pruneUninstalledInstantApps(bytes, Settings.Global.getLong(this.mContext.getContentResolver(), "uninstalled_instant_app_min_cache_period", 604800000L))) {
                return;
            }
        } else {
            try {
                this.mInstaller.freeCache(volumeUuid, bytes, 0L, 0);
            }
            catch (Installer.InstallerException installerException) {
                // empty catch block
            }
            if (file.getUsableSpace() >= bytes) {
                return;
            }
        }
        throw new IOException("Failed to free " + bytes + " on storage device at " + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pruneUnusedStaticSharedLibraries(long neededSpace, long maxCachePeriod) throws IOException {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        File volume = storage.findPathForUuid(StorageManager.UUID_PRIVATE_INTERNAL);
        ArrayList<VersionedPackage> packagesToDelete = null;
        long now = System.currentTimeMillis();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int[] allUsers = sUserManager.getUserIds();
            int libCount = this.mSharedLibraries.size();
            for (int i = 0; i < libCount; ++i) {
                SharedLibraryInfo libInfo;
                LongSparseArray<SharedLibraryInfo> versionedLib = this.mSharedLibraries.valueAt(i);
                if (versionedLib == null) continue;
                int versionCount = versionedLib.size();
                for (int j = 0; j < versionCount && (libInfo = versionedLib.valueAt(j)).isStatic(); ++j) {
                    VersionedPackage declaringPackage = libInfo.getDeclaringPackage();
                    String internalPackageName = this.resolveInternalPackageNameLPr(declaringPackage.getPackageName(), declaringPackage.getLongVersionCode());
                    PackageSetting ps = this.mSettings.getPackageLPr(internalPackageName);
                    if (ps == null || now - ps.lastUpdateTime < maxCachePeriod || ps.pkg.isSystem()) continue;
                    if (packagesToDelete == null) {
                        packagesToDelete = new ArrayList<VersionedPackage>();
                    }
                    packagesToDelete.add(new VersionedPackage(internalPackageName, declaringPackage.getLongVersionCode()));
                }
            }
        }
        if (packagesToDelete != null) {
            int packageCount = packagesToDelete.size();
            for (int i = 0; i < packageCount; ++i) {
                VersionedPackage pkgToDelete = (VersionedPackage)packagesToDelete.get(i);
                if (this.deletePackageX(pkgToDelete.getPackageName(), pkgToDelete.getLongVersionCode(), 0, 2) != 1 || volume.getUsableSpace() < neededSpace) continue;
                return true;
            }
        }
        return false;
    }

    private int updateFlags(int flags, int userId) {
        if ((flags & 0xC0000) == 0) {
            flags = this.getUserManagerInternal().isUserUnlockingOrUnlocked(userId) ? (flags |= 0xC0000) : (flags |= 0x80000);
        }
        return flags;
    }

    private UserManagerInternal getUserManagerInternal() {
        if (this.mUserManagerInternal == null) {
            this.mUserManagerInternal = LocalServices.getService(UserManagerInternal.class);
        }
        return this.mUserManagerInternal;
    }

    private ActivityManagerInternal getActivityManagerInternal() {
        if (this.mActivityManagerInternal == null) {
            this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        }
        return this.mActivityManagerInternal;
    }

    private ActivityTaskManagerInternal getActivityTaskManagerInternal() {
        if (this.mActivityTaskManagerInternal == null) {
            this.mActivityTaskManagerInternal = LocalServices.getService(ActivityTaskManagerInternal.class);
        }
        return this.mActivityTaskManagerInternal;
    }

    private DeviceIdleController.LocalService getDeviceIdleController() {
        if (this.mDeviceIdleController == null) {
            this.mDeviceIdleController = LocalServices.getService(DeviceIdleController.LocalService.class);
        }
        return this.mDeviceIdleController;
    }

    private StorageManagerInternal getStorageManagerInternal() {
        if (this.mStorageManagerInternal == null) {
            this.mStorageManagerInternal = LocalServices.getService(StorageManagerInternal.class);
        }
        return this.mStorageManagerInternal;
    }

    private int updateFlagsForPackage(int flags, int userId, Object cookie) {
        boolean isCallerSystemUser;
        boolean bl = isCallerSystemUser = UserHandle.getCallingUserId() == 0;
        if ((flags & 0x400000) != 0) {
            this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, !this.isRecentsAccessingChildProfiles(Binder.getCallingUid(), userId), "MATCH_ANY_USER flag requires INTERACT_ACROSS_USERS permission at " + Debug.getCallers(5));
        } else if ((flags & 0x2000) != 0 && isCallerSystemUser && sUserManager.hasManagedProfile(0)) {
            flags |= 0x400000;
        }
        return this.updateFlags(flags, userId);
    }

    private int updateFlagsForApplication(int flags, int userId, Object cookie) {
        return this.updateFlagsForPackage(flags, userId, cookie);
    }

    private int updateFlagsForComponent(int flags, int userId, Object cookie) {
        return this.updateFlags(flags, userId);
    }

    private Intent updateIntentForResolve(Intent intent) {
        if (intent.getSelector() != null) {
            intent = intent.getSelector();
        }
        return intent;
    }

    int updateFlagsForResolve(int flags, int userId, Intent intent, int callingUid) {
        return this.updateFlagsForResolve(flags, userId, intent, callingUid, false, false);
    }

    int updateFlagsForResolve(int flags, int userId, Intent intent, int callingUid, boolean wantInstantApps) {
        return this.updateFlagsForResolve(flags, userId, intent, callingUid, wantInstantApps, false);
    }

    int updateFlagsForResolve(int flags, int userId, Intent intent, int callingUid, boolean wantInstantApps, boolean onlyExposedExplicitly) {
        if (this.mSafeMode) {
            flags |= 0x100000;
        }
        if (this.getInstantAppPackageName(callingUid) != null) {
            if (onlyExposedExplicitly) {
                flags |= 0x2000000;
            }
            flags |= 0x1000000;
            flags |= 0x800000;
        } else {
            boolean wantMatchInstant = (flags & 0x800000) != 0;
            boolean allowMatchInstant = wantInstantApps || wantMatchInstant && this.canViewInstantApps(callingUid, userId);
            flags &= 0xFCFFFFFF;
            if (!allowMatchInstant) {
                flags &= 0xFF7FFFFF;
            }
        }
        return this.updateFlagsForComponent(flags, userId, intent);
    }

    @Override
    public ActivityInfo getActivityInfo(ComponentName component, int flags, int userId) {
        return this.getActivityInfoInternal(component, flags, Binder.getCallingUid(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityInfo getActivityInfoInternal(ComponentName component, int flags, int filterCallingUid, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        flags = this.updateFlagsForComponent(flags, userId, component);
        if (!this.isRecentsAccessingChildProfiles(Binder.getCallingUid(), userId)) {
            this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get activity info");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Activity a = this.mComponentResolver.getActivity(component);
            if (a != null && this.mSettings.isEnabledAndMatchLPr(a.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, filterCallingUid, component, 1, userId)) {
                    return null;
                }
                return PackageParser.generateActivityInfo(a, flags, ps.readUserState(userId), userId);
            }
            if (this.mResolveComponentName.equals(component)) {
                return PackageParser.generateActivityInfo(this.mResolveActivity, flags, new PackageUserState(), userId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRecentsAccessingChildProfiles(int callingUid, int targetUserId) {
        if (!this.getActivityTaskManagerInternal().isCallerRecents(callingUid)) {
            return false;
        }
        long token = Binder.clearCallingIdentity();
        try {
            int callingUserId = UserHandle.getUserId(callingUid);
            if (ActivityManager.getCurrentUser() != callingUserId) {
                boolean bl = false;
                return bl;
            }
            boolean bl = sUserManager.isSameProfileGroup(callingUserId, targetUserId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean activitySupportsIntent(ComponentName component, Intent intent, String resolvedType) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (component.equals(this.mResolveComponentName)) {
                return true;
            }
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            PackageParser.Activity a = this.mComponentResolver.getActivity(component);
            if (a == null) {
                return false;
            }
            PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
            if (ps == null) {
                return false;
            }
            if (this.filterAppAccessLPr(ps, callingUid, component, 1, callingUserId)) {
                return false;
            }
            for (int i = 0; i < a.intents.size(); ++i) {
                if (((PackageParser.ActivityIntentInfo)a.intents.get(i)).match(intent.getAction(), resolvedType, intent.getScheme(), intent.getData(), intent.getCategories(), TAG) < 0) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityInfo getReceiverInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForComponent(flags, userId, component);
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "get receiver info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Activity a = this.mComponentResolver.getReceiver(component);
            if (a != null && this.mSettings.isEnabledAndMatchLPr(a.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, callingUid, component, 2, userId)) {
                    return null;
                }
                return PackageParser.generateActivityInfo(a, flags, ps.readUserState(userId), userId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<SharedLibraryInfo> getSharedLibraries(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        Preconditions.checkArgumentNonnegative(userId, "userId must be >= 0");
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        flags = this.updateFlagsForPackage(flags, userId, null);
        boolean canSeeStaticLibraries = this.mContext.checkCallingOrSelfPermission("android.permission.INSTALL_PACKAGES") == 0 || this.mContext.checkCallingOrSelfPermission("android.permission.DELETE_PACKAGES") == 0 || this.canRequestPackageInstallsInternal(packageName, 0x4000000, userId, false) || this.mContext.checkCallingOrSelfPermission("android.permission.REQUEST_DELETE_PACKAGES") == 0 || this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_SHARED_LIBRARIES") == 0;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<SharedLibraryInfo> result = null;
            int libCount = this.mSharedLibraries.size();
            block6: for (int i = 0; i < libCount; ++i) {
                LongSparseArray<SharedLibraryInfo> versionedLib = this.mSharedLibraries.valueAt(i);
                if (versionedLib == null) continue;
                int versionCount = versionedLib.size();
                for (int j = 0; j < versionCount; ++j) {
                    SharedLibraryInfo libInfo = versionedLib.valueAt(j);
                    if (!canSeeStaticLibraries && libInfo.isStatic()) continue block6;
                    long identity = Binder.clearCallingIdentity();
                    try {
                        PackageInfo packageInfo = this.getPackageInfoVersioned(libInfo.getDeclaringPackage(), flags | 0x4000000, userId);
                        if (packageInfo == null) {
                            continue;
                        }
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    SharedLibraryInfo resLibInfo = new SharedLibraryInfo(libInfo.getPath(), libInfo.getPackageName(), libInfo.getAllCodePaths(), libInfo.getName(), libInfo.getLongVersion(), libInfo.getType(), libInfo.getDeclaringPackage(), this.getPackagesUsingSharedLibraryLPr(libInfo, flags, userId), (List<SharedLibraryInfo>)(libInfo.getDependencies() == null ? null : new ArrayList<SharedLibraryInfo>(libInfo.getDependencies())));
                    if (result == null) {
                        result = new ArrayList<SharedLibraryInfo>();
                    }
                    result.add(resLibInfo);
                }
            }
            return result != null ? new ParceledListSlice<SharedLibraryInfo>(result) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<SharedLibraryInfo> getDeclaredSharedLibraries(String packageName, int flags, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_SHARED_LIBRARIES", "getDeclaredSharedLibraries");
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, false, "getDeclaredSharedLibraries");
        Preconditions.checkNotNull(packageName, "packageName cannot be null");
        Preconditions.checkArgumentNonnegative(userId, "userId must be >= 0");
        if (!sUserManager.exists(userId)) {
            return null;
        }
        if (this.getInstantAppPackageName(callingUid) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<SharedLibraryInfo> result = null;
            int libraryCount = this.mSharedLibraries.size();
            for (int i = 0; i < libraryCount; ++i) {
                LongSparseArray<SharedLibraryInfo> versionedLibrary = this.mSharedLibraries.valueAt(i);
                if (versionedLibrary == null) continue;
                int versionCount = versionedLibrary.size();
                for (int j = 0; j < versionCount; ++j) {
                    SharedLibraryInfo libraryInfo = versionedLibrary.valueAt(j);
                    VersionedPackage declaringPackage = libraryInfo.getDeclaringPackage();
                    if (!Objects.equals(declaringPackage.getPackageName(), packageName)) continue;
                    long identity = Binder.clearCallingIdentity();
                    try {
                        PackageInfo packageInfo = this.getPackageInfoVersioned(declaringPackage, flags | 0x4000000, userId);
                        if (packageInfo == null) {
                            continue;
                        }
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    SharedLibraryInfo resultLibraryInfo = new SharedLibraryInfo(libraryInfo.getPath(), libraryInfo.getPackageName(), libraryInfo.getAllCodePaths(), libraryInfo.getName(), libraryInfo.getLongVersion(), libraryInfo.getType(), libraryInfo.getDeclaringPackage(), this.getPackagesUsingSharedLibraryLPr(libraryInfo, flags, userId), (List<SharedLibraryInfo>)(libraryInfo.getDependencies() == null ? null : new ArrayList<SharedLibraryInfo>(libraryInfo.getDependencies())));
                    if (result == null) {
                        result = new ArrayList<SharedLibraryInfo>();
                    }
                    result.add(resultLibraryInfo);
                }
            }
            return result != null ? new ParceledListSlice<SharedLibraryInfo>(result) : null;
        }
    }

    @GuardedBy(value={"mPackages"})
    private List<VersionedPackage> getPackagesUsingSharedLibraryLPr(SharedLibraryInfo libInfo, int flags, int userId) {
        ArrayList<VersionedPackage> versionedPackages = null;
        int packageCount = this.mSettings.mPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            PackageSetting ps = this.mSettings.mPackages.valueAt(i);
            if (ps == null || !ps.readUserState(userId).isAvailable(flags)) continue;
            String libName = libInfo.getName();
            if (libInfo.isStatic()) {
                int libIdx = ArrayUtils.indexOf(ps.usesStaticLibraries, libName);
                if (libIdx < 0 || ps.usesStaticLibrariesVersions[libIdx] != libInfo.getLongVersion()) continue;
                if (versionedPackages == null) {
                    versionedPackages = new ArrayList();
                }
                String dependentPackageName = ps.name;
                if (ps.pkg != null && ps.pkg.applicationInfo.isStaticSharedLibrary()) {
                    dependentPackageName = ps.pkg.manifestPackageName;
                }
                versionedPackages.add(new VersionedPackage(dependentPackageName, ps.versionCode));
                continue;
            }
            if (ps.pkg == null || !ArrayUtils.contains(ps.pkg.usesLibraries, libName) && !ArrayUtils.contains(ps.pkg.usesOptionalLibraries, libName)) continue;
            if (versionedPackages == null) {
                versionedPackages = new ArrayList<VersionedPackage>();
            }
            versionedPackages.add(new VersionedPackage(ps.name, ps.versionCode));
        }
        return versionedPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo getServiceInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForComponent(flags, userId, component);
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "get service info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Service s = this.mComponentResolver.getService(component);
            if (s != null && this.mSettings.isEnabledAndMatchLPr(s.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, callingUid, component, 3, userId)) {
                    return null;
                }
                return PackageParser.generateServiceInfo(s, flags, ps.readUserState(userId), userId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderInfo getProviderInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForComponent(flags, userId, component);
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "get provider info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Provider p = this.mComponentResolver.getProvider(component);
            if (p != null && this.mSettings.isEnabledAndMatchLPr(p.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, callingUid, component, 4, userId)) {
                    return null;
                }
                return PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId);
            }
            return null;
        }
    }

    @Override
    public ModuleInfo getModuleInfo(String packageName, int flags) {
        return this.mModuleInfoProvider.getModuleInfo(packageName, flags);
    }

    @Override
    public List<ModuleInfo> getInstalledModules(int flags) {
        return this.mModuleInfoProvider.getInstalledModules(flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSystemSharedLibraryNames() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArraySet<String> libs = null;
            int libCount = this.mSharedLibraries.size();
            block3: for (int i = 0; i < libCount; ++i) {
                LongSparseArray<SharedLibraryInfo> versionedLib = this.mSharedLibraries.valueAt(i);
                if (versionedLib == null) continue;
                int versionCount = versionedLib.size();
                for (int j = 0; j < versionCount; ++j) {
                    SharedLibraryInfo libraryInfo = versionedLib.valueAt(j);
                    if (!libraryInfo.isStatic()) {
                        if (libs == null) {
                            libs = new ArraySet<String>();
                        }
                        libs.add(libraryInfo.getName());
                        continue block3;
                    }
                    PackageSetting ps = this.mSettings.getPackageLPr(libraryInfo.getPackageName());
                    if (ps == null || this.filterSharedLibPackageLPr(ps, Binder.getCallingUid(), UserHandle.getUserId(Binder.getCallingUid()), 0x4000000)) continue;
                    if (libs == null) {
                        libs = new ArraySet();
                    }
                    libs.add(libraryInfo.getName());
                    continue block3;
                }
            }
            if (libs != null) {
                String[] libsArray = new String[libs.size()];
                libs.toArray(libsArray);
                return libsArray;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getServicesSystemSharedLibraryPackageName() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mServicesSystemSharedLibraryPackageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSharedSystemSharedLibraryPackageName() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSharedSystemSharedLibraryPackageName;
        }
    }

    @GuardedBy(value={"mPackages"})
    private void updateSequenceNumberLP(PackageSetting pkgSetting, int[] userList) {
        for (int i = userList.length - 1; i >= 0; --i) {
            Integer sequenceNumber;
            Map<String, Integer> sequenceNumbers;
            int userId = userList[i];
            if (pkgSetting.getInstantApp(userId)) continue;
            SparseArray<String> changedPackages = this.mChangedPackages.get(userId);
            if (changedPackages == null) {
                changedPackages = new SparseArray();
                this.mChangedPackages.put(userId, changedPackages);
            }
            if ((sequenceNumbers = this.mChangedPackagesSequenceNumbers.get(userId)) == null) {
                sequenceNumbers = new HashMap<String, Integer>();
                this.mChangedPackagesSequenceNumbers.put(userId, sequenceNumbers);
            }
            if ((sequenceNumber = sequenceNumbers.get(pkgSetting.name)) != null) {
                changedPackages.remove(sequenceNumber);
            }
            changedPackages.put(this.mChangedPackagesSequenceNumber, pkgSetting.name);
            sequenceNumbers.put(pkgSetting.name, this.mChangedPackagesSequenceNumber);
        }
        ++this.mChangedPackagesSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangedPackages getChangedPackages(int sequenceNumber, int userId) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (sequenceNumber >= this.mChangedPackagesSequenceNumber) {
                return null;
            }
            SparseArray<String> changedPackages = this.mChangedPackages.get(userId);
            if (changedPackages == null) {
                return null;
            }
            ArrayList<String> packageNames = new ArrayList<String>(this.mChangedPackagesSequenceNumber - sequenceNumber);
            for (int i = sequenceNumber; i < this.mChangedPackagesSequenceNumber; ++i) {
                String packageName = changedPackages.get(i);
                if (packageName == null) continue;
                packageNames.add(packageName);
            }
            return packageNames.isEmpty() ? null : new ChangedPackages(this.mChangedPackagesSequenceNumber, packageNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<FeatureInfo> getSystemAvailableFeatures() {
        ArrayList<FeatureInfo> res;
        ArrayMap<String, FeatureInfo> arrayMap = this.mAvailableFeatures;
        synchronized (arrayMap) {
            res = new ArrayList<FeatureInfo>(this.mAvailableFeatures.size() + 1);
            res.addAll(this.mAvailableFeatures.values());
        }
        FeatureInfo fi = new FeatureInfo();
        fi.reqGlEsVersion = SystemProperties.getInt("ro.opengles.version", 0);
        res.add(fi);
        return new ParceledListSlice<FeatureInfo>(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSystemFeature(String name, int version) {
        ArrayMap<String, FeatureInfo> arrayMap = this.mAvailableFeatures;
        synchronized (arrayMap) {
            FeatureInfo feat = this.mAvailableFeatures.get(name);
            if (feat == null) {
                return false;
            }
            return feat.version >= version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkPermission(String permName, String pkgName, int userId) {
        PackageManagerInternal.CheckPermissionDelegate checkPermissionDelegate;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mCheckPermissionDelegate == null) {
                return this.checkPermissionImpl(permName, pkgName, userId);
            }
            checkPermissionDelegate = this.mCheckPermissionDelegate;
        }
        return checkPermissionDelegate.checkPermission(permName, pkgName, userId, this::checkPermissionImpl);
    }

    private int checkPermissionImpl(String permName, String pkgName, int userId) {
        return this.mPermissionManager.checkPermission(permName, pkgName, PackageManagerService.getCallingUid(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkUidPermission(String permName, int uid) {
        PackageManagerInternal.CheckPermissionDelegate checkPermissionDelegate;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mCheckPermissionDelegate == null) {
                return this.checkUidPermissionImpl(permName, uid);
            }
            checkPermissionDelegate = this.mCheckPermissionDelegate;
        }
        return checkPermissionDelegate.checkUidPermission(permName, uid, this::checkUidPermissionImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkUidPermissionImpl(String permName, int uid) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String[] packageNames = this.getPackagesForUid(uid);
            PackageParser.Package pkg = null;
            int N = packageNames == null ? 0 : packageNames.length;
            for (int i = 0; pkg == null && i < N; ++i) {
                pkg = this.mPackages.get(packageNames[i]);
            }
            return this.mPermissionManager.checkUidPermission(permName, pkg, uid, PackageManagerService.getCallingUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPermissionRevokedByPolicy(String permission2, String packageName, int userId) {
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "isPermissionRevokedByPolicy for user " + userId);
        }
        if (this.checkPermission(permission2, packageName, userId) == 0) {
            return false;
        }
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null ? !this.isCallerSameApp(packageName, callingUid) : this.isInstantApp(packageName, userId)) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            int flags = this.getPermissionFlags(permission2, packageName, userId);
            boolean bl = (flags & 4) != 0;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPermissionControllerPackageName() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mRequiredPermissionControllerPackage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPackageInstallerPackageName() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mRequiredInstallerPackage;
        }
    }

    private boolean addDynamicPermission(PermissionInfo info, final boolean async) {
        return this.mPermissionManager.addDynamicPermission(info, async, PackageManagerService.getCallingUid(), new PermissionManagerServiceInternal.PermissionCallback(){

            @Override
            public void onPermissionChanged() {
                if (!async) {
                    PackageManagerService.this.mSettings.writeLPr();
                } else {
                    PackageManagerService.this.scheduleWriteSettingsLocked();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermission(PermissionInfo info) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.addDynamicPermission(info, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermissionAsync(PermissionInfo info) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.addDynamicPermission(info, true);
        }
    }

    @Override
    public void removePermission(String permName) {
        this.mPermissionManager.removeDynamicPermission(permName, PackageManagerService.getCallingUid(), this.mPermissionCallback);
    }

    @Override
    public void grantRuntimePermission(String packageName, String permName, int userId) {
        boolean overridePolicy = this.checkUidPermission("android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", Binder.getCallingUid()) == 0;
        this.mPermissionManager.grantRuntimePermission(permName, packageName, overridePolicy, PackageManagerService.getCallingUid(), userId, this.mPermissionCallback);
    }

    @Override
    public void revokeRuntimePermission(String packageName, String permName, int userId) {
        boolean overridePolicy = this.checkUidPermission("android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", Binder.getCallingUid()) == 0;
        this.mPermissionManager.revokeRuntimePermission(permName, packageName, overridePolicy, userId, this.mPermissionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetRuntimePermissions() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS", "revokeRuntimePermission");
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000 && callingUid != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "resetRuntimePermissions");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mPermissionManager.updateAllPermissions(StorageManager.UUID_PRIVATE_INTERNAL, false, this.mPackages.values(), this.mPermissionCallback);
            for (int userId : UserManagerService.getInstance().getUserIds()) {
                int packageCount = this.mPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    PackageParser.Package pkg = this.mPackages.valueAt(i);
                    if (!(pkg.mExtras instanceof PackageSetting)) continue;
                    PackageSetting ps = (PackageSetting)pkg.mExtras;
                    this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, userId);
                }
            }
        }
    }

    @Override
    public int getPermissionFlags(String permName, String packageName, int userId) {
        return this.mPermissionManager.getPermissionFlags(permName, packageName, PackageManagerService.getCallingUid(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePermissionFlags(String permName, String packageName, int flagMask, int flagValues, boolean checkAdjustPolicyFlagPermission, int userId) {
        int callingUid = PackageManagerService.getCallingUid();
        boolean overridePolicy = false;
        if (callingUid != 1000 && callingUid != 0) {
            long callingIdentity = Binder.clearCallingIdentity();
            try {
                if ((flagMask & 4) != 0) {
                    if (checkAdjustPolicyFlagPermission) {
                        this.mContext.enforceCallingOrSelfPermission("android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", "Need android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY to change policy flags");
                    } else if (!this.hasTargetSdkInUidLowerThan(callingUid, 29)) {
                        throw new IllegalArgumentException("android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY needs  to be checked for packages targeting 29 or later when changing policy flags");
                    }
                    overridePolicy = true;
                }
            }
            finally {
                Binder.restoreCallingIdentity(callingIdentity);
            }
        }
        this.mPermissionManager.updatePermissionFlags(permName, packageName, flagMask, flagValues, callingUid, userId, overridePolicy, this.mPermissionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePermissionFlagsForAllApps(int flagMask, int flagValues, int userId) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean changed = this.mPermissionManager.updatePermissionFlagsForAllApps(flagMask, flagValues, PackageManagerService.getCallingUid(), userId, this.mPackages.values(), this.mPermissionCallback);
            if (changed) {
                this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWhitelistedRestrictedPermissions(String packageName, int whitelistFlags, int userId) {
        PackageParser.Package pkg;
        Preconditions.checkNotNull(packageName);
        Preconditions.checkFlagsArgument(whitelistFlags, 7);
        Preconditions.checkArgumentNonNegative(userId, null);
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", "getWhitelistedRestrictedPermissions for user " + userId);
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean isCallerInstallerOnRecord;
            PackageSetting packageSetting = this.mSettings.mPackages.get(packageName);
            if (packageSetting == null) {
                Slog.w(TAG, "Unknown package: " + packageName);
                return null;
            }
            pkg = packageSetting.pkg;
            boolean isCallerPrivileged = this.mContext.checkCallingOrSelfPermission("android.permission.WHITELIST_RESTRICTED_PERMISSIONS") == 0;
            PackageSetting installerPackageSetting = this.mSettings.mPackages.get(packageSetting.installerPackageName);
            boolean bl = isCallerInstallerOnRecord = installerPackageSetting != null && UserHandle.isSameApp(installerPackageSetting.appId, Binder.getCallingUid());
            if ((whitelistFlags & 1) != 0 && !isCallerPrivileged) {
                throw new SecurityException("Querying system whitelist requires android.permission.WHITELIST_RESTRICTED_PERMISSIONS");
            }
            if ((whitelistFlags & 6) != 0 && !isCallerPrivileged && !isCallerInstallerOnRecord) {
                throw new SecurityException("Querying upgrade or installer whitelist requires being installer on record or android.permission.WHITELIST_RESTRICTED_PERMISSIONS");
            }
            if (this.filterAppAccessLPr(packageSetting, Binder.getCallingUid(), UserHandle.getCallingUserId())) {
                return null;
            }
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<String> list = this.mPermissionManager.getWhitelistedRestrictedPermissions(pkg, whitelistFlags, userId);
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @Override
    public boolean addWhitelistedRestrictedPermission(String packageName, String permission2, int whitelistFlags, int userId) {
        Preconditions.checkNotNull(permission2);
        if (!this.checkExistsAndEnforceCannotModifyImmutablyRestrictedPermission(permission2)) {
            return false;
        }
        List<String> permissions = this.getWhitelistedRestrictedPermissions(packageName, whitelistFlags, userId);
        if (permissions == null) {
            permissions = new ArrayList<String>(1);
        }
        if (permissions.indexOf(permission2) < 0) {
            permissions.add(permission2);
            return this.setWhitelistedRestrictedPermissions(packageName, permissions, whitelistFlags, userId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkExistsAndEnforceCannotModifyImmutablyRestrictedPermission(String permission2) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            BasePermission bp = this.mPermissionManager.getPermissionTEMP(permission2);
            if (bp == null) {
                Slog.w(TAG, "No such permissions: " + permission2);
                return false;
            }
            if (bp.isHardOrSoftRestricted() && bp.isImmutablyRestricted() && this.mContext.checkCallingOrSelfPermission("android.permission.WHITELIST_RESTRICTED_PERMISSIONS") != 0) {
                throw new SecurityException("Cannot modify whitelisting of an immutably restricted permission: " + permission2);
            }
            return true;
        }
    }

    @Override
    public boolean removeWhitelistedRestrictedPermission(String packageName, String permission2, int whitelistFlags, int userId) {
        Preconditions.checkNotNull(permission2);
        if (!this.checkExistsAndEnforceCannotModifyImmutablyRestrictedPermission(permission2)) {
            return false;
        }
        List<String> permissions = this.getWhitelistedRestrictedPermissions(packageName, whitelistFlags, userId);
        if (permissions != null && permissions.remove(permission2)) {
            return this.setWhitelistedRestrictedPermissions(packageName, permissions, whitelistFlags, userId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setWhitelistedRestrictedPermissions(String packageName, List<String> permissions, int whitelistFlag, int userId) {
        PackageParser.Package pkg;
        Preconditions.checkNotNull(packageName);
        Preconditions.checkFlagsArgument(whitelistFlag, 7);
        Preconditions.checkArgument(Integer.bitCount(whitelistFlag) == 1);
        Preconditions.checkArgumentNonNegative(userId, null);
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", "setWhitelistedRestrictedPermissions for user " + userId);
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean isCallerInstallerOnRecord;
            PackageSetting packageSetting = this.mSettings.mPackages.get(packageName);
            if (packageSetting == null) {
                Slog.w(TAG, "Unknown package: " + packageName);
                return false;
            }
            pkg = packageSetting.pkg;
            boolean isCallerPrivileged = this.mContext.checkCallingOrSelfPermission("android.permission.WHITELIST_RESTRICTED_PERMISSIONS") == 0;
            PackageSetting installerPackageSetting = this.mSettings.mPackages.get(packageSetting.installerPackageName);
            boolean bl = isCallerInstallerOnRecord = installerPackageSetting != null && UserHandle.isSameApp(installerPackageSetting.appId, Binder.getCallingUid());
            if ((whitelistFlag & 1) != 0 && !isCallerPrivileged) {
                throw new SecurityException("Modifying system whitelist requires android.permission.WHITELIST_RESTRICTED_PERMISSIONS");
            }
            if ((whitelistFlag & 4) != 0) {
                if (!isCallerPrivileged && !isCallerInstallerOnRecord) {
                    throw new SecurityException("Modifying upgrade whitelist requires being installer on record or android.permission.WHITELIST_RESTRICTED_PERMISSIONS");
                }
                List<String> whitelistedPermissions = this.getWhitelistedRestrictedPermissions(packageName, whitelistFlag, userId);
                if (permissions == null || permissions.isEmpty()) {
                    if (whitelistedPermissions == null || whitelistedPermissions.isEmpty()) {
                        return true;
                    }
                } else {
                    int permissionCount = permissions.size();
                    for (int i = 0; i < permissionCount; ++i) {
                        if (whitelistedPermissions != null && whitelistedPermissions.contains(permissions.get(i)) || isCallerPrivileged) continue;
                        throw new SecurityException("Adding to upgrade whitelist requiresandroid.permission.WHITELIST_RESTRICTED_PERMISSIONS");
                    }
                }
            }
            if ((whitelistFlag & 2) != 0 && !isCallerPrivileged && !isCallerInstallerOnRecord) {
                throw new SecurityException("Modifying installer whitelist requires being installer on record or android.permission.WHITELIST_RESTRICTED_PERMISSIONS");
            }
            if (this.filterAppAccessLPr(packageSetting, Binder.getCallingUid(), UserHandle.getCallingUserId())) {
                return false;
            }
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.mPermissionManager.setWhitelistedRestrictedPermissions(pkg, new int[]{userId}, permissions, Process.myUid(), whitelistFlag, this.mPermissionCallback);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldShowRequestPermissionRationale(String permissionName, String packageName, int userId) {
        int flags;
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "canShowRequestPermissionRationale for user " + userId);
        }
        int uid = this.getPackageUid(packageName, 0x10000000, userId);
        if (UserHandle.getAppId(PackageManagerService.getCallingUid()) != UserHandle.getAppId(uid)) {
            return false;
        }
        if (this.checkPermission(permissionName, packageName, userId) == 0) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            flags = this.getPermissionFlags(permissionName, packageName, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        int fixedFlags = 22;
        if ((flags & 0x16) != 0) {
            return false;
        }
        return (flags & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnPermissionsChangeListener(IOnPermissionsChangeListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.OBSERVE_GRANT_REVOKE_PERMISSIONS", "addOnPermissionsChangeListener");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mOnPermissionChangeListeners.addListenerLocked(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnPermissionsChangeListener(IOnPermissionsChangeListener listener) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            throw new SecurityException("Instant applications don't have access to this method");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mOnPermissionChangeListeners.removeListenerLocked(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtectedBroadcast(String actionName) {
        ArraySet<String> arraySet = this.mProtectedBroadcasts;
        synchronized (arraySet) {
            if (this.mProtectedBroadcasts.contains(actionName)) {
                return true;
            }
            if (actionName != null && (actionName.startsWith("android.net.netmon.lingerExpired") || actionName.startsWith("com.android.server.sip.SipWakeupTimer") || actionName.startsWith("com.android.internal.telephony.data-reconnect") || actionName.startsWith("android.net.netmon.launchCaptivePortalApp"))) {
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkSignatures(String pkg1, String pkg2) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p1 = this.mPackages.get(pkg1);
            PackageParser.Package p2 = this.mPackages.get(pkg2);
            if (p1 == null || p1.mExtras == null || p2 == null || p2.mExtras == null) {
                return -4;
            }
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            PackageSetting ps1 = (PackageSetting)p1.mExtras;
            PackageSetting ps2 = (PackageSetting)p2.mExtras;
            if (this.filterAppAccessLPr(ps1, callingUid, callingUserId) || this.filterAppAccessLPr(ps2, callingUid, callingUserId)) {
                return -4;
            }
            return PackageManagerServiceUtils.compareSignatures(p1.mSigningDetails.signatures, p2.mSigningDetails.signatures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int checkUidSignatures(int uid1, int uid2) {
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        boolean isCallerInstantApp = this.getInstantAppPackageName(callingUid) != null;
        int appId1 = UserHandle.getAppId(uid1);
        int appId2 = UserHandle.getAppId(uid2);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Signature[] s2;
            PackageSetting ps;
            Signature[] s1;
            SettingBase obj = this.mSettings.getSettingLPr(appId1);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                if (isCallerInstantApp) {
                    return -4;
                }
                s1 = ((SharedUserSetting)obj).signatures.mSigningDetails.signatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
                    return -4;
                }
                s1 = ps.signatures.mSigningDetails.signatures;
            }
            obj = this.mSettings.getSettingLPr(appId2);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                if (isCallerInstantApp) {
                    return -4;
                }
                s2 = ((SharedUserSetting)obj).signatures.mSigningDetails.signatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
                    return -4;
                }
                s2 = ps.signatures.mSigningDetails.signatures;
            }
            return PackageManagerServiceUtils.compareSignatures(s1, s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSigningCertificate(String packageName, byte[] certificate, int type) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int callingUserId;
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p == null || p.mExtras == null) {
                return false;
            }
            PackageSetting ps = (PackageSetting)p.mExtras;
            int callingUid = Binder.getCallingUid();
            if (this.filterAppAccessLPr(ps, callingUid, callingUserId = UserHandle.getUserId(callingUid))) {
                return false;
            }
            switch (type) {
                case 0: {
                    return p.mSigningDetails.hasCertificate(certificate);
                }
                case 1: {
                    return p.mSigningDetails.hasSha256Certificate(certificate);
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasUidSigningCertificate(int uid, byte[] certificate, int type) {
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        int appId = UserHandle.getAppId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.SigningDetails signingDetails;
            SettingBase obj = this.mSettings.getSettingLPr(appId);
            if (obj == null) return false;
            if (obj instanceof SharedUserSetting) {
                boolean isCallerInstantApp;
                if (this.getInstantAppPackageName(callingUid) != null) {
                    return false;
                }
                boolean bl = isCallerInstantApp = false;
                if (isCallerInstantApp) {
                    return false;
                }
                signingDetails = ((SharedUserSetting)obj).signatures.mSigningDetails;
            } else {
                if (!(obj instanceof PackageSetting)) return false;
                PackageSetting ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
                    return false;
                }
                signingDetails = ps.signatures.mSigningDetails;
            }
            switch (type) {
                case 0: {
                    return signingDetails.hasCertificate(certificate);
                }
                case 1: {
                    return signingDetails.hasSha256Certificate(certificate);
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killUid(int appId, int userId, String reason) {
        long identity = Binder.clearCallingIdentity();
        try {
            IActivityManager am = ActivityManager.getService();
            if (am != null) {
                try {
                    am.killUid(appId, userId, reason);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private boolean isCompatSignatureUpdateNeeded(PackageParser.Package scannedPkg) {
        return PackageManagerService.isCompatSignatureUpdateNeeded(this.getSettingsVersionForPackage(scannedPkg));
    }

    private static boolean isCompatSignatureUpdateNeeded(Settings.VersionInfo ver) {
        return ver.databaseVersion < 2;
    }

    private boolean isRecoverSignatureUpdateNeeded(PackageParser.Package scannedPkg) {
        return PackageManagerService.isRecoverSignatureUpdateNeeded(this.getSettingsVersionForPackage(scannedPkg));
    }

    private static boolean isRecoverSignatureUpdateNeeded(Settings.VersionInfo ver) {
        return ver.databaseVersion < 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllPackages() {
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.canViewInstantApps(callingUid, callingUserId)) {
                return new ArrayList<String>(this.mPackages.keySet());
            }
            String instantAppPkgName = this.getInstantAppPackageName(callingUid);
            ArrayList<String> result = new ArrayList<String>();
            if (instantAppPkgName != null) {
                for (PackageParser.Package pkg : this.mPackages.values()) {
                    if (!pkg.visibleToInstantApps) continue;
                    result.add(pkg.packageName);
                }
            } else {
                for (PackageParser.Package pkg : this.mPackages.values()) {
                    PackageSetting ps;
                    PackageSetting packageSetting = ps = pkg.mExtras != null ? (PackageSetting)pkg.mExtras : null;
                    if (ps != null && ps.getInstantApp(callingUserId) && !this.mInstantAppRegistry.isInstantAccessGranted(callingUserId, UserHandle.getAppId(callingUid), ps.appId)) continue;
                    result.add(pkg.packageName);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPackagesForUid(int uid) {
        int callingUid = Binder.getCallingUid();
        boolean isCallerInstantApp = this.getInstantAppPackageName(callingUid) != null;
        int userId = UserHandle.getUserId(uid);
        int appId = UserHandle.getAppId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            SettingBase obj = this.mSettings.getSettingLPr(appId);
            if (obj instanceof SharedUserSetting) {
                if (isCallerInstantApp) {
                    return null;
                }
                SharedUserSetting sus = (SharedUserSetting)obj;
                int N = sus.packages.size();
                String[] res = new String[N];
                Iterator<PackageSetting> it = sus.packages.iterator();
                int i = 0;
                while (it.hasNext()) {
                    PackageSetting ps2 = it.next();
                    if (ps2.getInstalled(userId)) {
                        res[i++] = ps2.name;
                        continue;
                    }
                    res = ArrayUtils.removeElement(String.class, res, res[i]);
                }
                return res;
            }
            if (obj instanceof PackageSetting && (ps = (PackageSetting)obj).getInstalled(userId) && !this.filterAppAccessLPr(ps, callingUid, userId)) {
                return new String[]{ps.name};
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameForUid(int uid) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return null;
        }
        int appId = UserHandle.getAppId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SettingBase obj = this.mSettings.getSettingLPr(appId);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.name + ":" + sus.userId;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                    return null;
                }
                return ps.name;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNamesForUids(int[] uids) {
        if (uids == null || uids.length == 0) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return null;
        }
        String[] names = new String[uids.length];
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (int i = uids.length - 1; i >= 0; --i) {
                int appId = UserHandle.getAppId(uids[i]);
                SettingBase obj = this.mSettings.getSettingLPr(appId);
                if (obj instanceof SharedUserSetting) {
                    SharedUserSetting sus = (SharedUserSetting)obj;
                    names[i] = "shared:" + sus.name;
                    continue;
                }
                if (obj instanceof PackageSetting) {
                    PackageSetting ps = (PackageSetting)obj;
                    if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                        names[i] = null;
                        continue;
                    }
                    names[i] = ps.name;
                    continue;
                }
                names[i] = null;
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getUidForSharedUser(String sharedUserName) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return -1;
        }
        if (sharedUserName == null) {
            return -1;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            block10: {
                try {
                    SharedUserSetting suid = this.mSettings.getSharedUserLPw(sharedUserName, 0, 0, false);
                    if (suid == null) break block10;
                    return suid.userId;
                }
                catch (PackageManagerException packageManagerException) {
                    return -1;
                }
            }
            return -1;
            {
                finally {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFlagsForUid(int uid) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return 0;
        }
        int appId = UserHandle.getAppId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SettingBase obj = this.mSettings.getSettingLPr(appId);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.pkgFlags;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                    return 0;
                }
                return ps.pkgFlags;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPrivateFlagsForUid(int uid) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return 0;
        }
        int appId = UserHandle.getAppId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SettingBase obj = this.mSettings.getSettingLPr(appId);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.pkgPrivateFlags;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                    return 0;
                }
                return ps.pkgPrivateFlags;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUidPrivileged(int uid) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return false;
        }
        int appId = UserHandle.getAppId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SettingBase obj = this.mSettings.getSettingLPr(appId);
            if (!(obj instanceof SharedUserSetting)) {
                if (!(obj instanceof PackageSetting)) return false;
                PackageSetting ps = (PackageSetting)obj;
                return ps.isPrivileged();
            }
            SharedUserSetting sus = (SharedUserSetting)obj;
            Iterator<PackageSetting> it = sus.packages.iterator();
            do {
                if (!it.hasNext()) return false;
            } while (!it.next().isPrivileged());
            return true;
        }
    }

    @Override
    public String[] getAppOpPermissionPackages(String permName) {
        return this.mPermissionManager.getAppOpPermissionPackages(permName);
    }

    @Override
    public ResolveInfo resolveIntent(Intent intent, String resolvedType, int flags, int userId) {
        return this.resolveIntentInternal(intent, resolvedType, flags, userId, false, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolveInfo resolveIntentInternal(Intent intent, String resolvedType, int flags, int userId, boolean resolveForStart, int filterCallingUid) {
        try {
            ResolveInfo bestChoice;
            Trace.traceBegin(262144L, "resolveIntent");
            if (!sUserManager.exists(userId)) {
                ResolveInfo resolveInfo = null;
                return resolveInfo;
            }
            int callingUid = Binder.getCallingUid();
            flags = this.updateFlagsForResolve(flags, userId, intent, filterCallingUid, resolveForStart);
            this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "resolve intent");
            Trace.traceBegin(262144L, "queryIntentActivities");
            List<ResolveInfo> query = this.queryIntentActivitiesInternal(intent, resolvedType, flags, filterCallingUid, userId, resolveForStart, true);
            Trace.traceEnd(262144L);
            ResolveInfo resolveInfo = bestChoice = this.chooseBestActivity(intent, resolvedType, flags, query, userId);
            return resolveInfo;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolveInfo findPersistentPreferredActivity(Intent intent, int userId) {
        if (!UserHandle.isSameApp(Binder.getCallingUid(), 1000)) {
            throw new SecurityException("findPersistentPreferredActivity can only be run by the system");
        }
        if (!sUserManager.exists(userId)) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        intent = this.updateIntentForResolve(intent);
        String resolvedType = intent.resolveTypeIfNeeded(this.mContext.getContentResolver());
        int flags = this.updateFlagsForResolve(0, userId, intent, callingUid, false);
        List<ResolveInfo> query = this.queryIntentActivitiesInternal(intent, resolvedType, flags, userId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.findPersistentPreferredActivityLP(intent, resolvedType, flags, query, false, userId);
        }
    }

    @Override
    public void setLastChosenActivity(Intent intent, String resolvedType, int flags, IntentFilter filter, int match, ComponentName activity) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        int userId = UserHandle.getCallingUserId();
        intent.setComponent(null);
        List<ResolveInfo> query = this.queryIntentActivitiesInternal(intent, resolvedType, flags, userId);
        this.findPreferredActivityNotLocked(intent, resolvedType, flags, query, 0, false, true, false, userId);
        this.addPreferredActivityInternal(filter, match, null, activity, false, userId, "Setting last chosen");
    }

    @Override
    public ResolveInfo getLastChosenActivity(Intent intent, String resolvedType, int flags) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        int userId = UserHandle.getCallingUserId();
        List<ResolveInfo> query = this.queryIntentActivitiesInternal(intent, resolvedType, flags, userId);
        return this.findPreferredActivityNotLocked(intent, resolvedType, flags, query, 0, false, false, false, userId);
    }

    private boolean areWebInstantAppsDisabled(int userId) {
        return this.mWebInstantAppsDisabled.get(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInstantAppResolutionAllowed(Intent intent, List<ResolveInfo> resolvedActivities, int userId, boolean skipPackageCheck) {
        if (this.mInstantAppResolverConnection == null) {
            return false;
        }
        if (this.mInstantAppInstallerActivity == null) {
            return false;
        }
        if (intent.getComponent() != null) {
            return false;
        }
        if ((intent.getFlags() & 0x200) != 0) {
            return false;
        }
        if (!skipPackageCheck && intent.getPackage() != null) {
            return false;
        }
        if (!intent.isWebIntent()) {
            if (resolvedActivities != null && resolvedActivities.size() != 0 || (intent.getFlags() & 0x800) == 0) {
                return false;
            }
        } else {
            if (intent.getData() == null || TextUtils.isEmpty(intent.getData().getHost())) {
                return false;
            }
            if (this.areWebInstantAppsDisabled(userId)) {
                return false;
            }
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int count = resolvedActivities == null ? 0 : resolvedActivities.size();
            for (int n = 0; n < count; ++n) {
                long packedStatus;
                int status;
                ResolveInfo info = resolvedActivities.get(n);
                String packageName = info.activityInfo.packageName;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) continue;
                if (!(info.handleAllWebDataURI || (status = (int)((packedStatus = this.getDomainVerificationStatusLPr(ps, userId)) >> 32)) != 2 && status != 4)) {
                    if (DEBUG_INSTANT) {
                        Slog.v(TAG, "DENY instant app; pkg: " + packageName + ", status: " + status);
                    }
                    return false;
                }
                if (!ps.getInstantApp(userId)) continue;
                if (DEBUG_INSTANT) {
                    Slog.v(TAG, "DENY instant app installed; pkg: " + packageName);
                }
                return false;
            }
        }
        return true;
    }

    private void requestInstantAppResolutionPhaseTwo(AuxiliaryResolveInfo responseObj, Intent origIntent, String resolvedType, String callingPackage, Bundle verificationBundle, int userId) {
        Message msg = this.mHandler.obtainMessage(20, new InstantAppRequest(responseObj, origIntent, resolvedType, callingPackage, userId, verificationBundle, false));
        this.mHandler.sendMessage(msg);
    }

    private ResolveInfo chooseBestActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int userId) {
        if (query != null) {
            int N = query.size();
            if (N == 1) {
                return query.get(0);
            }
            if (N > 1) {
                boolean debug = (intent.getFlags() & 8) != 0;
                ResolveInfo r0 = query.get(0);
                ResolveInfo r1 = query.get(1);
                if (debug) {
                    Slog.v(TAG, r0.activityInfo.name + "=" + r0.priority + " vs " + r1.activityInfo.name + "=" + r1.priority);
                }
                if (r0.priority != r1.priority || r0.preferredOrder != r1.preferredOrder || r0.isDefault != r1.isDefault) {
                    return query.get(0);
                }
                ResolveInfo ri = this.findPreferredActivityNotLocked(intent, resolvedType, flags, query, r0.priority, true, false, debug, userId);
                if (ri != null) {
                    return ri;
                }
                for (int i = 0; i < N; ++i) {
                    String packageName;
                    PackageSetting ps;
                    long packedStatus;
                    int status;
                    ri = query.get(i);
                    if (!ri.activityInfo.applicationInfo.isInstantApp() || (status = (int)((packedStatus = this.getDomainVerificationStatusLPr(ps = this.mSettings.mPackages.get(packageName = ri.activityInfo.packageName), userId)) >> 32)) == 4) continue;
                    return ri;
                }
                ri = new ResolveInfo(this.mResolveInfo);
                ri.activityInfo = new ActivityInfo(ri.activityInfo);
                ri.activityInfo.labelRes = ResolverActivity.getLabelRes(intent.getAction());
                String intentPackage = intent.getPackage();
                if (!TextUtils.isEmpty(intentPackage) && this.allHavePackage(query, intentPackage)) {
                    ApplicationInfo appi = query.get((int)0).activityInfo.applicationInfo;
                    ri.resolvePackageName = intentPackage;
                    if (this.userNeedsBadging(userId)) {
                        ri.noResourceId = true;
                    } else {
                        ri.icon = appi.icon;
                    }
                    ri.iconResourceId = appi.icon;
                    ri.labelRes = appi.labelRes;
                }
                ri.activityInfo.applicationInfo = new ApplicationInfo(ri.activityInfo.applicationInfo);
                if (userId != 0) {
                    ri.activityInfo.applicationInfo.uid = UserHandle.getUid(userId, UserHandle.getAppId(ri.activityInfo.applicationInfo.uid));
                }
                if (ri.activityInfo.metaData == null) {
                    ri.activityInfo.metaData = new Bundle();
                }
                ri.activityInfo.metaData.putBoolean("android.dock_home", true);
                return ri;
            }
        }
        return null;
    }

    private boolean allHavePackage(List<ResolveInfo> list, String packageName) {
        if (ArrayUtils.isEmpty(list)) {
            return false;
        }
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ActivityInfo ai;
            ResolveInfo ri = list.get(i);
            ActivityInfo activityInfo = ai = ri != null ? ri.activityInfo : null;
            if (ai != null && packageName.equals(ai.packageName)) continue;
            return false;
        }
        return true;
    }

    @GuardedBy(value={"mPackages"})
    private ResolveInfo findPersistentPreferredActivityLP(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, boolean debug, int userId) {
        List pprefs;
        int N = query.size();
        PersistentPreferredIntentResolver ppir = this.mSettings.mPersistentPreferredActivities.get(userId);
        if (debug) {
            Slog.v(TAG, "Looking for presistent preferred activities...");
        }
        List list = ppir != null ? ppir.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId) : (pprefs = null);
        if (pprefs != null && pprefs.size() > 0) {
            int M = pprefs.size();
            for (int i = 0; i < M; ++i) {
                PersistentPreferredActivity ppa = (PersistentPreferredActivity)pprefs.get(i);
                if (debug) {
                    Slog.v(TAG, "Checking PersistentPreferredActivity ds=" + (ppa.countDataSchemes() > 0 ? ppa.getDataScheme(0) : "<none>") + "\n  component=" + ppa.mComponent);
                    ppa.dump(new LogPrinter(2, TAG, 3), "  ");
                }
                ActivityInfo ai = this.getActivityInfo(ppa.mComponent, flags | 0x200, userId);
                if (debug) {
                    Slog.v(TAG, "Found persistent preferred activity:");
                    if (ai != null) {
                        ai.dump(new LogPrinter(2, TAG, 3), "  ");
                    } else {
                        Slog.v(TAG, "  null");
                    }
                }
                if (ai == null) continue;
                for (int j = 0; j < N; ++j) {
                    ResolveInfo ri = query.get(j);
                    if (!ri.activityInfo.applicationInfo.packageName.equals(ai.applicationInfo.packageName) || !ri.activityInfo.name.equals(ai.name)) continue;
                    if (debug) {
                        Slog.v(TAG, "Returning persistent preferred activity: " + ri.activityInfo.packageName + "/" + ri.activityInfo.name);
                    }
                    return ri;
                }
            }
        }
        return null;
    }

    private boolean isHomeIntent(Intent intent) {
        return "android.intent.action.MAIN".equals(intent.getAction()) && intent.hasCategory("android.intent.category.HOME") && intent.hasCategory("android.intent.category.DEFAULT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResolveInfo findPreferredActivityNotLocked(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int priority, boolean always, boolean removeMatches, boolean debug, int userId) {
        if (Thread.holdsLock(this.mPackages)) {
            Slog.wtf("PackageManager", "Calling thread " + Thread.currentThread().getName() + " is holding mPackages", new Throwable());
        }
        if (!PackageManagerService.sUserManager.exists(userId)) {
            return null;
        }
        callingUid = Binder.getCallingUid();
        isDeviceProvisioned = Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) == 1;
        flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, false);
        intent = this.updateIntentForResolve(intent);
        var12_12 = this.mPackages;
        synchronized (var12_12) {
            pri = this.findPersistentPreferredActivityLP(intent, resolvedType, flags, query, debug, userId);
            if (pri != null) {
                return pri;
            }
            pir = this.mSettings.mPreferredActivities.get(userId);
            if (debug) {
                Slog.v("PackageManager", "Looking for preferred activities...");
            }
            v0 = pir != null ? pir.queryIntent(intent, resolvedType, (flags & 65536) != 0, userId) : (prefs = null);
            if (prefs != null && prefs.size() > 0) {
                changed = false;
                try {
                    match = 0;
                    if (debug) {
                        Slog.v("PackageManager", "Figuring out best match...");
                    }
                    N = query.size();
                    for (j = 0; j < N; ++j) {
                        ri = query.get(j);
                        if (debug) {
                            Slog.v("PackageManager", "Match for " + ri.activityInfo + ": 0x" + Integer.toHexString(match));
                        }
                        if (ri.match <= match) continue;
                        match = ri.match;
                    }
                    if (debug) {
                        Slog.v("PackageManager", "Best match: 0x" + Integer.toHexString(match));
                    }
                    match &= 0xFFF0000;
                    M = prefs.size();
                    block8: for (i = 0; i < M; ++i) {
                        pa = (PreferredActivity)prefs.get(i);
                        if (debug) {
                            Slog.v("PackageManager", "Checking PreferredActivity ds=" + (pa.countDataSchemes() > 0 ? pa.getDataScheme(0) : "<none>") + "\n  component=" + pa.mPref.mComponent);
                            pa.dump(new LogPrinter(2, "PackageManager", 3), "  ");
                        }
                        if (pa.mPref.mMatch != match) {
                            if (!debug) continue;
                            Slog.v("PackageManager", "Skipping bad match " + Integer.toHexString(pa.mPref.mMatch));
                            continue;
                        }
                        if (always && !pa.mPref.mAlways) {
                            if (!debug) continue;
                            Slog.v("PackageManager", "Skipping mAlways=false entry");
                            continue;
                        }
                        ai = this.getActivityInfo(pa.mPref.mComponent, flags | 512 | 524288 | 262144, userId);
                        if (debug) {
                            Slog.v("PackageManager", "Found preferred activity:");
                            if (ai != null) {
                                ai.dump(new LogPrinter(2, "PackageManager", 3), "  ");
                            } else {
                                Slog.v("PackageManager", "  null");
                            }
                        }
                        v1 = excludeSetupWizardHomeActivity = this.isHomeIntent(intent) != false && isDeviceProvisioned == false;
                        if (ai == null) {
                            if (excludeSetupWizardHomeActivity) continue;
                            Slog.w("PackageManager", "Removing dangling preferred activity: " + pa.mPref.mComponent);
                            pir.removeFilter(pa);
                            changed = true;
                            continue;
                        }
                        for (j = 0; j < N; ++j) {
                            ri = query.get(j);
                            if (!ri.activityInfo.applicationInfo.packageName.equals(ai.applicationInfo.packageName) || !ri.activityInfo.name.equals(ai.name)) continue;
                            if (removeMatches) {
                                pir.removeFilter(pa);
                                changed = true;
                                continue block8;
                            }
                            if (always && !pa.mPref.sameSet(query, excludeSetupWizardHomeActivity)) {
                                if (!pa.mPref.isSuperset(query, excludeSetupWizardHomeActivity)) {
                                    Slog.i("PackageManager", "Result set changed, dropping preferred activity for " + intent + " type " + resolvedType);
                                    pir.removeFilter(pa);
                                    lastChosen = new PreferredActivity(pa, pa.mPref.mMatch, null, pa.mPref.mComponent, false);
                                    pir.addFilter(lastChosen);
                                    changed = true;
                                    var27_29 = null;
                                    return var27_29;
                                }
                                if (!excludeSetupWizardHomeActivity) {
                                    freshPa = new PreferredActivity(pa, pa.mPref.mMatch, pa.mPref.discardObsoleteComponents(query), pa.mPref.mComponent, pa.mPref.mAlways);
                                    pir.removeFilter(pa);
                                    pir.addFilter(freshPa);
                                    changed = true;
                                }
                            }
                            if (debug) {
                                Slog.v("PackageManager", "Returning preferred activity: " + ri.activityInfo.packageName + "/" + ri.activityInfo.name);
                            }
                            var26_27 = ri;
                            return var26_27;
                        }
                    }
                }
                finally {
                    if (changed) {
                        this.scheduleWritePackageRestrictionsLocked(userId);
                    }
                }
            }
            ** if (!debug) goto lbl111
        }
lbl-1000:
        // 1 sources

        {
            Slog.v("PackageManager", "No preferred activity to return");
        }
lbl111:
        // 2 sources

        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canForwardTo(Intent intent, String resolvedType, int sourceUserId, int targetUserId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        List<CrossProfileIntentFilter> matches = this.getMatchingCrossProfileIntentFilters(intent, resolvedType, sourceUserId);
        if (matches != null) {
            int size = matches.size();
            for (int i = 0; i < size; ++i) {
                if (matches.get(i).getTargetUserId() != targetUserId) continue;
                return true;
            }
        }
        if (intent.hasWebURI()) {
            int callingUid = Binder.getCallingUid();
            UserInfo parent = this.getProfileParent(sourceUserId);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                int flags = this.updateFlagsForResolve(0, parent.id, intent, callingUid, false);
                CrossProfileDomainInfo xpDomainInfo = this.getCrossProfileDomainPreferredLpr(intent, resolvedType, flags, sourceUserId, parent.id);
                return xpDomainInfo != null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo getProfileParent(int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = sUserManager.getProfileParent(userId);
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private List<CrossProfileIntentFilter> getMatchingCrossProfileIntentFilters(Intent intent, String resolvedType, int userId) {
        CrossProfileIntentResolver resolver = this.mSettings.mCrossProfileIntentResolvers.get(userId);
        if (resolver != null) {
            return resolver.queryIntent(intent, resolvedType, false, userId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ResolveInfo> queryIntentActivities(Intent intent, String resolvedType, int flags, int userId) {
        try {
            Trace.traceBegin(262144L, "queryIntentActivities");
            ParceledListSlice<ResolveInfo> parceledListSlice = new ParceledListSlice<ResolveInfo>(this.queryIntentActivitiesInternal(intent, resolvedType, flags, userId));
            return parceledListSlice;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInstantAppPackageName(int callingUid) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int appId;
            SettingBase obj;
            if (Process.isIsolated(callingUid)) {
                callingUid = this.mIsolatedOwners.get(callingUid);
            }
            if ((obj = this.mSettings.getSettingLPr(appId = UserHandle.getAppId(callingUid))) instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                boolean isInstantApp = ps.getInstantApp(UserHandle.getUserId(callingUid));
                String string2 = isInstantApp ? ps.pkg.packageName : null;
                return string2;
            }
            return null;
        }
    }

    private List<ResolveInfo> queryIntentActivitiesInternal(Intent intent, String resolvedType, int flags, int userId) {
        return this.queryIntentActivitiesInternal(intent, resolvedType, flags, Binder.getCallingUid(), userId, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> queryIntentActivitiesInternal(Intent intent, String resolvedType, int flags, int filterCallingUid, int userId, boolean resolveForStart, boolean allowDynamicSplits) {
        List<ResolveInfo> result;
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        String instantAppPkgName = this.getInstantAppPackageName(filterCallingUid);
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "query intent activities");
        String pkgName = intent.getPackage();
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        flags = this.updateFlagsForResolve(flags, userId, intent, filterCallingUid, resolveForStart, comp != null || pkgName != null);
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getActivityInfo(comp, flags, userId);
            if (ai != null) {
                boolean blockResolution;
                boolean matchInstantApp = (flags & 0x800000) != 0;
                boolean matchVisibleToInstantAppOnly = (flags & 0x1000000) != 0;
                boolean matchExplicitlyVisibleOnly = (flags & 0x2000000) != 0;
                boolean isCallerInstantApp = instantAppPkgName != null;
                boolean isTargetSameInstantApp = comp.getPackageName().equals(instantAppPkgName);
                boolean isTargetInstantApp = (ai.applicationInfo.privateFlags & 0x80) != 0;
                boolean isTargetVisibleToInstantApp = (ai.flags & 0x100000) != 0;
                boolean isTargetExplicitlyVisibleToInstantApp = isTargetVisibleToInstantApp && (ai.flags & 0x200000) == 0;
                boolean isTargetHiddenFromInstantApp = !isTargetVisibleToInstantApp || matchExplicitlyVisibleOnly && !isTargetExplicitlyVisibleToInstantApp;
                boolean bl = blockResolution = !isTargetSameInstantApp && (!matchInstantApp && !isCallerInstantApp && isTargetInstantApp || matchVisibleToInstantAppOnly && isCallerInstantApp && isTargetHiddenFromInstantApp);
                if (!blockResolution) {
                    ResolveInfo ri = new ResolveInfo();
                    ri.activityInfo = ai;
                    list.add(ri);
                }
            }
            return this.applyPostResolutionFilter(list, instantAppPkgName, allowDynamicSplits, filterCallingUid, resolveForStart, userId, intent);
        }
        boolean sortResult = false;
        boolean addInstant = false;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (pkgName == null) {
                List<CrossProfileIntentFilter> matchingFilters = this.getMatchingCrossProfileIntentFilters(intent, resolvedType, userId);
                ResolveInfo xpResolveInfo = this.querySkipCurrentProfileIntents(matchingFilters, intent, resolvedType, flags, userId);
                if (xpResolveInfo != null) {
                    ArrayList<ResolveInfo> xpResult = new ArrayList<ResolveInfo>(1);
                    xpResult.add(xpResolveInfo);
                    return this.applyPostResolutionFilter(this.filterIfNotSystemUser(xpResult, userId), instantAppPkgName, allowDynamicSplits, filterCallingUid, resolveForStart, userId, intent);
                }
                result = this.filterIfNotSystemUser(this.mComponentResolver.queryActivities(intent, resolvedType, flags, userId), userId);
                addInstant = this.isInstantAppResolutionAllowed(intent, result, userId, false);
                boolean hasNonNegativePriorityResult = this.hasNonNegativePriority(result);
                xpResolveInfo = this.queryCrossProfileIntents(matchingFilters, intent, resolvedType, flags, userId, hasNonNegativePriorityResult);
                if (xpResolveInfo != null && this.isUserEnabled(xpResolveInfo.targetUserId)) {
                    boolean isVisibleToUser;
                    boolean bl = isVisibleToUser = this.filterIfNotSystemUser(Collections.singletonList(xpResolveInfo), userId).size() > 0;
                    if (isVisibleToUser) {
                        result.add(xpResolveInfo);
                        sortResult = true;
                    }
                }
                if (intent.hasWebURI()) {
                    CrossProfileDomainInfo xpDomainInfo = null;
                    UserInfo parent = this.getProfileParent(userId);
                    if (parent != null) {
                        xpDomainInfo = this.getCrossProfileDomainPreferredLpr(intent, resolvedType, flags, userId, parent.id);
                    }
                    if (xpDomainInfo != null) {
                        if (xpResolveInfo != null) {
                            result.remove(xpResolveInfo);
                        }
                        if (result.size() == 0 && !addInstant) {
                            result.add(xpDomainInfo.resolveInfo);
                            return this.applyPostResolutionFilter(result, instantAppPkgName, allowDynamicSplits, filterCallingUid, resolveForStart, userId, intent);
                        }
                    } else if (result.size() <= 1 && !addInstant) {
                        return this.applyPostResolutionFilter(result, instantAppPkgName, allowDynamicSplits, filterCallingUid, resolveForStart, userId, intent);
                    }
                    result = this.filterCandidatesWithDomainPreferredActivitiesLPr(intent, flags, result, xpDomainInfo, userId);
                    sortResult = true;
                }
            } else {
                PackageParser.Package pkg = this.mPackages.get(pkgName);
                result = null;
                if (pkg != null) {
                    result = this.filterIfNotSystemUser(this.mComponentResolver.queryActivities(intent, resolvedType, flags, pkg.activities, userId), userId);
                }
                if (result == null || result.size() == 0) {
                    addInstant = this.isInstantAppResolutionAllowed(intent, null, userId, true);
                    if (result == null) {
                        result = new ArrayList<ResolveInfo>();
                    }
                }
            }
        }
        if (addInstant) {
            result = this.maybeAddInstantAppInstaller(result, intent, resolvedType, flags, userId, resolveForStart);
        }
        if (sortResult) {
            Collections.sort(result, ComponentResolver.RESOLVE_PRIORITY_SORTER);
        }
        return this.applyPostResolutionFilter(result, instantAppPkgName, allowDynamicSplits, filterCallingUid, resolveForStart, userId, intent);
    }

    private List<ResolveInfo> maybeAddInstantAppInstaller(List<ResolveInfo> result, Intent intent, String resolvedType, int flags, int userId, boolean resolveForStart) {
        boolean alreadyResolvedLocally = (flags & 0x800000) != 0;
        ResolveInfo localInstantApp = null;
        boolean blockResolution = false;
        if (!alreadyResolvedLocally) {
            List<ResolveInfo> instantApps = this.mComponentResolver.queryActivities(intent, resolvedType, flags | 0x40 | 0x800000 | 0x1000000, userId);
            for (int i = instantApps.size() - 1; i >= 0; --i) {
                ResolveInfo info = instantApps.get(i);
                String packageName = info.activityInfo.packageName;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (!ps.getInstantApp(userId)) continue;
                long packedStatus = this.getDomainVerificationStatusLPr(ps, userId);
                int status = (int)(packedStatus >> 32);
                if (status == 3) {
                    if (DEBUG_INSTANT) {
                        Slog.v(TAG, "Instant app marked to never run; pkg: " + packageName);
                    }
                    blockResolution = true;
                    break;
                }
                if (DEBUG_INSTANT) {
                    Slog.v(TAG, "Found installed instant app; pkg: " + packageName);
                }
                localInstantApp = info;
                break;
            }
        }
        AuxiliaryResolveInfo auxiliaryResponse = null;
        if (!blockResolution) {
            if (localInstantApp == null) {
                Trace.traceBegin(262144L, "resolveEphemeral");
                InstantAppRequest requestObject = new InstantAppRequest(null, intent, resolvedType, null, userId, null, resolveForStart);
                auxiliaryResponse = InstantAppResolver.doInstantAppResolutionPhaseOne(this.mInstantAppResolverConnection, requestObject);
                Trace.traceEnd(262144L);
            } else {
                ApplicationInfo ai = localInstantApp.activityInfo.applicationInfo;
                auxiliaryResponse = new AuxiliaryResolveInfo(null, ai.packageName, ai.longVersionCode, null);
            }
        }
        if (intent.isWebIntent() && auxiliaryResponse == null) {
            return result;
        }
        PackageSetting ps = this.mSettings.mPackages.get(this.mInstantAppInstallerActivity.packageName);
        if (ps == null || !ps.readUserState(userId).isEnabled(this.mInstantAppInstallerActivity, 0)) {
            return result;
        }
        ResolveInfo ephemeralInstaller = new ResolveInfo(this.mInstantAppInstallerInfo);
        ephemeralInstaller.activityInfo = PackageParser.generateActivityInfo(this.mInstantAppInstallerActivity, 0, ps.readUserState(userId), userId);
        ephemeralInstaller.match = 0x588000;
        ephemeralInstaller.filter = new IntentFilter();
        if (intent.getAction() != null) {
            ephemeralInstaller.filter.addAction(intent.getAction());
        }
        if (intent.getData() != null && intent.getData().getPath() != null) {
            ephemeralInstaller.filter.addDataPath(intent.getData().getPath(), 0);
        }
        ephemeralInstaller.isInstantAppAvailable = true;
        ephemeralInstaller.isDefault = true;
        ephemeralInstaller.auxiliaryInfo = auxiliaryResponse;
        if (DEBUG_INSTANT) {
            Slog.v(TAG, "Adding ephemeral installer to the ResolveInfo list");
        }
        result.add(ephemeralInstaller);
        return result;
    }

    private CrossProfileDomainInfo getCrossProfileDomainPreferredLpr(Intent intent, String resolvedType, int flags, int sourceUserId, int parentUserId) {
        if (!sUserManager.hasUserRestriction("allow_parent_profile_app_linking", sourceUserId)) {
            return null;
        }
        List<ResolveInfo> resultTargetUser = this.mComponentResolver.queryActivities(intent, resolvedType, flags, parentUserId);
        if (resultTargetUser == null || resultTargetUser.isEmpty()) {
            return null;
        }
        CrossProfileDomainInfo result = null;
        int size = resultTargetUser.size();
        for (int i = 0; i < size; ++i) {
            String packageName;
            PackageSetting ps;
            ResolveInfo riTargetUser = resultTargetUser.get(i);
            if (riTargetUser.handleAllWebDataURI || (ps = this.mSettings.mPackages.get(packageName = riTargetUser.activityInfo.packageName)) == null) continue;
            long verificationState = this.getDomainVerificationStatusLPr(ps, parentUserId);
            int status = (int)(verificationState >> 32);
            if (result == null) {
                result = new CrossProfileDomainInfo();
                result.resolveInfo = this.createForwardingResolveInfoUnchecked(new IntentFilter(), sourceUserId, parentUserId);
                result.bestDomainVerificationStatus = status;
                continue;
            }
            result.bestDomainVerificationStatus = this.bestDomainVerificationStatus(status, result.bestDomainVerificationStatus);
        }
        if (result != null && result.bestDomainVerificationStatus == 3) {
            return null;
        }
        return result;
    }

    private int bestDomainVerificationStatus(int status1, int status2) {
        if (status1 == 3) {
            return status2;
        }
        if (status2 == 3) {
            return status1;
        }
        return (int)MathUtils.max(status1, status2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserEnabled(int userId) {
        long callingId = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = sUserManager.getUserInfo(userId);
            boolean bl = userInfo != null && userInfo.isEnabled();
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    private List<ResolveInfo> filterIfNotSystemUser(List<ResolveInfo> resolveInfos, int userId) {
        if (userId == 0) {
            return resolveInfos;
        }
        for (int i = resolveInfos.size() - 1; i >= 0; --i) {
            ResolveInfo info = resolveInfos.get(i);
            if ((info.activityInfo.flags & 0x20000000) == 0) continue;
            resolveInfos.remove(i);
        }
        return resolveInfos;
    }

    private List<ResolveInfo> applyPostResolutionFilter(List<ResolveInfo> resolveInfos, String ephemeralPkgName, boolean allowDynamicSplits, int filterCallingUid, boolean resolveForStart, int userId, Intent intent) {
        boolean blockInstant = intent.isWebIntent() && this.areWebInstantAppsDisabled(userId);
        for (int i = resolveInfos.size() - 1; i >= 0; --i) {
            boolean isEphemeralApp;
            ResolveInfo info = resolveInfos.get(i);
            if (info.isInstantAppAvailable && blockInstant) {
                resolveInfos.remove(i);
                continue;
            }
            if (allowDynamicSplits && info.activityInfo != null && info.activityInfo.splitName != null && !ArrayUtils.contains(info.activityInfo.applicationInfo.splitNames, info.activityInfo.splitName)) {
                if (this.mInstantAppInstallerActivity == null) {
                    resolveInfos.remove(i);
                    continue;
                }
                if (blockInstant && this.isInstantApp(info.activityInfo.packageName, userId)) {
                    resolveInfos.remove(i);
                    continue;
                }
                ResolveInfo installerInfo = new ResolveInfo(this.mInstantAppInstallerInfo);
                ComponentName installFailureActivity = this.findInstallFailureActivity(info.activityInfo.packageName, filterCallingUid, userId);
                installerInfo.auxiliaryInfo = new AuxiliaryResolveInfo(installFailureActivity, info.activityInfo.packageName, info.activityInfo.applicationInfo.longVersionCode, info.activityInfo.splitName);
                installerInfo.filter = new IntentFilter();
                installerInfo.resolvePackageName = info.getComponentInfo().packageName;
                installerInfo.labelRes = info.resolveLabelResId();
                installerInfo.icon = info.resolveIconResId();
                installerInfo.isInstantAppAvailable = true;
                resolveInfos.set(i, installerInfo);
                continue;
            }
            if (ephemeralPkgName == null || ephemeralPkgName.equals(info.activityInfo.packageName) || resolveForStart && (intent.isWebIntent() || (intent.getFlags() & 0x800) != 0) && intent.getPackage() == null && intent.getComponent() == null || !(isEphemeralApp = info.activityInfo.applicationInfo.isInstantApp()) && (info.activityInfo.flags & 0x100000) != 0) continue;
            resolveInfos.remove(i);
        }
        return resolveInfos;
    }

    private ComponentName findInstallFailureActivity(String packageName, int filterCallingUid, int userId) {
        Intent failureActivityIntent = new Intent("android.intent.action.INSTALL_FAILURE");
        failureActivityIntent.setPackage(packageName);
        List<ResolveInfo> result = this.queryIntentActivitiesInternal(failureActivityIntent, null, 0, filterCallingUid, userId, false, false);
        int NR = result.size();
        if (NR > 0) {
            for (int i = 0; i < NR; ++i) {
                ResolveInfo info = result.get(i);
                if (info.activityInfo.splitName != null) continue;
                return new ComponentName(packageName, info.activityInfo.name);
            }
        }
        return null;
    }

    private boolean hasNonNegativePriority(List<ResolveInfo> resolveInfos) {
        return resolveInfos.size() > 0 && resolveInfos.get((int)0).priority >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> filterCandidatesWithDomainPreferredActivitiesLPr(Intent intent, int matchFlags, List<ResolveInfo> candidates, CrossProfileDomainInfo xpDomainInfo, int userId) {
        boolean debug = (intent.getFlags() & 8) != 0;
        ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>();
        ArrayList<Object> alwaysList = new ArrayList<Object>();
        ArrayList<Object> undefinedList = new ArrayList<Object>();
        ArrayList<Object> alwaysAskList = new ArrayList<Object>();
        ArrayList<Object> neverList = new ArrayList<Object>();
        ArrayList<Object> matchAllList = new ArrayList<Object>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int count = candidates.size();
            for (int n = 0; n < count; ++n) {
                ResolveInfo info = candidates.get(n);
                String packageName = info.activityInfo.packageName;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) continue;
                if (info.handleAllWebDataURI) {
                    matchAllList.add(info);
                    continue;
                }
                long packedStatus = this.getDomainVerificationStatusLPr(ps, userId);
                int status = (int)(packedStatus >> 32);
                int linkGeneration = (int)(packedStatus & 0xFFFFFFFFFFFFFFFFL);
                if (status == 2) {
                    if (debug) {
                        Slog.i(TAG, "  + always: " + info.activityInfo.packageName + " : linkgen=" + linkGeneration);
                    }
                    info.preferredOrder = linkGeneration;
                    alwaysList.add(info);
                    continue;
                }
                if (status == 3) {
                    if (debug) {
                        Slog.i(TAG, "  + never: " + info.activityInfo.packageName);
                    }
                    neverList.add(info);
                    continue;
                }
                if (status == 4) {
                    if (debug) {
                        Slog.i(TAG, "  + always-ask: " + info.activityInfo.packageName);
                    }
                    alwaysAskList.add(info);
                    continue;
                }
                if (status != 0 && status != 1) continue;
                if (debug) {
                    Slog.i(TAG, "  + ask: " + info.activityInfo.packageName);
                }
                undefinedList.add(info);
            }
            boolean includeBrowser = false;
            if (alwaysList.size() > 0) {
                result.addAll(alwaysList);
            } else {
                result.addAll(undefinedList);
                if (xpDomainInfo != null && xpDomainInfo.bestDomainVerificationStatus != 3) {
                    result.add(xpDomainInfo.resolveInfo);
                }
                includeBrowser = true;
            }
            if (alwaysAskList.size() > 0) {
                for (ResolveInfo i : result) {
                    i.preferredOrder = 0;
                }
                result.addAll(alwaysAskList);
                includeBrowser = true;
            }
            if (includeBrowser) {
                if ((matchFlags & 0x20000) != 0) {
                    result.addAll(matchAllList);
                } else {
                    String defaultBrowserPackageName = this.getDefaultBrowserPackageName(userId);
                    int maxMatchPrio = 0;
                    ResolveInfo defaultBrowserMatch = null;
                    int numCandidates = matchAllList.size();
                    for (int n = 0; n < numCandidates; ++n) {
                        ResolveInfo info = (ResolveInfo)matchAllList.get(n);
                        if (info.priority > maxMatchPrio) {
                            maxMatchPrio = info.priority;
                        }
                        if (!info.activityInfo.packageName.equals(defaultBrowserPackageName) || defaultBrowserMatch != null && defaultBrowserMatch.priority >= info.priority) continue;
                        if (debug) {
                            Slog.v(TAG, "Considering default browser match " + info);
                        }
                        defaultBrowserMatch = info;
                    }
                    if (defaultBrowserMatch != null && defaultBrowserMatch.priority >= maxMatchPrio && !TextUtils.isEmpty(defaultBrowserPackageName)) {
                        if (debug) {
                            Slog.v(TAG, "Default browser match " + defaultBrowserMatch);
                        }
                        result.add(defaultBrowserMatch);
                    } else {
                        result.addAll(matchAllList);
                    }
                }
                if (result.size() == 0) {
                    result.addAll(candidates);
                    result.removeAll(neverList);
                }
            }
        }
        return result;
    }

    private long getDomainVerificationStatusLPr(PackageSetting ps, int userId) {
        long result = ps.getDomainVerificationStatusForUser(userId);
        if (result >> 32 == 0L && ps.getIntentFilterVerificationInfo() != null) {
            result = (long)ps.getIntentFilterVerificationInfo().getStatus() << 32;
        }
        return result;
    }

    private ResolveInfo querySkipCurrentProfileIntents(List<CrossProfileIntentFilter> matchingFilters, Intent intent, String resolvedType, int flags, int sourceUserId) {
        if (matchingFilters != null) {
            int size = matchingFilters.size();
            for (int i = 0; i < size; ++i) {
                ResolveInfo resolveInfo;
                CrossProfileIntentFilter filter = matchingFilters.get(i);
                if ((filter.getFlags() & 2) == 0 || (resolveInfo = this.createForwardingResolveInfo(filter, intent, resolvedType, flags, sourceUserId)) == null) continue;
                return resolveInfo;
            }
        }
        return null;
    }

    private ResolveInfo queryCrossProfileIntents(List<CrossProfileIntentFilter> matchingFilters, Intent intent, String resolvedType, int flags, int sourceUserId, boolean matchInCurrentProfile) {
        if (matchingFilters != null) {
            SparseBooleanArray alreadyTriedUserIds = new SparseBooleanArray();
            int size = matchingFilters.size();
            for (int i = 0; i < size; ++i) {
                boolean skipCurrentProfileIfNoMatchFound;
                CrossProfileIntentFilter filter = matchingFilters.get(i);
                int targetUserId = filter.getTargetUserId();
                boolean skipCurrentProfile = (filter.getFlags() & 2) != 0;
                boolean bl = skipCurrentProfileIfNoMatchFound = (filter.getFlags() & 4) != 0;
                if (skipCurrentProfile || alreadyTriedUserIds.get(targetUserId) || skipCurrentProfileIfNoMatchFound && matchInCurrentProfile) continue;
                ResolveInfo resolveInfo = this.createForwardingResolveInfo(filter, intent, resolvedType, flags, sourceUserId);
                if (resolveInfo != null) {
                    return resolveInfo;
                }
                alreadyTriedUserIds.put(targetUserId, true);
            }
        }
        return null;
    }

    private ResolveInfo createForwardingResolveInfo(CrossProfileIntentFilter filter, Intent intent, String resolvedType, int flags, int sourceUserId) {
        int targetUserId = filter.getTargetUserId();
        List<ResolveInfo> resultTargetUser = this.mComponentResolver.queryActivities(intent, resolvedType, flags, targetUserId);
        if (resultTargetUser != null && this.isUserEnabled(targetUserId)) {
            for (int i = resultTargetUser.size() - 1; i >= 0; --i) {
                if ((resultTargetUser.get((int)i).activityInfo.applicationInfo.flags & 0x40000000) != 0) continue;
                return this.createForwardingResolveInfoUnchecked(filter, sourceUserId, targetUserId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolveInfo createForwardingResolveInfoUnchecked(IntentFilter filter, int sourceUserId, int targetUserId) {
        boolean targetIsProfile;
        ResolveInfo forwardingResolveInfo = new ResolveInfo();
        long ident = Binder.clearCallingIdentity();
        try {
            targetIsProfile = sUserManager.getUserInfo(targetUserId).isManagedProfile();
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        String className = targetIsProfile ? IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE : IntentForwarderActivity.FORWARD_INTENT_TO_PARENT;
        ComponentName forwardingActivityComponentName = new ComponentName(this.mAndroidApplication.packageName, className);
        ActivityInfo forwardingActivityInfo = this.getActivityInfo(forwardingActivityComponentName, 0, sourceUserId);
        if (!targetIsProfile) {
            forwardingActivityInfo.showUserIcon = targetUserId;
            forwardingResolveInfo.noResourceId = true;
        }
        forwardingResolveInfo.activityInfo = forwardingActivityInfo;
        forwardingResolveInfo.priority = 0;
        forwardingResolveInfo.preferredOrder = 0;
        forwardingResolveInfo.match = 0;
        forwardingResolveInfo.isDefault = true;
        forwardingResolveInfo.filter = filter;
        forwardingResolveInfo.targetUserId = targetUserId;
        return forwardingResolveInfo;
    }

    @Override
    public ParceledListSlice<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, String[] specificTypes, Intent intent, String resolvedType, int flags, int userId) {
        return new ParceledListSlice<ResolveInfo>(this.queryIntentActivityOptionsInternal(caller, specifics, specificTypes, intent, resolvedType, flags, userId));
    }

    private List<ResolveInfo> queryIntentActivityOptionsInternal(ComponentName caller, Intent[] specifics, String[] specificTypes, Intent intent, String resolvedType, int flags, int userId) {
        int N;
        int i;
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, false);
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "query intent activity options");
        String resultsAction = intent.getAction();
        List<ResolveInfo> results = this.queryIntentActivitiesInternal(intent, resolvedType, flags | 0x40, userId);
        int specificsPos = 0;
        if (specifics != null) {
            for (i = 0; i < specifics.length; ++i) {
                Intent sintent = specifics[i];
                if (sintent == null) continue;
                String action = sintent.getAction();
                if (resultsAction != null && resultsAction.equals(action)) {
                    action = null;
                }
                ResolveInfo ri = null;
                ActivityInfo ai = null;
                ComponentName comp = sintent.getComponent();
                if (comp == null) {
                    ri = this.resolveIntent(sintent, specificTypes != null ? specificTypes[i] : null, flags, userId);
                    if (ri == null) continue;
                    if (ri == this.mResolveInfo) {
                        // empty if block
                    }
                    ai = ri.activityInfo;
                    comp = new ComponentName(ai.applicationInfo.packageName, ai.name);
                } else {
                    ai = this.getActivityInfo(comp, flags, userId);
                    if (ai == null) continue;
                }
                N = results.size();
                for (int j = specificsPos; j < N; ++j) {
                    ResolveInfo sri = results.get(j);
                    if ((!sri.activityInfo.name.equals(comp.getClassName()) || !sri.activityInfo.applicationInfo.packageName.equals(comp.getPackageName())) && (action == null || !sri.filter.matchAction(action))) continue;
                    results.remove(j);
                    if (ri == null) {
                        ri = sri;
                    }
                    --j;
                    --N;
                }
                if (ri == null) {
                    ri = new ResolveInfo();
                    ri.activityInfo = ai;
                }
                results.add(specificsPos, ri);
                ri.specificIndex = i;
                ++specificsPos;
            }
        }
        N = results.size();
        for (i = specificsPos; i < N - 1; ++i) {
            Iterator<String> it;
            ResolveInfo rii = results.get(i);
            if (rii.filter == null || (it = rii.filter.actionsIterator()) == null) continue;
            while (it.hasNext()) {
                String action = it.next();
                if (resultsAction != null && resultsAction.equals(action)) continue;
                for (int j = i + 1; j < N; ++j) {
                    ResolveInfo rij = results.get(j);
                    if (rij.filter == null || !rij.filter.hasAction(action)) continue;
                    results.remove(j);
                    --j;
                    --N;
                }
            }
            if ((flags & 0x40) != 0) continue;
            rii.filter = null;
        }
        if (caller != null) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                ActivityInfo ainfo = results.get((int)i).activityInfo;
                if (!caller.getPackageName().equals(ainfo.applicationInfo.packageName) || !caller.getClassName().equals(ainfo.name)) continue;
                results.remove(i);
                break;
            }
        }
        if ((flags & 0x40) == 0) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                results.get((int)i).filter = null;
            }
        }
        return results;
    }

    @Override
    public ParceledListSlice<ResolveInfo> queryIntentReceivers(Intent intent, String resolvedType, int flags, int userId) {
        return new ParceledListSlice<ResolveInfo>(this.queryIntentReceiversInternal(intent, resolvedType, flags, userId, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> queryIntentReceiversInternal(Intent intent, String resolvedType, int flags, int userId, boolean allowDynamicSplits) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "query intent receivers");
        String instantAppPkgName = this.getInstantAppPackageName(callingUid);
        flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, false);
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getReceiverInfo(comp, flags, userId);
            if (ai != null) {
                boolean blockResolution;
                boolean matchInstantApp = (flags & 0x800000) != 0;
                boolean matchVisibleToInstantAppOnly = (flags & 0x1000000) != 0;
                boolean matchExplicitlyVisibleOnly = (flags & 0x2000000) != 0;
                boolean isCallerInstantApp = instantAppPkgName != null;
                boolean isTargetSameInstantApp = comp.getPackageName().equals(instantAppPkgName);
                boolean isTargetInstantApp = (ai.applicationInfo.privateFlags & 0x80) != 0;
                boolean isTargetVisibleToInstantApp = (ai.flags & 0x100000) != 0;
                boolean isTargetExplicitlyVisibleToInstantApp = isTargetVisibleToInstantApp && (ai.flags & 0x200000) == 0;
                boolean isTargetHiddenFromInstantApp = !isTargetVisibleToInstantApp || matchExplicitlyVisibleOnly && !isTargetExplicitlyVisibleToInstantApp;
                boolean bl = blockResolution = !isTargetSameInstantApp && (!matchInstantApp && !isCallerInstantApp && isTargetInstantApp || matchVisibleToInstantAppOnly && isCallerInstantApp && isTargetHiddenFromInstantApp);
                if (!blockResolution) {
                    ResolveInfo ri = new ResolveInfo();
                    ri.activityInfo = ai;
                    list.add(ri);
                }
            }
            return this.applyPostResolutionFilter(list, instantAppPkgName, allowDynamicSplits, callingUid, false, userId, intent);
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                List<ResolveInfo> result = this.mComponentResolver.queryReceivers(intent, resolvedType, flags, userId);
                return this.applyPostResolutionFilter(result, instantAppPkgName, allowDynamicSplits, callingUid, false, userId, intent);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                List<ResolveInfo> result = this.mComponentResolver.queryReceivers(intent, resolvedType, flags, pkg.receivers, userId);
                return this.applyPostResolutionFilter(result, instantAppPkgName, allowDynamicSplits, callingUid, false, userId, intent);
            }
            return Collections.emptyList();
        }
    }

    @Override
    public ResolveInfo resolveService(Intent intent, String resolvedType, int flags, int userId) {
        int callingUid = Binder.getCallingUid();
        return this.resolveServiceInternal(intent, resolvedType, flags, userId, callingUid);
    }

    private ResolveInfo resolveServiceInternal(Intent intent, String resolvedType, int flags, int userId, int callingUid) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        List<ResolveInfo> query = this.queryIntentServicesInternal(intent, resolvedType, flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, false), userId, callingUid, false);
        if (query != null && query.size() >= 1) {
            return query.get(0);
        }
        return null;
    }

    @Override
    public ParceledListSlice<ResolveInfo> queryIntentServices(Intent intent, String resolvedType, int flags, int userId) {
        int callingUid = Binder.getCallingUid();
        return new ParceledListSlice<ResolveInfo>(this.queryIntentServicesInternal(intent, resolvedType, flags, userId, callingUid, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> queryIntentServicesInternal(Intent intent, String resolvedType, int flags, int userId, int callingUid, boolean includeInstantApps) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "query intent receivers");
        String instantAppPkgName = this.getInstantAppPackageName(callingUid);
        flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, includeInstantApps);
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ServiceInfo si = this.getServiceInfo(comp, flags, userId);
            if (si != null) {
                boolean blockResolution;
                boolean matchInstantApp = (flags & 0x800000) != 0;
                boolean matchVisibleToInstantAppOnly = (flags & 0x1000000) != 0;
                boolean isCallerInstantApp = instantAppPkgName != null;
                boolean isTargetSameInstantApp = comp.getPackageName().equals(instantAppPkgName);
                boolean isTargetInstantApp = (si.applicationInfo.privateFlags & 0x80) != 0;
                boolean isTargetHiddenFromInstantApp = (si.flags & 0x100000) == 0;
                boolean bl = blockResolution = !isTargetSameInstantApp && (!matchInstantApp && !isCallerInstantApp && isTargetInstantApp || matchVisibleToInstantAppOnly && isCallerInstantApp && isTargetHiddenFromInstantApp);
                if (!blockResolution) {
                    ResolveInfo ri = new ResolveInfo();
                    ri.serviceInfo = si;
                    list.add(ri);
                }
            }
            return list;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.applyPostServiceResolutionFilter(this.mComponentResolver.queryServices(intent, resolvedType, flags, userId), instantAppPkgName);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.applyPostServiceResolutionFilter(this.mComponentResolver.queryServices(intent, resolvedType, flags, pkg.services, userId), instantAppPkgName);
            }
            return Collections.emptyList();
        }
    }

    private List<ResolveInfo> applyPostServiceResolutionFilter(List<ResolveInfo> resolveInfos, String instantAppPkgName) {
        if (instantAppPkgName == null) {
            return resolveInfos;
        }
        for (int i = resolveInfos.size() - 1; i >= 0; --i) {
            ResolveInfo info = resolveInfos.get(i);
            boolean isEphemeralApp = info.serviceInfo.applicationInfo.isInstantApp();
            if (isEphemeralApp && instantAppPkgName.equals(info.serviceInfo.packageName)) {
                if (info.serviceInfo.splitName == null || ArrayUtils.contains(info.serviceInfo.applicationInfo.splitNames, info.serviceInfo.splitName)) continue;
                if (DEBUG_INSTANT) {
                    Slog.v(TAG, "Adding ephemeral installer to the ResolveInfo list");
                }
                ResolveInfo installerInfo = new ResolveInfo(this.mInstantAppInstallerInfo);
                installerInfo.auxiliaryInfo = new AuxiliaryResolveInfo(null, info.serviceInfo.packageName, info.serviceInfo.applicationInfo.longVersionCode, info.serviceInfo.splitName);
                installerInfo.filter = new IntentFilter();
                installerInfo.resolvePackageName = info.getComponentInfo().packageName;
                resolveInfos.set(i, installerInfo);
                continue;
            }
            if (!isEphemeralApp && (info.serviceInfo.flags & 0x100000) != 0) continue;
            resolveInfos.remove(i);
        }
        return resolveInfos;
    }

    @Override
    public ParceledListSlice<ResolveInfo> queryIntentContentProviders(Intent intent, String resolvedType, int flags, int userId) {
        return new ParceledListSlice<ResolveInfo>(this.queryIntentContentProvidersInternal(intent, resolvedType, flags, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> queryIntentContentProvidersInternal(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        int callingUid = Binder.getCallingUid();
        String instantAppPkgName = this.getInstantAppPackageName(callingUid);
        flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, false);
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ProviderInfo pi = this.getProviderInfo(comp, flags, userId);
            if (pi != null) {
                boolean blockResolution;
                boolean matchInstantApp = (flags & 0x800000) != 0;
                boolean matchVisibleToInstantAppOnly = (flags & 0x1000000) != 0;
                boolean isCallerInstantApp = instantAppPkgName != null;
                boolean isTargetSameInstantApp = comp.getPackageName().equals(instantAppPkgName);
                boolean isTargetInstantApp = (pi.applicationInfo.privateFlags & 0x80) != 0;
                boolean isTargetHiddenFromInstantApp = (pi.flags & 0x100000) == 0;
                boolean bl = blockResolution = !isTargetSameInstantApp && (!matchInstantApp && !isCallerInstantApp && isTargetInstantApp || matchVisibleToInstantAppOnly && isCallerInstantApp && isTargetHiddenFromInstantApp);
                if (!blockResolution) {
                    ResolveInfo ri = new ResolveInfo();
                    ri.providerInfo = pi;
                    list.add(ri);
                }
            }
            return list;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.applyPostContentProviderResolutionFilter(this.mComponentResolver.queryProviders(intent, resolvedType, flags, userId), instantAppPkgName);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.applyPostContentProviderResolutionFilter(this.mComponentResolver.queryProviders(intent, resolvedType, flags, pkg.providers, userId), instantAppPkgName);
            }
            return Collections.emptyList();
        }
    }

    private List<ResolveInfo> applyPostContentProviderResolutionFilter(List<ResolveInfo> resolveInfos, String instantAppPkgName) {
        if (instantAppPkgName == null) {
            return resolveInfos;
        }
        for (int i = resolveInfos.size() - 1; i >= 0; --i) {
            ResolveInfo info = resolveInfos.get(i);
            boolean isEphemeralApp = info.providerInfo.applicationInfo.isInstantApp();
            if (isEphemeralApp && instantAppPkgName.equals(info.providerInfo.packageName)) {
                if (info.providerInfo.splitName == null || ArrayUtils.contains(info.providerInfo.applicationInfo.splitNames, info.providerInfo.splitName)) continue;
                if (DEBUG_INSTANT) {
                    Slog.v(TAG, "Adding ephemeral installer to the ResolveInfo list");
                }
                ResolveInfo installerInfo = new ResolveInfo(this.mInstantAppInstallerInfo);
                installerInfo.auxiliaryInfo = new AuxiliaryResolveInfo(null, info.providerInfo.packageName, info.providerInfo.applicationInfo.longVersionCode, info.providerInfo.splitName);
                installerInfo.filter = new IntentFilter();
                installerInfo.resolvePackageName = info.getComponentInfo().packageName;
                resolveInfos.set(i, installerInfo);
                continue;
            }
            if (!isEphemeralApp && (info.providerInfo.flags & 0x100000) != 0) continue;
            resolveInfos.remove(i);
        }
        return resolveInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInfo> getInstalledPackages(int flags, int userId) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return ParceledListSlice.emptyList();
        }
        if (!sUserManager.exists(userId)) {
            return ParceledListSlice.emptyList();
        }
        boolean listUninstalled = ((flags = this.updateFlagsForPackage(flags, userId, null)) & 0x402000) != 0;
        boolean listApex = (flags & 0x40000000) != 0;
        boolean listFactory = (flags & 0x200000) != 0;
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "get installed packages");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<PackageInfo> list;
            if (listUninstalled) {
                list = new ArrayList(this.mSettings.mPackages.size());
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    PackageInfo pi;
                    if (this.filterSharedLibPackageLPr(ps, callingUid, userId, flags) || this.filterAppAccessLPr(ps, callingUid, userId) || (pi = this.generatePackageInfo(ps, flags, userId)) == null) continue;
                    list.add(pi);
                }
            } else {
                list = new ArrayList<PackageInfo>(this.mPackages.size());
                for (PackageParser.Package p : this.mPackages.values()) {
                    PackageInfo pi;
                    PackageSetting ps = (PackageSetting)p.mExtras;
                    if (this.filterSharedLibPackageLPr(ps, callingUid, userId, flags) || this.filterAppAccessLPr(ps, callingUid, userId) || (pi = this.generatePackageInfo((PackageSetting)p.mExtras, flags, userId)) == null) continue;
                    list.add(pi);
                }
            }
            if (listApex) {
                if (listFactory) {
                    list.addAll(this.mApexManager.getFactoryPackages());
                } else {
                    list.addAll(this.mApexManager.getActivePackages());
                }
                if (listUninstalled) {
                    list.addAll(this.mApexManager.getInactivePackages());
                }
            }
            return new ParceledListSlice<PackageInfo>(list);
        }
    }

    private void addPackageHoldingPermissions(ArrayList<PackageInfo> list, PackageSetting ps, String[] permissions, boolean[] tmp, int flags, int userId) {
        int numMatch = 0;
        PermissionsState permissionsState = ps.getPermissionsState();
        for (int i = 0; i < permissions.length; ++i) {
            String permission2 = permissions[i];
            if (permissionsState.hasPermission(permission2, userId)) {
                tmp[i] = true;
                ++numMatch;
                continue;
            }
            tmp[i] = false;
        }
        if (numMatch == 0) {
            return;
        }
        PackageInfo pi = this.generatePackageInfo(ps, flags, userId);
        if (pi != null) {
            if ((flags & 0x1000) == 0) {
                if (numMatch == permissions.length) {
                    pi.requestedPermissions = permissions;
                } else {
                    pi.requestedPermissions = new String[numMatch];
                    numMatch = 0;
                    for (int i = 0; i < permissions.length; ++i) {
                        if (!tmp[i]) continue;
                        pi.requestedPermissions[numMatch] = permissions[i];
                        ++numMatch;
                    }
                }
            }
            list.add(pi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return ParceledListSlice.emptyList();
        }
        flags = this.updateFlagsForPackage(flags, userId, permissions);
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "get packages holding permissions");
        boolean listUninstalled = (flags & 0x402000) != 0;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
            boolean[] tmpBools = new boolean[permissions.length];
            if (listUninstalled) {
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    this.addPackageHoldingPermissions(list, ps, permissions, tmpBools, flags, userId);
                }
            } else {
                for (PackageParser.Package pkg : this.mPackages.values()) {
                    PackageSetting ps = (PackageSetting)pkg.mExtras;
                    if (ps == null) continue;
                    this.addPackageHoldingPermissions(list, ps, permissions, tmpBools, flags, userId);
                }
            }
            return new ParceledListSlice<PackageInfo>(list);
        }
    }

    @Override
    public ParceledListSlice<ApplicationInfo> getInstalledApplications(int flags, int userId) {
        int callingUid = Binder.getCallingUid();
        return new ParceledListSlice<ApplicationInfo>(this.getInstalledApplicationsListInternal(flags, userId, callingUid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApplicationInfo> getInstalledApplicationsListInternal(int flags, int userId, int callingUid) {
        if (this.getInstantAppPackageName(callingUid) != null) {
            return Collections.emptyList();
        }
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        boolean listUninstalled = ((flags = this.updateFlagsForApplication(flags, userId, null)) & 0x402000) != 0;
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "get installed application info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<ApplicationInfo> list;
            if (listUninstalled) {
                list = new ArrayList(this.mSettings.mPackages.size());
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    ApplicationInfo ai;
                    int effectiveFlags = flags;
                    if (ps.isSystem()) {
                        effectiveFlags |= 0x400000;
                    }
                    if (ps.pkg != null) {
                        if (this.filterSharedLibPackageLPr(ps, callingUid, userId, flags) || this.filterAppAccessLPr(ps, callingUid, userId)) continue;
                        ai = PackageParser.generateApplicationInfo(ps.pkg, effectiveFlags, ps.readUserState(userId), userId);
                        if (ai != null) {
                            ai.packageName = this.resolveExternalPackageNameLPr(ps.pkg);
                        }
                    } else {
                        ai = this.generateApplicationInfoFromSettingsLPw(ps.name, callingUid, effectiveFlags, userId);
                    }
                    if (ai == null) continue;
                    list.add(ai);
                }
            } else {
                list = new ArrayList<ApplicationInfo>(this.mPackages.size());
                for (PackageParser.Package p : this.mPackages.values()) {
                    ApplicationInfo ai;
                    PackageSetting ps;
                    if (p.mExtras == null || this.filterSharedLibPackageLPr(ps = (PackageSetting)p.mExtras, Binder.getCallingUid(), userId, flags) || this.filterAppAccessLPr(ps, callingUid, userId) || (ai = PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                    ai.packageName = this.resolveExternalPackageNameLPr(p);
                    list.add(ai);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<InstantAppInfo> getInstantApps(int userId) {
        if (!this.canViewInstantApps(Binder.getCallingUid(), userId)) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_INSTANT_APPS", "getEphemeralApplications");
        }
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getEphemeralApplications");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            List<InstantAppInfo> instantApps = this.mInstantAppRegistry.getInstantAppsLPr(userId);
            if (instantApps != null) {
                return new ParceledListSlice<InstantAppInfo>(instantApps);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInstantApp(String packageName, int userId) {
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "isInstantApp");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean returnAllowed;
            int callingUid = Binder.getCallingUid();
            if (Process.isIsolated(callingUid)) {
                callingUid = this.mIsolatedOwners.get(callingUid);
            }
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            PackageParser.Package pkg = this.mPackages.get(packageName);
            boolean bl = returnAllowed = ps != null && (this.isCallerSameApp(packageName, callingUid) || this.canViewInstantApps(callingUid, userId) || this.mInstantAppRegistry.isInstantAccessGranted(userId, UserHandle.getAppId(callingUid), ps.appId));
            if (returnAllowed) {
                return ps.getInstantApp(userId);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getInstantAppCookie(String packageName, int userId) {
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getInstantAppCookie");
        if (!this.isCallerSameApp(packageName, Binder.getCallingUid())) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mInstantAppRegistry.getInstantAppCookieLPw(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setInstantAppCookie(String packageName, byte[] cookie, int userId) {
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, true, "setInstantAppCookie");
        if (!this.isCallerSameApp(packageName, Binder.getCallingUid())) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mInstantAppRegistry.setInstantAppCookieLPw(packageName, cookie, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getInstantAppIcon(String packageName, int userId) {
        if (!this.canViewInstantApps(Binder.getCallingUid(), userId)) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_INSTANT_APPS", "getInstantAppIcon");
        }
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getInstantAppIcon");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mInstantAppRegistry.getInstantAppIconLPw(packageName, userId);
        }
    }

    private boolean isCallerSameApp(String packageName, int uid) {
        PackageParser.Package pkg = this.mPackages.get(packageName);
        return pkg != null && UserHandle.getAppId(uid) == pkg.applicationInfo.uid;
    }

    @Override
    public ParceledListSlice<ApplicationInfo> getPersistentApplications(int flags) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return ParceledListSlice.emptyList();
        }
        return new ParceledListSlice<ApplicationInfo>(this.getPersistentApplicationsInternal(flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApplicationInfo> getPersistentApplicationsInternal(int flags) {
        ArrayList<ApplicationInfo> finalList = new ArrayList<ApplicationInfo>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Iterator<PackageParser.Package> i = this.mPackages.values().iterator();
            int userId = UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ApplicationInfo ai;
                PackageSetting ps;
                boolean matchesAware;
                PackageParser.Package p = i.next();
                if (p.applicationInfo == null) continue;
                boolean matchesUnaware = (flags & 0x40000) != 0 && !p.applicationInfo.isDirectBootAware();
                boolean bl = matchesAware = (flags & 0x80000) != 0 && p.applicationInfo.isDirectBootAware();
                if ((p.applicationInfo.flags & 8) == 0 || this.mSafeMode && !PackageManagerService.isSystemApp(p) || !matchesUnaware && !matchesAware || (ps = this.mSettings.mPackages.get(p.packageName)) == null || (ai = PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                finalList.add(ai);
            }
        }
        return finalList;
    }

    @Override
    public ProviderInfo resolveContentProvider(String name, int flags, int userId) {
        return this.resolveContentProviderInternal(name, flags, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo resolveContentProviderInternal(String name, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        flags = this.updateFlagsForComponent(flags, userId, name);
        int callingUid = Binder.getCallingUid();
        ProviderInfo providerInfo = this.mComponentResolver.queryProvider(name, flags, userId);
        if (providerInfo == null) {
            return null;
        }
        if (!this.mSettings.isEnabledAndMatchLPr(providerInfo, flags, userId)) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(providerInfo.packageName);
            ComponentName component = new ComponentName(providerInfo.packageName, providerInfo.name);
            if (this.filterAppAccessLPr(ps, callingUid, component, 4, userId)) {
                return null;
            }
            return providerInfo;
        }
    }

    @Override
    @Deprecated
    public void querySyncProviders(List<String> outNames, List<ProviderInfo> outInfo) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        this.mComponentResolver.querySyncProviders(outNames, outInfo, this.mSafeMode, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ProviderInfo> queryContentProviders(String processName, int uid, int flags, String metaDataKey) {
        int userId;
        int callingUid = Binder.getCallingUid();
        int n = userId = processName != null ? UserHandle.getUserId(uid) : UserHandle.getCallingUserId();
        if (!sUserManager.exists(userId)) {
            return ParceledListSlice.emptyList();
        }
        flags = this.updateFlagsForComponent(flags, userId, processName);
        ArrayList<ProviderInfo> finalList = null;
        List<ProviderInfo> matchList = this.mComponentResolver.queryProviders(processName, metaDataKey, uid, flags, userId);
        int listSize = matchList == null ? 0 : matchList.size();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (int i = 0; i < listSize; ++i) {
                ComponentName component;
                PackageSetting ps;
                ProviderInfo providerInfo = matchList.get(i);
                if (!this.mSettings.isEnabledAndMatchLPr(providerInfo, flags, userId) || this.filterAppAccessLPr(ps = this.mSettings.mPackages.get(providerInfo.packageName), callingUid, component = new ComponentName(providerInfo.packageName, providerInfo.name), 4, userId)) continue;
                if (finalList == null) {
                    finalList = new ArrayList<ProviderInfo>(listSize - i);
                }
                finalList.add(providerInfo);
            }
        }
        if (finalList != null) {
            finalList.sort(sProviderInitOrderSorter);
            return new ParceledListSlice<ProviderInfo>(finalList);
        }
        return ParceledListSlice.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstrumentationInfo getInstrumentationInfo(ComponentName component, int flags) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
            if (ps == null) {
                return null;
            }
            if (this.filterAppAccessLPr(ps, callingUid, component, 0, callingUserId)) {
                return null;
            }
            PackageParser.Instrumentation i = this.mInstrumentation.get(component);
            return PackageParser.generateInstrumentationInfo(i, flags);
        }
    }

    @Override
    public ParceledListSlice<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        PackageSetting ps = this.mSettings.mPackages.get(targetPackage);
        if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
            return ParceledListSlice.emptyList();
        }
        return new ParceledListSlice<InstrumentationInfo>(this.queryInstrumentationInternal(targetPackage, flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InstrumentationInfo> queryInstrumentationInternal(String targetPackage, int flags) {
        ArrayList<InstrumentationInfo> finalList = new ArrayList<InstrumentationInfo>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (PackageParser.Instrumentation p : this.mInstrumentation.values()) {
                InstrumentationInfo ii;
                if (targetPackage != null && !targetPackage.equals(p.info.targetPackage) || (ii = PackageParser.generateInstrumentationInfo(p, flags)) == null) continue;
                finalList.add(ii);
            }
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDirTracedLI(File scanDir, int parseFlags, int scanFlags, long currentTime) {
        Trace.traceBegin(262144L, "scanDir [" + scanDir.getAbsolutePath() + "]");
        try {
            this.scanDirLI(scanDir, parseFlags, scanFlags, currentTime);
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    private void scanDirLI(File scanDir, int parseFlags, int scanFlags, long currentTime) {
        File[] files = scanDir.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            Log.d(TAG, "No files in app dir " + scanDir);
            return;
        }
        try (ParallelPackageParser parallelPackageParser = new ParallelPackageParser(this.mSeparateProcesses, this.mOnlyCore, this.mMetrics, this.mCacheDir, this.mParallelPackageParserCallback);){
            int fileCount = 0;
            for (File file : files) {
                boolean isPackage;
                boolean bl = isPackage = (PackageParser.isApkFile(file) || file.isDirectory()) && !PackageInstallerService.isStageName(file.getName());
                if (!isPackage) continue;
                parallelPackageParser.submit(file, parseFlags);
                ++fileCount;
            }
            while (fileCount > 0) {
                ParallelPackageParser.ParseResult parseResult = parallelPackageParser.take();
                Throwable throwable = parseResult.throwable;
                int errorCode = 1;
                if (throwable == null) {
                    if (parseResult.pkg.applicationInfo.isStaticSharedLibrary()) {
                        PackageManagerService.renameStaticSharedLibraryPackage(parseResult.pkg);
                    }
                    try {
                        this.scanPackageChildLI(parseResult.pkg, parseFlags, scanFlags, currentTime, null);
                    }
                    catch (PackageManagerException e) {
                        errorCode = e.error;
                        Slog.w(TAG, "Failed to scan " + parseResult.scanFile + ": " + e.getMessage());
                    }
                } else if (throwable instanceof PackageParser.PackageParserException) {
                    PackageParser.PackageParserException e = (PackageParser.PackageParserException)throwable;
                    errorCode = e.error;
                    Slog.w(TAG, "Failed to parse " + parseResult.scanFile + ": " + e.getMessage());
                } else {
                    throw new IllegalStateException("Unexpected exception occurred while parsing " + parseResult.scanFile, throwable);
                }
                if ((scanFlags & 0x20000) == 0 && errorCode != 1) {
                    PackageManagerServiceUtils.logCriticalInfo(5, "Deleting invalid package at " + parseResult.scanFile);
                    this.removeCodePathLI(parseResult.scanFile);
                }
                --fileCount;
            }
        }
    }

    public static void reportSettingsProblem(int priority, String msg) {
        PackageManagerServiceUtils.logCriticalInfo(priority, msg);
    }

    private void collectCertificatesLI(PackageSetting ps, PackageParser.Package pkg, boolean forceCollect, boolean skipVerify) throws PackageManagerException {
        long lastModifiedTime = this.mIsPreNMR1Upgrade ? new File(pkg.codePath).lastModified() : PackageManagerServiceUtils.getLastModifiedTime(pkg);
        Settings.VersionInfo settingsVersionForPackage = this.getSettingsVersionForPackage(pkg);
        if (ps != null && !forceCollect && ps.codePathString.equals(pkg.codePath) && ps.timeStamp == lastModifiedTime && !PackageManagerService.isCompatSignatureUpdateNeeded(settingsVersionForPackage) && !PackageManagerService.isRecoverSignatureUpdateNeeded(settingsVersionForPackage)) {
            if (ps.signatures.mSigningDetails.signatures != null && ps.signatures.mSigningDetails.signatures.length != 0 && ps.signatures.mSigningDetails.signatureSchemeVersion != 0) {
                pkg.mSigningDetails = new PackageParser.SigningDetails(ps.signatures.mSigningDetails);
                return;
            }
            Slog.w(TAG, "PackageSetting for " + ps.name + " is missing signatures.  Collecting certs again to recover them.");
        } else {
            Slog.i(TAG, pkg.codePath + " changed; collecting certs" + (forceCollect ? " (forced)" : ""));
        }
        try {
            Trace.traceBegin(262144L, "collectCertificates");
            PackageParser.collectCertificates(pkg, skipVerify);
        }
        catch (PackageParser.PackageParserException e) {
            throw PackageManagerException.from(e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    private void maybeClearProfilesForUpgradesLI(PackageSetting originalPkgSetting, PackageParser.Package currentPkg) {
        if (originalPkgSetting == null || !this.isDeviceUpgrading()) {
            return;
        }
        if (originalPkgSetting.versionCode == (long)currentPkg.mVersionCode) {
            return;
        }
        this.clearAppProfilesLIF(currentPkg, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mInstallLock", "mPackages"})
    private PackageParser.Package scanPackageTracedLI(File scanFile, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        Trace.traceBegin(262144L, "scanPackage [" + scanFile.toString() + "]");
        try {
            PackageParser.Package package_ = this.scanPackageLI(scanFile, parseFlags, scanFlags, currentTime, user);
            return package_;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    @GuardedBy(value={"mInstallLock", "mPackages"})
    private PackageParser.Package scanPackageLI(File scanFile, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        PackageParser.Package pkg;
        PackageParser pp = new PackageParser();
        pp.setSeparateProcesses(this.mSeparateProcesses);
        pp.setOnlyCoreApps(this.mOnlyCore);
        pp.setDisplayMetrics(this.mMetrics);
        pp.setCallback(this.mPackageParserCallback);
        Trace.traceBegin(262144L, "parsePackage");
        try {
            pkg = pp.parsePackage(scanFile, parseFlags);
        }
        catch (PackageParser.PackageParserException e) {
            throw PackageManagerException.from(e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
        if (pkg.applicationInfo.isStaticSharedLibrary()) {
            PackageManagerService.renameStaticSharedLibraryPackage(pkg);
        }
        return this.scanPackageChildLI(pkg, parseFlags, scanFlags, currentTime, user);
    }

    @GuardedBy(value={"mInstallLock", "mPackages"})
    private PackageParser.Package scanPackageChildLI(PackageParser.Package pkg, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        if ((scanFlags & 0x400) == 0) {
            if (pkg.childPackages != null && pkg.childPackages.size() > 0) {
                scanFlags |= 0x400;
            }
        } else {
            scanFlags &= 0xFFFFFBFF;
        }
        PackageParser.Package scannedPkg = this.addForInitLI(pkg, parseFlags, scanFlags, currentTime, user);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPackage = pkg.childPackages.get(i);
            this.addForInitLI(childPackage, parseFlags, scanFlags, currentTime, user);
        }
        if ((scanFlags & 0x400) != 0) {
            return this.scanPackageChildLI(pkg, parseFlags, scanFlags, currentTime, user);
        }
        return scannedPkg;
    }

    private boolean canSkipForcedPackageVerification(PackageParser.Package pkg) {
        if (!this.canSkipForcedApkVerification(pkg.baseCodePath)) {
            return false;
        }
        if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
            for (int i = 0; i < pkg.splitCodePaths.length; ++i) {
                if (this.canSkipForcedApkVerification(pkg.splitCodePaths[i])) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canSkipForcedApkVerification(String apkPath) {
        if (!PackageManagerServiceUtils.isLegacyApkVerityEnabled()) {
            return VerityUtils.hasFsverity(apkPath);
        }
        try {
            byte[] rootHashObserved = VerityUtils.generateApkVerityRootHash(apkPath);
            if (rootHashObserved == null) {
                return false;
            }
            Object object = this.mInstallLock;
            synchronized (object) {
                this.mInstaller.assertFsverityRootHashMatches(apkPath, rootHashObserved);
                return true;
            }
        }
        catch (Installer.InstallerException | IOException | DigestException | NoSuchAlgorithmException e) {
            Slog.w(TAG, "Error in fsverity check. Fallback to full apk verification.", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mInstallLock", "mPackages"})
    private PackageParser.Package addForInitLI(PackageParser.Package pkg, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        boolean isSystemPkgBetter;
        boolean isSystemPkgUpdated;
        PackageSetting disabledPkgSetting;
        Object disabledPkgName;
        boolean pkgAlreadyExists;
        PackageSetting pkgSetting;
        Object installedPkgSetting;
        boolean scanSystemPartition = (parseFlags & 0x10) != 0;
        pkg.setApplicationVolumeUuid(pkg.volumeUuid);
        pkg.setApplicationInfoCodePath(pkg.codePath);
        pkg.setApplicationInfoBaseCodePath(pkg.baseCodePath);
        pkg.setApplicationInfoSplitCodePaths(pkg.splitCodePaths);
        pkg.setApplicationInfoResourcePath(pkg.codePath);
        pkg.setApplicationInfoBaseResourcePath(pkg.baseCodePath);
        pkg.setApplicationInfoSplitResourcePaths(pkg.splitCodePaths);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SharedUserSetting sharedUserSetting;
            String renamedPkgName = this.mSettings.getRenamedPackageLPr(pkg.mRealPackage);
            String realPkgName = PackageManagerService.getRealPackageName(pkg, renamedPkgName);
            if (realPkgName != null) {
                PackageManagerService.ensurePackageRenamed(pkg, renamedPkgName);
            }
            PackageSetting originalPkgSetting = this.getOriginalPackageLocked(pkg, renamedPkgName);
            installedPkgSetting = this.mSettings.getPackageLPr(pkg.packageName);
            pkgSetting = originalPkgSetting == null ? installedPkgSetting : originalPkgSetting;
            pkgAlreadyExists = pkgSetting != null;
            disabledPkgName = pkgAlreadyExists ? pkgSetting.name : pkg.packageName;
            disabledPkgSetting = this.mSettings.getDisabledSystemPkgLPr((String)disabledPkgName);
            isSystemPkgUpdated = disabledPkgSetting != null;
            SharedUserSetting sharedUserSetting2 = sharedUserSetting = pkg.mSharedUserId != null ? this.mSettings.getSharedUserLPw(pkg.mSharedUserId, 0, 0, true) : null;
            if (scanSystemPartition && isSystemPkgUpdated) {
                int scannedChildCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
                int disabledChildCount = disabledPkgSetting.childPackageNames != null ? disabledPkgSetting.childPackageNames.size() : 0;
                for (int i = 0; i < disabledChildCount; ++i) {
                    String disabledChildPackageName = (String)disabledPkgSetting.childPackageNames.get(i);
                    boolean disabledPackageAvailable = false;
                    for (int j = 0; j < scannedChildCount; ++j) {
                        PackageParser.Package childPkg = pkg.childPackages.get(j);
                        if (!childPkg.packageName.equals(disabledChildPackageName)) continue;
                        disabledPackageAvailable = true;
                        break;
                    }
                    if (disabledPackageAvailable) continue;
                    this.mSettings.removeDisabledSystemPackageLPw(disabledChildPackageName);
                }
                ScanRequest request = new ScanRequest(pkg, sharedUserSetting, null, disabledPkgSetting, null, null, null, parseFlags, scanFlags, pkg == this.mPlatformPackage, user);
                PackageManagerService.applyPolicy(pkg, parseFlags, scanFlags, this.mPlatformPackage);
                ScanResult scanResult = PackageManagerService.scanPackageOnlyLI(request, this.mFactoryTest, -1L);
                if (scanResult.existingSettingCopied && scanResult.request.pkgSetting != null) {
                    scanResult.request.pkgSetting.updateFrom(scanResult.pkgSetting);
                }
            }
        }
        boolean newPkgChangedPaths = pkgAlreadyExists && !pkgSetting.codePathString.equals(pkg.codePath);
        boolean newPkgVersionGreater = pkgAlreadyExists && pkg.getLongVersionCode() > pkgSetting.versionCode;
        boolean bl = isSystemPkgBetter = scanSystemPartition && isSystemPkgUpdated && newPkgChangedPaths && newPkgVersionGreater;
        if (isSystemPkgBetter) {
            installedPkgSetting = this.mPackages;
            synchronized (installedPkgSetting) {
                this.mPackages.remove(pkgSetting.name);
            }
            PackageManagerServiceUtils.logCriticalInfo(5, "System package updated; name: " + pkgSetting.name + "; " + pkgSetting.versionCode + " --> " + pkg.getLongVersionCode() + "; " + pkgSetting.codePathString + " --> " + pkg.codePath);
            InstallArgs args = this.createInstallArgsForExisting(pkgSetting.codePathString, pkgSetting.resourcePathString, InstructionSets.getAppDexInstructionSets(pkgSetting));
            args.cleanUpResourcesLI();
            disabledPkgName = this.mPackages;
            synchronized (disabledPkgName) {
                this.mSettings.enableSystemPackageLPw(pkgSetting.name);
            }
        }
        if (scanSystemPartition && isSystemPkgUpdated && !isSystemPkgBetter) {
            throw new PackageManagerException(5, "Package " + pkg.packageName + " at " + pkg.codePath + " ignored: updated version " + pkgSetting.versionCode + " better than this " + pkg.getLongVersionCode());
        }
        boolean forceCollect = this.mIsUpgrade && scanSystemPartition || PackageManagerServiceUtils.isApkVerificationForced(disabledPkgSetting);
        boolean skipVerify = scanSystemPartition || forceCollect && this.canSkipForcedPackageVerification(pkg);
        this.collectCertificatesLI(pkgSetting, pkg, forceCollect, skipVerify);
        this.maybeClearProfilesForUpgradesLI(pkgSetting, pkg);
        boolean shouldHideSystemApp = false;
        if (scanSystemPartition && !isSystemPkgUpdated && pkgAlreadyExists && !pkgSetting.isSystem()) {
            if (!pkg.mSigningDetails.checkCapability(pkgSetting.signatures.mSigningDetails, 1) && !pkgSetting.signatures.mSigningDetails.checkCapability(pkg.mSigningDetails, 8)) {
                PackageManagerServiceUtils.logCriticalInfo(5, "System package signature mismatch; name: " + pkgSetting.name);
                try (PackageFreezer freezer = this.freezePackage(pkg.packageName, "scanPackageInternalLI");){
                    this.deletePackageLIF(pkg.packageName, null, true, null, 0, null, false, null);
                }
                pkgSetting = null;
            } else if (newPkgVersionGreater) {
                PackageManagerServiceUtils.logCriticalInfo(5, "System package enabled; name: " + pkgSetting.name + "; " + pkgSetting.versionCode + " --> " + pkg.getLongVersionCode() + "; " + pkgSetting.codePathString + " --> " + pkg.codePath);
                InstallArgs args = this.createInstallArgsForExisting(pkgSetting.codePathString, pkgSetting.resourcePathString, InstructionSets.getAppDexInstructionSets(pkgSetting));
                Object object = this.mInstallLock;
                synchronized (object) {
                    args.cleanUpResourcesLI();
                }
            } else {
                shouldHideSystemApp = true;
                PackageManagerServiceUtils.logCriticalInfo(4, "System package disabled; name: " + pkgSetting.name + "; old: " + pkgSetting.codePathString + " @ " + pkgSetting.versionCode + "; new: " + pkg.codePath + " @ " + pkg.codePath);
            }
        }
        ScanResult scanResult = this.scanPackageNewLI(pkg, parseFlags, scanFlags | 2, currentTime, user);
        if (scanResult.success) {
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                boolean appIdCreated = false;
                try {
                    String pkgName = scanResult.pkgSetting.name;
                    Map<String, ReconciledPackage> reconcileResult = PackageManagerService.reconcilePackagesLocked(new ReconcileRequest(Collections.singletonMap(pkgName, scanResult), this.mSharedLibraries, this.mPackages, Collections.singletonMap(pkgName, this.getSettingsVersionForPackage(pkg)), Collections.singletonMap(pkgName, this.getSharedLibLatestVersionSetting(scanResult))), this.mSettings.mKeySetManagerService);
                    appIdCreated = this.optimisticallyRegisterAppId(scanResult);
                    this.commitReconciledScanResultLocked(reconcileResult.get(pkgName));
                }
                catch (PackageManagerException e) {
                    if (appIdCreated) {
                        this.cleanUpAppIdCreation(scanResult);
                    }
                    throw e;
                }
            }
        }
        if (shouldHideSystemApp) {
            ArrayMap<String, PackageParser.Package> arrayMap3 = this.mPackages;
            synchronized (arrayMap3) {
                this.mSettings.disableSystemPackageLPw(pkg.packageName, true);
            }
        }
        return scanResult.pkgSetting.pkg;
    }

    private static void renameStaticSharedLibraryPackage(PackageParser.Package pkg) {
        pkg.setPackageName(pkg.packageName + STATIC_SHARED_LIB_DELIMITER + pkg.staticSharedLibVersion);
    }

    static String fixProcessName(String defProcessName, String processName) {
        if (processName == null) {
            return defProcessName;
        }
        return processName;
    }

    private static void enforceSystemOrRoot(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0) {
            throw new SecurityException(message);
        }
    }

    private static void enforceSystemOrRootOrShell(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0 && uid != 2000) {
            throw new SecurityException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performFstrimIfNeeded() {
        block10: {
            PackageManagerService.enforceSystemOrRoot("Only the system can request fstrim");
            try {
                IStorageManager sm = PackageHelper.getStorageManager();
                if (sm != null) {
                    boolean dexOptDialogShown;
                    long timeSinceLast;
                    boolean doTrim = false;
                    long interval = Settings.Global.getLong(this.mContext.getContentResolver(), "fstrim_mandatory_interval", 259200000L);
                    if (interval > 0L && (timeSinceLast = System.currentTimeMillis() - sm.lastMaintenance()) > interval) {
                        doTrim = true;
                        Slog.w(TAG, "No disk maintenance in " + timeSinceLast + "; running immediately");
                    }
                    if (!doTrim) break block10;
                    ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                    synchronized (arrayMap) {
                        dexOptDialogShown = this.mDexOptDialogShown;
                    }
                    if (!this.isFirstBoot() && dexOptDialogShown) {
                        try {
                            ActivityManager.getService().showBootMessage(this.mContext.getResources().getString(17039493), true);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    sm.runMaintenance();
                    break block10;
                }
                Slog.e(TAG, "storageManager service unavailable!");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePackagesIfNeeded() {
        List<PackageParser.Package> pkgs;
        PackageManagerService.enforceSystemOrRoot("Only the system can request package update");
        boolean causeUpgrade = this.isDeviceUpgrading();
        boolean causeFirstBoot = this.isFirstBoot() || this.mIsPreNUpgrade;
        boolean causePrunedCache = VMRuntime.didPruneDalvikCache();
        if (!(causeUpgrade || causeFirstBoot || causePrunedCache)) {
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkgs = PackageManagerServiceUtils.getPackagesForDexopt(this.mPackages.values(), this);
        }
        long startTime = System.nanoTime();
        int[] stats = this.performDexOptUpgrade(pkgs, this.mIsPreNUpgrade, causeFirstBoot ? 0 : 1, false);
        int elapsedTimeSeconds = (int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime);
        MetricsLogger.histogram(this.mContext, "opt_dialog_num_dexopted", stats[0]);
        MetricsLogger.histogram(this.mContext, "opt_dialog_num_skipped", stats[1]);
        MetricsLogger.histogram(this.mContext, "opt_dialog_num_failed", stats[2]);
        MetricsLogger.histogram(this.mContext, "opt_dialog_num_total", this.getOptimizablePackages().size());
        MetricsLogger.histogram(this.mContext, "opt_dialog_time_s", elapsedTimeSeconds);
    }

    private static String getPrebuildProfilePath(PackageParser.Package pkg) {
        return pkg.baseCodePath + ".prof";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] performDexOptUpgrade(List<PackageParser.Package> pkgs, boolean showDialog, int compilationReason, boolean bootComplete) {
        int numberOfPackagesVisited = 0;
        int numberOfPackagesOptimized = 0;
        int numberOfPackagesSkipped = 0;
        int numberOfPackagesFailed = 0;
        int numberOfPackagesToDexopt = pkgs.size();
        block14: for (PackageParser.Package pkg : pkgs) {
            int dexoptFlags;
            Object profileFile2;
            ++numberOfPackagesVisited;
            boolean useProfileForDexopt = false;
            if ((this.isFirstBoot() || this.isDeviceUpgrading()) && PackageManagerService.isSystemApp(pkg)) {
                profileFile2 = new File(PackageManagerService.getPrebuildProfilePath(pkg));
                if (((File)profileFile2).exists()) {
                    try {
                        if (!this.mInstaller.copySystemProfile(((File)profileFile2).getAbsolutePath(), pkg.applicationInfo.uid, pkg.packageName, ArtManager.getProfileName(null))) {
                            Log.e(TAG, "Installer failed to copy system profile!");
                        }
                    }
                    catch (Exception e) {
                        Log.e(TAG, "Failed to copy profile " + ((File)profileFile2).getAbsolutePath() + " ", e);
                    }
                } else {
                    String systemProfilePath;
                    PackageSetting disabledPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
                    if (disabledPs != null && disabledPs.pkg.isStub && ((File)(profileFile2 = new File(systemProfilePath = PackageManagerService.getPrebuildProfilePath(disabledPs.pkg).replace(STUB_SUFFIX, "")))).exists()) {
                        try {
                            if (!this.mInstaller.copySystemProfile(((File)profileFile2).getAbsolutePath(), pkg.applicationInfo.uid, pkg.packageName, ArtManager.getProfileName(null))) {
                                Log.e(TAG, "Failed to copy system profile for stub package!");
                            } else {
                                useProfileForDexopt = true;
                            }
                        }
                        catch (Exception e) {
                            Log.e(TAG, "Failed to copy profile " + ((File)profileFile2).getAbsolutePath() + " ", e);
                        }
                    }
                }
            }
            if (!PackageDexOptimizer.canOptimizePackage(pkg)) {
                ++numberOfPackagesSkipped;
                continue;
            }
            if (showDialog) {
                try {
                    ActivityManager.getService().showBootMessage(this.mContext.getResources().getString(17039491, numberOfPackagesVisited, numberOfPackagesToDexopt), true);
                }
                catch (RemoteException profileFile2) {
                    // empty catch block
                }
                profileFile2 = this.mPackages;
                synchronized (profileFile2) {
                    this.mDexOptDialogShown = true;
                }
            }
            int pkgCompilationReason = compilationReason;
            if (useProfileForDexopt) {
                pkgCompilationReason = 3;
            }
            if (SystemProperties.getBoolean(PRECOMPILE_LAYOUTS, false)) {
                this.mArtManagerService.compileLayouts(pkg);
            }
            int n = dexoptFlags = bootComplete ? 4 : 0;
            if (compilationReason == 0) {
                dexoptFlags |= 0x400;
            }
            int primaryDexOptStaus = this.performDexOptTraced(new DexoptOptions(pkg.packageName, pkgCompilationReason, dexoptFlags));
            switch (primaryDexOptStaus) {
                case 1: {
                    ++numberOfPackagesOptimized;
                    continue block14;
                }
                case 0: {
                    ++numberOfPackagesSkipped;
                    continue block14;
                }
                case -1: {
                    ++numberOfPackagesFailed;
                    continue block14;
                }
            }
            Log.e(TAG, "Unexpected dexopt return code " + primaryDexOptStaus);
        }
        return new int[]{numberOfPackagesOptimized, numberOfPackagesSkipped, numberOfPackagesFailed};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPackageUse(String packageName, int reason) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            if (this.getInstantAppPackageName(callingUid) != null) {
                if (!this.isCallerSameApp(packageName, callingUid)) {
                    return;
                }
            } else if (this.isInstantApp(packageName, callingUserId)) {
                return;
            }
            this.notifyPackageUseLocked(packageName, reason);
        }
    }

    @GuardedBy(value={"mPackages"})
    public PackageManagerInternal.CheckPermissionDelegate getCheckPermissionDelegateLocked() {
        return this.mCheckPermissionDelegate;
    }

    @GuardedBy(value={"mPackages"})
    public void setCheckPermissionDelegateLocked(PackageManagerInternal.CheckPermissionDelegate delegate) {
        this.mCheckPermissionDelegate = delegate;
    }

    @GuardedBy(value={"mPackages"})
    private void notifyPackageUseLocked(String packageName, int reason) {
        PackageParser.Package p = this.mPackages.get(packageName);
        if (p == null) {
            return;
        }
        p.mLastPackageUsageTimeInMills[reason] = System.currentTimeMillis();
    }

    @Override
    public void notifyDexLoad(String loadingPackageName, List<String> classLoaderNames, List<String> classPaths, String loaderIsa) {
        int userId = UserHandle.getCallingUserId();
        ApplicationInfo ai = this.getApplicationInfo(loadingPackageName, 0, userId);
        if (ai == null) {
            Slog.w(TAG, "Loading a package that does not exist for the calling user. package=" + loadingPackageName + ", user=" + userId);
            return;
        }
        this.mDexManager.notifyDexLoad(ai, classLoaderNames, classPaths, loaderIsa, userId);
    }

    @Override
    public void registerDexModule(String packageName, String dexModulePath, boolean isSharedModule, IDexModuleRegisterCallback callback) {
        DexManager.RegisterDexModuleResult result;
        int userId = UserHandle.getCallingUserId();
        ApplicationInfo ai = this.getApplicationInfo(packageName, 0, userId);
        if (ai == null) {
            Slog.w(TAG, "Registering a dex module for a package that does not exist for the calling user. package=" + packageName + ", user=" + userId);
            result = new DexManager.RegisterDexModuleResult(false, "Package not installed");
        } else {
            result = this.mDexManager.registerDexModule(ai, dexModulePath, isSharedModule, userId);
        }
        if (callback != null) {
            this.mHandler.post(() -> {
                try {
                    callback.onDexModuleRegistered(dexModulePath, result.success, result.message);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Failed to callback after module registration " + dexModulePath, e);
                }
            });
        }
    }

    @Override
    public boolean performDexOptMode(String packageName, boolean checkProfiles, String targetCompilerFilter, boolean force, boolean bootComplete, String splitName) {
        int flags = (checkProfiles ? 1 : 0) | (force ? 2 : 0) | (bootComplete ? 4 : 0);
        return this.performDexOpt(new DexoptOptions(packageName, -1, targetCompilerFilter, splitName, flags));
    }

    @Override
    public boolean performDexOptSecondary(String packageName, String compilerFilter, boolean force) {
        int flags = 0xD | (force ? 2 : 0);
        return this.performDexOpt(new DexoptOptions(packageName, compilerFilter, flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compileLayouts(String packageName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                return false;
            }
            return this.mViewCompiler.compileLayouts(pkg);
        }
    }

    boolean performDexOpt(DexoptOptions options) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return false;
        }
        if (this.isInstantApp(options.getPackageName(), UserHandle.getCallingUserId())) {
            return false;
        }
        if (options.isDexoptOnlySecondaryDex()) {
            return this.mDexManager.dexoptSecondaryDex(options);
        }
        int dexoptStatus = this.performDexOptWithStatus(options);
        return dexoptStatus != -1;
    }

    int performDexOptWithStatus(DexoptOptions options) {
        return this.performDexOptTraced(options);
    }

    private int performDexOptTraced(DexoptOptions options) {
        Trace.traceBegin(262144L, "dexopt");
        try {
            int n = this.performDexOptInternal(options);
            return n;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performDexOptInternal(DexoptOptions options) {
        PackageParser.Package p;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            p = this.mPackages.get(options.getPackageName());
            if (p == null) {
                return -1;
            }
            this.mPackageUsage.maybeWriteAsync(this.mPackages);
            this.mCompilerStats.maybeWriteAsync();
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            Object object = this.mInstallLock;
            synchronized (object) {
                int n = this.performDexOptInternalWithDependenciesLI(p, options);
                return n;
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArraySet<String> getOptimizablePackages() {
        ArraySet<String> pkgs = new ArraySet<String>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (PackageParser.Package p : this.mPackages.values()) {
                if (!PackageDexOptimizer.canOptimizePackage(p)) continue;
                pkgs.add(p.packageName);
            }
        }
        return pkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performDexOptInternalWithDependenciesLI(PackageParser.Package p, DexoptOptions options) {
        PackageDexOptimizer pdo = options.isForce() ? new PackageDexOptimizer.ForcedUpdatePackageDexOptimizer(this.mPackageDexOptimizer) : this.mPackageDexOptimizer;
        List<SharedLibraryInfo> deps = PackageManagerService.findSharedLibraries(p);
        String[] instructionSets = InstructionSets.getAppDexInstructionSets(p.applicationInfo);
        if (!deps.isEmpty()) {
            DexoptOptions libraryOptions = new DexoptOptions(options.getPackageName(), options.getCompilationReason(), options.getCompilerFilter(), options.getSplitName(), options.getFlags() | 0x40);
            for (SharedLibraryInfo info : deps) {
                PackageParser.Package depPackage = null;
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    depPackage = this.mPackages.get(info.getPackageName());
                }
                if (depPackage == null) continue;
                pdo.performDexOpt(depPackage, instructionSets, this.getOrCreateCompilerPackageStats(depPackage), this.mDexManager.getPackageUseInfoOrDefault(depPackage.packageName), libraryOptions);
            }
        }
        return pdo.performDexOpt(p, instructionSets, this.getOrCreateCompilerPackageStats(p), this.mDexManager.getPackageUseInfoOrDefault(p.packageName), options);
    }

    @Override
    public void reconcileSecondaryDexFiles(String packageName) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        if (this.isInstantApp(packageName, UserHandle.getCallingUserId())) {
            return;
        }
        this.mDexManager.reconcileSecondaryDexFiles(packageName);
    }

    DexManager getDexManager() {
        return this.mDexManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runBackgroundDexoptJob(List<String> packageNames) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return false;
        }
        PackageManagerService.enforceSystemOrRootOrShell("runBackgroundDexoptJob");
        long identity = Binder.clearCallingIdentity();
        try {
            boolean bl = BackgroundDexOptService.runIdleOptimizationsNow(this, this.mContext, packageNames);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private static List<SharedLibraryInfo> findSharedLibraries(PackageParser.Package p) {
        if (p.usesLibraryInfos != null) {
            ArrayList<SharedLibraryInfo> retValue = new ArrayList<SharedLibraryInfo>();
            HashSet<String> collectedNames = new HashSet<String>();
            for (SharedLibraryInfo info : p.usesLibraryInfos) {
                PackageManagerService.findSharedLibrariesRecursive(info, retValue, collectedNames);
            }
            return retValue;
        }
        return Collections.emptyList();
    }

    private static void findSharedLibrariesRecursive(SharedLibraryInfo info, ArrayList<SharedLibraryInfo> collected, Set<String> collectedNames) {
        if (!collectedNames.contains(info.getName())) {
            collectedNames.add(info.getName());
            collected.add(info);
            if (info.getDependencies() != null) {
                for (SharedLibraryInfo dep : info.getDependencies()) {
                    PackageManagerService.findSharedLibrariesRecursive(dep, collected, collectedNames);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<PackageParser.Package> findSharedNonSystemLibraries(PackageParser.Package pkg) {
        List<SharedLibraryInfo> deps = PackageManagerService.findSharedLibraries(pkg);
        if (!deps.isEmpty()) {
            ArrayList<PackageParser.Package> retValue = new ArrayList<PackageParser.Package>();
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                for (SharedLibraryInfo info : deps) {
                    PackageParser.Package depPackage = this.mPackages.get(info.getPackageName());
                    if (depPackage == null) continue;
                    retValue.add(depPackage);
                }
            }
            return retValue;
        }
        return Collections.emptyList();
    }

    private SharedLibraryInfo getSharedLibraryInfoLPr(String name, long version) {
        return PackageManagerService.getSharedLibraryInfo(name, version, this.mSharedLibraries, null);
    }

    private static SharedLibraryInfo getSharedLibraryInfo(String name, long version, Map<String, LongSparseArray<SharedLibraryInfo>> existingLibraries, Map<String, LongSparseArray<SharedLibraryInfo>> newLibraries) {
        LongSparseArray<SharedLibraryInfo> versionedLib;
        if (newLibraries != null) {
            versionedLib = newLibraries.get(name);
            SharedLibraryInfo info = null;
            if (versionedLib != null) {
                info = versionedLib.get(version);
            }
            if (info != null) {
                return info;
            }
        }
        if ((versionedLib = existingLibraries.get(name)) == null) {
            return null;
        }
        return versionedLib.get(version);
    }

    private SharedLibraryInfo getLatestSharedLibraVersionLPr(PackageParser.Package pkg) {
        LongSparseArray<SharedLibraryInfo> versionedLib = this.mSharedLibraries.get(pkg.staticSharedLibName);
        if (versionedLib == null) {
            return null;
        }
        long previousLibVersion = -1L;
        int versionCount = versionedLib.size();
        for (int i = 0; i < versionCount; ++i) {
            long libVersion = versionedLib.keyAt(i);
            if (libVersion >= pkg.staticSharedLibVersion) continue;
            previousLibVersion = Math.max(previousLibVersion, libVersion);
        }
        if (previousLibVersion >= 0L) {
            return versionedLib.get(previousLibVersion);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSetting getSharedLibLatestVersionSetting(ScanResult scanResult) {
        PackageSetting sharedLibPackage = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SharedLibraryInfo latestSharedLibraVersionLPr = this.getLatestSharedLibraVersionLPr(scanResult.pkgSetting.pkg);
            if (latestSharedLibraVersionLPr != null) {
                sharedLibPackage = this.mSettings.getPackageLPr(latestSharedLibraVersionLPr.getPackageName());
            }
        }
        return sharedLibPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.mPackageUsage.writeNow(this.mPackages);
        this.mCompilerStats.writeNow();
        this.mDexManager.writePackageDexUsageNow();
        PackageWatchdog.getInstance(this.mContext).writeNow();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mHandler.hasMessages(14)) {
                this.mHandler.removeMessages(14);
                for (int userId : this.mDirtyUsers) {
                    this.mSettings.writePackageRestrictionsLPr(userId);
                }
                this.mDirtyUsers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpProfiles(String packageName) {
        PackageParser.Package pkg;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
        }
        int callingUid = Binder.getCallingUid();
        if (callingUid != 2000 && callingUid != 0 && callingUid != pkg.applicationInfo.uid) {
            throw new SecurityException("dumpProfiles");
        }
        Object object = this.mInstallLock;
        synchronized (object) {
            Trace.traceBegin(262144L, "dump profiles");
            this.mArtManagerService.dumpProfiles(pkg);
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceDexOpt(String packageName) {
        PackageParser.Package pkg;
        PackageManagerService.enforceSystemOrRoot("forceDexOpt");
        Object object = this.mPackages;
        synchronized (object) {
            pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
        }
        object = this.mInstallLock;
        synchronized (object) {
            Trace.traceBegin(262144L, "dexopt");
            int res = this.performDexOptInternalWithDependenciesLI(pkg, new DexoptOptions(packageName, PackageManagerServiceCompilerMapping.getDefaultCompilerFilter(), 6));
            Trace.traceEnd(262144L);
            if (res != 1) {
                throw new IllegalStateException("Failed to dexopt: " + res);
            }
        }
    }

    @GuardedBy(value={"mPackages"})
    private boolean verifyPackageUpdateLPr(PackageSetting oldPkg, PackageParser.Package newPkg) {
        if ((oldPkg.pkgFlags & 1) == 0) {
            Slog.w(TAG, "Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package not in system partition");
            return false;
        }
        if (this.mPackages.get(oldPkg.name) != null) {
            Slog.w(TAG, "Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package still exists");
            return false;
        }
        return true;
    }

    @GuardedBy(value={"mInstallLock"})
    void removeCodePathLI(File codePath) {
        if (codePath.isDirectory()) {
            try {
                this.mInstaller.rmPackageDir(codePath.getAbsolutePath());
            }
            catch (Installer.InstallerException e) {
                Slog.w(TAG, "Failed to remove code path", e);
            }
        } else {
            codePath.delete();
        }
    }

    private int[] resolveUserIds(int userId) {
        int[] nArray;
        if (userId == -1) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userId;
        }
        return nArray;
    }

    private void clearAppDataLIF(PackageParser.Package pkg, int userId, int flags) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.clearAppDataLeafLIF(pkg, userId, flags);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.clearAppDataLeafLIF(pkg.childPackages.get(i), userId, flags);
        }
        this.clearAppProfilesLIF(pkg, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAppDataLeafLIF(PackageParser.Package pkg, int userId, int flags) {
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(pkg.packageName);
        }
        for (Object realUserId : (ArrayMap<String, PackageParser.Package>)this.resolveUserIds(userId)) {
            long ceDataInode = ps != null ? ps.getCeDataInode((int)realUserId) : 0L;
            try {
                this.mInstaller.clearAppData(pkg.volumeUuid, pkg.packageName, (int)realUserId, flags, ceDataInode);
            }
            catch (Installer.InstallerException e) {
                Slog.w(TAG, String.valueOf(e));
            }
        }
    }

    private void destroyAppDataLIF(PackageParser.Package pkg, int userId, int flags) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.destroyAppDataLeafLIF(pkg, userId, flags);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.destroyAppDataLeafLIF(pkg.childPackages.get(i), userId, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAppDataLeafLIF(PackageParser.Package pkg, int userId, int flags) {
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(pkg.packageName);
        }
        for (Object realUserId : (ArrayMap<String, PackageParser.Package>)this.resolveUserIds(userId)) {
            long ceDataInode = ps != null ? ps.getCeDataInode((int)realUserId) : 0L;
            try {
                this.mInstaller.destroyAppData(pkg.volumeUuid, pkg.packageName, (int)realUserId, flags, ceDataInode);
            }
            catch (Installer.InstallerException e) {
                Slog.w(TAG, String.valueOf(e));
            }
            this.mDexManager.notifyPackageDataDestroyed(pkg.packageName, userId);
        }
    }

    private void destroyAppProfilesLIF(PackageParser.Package pkg) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.destroyAppProfilesLeafLIF(pkg);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.destroyAppProfilesLeafLIF(pkg.childPackages.get(i));
        }
    }

    private void destroyAppProfilesLeafLIF(PackageParser.Package pkg) {
        try {
            this.mInstaller.destroyAppProfiles(pkg.packageName);
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, String.valueOf(e));
        }
    }

    private void clearAppProfilesLIF(PackageParser.Package pkg, int userId) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.mArtManagerService.clearAppProfiles(pkg);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.mArtManagerService.clearAppProfiles(pkg.childPackages.get(i));
        }
    }

    private void setInstallAndUpdateTime(PackageParser.Package pkg, long firstInstallTime, long lastUpdateTime) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps != null) {
            ps.firstInstallTime = firstInstallTime;
            ps.lastUpdateTime = lastUpdateTime;
        }
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            ps = (PackageSetting)childPkg.mExtras;
            if (ps == null) continue;
            ps.firstInstallTime = firstInstallTime;
            ps.lastUpdateTime = lastUpdateTime;
        }
    }

    @GuardedBy(value={"mPackages"})
    private void applyDefiningSharedLibraryUpdateLocked(PackageParser.Package pkg, SharedLibraryInfo libInfo, BiConsumer<SharedLibraryInfo, SharedLibraryInfo> action) {
        if (pkg.isLibrary()) {
            if (pkg.staticSharedLibName != null) {
                SharedLibraryInfo definedLibrary = this.getSharedLibraryInfoLPr(pkg.staticSharedLibName, pkg.staticSharedLibVersion);
                if (definedLibrary != null) {
                    action.accept(definedLibrary, libInfo);
                }
            } else {
                for (String libraryName : pkg.libraryNames) {
                    SharedLibraryInfo definedLibrary = this.getSharedLibraryInfoLPr(libraryName, -1L);
                    if (definedLibrary == null) continue;
                    action.accept(definedLibrary, libInfo);
                }
            }
        }
    }

    @GuardedBy(value={"mPackages"})
    private void addSharedLibraryLPr(PackageParser.Package pkg, Set<String> usesLibraryFiles, SharedLibraryInfo libInfo, PackageParser.Package changingLib) {
        if (libInfo.getPath() != null) {
            usesLibraryFiles.add(libInfo.getPath());
            return;
        }
        PackageParser.Package p = this.mPackages.get(libInfo.getPackageName());
        if (changingLib != null && changingLib.packageName.equals(libInfo.getPackageName()) && (p == null || p.packageName.equals(changingLib.packageName))) {
            p = changingLib;
        }
        if (p != null) {
            usesLibraryFiles.addAll(p.getAllCodePaths());
            this.applyDefiningSharedLibraryUpdateLocked(pkg, libInfo, (definingLibrary, dependency) -> definingLibrary.addDependency((SharedLibraryInfo)dependency));
            if (p.usesLibraryFiles != null) {
                Collections.addAll(usesLibraryFiles, p.usesLibraryFiles);
            }
        }
    }

    @GuardedBy(value={"mPackages"})
    private void updateSharedLibrariesLocked(PackageParser.Package pkg, PackageParser.Package changingLib, Map<String, PackageParser.Package> availablePackages) throws PackageManagerException {
        ArrayList<SharedLibraryInfo> sharedLibraryInfos = PackageManagerService.collectSharedLibraryInfos(pkg, availablePackages, this.mSharedLibraries, null);
        this.executeSharedLibrariesUpdateLPr(pkg, changingLib, sharedLibraryInfos);
    }

    private static ArrayList<SharedLibraryInfo> collectSharedLibraryInfos(PackageParser.Package pkg, Map<String, PackageParser.Package> availablePackages, Map<String, LongSparseArray<SharedLibraryInfo>> existingLibraries, Map<String, LongSparseArray<SharedLibraryInfo>> newLibraries) throws PackageManagerException {
        if (pkg == null) {
            return null;
        }
        ArrayList<SharedLibraryInfo> usesLibraryInfos = null;
        if (pkg.usesLibraries != null) {
            usesLibraryInfos = PackageManagerService.collectSharedLibraryInfos(pkg.usesLibraries, null, null, pkg.packageName, true, pkg.applicationInfo.targetSdkVersion, null, availablePackages, existingLibraries, newLibraries);
        }
        if (pkg.usesStaticLibraries != null) {
            usesLibraryInfos = PackageManagerService.collectSharedLibraryInfos(pkg.usesStaticLibraries, pkg.usesStaticLibrariesVersions, pkg.usesStaticLibrariesCertDigests, pkg.packageName, true, pkg.applicationInfo.targetSdkVersion, usesLibraryInfos, availablePackages, existingLibraries, newLibraries);
        }
        if (pkg.usesOptionalLibraries != null) {
            usesLibraryInfos = PackageManagerService.collectSharedLibraryInfos(pkg.usesOptionalLibraries, null, null, pkg.packageName, false, pkg.applicationInfo.targetSdkVersion, usesLibraryInfos, availablePackages, existingLibraries, newLibraries);
        }
        return usesLibraryInfos;
    }

    private void executeSharedLibrariesUpdateLPr(PackageParser.Package pkg, PackageParser.Package changingLib, ArrayList<SharedLibraryInfo> usesLibraryInfos) {
        this.applyDefiningSharedLibraryUpdateLocked(pkg, null, (definingLibrary, dependency) -> definingLibrary.clearDependencies());
        if (usesLibraryInfos != null) {
            pkg.usesLibraryInfos = usesLibraryInfos;
            LinkedHashSet<String> usesLibraryFiles = new LinkedHashSet<String>();
            for (SharedLibraryInfo libInfo : usesLibraryInfos) {
                this.addSharedLibraryLPr(pkg, usesLibraryFiles, libInfo, changingLib);
            }
            pkg.usesLibraryFiles = usesLibraryFiles.toArray(new String[usesLibraryFiles.size()]);
        } else {
            pkg.usesLibraryInfos = null;
            pkg.usesLibraryFiles = null;
        }
    }

    @GuardedBy(value={"mPackages"})
    private static ArrayList<SharedLibraryInfo> collectSharedLibraryInfos(List<String> requestedLibraries, long[] requiredVersions, String[][] requiredCertDigests, String packageName, boolean required, int targetSdk, ArrayList<SharedLibraryInfo> outUsedLibraries, Map<String, PackageParser.Package> availablePackages, Map<String, LongSparseArray<SharedLibraryInfo>> existingLibraries, Map<String, LongSparseArray<SharedLibraryInfo>> newLibraries) throws PackageManagerException {
        int libCount = requestedLibraries.size();
        for (int i = 0; i < libCount; ++i) {
            long libVersion;
            String libName = requestedLibraries.get(i);
            SharedLibraryInfo libraryInfo = PackageManagerService.getSharedLibraryInfo(libName, libVersion = requiredVersions != null ? requiredVersions[i] : -1L, existingLibraries, newLibraries);
            if (libraryInfo == null) {
                if (!required) continue;
                throw new PackageManagerException(-9, "Package " + packageName + " requires unavailable shared library " + libName + "; failing!");
            }
            if (requiredVersions != null && requiredCertDigests != null) {
                if (libraryInfo.getLongVersion() != requiredVersions[i]) {
                    throw new PackageManagerException(-9, "Package " + packageName + " requires unavailable static shared library " + libName + " version " + libraryInfo.getLongVersion() + "; failing!");
                }
                PackageParser.Package libPkg = availablePackages.get(libraryInfo.getPackageName());
                if (libPkg == null) {
                    throw new PackageManagerException(-9, "Package " + packageName + " requires unavailable static shared library; failing!");
                }
                Object[] expectedCertDigests = requiredCertDigests[i];
                if (expectedCertDigests.length > 1) {
                    Object[] libCertDigests;
                    Object[] objectArray = libCertDigests = targetSdk >= 27 ? PackageUtils.computeSignaturesSha256Digests(libPkg.mSigningDetails.signatures) : PackageUtils.computeSignaturesSha256Digests(new Signature[]{libPkg.mSigningDetails.signatures[0]});
                    if (expectedCertDigests.length != libCertDigests.length) {
                        throw new PackageManagerException(-9, "Package " + packageName + " requires differently signed static shared library; failing!");
                    }
                    Arrays.sort(libCertDigests);
                    Arrays.sort(expectedCertDigests);
                    int certCount = libCertDigests.length;
                    for (int j = 0; j < certCount; ++j) {
                        if (((String)libCertDigests[j]).equalsIgnoreCase((String)expectedCertDigests[j])) continue;
                        throw new PackageManagerException(-9, "Package " + packageName + " requires differently signed static shared library; failing!");
                    }
                } else if (!libPkg.mSigningDetails.hasSha256Certificate(ByteStringUtils.fromHexToByteArray(expectedCertDigests[0]))) {
                    throw new PackageManagerException(-9, "Package " + packageName + " requires differently signed static shared library; failing!");
                }
            }
            if (outUsedLibraries == null) {
                outUsedLibraries = new ArrayList();
            }
            outUsedLibraries.add(libraryInfo);
        }
        return outUsedLibraries;
    }

    private static boolean hasString(List<String> list, List<String> which) {
        if (list == null || which == null) {
            return false;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            for (int j = which.size() - 1; j >= 0; --j) {
                if (!which.get(j).equals(list.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    @GuardedBy(value={"mPackages"})
    private ArrayList<PackageParser.Package> updateAllSharedLibrariesLocked(PackageParser.Package updatedPkg, Map<String, PackageParser.Package> availablePackages) {
        ArrayList<PackageParser.Package> resultList = null;
        ArraySet<String> descendants = null;
        ArrayList<PackageParser.Package> needsUpdating = null;
        if (updatedPkg != null) {
            needsUpdating = new ArrayList<PackageParser.Package>(1);
            needsUpdating.add(updatedPkg);
        }
        do {
            PackageParser.Package changingPkg = needsUpdating == null ? null : (PackageParser.Package)needsUpdating.remove(0);
            for (int i = this.mPackages.size() - 1; i >= 0; --i) {
                PackageParser.Package pkg = this.mPackages.valueAt(i);
                if (changingPkg != null && !PackageManagerService.hasString(pkg.usesLibraries, changingPkg.libraryNames) && !PackageManagerService.hasString(pkg.usesOptionalLibraries, changingPkg.libraryNames) && !ArrayUtils.contains(pkg.usesStaticLibraries, changingPkg.staticSharedLibName)) continue;
                if (resultList == null) {
                    resultList = new ArrayList<PackageParser.Package>();
                }
                resultList.add(pkg);
                if (changingPkg != null) {
                    if (descendants == null) {
                        descendants = new ArraySet<String>();
                    }
                    if (!descendants.contains(pkg.packageName)) {
                        descendants.add(pkg.packageName);
                        needsUpdating.add(pkg);
                    }
                }
                try {
                    this.updateSharedLibrariesLocked(pkg, changingPkg, availablePackages);
                    continue;
                }
                catch (PackageManagerException e) {
                    if (!pkg.isSystem() || pkg.isUpdatedSystemApp()) {
                        int flags = pkg.isUpdatedSystemApp() ? 1 : 0;
                        this.deletePackageLIF(pkg.packageName, null, true, sUserManager.getUserIds(), flags, null, true, null);
                    }
                    Slog.e(TAG, "updateAllSharedLibrariesLPw failed: " + e.getMessage());
                }
            }
        } while (needsUpdating != null && needsUpdating.size() > 0);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mInstallLock", "mPackages"})
    private List<ScanResult> scanPackageTracedLI(PackageParser.Package pkg, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        Trace.traceBegin(262144L, "scanPackage");
        if ((scanFlags & 0x400) == 0) {
            if (pkg.childPackages != null && pkg.childPackages.size() > 0) {
                scanFlags |= 0x400;
            }
        } else {
            scanFlags &= 0xFFFFFBFF;
        }
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        ArrayList<ScanResult> scanResults = new ArrayList<ScanResult>(1 + childCount);
        try {
            scanResults.add(this.scanPackageNewLI(pkg, parseFlags, scanFlags, currentTime, user));
            for (int i = 0; i < childCount; ++i) {
                PackageParser.Package childPkg = pkg.childPackages.get(i);
                scanResults.add(this.scanPackageNewLI(childPkg, parseFlags, scanFlags, currentTime, user));
            }
        }
        finally {
            Trace.traceEnd(262144L);
        }
        if ((scanFlags & 0x400) != 0) {
            return this.scanPackageTracedLI(pkg, parseFlags, scanFlags, currentTime, user);
        }
        return scanResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int adjustScanFlags(int scanFlags, PackageSetting pkgSetting, PackageSetting disabledPkgSetting, UserHandle user, PackageParser.Package pkg) {
        boolean skipVendorPrivilegeScan;
        PackageSetting systemPkgSetting;
        PackageSetting packageSetting = systemPkgSetting = (scanFlags & 4) != 0 && disabledPkgSetting == null && pkgSetting != null && pkgSetting.isSystem() ? pkgSetting : disabledPkgSetting;
        if (systemPkgSetting != null) {
            scanFlags |= 0x20000;
            if ((systemPkgSetting.pkgPrivateFlags & 8) != 0) {
                scanFlags |= 0x40000;
            }
            if ((systemPkgSetting.pkgPrivateFlags & 0x20000) != 0) {
                scanFlags |= 0x80000;
            }
            if ((systemPkgSetting.pkgPrivateFlags & 0x40000) != 0) {
                scanFlags |= 0x100000;
            }
            if ((systemPkgSetting.pkgPrivateFlags & 0x80000) != 0) {
                scanFlags |= 0x200000;
            }
            if ((systemPkgSetting.pkgPrivateFlags & 0x200000) != 0) {
                scanFlags |= 0x400000;
            }
            if ((systemPkgSetting.pkgPrivateFlags & 0x40000000) != 0) {
                scanFlags |= 0x800000;
            }
        }
        if (pkgSetting != null) {
            int userId;
            int n = userId = user == null ? 0 : user.getIdentifier();
            if (pkgSetting.getInstantApp(userId)) {
                scanFlags |= 0x4000;
            }
            if (pkgSetting.getVirtulalPreload(userId)) {
                scanFlags |= 0x10000;
            }
        }
        boolean bl = skipVendorPrivilegeScan = (scanFlags & 0x100000) != 0 && SystemProperties.getInt("ro.vndk.version", 28) < 28;
        if ((scanFlags & 0x40000) == 0 && !pkg.isPrivileged() && pkg.mSharedUserId != null && !skipVendorPrivilegeScan) {
            SharedUserSetting sharedUserSetting = null;
            try {
                sharedUserSetting = this.mSettings.getSharedUserLPw(pkg.mSharedUserId, 0, 0, false);
            }
            catch (PackageManagerException packageManagerException) {
                // empty catch block
            }
            if (sharedUserSetting != null && sharedUserSetting.isPrivileged()) {
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    PackageSetting platformPkgSetting = this.mSettings.mPackages.get(PLATFORM_PACKAGE_NAME);
                    if (PackageManagerServiceUtils.compareSignatures(platformPkgSetting.signatures.mSigningDetails.signatures, pkg.mSigningDetails.signatures) != 0) {
                        scanFlags |= 0x40000;
                    }
                }
            }
        }
        return scanFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mInstallLock", "mPackages"})
    private ScanResult scanPackageNewLI(PackageParser.Package pkg, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        String renamedPkgName = this.mSettings.getRenamedPackageLPr(pkg.mRealPackage);
        String realPkgName = PackageManagerService.getRealPackageName(pkg, renamedPkgName);
        if (realPkgName != null) {
            PackageManagerService.ensurePackageRenamed(pkg, renamedPkgName);
        }
        PackageSetting originalPkgSetting = this.getOriginalPackageLocked(pkg, renamedPkgName);
        PackageSetting pkgSetting = this.mSettings.getPackageLPr(pkg.packageName);
        PackageSetting disabledPkgSetting = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
        if (this.mTransferedPackages.contains(pkg.packageName)) {
            Slog.w(TAG, "Package " + pkg.packageName + " was transferred to another, but its .apk remains");
        }
        scanFlags = this.adjustScanFlags(scanFlags, pkgSetting, disabledPkgSetting, user, pkg);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageManagerService.applyPolicy(pkg, parseFlags, scanFlags, this.mPlatformPackage);
            this.assertPackageIsValid(pkg, parseFlags, scanFlags);
            SharedUserSetting sharedUserSetting = null;
            if (pkg.mSharedUserId != null) {
                sharedUserSetting = this.mSettings.getSharedUserLPw(pkg.mSharedUserId, 0, 0, true);
            }
            ScanRequest request = new ScanRequest(pkg, sharedUserSetting, pkgSetting == null ? null : pkgSetting.pkg, pkgSetting, disabledPkgSetting, originalPkgSetting, realPkgName, parseFlags, scanFlags, pkg == this.mPlatformPackage, user);
            return PackageManagerService.scanPackageOnlyLI(request, this.mFactoryTest, currentTime);
        }
    }

    private boolean optimisticallyRegisterAppId(ScanResult result) throws PackageManagerException {
        if (!result.existingSettingCopied) {
            return this.mSettings.registerAppIdLPw(result.pkgSetting);
        }
        return false;
    }

    private void cleanUpAppIdCreation(ScanResult result) {
        if (result.pkgSetting.appId > 0) {
            this.mSettings.removeAppIdLPw(result.pkgSetting.appId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mPackages", "mInstallLock"})
    private void commitReconciledScanResultLocked(ReconciledPackage reconciledPkg) {
        int i;
        PackageSetting pkgSetting;
        ScanResult result = reconciledPkg.scanResult;
        ScanRequest request = result.request;
        PackageParser.Package pkg = request.pkg;
        PackageParser.Package oldPkg = request.oldPkg;
        int parseFlags = request.parseFlags;
        int scanFlags = request.scanFlags;
        PackageSetting oldPkgSetting = request.oldPkgSetting;
        PackageSetting originalPkgSetting = request.originalPkgSetting;
        UserHandle user = request.user;
        String realPkgName = request.realPkgName;
        List<String> changedAbiCodePath = result.changedAbiCodePath;
        if (result.existingSettingCopied) {
            pkgSetting = request.pkgSetting;
            pkgSetting.updateFrom(result.pkgSetting);
            pkg.mExtras = pkgSetting;
            if (pkgSetting.sharedUser != null && pkgSetting.sharedUser.removePackage(result.pkgSetting)) {
                pkgSetting.sharedUser.addPackage(pkgSetting);
            }
        } else {
            pkgSetting = result.pkgSetting;
            if (originalPkgSetting != null) {
                this.mSettings.addRenamedPackageLPw(pkg.packageName, originalPkgSetting.name);
            }
            if (originalPkgSetting != null && (scanFlags & 0x400) == 0) {
                this.mTransferedPackages.add(originalPkgSetting.name);
            }
        }
        pkg.applicationInfo.uid = pkgSetting.appId;
        this.mSettings.writeUserRestrictionsLPw(pkgSetting, oldPkgSetting);
        if ((scanFlags & 0x400) == 0 && realPkgName != null) {
            this.mTransferedPackages.add(pkg.packageName);
        }
        if (reconciledPkg.collectedSharedLibraryInfos != null) {
            this.executeSharedLibrariesUpdateLPr(pkg, null, reconciledPkg.collectedSharedLibraryInfos);
        }
        KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
        if (reconciledPkg.removeAppKeySetData) {
            ksms.removeAppKeySetDataLPw(pkg.packageName);
        }
        if (reconciledPkg.sharedUserSignaturesChanged) {
            pkgSetting.sharedUser.signaturesChanged = Boolean.TRUE;
            pkgSetting.sharedUser.signatures.mSigningDetails = reconciledPkg.signingDetails;
        }
        pkgSetting.signatures.mSigningDetails = reconciledPkg.signingDetails;
        if ((scanFlags & 0x400) == 0 && pkg.mAdoptPermissions != null) {
            for (i = pkg.mAdoptPermissions.size() - 1; i >= 0; --i) {
                String origName = pkg.mAdoptPermissions.get(i);
                PackageSetting orig = this.mSettings.getPackageLPr(origName);
                if (orig == null || !this.verifyPackageUpdateLPr(orig, pkg)) continue;
                Slog.i(TAG, "Adopting permissions from " + origName + " to " + pkg.packageName);
                this.mSettings.mPermissions.transferPermissions(origName, pkg.packageName);
            }
        }
        if (changedAbiCodePath != null && changedAbiCodePath.size() > 0) {
            for (i = changedAbiCodePath.size() - 1; i >= 0; --i) {
                String codePathString = changedAbiCodePath.get(i);
                try {
                    this.mInstaller.rmdex(codePathString, InstructionSets.getDexCodeInstructionSet(InstructionSets.getPreferredInstructionSet()));
                    continue;
                }
                catch (Installer.InstallerException installerException) {
                    // empty catch block
                }
            }
        }
        if ((scanFlags & 0x400) != 0) {
            if (oldPkgSetting != null) {
                ArrayMap<String, PackageParser.Package> i2 = this.mPackages;
                synchronized (i2) {
                    this.mSettings.mPackages.put(oldPkgSetting.name, oldPkgSetting);
                }
            }
        } else {
            int userId = user == null ? 0 : user.getIdentifier();
            this.commitPackageSettings(pkg, oldPkg, pkgSetting, scanFlags, (parseFlags & Integer.MIN_VALUE) != 0, reconciledPkg);
            if (pkgSetting.getInstantApp(userId)) {
                this.mInstantAppRegistry.addInstantAppLPw(userId, pkgSetting.appId);
            }
        }
    }

    private static String getRealPackageName(PackageParser.Package pkg, String renamedPkgName) {
        if (PackageManagerService.isPackageRenamed(pkg, renamedPkgName)) {
            return pkg.mRealPackage;
        }
        return null;
    }

    private static boolean isPackageRenamed(PackageParser.Package pkg, String renamedPkgName) {
        return pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(renamedPkgName);
    }

    @GuardedBy(value={"mPackages"})
    private PackageSetting getOriginalPackageLocked(PackageParser.Package pkg, String renamedPkgName) {
        if (!PackageManagerService.isPackageRenamed(pkg, renamedPkgName)) {
            return null;
        }
        for (int i = pkg.mOriginalPackages.size() - 1; i >= 0; --i) {
            PackageSetting originalPs = this.mSettings.getPackageLPr(pkg.mOriginalPackages.get(i));
            if (originalPs == null || !this.verifyPackageUpdateLPr(originalPs, pkg)) continue;
            if (originalPs.sharedUser != null && !originalPs.sharedUser.name.equals(pkg.mSharedUserId)) {
                Slog.w(TAG, "Unable to migrate data from " + originalPs.name + " to " + pkg.packageName + ": old uid " + originalPs.sharedUser.name + " differs from " + pkg.mSharedUserId);
                continue;
            }
            return originalPs;
        }
        return null;
    }

    private static void ensurePackageRenamed(PackageParser.Package pkg, String renamedPackageName) {
        if (pkg.mOriginalPackages == null || !pkg.mOriginalPackages.contains(renamedPackageName) || pkg.packageName.equals(renamedPackageName)) {
            return;
        }
        pkg.setPackageName(renamedPackageName);
    }

    @GuardedBy(value={"mInstallLock"})
    private static ScanResult scanPackageOnlyLI(ScanRequest request, boolean isUnderFactoryTest, long currentTime) throws PackageManagerException {
        String volumeUuid;
        int userId;
        boolean instantApp;
        boolean createNewPackage;
        boolean needToDeriveAbi;
        PackageParser.Package pkg = request.pkg;
        PackageSetting pkgSetting = request.pkgSetting;
        PackageSetting disabledPkgSetting = request.disabledPkgSetting;
        PackageSetting originalPkgSetting = request.originalPkgSetting;
        int parseFlags = request.parseFlags;
        int scanFlags = request.scanFlags;
        String realPkgName = request.realPkgName;
        SharedUserSetting sharedUserSetting = request.sharedUserSetting;
        UserHandle user = request.user;
        boolean isPlatformPackage = request.isPlatformPackage;
        List<String> changedAbiCodePath = null;
        File scanFile = new File(pkg.codePath);
        File destCodeFile = new File(pkg.applicationInfo.getCodePath());
        File destResourceFile = new File(pkg.applicationInfo.getResourcePath());
        String primaryCpuAbiFromSettings = null;
        String secondaryCpuAbiFromSettings = null;
        boolean bl = needToDeriveAbi = (scanFlags & 0x2000) != 0;
        if (!needToDeriveAbi) {
            if (pkgSetting != null) {
                primaryCpuAbiFromSettings = pkgSetting.primaryCpuAbiString;
                secondaryCpuAbiFromSettings = pkgSetting.secondaryCpuAbiString;
            } else {
                needToDeriveAbi = true;
            }
        }
        if (pkgSetting != null && pkgSetting.sharedUser != sharedUserSetting) {
            PackageManagerService.reportSettingsProblem(5, "Package " + pkg.packageName + " shared user changed from " + (pkgSetting.sharedUser != null ? pkgSetting.sharedUser.name : "<nothing>") + " to " + (sharedUserSetting != null ? sharedUserSetting.name : "<nothing>") + "; replacing with new");
            pkgSetting = null;
        }
        String[] usesStaticLibraries = null;
        if (pkg.usesStaticLibraries != null) {
            usesStaticLibraries = new String[pkg.usesStaticLibraries.size()];
            pkg.usesStaticLibraries.toArray(usesStaticLibraries);
        }
        boolean bl2 = createNewPackage = pkgSetting == null;
        if (createNewPackage) {
            String parentPackageName = pkg.parentPackage != null ? pkg.parentPackage.packageName : null;
            instantApp = (scanFlags & 0x4000) != 0;
            boolean virtualPreload = (scanFlags & 0x10000) != 0;
            pkgSetting = Settings.createNewSetting(pkg.packageName, originalPkgSetting, disabledPkgSetting, realPkgName, sharedUserSetting, destCodeFile, destResourceFile, pkg.applicationInfo.nativeLibraryRootDir, pkg.applicationInfo.primaryCpuAbi, pkg.applicationInfo.secondaryCpuAbi, pkg.mVersionCode, pkg.applicationInfo.flags, pkg.applicationInfo.privateFlags, user, true, instantApp, virtualPreload, parentPackageName, pkg.getChildPackageNames(), UserManagerService.getInstance(), usesStaticLibraries, pkg.usesStaticLibrariesVersions);
        } else {
            pkgSetting = new PackageSetting(pkgSetting);
            pkgSetting.pkg = pkg;
            Settings.updatePackageSetting(pkgSetting, disabledPkgSetting, sharedUserSetting, destCodeFile, destResourceFile, pkg.applicationInfo.nativeLibraryDir, pkg.applicationInfo.primaryCpuAbi, pkg.applicationInfo.secondaryCpuAbi, pkg.applicationInfo.flags, pkg.applicationInfo.privateFlags, pkg.getChildPackageNames(), UserManagerService.getInstance(), usesStaticLibraries, pkg.usesStaticLibrariesVersions);
        }
        if (createNewPackage && originalPkgSetting != null) {
            pkg.setPackageName(originalPkgSetting.name);
            String msg = "New package " + pkgSetting.realName + " renamed to replace old package " + pkgSetting.name;
            PackageManagerService.reportSettingsProblem(5, msg);
        }
        int n = userId = user == null ? 0 : user.getIdentifier();
        if (!createNewPackage) {
            instantApp = (scanFlags & 0x4000) != 0;
            boolean fullApp = (scanFlags & 0x8000) != 0;
            PackageManagerService.setInstantAppForUser(pkgSetting, userId, instantApp, fullApp);
        }
        if (disabledPkgSetting != null || 0 != (scanFlags & 4) && pkgSetting != null && pkgSetting.isSystem()) {
            pkg.applicationInfo.flags |= 0x80;
        }
        int targetSdkVersion = sharedUserSetting != null && sharedUserSetting.packages.size() != 0 ? sharedUserSetting.seInfoTargetSdkVersion : pkg.applicationInfo.targetSdkVersion;
        boolean isPrivileged = sharedUserSetting != null ? sharedUserSetting.isPrivileged() | pkg.isPrivileged() : pkg.isPrivileged();
        pkg.applicationInfo.seInfo = SELinuxMMAC.getSeInfo(pkg, isPrivileged, pkg.applicationInfo.targetSandboxVersion, targetSdkVersion);
        pkg.applicationInfo.seInfoUser = SELinuxUtil.assignSeinfoUser(pkgSetting.readUserState(userId == -1 ? 0 : userId));
        pkg.mExtras = pkgSetting;
        pkg.applicationInfo.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.packageName, pkg.applicationInfo.processName);
        if (!isPlatformPackage) {
            pkg.applicationInfo.initForUser(0);
        }
        String cpuAbiOverride = PackageManagerServiceUtils.deriveAbiOverride(pkg.cpuAbiOverride, pkgSetting);
        if ((scanFlags & 4) == 0) {
            if (needToDeriveAbi) {
                Trace.traceBegin(262144L, "derivePackageAbi");
                boolean extractNativeLibs = !pkg.isLibrary();
                PackageManagerService.derivePackageAbi(pkg, cpuAbiOverride, extractNativeLibs);
                Trace.traceEnd(262144L);
                if (PackageManagerService.isSystemApp(pkg) && !pkg.isUpdatedSystemApp() && pkg.applicationInfo.primaryCpuAbi == null) {
                    PackageManagerService.setBundledAppAbisAndRoots(pkg, pkgSetting);
                    PackageManagerService.setNativeLibraryPaths(pkg, sAppLib32InstallDir);
                }
            } else {
                pkg.applicationInfo.primaryCpuAbi = primaryCpuAbiFromSettings;
                pkg.applicationInfo.secondaryCpuAbi = secondaryCpuAbiFromSettings;
                PackageManagerService.setNativeLibraryPaths(pkg, sAppLib32InstallDir);
            }
        } else {
            if ((scanFlags & 0x100) != 0) {
                pkg.applicationInfo.primaryCpuAbi = pkgSetting.primaryCpuAbiString;
                pkg.applicationInfo.secondaryCpuAbi = pkgSetting.secondaryCpuAbiString;
            }
            PackageManagerService.setNativeLibraryPaths(pkg, sAppLib32InstallDir);
        }
        if (isPlatformPackage) {
            String string2 = pkg.applicationInfo.primaryCpuAbi = VMRuntime.getRuntime().is64Bit() ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        }
        if ((scanFlags & 1) == 0 && (scanFlags & 4) != 0 && cpuAbiOverride == null && pkg.packageName != null) {
            Slog.w(TAG, "Ignoring persisted ABI override " + cpuAbiOverride + " for package " + pkg.packageName);
        }
        pkgSetting.primaryCpuAbiString = pkg.applicationInfo.primaryCpuAbi;
        pkgSetting.secondaryCpuAbiString = pkg.applicationInfo.secondaryCpuAbi;
        pkgSetting.cpuAbiOverrideString = cpuAbiOverride;
        pkg.cpuAbiOverride = cpuAbiOverride;
        pkgSetting.legacyNativeLibraryPathString = pkg.applicationInfo.nativeLibraryRootDir;
        if ((scanFlags & 0x10) == 0 && pkgSetting.sharedUser != null) {
            changedAbiCodePath = PackageManagerService.adjustCpuAbisForSharedUserLPw(pkgSetting.sharedUser.packages, pkg);
        }
        if (isUnderFactoryTest && pkg.requestedPermissions.contains("android.permission.FACTORY_TEST")) {
            pkg.applicationInfo.flags |= 0x10;
        }
        if (PackageManagerService.isSystemApp(pkg)) {
            pkgSetting.isOrphaned = true;
        }
        long scanFileTime = PackageManagerServiceUtils.getLastModifiedTime(pkg);
        if (currentTime != 0L) {
            if (pkgSetting.firstInstallTime == 0L) {
                pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = currentTime;
            } else if ((scanFlags & 8) != 0) {
                pkgSetting.lastUpdateTime = currentTime;
            }
        } else if (pkgSetting.firstInstallTime == 0L) {
            pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = scanFileTime;
        } else if ((parseFlags & 0x10) != 0 && scanFileTime != pkgSetting.timeStamp) {
            pkgSetting.lastUpdateTime = scanFileTime;
        }
        pkgSetting.setTimeStamp(scanFileTime);
        pkgSetting.pkg = pkg;
        pkgSetting.pkgFlags = pkg.applicationInfo.flags;
        if (pkg.getLongVersionCode() != pkgSetting.versionCode) {
            pkgSetting.versionCode = pkg.getLongVersionCode();
        }
        if (!Objects.equals(volumeUuid = pkg.applicationInfo.volumeUuid, pkgSetting.volumeUuid)) {
            Slog.i(TAG, "Update" + (pkgSetting.isSystem() ? " system" : "") + " package " + pkg.packageName + " volume from " + pkgSetting.volumeUuid + " to " + volumeUuid);
            pkgSetting.volumeUuid = volumeUuid;
        }
        SharedLibraryInfo staticSharedLibraryInfo = null;
        if (!TextUtils.isEmpty(pkg.staticSharedLibName)) {
            staticSharedLibraryInfo = SharedLibraryInfo.createForStatic(pkg);
        }
        ArrayList<SharedLibraryInfo> dynamicSharedLibraryInfos = null;
        if (!ArrayUtils.isEmpty(pkg.libraryNames)) {
            dynamicSharedLibraryInfos = new ArrayList<SharedLibraryInfo>(pkg.libraryNames.size());
            for (String name : pkg.libraryNames) {
                dynamicSharedLibraryInfos.add(SharedLibraryInfo.createForDynamic(pkg, name));
            }
        }
        return new ScanResult(request, true, pkgSetting, changedAbiCodePath, !createNewPackage, staticSharedLibraryInfo, dynamicSharedLibraryInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean apkHasCode(String fileName) {
        StrictJarFile jarFile = null;
        try {
            jarFile = new StrictJarFile(fileName, false, false);
            boolean bl = jarFile.findEntry("classes.dex") != null;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private static void assertCodePolicy(PackageParser.Package pkg) throws PackageManagerException {
        boolean shouldHaveCode;
        boolean bl = shouldHaveCode = (pkg.applicationInfo.flags & 4) != 0;
        if (shouldHaveCode && !PackageManagerService.apkHasCode(pkg.baseCodePath)) {
            throw new PackageManagerException(-2, "Package " + pkg.baseCodePath + " code is missing");
        }
        if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
            for (int i = 0; i < pkg.splitCodePaths.length; ++i) {
                boolean splitShouldHaveCode;
                boolean bl2 = splitShouldHaveCode = (pkg.splitFlags[i] & 4) != 0;
                if (!splitShouldHaveCode || PackageManagerService.apkHasCode(pkg.splitCodePaths[i])) continue;
                throw new PackageManagerException(-2, "Package " + pkg.splitCodePaths[i] + " code is missing");
            }
        }
    }

    private static void applyPolicy(PackageParser.Package pkg, int parseFlags, int scanFlags, PackageParser.Package platformPkg) {
        if ((scanFlags & 0x20000) != 0) {
            pkg.applicationInfo.flags |= 1;
            if (pkg.applicationInfo.isDirectBootAware()) {
                for (PackageParser.Service s : pkg.services) {
                    s.info.directBootAware = true;
                    s.info.encryptionAware = true;
                }
                for (PackageParser.Provider p : pkg.providers) {
                    p.info.directBootAware = true;
                    p.info.encryptionAware = true;
                }
                for (PackageParser.Activity a : pkg.activities) {
                    a.info.directBootAware = true;
                    a.info.encryptionAware = true;
                }
                for (PackageParser.Activity r : pkg.receivers) {
                    r.info.directBootAware = true;
                    r.info.encryptionAware = true;
                }
            }
            if (PackageManagerServiceUtils.compressedFileExists(pkg.codePath)) {
                pkg.isStub = true;
            }
        } else {
            pkg.coreApp = false;
            pkg.applicationInfo.flags &= 0xFFFFFFF7;
            pkg.applicationInfo.privateFlags &= 0xFFFFFFDF;
            pkg.applicationInfo.privateFlags &= 0xFFFFFFBF;
            if (pkg.permissionGroups != null && pkg.permissionGroups.size() > 0) {
                for (int i = pkg.permissionGroups.size() - 1; i >= 0; --i) {
                    pkg.permissionGroups.get((int)i).info.priority = 0;
                }
            }
        }
        if ((scanFlags & 0x40000) == 0) {
            pkg.protectedBroadcasts = null;
            if (pkg.receivers != null) {
                for (int i = pkg.receivers.size() - 1; i >= 0; --i) {
                    PackageParser.Activity receiver = pkg.receivers.get(i);
                    if ((receiver.info.flags & 0x40000000) == 0) continue;
                    receiver.info.exported = false;
                }
            }
            if (pkg.services != null) {
                for (int i = pkg.services.size() - 1; i >= 0; --i) {
                    PackageParser.Service service = pkg.services.get(i);
                    if ((service.info.flags & 0x40000000) == 0) continue;
                    service.info.exported = false;
                }
            }
            if (pkg.providers != null) {
                for (int i = pkg.providers.size() - 1; i >= 0; --i) {
                    PackageParser.Provider provider = pkg.providers.get(i);
                    if ((provider.info.flags & 0x40000000) == 0) continue;
                    provider.info.exported = false;
                }
            }
        }
        if ((scanFlags & 0x40000) != 0) {
            pkg.applicationInfo.privateFlags |= 8;
        }
        if ((scanFlags & 0x80000) != 0) {
            pkg.applicationInfo.privateFlags |= 0x20000;
        }
        if ((scanFlags & 0x100000) != 0) {
            pkg.applicationInfo.privateFlags |= 0x40000;
        }
        if ((scanFlags & 0x200000) != 0) {
            pkg.applicationInfo.privateFlags |= 0x80000;
        }
        if ((scanFlags & 0x400000) != 0) {
            pkg.applicationInfo.privateFlags |= 0x200000;
        }
        if ((scanFlags & 0x800000) != 0) {
            pkg.applicationInfo.privateFlags |= 0x40000000;
        }
        if (PLATFORM_PACKAGE_NAME.equals(pkg.packageName) || platformPkg != null && PackageManagerServiceUtils.compareSignatures(platformPkg.mSigningDetails.signatures, pkg.mSigningDetails.signatures) == 0) {
            pkg.applicationInfo.privateFlags |= 0x100000;
        }
        if (!PackageManagerService.isSystemApp(pkg)) {
            pkg.mOriginalPackages = null;
            pkg.mRealPackage = null;
            pkg.mAdoptPermissions = null;
        }
        PackageBackwardCompatibility.modifySharedLibraries(pkg);
    }

    private static <T> T assertNotNull(T object, String message) throws PackageManagerException {
        if (object == null) {
            throw new PackageManagerException(-110, message);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertPackageIsValid(PackageParser.Package pkg, int parseFlags, int scanFlags) throws PackageManagerException {
        boolean isFirstBootOrUpgrade;
        if ((parseFlags & 0x40) != 0) {
            PackageManagerService.assertCodePolicy(pkg);
        }
        if (pkg.applicationInfo.getCodePath() == null || pkg.applicationInfo.getResourcePath() == null) {
            throw new PackageManagerException(-2, "Code and resource paths haven't been set correctly");
        }
        boolean isUserInstall = (scanFlags & 0x10) == 0;
        boolean bl = isFirstBootOrUpgrade = (scanFlags & 0x2000) != 0;
        if ((isUserInstall || isFirstBootOrUpgrade) && this.mApexManager.isApexPackage(pkg.packageName)) {
            throw new PackageManagerException(-5, pkg.packageName + " is an APEX package and can't be installed as an APK.");
        }
        KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
        ksms.assertScannedPackageValid(pkg);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (pkg.packageName.equals(PLATFORM_PACKAGE_NAME) && this.mAndroidApplication != null) {
                Slog.w(TAG, "*************************************************");
                Slog.w(TAG, "Core android package being redefined.  Skipping.");
                Slog.w(TAG, " codePath=" + pkg.codePath);
                Slog.w(TAG, "*************************************************");
                throw new PackageManagerException(-5, "Core android package being redefined.  Skipping.");
            }
            if ((scanFlags & 4) == 0 && this.mPackages.containsKey(pkg.packageName)) {
                throw new PackageManagerException(-5, "Application package " + pkg.packageName + " already installed.  Skipping duplicate.");
            }
            if (pkg.applicationInfo.isStaticSharedLibrary()) {
                if ((scanFlags & 4) == 0 && this.mPackages.containsKey(pkg.manifestPackageName)) {
                    throw new PackageManagerException("Duplicate static shared lib provider package");
                }
                if (pkg.applicationInfo.targetSdkVersion < 26) {
                    throw new PackageManagerException("Packages declaring static-shared libs must target O SDK or higher");
                }
                if ((scanFlags & 0x4000) != 0) {
                    throw new PackageManagerException("Packages declaring static-shared libs cannot be instant apps");
                }
                if (!ArrayUtils.isEmpty(pkg.mOriginalPackages)) {
                    throw new PackageManagerException("Packages declaring static-shared libs cannot be renamed");
                }
                if (!ArrayUtils.isEmpty(pkg.childPackages)) {
                    throw new PackageManagerException("Packages declaring static-shared libs cannot have child packages");
                }
                if (!ArrayUtils.isEmpty(pkg.libraryNames)) {
                    throw new PackageManagerException("Packages declaring static-shared libs cannot declare dynamic libs");
                }
                if (pkg.mSharedUserId != null) {
                    throw new PackageManagerException("Packages declaring static-shared libs cannot declare shared users");
                }
                if (!pkg.activities.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare activities");
                }
                if (!pkg.services.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare services");
                }
                if (!pkg.providers.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare content providers");
                }
                if (!pkg.receivers.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare broadcast receivers");
                }
                if (!pkg.permissionGroups.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare permission groups");
                }
                if (!pkg.permissions.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare permissions");
                }
                if (pkg.protectedBroadcasts != null) {
                    throw new PackageManagerException("Static shared libs cannot declare protected broadcasts");
                }
                if (pkg.mOverlayTarget != null) {
                    throw new PackageManagerException("Static shared libs cannot be overlay targets");
                }
                long minVersionCode = Long.MIN_VALUE;
                long maxVersionCode = Long.MAX_VALUE;
                LongSparseArray<SharedLibraryInfo> versionedLib = this.mSharedLibraries.get(pkg.staticSharedLibName);
                if (versionedLib != null) {
                    int versionCount = versionedLib.size();
                    for (int i = 0; i < versionCount; ++i) {
                        SharedLibraryInfo libInfo = versionedLib.valueAt(i);
                        long libVersionCode = libInfo.getDeclaringPackage().getLongVersionCode();
                        if (libInfo.getLongVersion() < pkg.staticSharedLibVersion) {
                            minVersionCode = Math.max(minVersionCode, libVersionCode + 1L);
                            continue;
                        }
                        if (libInfo.getLongVersion() > pkg.staticSharedLibVersion) {
                            maxVersionCode = Math.min(maxVersionCode, libVersionCode - 1L);
                            continue;
                        }
                        minVersionCode = maxVersionCode = libVersionCode;
                        break;
                    }
                }
                if (pkg.getLongVersionCode() < minVersionCode || pkg.getLongVersionCode() > maxVersionCode) {
                    throw new PackageManagerException("Static shared lib version codes must be ordered as lib versions");
                }
            }
            if (pkg.childPackages != null && !pkg.childPackages.isEmpty()) {
                if ((scanFlags & 0x40000) == 0) {
                    throw new PackageManagerException("Only privileged apps can add child packages. Ignoring package " + pkg.packageName);
                }
                int childCount = pkg.childPackages.size();
                for (int i = 0; i < childCount; ++i) {
                    PackageParser.Package childPkg = pkg.childPackages.get(i);
                    if (!this.mSettings.hasOtherDisabledSystemPkgWithChildLPr(pkg.packageName, childPkg.packageName)) continue;
                    throw new PackageManagerException("Can't override child of another disabled app. Ignoring package " + pkg.packageName);
                }
            }
            if ((scanFlags & 0x80) != 0) {
                if (this.mExpectingBetter.containsKey(pkg.packageName)) {
                    PackageManagerServiceUtils.logCriticalInfo(5, "Relax SCAN_REQUIRE_KNOWN requirement for package " + pkg.packageName);
                } else {
                    PackageSetting known = this.mSettings.getPackageLPr(pkg.packageName);
                    if (known != null) {
                        if (!pkg.applicationInfo.getCodePath().equals(known.codePathString) || !pkg.applicationInfo.getResourcePath().equals(known.resourcePathString)) {
                            throw new PackageManagerException(-23, "Application package " + pkg.packageName + " found at " + pkg.applicationInfo.getCodePath() + " but expected at " + known.codePathString + "; ignoring.");
                        }
                    } else {
                        throw new PackageManagerException(-19, "Application package " + pkg.packageName + " not found; ignoring.");
                    }
                }
            }
            if ((scanFlags & 4) != 0) {
                this.mComponentResolver.assertProvidersNotDefined(pkg);
            }
            if (!pkg.isPrivileged() && pkg.mSharedUserId != null) {
                SharedUserSetting sharedUserSetting = null;
                try {
                    sharedUserSetting = this.mSettings.getSharedUserLPw(pkg.mSharedUserId, 0, 0, false);
                }
                catch (PackageManagerException i) {
                    // empty catch block
                }
                if (sharedUserSetting != null && sharedUserSetting.isPrivileged()) {
                    PackageSetting platformPkgSetting = this.mSettings.mPackages.get(PLATFORM_PACKAGE_NAME);
                    if (platformPkgSetting.signatures.mSigningDetails != PackageParser.SigningDetails.UNKNOWN && PackageManagerServiceUtils.compareSignatures(platformPkgSetting.signatures.mSigningDetails.signatures, pkg.mSigningDetails.signatures) != 0) {
                        throw new PackageManagerException("Apps that share a user with a privileged app must themselves be marked as privileged. " + pkg.packageName + " shares privileged user " + pkg.mSharedUserId + ".");
                    }
                }
            }
            if (pkg.mOverlayTarget != null) {
                if ((scanFlags & 0x20000) != 0) {
                    if ((parseFlags & 0x10) == 0) {
                        PackageSetting previousPkg = PackageManagerService.assertNotNull(this.mSettings.getPackageLPr(pkg.packageName), "previous package state not present");
                        PackageParser.Package ppkg = previousPkg.pkg;
                        if (ppkg == null) {
                            try {
                                PackageParser pp = new PackageParser();
                                ppkg = pp.parsePackage(previousPkg.codePath, parseFlags | 0x10);
                            }
                            catch (PackageParser.PackageParserException e) {
                                Slog.w(TAG, "failed to parse " + previousPkg.codePath, e);
                            }
                        }
                        if (ppkg != null && ppkg.mOverlayIsStatic) {
                            throw new PackageManagerException("Overlay " + pkg.packageName + " is static and cannot be upgraded.");
                        }
                        if (pkg.mOverlayIsStatic) {
                            throw new PackageManagerException("Overlay " + pkg.packageName + " cannot be upgraded into a static overlay.");
                        }
                    }
                } else {
                    PackageSetting targetPkgSetting;
                    if (pkg.mOverlayIsStatic) {
                        throw new PackageManagerException("Overlay " + pkg.packageName + " is static but not pre-installed.");
                    }
                    if (pkg.applicationInfo.targetSdkVersion < 29) {
                        PackageSetting platformPkgSetting = this.mSettings.getPackageLPr(PLATFORM_PACKAGE_NAME);
                        if (platformPkgSetting.signatures.mSigningDetails != PackageParser.SigningDetails.UNKNOWN && PackageManagerServiceUtils.compareSignatures(platformPkgSetting.signatures.mSigningDetails.signatures, pkg.mSigningDetails.signatures) != 0) {
                            throw new PackageManagerException("Overlay " + pkg.packageName + " must target Q or later, or be signed with the platform certificate");
                        }
                    }
                    if (pkg.mOverlayTargetName == null && (targetPkgSetting = this.mSettings.getPackageLPr(pkg.mOverlayTarget)) != null && targetPkgSetting.signatures.mSigningDetails != PackageParser.SigningDetails.UNKNOWN && PackageManagerServiceUtils.compareSignatures(targetPkgSetting.signatures.mSigningDetails.signatures, pkg.mSigningDetails.signatures) != 0) {
                        throw new PackageManagerException("Overlay " + pkg.packageName + " and target " + pkg.mOverlayTarget + " signed with different certificates, and the overlay lacks <overlay android:targetName>");
                    }
                }
            }
        }
    }

    @GuardedBy(value={"mPackages"})
    private boolean addBuiltInSharedLibraryLocked(String path, String name) {
        if (this.nonStaticSharedLibExistsLocked(name)) {
            return false;
        }
        SharedLibraryInfo libraryInfo = new SharedLibraryInfo(path, null, null, name, -1L, 0, new VersionedPackage(PLATFORM_PACKAGE_NAME, 0L), null, null);
        this.commitSharedLibraryInfoLocked(libraryInfo);
        return true;
    }

    @GuardedBy(value={"mPackages"})
    private boolean nonStaticSharedLibExistsLocked(String name) {
        return PackageManagerService.sharedLibExists(name, -1L, this.mSharedLibraries);
    }

    private static boolean sharedLibExists(String name, long version, Map<String, LongSparseArray<SharedLibraryInfo>> librarySource) {
        LongSparseArray<SharedLibraryInfo> versionedLib = librarySource.get(name);
        return versionedLib != null && versionedLib.indexOfKey(version) >= 0;
    }

    @GuardedBy(value={"mPackages"})
    private void commitSharedLibraryInfoLocked(SharedLibraryInfo libraryInfo) {
        String name = libraryInfo.getName();
        LongSparseArray<SharedLibraryInfo> versionedLib = this.mSharedLibraries.get(name);
        if (versionedLib == null) {
            versionedLib = new LongSparseArray();
            this.mSharedLibraries.put(name, versionedLib);
        }
        String declaringPackageName = libraryInfo.getDeclaringPackage().getPackageName();
        if (libraryInfo.getType() == 2) {
            this.mStaticLibsByDeclaringPackage.put(declaringPackageName, versionedLib);
        }
        versionedLib.put(libraryInfo.getLongVersion(), libraryInfo);
    }

    private boolean removeSharedLibraryLPw(String name, long version) {
        LongSparseArray<SharedLibraryInfo> versionedLib = this.mSharedLibraries.get(name);
        if (versionedLib == null) {
            return false;
        }
        int libIdx = versionedLib.indexOfKey(version);
        if (libIdx < 0) {
            return false;
        }
        SharedLibraryInfo libraryInfo = versionedLib.valueAt(libIdx);
        versionedLib.remove(version);
        if (versionedLib.size() <= 0) {
            this.mSharedLibraries.remove(name);
            if (libraryInfo.getType() == 2) {
                this.mStaticLibsByDeclaringPackage.remove(libraryInfo.getDeclaringPackage().getPackageName());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPackageSettings(PackageParser.Package pkg, PackageParser.Package oldPkg, PackageSetting pkgSetting, int scanFlags, boolean chatty, ReconciledPackage reconciledPkg) {
        String pkgName = pkg.packageName;
        if (this.mCustomResolverComponentName != null && this.mCustomResolverComponentName.getPackageName().equals(pkg.packageName)) {
            this.setUpCustomResolverActivity(pkg);
        }
        if (pkg.packageName.equals(PLATFORM_PACKAGE_NAME)) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                if ((scanFlags & 0x400) == 0) {
                    this.mPlatformPackage = pkg;
                    pkg.mVersionCode = this.mSdkVersion;
                    pkg.mVersionCodeMajor = 0;
                    this.mAndroidApplication = pkg.applicationInfo;
                    if (!this.mResolverReplaced) {
                        this.mResolveActivity.applicationInfo = this.mAndroidApplication;
                        this.mResolveActivity.name = ResolverActivity.class.getName();
                        this.mResolveActivity.packageName = this.mAndroidApplication.packageName;
                        this.mResolveActivity.processName = "system:ui";
                        this.mResolveActivity.launchMode = 0;
                        this.mResolveActivity.documentLaunchMode = 3;
                        this.mResolveActivity.flags = 32;
                        this.mResolveActivity.theme = 16974374;
                        this.mResolveActivity.exported = true;
                        this.mResolveActivity.enabled = true;
                        this.mResolveActivity.resizeMode = 2;
                        this.mResolveActivity.configChanges = 3504;
                        this.mResolveInfo.activityInfo = this.mResolveActivity;
                        this.mResolveInfo.priority = 0;
                        this.mResolveInfo.preferredOrder = 0;
                        this.mResolveInfo.match = 0;
                        this.mResolveComponentName = new ComponentName(this.mAndroidApplication.packageName, this.mResolveActivity.name);
                    }
                }
            }
        }
        ArrayList<PackageParser.Package> clientLibPkgs = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (!ArrayUtils.isEmpty(reconciledPkg.allowedSharedLibraryInfos)) {
                for (SharedLibraryInfo info : reconciledPkg.allowedSharedLibraryInfos) {
                    this.commitSharedLibraryInfoLocked(info);
                }
                Map combinedPackages = reconciledPkg.getCombinedPackages();
                try {
                    this.updateSharedLibrariesLocked(pkg, null, combinedPackages);
                }
                catch (PackageManagerException e) {
                    Slog.e(TAG, "updateSharedLibrariesLPr failed: ", e);
                }
                if ((scanFlags & 0x10) == 0) {
                    clientLibPkgs = this.updateAllSharedLibrariesLocked(pkg, combinedPackages);
                }
            }
        }
        if ((scanFlags & 0x10) == 0 && (scanFlags & 0x800) == 0 && (scanFlags & 0x1000) == 0) {
            this.checkPackageFrozen(pkgName);
        }
        if (clientLibPkgs != null) {
            for (int i = 0; i < clientLibPkgs.size(); ++i) {
                PackageParser.Package clientPkg = (PackageParser.Package)clientLibPkgs.get(i);
                this.killApplication(clientPkg.applicationInfo.packageName, clientPkg.applicationInfo.uid, "update lib");
            }
        }
        Trace.traceBegin(262144L, "updateSettings");
        ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
        synchronized (arrayMap2) {
            Object a;
            int i;
            this.mSettings.insertPackageSettingLPw(pkgSetting, pkg);
            this.mPackages.put(pkg.applicationInfo.packageName, pkg);
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            ksms.addScannedPackageLPw(pkg);
            this.mComponentResolver.addAllComponents(pkg, chatty);
            if ((scanFlags & 0x4000) != 0) {
                Slog.w(TAG, "Permission groups from package " + pkg.packageName + " ignored: instant apps cannot define new permission groups.");
            } else {
                this.mPermissionManager.addAllPermissionGroups(pkg, chatty);
            }
            if ((scanFlags & 0x4000) != 0) {
                Slog.w(TAG, "Permissions from package " + pkg.packageName + " ignored: instant apps cannot define new permissions.");
            } else {
                this.mPermissionManager.addAllPermissions(pkg, chatty);
            }
            int collectionSize = pkg.instrumentation.size();
            StringBuilder r = null;
            for (i = 0; i < collectionSize; ++i) {
                a = pkg.instrumentation.get(i);
                ((PackageParser.Instrumentation)a).info.packageName = pkg.applicationInfo.packageName;
                ((PackageParser.Instrumentation)a).info.sourceDir = pkg.applicationInfo.sourceDir;
                ((PackageParser.Instrumentation)a).info.publicSourceDir = pkg.applicationInfo.publicSourceDir;
                ((PackageParser.Instrumentation)a).info.splitNames = pkg.splitNames;
                ((PackageParser.Instrumentation)a).info.splitSourceDirs = pkg.applicationInfo.splitSourceDirs;
                ((PackageParser.Instrumentation)a).info.splitPublicSourceDirs = pkg.applicationInfo.splitPublicSourceDirs;
                ((PackageParser.Instrumentation)a).info.splitDependencies = pkg.applicationInfo.splitDependencies;
                ((PackageParser.Instrumentation)a).info.dataDir = pkg.applicationInfo.dataDir;
                ((PackageParser.Instrumentation)a).info.deviceProtectedDataDir = pkg.applicationInfo.deviceProtectedDataDir;
                ((PackageParser.Instrumentation)a).info.credentialProtectedDataDir = pkg.applicationInfo.credentialProtectedDataDir;
                ((PackageParser.Instrumentation)a).info.primaryCpuAbi = pkg.applicationInfo.primaryCpuAbi;
                ((PackageParser.Instrumentation)a).info.secondaryCpuAbi = pkg.applicationInfo.secondaryCpuAbi;
                ((PackageParser.Instrumentation)a).info.nativeLibraryDir = pkg.applicationInfo.nativeLibraryDir;
                ((PackageParser.Instrumentation)a).info.secondaryNativeLibraryDir = pkg.applicationInfo.secondaryNativeLibraryDir;
                this.mInstrumentation.put(((PackageParser.Component)a).getComponentName(), (PackageParser.Instrumentation)a);
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(((PackageParser.Instrumentation)a).info.name);
            }
            if (r != null) {
                // empty if block
            }
            if (pkg.protectedBroadcasts != null) {
                collectionSize = pkg.protectedBroadcasts.size();
                a = this.mProtectedBroadcasts;
                synchronized (a) {
                    for (i = 0; i < collectionSize; ++i) {
                        this.mProtectedBroadcasts.add(pkg.protectedBroadcasts.get(i));
                    }
                }
            }
            if (oldPkg != null) {
                ArrayList<String> allPackageNames = new ArrayList<String>(this.mPackages.keySet());
                AsyncTask.execute(() -> this.mPermissionManager.revokeRuntimePermissionsIfGroupChanged(pkg, oldPkg, allPackageNames, this.mPermissionCallback));
            }
        }
        Trace.traceEnd(262144L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void derivePackageAbi(PackageParser.Package pkg, String cpuAbiOverride, boolean extractLibs) throws PackageManagerException {
        PackageManagerService.setNativeLibraryPaths(pkg, sAppLib32InstallDir);
        if (PackageManagerService.isSystemApp(pkg) && !pkg.isUpdatedSystemApp()) {
            extractLibs = false;
        }
        String nativeLibraryRootStr = pkg.applicationInfo.nativeLibraryRootDir;
        boolean useIsaSpecificSubdirs = pkg.applicationInfo.nativeLibraryRootRequiresIsa;
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = NativeLibraryHelper.Handle.create(pkg);
            File nativeLibraryRoot = new File(nativeLibraryRootStr);
            pkg.applicationInfo.primaryCpuAbi = null;
            pkg.applicationInfo.secondaryCpuAbi = null;
            if (PackageManagerService.isMultiArch(pkg.applicationInfo)) {
                if (pkg.cpuAbiOverride != null && !"-".equals(pkg.cpuAbiOverride)) {
                    Slog.w(TAG, "Ignoring abiOverride for multi arch application.");
                }
                int abi32 = -114;
                int abi64 = -114;
                if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
                    if (extractLibs) {
                        Trace.traceBegin(262144L, "copyNativeBinaries");
                        abi32 = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, Build.SUPPORTED_32_BIT_ABIS, useIsaSpecificSubdirs);
                    } else {
                        Trace.traceBegin(262144L, "findSupportedAbi");
                        abi32 = NativeLibraryHelper.findSupportedAbi(handle, Build.SUPPORTED_32_BIT_ABIS);
                    }
                    Trace.traceEnd(262144L);
                }
                if (abi32 >= 0 && pkg.isLibrary() && extractLibs) {
                    throw new PackageManagerException(-110, "Shared library native lib extraction not supported");
                }
                PackageManagerService.maybeThrowExceptionForMultiArchCopy("Error unpackaging 32 bit native libs for multiarch app.", abi32);
                if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
                    if (extractLibs) {
                        Trace.traceBegin(262144L, "copyNativeBinaries");
                        abi64 = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, Build.SUPPORTED_64_BIT_ABIS, useIsaSpecificSubdirs);
                    } else {
                        Trace.traceBegin(262144L, "findSupportedAbi");
                        abi64 = NativeLibraryHelper.findSupportedAbi(handle, Build.SUPPORTED_64_BIT_ABIS);
                    }
                    Trace.traceEnd(262144L);
                }
                PackageManagerService.maybeThrowExceptionForMultiArchCopy("Error unpackaging 64 bit native libs for multiarch app.", abi64);
                if (abi64 >= 0) {
                    if (extractLibs && pkg.isLibrary()) {
                        throw new PackageManagerException(-110, "Shared library native lib extraction not supported");
                    }
                    pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[abi64];
                }
                if (abi32 >= 0) {
                    String abi = Build.SUPPORTED_32_BIT_ABIS[abi32];
                    if (abi64 >= 0) {
                        if (pkg.use32bitAbi) {
                            pkg.applicationInfo.secondaryCpuAbi = pkg.applicationInfo.primaryCpuAbi;
                            pkg.applicationInfo.primaryCpuAbi = abi;
                        } else {
                            pkg.applicationInfo.secondaryCpuAbi = abi;
                        }
                    } else {
                        pkg.applicationInfo.primaryCpuAbi = abi;
                    }
                }
            } else {
                int copyRet;
                String[] stringArray;
                if (cpuAbiOverride != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = cpuAbiOverride;
                } else {
                    stringArray = Build.SUPPORTED_ABIS;
                }
                String[] abiList = stringArray;
                boolean needsRenderScriptOverride = false;
                if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && cpuAbiOverride == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                    abiList = Build.SUPPORTED_32_BIT_ABIS;
                    needsRenderScriptOverride = true;
                }
                if (extractLibs) {
                    Trace.traceBegin(262144L, "copyNativeBinaries");
                    copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, abiList, useIsaSpecificSubdirs);
                } else {
                    Trace.traceBegin(262144L, "findSupportedAbi");
                    copyRet = NativeLibraryHelper.findSupportedAbi(handle, abiList);
                }
                Trace.traceEnd(262144L);
                if (copyRet < 0 && copyRet != -114) {
                    throw new PackageManagerException(-110, "Error unpackaging native libs for app, errorCode=" + copyRet);
                }
                if (copyRet >= 0) {
                    if (pkg.isLibrary()) {
                        throw new PackageManagerException(-110, "Shared library with native libs must be multiarch");
                    }
                    pkg.applicationInfo.primaryCpuAbi = abiList[copyRet];
                } else if (copyRet == -114 && cpuAbiOverride != null) {
                    pkg.applicationInfo.primaryCpuAbi = cpuAbiOverride;
                } else if (needsRenderScriptOverride) {
                    pkg.applicationInfo.primaryCpuAbi = abiList[0];
                }
            }
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Unable to get canonical file " + ioe.toString());
        }
        finally {
            IoUtils.closeQuietly(handle);
        }
        PackageManagerService.setNativeLibraryPaths(pkg, sAppLib32InstallDir);
    }

    private static List<String> adjustCpuAbisForSharedUserLPw(Set<PackageSetting> packagesForUser, PackageParser.Package scannedPackage) {
        ArrayList<String> changedAbiCodePath = null;
        String requiredInstructionSet = null;
        if (scannedPackage != null && scannedPackage.applicationInfo.primaryCpuAbi != null) {
            requiredInstructionSet = VMRuntime.getInstructionSet(scannedPackage.applicationInfo.primaryCpuAbi);
        }
        PackageSetting requirer = null;
        for (PackageSetting ps : packagesForUser) {
            if (scannedPackage != null && scannedPackage.packageName.equals(ps.name) || ps.primaryCpuAbiString == null) continue;
            String instructionSet = VMRuntime.getInstructionSet(ps.primaryCpuAbiString);
            if (requiredInstructionSet != null && !instructionSet.equals(requiredInstructionSet)) {
                String errorMessage = "Instruction set mismatch, " + (requirer == null ? "[caller]" : requirer) + " requires " + requiredInstructionSet + " whereas " + ps + " requires " + instructionSet;
                Slog.w(TAG, errorMessage);
            }
            if (requiredInstructionSet != null) continue;
            requiredInstructionSet = instructionSet;
            requirer = ps;
        }
        if (requiredInstructionSet != null) {
            String adjustedAbi;
            if (requirer != null) {
                adjustedAbi = requirer.primaryCpuAbiString;
                if (scannedPackage != null) {
                    scannedPackage.applicationInfo.primaryCpuAbi = adjustedAbi;
                }
            } else {
                adjustedAbi = scannedPackage.applicationInfo.primaryCpuAbi;
            }
            for (PackageSetting ps : packagesForUser) {
                if (scannedPackage != null && scannedPackage.packageName.equals(ps.name) || ps.primaryCpuAbiString != null) continue;
                ps.primaryCpuAbiString = adjustedAbi;
                if (ps.pkg == null || ps.pkg.applicationInfo == null || TextUtils.equals(adjustedAbi, ps.pkg.applicationInfo.primaryCpuAbi)) continue;
                ps.pkg.applicationInfo.primaryCpuAbi = adjustedAbi;
                if (changedAbiCodePath == null) {
                    changedAbiCodePath = new ArrayList<String>();
                }
                changedAbiCodePath.add(ps.codePathString);
            }
        }
        return changedAbiCodePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpCustomResolverActivity(PackageParser.Package pkg) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mResolverReplaced = true;
            this.mResolveActivity.applicationInfo = pkg.applicationInfo;
            this.mResolveActivity.name = this.mCustomResolverComponentName.getClassName();
            this.mResolveActivity.packageName = pkg.applicationInfo.packageName;
            this.mResolveActivity.processName = pkg.applicationInfo.packageName;
            this.mResolveActivity.launchMode = 0;
            this.mResolveActivity.flags = 288;
            this.mResolveActivity.theme = 0;
            this.mResolveActivity.exported = true;
            this.mResolveActivity.enabled = true;
            this.mResolveInfo.activityInfo = this.mResolveActivity;
            this.mResolveInfo.priority = 0;
            this.mResolveInfo.preferredOrder = 0;
            this.mResolveInfo.match = 0;
            this.mResolveComponentName = this.mCustomResolverComponentName;
            Slog.i(TAG, "Replacing default ResolverActivity with custom activity: " + this.mResolveComponentName);
        }
    }

    private void setUpInstantAppInstallerActivityLP(ActivityInfo installerActivity) {
        if (installerActivity == null) {
            if (DEBUG_INSTANT) {
                Slog.d(TAG, "Clear ephemeral installer activity");
            }
            this.mInstantAppInstallerActivity = null;
            return;
        }
        if (DEBUG_INSTANT) {
            Slog.d(TAG, "Set ephemeral installer activity: " + installerActivity.getComponentName());
        }
        this.mInstantAppInstallerActivity = installerActivity;
        this.mInstantAppInstallerActivity.flags |= 0x120;
        this.mInstantAppInstallerActivity.exported = true;
        this.mInstantAppInstallerActivity.enabled = true;
        this.mInstantAppInstallerInfo.activityInfo = this.mInstantAppInstallerActivity;
        this.mInstantAppInstallerInfo.priority = 1;
        this.mInstantAppInstallerInfo.preferredOrder = 1;
        this.mInstantAppInstallerInfo.isDefault = true;
        this.mInstantAppInstallerInfo.match = 0x588000;
    }

    private static String calculateBundledApkRoot(String codePathString) {
        File codeRoot;
        File codePath = new File(codePathString);
        if (FileUtils.contains(Environment.getRootDirectory(), codePath)) {
            codeRoot = Environment.getRootDirectory();
        } else if (FileUtils.contains(Environment.getOemDirectory(), codePath)) {
            codeRoot = Environment.getOemDirectory();
        } else if (FileUtils.contains(Environment.getVendorDirectory(), codePath)) {
            codeRoot = Environment.getVendorDirectory();
        } else if (FileUtils.contains(Environment.getOdmDirectory(), codePath)) {
            codeRoot = Environment.getOdmDirectory();
        } else if (FileUtils.contains(Environment.getProductDirectory(), codePath)) {
            codeRoot = Environment.getProductDirectory();
        } else if (FileUtils.contains(Environment.getProductServicesDirectory(), codePath)) {
            codeRoot = Environment.getProductServicesDirectory();
        } else if (FileUtils.contains(Environment.getOdmDirectory(), codePath)) {
            codeRoot = Environment.getOdmDirectory();
        } else {
            try {
                File tmp;
                File f = codePath.getCanonicalFile();
                File parent = f.getParentFile();
                while ((tmp = parent.getParentFile()) != null) {
                    f = parent;
                    parent = tmp;
                }
                codeRoot = f;
                Slog.w(TAG, "Unrecognized code path " + codePath + " - using " + codeRoot);
            }
            catch (IOException e) {
                Slog.w(TAG, "Can't canonicalize code path " + codePath);
                return Environment.getRootDirectory().getPath();
            }
        }
        return codeRoot.getPath();
    }

    private static void setNativeLibraryPaths(PackageParser.Package pkg, File appLib32InstallDir) {
        ApplicationInfo info = pkg.applicationInfo;
        String codePath = pkg.codePath;
        File codeFile = new File(codePath);
        boolean bundledApp = info.isSystemApp() && !info.isUpdatedSystemApp();
        info.nativeLibraryRootDir = null;
        info.nativeLibraryRootRequiresIsa = false;
        info.nativeLibraryDir = null;
        info.secondaryNativeLibraryDir = null;
        if (PackageParser.isApkFile(codeFile)) {
            if (bundledApp) {
                String apkRoot = PackageManagerService.calculateBundledApkRoot(info.sourceDir);
                boolean is64Bit = VMRuntime.is64BitInstructionSet(InstructionSets.getPrimaryInstructionSet(info));
                String apkName = PackageManagerService.deriveCodePathName(codePath);
                String libDir = is64Bit ? "lib64" : "lib";
                info.nativeLibraryRootDir = Environment.buildPath(new File(apkRoot), libDir, apkName).getAbsolutePath();
                if (info.secondaryCpuAbi != null) {
                    String secondaryLibDir = is64Bit ? "lib" : "lib64";
                    info.secondaryNativeLibraryDir = Environment.buildPath(new File(apkRoot), secondaryLibDir, apkName).getAbsolutePath();
                }
            } else {
                String apkName = PackageManagerService.deriveCodePathName(codePath);
                info.nativeLibraryRootDir = new File(appLib32InstallDir, apkName).getAbsolutePath();
            }
            info.nativeLibraryRootRequiresIsa = false;
            info.nativeLibraryDir = info.nativeLibraryRootDir;
        } else {
            info.nativeLibraryRootDir = new File(codeFile, "lib").getAbsolutePath();
            info.nativeLibraryRootRequiresIsa = true;
            info.nativeLibraryDir = new File(info.nativeLibraryRootDir, InstructionSets.getPrimaryInstructionSet(info)).getAbsolutePath();
            if (info.secondaryCpuAbi != null) {
                info.secondaryNativeLibraryDir = new File(info.nativeLibraryRootDir, VMRuntime.getInstructionSet(info.secondaryCpuAbi)).getAbsolutePath();
            }
        }
    }

    private static void setBundledAppAbisAndRoots(PackageParser.Package pkg, PackageSetting pkgSetting) {
        String apkName = PackageManagerService.deriveCodePathName(pkg.applicationInfo.getCodePath());
        String apkRoot = PackageManagerService.calculateBundledApkRoot(pkg.applicationInfo.sourceDir);
        PackageManagerService.setBundledAppAbi(pkg, apkRoot, apkName);
        if (pkgSetting != null) {
            pkgSetting.primaryCpuAbiString = pkg.applicationInfo.primaryCpuAbi;
            pkgSetting.secondaryCpuAbiString = pkg.applicationInfo.secondaryCpuAbi;
        }
    }

    private static void setBundledAppAbi(PackageParser.Package pkg, String apkRoot, String apkName) {
        boolean has32BitLibs;
        boolean has64BitLibs;
        File codeFile = new File(pkg.codePath);
        if (PackageParser.isApkFile(codeFile)) {
            has64BitLibs = new File(apkRoot, new File("lib64", apkName).getPath()).exists();
            has32BitLibs = new File(apkRoot, new File("lib", apkName).getPath()).exists();
        } else {
            String isa;
            File rootDir = new File(codeFile, "lib");
            if (!ArrayUtils.isEmpty(Build.SUPPORTED_64_BIT_ABIS) && !TextUtils.isEmpty(Build.SUPPORTED_64_BIT_ABIS[0])) {
                isa = VMRuntime.getInstructionSet(Build.SUPPORTED_64_BIT_ABIS[0]);
                has64BitLibs = new File(rootDir, isa).exists();
            } else {
                has64BitLibs = false;
            }
            if (!ArrayUtils.isEmpty(Build.SUPPORTED_32_BIT_ABIS) && !TextUtils.isEmpty(Build.SUPPORTED_32_BIT_ABIS[0])) {
                isa = VMRuntime.getInstructionSet(Build.SUPPORTED_32_BIT_ABIS[0]);
                has32BitLibs = new File(rootDir, isa).exists();
            } else {
                has32BitLibs = false;
            }
        }
        if (has64BitLibs && !has32BitLibs) {
            pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
            pkg.applicationInfo.secondaryCpuAbi = null;
        } else if (has32BitLibs && !has64BitLibs) {
            pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
            pkg.applicationInfo.secondaryCpuAbi = null;
        } else if (has32BitLibs && has64BitLibs) {
            if ((pkg.applicationInfo.flags & Integer.MIN_VALUE) == 0) {
                Slog.e(TAG, "Package " + pkg + " has multiple bundled libs, but is not multiarch.");
            }
            if (VMRuntime.is64BitInstructionSet(InstructionSets.getPreferredInstructionSet())) {
                pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
                pkg.applicationInfo.secondaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
            } else {
                pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
                pkg.applicationInfo.secondaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
            }
        } else {
            pkg.applicationInfo.primaryCpuAbi = null;
            pkg.applicationInfo.secondaryCpuAbi = null;
        }
    }

    private void killApplication(String pkgName, int appId, String reason) {
        this.killApplication(pkgName, appId, -1, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killApplication(String pkgName, int appId, int userId, String reason) {
        long token = Binder.clearCallingIdentity();
        try {
            IActivityManager am = ActivityManager.getService();
            if (am != null) {
                try {
                    am.killApplication(pkgName, appId, userId, reason);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void removePackageLI(PackageParser.Package pkg, boolean chatty) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps != null) {
            this.removePackageLI(ps.name, chatty);
        }
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            ps = (PackageSetting)childPkg.mExtras;
            if (ps == null) continue;
            this.removePackageLI(ps.name, chatty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePackageLI(String packageName, boolean chatty) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package removedPackage = this.mPackages.remove(packageName);
            if (removedPackage != null) {
                this.cleanPackageDataStructuresLILPw(removedPackage, chatty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInstalledPackageLI(PackageParser.Package pkg, boolean chatty) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mPackages.remove(pkg.applicationInfo.packageName);
            this.cleanPackageDataStructuresLILPw(pkg, chatty);
            int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                PackageParser.Package childPkg = pkg.childPackages.get(i);
                this.mPackages.remove(childPkg.applicationInfo.packageName);
                this.cleanPackageDataStructuresLILPw(childPkg, chatty);
            }
        }
    }

    void cleanPackageDataStructuresLILPw(PackageParser.Package pkg, boolean chatty) {
        int i;
        this.mComponentResolver.removeAllComponents(pkg, chatty);
        this.mPermissionManager.removeAllPermissions(pkg, chatty);
        int instrumentationSize = pkg.instrumentation.size();
        Object r = null;
        for (i = 0; i < instrumentationSize; ++i) {
            PackageParser.Instrumentation a = pkg.instrumentation.get(i);
            this.mInstrumentation.remove(a.getComponentName());
        }
        if (r != null) {
            // empty if block
        }
        r = null;
        if ((pkg.applicationInfo.flags & 1) != 0 && pkg.libraryNames != null) {
            int libraryNamesSize = pkg.libraryNames.size();
            for (i = 0; i < libraryNamesSize; ++i) {
                String name = pkg.libraryNames.get(i);
                if (!this.removeSharedLibraryLPw(name, 0L)) continue;
            }
        }
        r = null;
        if (pkg.staticSharedLibName == null || this.removeSharedLibraryLPw(pkg.staticSharedLibName, pkg.staticSharedLibVersion)) {
            // empty if block
        }
        if (r != null) {
            // empty if block
        }
    }

    @Override
    public void sendPackageBroadcast(String action, String pkg, Bundle extras, int flags, String targetPkg, IIntentReceiver finishedReceiver, int[] userIds, int[] instantUserIds) {
        this.mHandler.post(() -> {
            try {
                IActivityManager am = ActivityManager.getService();
                if (am == null) {
                    return;
                }
                int[] resolvedUserIds = userIds == null ? am.getRunningUserIds() : userIds;
                this.doSendBroadcast(am, action, pkg, extras, flags, targetPkg, finishedReceiver, resolvedUserIds, false);
                if (instantUserIds != null && instantUserIds != EMPTY_INT_ARRAY) {
                    this.doSendBroadcast(am, action, pkg, extras, flags, targetPkg, finishedReceiver, instantUserIds, true);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPackageAdded(String packageName, int uid) {
        PackageManagerInternal.PackageListObserver[] observers;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mPackageListObservers.size() == 0) {
                return;
            }
            PackageManagerInternal.PackageListObserver[] observerArray = new PackageManagerInternal.PackageListObserver[this.mPackageListObservers.size()];
            observers = this.mPackageListObservers.toArray(observerArray);
        }
        for (int i = observers.length - 1; i >= 0; --i) {
            observers[i].onPackageAdded(packageName, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPackageChanged(String packageName, int uid) {
        PackageManagerInternal.PackageListObserver[] observers;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mPackageListObservers.size() == 0) {
                return;
            }
            PackageManagerInternal.PackageListObserver[] observerArray = new PackageManagerInternal.PackageListObserver[this.mPackageListObservers.size()];
            observers = this.mPackageListObservers.toArray(observerArray);
        }
        for (int i = observers.length - 1; i >= 0; --i) {
            observers[i].onPackageChanged(packageName, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPackageRemoved(String packageName, int uid) {
        PackageManagerInternal.PackageListObserver[] observers;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mPackageListObservers.size() == 0) {
                return;
            }
            PackageManagerInternal.PackageListObserver[] observerArray = new PackageManagerInternal.PackageListObserver[this.mPackageListObservers.size()];
            observers = this.mPackageListObservers.toArray(observerArray);
        }
        for (int i = observers.length - 1; i >= 0; --i) {
            observers[i].onPackageRemoved(packageName, uid);
        }
    }

    private void doSendBroadcast(IActivityManager am, String action, String pkg, Bundle extras, int flags, String targetPkg, IIntentReceiver finishedReceiver, int[] userIds, boolean isInstantApp) throws RemoteException {
        for (int id2 : userIds) {
            int uid;
            String[] requiredPermissions;
            Intent intent = new Intent(action, pkg != null ? Uri.fromParts(PACKAGE_SCHEME, pkg, null) : null);
            Object object = requiredPermissions = isInstantApp ? INSTANT_APP_BROADCAST_PERMISSION : null;
            if (extras != null) {
                intent.putExtras(extras);
            }
            if (targetPkg != null) {
                intent.setPackage(targetPkg);
            }
            if ((uid = intent.getIntExtra("android.intent.extra.UID", -1)) > 0 && UserHandle.getUserId(uid) != id2) {
                uid = UserHandle.getUid(id2, UserHandle.getAppId(uid));
                intent.putExtra("android.intent.extra.UID", uid);
            }
            intent.putExtra("android.intent.extra.user_handle", id2);
            intent.addFlags(0x4000000 | flags);
            am.broadcastIntent(null, intent, null, finishedReceiver, 0, null, null, requiredPermissions, -1, null, finishedReceiver != null, false, id2);
        }
    }

    private boolean isExternalMediaAvailable() {
        return this.mMediaMounted || Environment.isExternalStorageEmulated();
    }

    private int fixUpInstallReason(String installerPackageName, int installerUid, int installReason) {
        if (this.checkUidPermission("android.permission.INSTALL_PACKAGES", installerUid) == 0) {
            return installReason;
        }
        String ownerPackage = this.mProtectedPackages.getDeviceOwnerOrProfileOwnerPackage(UserHandle.getUserId(installerUid));
        if (ownerPackage != null && ownerPackage.equals(installerPackageName)) {
            return 1;
        }
        if (installReason == 1) {
            return 0;
        }
        return installReason;
    }

    void installStage(ActiveInstallSession activeInstallSession) {
        if (DEBUG_INSTANT && (activeInstallSession.getSessionParams().installFlags & 0x800) != 0) {
            Slog.d(TAG, "Ephemeral install of " + activeInstallSession.getPackageName());
        }
        Message msg = this.mHandler.obtainMessage(5);
        InstallParams params = new InstallParams(activeInstallSession);
        params.setTraceMethod("installStage").setTraceCookie(System.identityHashCode(params));
        msg.obj = params;
        Trace.asyncTraceBegin(262144L, "installStage", System.identityHashCode(msg.obj));
        Trace.asyncTraceBegin(262144L, "queueInstall", System.identityHashCode(msg.obj));
        this.mHandler.sendMessage(msg);
    }

    void installStage(List<ActiveInstallSession> children) throws PackageManagerException {
        Message msg = this.mHandler.obtainMessage(5);
        MultiPackageInstallParams params = new MultiPackageInstallParams(UserHandle.ALL, children);
        params.setTraceMethod("installStageMultiPackage").setTraceCookie(System.identityHashCode(params));
        msg.obj = params;
        Trace.asyncTraceBegin(262144L, "installStageMultiPackage", System.identityHashCode(msg.obj));
        Trace.asyncTraceBegin(262144L, "queueInstall", System.identityHashCode(msg.obj));
        this.mHandler.sendMessage(msg);
    }

    private void sendPackageAddedForUser(String packageName, PackageSetting pkgSetting, int userId) {
        int[] nArray;
        int[] nArray2;
        boolean isSystem = PackageManagerService.isSystemApp(pkgSetting) || PackageManagerService.isUpdatedSystemApp(pkgSetting);
        boolean isInstantApp = pkgSetting.getInstantApp(userId);
        if (isInstantApp) {
            nArray2 = EMPTY_INT_ARRAY;
        } else {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = userId;
        }
        int[] userIds = nArray2;
        if (isInstantApp) {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = userId;
        } else {
            nArray = EMPTY_INT_ARRAY;
        }
        int[] instantUserIds = nArray;
        this.sendPackageAddedForNewUsers(packageName, isSystem, false, pkgSetting.appId, userIds, instantUserIds);
        PackageInstaller.SessionInfo info = new PackageInstaller.SessionInfo();
        info.installReason = pkgSetting.getInstallReason(userId);
        info.appPackageName = packageName;
        this.sendSessionCommitBroadcast(info, userId);
    }

    @Override
    public void sendPackageAddedForNewUsers(String packageName, boolean sendBootCompleted, boolean includeStopped, int appId, int[] userIds, int[] instantUserIds) {
        if (ArrayUtils.isEmpty(userIds) && ArrayUtils.isEmpty(instantUserIds)) {
            return;
        }
        Bundle extras = new Bundle(1);
        int uid = UserHandle.getUid(ArrayUtils.isEmpty(userIds) ? instantUserIds[0] : userIds[0], appId);
        extras.putInt("android.intent.extra.UID", uid);
        this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, 0, null, null, userIds, instantUserIds);
        if (sendBootCompleted && !ArrayUtils.isEmpty(userIds)) {
            this.mHandler.post(() -> {
                for (int userId : userIds) {
                    this.sendBootCompletedBroadcastToSystemApp(packageName, includeStopped, userId);
                }
            });
        }
    }

    private void sendBootCompletedBroadcastToSystemApp(String packageName, boolean includeStopped, int userId) {
        if (!this.mUserManagerInternal.isUserRunning(userId)) {
            return;
        }
        IActivityManager am = ActivityManager.getService();
        try {
            Intent lockedBcIntent = new Intent("android.intent.action.LOCKED_BOOT_COMPLETED").setPackage(packageName);
            if (includeStopped) {
                lockedBcIntent.addFlags(32);
            }
            String[] requiredPermissions = new String[]{"android.permission.RECEIVE_BOOT_COMPLETED"};
            am.broadcastIntent(null, lockedBcIntent, null, null, 0, null, null, requiredPermissions, -1, null, false, false, userId);
            if (this.mUserManagerInternal.isUserUnlockingOrUnlocked(userId)) {
                Intent bcIntent = new Intent("android.intent.action.BOOT_COMPLETED").setPackage(packageName);
                if (includeStopped) {
                    bcIntent.addFlags(32);
                }
                am.broadcastIntent(null, bcIntent, null, null, 0, null, null, requiredPermissions, -1, null, false, false, userId);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, int userId) {
        PackageSetting pkgSetting;
        boolean sendRemoved;
        boolean sendAdded;
        long callingId;
        int callingUid;
        block21: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
            callingUid = Binder.getCallingUid();
            this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, true, "setApplicationHiddenSetting for user " + userId);
            if (hidden && this.isPackageDeviceAdmin(packageName, userId)) {
                Slog.w(TAG, "Not hiding package " + packageName + ": has active device admin");
                return false;
            }
            callingId = Binder.clearCallingIdentity();
            sendAdded = false;
            sendRemoved = false;
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            // MONITORENTER : arrayMap
            pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting != null) break block21;
            boolean bl = false;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        if (this.filterAppAccessLPr(pkgSetting, callingUid, userId)) {
            boolean bl = false;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        if (PLATFORM_PACKAGE_NAME.equals(packageName)) {
            Slog.w(TAG, "Cannot hide package: android");
            boolean bl = false;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        PackageParser.Package pkg = this.mPackages.get(packageName);
        if (pkg != null && pkg.staticSharedLibName != null) {
            Slog.w(TAG, "Cannot hide package: " + packageName + " providing static shared library: " + pkg.staticSharedLibName);
            boolean bl = false;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        if (hidden && !UserHandle.isSameApp(callingUid, pkgSetting.appId) && this.mProtectedPackages.isPackageStateProtected(userId, packageName)) {
            Slog.w(TAG, "Not hiding protected package: " + packageName);
            boolean bl = false;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        try {
            if (pkgSetting.getHidden(userId) != hidden) {
                pkgSetting.setHidden(hidden, userId);
                this.mSettings.writePackageRestrictionsLPr(userId);
                if (hidden) {
                    sendRemoved = true;
                } else {
                    sendAdded = true;
                }
            }
            // MONITOREXIT : arrayMap
            if (sendAdded) {
                this.sendPackageAddedForUser(packageName, pkgSetting, userId);
                boolean bl = true;
                return bl;
            }
            if (!sendRemoved) return false;
            this.killApplication(packageName, UserHandle.getUid(userId, pkgSetting.appId), "hiding pkg");
            this.sendApplicationHiddenForUser(packageName, pkgSetting, userId);
            boolean bl = true;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSystemAppHiddenUntilInstalled(String packageName, boolean hidden) {
        PackageManagerService.enforceSystemOrPhoneCaller("setSystemAppHiddenUntilInstalled");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting disabledPs;
            PackageSetting pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting == null || !pkgSetting.isSystem()) {
                return;
            }
            PackageParser.Package pkg = pkgSetting.pkg;
            if (pkg != null && pkg.applicationInfo != null) {
                pkg.applicationInfo.hiddenUntilInstalled = hidden;
            }
            if ((disabledPs = this.mSettings.getDisabledSystemPkgLPr(packageName)) == null) {
                return;
            }
            pkg = disabledPs.pkg;
            if (pkg != null && pkg.applicationInfo != null) {
                pkg.applicationInfo.hiddenUntilInstalled = hidden;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSystemAppInstallState(String packageName, boolean installed, int userId) {
        PackageManagerService.enforceSystemOrPhoneCaller("setSystemAppInstallState");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting == null || !pkgSetting.isSystem()) {
                return false;
            }
            if (pkgSetting.getInstalled(userId) == installed) {
                return false;
            }
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            if (installed) {
                this.installExistingPackageAsUser(packageName, userId, 0x400000, 3, null);
                boolean bl = true;
                return bl;
            }
            this.deletePackageVersioned(new VersionedPackage(packageName, -1), new PackageManager.LegacyPackageDeleteObserver(null).getBinder(), userId, 4);
            boolean bl = true;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    private void sendApplicationHiddenForUser(String packageName, PackageSetting pkgSetting, int userId) {
        PackageRemovedInfo info = new PackageRemovedInfo(this);
        info.removedPackage = packageName;
        info.installerPackageName = pkgSetting.installerPackageName;
        info.removedUsers = new int[]{userId};
        info.broadcastUsers = new int[]{userId};
        info.uid = UserHandle.getUid(userId, pkgSetting.appId);
        info.sendPackageRemovedBroadcasts(true);
    }

    private void sendDistractingPackagesChanged(String[] pkgList, int[] uidList, int userId, int distractionFlags) {
        Bundle extras = new Bundle(3);
        extras.putStringArray("android.intent.extra.changed_package_list", pkgList);
        extras.putIntArray("android.intent.extra.changed_uid_list", uidList);
        extras.putInt("android.intent.extra.distraction_restrictions", distractionFlags);
        this.sendPackageBroadcast("android.intent.action.DISTRACTING_PACKAGES_CHANGED", null, extras, 0x40000000, null, null, new int[]{userId}, null);
    }

    private void sendPackagesSuspendedForUser(String[] pkgList, int[] uidList, int userId, boolean suspended, PersistableBundle launcherExtras) {
        Bundle extras = new Bundle(3);
        extras.putStringArray("android.intent.extra.changed_package_list", pkgList);
        extras.putIntArray("android.intent.extra.changed_uid_list", uidList);
        if (launcherExtras != null) {
            extras.putBundle("android.intent.extra.LAUNCHER_EXTRAS", new Bundle(launcherExtras.deepCopy()));
        }
        this.sendPackageBroadcast(suspended ? "android.intent.action.PACKAGES_SUSPENDED" : "android.intent.action.PACKAGES_UNSUSPENDED", null, extras, 0x40000000, null, null, new int[]{userId}, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean getApplicationHiddenSettingAsUser(String packageName, int userId) {
        PackageSetting ps;
        long callingId;
        int callingUid;
        block8: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
            callingUid = Binder.getCallingUid();
            this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, false, "getApplicationHidden for user " + userId);
            callingId = Binder.clearCallingIdentity();
            try {
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                // MONITORENTER : arrayMap
                ps = this.mSettings.mPackages.get(packageName);
                if (ps != null) break block8;
                bl = true;
                // MONITOREXIT : arrayMap
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(callingId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        if (this.filterAppAccessLPr(ps, callingUid, userId)) {
            boolean bl = true;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        boolean bl = ps.getHidden(userId);
        // MONITOREXIT : arrayMap
        Binder.restoreCallingIdentity(callingId);
        return bl;
    }

    @Override
    public int installExistingPackageAsUser(String packageName, int userId, int installFlags, int installReason, List<String> whiteListedPermissions) {
        return this.installExistingPackageAsUser(packageName, userId, installFlags, installReason, whiteListedPermissions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int installExistingPackageAsUser(String packageName, int userId, int installFlags, int installReason, List<String> whiteListedPermissions, IntentSender intentSender) {
        block25: {
            callingUid = Binder.getCallingUid();
            if (this.mContext.checkCallingOrSelfPermission("android.permission.INSTALL_PACKAGES") != 0 && this.mContext.checkCallingOrSelfPermission("com.android.permission.INSTALL_EXISTING_PACKAGES") != 0) {
                throw new SecurityException("Neither user " + callingUid + " nor current process has " + "android.permission.INSTALL_PACKAGES" + ".");
            }
            this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, true, "installExistingPackage for user " + userId);
            if (this.isUserRestricted(userId, "no_install_apps")) {
                return -111;
            }
            callingId = Binder.clearCallingIdentity();
            installed = false;
            instantApp = (installFlags & 2048) != 0;
            fullApp = (installFlags & 16384) != 0;
            var14_12 = this.mPackages;
            synchronized (var14_12) {
                pkgSetting = this.mSettings.mPackages.get(packageName);
                if (pkgSetting != null) ** break block23
                var15_14 = -3;
            }
            Binder.restoreCallingIdentity(callingId);
            return var15_14;
            {
                if (this.canViewInstantApps(callingUid, UserHandle.getUserId(callingUid))) ** break block24
                installAllowed = false;
                for (int checkUserId : PackageManagerService.sUserManager.getUserIds()) {
                    v0 = installAllowed = pkgSetting.getInstantApp(checkUserId) == false;
                    if (installAllowed) break;
                }
                if (installAllowed) ** break block24
                var16_18 = -3;
            }
            Binder.restoreCallingIdentity(callingId);
            return var16_18;
            {
                if (!pkgSetting.getInstalled(userId)) {
                    pkgSetting.setInstalled(true, userId);
                    pkgSetting.setHidden(false, userId);
                    pkgSetting.setInstallReason(installReason, userId);
                    this.mSettings.writePackageRestrictionsLPr(userId);
                    this.mSettings.writeKernelMappingLPr(pkgSetting);
                    installed = true;
                } else if (fullApp && pkgSetting.getInstantApp(userId)) {
                    installed = true;
                }
                PackageManagerService.setInstantAppForUser(pkgSetting, userId, instantApp, fullApp);
                // MONITOREXIT @DISABLED, blocks:[3, 4, 7] lbl49 : MonitorExitStatement: MONITOREXIT : var14_12
                {
                    catch (Throwable var20_22) {
                        throw var20_22;
                    }
                }
                if (!installed) break block25;
                if ((installFlags & 0x400000) != 0 && pkgSetting.pkg != null) {
                    whiteListedPermissions = pkgSetting.pkg.requestedPermissions;
                }
                this.setWhitelistedRestrictedPermissions(packageName, whiteListedPermissions, 2, userId);
                if (pkgSetting.pkg != null) {
                    var14_12 = this.mInstallLock;
                    synchronized (var14_12) {
                        this.prepareAppDataAfterInstallLIF(pkgSetting.pkg);
                    }
                }
                this.sendPackageAddedForUser(packageName, pkgSetting, userId);
                var14_12 = this.mPackages;
                synchronized (var14_12) {
                    this.updateSequenceNumberLP(pkgSetting, new int[]{userId});
                }
                res = this.createPackageInstalledInfo(1);
                res.pkg = pkgSetting.pkg;
                res.newUsers = new int[]{userId};
                postInstallData = intentSender == null ? null : new PostInstallData(null, res, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$installExistingPackageAsUser$10(com.android.server.pm.PackageManagerService$PackageInstalledInfo android.content.IntentSender ), ()V)((PackageManagerService)this, (PackageInstalledInfo)res, (IntentSender)intentSender));
                this.restoreAndPostInstall(userId, res, postInstallData);
                break block25;
            }
            {
                finally {
                    Binder.restoreCallingIdentity(callingId);
                }
            }
        }
        return 1;
    }

    static void onRestoreComplete(int returnCode, Context context, IntentSender target) {
        Intent fillIn = new Intent();
        fillIn.putExtra("android.content.pm.extra.STATUS", PackageManager.installStatusToPublicStatus(returnCode));
        try {
            target.sendIntent(context, 0, fillIn, null, null);
        }
        catch (IntentSender.SendIntentException sendIntentException) {
            // empty catch block
        }
    }

    static void setInstantAppForUser(PackageSetting pkgSetting, int userId, boolean instantApp, boolean fullApp) {
        block5: {
            block3: {
                block4: {
                    if (!instantApp && !fullApp) {
                        return;
                    }
                    if (userId == -1) break block3;
                    if (!instantApp || pkgSetting.getInstantApp(userId)) break block4;
                    pkgSetting.setInstantApp(true, userId);
                    break block5;
                }
                if (!fullApp || !pkgSetting.getInstantApp(userId)) break block5;
                pkgSetting.setInstantApp(false, userId);
                break block5;
            }
            for (int currentUserId : sUserManager.getUserIds()) {
                if (instantApp && !pkgSetting.getInstantApp(currentUserId)) {
                    pkgSetting.setInstantApp(true, currentUserId);
                    continue;
                }
                if (!fullApp || !pkgSetting.getInstantApp(currentUserId)) continue;
                pkgSetting.setInstantApp(false, currentUserId);
            }
        }
    }

    boolean isUserRestricted(int userId, String restrictionKey) {
        Bundle restrictions = sUserManager.getUserRestrictions(userId);
        if (restrictions.getBoolean(restrictionKey, false)) {
            Log.w(TAG, "User is restricted: " + restrictionKey);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] setDistractingPackageRestrictionsAsUser(String[] packageNames, int restrictionFlags, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SUSPEND_APPS", "setDistractingPackageRestrictionsAsUser");
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 1000 && UserHandle.getUserId(callingUid) != userId) {
            throw new SecurityException("Calling uid " + callingUid + " cannot call for user " + userId);
        }
        Preconditions.checkNotNull(packageNames, "packageNames cannot be null");
        ArrayList<String> changedPackagesList = new ArrayList<String>(packageNames.length);
        IntArray changedUids = new IntArray(packageNames.length);
        ArrayList<String> unactionedPackages = new ArrayList<String>(packageNames.length);
        boolean[] canRestrict = restrictionFlags != 0 ? this.canSuspendPackageForUserInternal(packageNames, userId) : null;
        for (int i = 0; i < packageNames.length; ++i) {
            PackageSetting pkgSetting;
            String packageName = packageNames[i];
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                pkgSetting = this.mSettings.mPackages.get(packageName);
                if (pkgSetting == null || this.filterAppAccessLPr(pkgSetting, callingUid, userId)) {
                    Slog.w(TAG, "Could not find package setting for package: " + packageName + ". Skipping...");
                    unactionedPackages.add(packageName);
                    continue;
                }
            }
            if (canRestrict != null && !canRestrict[i]) {
                unactionedPackages.add(packageName);
                continue;
            }
            arrayMap = this.mPackages;
            synchronized (arrayMap) {
                int oldDistractionFlags = pkgSetting.getDistractionFlags(userId);
                if (restrictionFlags != oldDistractionFlags) {
                    pkgSetting.setDistractionFlags(restrictionFlags, userId);
                    changedPackagesList.add(packageName);
                    changedUids.add(UserHandle.getUid(userId, pkgSetting.appId));
                }
                continue;
            }
        }
        if (!changedPackagesList.isEmpty()) {
            String[] changedPackages = changedPackagesList.toArray(new String[changedPackagesList.size()]);
            this.sendDistractingPackagesChanged(changedPackages, changedUids.toArray(), userId, restrictionFlags);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
        }
        return unactionedPackages.toArray(new String[0]);
    }

    private void enforceCanSetPackagesSuspendedAsUser(String callingPackage, int callingUid, int userId, String callingMethod) {
        boolean allowedShell;
        if (callingUid == 0 || callingUid == 1000) {
            return;
        }
        String ownerPackage = this.mProtectedPackages.getDeviceOwnerOrProfileOwnerPackage(userId);
        if (ownerPackage != null) {
            int ownerUid = this.getPackageUid(ownerPackage, 0, userId);
            if (ownerUid == callingUid) {
                return;
            }
            throw new UnsupportedOperationException("Cannot suspend/unsuspend packages. User " + userId + " has an active DO or PO");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.SUSPEND_APPS", callingMethod);
        int packageUid = this.getPackageUid(callingPackage, 0, userId);
        boolean allowedPackageUid = packageUid == callingUid;
        boolean bl = allowedShell = callingUid == 2000 && UserHandle.isSameApp(packageUid, callingUid);
        if (!allowedShell && !allowedPackageUid) {
            throw new SecurityException("Calling package " + callingPackage + " in user " + userId + " does not belong to calling uid " + callingUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] setPackagesSuspendedAsUser(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, SuspendDialogInfo dialogInfo, String callingPackage, int userId) {
        int callingUid = Binder.getCallingUid();
        this.enforceCanSetPackagesSuspendedAsUser(callingPackage, callingUid, userId, "setPackagesSuspendedAsUser");
        if (ArrayUtils.isEmpty(packageNames)) {
            return packageNames;
        }
        ArrayList<String> changedPackagesList = new ArrayList<String>(packageNames.length);
        IntArray changedUids = new IntArray(packageNames.length);
        ArrayList<String> unactionedPackages = new ArrayList<String>(packageNames.length);
        boolean[] canSuspend = suspended ? this.canSuspendPackageForUserInternal(packageNames, userId) : null;
        for (int i = 0; i < packageNames.length; ++i) {
            PackageSetting pkgSetting;
            String packageName = packageNames[i];
            if (callingPackage.equals(packageName)) {
                Slog.w(TAG, "Calling package: " + callingPackage + " trying to " + (suspended ? "" : "un") + "suspend itself. Ignoring");
                unactionedPackages.add(packageName);
                continue;
            }
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                pkgSetting = this.mSettings.mPackages.get(packageName);
                if (pkgSetting == null || this.filterAppAccessLPr(pkgSetting, callingUid, userId)) {
                    Slog.w(TAG, "Could not find package setting for package: " + packageName + ". Skipping suspending/un-suspending.");
                    unactionedPackages.add(packageName);
                    continue;
                }
            }
            if (canSuspend != null && !canSuspend[i]) {
                unactionedPackages.add(packageName);
                continue;
            }
            arrayMap = this.mPackages;
            synchronized (arrayMap) {
                pkgSetting.setSuspended(suspended, callingPackage, dialogInfo, appExtras, launcherExtras, userId);
            }
            changedPackagesList.add(packageName);
            changedUids.add(UserHandle.getUid(userId, pkgSetting.appId));
        }
        if (!changedPackagesList.isEmpty()) {
            String[] changedPackages = changedPackagesList.toArray(new String[changedPackagesList.size()]);
            this.sendPackagesSuspendedForUser(changedPackages, changedUids.toArray(), userId, suspended, launcherExtras);
            this.sendMyPackageSuspendedOrUnsuspended(changedPackages, suspended, appExtras, userId);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
        }
        return unactionedPackages.toArray(new String[unactionedPackages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistableBundle getSuspendedPackageAppExtras(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        if (this.getPackageUid(packageName, 0, userId) != callingUid) {
            throw new SecurityException("Calling package " + packageName + " does not belong to calling uid " + callingUid);
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || this.filterAppAccessLPr(ps, callingUid, userId)) {
                throw new IllegalArgumentException("Unknown target package: " + packageName);
            }
            PackageUserState packageUserState = ps.readUserState(userId);
            if (packageUserState.suspended) {
                return packageUserState.suspendedAppExtras;
            }
            return null;
        }
    }

    private void sendMyPackageSuspendedOrUnsuspended(String[] affectedPackages, boolean suspended, PersistableBundle appExtras, int userId) {
        String action;
        Bundle intentExtras = new Bundle();
        if (suspended) {
            action = "android.intent.action.MY_PACKAGE_SUSPENDED";
            if (appExtras != null) {
                Bundle bundledAppExtras = new Bundle(appExtras.deepCopy());
                intentExtras.putBundle("android.intent.extra.SUSPENDED_PACKAGE_EXTRAS", bundledAppExtras);
            }
        } else {
            action = "android.intent.action.MY_PACKAGE_UNSUSPENDED";
        }
        this.mHandler.post(() -> {
            try {
                IActivityManager am = ActivityManager.getService();
                if (am == null) {
                    Slog.wtf(TAG, "IActivityManager null. Cannot send MY_PACKAGE_ " + (suspended ? "" : "UN") + "SUSPENDED broadcasts");
                    return;
                }
                int[] targetUserIds = new int[]{userId};
                for (String packageName : affectedPackages) {
                    this.doSendBroadcast(am, action, null, intentExtras, 0x1000000, packageName, null, targetUserIds, false);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageSuspendedForUser(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, false, "isPackageSuspendedForUser for user " + userId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || this.filterAppAccessLPr(ps, callingUid, userId)) {
                throw new IllegalArgumentException("Unknown target package: " + packageName);
            }
            return ps.getSuspended(userId);
        }
    }

    void unsuspendForSuspendingPackage(String packageName, int affectedUser) {
        int[] userIds;
        int[] nArray;
        if (affectedUser == -1) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = affectedUser;
        }
        for (int userId : userIds = nArray) {
            this.unsuspendForSuspendingPackages(packageName::equals, userId);
        }
    }

    void unsuspendForNonSystemSuspendingPackages(ArraySet<Integer> userIds) {
        int sz = userIds.size();
        for (int i = 0; i < sz; ++i) {
            this.unsuspendForSuspendingPackages(suspendingPackage -> !PLATFORM_PACKAGE_NAME.equals(suspendingPackage), userIds.valueAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsuspendForSuspendingPackages(Predicate<String> packagePredicate, int userId) {
        ArrayList<String> affectedPackages = new ArrayList<String>();
        IntArray affectedUids = new IntArray();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (PackageSetting ps : this.mSettings.mPackages.values()) {
                PackageUserState pus = ps.readUserState(userId);
                if (!pus.suspended || !packagePredicate.test(pus.suspendingPackage)) continue;
                ps.setSuspended(false, null, null, null, null, userId);
                affectedPackages.add(ps.name);
                affectedUids.add(UserHandle.getUid(userId, ps.getAppId()));
            }
        }
        if (!affectedPackages.isEmpty()) {
            String[] packageArray = affectedPackages.toArray(new String[affectedPackages.size()]);
            this.sendMyPackageSuspendedOrUnsuspended(packageArray, false, null, userId);
            this.sendPackagesSuspendedForUser(packageArray, affectedUids.toArray(), userId, false, null);
            this.mSettings.writePackageRestrictionsLPr(userId);
        }
    }

    @Override
    public String[] getUnsuspendablePackagesForUser(String[] packageNames, int userId) {
        Preconditions.checkNotNull("packageNames cannot be null", packageNames);
        this.mContext.enforceCallingOrSelfPermission("android.permission.SUSPEND_APPS", "getUnsuspendablePackagesForUser");
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getUserId(callingUid) != userId) {
            throw new SecurityException("Calling uid " + callingUid + " cannot query getUnsuspendablePackagesForUser for user " + userId);
        }
        ArraySet<String> unactionablePackages = new ArraySet<String>();
        boolean[] canSuspend = this.canSuspendPackageForUserInternal(packageNames, userId);
        for (int i = 0; i < packageNames.length; ++i) {
            if (canSuspend[i]) continue;
            unactionablePackages.add(packageNames[i]);
        }
        return unactionablePackages.toArray(new String[unactionablePackages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean[] canSuspendPackageForUserInternal(String[] packageNames, int userId) {
        boolean[] canSuspend = new boolean[packageNames.length];
        long callingId = Binder.clearCallingIdentity();
        try {
            String activeLauncherPackageName = this.getActiveLauncherPackageName(userId);
            String dialerPackageName = this.getDefaultDialerPackageName(userId);
            for (int i = 0; i < packageNames.length; ++i) {
                block17: {
                    canSuspend[i] = false;
                    String packageName = packageNames[i];
                    if (this.isPackageDeviceAdmin(packageName, userId)) {
                        Slog.w(TAG, "Cannot suspend package \"" + packageName + "\": has an active device admin");
                        continue;
                    }
                    if (packageName.equals(activeLauncherPackageName)) {
                        Slog.w(TAG, "Cannot suspend package \"" + packageName + "\": contains the active launcher");
                        continue;
                    }
                    if (packageName.equals(this.mRequiredInstallerPackage)) {
                        Slog.w(TAG, "Cannot suspend package \"" + packageName + "\": required for package installation");
                        continue;
                    }
                    if (packageName.equals(this.mRequiredUninstallerPackage)) {
                        Slog.w(TAG, "Cannot suspend package \"" + packageName + "\": required for package uninstallation");
                        continue;
                    }
                    if (packageName.equals(this.mRequiredVerifierPackage)) {
                        Slog.w(TAG, "Cannot suspend package \"" + packageName + "\": required for package verification");
                        continue;
                    }
                    if (packageName.equals(dialerPackageName)) {
                        Slog.w(TAG, "Cannot suspend package \"" + packageName + "\": is the default dialer");
                        continue;
                    }
                    if (packageName.equals(this.mRequiredPermissionControllerPackage)) {
                        Slog.w(TAG, "Cannot suspend package \"" + packageName + "\": required for permissions management");
                        continue;
                    }
                    ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                    synchronized (arrayMap) {
                        if (this.mProtectedPackages.isPackageStateProtected(userId, packageName)) {
                            Slog.w(TAG, "Cannot suspend package \"" + packageName + "\": protected package");
                            continue;
                        }
                        PackageParser.Package pkg = this.mPackages.get(packageName);
                        if (pkg != null && pkg.applicationInfo.isStaticSharedLibrary()) {
                            Slog.w(TAG, "Cannot suspend package: " + packageName + " providing static shared library: " + pkg.staticSharedLibName);
                            continue;
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 7] lbl52 : MonitorExitStatement: MONITOREXIT : var10_9
                        if (!PLATFORM_PACKAGE_NAME.equals(packageName)) break block17;
                    }
                    Slog.w(TAG, "Cannot suspend the platform package: " + packageName);
                    continue;
                }
                canSuspend[i] = true;
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
        return canSuspend;
    }

    private String getActiveLauncherPackageName(int userId) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = this.resolveIntent(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 65536, userId);
        return resolveInfo == null ? null : resolveInfo.activityInfo.packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultDialerPackageName(int userId) {
        PackageManagerInternal.DefaultDialerProvider provider;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            provider = this.mDefaultDialerProvider;
        }
        if (provider == null) {
            Slog.e(TAG, "mDefaultDialerProvider is null");
            return null;
        }
        return provider.getDefaultDialer(userId);
    }

    @Override
    public void verifyPendingInstall(int id2, int verificationCode) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can verify applications");
        Message msg = this.mHandler.obtainMessage(15);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCode, Binder.getCallingUid());
        msg.arg1 = id2;
        msg.obj = response;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can extend verification timeouts");
        PackageVerificationState state = this.mPendingVerification.get(id2);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCodeAtTimeout, Binder.getCallingUid());
        if (millisecondsToDelay > 3600000L) {
            millisecondsToDelay = 3600000L;
        }
        if (millisecondsToDelay < 0L) {
            millisecondsToDelay = 0L;
        }
        if (verificationCodeAtTimeout != 1 && verificationCodeAtTimeout != -1) {
            verificationCodeAtTimeout = -1;
        }
        if (state != null && !state.timeoutExtended()) {
            state.extendTimeout();
            Message msg = this.mHandler.obtainMessage(15);
            msg.arg1 = id2;
            msg.obj = response;
            this.mHandler.sendMessageDelayed(msg, millisecondsToDelay);
        }
    }

    private void broadcastPackageVerified(int verificationId, Uri packageUri, int verificationCode, UserHandle user) {
        Intent intent = new Intent("android.intent.action.PACKAGE_VERIFIED");
        intent.setDataAndType(packageUri, PACKAGE_MIME_TYPE);
        intent.addFlags(1);
        intent.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
        intent.putExtra("android.content.pm.extra.VERIFICATION_RESULT", verificationCode);
        this.mContext.sendBroadcastAsUser(intent, user, "android.permission.PACKAGE_VERIFICATION_AGENT");
    }

    private ComponentName matchComponentForVerifier(String packageName, List<ResolveInfo> receivers) {
        ActivityInfo targetReceiver = null;
        int NR = receivers.size();
        for (int i = 0; i < NR; ++i) {
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || !packageName.equals(info.activityInfo.packageName)) continue;
            targetReceiver = info.activityInfo;
            break;
        }
        if (targetReceiver == null) {
            return null;
        }
        return new ComponentName(targetReceiver.packageName, targetReceiver.name);
    }

    private List<ComponentName> matchVerifiers(PackageInfoLite pkgInfo, List<ResolveInfo> receivers, PackageVerificationState verificationState) {
        if (pkgInfo.verifiers.length == 0) {
            return null;
        }
        int N = pkgInfo.verifiers.length;
        ArrayList<ComponentName> sufficientVerifiers = new ArrayList<ComponentName>(N + 1);
        for (int i = 0; i < N; ++i) {
            int verifierUid;
            VerifierInfo verifierInfo = pkgInfo.verifiers[i];
            ComponentName comp = this.matchComponentForVerifier(verifierInfo.packageName, receivers);
            if (comp == null || (verifierUid = this.getUidForVerifier(verifierInfo)) == -1) continue;
            sufficientVerifiers.add(comp);
            verificationState.addSufficientVerifier(verifierUid);
        }
        return sufficientVerifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForVerifier(VerifierInfo verifierInfo) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            byte[] expectedPublicKey;
            PackageParser.Package pkg = this.mPackages.get(verifierInfo.packageName);
            if (pkg == null) {
                return -1;
            }
            if (pkg.mSigningDetails.signatures.length != 1) {
                Slog.i(TAG, "Verifier package " + verifierInfo.packageName + " has more than one signature; ignoring");
                return -1;
            }
            try {
                Signature verifierSig = pkg.mSigningDetails.signatures[0];
                PublicKey publicKey = verifierSig.getPublicKey();
                expectedPublicKey = publicKey.getEncoded();
            }
            catch (CertificateException e) {
                return -1;
            }
            byte[] actualPublicKey = verifierInfo.publicKey.getEncoded();
            if (!Arrays.equals(actualPublicKey, expectedPublicKey)) {
                Slog.i(TAG, "Verifier package " + verifierInfo.packageName + " does not have the expected public key; ignoring");
                return -1;
            }
            return pkg.applicationInfo.uid;
        }
    }

    private void setEnableRollbackCode(int token, int enableRollbackCode) {
        Message msg = this.mHandler.obtainMessage(21);
        msg.arg1 = token;
        msg.arg2 = enableRollbackCode;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void finishPackageInstall(int token, boolean didLaunch) {
        PackageManagerService.enforceSystemOrRoot("Only the system is allowed to finish installs");
        Trace.asyncTraceEnd(262144L, "restore", token);
        Message msg = this.mHandler.obtainMessage(9, token, didLaunch ? 1 : 0);
        this.mHandler.sendMessage(msg);
    }

    private long getVerificationTimeout() {
        return Settings.Global.getLong(this.mContext.getContentResolver(), "verifier_timeout", 10000L);
    }

    private int getDefaultVerificationResponse(UserHandle user) {
        if (sUserManager.hasUserRestriction("ensure_verify_apps", user.getIdentifier())) {
            return -1;
        }
        return Settings.Global.getInt(this.mContext.getContentResolver(), "verifier_default_response", 1);
    }

    private boolean isVerificationEnabled(int userId, int installFlags, int installerUid) {
        if ((installFlags & 0x80000) != 0) {
            return false;
        }
        boolean ensureVerifyAppsEnabled = this.isUserRestricted(userId, "ensure_verify_apps");
        if ((installFlags & 0x20) != 0) {
            if (ActivityManager.isRunningInTestHarness()) {
                return false;
            }
            if (ensureVerifyAppsEnabled) {
                return true;
            }
            if (Settings.Global.getInt(this.mContext.getContentResolver(), "verifier_verify_adb_installs", 1) == 0) {
                return false;
            }
        } else if ((installFlags & 0x800) != 0 && this.mInstantAppInstallerActivity != null && this.mInstantAppInstallerActivity.packageName.equals(this.mRequiredVerifierPackage)) {
            try {
                this.mContext.getSystemService(AppOpsManager.class).checkPackage(installerUid, this.mRequiredVerifierPackage);
                return false;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (ensureVerifyAppsEnabled) {
            return true;
        }
        return Settings.Global.getInt(this.mContext.getContentResolver(), "package_verifier_enable", 1) == 1;
    }

    @Override
    public void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTENT_FILTER_VERIFICATION_AGENT", "Only intentfilter verification agents can verify applications");
        Message msg = this.mHandler.obtainMessage(18);
        IntentFilterVerificationResponse response = new IntentFilterVerificationResponse(Binder.getCallingUid(), verificationCode, failedDomains);
        msg.arg1 = id2;
        msg.obj = response;
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIntentVerificationStatus(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getUserId(callingUid) != userId) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "getIntentVerificationStatus" + userId);
        }
        if (this.getInstantAppPackageName(callingUid) != null) {
            return 0;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                return 0;
            }
            return this.mSettings.getIntentFilterVerificationStatusLPr(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateIntentVerificationStatus(String packageName, int status, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        boolean result = false;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (this.filterAppAccessLPr(ps, Binder.getCallingUid(), UserHandle.getCallingUserId())) {
                return false;
            }
            result = this.mSettings.updateIntentFilterVerificationStatusLPw(packageName, status, userId);
        }
        if (result) {
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<IntentFilterVerificationInfo> getIntentFilterVerifications(String packageName) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return ParceledListSlice.emptyList();
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                return ParceledListSlice.emptyList();
            }
            return new ParceledListSlice<IntentFilterVerificationInfo>(this.mSettings.getIntentFilterVerificationsLPr(packageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<IntentFilter> getAllIntentFilters(String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return ParceledListSlice.emptyList();
        }
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null || pkg.activities == null) {
                return ParceledListSlice.emptyList();
            }
            if (pkg.mExtras == null) {
                return ParceledListSlice.emptyList();
            }
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
                return ParceledListSlice.emptyList();
            }
            int count = pkg.activities.size();
            ArrayList result = new ArrayList();
            for (int n = 0; n < count; ++n) {
                PackageParser.Activity activity = pkg.activities.get(n);
                if (activity.intents == null || activity.intents.size() <= 0) continue;
                result.addAll(activity.intents);
            }
            return new ParceledListSlice<IntentFilter>(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDefaultBrowserPackageName(String packageName, int userId) {
        PackageManagerInternal.DefaultBrowserProvider provider;
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        }
        if (userId == -1) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            provider = this.mDefaultBrowserProvider;
        }
        if (provider == null) {
            Slog.e(TAG, "mDefaultBrowserProvider is null");
            return false;
        }
        boolean successful = provider.setDefaultBrowser(packageName, userId);
        if (!successful) {
            return false;
        }
        if (packageName != null) {
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultBrowser(packageName, userId);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultBrowserAsyncLPw(String packageName, int userId) {
        if (userId == -1) {
            return;
        }
        if (this.mDefaultBrowserProvider == null) {
            Slog.e(TAG, "mDefaultBrowserProvider is null");
            return;
        }
        this.mDefaultBrowserProvider.setDefaultBrowserAsync(packageName, userId);
        if (packageName != null) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultBrowser(packageName, userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultBrowserPackageName(int userId) {
        PackageManagerInternal.DefaultBrowserProvider provider;
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        }
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            provider = this.mDefaultBrowserProvider;
        }
        if (provider == null) {
            Slog.e(TAG, "mDefaultBrowserProvider is null");
            return null;
        }
        return provider.getDefaultBrowser(userId);
    }

    private int getUnknownSourcesSettings() {
        return Settings.Secure.getInt(this.mContext.getContentResolver(), "install_non_market_apps", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInstallerPackageName(String targetPackage, String installerPackageName) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting setting;
            Signature[] callerSignature;
            int appId;
            SettingBase obj;
            PackageSetting installerPackageSetting;
            PackageSetting targetPackageSetting = this.mSettings.mPackages.get(targetPackage);
            if (targetPackageSetting == null || this.filterAppAccessLPr(targetPackageSetting, callingUid, UserHandle.getUserId(callingUid))) {
                throw new IllegalArgumentException("Unknown target package: " + targetPackage);
            }
            if (installerPackageName != null) {
                installerPackageSetting = this.mSettings.mPackages.get(installerPackageName);
                if (installerPackageSetting == null) {
                    throw new IllegalArgumentException("Unknown installer package: " + installerPackageName);
                }
            } else {
                installerPackageSetting = null;
            }
            if ((obj = this.mSettings.getSettingLPr(appId = UserHandle.getAppId(callingUid))) == null) throw new SecurityException("Unknown calling UID: " + callingUid);
            if (obj instanceof SharedUserSetting) {
                callerSignature = ((SharedUserSetting)obj).signatures.mSigningDetails.signatures;
            } else {
                if (!(obj instanceof PackageSetting)) throw new SecurityException("Bad object " + obj + " for uid " + callingUid);
                callerSignature = ((PackageSetting)obj).signatures.mSigningDetails.signatures;
            }
            if (installerPackageSetting != null && PackageManagerServiceUtils.compareSignatures(callerSignature, installerPackageSetting.signatures.mSigningDetails.signatures) != 0) {
                throw new SecurityException("Caller does not have same cert as new installer package " + installerPackageName);
            }
            if (targetPackageSetting.installerPackageName != null && (setting = this.mSettings.mPackages.get(targetPackageSetting.installerPackageName)) != null && PackageManagerServiceUtils.compareSignatures(callerSignature, setting.signatures.mSigningDetails.signatures) != 0) {
                throw new SecurityException("Caller does not have same cert as old installer package " + targetPackageSetting.installerPackageName);
            }
            targetPackageSetting.installerPackageName = installerPackageName;
            if (installerPackageName != null) {
                this.mSettings.mInstallerPackages.add(installerPackageName);
            }
            this.scheduleWriteSettingsLocked();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationCategoryHint(String packageName, int categoryHint, String callerPackageName) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            throw new SecurityException("Instant applications don't have access to this method");
        }
        this.mContext.getSystemService(AppOpsManager.class).checkPackage(Binder.getCallingUid(), callerPackageName);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                throw new IllegalArgumentException("Unknown target package " + packageName);
            }
            if (this.filterAppAccessLPr(ps, Binder.getCallingUid(), UserHandle.getCallingUserId())) {
                throw new IllegalArgumentException("Unknown target package " + packageName);
            }
            if (!Objects.equals(callerPackageName, ps.installerPackageName)) {
                throw new IllegalArgumentException("Calling package " + callerPackageName + " is not installer for " + packageName);
            }
            if (ps.categoryHint != categoryHint) {
                ps.categoryHint = categoryHint;
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    private void processPendingInstall(InstallArgs args, int currentStatus) {
        if (args.mMultiPackageInstallParams != null) {
            args.mMultiPackageInstallParams.tryProcessInstallRequest(args, currentStatus);
        } else {
            PackageInstalledInfo res = this.createPackageInstalledInfo(currentStatus);
            this.processInstallRequestsAsync(res.returnCode == 1, Collections.singletonList(new InstallRequest(args, res)));
        }
    }

    private void processInstallRequestsAsync(boolean success, List<InstallRequest> installRequests) {
        this.mHandler.post(() -> {
            if (success) {
                for (InstallRequest request : installRequests) {
                    request.args.doPreInstall(request.installResult.returnCode);
                }
                Iterator iterator = this.mInstallLock;
                synchronized (iterator) {
                    this.installPackagesTracedLI(installRequests);
                }
                for (InstallRequest request : installRequests) {
                    request.args.doPostInstall(request.installResult.returnCode, request.installResult.uid);
                }
            }
            for (InstallRequest request : installRequests) {
                this.restoreAndPostInstall(request.args.user.getIdentifier(), request.installResult, new PostInstallData(request.args, request.installResult, null));
            }
        });
    }

    private PackageInstalledInfo createPackageInstalledInfo(int currentStatus) {
        PackageInstalledInfo res = new PackageInstalledInfo();
        res.setReturnCode(currentStatus);
        res.uid = -1;
        res.pkg = null;
        res.removedInfo = null;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreAndPostInstall(int userId, PackageInstalledInfo res, PostInstallData data) {
        int token;
        boolean doRestore;
        boolean update;
        block19: {
            update = res.removedInfo != null && res.removedInfo.removedPackage != null;
            int flags = res.pkg == null ? 0 : res.pkg.applicationInfo.flags;
            boolean bl = doRestore = !update && (flags & 0x8000) != 0;
            if (this.mNextInstallToken < 0) {
                this.mNextInstallToken = 1;
            }
            token = this.mNextInstallToken++;
            if (data != null) {
                this.mRunningInstalls.put(token, data);
            }
            if (res.returnCode == 1 && doRestore) {
                IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                if (bm != null) {
                    if (userId == -1) {
                        userId = 0;
                    }
                    Trace.asyncTraceBegin(262144L, "restore", token);
                    try {
                        if (bm.isBackupServiceActive(userId)) {
                            bm.restoreAtInstallForUser(userId, res.pkg.applicationInfo.packageName, token);
                            break block19;
                        }
                        doRestore = false;
                    }
                    catch (RemoteException remoteException) {
                    }
                    catch (Exception e) {
                        Slog.e(TAG, "Exception trying to enqueue restore", e);
                        doRestore = false;
                    }
                } else {
                    Slog.e(TAG, "Backup Manager not found!");
                    doRestore = false;
                }
            }
        }
        if (res.returnCode == 1 && !doRestore && update) {
            int[] installedUsers;
            PackageSetting ps;
            IRollbackManager rm = IRollbackManager.Stub.asInterface(ServiceManager.getService("rollback"));
            String packageName = res.pkg.applicationInfo.packageName;
            String seInfo = res.pkg.applicationInfo.seInfo;
            int[] allUsers = sUserManager.getUserIds();
            int appId = -1;
            long ceDataInode = -1L;
            Settings settings = this.mSettings;
            synchronized (settings) {
                ps = this.mSettings.getPackageLPr(packageName);
                if (ps != null) {
                    appId = ps.appId;
                    ceDataInode = ps.getCeDataInode(userId);
                }
                installedUsers = ps.queryInstalledUsers(allUsers, true);
            }
            if (ps != null) {
                try {
                    rm.snapshotAndRestoreUserData(packageName, installedUsers, appId, ceDataInode, seInfo, token);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                doRestore = true;
            }
        }
        if (!doRestore) {
            Trace.asyncTraceBegin(262144L, "postInstall", token);
            Message msg = this.mHandler.obtainMessage(9, token, 0);
            this.mHandler.sendMessage(msg);
        }
    }

    void notifyFirstLaunch(String packageName, String installerPackage, int userId) {
        this.mHandler.post(() -> {
            int[] nArray;
            int[] nArray2;
            for (int i = 0; i < this.mRunningInstalls.size(); ++i) {
                PostInstallData data = this.mRunningInstalls.valueAt(i);
                if (data.res.returnCode != 1 || !packageName.equals(data.res.pkg.applicationInfo.packageName)) continue;
                for (int uIndex = 0; uIndex < data.res.newUsers.length; ++uIndex) {
                    if (userId != data.res.newUsers[uIndex]) continue;
                    return;
                }
            }
            boolean isInstantApp = this.isInstantApp(packageName, userId);
            if (isInstantApp) {
                nArray2 = EMPTY_INT_ARRAY;
            } else {
                int[] nArray3 = new int[1];
                nArray2 = nArray3;
                nArray3[0] = userId;
            }
            int[] userIds = nArray2;
            if (isInstantApp) {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = userId;
            } else {
                nArray = EMPTY_INT_ARRAY;
            }
            int[] instantUserIds = nArray;
            this.sendFirstLaunchBroadcast(packageName, installerPackage, userIds, instantUserIds);
        });
    }

    private void sendFirstLaunchBroadcast(String pkgName, String installerPkg, int[] userIds, int[] instantUserIds) {
        this.sendPackageBroadcast("android.intent.action.PACKAGE_FIRST_LAUNCH", pkgName, null, 0, installerPkg, null, userIds, instantUserIds);
    }

    private InstallArgs createInstallArgs(InstallParams params) {
        if (params.move != null) {
            return new MoveInstallArgs(params);
        }
        return new FileInstallArgs(params);
    }

    private InstallArgs createInstallArgsForExisting(String codePath, String resourcePath, String[] instructionSets) {
        return new FileInstallArgs(codePath, resourcePath, instructionSets);
    }

    void removeDexFiles(List<String> allCodePaths, String[] instructionSets) {
        if (!allCodePaths.isEmpty()) {
            if (instructionSets == null) {
                throw new IllegalStateException("instructionSet == null");
            }
            String[] dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets);
            for (String codePath : allCodePaths) {
                for (String dexCodeInstructionSet : dexCodeInstructionSets) {
                    try {
                        this.mInstaller.rmdex(codePath, dexCodeInstructionSet);
                    }
                    catch (Installer.InstallerException installerException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void maybeThrowExceptionForMultiArchCopy(String message, int copyRet) throws PackageManagerException {
        if (copyRet < 0 && copyRet != -114 && copyRet != -113) {
            throw new PackageManagerException(copyRet, message);
        }
    }

    private File getNextCodePath(File targetDir, String packageName) {
        String suffix;
        File result;
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[16];
        do {
            random.nextBytes(bytes);
            suffix = Base64.encodeToString(bytes, 10);
        } while ((result = new File(targetDir, packageName + "-" + suffix)).exists());
        return result;
    }

    static String deriveCodePathName(String codePath) {
        if (codePath == null) {
            return null;
        }
        File codeFile = new File(codePath);
        String name = codeFile.getName();
        if (codeFile.isDirectory()) {
            return name;
        }
        if (name.endsWith(".apk") || name.endsWith(".tmp")) {
            int lastDot = name.lastIndexOf(46);
            return name.substring(0, lastDot);
        }
        Slog.w(TAG, "Odd, " + codePath + " doesn't look like an APK");
        return null;
    }

    private static void updateDigest(MessageDigest digest, File file) throws IOException {
        try (DigestInputStream digestStream = new DigestInputStream(new FileInputStream(file), digest);){
            while (digestStream.read() != -1) {
            }
        }
    }

    private String getParentOrChildPackageChangedSharedUser(PackageParser.Package oldPkg, PackageParser.Package newPkg) {
        if (!Objects.equals(oldPkg.mSharedUserId, newPkg.mSharedUserId)) {
            return newPkg.packageName;
        }
        int oldChildCount = oldPkg.childPackages != null ? oldPkg.childPackages.size() : 0;
        int newChildCount = newPkg.childPackages != null ? newPkg.childPackages.size() : 0;
        for (int i = 0; i < newChildCount; ++i) {
            PackageParser.Package newChildPkg = newPkg.childPackages.get(i);
            for (int j = 0; j < oldChildCount; ++j) {
                PackageParser.Package oldChildPkg = oldPkg.childPackages.get(j);
                if (!newChildPkg.packageName.equals(oldChildPkg.packageName) || Objects.equals(newChildPkg.mSharedUserId, oldChildPkg.mSharedUserId)) continue;
                return newChildPkg.packageName;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNativeBinariesLI(PackageSetting ps) {
        if (ps != null) {
            NativeLibraryHelper.removeNativeBinariesLI(ps.legacyNativeLibraryPathString);
            int childCount = ps.childPackageNames != null ? ps.childPackageNames.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                PackageSetting childPs = null;
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    childPs = this.mSettings.getPackageLPr((String)ps.childPackageNames.get(i));
                }
                if (childPs == null) continue;
                NativeLibraryHelper.removeNativeBinariesLI(childPs.legacyNativeLibraryPathString);
            }
        }
    }

    @GuardedBy(value={"mPackages"})
    private void enableSystemPackageLPw(PackageParser.Package pkg) {
        this.mSettings.enableSystemPackageLPw(pkg.packageName);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            this.mSettings.enableSystemPackageLPw(childPkg.packageName);
        }
    }

    @GuardedBy(value={"mPackages"})
    private boolean disableSystemPackageLPw(PackageParser.Package oldPkg, PackageParser.Package newPkg) {
        boolean disabled = this.mSettings.disableSystemPackageLPw(oldPkg.packageName, true);
        int childCount = oldPkg.childPackages != null ? oldPkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = oldPkg.childPackages.get(i);
            boolean replace = newPkg.hasChildPackage(childPkg.packageName);
            disabled |= this.mSettings.disableSystemPackageLPw(childPkg.packageName, replace);
        }
        return disabled;
    }

    @GuardedBy(value={"mPackages"})
    private void setInstallerPackageNameLPw(PackageParser.Package pkg, String installerPackageName) {
        this.mSettings.setInstallerPackageName(pkg.packageName, installerPackageName);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            this.mSettings.setInstallerPackageName(childPkg.packageName, installerPackageName);
        }
    }

    private void updateSettingsLI(PackageParser.Package newPackage, String installerPackageName, int[] allUsers, PackageInstalledInfo res, UserHandle user, int installReason) {
        this.updateSettingsInternalLI(newPackage, installerPackageName, allUsers, res.origUsers, res, user, installReason);
        int childCount = newPackage.childPackages != null ? newPackage.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPackage = newPackage.childPackages.get(i);
            PackageInstalledInfo childRes = res.addedChildPackages.get(childPackage.packageName);
            this.updateSettingsInternalLI(childPackage, installerPackageName, allUsers, childRes.origUsers, childRes, user, installReason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSettingsInternalLI(PackageParser.Package pkg, String installerPackageName, int[] allUsers, int[] installedForUsers, PackageInstalledInfo res, UserHandle user, int installReason) {
        Trace.traceBegin(262144L, "updateSettings");
        String pkgName = pkg.packageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mPermissionManager.updatePermissions(pkg.packageName, pkg, true, this.mPackages.values(), this.mPermissionCallback);
            PackageSetting ps = this.mSettings.mPackages.get(pkgName);
            int userId = user.getIdentifier();
            if (ps != null) {
                if (PackageManagerService.isSystemApp(pkg)) {
                    if (res.origUsers != null) {
                        for (int origUserId : res.origUsers) {
                            if (userId != -1 && userId != origUserId) continue;
                            ps.setEnabled(0, origUserId, installerPackageName);
                        }
                    }
                    if (allUsers != null && installedForUsers != null) {
                        for (int currentUserId : allUsers) {
                            boolean installed = ArrayUtils.contains(installedForUsers, currentUserId);
                            ps.setInstalled(installed, currentUserId);
                        }
                    }
                }
                if (userId != -1) {
                    ps.setInstalled(true, userId);
                    ps.setEnabled(0, userId, installerPackageName);
                }
                ArraySet<Integer> previousUserIds = new ArraySet<Integer>();
                if (res.removedInfo != null && res.removedInfo.installReasons != null) {
                    int installReasonCount = res.removedInfo.installReasons.size();
                    for (int i = 0; i < installReasonCount; ++i) {
                        int previousUserId = res.removedInfo.installReasons.keyAt(i);
                        int previousInstallReason = res.removedInfo.installReasons.valueAt(i);
                        ps.setInstallReason(previousInstallReason, previousUserId);
                        previousUserIds.add(previousUserId);
                    }
                }
                if (userId == -1) {
                    for (int currentUserId : sUserManager.getUserIds()) {
                        if (previousUserIds.contains(currentUserId)) continue;
                        ps.setInstallReason(installReason, currentUserId);
                    }
                } else if (!previousUserIds.contains(userId)) {
                    ps.setInstallReason(installReason, userId);
                }
                this.mSettings.writeKernelMappingLPr(ps);
            }
            res.name = pkgName;
            res.uid = pkg.applicationInfo.uid;
            res.pkg = pkg;
            this.mSettings.setInstallerPackageName(pkgName, installerPackageName);
            res.setReturnCode(1);
            Trace.traceBegin(262144L, "writeSettings");
            this.mSettings.writeLPr();
            Trace.traceEnd(262144L);
        }
        Trace.traceEnd(262144L);
    }

    @GuardedBy(value={"mInstallLock", "mPackages"})
    private void installPackagesTracedLI(List<InstallRequest> requests) {
        try {
            Trace.traceBegin(262144L, "installPackages");
            this.installPackagesLI(requests);
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    @GuardedBy(value={"mPackages"})
    private static Map<String, ReconciledPackage> reconcilePackagesLocked(ReconcileRequest request, KeySetManagerService ksms) throws ReconcileFailure {
        ScanResult scanResult;
        Map<String, ScanResult> scannedPackages = request.scannedPackages;
        ArrayMap<String, ReconciledPackage> result = new ArrayMap<String, ReconciledPackage>(scannedPackages.size());
        ArrayMap<String, PackageParser.Package> combinedPackages = new ArrayMap<String, PackageParser.Package>(request.allPackages.size() + scannedPackages.size());
        combinedPackages.putAll(request.allPackages);
        ArrayMap<String, LongSparseArray<SharedLibraryInfo>> incomingSharedLibraries = new ArrayMap<String, LongSparseArray<SharedLibraryInfo>>();
        for (String installPackageName : scannedPackages.keySet()) {
            DeletePackageAction deletePackageAction;
            boolean isInstall;
            scanResult = scannedPackages.get(installPackageName);
            combinedPackages.put(scanResult.pkgSetting.name, scanResult.request.pkg);
            List<SharedLibraryInfo> allowedSharedLibInfos = PackageManagerService.getAllowedSharedLibInfos(scanResult, request.sharedLibrarySource);
            SharedLibraryInfo staticLib = scanResult.staticSharedLibraryInfo;
            if (allowedSharedLibInfos != null) {
                for (SharedLibraryInfo info : allowedSharedLibInfos) {
                    if (PackageManagerService.addSharedLibraryToPackageVersionMap(incomingSharedLibraries, info)) continue;
                    throw new ReconcileFailure("Static Shared Library " + staticLib.getName() + " is being installed twice in this set!");
                }
            }
            InstallArgs installArgs = request.installArgs.get(installPackageName);
            PackageInstalledInfo res = request.installResults.get(installPackageName);
            PrepareResult prepareResult = request.preparedPackages.get(installPackageName);
            boolean bl = isInstall = installArgs != null;
            if (isInstall && (res == null || prepareResult == null)) {
                throw new ReconcileFailure("Reconcile arguments are not balanced for " + installPackageName + "!");
            }
            if (isInstall && prepareResult.replace && !prepareResult.system) {
                boolean killApp = (scanResult.request.scanFlags & 0x800) == 0;
                int deleteFlags = 1 | (killApp ? 0 : 8);
                deletePackageAction = PackageManagerService.mayDeletePackageLocked(res.removedInfo, prepareResult.originalPs, prepareResult.disabledPs, prepareResult.childPackageSettings, deleteFlags, null);
                if (deletePackageAction == null) {
                    throw new ReconcileFailure(-10, "May not delete " + installPackageName + " to replace");
                }
            } else {
                deletePackageAction = null;
            }
            int scanFlags = scanResult.request.scanFlags;
            int parseFlags = scanResult.request.parseFlags;
            PackageParser.Package pkg = scanResult.request.pkg;
            PackageSetting disabledPkgSetting = scanResult.request.disabledPkgSetting;
            PackageSetting lastStaticSharedLibSetting = request.lastStaticSharedLibSettings.get(installPackageName);
            PackageSetting signatureCheckPs = prepareResult != null && lastStaticSharedLibSetting != null ? lastStaticSharedLibSetting : scanResult.pkgSetting;
            boolean removeAppKeySetData = false;
            boolean sharedUserSignaturesChanged = false;
            PackageParser.SigningDetails signingDetails = null;
            if (ksms.shouldCheckUpgradeKeySetLocked(signatureCheckPs, scanFlags)) {
                if (!ksms.checkUpgradeKeySetLocked(signatureCheckPs, pkg)) {
                    if ((parseFlags & 0x10) == 0) {
                        throw new ReconcileFailure(-7, "Package " + pkg.packageName + " upgrade keys do not match the previously installed version");
                    }
                    String msg = "System package " + pkg.packageName + " signature changed; retaining data.";
                    PackageManagerService.reportSettingsProblem(5, msg);
                }
                signingDetails = pkg.mSigningDetails;
            } else {
                try {
                    Settings.VersionInfo versionInfo = request.versionInfos.get(installPackageName);
                    boolean compareCompat = PackageManagerService.isCompatSignatureUpdateNeeded(versionInfo);
                    boolean compareRecover = PackageManagerService.isRecoverSignatureUpdateNeeded(versionInfo);
                    boolean compatMatch = PackageManagerServiceUtils.verifySignatures(signatureCheckPs, disabledPkgSetting, pkg.mSigningDetails, compareCompat, compareRecover);
                    if (compatMatch) {
                        removeAppKeySetData = true;
                    }
                    signingDetails = pkg.mSigningDetails;
                    if (signatureCheckPs.sharedUser != null) {
                        if (pkg.mSigningDetails.hasAncestor(signatureCheckPs.sharedUser.signatures.mSigningDetails)) {
                            signatureCheckPs.sharedUser.signatures.mSigningDetails = pkg.mSigningDetails;
                        }
                        if (signatureCheckPs.sharedUser.signaturesChanged == null) {
                            signatureCheckPs.sharedUser.signaturesChanged = Boolean.FALSE;
                        }
                    }
                }
                catch (PackageManagerException e) {
                    if ((parseFlags & 0x10) == 0) {
                        throw new ReconcileFailure(e);
                    }
                    signingDetails = pkg.mSigningDetails;
                    if (signatureCheckPs.sharedUser != null) {
                        Signature[] sharedUserSignatures = signatureCheckPs.sharedUser.signatures.mSigningDetails.signatures;
                        if (signatureCheckPs.sharedUser.signaturesChanged != null && PackageManagerServiceUtils.compareSignatures(sharedUserSignatures, pkg.mSigningDetails.signatures) != 0) {
                            if (SystemProperties.getInt("ro.product.first_api_level", 0) <= 29) {
                                throw new ReconcileFailure(-104, "Signature mismatch for shared user: " + scanResult.pkgSetting.sharedUser);
                            }
                            throw new IllegalStateException("Signature mismatch on system package " + pkg.packageName + " for shared user " + scanResult.pkgSetting.sharedUser);
                        }
                        sharedUserSignaturesChanged = true;
                        signatureCheckPs.sharedUser.signatures.mSigningDetails = pkg.mSigningDetails;
                        signatureCheckPs.sharedUser.signaturesChanged = Boolean.TRUE;
                    }
                    String msg = "System package " + pkg.packageName + " signature changed; retaining data.";
                    PackageManagerService.reportSettingsProblem(5, msg);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Signing certificates comparison made on incomparable signing details but somehow passed verifySignatures!", e);
                }
            }
            result.put(installPackageName, new ReconciledPackage(request, installArgs, scanResult.pkgSetting, res, request.preparedPackages.get(installPackageName), scanResult, deletePackageAction, allowedSharedLibInfos, signingDetails, sharedUserSignaturesChanged, removeAppKeySetData));
        }
        for (String installPackageName : scannedPackages.keySet()) {
            scanResult = scannedPackages.get(installPackageName);
            if ((scanResult.request.scanFlags & 0x10) != 0 || (scanResult.request.parseFlags & 0x10) != 0) continue;
            try {
                ((ReconciledPackage)result.get((Object)installPackageName)).collectedSharedLibraryInfos = PackageManagerService.collectSharedLibraryInfos(scanResult.request.pkg, combinedPackages, request.sharedLibrarySource, incomingSharedLibraries);
            }
            catch (PackageManagerException e) {
                throw new ReconcileFailure(e.error, e.getMessage());
            }
        }
        return result;
    }

    private static List<SharedLibraryInfo> getAllowedSharedLibInfos(ScanResult scanResult, Map<String, LongSparseArray<SharedLibraryInfo>> existingSharedLibraries) {
        PackageSetting updatedSystemPs;
        boolean hasDynamicLibraries;
        PackageParser.Package pkg = scanResult.request.pkg;
        if (scanResult.staticSharedLibraryInfo == null && scanResult.dynamicSharedLibraryInfos == null) {
            return null;
        }
        if (scanResult.staticSharedLibraryInfo != null) {
            return Collections.singletonList(scanResult.staticSharedLibraryInfo);
        }
        boolean bl = hasDynamicLibraries = (pkg.applicationInfo.flags & 1) != 0 && scanResult.dynamicSharedLibraryInfos != null;
        if (!hasDynamicLibraries) {
            return null;
        }
        boolean isUpdatedSystemApp = pkg.isUpdatedSystemApp();
        PackageSetting packageSetting = isUpdatedSystemApp ? (scanResult.request.disabledPkgSetting == null ? scanResult.request.oldPkgSetting : scanResult.request.disabledPkgSetting) : (updatedSystemPs = null);
        if (isUpdatedSystemApp && (updatedSystemPs.pkg == null || updatedSystemPs.pkg.libraryNames == null)) {
            Slog.w(TAG, "Package " + pkg.packageName + " declares libraries that are not declared on the system image; skipping");
            return null;
        }
        ArrayList<SharedLibraryInfo> infos = new ArrayList<SharedLibraryInfo>(scanResult.dynamicSharedLibraryInfos.size());
        for (SharedLibraryInfo info : scanResult.dynamicSharedLibraryInfos) {
            String name = info.getName();
            if (isUpdatedSystemApp && !updatedSystemPs.pkg.libraryNames.contains(name)) {
                Slog.w(TAG, "Package " + pkg.packageName + " declares library " + name + " that is not declared on system image; skipping");
                continue;
            }
            if (PackageManagerService.sharedLibExists(name, -1L, existingSharedLibraries)) {
                Slog.w(TAG, "Package " + pkg.packageName + " declares library " + name + " that already exists; skipping");
                continue;
            }
            infos.add(info);
        }
        return infos;
    }

    private static boolean addSharedLibraryToPackageVersionMap(Map<String, LongSparseArray<SharedLibraryInfo>> target, SharedLibraryInfo library) {
        String name = library.getName();
        if (target.containsKey(name)) {
            if (library.getType() != 2) {
                return false;
            }
            if (target.get(name).indexOfKey(library.getLongVersion()) >= 0) {
                return false;
            }
        } else {
            target.put(name, new LongSparseArray());
        }
        target.get(name).put(library.getLongVersion(), library);
        return true;
    }

    @GuardedBy(value={"mPackages"})
    private void commitPackagesLocked(CommitRequest request) {
        for (ReconciledPackage reconciledPkg : request.reconciledPackages.values()) {
            ScanResult scanResult = reconciledPkg.scanResult;
            ScanRequest scanRequest = scanResult.request;
            PackageParser.Package pkg = scanRequest.pkg;
            String packageName = pkg.packageName;
            PackageInstalledInfo res = reconciledPkg.installResult;
            if (reconciledPkg.prepareResult.replace) {
                PackageParser.Package oldPackage = this.mPackages.get(packageName);
                PackageSetting deletedPkgSetting = (PackageSetting)oldPackage.mExtras;
                this.setInstallAndUpdateTime(pkg, deletedPkgSetting.firstInstallTime, System.currentTimeMillis());
                if (reconciledPkg.prepareResult.system) {
                    this.removePackageLI(oldPackage, true);
                    res.removedInfo.args = !this.disableSystemPackageLPw(oldPackage, pkg) ? this.createInstallArgsForExisting(oldPackage.applicationInfo.getCodePath(), oldPackage.applicationInfo.getResourcePath(), InstructionSets.getAppDexInstructionSets(oldPackage.applicationInfo)) : null;
                    int deletedChildCount = oldPackage.childPackages != null ? oldPackage.childPackages.size() : 0;
                    int newChildCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
                    for (int i = 0; i < deletedChildCount; ++i) {
                        PackageSetting ps1;
                        PackageParser.Package deletedChildPkg = oldPackage.childPackages.get(i);
                        boolean childPackageDeleted = true;
                        for (int j = 0; j < newChildCount; ++j) {
                            PackageParser.Package newChildPkg = pkg.childPackages.get(j);
                            if (!deletedChildPkg.packageName.equals(newChildPkg.packageName)) continue;
                            childPackageDeleted = false;
                            break;
                        }
                        if (!childPackageDeleted || (ps1 = this.mSettings.getDisabledSystemPkgLPr(deletedChildPkg.packageName)) == null || res.removedInfo.removedChildPackages == null) continue;
                        PackageRemovedInfo removedChildRes = res.removedInfo.removedChildPackages.get(deletedChildPkg.packageName);
                        this.removePackageDataLIF(ps1, request.mAllUsers, removedChildRes, 0, false);
                        removedChildRes.removedForAllUsers = this.mPackages.get(ps1.name) == null;
                    }
                } else {
                    PackageSetting ps2;
                    block21: {
                        try {
                            this.executeDeletePackageLIF(reconciledPkg.deletePackageAction, packageName, true, request.mAllUsers, true, pkg);
                        }
                        catch (SystemDeleteException e) {
                            if (!Build.IS_ENG) break block21;
                            throw new RuntimeException("Unexpected failure", e);
                        }
                    }
                    if (oldPackage.isForwardLocked() || PackageManagerService.isExternal(oldPackage)) {
                        int[] uidArray = new int[]{oldPackage.applicationInfo.uid};
                        ArrayList<String> pkgList = new ArrayList<String>(1);
                        pkgList.add(oldPackage.applicationInfo.packageName);
                        this.sendResourcesChangedBroadcast(false, true, pkgList, uidArray, null);
                    }
                    PackageSetting ps1 = this.mSettings.mPackages.get(reconciledPkg.prepareResult.existingPackage.packageName);
                    if ((reconciledPkg.installArgs.installFlags & 1) == 0) {
                        if (ps1.mOldCodePaths == null) {
                            ps1.mOldCodePaths = new ArraySet();
                        }
                        Collections.addAll(ps1.mOldCodePaths, oldPackage.baseCodePath);
                        if (oldPackage.splitCodePaths != null) {
                            Collections.addAll(ps1.mOldCodePaths, oldPackage.splitCodePaths);
                        }
                    } else {
                        ps1.mOldCodePaths = null;
                    }
                    if (ps1.childPackageNames != null) {
                        for (int i = ps1.childPackageNames.size() - 1; i >= 0; --i) {
                            String childPkgName = (String)ps1.childPackageNames.get(i);
                            PackageSetting childPs = this.mSettings.mPackages.get(childPkgName);
                            childPs.mOldCodePaths = ps1.mOldCodePaths;
                        }
                    }
                    if (reconciledPkg.installResult.returnCode == 1 && (ps2 = this.mSettings.getPackageLPr(pkg.packageName)) != null) {
                        boolean bl = res.removedInfo.removedForAllUsers = this.mPackages.get(ps2.name) == null;
                        if (res.removedInfo.removedChildPackages != null) {
                            int childCount1 = res.removedInfo.removedChildPackages.size();
                            for (int i = childCount1 - 1; i >= 0; --i) {
                                String childPackageName = res.removedInfo.removedChildPackages.keyAt(i);
                                if (res.addedChildPackages.containsKey(childPackageName)) {
                                    res.removedInfo.removedChildPackages.removeAt(i);
                                    continue;
                                }
                                PackageRemovedInfo childInfo = res.removedInfo.removedChildPackages.valueAt(i);
                                childInfo.removedForAllUsers = this.mPackages.get(childInfo.removedPackage) == null;
                            }
                        }
                    }
                }
            }
            this.commitReconciledScanResultLocked(reconciledPkg);
            this.updateSettingsLI(pkg, reconciledPkg.installArgs.installerPackageName, request.mAllUsers, res, reconciledPkg.installArgs.user, reconciledPkg.installArgs.installReason);
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps != null) {
                res.newUsers = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
                ps.setUpdateAvailable(false);
            }
            int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                PackageParser.Package childPkg = pkg.childPackages.get(i);
                PackageInstalledInfo childRes = res.addedChildPackages.get(childPkg.packageName);
                PackageSetting childPs = this.mSettings.getPackageLPr(childPkg.packageName);
                if (childPs == null) continue;
                childRes.newUsers = childPs.queryInstalledUsers(sUserManager.getUserIds(), true);
            }
            if (res.returnCode != 1) continue;
            this.updateSequenceNumberLP(ps, res.newUsers);
            this.updateInstantAppInstallerLocked(packageName);
        }
    }

    /*
     * Exception decompiling
     */
    @GuardedBy(value={"mInstallLock"})
    private void installPackagesLI(List<InstallRequest> requests) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK], 15[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executePostCommitSteps(CommitRequest commitRequest) {
        for (ReconciledPackage reconciledPkg : commitRequest.reconciledPackages.values()) {
            boolean performDexopt;
            boolean instantApp = (reconciledPkg.scanResult.request.scanFlags & 0x4000) != 0;
            PackageParser.Package pkg = reconciledPkg.pkgSetting.pkg;
            String packageName = pkg.packageName;
            this.prepareAppDataAfterInstallLIF(pkg);
            if (reconciledPkg.prepareResult.clearCodeCache) {
                this.clearAppDataLIF(pkg, -1, 39);
            }
            if (reconciledPkg.prepareResult.replace) {
                this.mDexManager.notifyPackageUpdated(pkg.packageName, pkg.baseCodePath, pkg.splitCodePaths);
            }
            this.mArtManagerService.prepareAppProfiles(pkg, this.resolveUserIds(reconciledPkg.installArgs.user.getIdentifier()), true);
            boolean bl = performDexopt = (!instantApp || Settings.Global.getInt(this.mContext.getContentResolver(), "instant_app_dexopt_enabled", 0) != 0) && (pkg.applicationInfo.flags & 2) == 0;
            if (performDexopt) {
                if (SystemProperties.getBoolean(PRECOMPILE_LAYOUTS, false)) {
                    Trace.traceBegin(262144L, "compileLayouts");
                    this.mViewCompiler.compileLayouts(pkg);
                    Trace.traceEnd(262144L);
                }
                Trace.traceBegin(262144L, "dexopt");
                DexoptOptions dexoptOptions = new DexoptOptions(packageName, 2, 1028);
                this.mPackageDexOptimizer.performDexOpt(pkg, null, this.getOrCreateCompilerPackageStats(pkg), this.mDexManager.getPackageUseInfoOrDefault(packageName), dexoptOptions);
                Trace.traceEnd(262144L);
            }
            BackgroundDexOptService.notifyPackageChanged(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mInstallLock"})
    private PrepareResult preparePackageLI(InstallArgs args, PackageInstalledInfo res) throws PrepareFailure {
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> childPkg;
        PackageParser.Package pkg;
        int installFlags = args.installFlags;
        String installerPackageName = args.installerPackageName;
        String volumeUuid = args.volumeUuid;
        File tmpPackageFile = new File(args.getCodePath());
        boolean onExternal = args.volumeUuid != null;
        boolean instantApp = (installFlags & 0x800) != 0;
        boolean fullApp = (installFlags & 0x4000) != 0;
        boolean virtualPreload = (installFlags & 0x10000) != 0;
        int scanFlags = 6;
        if (args.move != null) {
            scanFlags |= 0x200;
        }
        if ((installFlags & 0x1000) != 0) {
            scanFlags |= 0x800;
        }
        if (instantApp) {
            scanFlags |= 0x4000;
        }
        if (fullApp) {
            scanFlags |= 0x8000;
        }
        if (virtualPreload) {
            scanFlags |= 0x10000;
        }
        if (instantApp && onExternal) {
            Slog.i(TAG, "Incompatible ephemeral install; external=" + onExternal);
            throw new PrepareFailure(-116);
        }
        int parseFlags = this.mDefParseFlags | Integer.MIN_VALUE | 0x40 | (onExternal ? 8 : 0);
        PackageParser pp = new PackageParser();
        pp.setSeparateProcesses(this.mSeparateProcesses);
        pp.setDisplayMetrics(this.mMetrics);
        pp.setCallback(this.mPackageParserCallback);
        Trace.traceBegin(262144L, "parsePackage");
        try {
            pkg = pp.parsePackage(tmpPackageFile, parseFlags);
            DexMetadataHelper.validatePackageDexMetadata(pkg);
        }
        catch (PackageParser.PackageParserException e) {
            throw new PrepareFailure("Failed parse during installPackageLI", e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
        if (instantApp) {
            if (pkg.applicationInfo.targetSdkVersion < 26) {
                Slog.w(TAG, "Instant app package " + pkg.packageName + " does not target at least O");
                throw new PrepareFailure(-116, "Instant app package must target at least O");
            }
            if (pkg.mSharedUserId != null) {
                Slog.w(TAG, "Instant app package " + pkg.packageName + " may not declare sharedUserId.");
                throw new PrepareFailure(-116, "Instant app package may not declare a sharedUserId");
            }
        }
        if (pkg.applicationInfo.isStaticSharedLibrary()) {
            PackageManagerService.renameStaticSharedLibraryPackage(pkg);
            if (onExternal) {
                Slog.i(TAG, "Static shared libs can only be installed on internal storage.");
                throw new PrepareFailure(-19, "Packages declaring static-shared libs cannot be updated");
            }
        }
        if (pkg.childPackages != null) {
            ArrayMap<String, PackageParser.Package> e = this.mPackages;
            synchronized (e) {
                int childCount = pkg.childPackages.size();
                for (int i = 0; i < childCount; ++i) {
                    childPkg = pkg.childPackages.get(i);
                    PackageInstalledInfo childRes = new PackageInstalledInfo();
                    childRes.setReturnCode(1);
                    childRes.pkg = childPkg;
                    childRes.name = ((PackageParser.Package)((Object)childPkg)).packageName;
                    PackageSetting childPs = this.mSettings.getPackageLPr(((PackageParser.Package)((Object)childPkg)).packageName);
                    if (childPs != null) {
                        childRes.origUsers = childPs.queryInstalledUsers(sUserManager.getUserIds(), true);
                    }
                    if (this.mPackages.containsKey(((PackageParser.Package)((Object)childPkg)).packageName)) {
                        childRes.removedInfo = new PackageRemovedInfo(this);
                        childRes.removedInfo.removedPackage = ((PackageParser.Package)((Object)childPkg)).packageName;
                        childRes.removedInfo.installerPackageName = childPs.installerPackageName;
                    }
                    if (res.addedChildPackages == null) {
                        res.addedChildPackages = new ArrayMap();
                    }
                    res.addedChildPackages.put(((PackageParser.Package)((Object)childPkg)).packageName, childRes);
                }
            }
        }
        if (TextUtils.isEmpty(pkg.cpuAbiOverride)) {
            pkg.cpuAbiOverride = args.abiOverride;
        }
        String pkgName = res.name = pkg.packageName;
        if ((pkg.applicationInfo.flags & 0x100) != 0 && (installFlags & 4) == 0) {
            throw new PrepareFailure(-15, "installPackageLI");
        }
        try {
            if (args.signingDetails != PackageParser.SigningDetails.UNKNOWN) {
                pkg.setSigningDetails(args.signingDetails);
            } else {
                PackageParser.collectCertificates(pkg, false);
            }
        }
        catch (PackageParser.PackageParserException e) {
            throw new PrepareFailure("Failed collect during installPackageLI", e);
        }
        if (instantApp && pkg.mSigningDetails.signatureSchemeVersion < 2) {
            Slog.w(TAG, "Instant app package " + pkg.packageName + " is not signed with at least APK Signature Scheme v2");
            throw new PrepareFailure(-116, "Instant app package must be signed with APK Signature Scheme v2 or greater");
        }
        pp = null;
        boolean systemApp = false;
        boolean replace = false;
        childPkg = this.mPackages;
        synchronized (childPkg) {
            if ((installFlags & 2) != 0) {
                String oldName = this.mSettings.getRenamedPackageLPr(pkgName);
                if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName) && this.mPackages.containsKey(oldName)) {
                    pkg.setPackageName(oldName);
                    pkgName = pkg.packageName;
                    replace = true;
                } else if (this.mPackages.containsKey(pkgName)) {
                    replace = true;
                }
                if (pkg.parentPackage != null) {
                    throw new PrepareFailure(-106, "Package " + pkg.packageName + " is child of package " + pkg.parentPackage.parentPackage + ". Child packages can be updated only through the parent package.");
                }
                if (replace) {
                    PackageParser.Package oldPackage = this.mPackages.get(pkgName);
                    int oldTargetSdk = oldPackage.applicationInfo.targetSdkVersion;
                    int newTargetSdk = pkg.applicationInfo.targetSdkVersion;
                    if (oldTargetSdk > 22 && newTargetSdk <= 22) {
                        throw new PrepareFailure(-26, "Package " + pkg.packageName + " new target SDK " + newTargetSdk + " doesn't support runtime permissions but the old target SDK " + oldTargetSdk + " does.");
                    }
                    if ((oldPackage.applicationInfo.flags & 8) != 0 && (installFlags & 0x200000) == 0) {
                        throw new PrepareFailure(-2, "Package " + oldPackage.packageName + " is a persistent app. Persistent apps are not updateable.");
                    }
                    if (oldPackage.parentPackage != null) {
                        throw new PrepareFailure(-106, "Package " + pkg.packageName + " is child of package " + oldPackage.parentPackage + ". Child packages can be updated only through the parent package.");
                    }
                }
            }
            if ((ps = this.mSettings.mPackages.get(pkgName)) != null) {
                block123: {
                    KeySetManagerService ksms;
                    SharedLibraryInfo libraryInfo;
                    PackageSetting signatureCheckPs = ps;
                    if (pkg.applicationInfo.isStaticSharedLibrary() && (libraryInfo = this.getLatestSharedLibraVersionLPr(pkg)) != null) {
                        signatureCheckPs = this.mSettings.getPackageLPr(libraryInfo.getPackageName());
                    }
                    if ((ksms = this.mSettings.mKeySetManagerService).shouldCheckUpgradeKeySetLocked(signatureCheckPs, scanFlags)) {
                        if (!ksms.checkUpgradeKeySetLocked(signatureCheckPs, pkg)) {
                            throw new PrepareFailure(-7, "Package " + pkg.packageName + " upgrade keys do not match the previously installed version");
                        }
                    } else {
                        try {
                            boolean compareCompat = this.isCompatSignatureUpdateNeeded(pkg);
                            boolean compareRecover = this.isRecoverSignatureUpdateNeeded(pkg);
                            boolean compatMatch = PackageManagerServiceUtils.verifySignatures(signatureCheckPs, null, pkg.mSigningDetails, compareCompat, compareRecover);
                            if (!compatMatch) break block123;
                            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                            synchronized (arrayMap) {
                                ksms.removeAppKeySetDataLPw(pkg.packageName);
                            }
                        }
                        catch (PackageManagerException e) {
                            throw new PrepareFailure(e.error, e.getMessage());
                        }
                    }
                }
                if (ps.pkg != null && ps.pkg.applicationInfo != null) {
                    systemApp = (ps.pkg.applicationInfo.flags & 1) != 0;
                }
                res.origUsers = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
            }
            int N = pkg.permissions.size();
            for (int i = N - 1; i >= 0; --i) {
                boolean sigsOk;
                PackageParser.Permission perm = pkg.permissions.get(i);
                BasePermission bp = this.mPermissionManager.getPermissionTEMP(perm.info.name);
                if ((perm.info.protectionLevel & 0x1000) != 0 && !systemApp) {
                    Slog.w(TAG, "Non-System package " + pkg.packageName + " attempting to delcare ephemeral permission " + perm.info.name + "; Removing ephemeral.");
                    perm.info.protectionLevel &= 0xFFFFEFFF;
                }
                if (bp == null) continue;
                String sourcePackageName = bp.getSourcePackageName();
                PackageSettingBase sourcePackageSetting = bp.getSourcePackageSetting();
                KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                if (sourcePackageName.equals(pkg.packageName) && ksms.shouldCheckUpgradeKeySetLocked(sourcePackageSetting, scanFlags)) {
                    sigsOk = ksms.checkUpgradeKeySetLocked(sourcePackageSetting, pkg);
                } else if (sourcePackageSetting.signatures.mSigningDetails.checkCapability(pkg.mSigningDetails, 4)) {
                    sigsOk = true;
                } else if (pkg.mSigningDetails.checkCapability(sourcePackageSetting.signatures.mSigningDetails, 4)) {
                    sourcePackageSetting.signatures.mSigningDetails = pkg.mSigningDetails;
                    sigsOk = true;
                } else {
                    sigsOk = false;
                }
                if (!sigsOk) {
                    if (!sourcePackageName.equals(PLATFORM_PACKAGE_NAME)) {
                        throw new PrepareFailure(-112, "Package " + pkg.packageName + " attempting to redeclare permission " + perm.info.name + " already owned by " + sourcePackageName).conflictsWithExistingPermission(perm.info.name, sourcePackageName);
                    }
                    Slog.w(TAG, "Package " + pkg.packageName + " attempting to redeclare system permission " + perm.info.name + "; ignoring new declaration");
                    pkg.permissions.remove(i);
                    continue;
                }
                if (PLATFORM_PACKAGE_NAME.equals(pkg.packageName) || (perm.info.protectionLevel & 0xF) != 1 || bp == null || bp.isRuntime()) continue;
                Slog.w(TAG, "Package " + pkg.packageName + " trying to change a non-runtime permission " + perm.info.name + " to runtime; keeping old protection level");
                perm.info.protectionLevel = bp.getProtectionLevel();
            }
        }
        if (systemApp) {
            if (onExternal) {
                throw new PrepareFailure(-19, "Cannot install updates to system apps on sdcard");
            }
            if (instantApp) {
                throw new PrepareFailure(-116, "Cannot update a system app with an instant app");
            }
        }
        if (args.move != null) {
            scanFlags |= 1;
            scanFlags |= 0x100;
            childPkg = this.mPackages;
            synchronized (childPkg) {
                ps = this.mSettings.mPackages.get(pkgName);
                if (ps == null) {
                    res.setError(-110, "Missing settings for moved package " + pkgName);
                }
                pkg.applicationInfo.primaryCpuAbi = ps.primaryCpuAbiString;
                pkg.applicationInfo.secondaryCpuAbi = ps.secondaryCpuAbiString;
            }
        }
        scanFlags |= 1;
        try {
            String abiOverride = TextUtils.isEmpty(pkg.cpuAbiOverride) ? args.abiOverride : pkg.cpuAbiOverride;
            boolean extractNativeLibs = !pkg.isLibrary();
            PackageManagerService.derivePackageAbi(pkg, abiOverride, extractNativeLibs);
        }
        catch (PackageManagerException pme) {
            Slog.e(TAG, "Error deriving application ABI", pme);
            throw new PrepareFailure(-110, "Error deriving application ABI");
        }
        if (!args.doRename(res.returnCode, pkg)) {
            throw new PrepareFailure(-4, "Failed rename");
        }
        try {
            this.setUpFsVerityIfPossible(pkg);
        }
        catch (Installer.InstallerException | IOException | DigestException | NoSuchAlgorithmException e) {
            throw new PrepareFailure(-110, "Failed to set up verity: " + e);
        }
        if (!instantApp) {
            this.startIntentFilterVerifications(args.user.getIdentifier(), replace, pkg);
        }
        PackageFreezer freezer = this.freezePackageForInstall(pkgName, installFlags, "installPackageLI");
        boolean shouldCloseFreezerBeforeReturn = true;
        try {
            PackageSetting[] childPackages;
            PackageSetting disabledPs;
            PackageSetting ps2;
            PackageParser.Package existingPackage;
            String renamedPackage = null;
            boolean sysPkg = false;
            String targetVolumeUuid = volumeUuid;
            int targetScanFlags = scanFlags;
            int targetParseFlags = parseFlags;
            if (replace) {
                int[] installedUsers;
                int[] allUsers;
                PackageParser.Package oldPackage;
                PackageParser.Package existingPkg;
                targetVolumeUuid = null;
                if (pkg.applicationInfo.isStaticSharedLibrary() && (existingPkg = this.mPackages.get(pkg.packageName)) != null && existingPkg.getLongVersionCode() != pkg.getLongVersionCode()) {
                    throw new PrepareFailure(-5, "Packages declaring static-shared libs cannot be updated");
                }
                boolean isInstantApp = (scanFlags & 0x4000) != 0;
                String pkgName11 = pkg.packageName;
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    String invalidPackageName;
                    existingPackage = oldPackage = this.mPackages.get(pkgName11);
                    ps2 = this.mSettings.mPackages.get(pkgName11);
                    disabledPs = this.mSettings.getDisabledSystemPkgLPr(ps2);
                    KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                    if (ksms.shouldCheckUpgradeKeySetLocked(ps2, scanFlags)) {
                        if (!ksms.checkUpgradeKeySetLocked(ps2, pkg)) {
                            throw new PrepareFailure(-7, "New package not signed by keys specified by upgrade-keysets: " + pkgName11);
                        }
                    } else if (!pkg.mSigningDetails.checkCapability(oldPackage.mSigningDetails, 1) && !oldPackage.mSigningDetails.checkCapability(pkg.mSigningDetails, 8)) {
                        throw new PrepareFailure(-7, "New package has a different signature: " + pkgName11);
                    }
                    if (oldPackage.restrictUpdateHash != null && oldPackage.isSystem()) {
                        byte[] digestBytes;
                        try {
                            MessageDigest digest = MessageDigest.getInstance("SHA-512");
                            PackageManagerService.updateDigest(digest, new File(pkg.baseCodePath));
                            if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
                                String[] stringArray = pkg.splitCodePaths;
                                int n = stringArray.length;
                                for (int i = 0; i < n; ++i) {
                                    String path = stringArray[i];
                                    PackageManagerService.updateDigest(digest, new File(path));
                                }
                            }
                            digestBytes = digest.digest();
                        }
                        catch (IOException | NoSuchAlgorithmException e) {
                            throw new PrepareFailure(-2, "Could not compute hash: " + pkgName11);
                        }
                        if (!Arrays.equals(oldPackage.restrictUpdateHash, digestBytes)) {
                            throw new PrepareFailure(-2, "New package fails restrict-update check: " + pkgName11);
                        }
                        pkg.restrictUpdateHash = oldPackage.restrictUpdateHash;
                    }
                    if ((invalidPackageName = this.getParentOrChildPackageChangedSharedUser(oldPackage, pkg)) != null) {
                        throw new PrepareFailure(-8, "Package " + invalidPackageName + " tried to change user " + oldPackage.mSharedUserId);
                    }
                    allUsers = sUserManager.getUserIds();
                    installedUsers = ps2.queryInstalledUsers(allUsers, true);
                    if (isInstantApp) {
                        if (args.user == null || args.user.getIdentifier() == -1) {
                            for (int currentUser : allUsers) {
                                if (ps2.getInstantApp(currentUser)) continue;
                                Slog.w(TAG, "Can't replace full app with instant app: " + pkgName11 + " for user: " + currentUser);
                                throw new PrepareFailure(-116);
                            }
                        } else if (!ps2.getInstantApp(args.user.getIdentifier())) {
                            Slog.w(TAG, "Can't replace full app with instant app: " + pkgName11 + " for user: " + args.user.getIdentifier());
                            throw new PrepareFailure(-116);
                        }
                    }
                }
                res.removedInfo = new PackageRemovedInfo(this);
                res.removedInfo.uid = oldPackage.applicationInfo.uid;
                res.removedInfo.removedPackage = oldPackage.packageName;
                res.removedInfo.installerPackageName = ps2.installerPackageName;
                res.removedInfo.isStaticSharedLib = pkg.staticSharedLibName != null;
                res.removedInfo.isUpdate = true;
                res.removedInfo.origUsers = installedUsers;
                res.removedInfo.installReasons = new SparseArray(installedUsers.length);
                for (int i = 0; i < installedUsers.length; ++i) {
                    int userId = installedUsers[i];
                    res.removedInfo.installReasons.put(userId, ps2.getInstallReason(userId));
                }
                childPackages = this.mSettings.getChildSettingsLPr(ps2);
                if (childPackages != null) {
                    for (PackageSetting childPs : childPackages) {
                        PackageInstalledInfo childRes;
                        PackageParser.Package childPkg2;
                        boolean childPackageUpdated = false;
                        PackageParser.Package package_ = childPkg2 = childPs == null ? null : childPs.pkg;
                        if (res.addedChildPackages != null && (childRes = res.addedChildPackages.get(childPkg2.packageName)) != null) {
                            childRes.removedInfo.uid = childPkg2.applicationInfo.uid;
                            childRes.removedInfo.removedPackage = childPkg2.packageName;
                            if (childPs != null) {
                                childRes.removedInfo.installerPackageName = childPs.installerPackageName;
                            }
                            childRes.removedInfo.isUpdate = true;
                            childRes.removedInfo.installReasons = res.removedInfo.installReasons;
                            childPackageUpdated = true;
                        }
                        if (childPackageUpdated) continue;
                        PackageRemovedInfo childRemovedRes = new PackageRemovedInfo(this);
                        childRemovedRes.removedPackage = childPkg2.packageName;
                        if (childPs != null) {
                            childRemovedRes.installerPackageName = childPs.installerPackageName;
                        }
                        childRemovedRes.isUpdate = false;
                        childRemovedRes.dataRemoved = true;
                        ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
                        synchronized (arrayMap2) {
                            if (childPs != null) {
                                childRemovedRes.origUsers = childPs.queryInstalledUsers(allUsers, true);
                            }
                        }
                        if (res.removedInfo.removedChildPackages == null) {
                            res.removedInfo.removedChildPackages = new ArrayMap();
                        }
                        res.removedInfo.removedChildPackages.put(childPkg2.packageName, childRemovedRes);
                    }
                }
                if (sysPkg = PackageManagerService.isSystemApp(oldPackage)) {
                    boolean privileged = PackageManagerService.isPrivilegedApp(oldPackage);
                    boolean oem = PackageManagerService.isOemApp(oldPackage);
                    boolean vendor = PackageManagerService.isVendorApp(oldPackage);
                    boolean product = PackageManagerService.isProductApp(oldPackage);
                    boolean odm = PackageManagerService.isOdmApp(oldPackage);
                    int systemParseFlags = parseFlags;
                    int systemScanFlags = scanFlags | 0x20000 | (privileged ? 262144 : 0) | (oem ? 524288 : 0) | (vendor ? 0x100000 : 0) | (product ? 0x200000 : 0) | (odm ? 0x800000 : 0);
                    res.setReturnCode(1);
                    pkg.setApplicationInfoFlags(128, 128);
                    targetParseFlags = systemParseFlags;
                    targetScanFlags = systemScanFlags;
                } else {
                    replace = true;
                    String pkgName1 = oldPackage.packageName;
                    boolean deletedPkg = true;
                    boolean addedPkg = false;
                    boolean updatedSettings = false;
                    long l = pkg.mExtras != null ? ((PackageSetting)pkg.mExtras).lastUpdateTime : 0L;
                }
            } else {
                ps2 = null;
                childPackages = null;
                disabledPs = null;
                replace = false;
                existingPackage = null;
                String pkgName1 = pkg.packageName;
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    renamedPackage = this.mSettings.getRenamedPackageLPr(pkgName1);
                    if (renamedPackage != null) {
                        throw new PrepareFailure(-1, "Attempt to re-install " + pkgName1 + " without first uninstalling package running as " + renamedPackage);
                    }
                    if (this.mPackages.containsKey(pkgName1)) {
                        throw new PrepareFailure(-1, "Attempt to re-install " + pkgName1 + " without first uninstalling.");
                    }
                }
            }
            shouldCloseFreezerBeforeReturn = false;
            PrepareResult prepareResult = new PrepareResult(args.installReason, targetVolumeUuid, installerPackageName, args.user, replace, targetScanFlags, targetParseFlags, existingPackage, pkg, replace, sysPkg, renamedPackage, freezer, ps2, disabledPs, childPackages);
            return prepareResult;
        }
        finally {
            if (shouldCloseFreezerBeforeReturn) {
                freezer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpFsVerityIfPossible(PackageParser.Package pkg) throws Installer.InstallerException, PrepareFailure, IOException, DigestException, NoSuchAlgorithmException {
        boolean standardMode = PackageManagerServiceUtils.isApkVerityEnabled();
        boolean legacyMode = PackageManagerServiceUtils.isLegacyApkVerityEnabled();
        if (!standardMode && !legacyMode) {
            return;
        }
        ArrayMap<String, String> fsverityCandidates = new ArrayMap<String, String>();
        if (legacyMode) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                PackageSetting packageSetting = this.mSettings.mPackages.get(pkg.packageName);
                if (packageSetting != null && packageSetting.isPrivileged()) {
                    fsverityCandidates.put(pkg.baseCodePath, null);
                    if (pkg.splitCodePaths != null) {
                        for (String splitPath : pkg.splitCodePaths) {
                            fsverityCandidates.put(splitPath, null);
                        }
                    }
                }
            }
        } else {
            fsverityCandidates.put(pkg.baseCodePath, VerityUtils.getFsveritySignatureFilePath(pkg.baseCodePath));
            String dmPath = DexMetadataHelper.buildDexMetadataPathForApk(pkg.baseCodePath);
            if (new File(dmPath).exists()) {
                fsverityCandidates.put(dmPath, VerityUtils.getFsveritySignatureFilePath(dmPath));
            }
            if (pkg.splitCodePaths != null) {
                for (String path : pkg.splitCodePaths) {
                    fsverityCandidates.put(path, VerityUtils.getFsveritySignatureFilePath(path));
                    String splitDmPath = DexMetadataHelper.buildDexMetadataPathForApk(path);
                    if (!new File(splitDmPath).exists()) continue;
                    fsverityCandidates.put(splitDmPath, VerityUtils.getFsveritySignatureFilePath(splitDmPath));
                }
            }
        }
        for (Map.Entry entry : fsverityCandidates.entrySet()) {
            String filePath = (String)entry.getKey();
            String signaturePath = (String)entry.getValue();
            if (!legacyMode) {
                if (!new File(signaturePath).exists() || VerityUtils.hasFsverity(filePath)) continue;
                try {
                    VerityUtils.setUpFsverity(filePath, signaturePath);
                    continue;
                }
                catch (IOException | SecurityException | DigestException | NoSuchAlgorithmException e) {
                    throw new PrepareFailure(-118, "Failed to enable fs-verity: " + e);
                }
            }
            VerityUtils.SetupResult result = VerityUtils.generateApkVeritySetupData(filePath);
            if (result.isOk()) {
                if (Build.IS_DEBUGGABLE) {
                    Slog.i(TAG, "Enabling verity to " + filePath);
                }
                FileDescriptor fd = result.getUnownedFileDescriptor();
                try {
                    byte[] rootHash = VerityUtils.generateApkVerityRootHash(filePath);
                    try {
                        this.mInstaller.assertFsverityRootHashMatches(filePath, rootHash);
                    }
                    catch (Installer.InstallerException e) {
                        this.mInstaller.installApkVerity(filePath, fd, result.getContentSize());
                        this.mInstaller.assertFsverityRootHashMatches(filePath, rootHash);
                    }
                    continue;
                }
                finally {
                    IoUtils.closeQuietly(fd);
                    continue;
                }
            }
            if (!result.isFailed()) continue;
            throw new PrepareFailure(-118, "Failed to generate verity");
        }
    }

    private void startIntentFilterVerifications(int userId, boolean replacing, PackageParser.Package pkg) {
        if (this.mIntentFilterVerifierComponent == null) {
            Slog.w(TAG, "No IntentFilter verification will not be done as there is no IntentFilterVerifier available!");
            return;
        }
        int verifierUid = this.getPackageUid(this.mIntentFilterVerifierComponent.getPackageName(), 0x10000000, userId == -1 ? 0 : userId);
        Message msg = this.mHandler.obtainMessage(17);
        msg.obj = new IFVerificationParams(pkg, replacing, userId, verifierUid);
        this.mHandler.sendMessage(msg);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            msg = this.mHandler.obtainMessage(17);
            msg.obj = new IFVerificationParams(childPkg, replacing, userId, verifierUid);
            this.mHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyIntentFiltersIfNeeded(int userId, int verifierUid, boolean replacing, PackageParser.Package pkg) {
        int size = pkg.activities.size();
        if (size == 0) {
            return;
        }
        boolean hasDomainURLs = PackageManagerService.hasDomainURLs(pkg);
        if (!hasDomainURLs) {
            return;
        }
        int count = 0;
        String packageName = pkg.packageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            IntentFilterVerificationInfo ivi;
            if (!replacing && (ivi = this.mSettings.getIntentFilterVerificationLPr(packageName)) != null) {
                return;
            }
            boolean needToVerify = false;
            block3: for (PackageParser.Activity a : pkg.activities) {
                for (PackageParser.ActivityIntentInfo filter : a.intents) {
                    if (!filter.needsVerification() || !this.needsNetworkVerificationLPr(filter)) continue;
                    needToVerify = true;
                    continue block3;
                }
            }
            if (needToVerify) {
                int verificationId = this.mIntentFilterVerificationToken++;
                for (PackageParser.Activity a : pkg.activities) {
                    for (PackageParser.ActivityIntentInfo filter : a.intents) {
                        if (!filter.handlesWebUris(true) || !this.needsNetworkVerificationLPr(filter)) continue;
                        this.mIntentFilterVerifier.addOneIntentFilterVerification(verifierUid, userId, verificationId, filter, packageName);
                        ++count;
                    }
                }
            }
        }
        if (count > 0) {
            this.mIntentFilterVerifier.startVerifications(userId);
        }
    }

    @GuardedBy(value={"mPackages"})
    private boolean needsNetworkVerificationLPr(PackageParser.ActivityIntentInfo filter) {
        ComponentName cn = filter.activity.getComponentName();
        String packageName = cn.getPackageName();
        IntentFilterVerificationInfo ivi = this.mSettings.getIntentFilterVerificationLPr(packageName);
        if (ivi == null) {
            return true;
        }
        int status = ivi.getStatus();
        switch (status) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private static boolean isMultiArch(ApplicationInfo info) {
        return (info.flags & Integer.MIN_VALUE) != 0;
    }

    private static boolean isExternal(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x40000) != 0;
    }

    private static boolean isExternal(PackageSetting ps) {
        return (ps.pkgFlags & 0x40000) != 0;
    }

    private static boolean isSystemApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 1) != 0;
    }

    private static boolean isPrivilegedApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 8) != 0;
    }

    private static boolean isOemApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 0x20000) != 0;
    }

    private static boolean isVendorApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 0x40000) != 0;
    }

    private static boolean isProductApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 0x80000) != 0;
    }

    private static boolean isProductServicesApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 0x200000) != 0;
    }

    private static boolean isOdmApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 0x40000000) != 0;
    }

    private static boolean hasDomainURLs(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 0x10) != 0;
    }

    private static boolean isSystemApp(PackageSetting ps) {
        return (ps.pkgFlags & 1) != 0;
    }

    private static boolean isUpdatedSystemApp(PackageSetting ps) {
        return (ps.pkgFlags & 0x80) != 0;
    }

    private Settings.VersionInfo getSettingsVersionForPackage(PackageParser.Package pkg) {
        if (PackageManagerService.isExternal(pkg)) {
            if (TextUtils.isEmpty(pkg.volumeUuid)) {
                return this.mSettings.getExternalVersion();
            }
            return this.mSettings.findOrCreateVersion(pkg.volumeUuid);
        }
        return this.mSettings.getInternalVersion();
    }

    private void deleteTempPackageFiles() {
        FilenameFilter filter = (dir, name) -> name.startsWith("vmdl") && name.endsWith(".tmp");
    }

    @Override
    public void deletePackageAsUser(String packageName, int versionCode, IPackageDeleteObserver observer, int userId, int flags) {
        this.deletePackageVersioned(new VersionedPackage(packageName, versionCode), new PackageManager.LegacyPackageDeleteObserver(observer).getBinder(), userId, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePackageVersioned(VersionedPackage versionedPackage, IPackageDeleteObserver2 observer, int userId, int deleteFlags) {
        int[] nArray;
        boolean deleteAllUsers;
        String internalPackageName;
        int callingUid = Binder.getCallingUid();
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_PACKAGES", null);
        boolean canViewInstantApps = this.canViewInstantApps(callingUid, userId);
        Preconditions.checkNotNull(versionedPackage);
        Preconditions.checkNotNull(observer);
        Preconditions.checkArgumentInRange(versionedPackage.getLongVersionCode(), -1L, Long.MAX_VALUE, "versionCode must be >= -1");
        String packageName = versionedPackage.getPackageName();
        long versionCode = versionedPackage.getLongVersionCode();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            internalPackageName = this.resolveInternalPackageNameLPr(packageName, versionCode);
        }
        int uid = Binder.getCallingUid();
        if (!this.isOrphaned(internalPackageName) && !this.isCallerAllowedToSilentlyUninstall(uid, internalPackageName)) {
            this.mHandler.post(() -> {
                try {
                    Intent intent = new Intent("android.intent.action.UNINSTALL_PACKAGE");
                    intent.setData(Uri.fromParts(PACKAGE_SCHEME, packageName, null));
                    intent.putExtra("android.content.pm.extra.CALLBACK", observer.asBinder());
                    observer.onUserActionRequired(intent);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            });
            return;
        }
        boolean bl = deleteAllUsers = (deleteFlags & 2) != 0;
        if (deleteAllUsers) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userId;
        }
        int[] users = nArray;
        if (UserHandle.getUserId(uid) != userId || deleteAllUsers && users.length > 1) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "deletePackage for user " + userId);
        }
        if (this.isUserRestricted(userId, "no_uninstall_apps")) {
            this.mHandler.post(() -> {
                try {
                    observer.onPackageDeleted(packageName, -3, null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            });
            return;
        }
        if (!deleteAllUsers && this.getBlockUninstallForUser(internalPackageName, userId)) {
            this.mHandler.post(() -> {
                try {
                    observer.onPackageDeleted(packageName, -4, null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            });
            return;
        }
        this.mHandler.post(() -> {
            int returnCode;
            PackageSetting ps = this.mSettings.mPackages.get(internalPackageName);
            boolean doDeletePackage = true;
            if (ps != null) {
                boolean targetIsInstantApp = ps.getInstantApp(UserHandle.getUserId(callingUid));
                boolean bl = doDeletePackage = !targetIsInstantApp || canViewInstantApps;
            }
            if (doDeletePackage) {
                if (!deleteAllUsers) {
                    returnCode = this.deletePackageX(internalPackageName, versionCode, userId, deleteFlags);
                } else {
                    int[] blockUninstallUserIds = this.getBlockUninstallForUsers(internalPackageName, users);
                    if (ArrayUtils.isEmpty(blockUninstallUserIds)) {
                        returnCode = this.deletePackageX(internalPackageName, versionCode, userId, deleteFlags);
                    } else {
                        int userFlags = deleteFlags & 0xFFFFFFFD;
                        for (int userId1 : users) {
                            if (ArrayUtils.contains(blockUninstallUserIds, userId1) || (returnCode = this.deletePackageX(internalPackageName, versionCode, userId1, userFlags)) == 1) continue;
                            Slog.w(TAG, "Package delete failed for user " + userId1 + ", returnCode " + returnCode);
                        }
                        returnCode = -4;
                    }
                }
            } else {
                returnCode = -1;
            }
            try {
                observer.onPackageDeleted(packageName, returnCode, null);
            }
            catch (RemoteException e) {
                Log.i(TAG, "Observer no longer exists.");
            }
        });
    }

    private String resolveExternalPackageNameLPr(PackageParser.Package pkg) {
        if (pkg.staticSharedLibName != null) {
            return pkg.manifestPackageName;
        }
        return pkg.packageName;
    }

    @GuardedBy(value={"mPackages"})
    private String resolveInternalPackageNameLPr(String packageName, long versionCode) {
        String normalizedPackageName = this.mSettings.getRenamedPackageLPr(packageName);
        LongSparseArray<SharedLibraryInfo> versionedLib = this.mStaticLibsByDeclaringPackage.get(packageName = normalizedPackageName != null ? normalizedPackageName : packageName);
        if (versionedLib == null || versionedLib.size() <= 0) {
            return packageName;
        }
        LongSparseLongArray versionsCallerCanSee = null;
        int callingAppId = UserHandle.getAppId(Binder.getCallingUid());
        if (callingAppId != 1000 && callingAppId != 2000 && callingAppId != 0) {
            versionsCallerCanSee = new LongSparseLongArray();
            String libName = versionedLib.valueAt(0).getName();
            String[] uidPackages = this.getPackagesForUid(Binder.getCallingUid());
            if (uidPackages != null) {
                for (String uidPackage : uidPackages) {
                    PackageSetting ps = this.mSettings.getPackageLPr(uidPackage);
                    int libIdx = ArrayUtils.indexOf(ps.usesStaticLibraries, libName);
                    if (libIdx < 0) continue;
                    long libVersion = ps.usesStaticLibrariesVersions[libIdx];
                    versionsCallerCanSee.append(libVersion, libVersion);
                }
            }
        }
        if (versionsCallerCanSee != null && versionsCallerCanSee.size() <= 0) {
            return packageName;
        }
        SharedLibraryInfo highestVersion = null;
        int versionCount = versionedLib.size();
        for (int i = 0; i < versionCount; ++i) {
            SharedLibraryInfo libraryInfo = versionedLib.valueAt(i);
            if (versionsCallerCanSee != null && versionsCallerCanSee.indexOfKey(libraryInfo.getLongVersion()) < 0) continue;
            long libVersionCode = libraryInfo.getDeclaringPackage().getLongVersionCode();
            if (versionCode != -1L) {
                if (libVersionCode != versionCode) continue;
                return libraryInfo.getPackageName();
            }
            if (highestVersion == null) {
                highestVersion = libraryInfo;
                continue;
            }
            if (libVersionCode <= highestVersion.getDeclaringPackage().getLongVersionCode()) continue;
            highestVersion = libraryInfo;
        }
        if (highestVersion != null) {
            return highestVersion.getPackageName();
        }
        return packageName;
    }

    boolean isCallerVerifier(int callingUid) {
        int callingUserId = UserHandle.getUserId(callingUid);
        return this.mRequiredVerifierPackage != null && callingUid == this.getPackageUid(this.mRequiredVerifierPackage, 0, callingUserId);
    }

    private boolean isCallerAllowedToSilentlyUninstall(int callingUid, String pkgName) {
        if (callingUid == 2000 || callingUid == 0 || UserHandle.getAppId(callingUid) == 1000) {
            return true;
        }
        int callingUserId = UserHandle.getUserId(callingUid);
        if (callingUid == this.getPackageUid(this.getInstallerPackageName(pkgName), 0, callingUserId)) {
            return true;
        }
        if (this.mRequiredVerifierPackage != null && callingUid == this.getPackageUid(this.mRequiredVerifierPackage, 0, callingUserId)) {
            return true;
        }
        if (this.mRequiredUninstallerPackage != null && callingUid == this.getPackageUid(this.mRequiredUninstallerPackage, 0, callingUserId)) {
            return true;
        }
        if (this.mStorageManagerPackage != null && callingUid == this.getPackageUid(this.mStorageManagerPackage, 0, callingUserId)) {
            return true;
        }
        return this.checkUidPermission("android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS", callingUid) == 0;
    }

    private int[] getBlockUninstallForUsers(String packageName, int[] userIds) {
        int[] result = EMPTY_INT_ARRAY;
        for (int userId : userIds) {
            if (!this.getBlockUninstallForUser(packageName, userId)) continue;
            result = ArrayUtils.appendInt(result, userId);
        }
        return result;
    }

    @Override
    public boolean isPackageDeviceAdminOnAnyUser(String packageName) {
        int callingUid = Binder.getCallingUid();
        if (this.checkUidPermission("android.permission.MANAGE_USERS", callingUid) != 0) {
            EventLog.writeEvent(1397638484, "128599183", -1, "");
            throw new SecurityException("android.permission.MANAGE_USERS permission is required to call this API");
        }
        if (this.getInstantAppPackageName(callingUid) != null && !this.isCallerSameApp(packageName, callingUid)) {
            return false;
        }
        return this.isPackageDeviceAdmin(packageName, -1);
    }

    private boolean isPackageDeviceAdmin(String packageName, int userId) {
        IDevicePolicyManager dpm = IDevicePolicyManager.Stub.asInterface(ServiceManager.getService("device_policy"));
        try {
            if (dpm != null) {
                String deviceOwnerPackageName;
                ComponentName deviceOwnerComponentName = dpm.getDeviceOwnerComponent(false);
                String string2 = deviceOwnerPackageName = deviceOwnerComponentName == null ? null : deviceOwnerComponentName.getPackageName();
                if (packageName.equals(deviceOwnerPackageName)) {
                    return true;
                }
                int[] users = userId == -1 ? sUserManager.getUserIds() : new int[]{userId};
                for (int i = 0; i < users.length; ++i) {
                    if (!dpm.packageHasActiveAdmins(packageName, users[i])) continue;
                    return true;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private boolean shouldKeepUninstalledPackageLPr(String packageName) {
        return this.mKeepUninstalledPackages != null && this.mKeepUninstalledPackages.contains(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deletePackageX(String packageName, long versionCode, int userId, int deleteFlags) {
        boolean res;
        Object object;
        Object libraryInfo;
        int[] allUsers;
        PackageParser.Package pkg;
        int origEnabledState;
        PackageSetting disabledSystemPs;
        PackageSetting uninstalledPs;
        int removeUser;
        PackageRemovedInfo info = new PackageRemovedInfo(this);
        int n = removeUser = (deleteFlags & 2) != 0 ? -1 : userId;
        if (this.isPackageDeviceAdmin(packageName, removeUser)) {
            Slog.w(TAG, "Not removing package " + packageName + ": has active device admin");
            return -2;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            uninstalledPs = this.mSettings.mPackages.get(packageName);
            if (uninstalledPs == null) {
                Slog.w(TAG, "Not removing non-existent package " + packageName);
                return -1;
            }
            if (versionCode != -1L && uninstalledPs.versionCode != versionCode) {
                Slog.w(TAG, "Not removing package " + packageName + " with versionCode " + uninstalledPs.versionCode + " != " + versionCode);
                return -1;
            }
            disabledSystemPs = this.mSettings.getDisabledSystemPkgLPr(packageName);
            origEnabledState = uninstalledPs == null ? 0 : uninstalledPs.getEnabled(userId);
            pkg = this.mPackages.get(packageName);
            allUsers = sUserManager.getUserIds();
            if (pkg != null && pkg.staticSharedLibName != null && (libraryInfo = this.getSharedLibraryInfoLPr(pkg.staticSharedLibName, pkg.staticSharedLibVersion)) != null) {
                for (int currUserId : allUsers) {
                    List<VersionedPackage> libClientPackages;
                    if (removeUser != -1 && removeUser != currUserId || ArrayUtils.isEmpty(libClientPackages = this.getPackagesUsingSharedLibraryLPr((SharedLibraryInfo)libraryInfo, 0, currUserId))) continue;
                    Slog.w(TAG, "Not removing package " + pkg.manifestPackageName + " hosting lib " + ((SharedLibraryInfo)libraryInfo).getName() + " version " + ((SharedLibraryInfo)libraryInfo).getLongVersion() + " used by " + libClientPackages + " for user " + currUserId);
                    return -6;
                }
            }
            info.origUsers = uninstalledPs.queryInstalledUsers(allUsers, true);
        }
        int freezeUser = PackageManagerService.isUpdatedSystemApp(uninstalledPs) && (deleteFlags & 4) == 0 ? -1 : removeUser;
        libraryInfo = this.mInstallLock;
        synchronized (libraryInfo) {
            object = null;
            try (Object freezer = this.freezePackageForDelete(packageName, freezeUser, deleteFlags, "deletePackageX");){
                res = this.deletePackageLIF(packageName, UserHandle.of(removeUser), true, allUsers, deleteFlags | Integer.MIN_VALUE, info, true, null);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            freezer = this.mPackages;
            synchronized (freezer) {
                if (res) {
                    if (pkg != null) {
                        this.mInstantAppRegistry.onPackageUninstalledLPw(pkg, info.removedUsers);
                    }
                    this.updateSequenceNumberLP(uninstalledPs, info.removedUsers);
                    this.updateInstantAppInstallerLocked(packageName);
                }
            }
        }
        if (res) {
            boolean killApp = (deleteFlags & 8) == 0;
            info.sendPackageRemovedBroadcasts(killApp);
            info.sendSystemPackageUpdatedBroadcasts();
            info.sendSystemPackageAppearedBroadcasts();
        }
        Runtime.getRuntime().gc();
        Object object2 = this.mInstallLock;
        synchronized (object2) {
            PackageParser.Package stubPkg;
            if (info.args != null) {
                info.args.doPostDeleteLI(true);
            }
            PackageParser.Package package_ = stubPkg = disabledSystemPs == null ? null : disabledSystemPs.pkg;
            if (stubPkg != null && stubPkg.isStub) {
                object = this.mPackages;
                synchronized (object) {
                    PackageSetting stubPs = this.mSettings.mPackages.get(stubPkg.packageName);
                    if (stubPs != null) {
                        stubPs.setEnabled(origEnabledState, userId, PLATFORM_PACKAGE_NAME);
                    }
                }
                if (origEnabledState == 0 || origEnabledState == 1) {
                    if (DEBUG_COMPRESSION) {
                        Slog.i(TAG, "Enabling system stub after removal; pkg: " + stubPkg.packageName);
                    }
                    this.enableCompressedPackage(stubPkg);
                }
            }
        }
        return res ? 1 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePackageDataLIF(PackageSetting deletedPs, int[] allUserHandles, PackageRemovedInfo outInfo, int flags, boolean writeSettings) {
        String packageName = deletedPs.name;
        PackageParser.Package deletedPkg = deletedPs.pkg;
        if (outInfo != null) {
            outInfo.removedPackage = packageName;
            outInfo.installerPackageName = deletedPs.installerPackageName;
            outInfo.isStaticSharedLib = deletedPkg != null && deletedPkg.staticSharedLibName != null;
            outInfo.populateUsers(deletedPs == null ? null : deletedPs.queryInstalledUsers(sUserManager.getUserIds(), true), deletedPs);
        }
        this.removePackageLI(deletedPs.name, (flags & Integer.MIN_VALUE) != 0);
        if ((flags & 1) == 0) {
            PackageParser.Package resolvedPkg;
            if (deletedPkg != null) {
                resolvedPkg = deletedPkg;
            } else {
                resolvedPkg = new PackageParser.Package(deletedPs.name);
                resolvedPkg.setVolumeUuid(deletedPs.volumeUuid);
            }
            this.destroyAppDataLIF(resolvedPkg, -1, 7);
            this.destroyAppProfilesLIF(resolvedPkg);
            if (outInfo != null) {
                outInfo.dataRemoved = true;
            }
        }
        int removedAppId = -1;
        boolean installedStateChanged = false;
        if (deletedPs != null) {
            if ((flags & 1) == 0) {
                SparseBooleanArray changedUsers = new SparseBooleanArray();
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    this.clearIntentFilterVerificationsLPw(deletedPs.name, -1);
                    this.clearDefaultBrowserIfNeeded(packageName);
                    this.mSettings.mKeySetManagerService.removeAppKeySetDataLPw(packageName);
                    removedAppId = this.mSettings.removePackageLPw(packageName);
                    if (outInfo != null) {
                        outInfo.removedAppId = removedAppId;
                    }
                    this.mPermissionManager.updatePermissions(deletedPs.name, null, false, this.mPackages.values(), this.mPermissionCallback);
                    if (deletedPs.sharedUser != null) {
                        for (int userId : UserManagerService.getInstance().getUserIds()) {
                            int userIdToKill = this.mSettings.updateSharedUserPermsLPw(deletedPs, userId);
                            if (userIdToKill != -1 && userIdToKill < 0) continue;
                            this.mHandler.post(() -> this.killApplication(deletedPs.name, deletedPs.appId, KILL_APP_REASON_GIDS_CHANGED));
                            break;
                        }
                    }
                    this.clearPackagePreferredActivitiesLPw(deletedPs.name, changedUsers, -1);
                }
                if (changedUsers.size() > 0) {
                    this.updateDefaultHomeNotLocked(changedUsers);
                    this.postPreferredActivityChangedBroadcast(-1);
                }
            }
            if (allUserHandles != null && outInfo != null && outInfo.origUsers != null) {
                for (Object userId : (ArrayMap<String, PackageParser.Package>)allUserHandles) {
                    boolean installed = ArrayUtils.contains(outInfo.origUsers, (int)userId);
                    if (installed != deletedPs.getInstalled((int)userId)) {
                        installedStateChanged = true;
                    }
                    deletedPs.setInstalled(installed, (int)userId);
                }
            }
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
            if (installedStateChanged) {
                this.mSettings.writeKernelMappingLPr(deletedPs);
            }
        }
        if (removedAppId != -1) {
            PackageManagerService.removeKeystoreDataIfNeeded(-1, removedAppId);
        }
    }

    static boolean locationIsPrivileged(String path) {
        try {
            File privilegedAppDir = new File(Environment.getRootDirectory(), "priv-app");
            File privilegedVendorAppDir = new File(Environment.getVendorDirectory(), "priv-app");
            File privilegedOdmAppDir = new File(Environment.getOdmDirectory(), "priv-app");
            File privilegedProductAppDir = new File(Environment.getProductDirectory(), "priv-app");
            File privilegedProductServicesAppDir = new File(Environment.getProductServicesDirectory(), "priv-app");
            return path.startsWith(privilegedAppDir.getCanonicalPath() + "/") || path.startsWith(privilegedVendorAppDir.getCanonicalPath() + "/") || path.startsWith(privilegedOdmAppDir.getCanonicalPath() + "/") || path.startsWith(privilegedProductAppDir.getCanonicalPath() + "/") || path.startsWith(privilegedProductServicesAppDir.getCanonicalPath() + "/");
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to access code path " + path);
            return false;
        }
    }

    static boolean locationIsOem(String path) {
        try {
            return path.startsWith(Environment.getOemDirectory().getCanonicalPath() + "/");
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to access code path " + path);
            return false;
        }
    }

    static boolean locationIsVendor(String path) {
        try {
            return path.startsWith(Environment.getVendorDirectory().getCanonicalPath() + "/") || path.startsWith(Environment.getOdmDirectory().getCanonicalPath() + "/");
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to access code path " + path);
            return false;
        }
    }

    static boolean locationIsProduct(String path) {
        try {
            return path.startsWith(Environment.getProductDirectory().getCanonicalPath() + "/");
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to access code path " + path);
            return false;
        }
    }

    static boolean locationIsProductServices(String path) {
        try {
            return path.startsWith(Environment.getProductServicesDirectory().getCanonicalPath() + "/");
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to access code path " + path);
            return false;
        }
    }

    static boolean locationIsOdm(String path) {
        try {
            return path.startsWith(Environment.getOdmDirectory().getCanonicalPath() + "/");
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to access code path " + path);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSystemPackageLIF(DeletePackageAction action, PackageSetting deletedPs, int[] allUserHandles, int flags, PackageRemovedInfo outInfo, boolean writeSettings) throws SystemDeleteException {
        boolean applyUserRestrictions = allUserHandles != null && outInfo.origUsers != null;
        PackageParser.Package deletedPkg = deletedPs.pkg;
        PackageSetting disabledPs = action.disabledPs;
        Slog.d(TAG, "Deleting system pkg from data partition");
        outInfo.isRemovedPackageSystemUpdate = true;
        if (outInfo.removedChildPackages != null) {
            int childCount = deletedPs.childPackageNames != null ? deletedPs.childPackageNames.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                PackageRemovedInfo childInfo;
                String childPackageName = (String)deletedPs.childPackageNames.get(i);
                if (disabledPs.childPackageNames == null || !disabledPs.childPackageNames.contains(childPackageName) || (childInfo = outInfo.removedChildPackages.get(childPackageName)) == null) continue;
                childInfo.isRemovedPackageSystemUpdate = true;
            }
        }
        flags = disabledPs.versionCode < deletedPs.versionCode ? (flags &= 0xFFFFFFFE) : (flags |= 1);
        this.deleteInstalledPackageLIF(deletedPs, true, flags, allUserHandles, outInfo, writeSettings, disabledPs.pkg);
        ArrayMap<String, PackageParser.Package> childCount = this.mPackages;
        synchronized (childCount) {
            this.enableSystemPackageLPw(disabledPs.pkg);
            this.removeNativeBinariesLI(deletedPs);
        }
        try {
            this.installPackageFromSystemLIF(disabledPs.codePathString, allUserHandles, outInfo.origUsers, deletedPs.getPermissionsState(), writeSettings);
        }
        catch (PackageManagerException e) {
            Slog.w(TAG, "Failed to restore system package:" + deletedPkg.packageName + ": " + e.getMessage());
            throw new SystemDeleteException(e);
        }
        finally {
            PackageSetting stubPs;
            if (disabledPs.pkg.isStub && (stubPs = this.mSettings.mPackages.get(deletedPkg.packageName)) != null) {
                stubPs.setEnabled(2, 0, PLATFORM_PACKAGE_NAME);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package installPackageFromSystemLIF(String codePathString, int[] allUserHandles, int[] origUserHandles, PermissionsState origPermissionState, boolean writeSettings) throws PackageManagerException {
        int parseFlags = this.mDefParseFlags | 1 | 0x10;
        int scanFlags = 131072;
        if (PackageManagerService.locationIsPrivileged(codePathString)) {
            scanFlags |= 0x40000;
        }
        if (PackageManagerService.locationIsOem(codePathString)) {
            scanFlags |= 0x80000;
        }
        if (PackageManagerService.locationIsVendor(codePathString)) {
            scanFlags |= 0x100000;
        }
        if (PackageManagerService.locationIsProduct(codePathString)) {
            scanFlags |= 0x200000;
        }
        if (PackageManagerService.locationIsProductServices(codePathString)) {
            scanFlags |= 0x400000;
        }
        if (PackageManagerService.locationIsOdm(codePathString)) {
            scanFlags |= 0x800000;
        }
        File codePath = new File(codePathString);
        PackageParser.Package pkg = this.scanPackageTracedLI(codePath, parseFlags, scanFlags, 0L, null);
        try {
            this.updateSharedLibrariesLocked(pkg, null, Collections.unmodifiableMap(this.mPackages));
        }
        catch (PackageManagerException e) {
            Slog.e(TAG, "updateAllSharedLibrariesLPw failed: " + e.getMessage());
        }
        this.prepareAppDataAfterInstallLIF(pkg);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean applyUserRestrictions;
            PackageSetting ps = this.mSettings.mPackages.get(pkg.packageName);
            if (origPermissionState != null) {
                ps.getPermissionsState().copyFrom(origPermissionState);
            }
            this.mPermissionManager.updatePermissions(pkg.packageName, pkg, true, this.mPackages.values(), this.mPermissionCallback);
            boolean bl = applyUserRestrictions = allUserHandles != null && origUserHandles != null;
            if (applyUserRestrictions) {
                boolean installedStateChanged = false;
                for (int userId : allUserHandles) {
                    boolean installed = ArrayUtils.contains(origUserHandles, userId);
                    if (installed != ps.getInstalled(userId)) {
                        installedStateChanged = true;
                    }
                    ps.setInstalled(installed, userId);
                    this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
                }
                this.mSettings.writeAllUsersPackageRestrictionsLPr();
                if (installedStateChanged) {
                    this.mSettings.writeKernelMappingLPr(ps);
                }
            }
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInstalledPackageLIF(PackageSetting ps, boolean deleteCodeAndResources, int flags, int[] allUserHandles, PackageRemovedInfo outInfo, boolean writeSettings, PackageParser.Package replacingPackage) {
        Object childPackageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (outInfo != null) {
                outInfo.uid = ps.appId;
            }
            if (outInfo != null && outInfo.removedChildPackages != null) {
                int childCount = ps.childPackageNames != null ? ps.childPackageNames.size() : 0;
                for (int i = 0; i < childCount; ++i) {
                    childPackageName = (String)ps.childPackageNames.get(i);
                    PackageSetting childPs = this.mSettings.mPackages.get(childPackageName);
                    PackageRemovedInfo childInfo = outInfo.removedChildPackages.get(childPackageName);
                    if (childInfo == null) continue;
                    childInfo.uid = childPs.appId;
                }
            }
        }
        this.removePackageDataLIF(ps, allUserHandles, outInfo, flags, writeSettings);
        int childCount = ps.childPackageNames != null ? ps.childPackageNames.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageSetting childPs;
            childPackageName = this.mPackages;
            synchronized (childPackageName) {
                childPs = this.mSettings.getPackageLPr((String)ps.childPackageNames.get(i));
            }
            if (childPs == null) continue;
            PackageRemovedInfo childOutInfo = outInfo != null && outInfo.removedChildPackages != null ? outInfo.removedChildPackages.get(childPs.name) : null;
            int deleteFlags = (flags & 1) != 0 && replacingPackage != null && !replacingPackage.hasChildPackage(childPs.name) ? flags & 0xFFFFFFFE : flags;
            this.removePackageDataLIF(childPs, allUserHandles, childOutInfo, deleteFlags, writeSettings);
        }
        if (ps.parentPackageName == null && deleteCodeAndResources && outInfo != null) {
            outInfo.args = this.createInstallArgsForExisting(ps.codePathString, ps.resourcePathString, InstructionSets.getAppDexInstructionSets(ps));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBlockUninstallForUser(String packageName, boolean blockUninstall, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_PACKAGES", null);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg != null && pkg.staticSharedLibName != null) {
                Slog.w(TAG, "Cannot block uninstall of package: " + packageName + " providing static shared library: " + pkg.staticSharedLibName);
                return false;
            }
            this.mSettings.setBlockUninstallLPw(userId, packageName, blockUninstall);
            this.mSettings.writePackageRestrictionsLPr(userId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBlockUninstallForUser(String packageName, int userId) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || this.filterAppAccessLPr(ps, Binder.getCallingUid(), userId)) {
                return false;
            }
            return this.mSettings.getBlockUninstallLPr(userId, packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setRequiredForSystemUser(String packageName, boolean systemUserApp) {
        PackageManagerService.enforceSystemOrRoot("setRequiredForSystemUser can only be run by the system or root");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Log.w(TAG, "Package doesn't exist: " + packageName);
                return false;
            }
            ps.pkgPrivateFlags = systemUserApp ? (ps.pkgPrivateFlags |= 0x200) : (ps.pkgPrivateFlags &= 0xFFFFFDFF);
            this.mSettings.writeLPr();
        }
        return true;
    }

    @GuardedBy(value={"mPackages"})
    private static DeletePackageAction mayDeletePackageLocked(PackageRemovedInfo outInfo, PackageSetting ps, PackageSetting disabledPs, PackageSetting[] children, int flags, UserHandle user) {
        int childCount;
        if (ps == null) {
            return null;
        }
        if (PackageManagerService.isSystemApp(ps)) {
            boolean deleteAllUsers;
            if (ps.parentPackageName != null) {
                Slog.w(TAG, "Attempt to delete child system package " + ps.pkg.packageName);
                return null;
            }
            boolean deleteSystem = (flags & 4) != 0;
            boolean bl = deleteAllUsers = user == null || user.getIdentifier() == -1;
            if ((!deleteSystem || deleteAllUsers) && disabledPs == null) {
                Slog.w(TAG, "Attempt to delete unknown system package " + ps.pkg.packageName);
                return null;
            }
        }
        int parentReferenceCount = ps.childPackageNames != null ? ps.childPackageNames.size() : 0;
        int n = childCount = children != null ? children.length : 0;
        if (childCount != parentReferenceCount) {
            return null;
        }
        if (childCount != 0 && outInfo != null && outInfo.removedChildPackages != null) {
            for (PackageSetting child : children) {
                if (child != null && ps.childPackageNames.contains(child.name)) continue;
                return null;
            }
        }
        return new DeletePackageAction(ps, disabledPs, outInfo, flags, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePackageLIF(String packageName, UserHandle user, boolean deleteCodeAndResources, int[] allUserHandles, int flags, PackageRemovedInfo outInfo, boolean writeSettings, PackageParser.Package replacingPackage) {
        DeletePackageAction action;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            PackageSetting disabledPs = this.mSettings.getDisabledSystemPkgLPr(ps);
            PackageSetting[] children = this.mSettings.getChildSettingsLPr(ps);
            action = PackageManagerService.mayDeletePackageLocked(outInfo, ps, disabledPs, children, flags, user);
        }
        if (null == action) {
            return false;
        }
        try {
            this.executeDeletePackageLIF(action, packageName, deleteCodeAndResources, allUserHandles, writeSettings, replacingPackage);
        }
        catch (SystemDeleteException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDeletePackageLIF(DeletePackageAction action, String packageName, boolean deleteCodeAndResources, int[] allUserHandles, boolean writeSettings, PackageParser.Package replacingPackage) throws SystemDeleteException {
        PackageSetting childPs;
        int i;
        int userId;
        PackageSetting ps = action.deletingPs;
        PackageRemovedInfo outInfo = action.outInfo;
        UserHandle user = action.user;
        int flags = action.flags;
        boolean systemApp = PackageManagerService.isSystemApp(ps);
        if (!(ps.parentPackageName == null || systemApp && (flags & 4) == 0)) {
            int removedUserId = user != null ? user.getIdentifier() : -1;
            this.clearPackageStateForUserLIF(ps, removedUserId, outInfo, flags);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.markPackageUninstalledForUserLPw(ps, user);
                this.scheduleWritePackageRestrictionsLocked(user);
            }
            return;
        }
        int n = userId = user == null ? -1 : user.getIdentifier();
        if (ps.getPermissionsState().hasPermission("android.permission.SUSPEND_APPS", userId)) {
            this.unsuspendForSuspendingPackage(packageName, userId);
        }
        if (!(systemApp && (flags & 4) == 0 || userId == -1)) {
            boolean clearPackageStateAndReturn;
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.markPackageUninstalledForUserLPw(ps, user);
                if (!systemApp) {
                    boolean keepUninstalledPackage = this.shouldKeepUninstalledPackageLPr(packageName);
                    if (ps.isAnyInstalled(sUserManager.getUserIds()) || keepUninstalledPackage) {
                        clearPackageStateAndReturn = true;
                    } else {
                        ps.setInstalled(true, userId);
                        this.mSettings.writeKernelMappingLPr(ps);
                        clearPackageStateAndReturn = false;
                    }
                } else {
                    clearPackageStateAndReturn = true;
                }
            }
            if (clearPackageStateAndReturn) {
                this.clearPackageStateForUserLIF(ps, userId, outInfo, flags);
                arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    this.scheduleWritePackageRestrictionsLocked(user);
                }
                return;
            }
        }
        if (ps.childPackageNames != null && outInfo != null) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                int childCount = ps.childPackageNames.size();
                outInfo.removedChildPackages = new ArrayMap(childCount);
                for (i = 0; i < childCount; ++i) {
                    String childPackageName = (String)ps.childPackageNames.get(i);
                    PackageRemovedInfo childInfo = new PackageRemovedInfo(this);
                    childInfo.removedPackage = childPackageName;
                    childInfo.installerPackageName = ps.installerPackageName;
                    outInfo.removedChildPackages.put(childPackageName, childInfo);
                    childPs = this.mSettings.getPackageLPr(childPackageName);
                    if (childPs == null) continue;
                    childInfo.origUsers = childPs.queryInstalledUsers(allUserHandles, true);
                }
            }
        }
        if (systemApp) {
            this.deleteSystemPackageLIF(action, ps, allUserHandles, flags, outInfo, writeSettings);
        } else {
            this.deleteInstalledPackageLIF(ps, deleteCodeAndResources, flags, allUserHandles, outInfo, writeSettings, replacingPackage);
        }
        if (outInfo != null) {
            boolean bl = outInfo.removedForAllUsers = this.mPackages.get(ps.name) == null;
            if (outInfo.removedChildPackages != null) {
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    int childCount = outInfo.removedChildPackages.size();
                    for (i = 0; i < childCount; ++i) {
                        PackageRemovedInfo childInfo = outInfo.removedChildPackages.valueAt(i);
                        if (childInfo == null) continue;
                        childInfo.removedForAllUsers = this.mPackages.get(childInfo.removedPackage) == null;
                    }
                }
            }
            if (systemApp) {
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    PackageSetting updatedPs = this.mSettings.getPackageLPr(ps.name);
                    int childCount = updatedPs.childPackageNames != null ? updatedPs.childPackageNames.size() : 0;
                    for (int i2 = 0; i2 < childCount; ++i2) {
                        String childPackageName = (String)updatedPs.childPackageNames.get(i2);
                        if (outInfo.removedChildPackages != null && outInfo.removedChildPackages.indexOfKey(childPackageName) >= 0 || (childPs = this.mSettings.getPackageLPr(childPackageName)) == null) continue;
                        PackageInstalledInfo installRes = new PackageInstalledInfo();
                        installRes.name = childPackageName;
                        installRes.newUsers = childPs.queryInstalledUsers(allUserHandles, true);
                        installRes.pkg = this.mPackages.get(childPackageName);
                        installRes.uid = childPs.pkg.applicationInfo.uid;
                        if (outInfo.appearedChildPackages == null) {
                            outInfo.appearedChildPackages = new ArrayMap();
                        }
                        outInfo.appearedChildPackages.put(childPackageName, installRes);
                    }
                }
            }
        }
    }

    @GuardedBy(value={"mPackages"})
    private void markPackageUninstalledForUserLPw(PackageSetting ps, UserHandle user) {
        int[] userIds;
        int[] nArray;
        if (user == null || user.getIdentifier() == -1) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = user.getIdentifier();
        }
        for (int nextUserId : userIds = nArray) {
            ps.setUserState(nextUserId, 0L, 0, false, true, true, false, 0, false, null, null, null, null, false, false, null, null, null, ps.readUserState((int)nextUserId).domainVerificationStatus, 0, 0, null);
        }
        this.mSettings.writeKernelMappingLPr(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPackageStateForUserLIF(PackageSetting ps, int userId, PackageRemovedInfo outInfo, int flags) {
        int[] userIds;
        int[] nArray;
        PackageParser.Package pkg;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkg = this.mPackages.get(ps.name);
        }
        this.destroyAppProfilesLIF(pkg);
        if (userId == -1) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userId;
        }
        for (int nextUserId : userIds = nArray) {
            ArrayMap<String, PackageParser.Package> arrayMap2;
            this.destroyAppDataLIF(pkg, nextUserId, 7);
            this.clearDefaultBrowserIfNeededForUser(ps.name, nextUserId);
            PackageManagerService.removeKeystoreDataIfNeeded(nextUserId, ps.appId);
            SparseBooleanArray changedUsers = new SparseBooleanArray();
            this.clearPackagePreferredActivitiesLPw(ps.name, changedUsers, nextUserId);
            if (changedUsers.size() > 0) {
                this.updateDefaultHomeNotLocked(changedUsers);
                this.postPreferredActivityChangedBroadcast(nextUserId);
                arrayMap2 = this.mPackages;
                synchronized (arrayMap2) {
                    this.scheduleWritePackageRestrictionsLocked(nextUserId);
                }
            }
            arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, nextUserId);
            }
            if ((flags & 0x10) == 0) continue;
            try {
                MediaStore.deleteContributedMedia(this.mContext, ps.name, UserHandle.of(nextUserId));
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to delete contributed media for " + ps.name, e);
            }
        }
        if (outInfo != null) {
            outInfo.removedPackage = ps.name;
            outInfo.installerPackageName = ps.installerPackageName;
            outInfo.isStaticSharedLib = pkg != null && pkg.staticSharedLibName != null;
            outInfo.removedAppId = ps.appId;
            outInfo.removedUsers = userIds;
            outInfo.broadcastUsers = userIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearApplicationProfileData(String packageName) {
        PackageParser.Package pkg;
        PackageManagerService.enforceSystemOrRoot("Only the system can clear all profile data");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkg = this.mPackages.get(packageName);
        }
        try (PackageFreezer freezer = this.freezePackage(packageName, "clearApplicationProfileData");){
            Object object = this.mInstallLock;
            synchronized (object) {
                this.clearAppProfilesLIF(pkg, -1);
            }
        }
    }

    @Override
    public void clearApplicationUserData(final String packageName, final IPackageDataObserver observer, final int userId) {
        boolean filterApp;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_USER_DATA", null);
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, false, "clear application data");
        PackageSetting ps = this.mSettings.getPackageLPr(packageName);
        boolean bl = filterApp = ps != null && this.filterAppAccessLPr(ps, callingUid, userId);
        if (!filterApp && this.mProtectedPackages.isPackageDataProtected(userId, packageName)) {
            throw new SecurityException("Cannot clear data for a protected package: " + packageName);
        }
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean succeeded;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                if (!filterApp) {
                    try (PackageFreezer freezer = PackageManagerService.this.freezePackage(packageName, "clearApplicationUserData");){
                        ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mInstallLock;
                        synchronized (arrayMap) {
                            succeeded = PackageManagerService.this.clearApplicationUserDataLIF(packageName, userId);
                        }
                        arrayMap = PackageManagerService.this.mPackages;
                        synchronized (arrayMap) {
                            PackageManagerService.this.mInstantAppRegistry.deleteInstantApplicationMetadataLPw(packageName, userId);
                        }
                    }
                    if (succeeded) {
                        DeviceStorageMonitorInternal dsm = LocalServices.getService(DeviceStorageMonitorInternal.class);
                        if (dsm != null) {
                            dsm.checkMemory();
                        }
                        if (PackageManagerService.this.checkPermission("android.permission.SUSPEND_APPS", packageName, userId) == 0) {
                            PackageManagerService.this.unsuspendForSuspendingPackage(packageName, userId);
                        }
                    }
                } else {
                    succeeded = false;
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, succeeded);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearApplicationUserDataLIF(String packageName, int userId) {
        PackageParser.Package pkg;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            pkg = this.mPackages.get(packageName);
            if (pkg == null && (ps = this.mSettings.mPackages.get(packageName)) != null) {
                pkg = ps.pkg;
            }
            if (pkg == null) {
                Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                return false;
            }
            ps = (PackageSetting)pkg.mExtras;
            this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, userId);
        }
        this.clearAppDataLIF(pkg, userId, 7);
        int appId = UserHandle.getAppId(pkg.applicationInfo.uid);
        PackageManagerService.removeKeystoreDataIfNeeded(userId, appId);
        UserManagerInternal umInternal = this.getUserManagerInternal();
        int flags = umInternal.isUserUnlockingOrUnlocked(userId) ? 3 : (umInternal.isUserRunning(userId) ? 1 : 0);
        this.prepareAppDataContentsLIF(pkg, userId, flags);
        return true;
    }

    @GuardedBy(value={"mPackages"})
    private void resetUserChangesToRuntimePermissionsAndFlagsLPw(int userId) {
        int packageCount = this.mPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            PackageParser.Package pkg = this.mPackages.valueAt(i);
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, userId);
        }
    }

    private void resetNetworkPolicies(int userId) {
        LocalServices.getService(NetworkPolicyManagerInternal.class).resetUserState(userId);
    }

    @GuardedBy(value={"mPackages"})
    private void resetUserChangesToRuntimePermissionsAndFlagsLPw(PackageSetting ps, int userId) {
        if (ps.pkg == null) {
            return;
        }
        String packageName = ps.pkg.packageName;
        int userSettableMask = 75;
        int policyOrSystemFlags = 20;
        final boolean[] permissionRemoved = new boolean[1];
        final ArraySet revokedPermissions = new ArraySet();
        final SparseBooleanArray updatedUsers = new SparseBooleanArray();
        PermissionManagerServiceInternal.PermissionCallback delayingPermCallback = new PermissionManagerServiceInternal.PermissionCallback(){

            @Override
            public void onGidsChanged(int appId, int userId) {
                PackageManagerService.this.mPermissionCallback.onGidsChanged(appId, userId);
            }

            @Override
            public void onPermissionChanged() {
                PackageManagerService.this.mPermissionCallback.onPermissionChanged();
            }

            @Override
            public void onPermissionGranted(int uid, int userId) {
                PackageManagerService.this.mPermissionCallback.onPermissionGranted(uid, userId);
            }

            @Override
            public void onInstallPermissionGranted() {
                PackageManagerService.this.mPermissionCallback.onInstallPermissionGranted();
            }

            @Override
            public void onPermissionRevoked(int uid, int userId) {
                revokedPermissions.add(IntPair.of(uid, userId));
                updatedUsers.put(userId, true);
            }

            @Override
            public void onInstallPermissionRevoked() {
                PackageManagerService.this.mPermissionCallback.onInstallPermissionRevoked();
            }

            @Override
            public void onPermissionUpdated(int[] updatedUserIds, boolean sync) {
                for (int userId : updatedUserIds) {
                    if (sync) {
                        updatedUsers.put(userId, true);
                        continue;
                    }
                    if (updatedUsers.get(userId)) continue;
                    updatedUsers.put(userId, false);
                }
            }

            @Override
            public void onPermissionRemoved() {
                permissionRemoved[0] = true;
            }

            @Override
            public void onInstallPermissionUpdated() {
                PackageManagerService.this.mPermissionCallback.onInstallPermissionUpdated();
            }
        };
        int permissionCount = ps.pkg.requestedPermissions.size();
        for (int i = 0; i < permissionCount; ++i) {
            String permName = ps.pkg.requestedPermissions.get(i);
            BasePermission bp = this.mPermissionManager.getPermissionTEMP(permName);
            if (bp == null || bp.isRemoved()) continue;
            if (ps.sharedUser != null) {
                boolean used = false;
                int packageCount = ps.sharedUser.packages.size();
                for (int j = 0; j < packageCount; ++j) {
                    PackageSetting pkg = ps.sharedUser.packages.valueAt(j);
                    if (pkg.pkg == null || pkg.pkg.packageName.equals(ps.pkg.packageName) || !pkg.pkg.requestedPermissions.contains(permName)) continue;
                    used = true;
                    break;
                }
                if (used) continue;
            }
            int oldFlags = this.mPermissionManager.getPermissionFlags(permName, packageName, 1000, userId);
            int flags = 0;
            if (ps.pkg.applicationInfo.targetSdkVersion < 23 && bp.isRuntime()) {
                flags |= 0x48;
            }
            this.mPermissionManager.updatePermissionFlags(permName, packageName, 75, flags, 1000, userId, false, delayingPermCallback);
            if (!bp.isRuntime() || (oldFlags & 0x14) != 0) continue;
            if ((oldFlags & 0x20) != 0) {
                this.mPermissionManager.grantRuntimePermission(permName, packageName, false, 1000, userId, delayingPermCallback);
                continue;
            }
            if ((flags & 0x40) != 0) continue;
            this.mPermissionManager.revokeRuntimePermission(permName, packageName, false, userId, delayingPermCallback);
        }
        if (permissionRemoved[0]) {
            this.mPermissionCallback.onPermissionRemoved();
        }
        if (!revokedPermissions.isEmpty()) {
            int numRevokedPermissions = revokedPermissions.size();
            for (int i = 0; i < numRevokedPermissions; ++i) {
                int revocationUID = IntPair.first((Long)revokedPermissions.valueAt(i));
                int revocationUserId = IntPair.second((Long)revokedPermissions.valueAt(i));
                this.mOnPermissionChangeListeners.onPermissionsChanged(revocationUID);
                this.mHandler.post(() -> this.killUid(UserHandle.getAppId(revocationUID), revocationUserId, KILL_APP_REASON_PERMISSIONS_REVOKED));
            }
        }
        int numUpdatedUsers = updatedUsers.size();
        for (int i = 0; i < numUpdatedUsers; ++i) {
            this.mSettings.writeRuntimePermissionsForUserLPr(updatedUsers.keyAt(i), updatedUsers.valueAt(i));
        }
    }

    private static void removeKeystoreDataIfNeeded(int userId, int appId) {
        if (appId < 0) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance();
        if (keyStore != null) {
            if (userId == -1) {
                for (int individual : sUserManager.getUserIds()) {
                    keyStore.clearUid(UserHandle.getUid(individual, appId));
                }
            } else {
                keyStore.clearUid(UserHandle.getUid(userId, appId));
            }
        } else {
            Slog.w(TAG, "Could not contact keystore to clear entries for app id " + appId);
        }
    }

    @Override
    public void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
        int userId = UserHandle.getCallingUserId();
        this.deleteApplicationCacheFilesAsUser(packageName, userId, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApplicationCacheFilesAsUser(String packageName, int userId, IPackageDataObserver observer) {
        PackageParser.Package pkg;
        int callingUid = Binder.getCallingUid();
        if (this.mContext.checkCallingOrSelfPermission("android.permission.INTERNAL_DELETE_CACHE_FILES") != 0) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.DELETE_CACHE_FILES") == 0) {
                Slog.w(TAG, "Calling uid " + callingUid + " does not have " + "android.permission.INTERNAL_DELETE_CACHE_FILES" + ", silently ignoring");
                return;
            }
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERNAL_DELETE_CACHE_FILES", null);
        }
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, false, "delete application cache files");
        int hasAccessInstantApps = this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_INSTANT_APPS");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkg = this.mPackages.get(packageName);
        }
        this.mHandler.post(() -> {
            PackageSetting ps = pkg == null ? null : (PackageSetting)pkg.mExtras;
            boolean doClearData = true;
            if (ps != null) {
                boolean targetIsInstantApp = ps.getInstantApp(UserHandle.getUserId(callingUid));
                boolean bl = doClearData = !targetIsInstantApp || hasAccessInstantApps == 0;
            }
            if (doClearData) {
                Object targetIsInstantApp = this.mInstallLock;
                synchronized (targetIsInstantApp) {
                    int flags = 7;
                    this.clearAppDataLIF(pkg, userId, 23);
                    this.clearAppDataLIF(pkg, userId, 39);
                }
            }
            if (observer != null) {
                try {
                    observer.onRemoveCompleted(packageName, true);
                }
                catch (RemoteException e) {
                    Log.i(TAG, "Observer no longer exists.");
                }
            }
        });
    }

    @Override
    public void getPackageSizeInfo(String packageName, int userHandle, IPackageStatsObserver observer) {
        throw new UnsupportedOperationException("Shame on you for calling the hidden API getPackageSizeInfo(). Shame!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mInstallLock"})
    private boolean getPackageSizeInfoLI(String packageName, int userId, PackageStats stats) {
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Slog.w(TAG, "Failed to find settings for " + packageName);
                return false;
            }
        }
        String[] packageNames = new String[]{packageName};
        long[] ceDataInodes = new long[]{ps.getCeDataInode(userId)};
        String[] codePaths = new String[]{ps.codePathString};
        try {
            this.mInstaller.getAppSize(ps.volumeUuid, packageNames, userId, 0, ps.appId, ceDataInodes, codePaths, stats);
            if (PackageManagerService.isSystemApp(ps) && !PackageManagerService.isUpdatedSystemApp(ps)) {
                stats.codeSize = 0L;
            }
            stats.dataSize -= stats.cacheSize;
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, String.valueOf(e));
            return false;
        }
        return true;
    }

    @GuardedBy(value={"mPackages"})
    private int getUidTargetSdkVersionLockedLPr(int uid) {
        int appId = UserHandle.getAppId(uid);
        SettingBase obj = this.mSettings.getSettingLPr(appId);
        if (obj instanceof SharedUserSetting) {
            SharedUserSetting sus = (SharedUserSetting)obj;
            int vers = 10000;
            for (PackageSetting ps : sus.packages) {
                int v;
                if (ps.pkg == null || (v = ps.pkg.applicationInfo.targetSdkVersion) >= vers) continue;
                vers = v;
            }
            return vers;
        }
        if (obj instanceof PackageSetting) {
            PackageSetting ps = (PackageSetting)obj;
            if (ps.pkg != null) {
                return ps.pkg.applicationInfo.targetSdkVersion;
            }
        }
        return 10000;
    }

    @GuardedBy(value={"mPackages"})
    private int getPackageTargetSdkVersionLockedLPr(String packageName) {
        PackageParser.Package p = this.mPackages.get(packageName);
        if (p != null) {
            return p.applicationInfo.targetSdkVersion;
        }
        return 10000;
    }

    @Override
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        this.addPreferredActivityInternal(filter, match, set, activity, true, userId, "Adding preferred");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPreferredActivityInternal(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, boolean always, int userId, String opname) {
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, false, "add preferred activity");
        if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
            if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                Slog.w(TAG, "Ignoring addPreferredActivity() from uid " + callingUid);
                return;
            }
            this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        }
        if (filter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a preferred activity with no filter actions");
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PreferredIntentResolver pir = this.mSettings.editPreferredActivitiesLPw(userId);
            pir.addFilter(new PreferredActivity(filter, match, set, activity, always));
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
        if (!this.updateDefaultHomeNotLocked(userId)) {
            this.postPreferredActivityChangedBroadcast(userId);
        }
    }

    private void postPreferredActivityChangedBroadcast(int userId) {
        this.mHandler.post(() -> {
            IActivityManager am = ActivityManager.getService();
            if (am == null) {
                return;
            }
            Intent intent = new Intent("android.intent.action.ACTION_PREFERRED_ACTIVITY_CHANGED");
            intent.putExtra("android.intent.extra.user_handle", userId);
            intent.addFlags(0x4000000);
            try {
                am.broadcastIntent(null, intent, null, null, 0, null, null, null, -1, null, false, false, userId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        ArrayMap<String, PackageParser.Package> arrayMap;
        if (filter.countActions() != 1) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have only 1 action.");
        }
        if (filter.countDataAuthorities() != 0 || filter.countDataPaths() != 0 || filter.countDataSchemes() > 1 || filter.countDataTypes() != 0) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have no data authorities, paths, or types; and at most one scheme.");
        }
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, false, "replace preferred activity");
        if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
            arrayMap = this.mPackages;
            synchronized (arrayMap) {
                if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                    Slog.w(TAG, "Ignoring replacePreferredActivity() from uid " + Binder.getCallingUid());
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 15] lbl17 : MonitorExitStatement: MONITOREXIT : var7_7
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
        }
        arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.get(userId);
            if (pir != null) {
                ArrayList existing = pir.findFilters(filter);
                if (existing != null && existing.size() == 1) {
                    PreferredActivity cur = (PreferredActivity)existing.get(0);
                    if (cur.mPref.mAlways && cur.mPref.mComponent.equals(activity) && cur.mPref.mMatch == (match & 0xFFF0000) && cur.mPref.sameSet(set)) {
                        return;
                    }
                }
                if (existing != null) {
                    for (int i = existing.size() - 1; i >= 0; --i) {
                        PreferredActivity pa = (PreferredActivity)existing.get(i);
                        pir.removeFilter(pa);
                    }
                }
            }
        }
        this.addPreferredActivityInternal(filter, match, set, activity, true, userId, "Replacing preferred");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePreferredActivities(String packageName) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (!(pkg != null && this.isCallerSameApp(packageName, callingUid) || this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") == 0)) {
                if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                    Slog.w(TAG, "Ignoring clearPackagePreferredActivities() from uid " + callingUid);
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            if ((ps = this.mSettings.getPackageLPr(packageName)) != null && this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                return;
            }
        }
        int callingUserId = UserHandle.getCallingUserId();
        SparseBooleanArray changedUsers = new SparseBooleanArray();
        this.clearPackagePreferredActivitiesLPw(packageName, changedUsers, callingUserId);
        if (changedUsers.size() > 0) {
            this.updateDefaultHomeNotLocked(changedUsers);
            this.postPreferredActivityChangedBroadcast(callingUserId);
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                this.scheduleWritePackageRestrictionsLocked(callingUserId);
            }
        }
    }

    @GuardedBy(value={"mPackages"})
    private void clearPackagePreferredActivitiesLPw(String packageName, SparseBooleanArray outUserChanged, int userId) {
        ArrayList<PreferredActivity> removed = null;
        for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
            int thisUserId = this.mSettings.mPreferredActivities.keyAt(i);
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
            if (userId != -1 && userId != thisUserId) continue;
            Iterator it = pir.filterIterator();
            while (it.hasNext()) {
                PreferredActivity pa = (PreferredActivity)it.next();
                if (packageName != null && (!pa.mPref.mComponent.getPackageName().equals(packageName) || !pa.mPref.mAlways)) continue;
                if (removed == null) {
                    removed = new ArrayList<PreferredActivity>();
                }
                removed.add(pa);
            }
            if (removed == null) continue;
            for (int j = 0; j < removed.size(); ++j) {
                PreferredActivity pa = (PreferredActivity)removed.get(j);
                pir.removeFilter(pa);
            }
            outUserChanged.put(thisUserId, true);
        }
    }

    @GuardedBy(value={"mPackages"})
    private void clearIntentFilterVerificationsLPw(int userId) {
        int packageCount = this.mPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            PackageParser.Package pkg = this.mPackages.valueAt(i);
            this.clearIntentFilterVerificationsLPw(pkg.packageName, userId);
        }
    }

    @GuardedBy(value={"mPackages"})
    void clearIntentFilterVerificationsLPw(String packageName, int userId) {
        if (userId == -1) {
            if (this.mSettings.removeIntentFilterVerificationLPw(packageName, sUserManager.getUserIds())) {
                for (int oneUserId : sUserManager.getUserIds()) {
                    this.scheduleWritePackageRestrictionsLocked(oneUserId);
                }
            }
        } else if (this.mSettings.removeIntentFilterVerificationLPw(packageName, userId)) {
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
    }

    void clearDefaultBrowserIfNeeded(String packageName) {
        for (int oneUserId : sUserManager.getUserIds()) {
            this.clearDefaultBrowserIfNeededForUser(packageName, oneUserId);
        }
    }

    private void clearDefaultBrowserIfNeededForUser(String packageName, int userId) {
        String defaultBrowserPackageName = this.getDefaultBrowserPackageName(userId);
        if (!TextUtils.isEmpty(defaultBrowserPackageName) && packageName.equals(defaultBrowserPackageName)) {
            this.setDefaultBrowserPackageName(null, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetApplicationPreferences(int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        long identity = Binder.clearCallingIdentity();
        try {
            SparseBooleanArray changedUsers = new SparseBooleanArray();
            this.clearPackagePreferredActivitiesLPw(null, changedUsers, userId);
            if (changedUsers.size() > 0) {
                this.postPreferredActivityChangedBroadcast(userId);
            }
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.applyDefaultPreferredAppsLPw(userId);
                this.clearIntentFilterVerificationsLPw(userId);
                this.primeDomainVerificationsLPw(userId);
                this.resetUserChangesToRuntimePermissionsAndFlagsLPw(userId);
            }
            this.updateDefaultHomeNotLocked(userId);
            this.setDefaultBrowserPackageName(null, userId);
            this.resetNetworkPolicies(userId);
            arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return 0;
        }
        int num = 0;
        int userId = UserHandle.getCallingUserId();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.get(userId);
            if (pir != null) {
                Iterator it = pir.filterIterator();
                while (it.hasNext()) {
                    PreferredActivity pa = (PreferredActivity)it.next();
                    if (packageName != null && (!pa.mPref.mComponent.getPackageName().equals(packageName) || !pa.mPref.mAlways)) continue;
                    if (outFilters != null) {
                        outFilters.add(new IntentFilter(pa));
                    }
                    if (outActivities == null) continue;
                    outActivities.add(pa.mPref.mComponent);
                }
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPersistentPreferredActivity(IntentFilter filter, ComponentName activity, int userId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("addPersistentPreferredActivity can only be run by the system");
        }
        if (filter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a preferred activity with no filter actions");
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mSettings.editPersistentPreferredActivitiesLPw(userId).addFilter(new PersistentPreferredActivity(filter, activity));
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
        this.updateDefaultHomeNotLocked(userId);
        this.postPreferredActivityChangedBroadcast(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePersistentPreferredActivities(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("clearPackagePersistentPreferredActivities can only be run by the system");
        }
        ArrayList<PersistentPreferredActivity> removed = null;
        boolean changed = false;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (int i = 0; i < this.mSettings.mPersistentPreferredActivities.size(); ++i) {
                int thisUserId = this.mSettings.mPersistentPreferredActivities.keyAt(i);
                PersistentPreferredIntentResolver ppir = this.mSettings.mPersistentPreferredActivities.valueAt(i);
                if (userId != thisUserId) continue;
                Iterator it = ppir.filterIterator();
                while (it.hasNext()) {
                    PersistentPreferredActivity ppa = (PersistentPreferredActivity)it.next();
                    if (!ppa.mComponent.getPackageName().equals(packageName)) continue;
                    if (removed == null) {
                        removed = new ArrayList<PersistentPreferredActivity>();
                    }
                    removed.add(ppa);
                }
                if (removed == null) continue;
                for (int j = 0; j < removed.size(); ++j) {
                    PersistentPreferredActivity ppa = (PersistentPreferredActivity)removed.get(j);
                    ppir.removeFilter(ppa);
                }
                changed = true;
            }
        }
        if (changed) {
            this.updateDefaultHomeNotLocked(userId);
            this.postPreferredActivityChangedBroadcast(userId);
            arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
        }
    }

    private void restoreFromXml(XmlPullParser parser, int userId, String expectedStartTag, BlobXmlRestorer functor) throws IOException, XmlPullParserException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            return;
        }
        if (!expectedStartTag.equals(parser.getName())) {
            return;
        }
        while ((type = parser.next()) == 4) {
        }
        functor.apply(parser, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPreferredActivityBackup(int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call getPreferredActivityBackup()");
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_PREFERRED_BACKUP);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.writePreferredActivitiesLPr(serializer, userId, true);
            }
            serializer.endTag(null, TAG_PREFERRED_BACKUP);
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            return null;
        }
        return dataStream.toByteArray();
    }

    @Override
    public void restorePreferredActivities(byte[] backup, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call restorePreferredActivities()");
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new ByteArrayInputStream(backup), StandardCharsets.UTF_8.name());
            this.restoreFromXml(parser, userId, TAG_PREFERRED_BACKUP, (readParser, readUserId) -> {
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    this.mSettings.readPreferredActivitiesLPw(readParser, readUserId);
                }
                this.updateDefaultHomeNotLocked(readUserId);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getDefaultAppsBackup(int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call getDefaultAppsBackup()");
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_DEFAULT_APPS);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.writeDefaultAppsLPr(serializer, userId);
            }
            serializer.endTag(null, TAG_DEFAULT_APPS);
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            return null;
        }
        return dataStream.toByteArray();
    }

    @Override
    public void restoreDefaultApps(byte[] backup, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call restoreDefaultApps()");
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new ByteArrayInputStream(backup), StandardCharsets.UTF_8.name());
            this.restoreFromXml(parser, userId, TAG_DEFAULT_APPS, (parser1, userId1) -> {
                String defaultBrowser;
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    this.mSettings.readDefaultAppsLPw(parser1, userId1);
                    defaultBrowser = this.mSettings.removeDefaultBrowserPackageNameLPw(userId1);
                }
                if (defaultBrowser != null) {
                    PackageManagerInternal.DefaultBrowserProvider provider;
                    ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
                    synchronized (arrayMap2) {
                        provider = this.mDefaultBrowserProvider;
                    }
                    provider.setDefaultBrowser(defaultBrowser, userId1);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getIntentFilterVerificationBackup(int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call getIntentFilterVerificationBackup()");
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_INTENT_FILTER_VERIFICATION);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.writeAllDomainVerificationsLPr(serializer, userId);
            }
            serializer.endTag(null, TAG_INTENT_FILTER_VERIFICATION);
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            return null;
        }
        return dataStream.toByteArray();
    }

    @Override
    public void restoreIntentFilterVerification(byte[] backup, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call restorePreferredActivities()");
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new ByteArrayInputStream(backup), StandardCharsets.UTF_8.name());
            this.restoreFromXml(parser, userId, TAG_INTENT_FILTER_VERIFICATION, (parser1, userId1) -> {
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    this.mSettings.readAllDomainVerificationsLPr(parser1, userId1);
                    this.mSettings.writeLPr();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCrossProfileIntentFilter(IntentFilter intentFilter, String ownerPackage, int sourceUserId, int targetUserId, int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        int callingUid = Binder.getCallingUid();
        this.enforceOwnerRights(ownerPackage, callingUid);
        PackageManagerServiceUtils.enforceShellRestriction("no_debugging_features", callingUid, sourceUserId);
        if (intentFilter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a crossProfile intent filter with no filter actions");
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            CrossProfileIntentFilter newFilter = new CrossProfileIntentFilter(intentFilter, ownerPackage, targetUserId, flags);
            CrossProfileIntentResolver resolver = this.mSettings.editCrossProfileIntentResolverLPw(sourceUserId);
            ArrayList existing = resolver.findFilters(intentFilter);
            if (existing != null) {
                int size = existing.size();
                for (int i = 0; i < size; ++i) {
                    if (!newFilter.equalsIgnoreFilter((CrossProfileIntentFilter)existing.get(i))) continue;
                    return;
                }
            }
            resolver.addFilter(newFilter);
            this.scheduleWritePackageRestrictionsLocked(sourceUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCrossProfileIntentFilters(int sourceUserId, String ownerPackage) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        int callingUid = Binder.getCallingUid();
        this.enforceOwnerRights(ownerPackage, callingUid);
        PackageManagerServiceUtils.enforceShellRestriction("no_debugging_features", callingUid, sourceUserId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            CrossProfileIntentResolver resolver = this.mSettings.editCrossProfileIntentResolverLPw(sourceUserId);
            ArraySet set = new ArraySet(resolver.filterSet());
            for (CrossProfileIntentFilter filter : set) {
                if (!filter.getOwnerPackage().equals(ownerPackage)) continue;
                resolver.removeFilter(filter);
            }
            this.scheduleWritePackageRestrictionsLocked(sourceUserId);
        }
    }

    private void enforceOwnerRights(String pkg, int callingUid) {
        if (UserHandle.getAppId(callingUid) == 1000) {
            return;
        }
        int callingUserId = UserHandle.getUserId(callingUid);
        PackageInfo pi = this.getPackageInfo(pkg, 0, callingUserId);
        if (pi == null) {
            throw new IllegalArgumentException("Unknown package " + pkg + " on user " + callingUserId);
        }
        if (!UserHandle.isSameApp(pi.applicationInfo.uid, callingUid)) {
            throw new SecurityException("Calling uid " + callingUid + " does not own package " + pkg);
        }
    }

    @Override
    public ComponentName getHomeActivities(List<ResolveInfo> allHomeCandidates) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        return this.getHomeActivitiesAsUser(allHomeCandidates, UserHandle.getCallingUserId());
    }

    public void sendSessionUpdatedBroadcast(PackageInstaller.SessionInfo sessionInfo, int userId) {
        if (TextUtils.isEmpty(sessionInfo.installerPackageName)) {
            return;
        }
        Intent sessionUpdatedIntent = new Intent("android.content.pm.action.SESSION_UPDATED").putExtra("android.content.pm.extra.SESSION", sessionInfo).setPackage(sessionInfo.installerPackageName);
        this.mContext.sendBroadcastAsUser(sessionUpdatedIntent, UserHandle.of(userId));
    }

    public void sendSessionCommitBroadcast(PackageInstaller.SessionInfo sessionInfo, int userId) {
        UserManagerService ums = UserManagerService.getInstance();
        if (ums != null) {
            UserInfo parent = ums.getProfileParent(userId);
            int launcherUid = parent != null ? parent.id : userId;
            ComponentName launcherComponent = this.getDefaultHomeActivity(launcherUid);
            if (launcherComponent != null) {
                Intent launcherIntent = new Intent("android.content.pm.action.SESSION_COMMITTED").putExtra("android.content.pm.extra.SESSION", sessionInfo).putExtra("android.intent.extra.USER", UserHandle.of(userId)).setPackage(launcherComponent.getPackageName());
                this.mContext.sendBroadcastAsUser(launcherIntent, UserHandle.of(launcherUid));
            }
            if (this.mAppPredictionServicePackage != null) {
                Intent predictorIntent = new Intent("android.content.pm.action.SESSION_COMMITTED").putExtra("android.content.pm.extra.SESSION", sessionInfo).putExtra("android.intent.extra.USER", UserHandle.of(userId)).setPackage(this.mAppPredictionServicePackage);
                this.mContext.sendBroadcastAsUser(predictorIntent, UserHandle.of(launcherUid));
            }
        }
    }

    private ComponentName getDefaultHomeActivity(int userId) {
        ArrayList<ResolveInfo> allHomeCandidates = new ArrayList<ResolveInfo>();
        ComponentName cn = this.getHomeActivitiesAsUser(allHomeCandidates, userId);
        if (cn != null) {
            return cn;
        }
        int lastPriority = Integer.MIN_VALUE;
        ComponentName lastComponent = null;
        int size = allHomeCandidates.size();
        for (int i = 0; i < size; ++i) {
            ResolveInfo ri = (ResolveInfo)allHomeCandidates.get(i);
            if (ri.priority > lastPriority) {
                lastComponent = ri.activityInfo.getComponentName();
                lastPriority = ri.priority;
                continue;
            }
            if (ri.priority != lastPriority) continue;
            lastComponent = null;
        }
        return lastComponent;
    }

    private Intent getHomeIntent() {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        intent.addCategory("android.intent.category.DEFAULT");
        return intent;
    }

    private IntentFilter getHomeFilter() {
        IntentFilter filter = new IntentFilter("android.intent.action.MAIN");
        filter.addCategory("android.intent.category.HOME");
        filter.addCategory("android.intent.category.DEFAULT");
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName getHomeActivitiesAsUser(List<ResolveInfo> allHomeCandidates, int userId) {
        PackageManagerInternal.DefaultHomeProvider provider;
        Intent intent = this.getHomeIntent();
        List<ResolveInfo> resolveInfos = this.queryIntentActivitiesInternal(intent, null, 128, userId);
        allHomeCandidates.clear();
        if (resolveInfos == null) {
            return null;
        }
        allHomeCandidates.addAll(resolveInfos);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            provider = this.mDefaultHomeProvider;
        }
        if (provider == null) {
            Slog.e(TAG, "mDefaultHomeProvider is null");
            return null;
        }
        String packageName = provider.getDefaultHome(userId);
        if (packageName == null) {
            return null;
        }
        int resolveInfosSize = resolveInfos.size();
        for (int i = 0; i < resolveInfosSize; ++i) {
            ResolveInfo resolveInfo = resolveInfos.get(i);
            if (resolveInfo.activityInfo == null || !TextUtils.equals(resolveInfo.activityInfo.packageName, packageName)) continue;
            return new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name);
        }
        return null;
    }

    private void updateDefaultHomeNotLocked(SparseBooleanArray userIds) {
        if (Thread.holdsLock(this.mPackages)) {
            Slog.wtf(TAG, "Calling thread " + Thread.currentThread().getName() + " is holding mPackages", new Throwable());
        }
        for (int i = userIds.size() - 1; i >= 0; --i) {
            int userId = userIds.keyAt(i);
            this.updateDefaultHomeNotLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDefaultHomeNotLocked(int userId) {
        PackageManagerInternal.DefaultHomeProvider provider;
        List<ResolveInfo> resolveInfos;
        if (Thread.holdsLock(this.mPackages)) {
            Slog.wtf(TAG, "Calling thread " + Thread.currentThread().getName() + " is holding mPackages", new Throwable());
        }
        if (!this.mSystemReady) {
            return false;
        }
        Intent intent = this.getHomeIntent();
        ResolveInfo preferredResolveInfo = this.findPreferredActivityNotLocked(intent, null, 0, resolveInfos = this.queryIntentActivitiesInternal(intent, null, 128, userId), 0, true, false, false, userId);
        String packageName = preferredResolveInfo != null && preferredResolveInfo.activityInfo != null ? preferredResolveInfo.activityInfo.packageName : null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            provider = this.mDefaultHomeProvider;
        }
        if (provider == null) {
            Slog.e(TAG, "Default home provider has not been set");
            return false;
        }
        String currentPackageName = provider.getDefaultHome(userId);
        if (TextUtils.equals(currentPackageName, packageName)) {
            return false;
        }
        String[] callingPackages = this.getPackagesForUid(Binder.getCallingUid());
        if (callingPackages != null && ArrayUtils.contains(callingPackages, this.mRequiredPermissionControllerPackage)) {
            return false;
        }
        provider.setDefaultHomeAsync(packageName, userId, successful -> {
            if (successful.booleanValue()) {
                this.postPreferredActivityChangedBroadcast(userId);
            }
        });
        return true;
    }

    @Override
    public void setHomeActivity(ComponentName comp, int userId) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        ArrayList<ResolveInfo> homeActivities = new ArrayList<ResolveInfo>();
        this.getHomeActivitiesAsUser(homeActivities, userId);
        boolean found = false;
        int size = homeActivities.size();
        ComponentName[] set = new ComponentName[size];
        for (int i = 0; i < size; ++i) {
            ComponentName activityName;
            ResolveInfo candidate = homeActivities.get(i);
            ActivityInfo info = candidate.activityInfo;
            set[i] = activityName = new ComponentName(info.packageName, info.name);
            if (found || !activityName.equals(comp)) continue;
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Component " + comp + " cannot be home on user " + userId);
        }
        this.replacePreferredActivity(this.getHomeFilter(), 0x100000, set, comp, userId);
    }

    private String getSetupWizardPackageName() {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.SETUP_WIZARD");
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, null, 1835520, UserHandle.myUserId());
        if (matches.size() == 1) {
            return matches.get((int)0).getComponentInfo().packageName;
        }
        Slog.e(TAG, "There should probably be exactly one setup wizard; found " + matches.size() + ": matches=" + matches);
        return null;
    }

    private String getStorageManagerPackageName() {
        Intent intent = new Intent("android.os.storage.action.MANAGE_STORAGE");
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, null, 1835520, UserHandle.myUserId());
        if (matches.size() == 1) {
            return matches.get((int)0).getComponentInfo().packageName;
        }
        Slog.e(TAG, "There should probably be exactly one storage manager; found " + matches.size() + ": matches=" + matches);
        return null;
    }

    @Override
    public String getSystemTextClassifierPackageName() {
        return this.mContext.getString(17039712);
    }

    @Override
    public String getAttentionServicePackageName() {
        ComponentName componentName;
        String flattenedComponentName = this.mContext.getString(17039698);
        if (flattenedComponentName != null && (componentName = ComponentName.unflattenFromString(flattenedComponentName)) != null && componentName.getPackageName() != null) {
            return componentName.getPackageName();
        }
        return null;
    }

    private String getDocumenterPackageName() {
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("*/*");
        String resolvedType = intent.resolveTypeIfNeeded(this.mContext.getContentResolver());
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, resolvedType, 1835520, UserHandle.myUserId());
        if (matches.size() == 1) {
            return matches.get((int)0).getComponentInfo().packageName;
        }
        Slog.e(TAG, "There should probably be exactly one documenter; found " + matches.size() + ": matches=" + matches);
        return null;
    }

    @Override
    public String getWellbeingPackageName() {
        return this.mContext.getString(17039714);
    }

    @Override
    public String getAppPredictionServicePackageName() {
        String flattenedAppPredictionServiceComponentName = this.mContext.getString(17039696);
        if (flattenedAppPredictionServiceComponentName == null) {
            return null;
        }
        ComponentName appPredictionServiceComponentName = ComponentName.unflattenFromString(flattenedAppPredictionServiceComponentName);
        if (appPredictionServiceComponentName == null) {
            return null;
        }
        return appPredictionServiceComponentName.getPackageName();
    }

    @Override
    public String getSystemCaptionsServicePackageName() {
        String flattenedSystemCaptionsServiceComponentName = this.mContext.getString(17039711);
        if (TextUtils.isEmpty(flattenedSystemCaptionsServiceComponentName)) {
            return null;
        }
        ComponentName systemCaptionsServiceComponentName = ComponentName.unflattenFromString(flattenedSystemCaptionsServiceComponentName);
        if (systemCaptionsServiceComponentName == null) {
            return null;
        }
        return systemCaptionsServiceComponentName.getPackageName();
    }

    @Override
    public String getIncidentReportApproverPackageName() {
        return this.mContext.getString(17039744);
    }

    @Override
    public void setApplicationEnabledSetting(String appPackageName, int newState, int flags, int userId, String callingPackage) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        if (callingPackage == null) {
            callingPackage = Integer.toString(Binder.getCallingUid());
        }
        this.setEnabledSetting(appPackageName, null, newState, flags, userId, callingPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUpdateAvailable(String packageName, boolean updateAvailable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting != null) {
                pkgSetting.setUpdateAvailable(updateAvailable);
            }
        }
    }

    @Override
    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.setEnabledSetting(componentName.getPackageName(), componentName.getClassName(), newState, flags, userId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabledSetting(String packageName, String className, int newState, int flags, int userId, String callingPackage) {
        ArrayList<String> components;
        ArrayMap<String, PackageParser.Package> deletedPkg;
        PackageSetting pkgSetting;
        if (newState != 0 && newState != 1 && newState != 2 && newState != 3 && newState != 4) {
            throw new IllegalArgumentException("Invalid new component state: " + newState);
        }
        int callingUid = Binder.getCallingUid();
        int permission2 = callingUid == 1000 ? 0 : this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, true, "set enabled");
        boolean allowedByPermission = permission2 == 0;
        boolean sendNow = false;
        boolean isApp = className == null;
        boolean isCallerInstantApp = this.getInstantAppPackageName(callingUid) != null;
        String componentName = isApp ? packageName : className;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting == null) {
                if (!isCallerInstantApp) {
                    if (className == null) {
                        throw new IllegalArgumentException("Unknown package: " + packageName);
                    }
                    throw new IllegalArgumentException("Unknown component: " + packageName + "/" + className);
                }
                throw new SecurityException("Attempt to change component state; pid=" + Binder.getCallingPid() + ", uid=" + callingUid + (className == null ? ", package=" + packageName : ", component=" + packageName + "/" + className));
            }
        }
        if (!UserHandle.isSameApp(callingUid, pkgSetting.appId)) {
            if (!allowedByPermission || this.filterAppAccessLPr(pkgSetting, callingUid, userId)) {
                throw new SecurityException("Attempt to change component state; pid=" + Binder.getCallingPid() + ", uid=" + callingUid + (className == null ? ", package=" + packageName : ", component=" + packageName + "/" + className));
            }
            if (this.mProtectedPackages.isPackageStateProtected(userId, packageName)) {
                throw new SecurityException("Cannot disable a protected package: " + packageName);
            }
        }
        if (PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME.equals(className) && !allowedByPermission) {
            throw new SecurityException("Cannot disable a system-generated component");
        }
        arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (callingUid == 2000 && (pkgSetting.pkgFlags & 0x100) == 0) {
                int oldState = pkgSetting.getEnabled(userId);
                if (className != null || oldState != 3 && oldState != 0 && oldState != 1 || newState != 3 && newState != 0 && newState != 1) {
                    throw new SecurityException("Shell cannot change component state for " + packageName + "/" + className + " to " + newState);
                }
            }
        }
        if (className == null) {
            boolean isSystemStub;
            arrayMap = this.mPackages;
            synchronized (arrayMap) {
                if (pkgSetting.getEnabled(userId) == newState) {
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[2, 3, 53, 12] lbl53 : MonitorExitStatement: MONITOREXIT : var16_14
                deletedPkg = pkgSetting.pkg;
                boolean bl = isSystemStub = ((PackageParser.Package)((Object)deletedPkg)).isStub && ((PackageParser.Package)((Object)deletedPkg)).isSystem();
            }
            if (isSystemStub && (newState == 0 || newState == 1) && !this.enableCompressedPackage((PackageParser.Package)((Object)deletedPkg))) {
                return;
            }
            if (newState == 0 || newState == 1) {
                callingPackage = null;
            }
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                pkgSetting.setEnabled(newState, userId, callingPackage);
            }
        }
        deletedPkg = this.mPackages;
        synchronized (deletedPkg) {
            PackageParser.Package pkg = pkgSetting.pkg;
            if (pkg == null || !pkg.hasComponentClassName(className)) {
                if (pkg != null && pkg.applicationInfo.targetSdkVersion >= 16) {
                    throw new IllegalArgumentException("Component class " + className + " does not exist in " + packageName);
                }
                Slog.w(TAG, "Failed setComponentEnabledSetting: component class " + className + " does not exist in " + packageName);
            }
            switch (newState) {
                case 1: {
                    if (pkgSetting.enableComponentLPw(className, userId)) break;
                    return;
                }
                case 2: {
                    if (pkgSetting.disableComponentLPw(className, userId)) break;
                    return;
                }
                case 0: {
                    if (pkgSetting.restoreComponentLPw(className, userId)) break;
                    return;
                }
                default: {
                    Slog.e(TAG, "Invalid new component state: " + newState);
                    return;
                }
            }
        }
        deletedPkg = this.mPackages;
        synchronized (deletedPkg) {
            boolean newPackage;
            this.scheduleWritePackageRestrictionsLocked(userId);
            this.updateSequenceNumberLP(pkgSetting, new int[]{userId});
            long callingId = Binder.clearCallingIdentity();
            try {
                this.updateInstantAppInstallerLocked(packageName);
            }
            finally {
                Binder.restoreCallingIdentity(callingId);
            }
            components = this.mPendingBroadcasts.get(userId, packageName);
            boolean bl = newPackage = components == null;
            if (newPackage) {
                components = new ArrayList();
            }
            if (!components.contains(componentName)) {
                components.add(componentName);
            }
            if ((flags & 1) == 0) {
                sendNow = true;
                this.mPendingBroadcasts.remove(userId, packageName);
            } else {
                if (newPackage) {
                    this.mPendingBroadcasts.put(userId, packageName, components);
                }
                if (!this.mHandler.hasMessages(1)) {
                    long broadcastDelay = SystemClock.uptimeMillis() > this.mServiceStartWithDelay ? 1000L : 10000L;
                    this.mHandler.sendEmptyMessageDelayed(1, broadcastDelay);
                }
            }
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            if (sendNow) {
                int packageUid = UserHandle.getUid(userId, pkgSetting.appId);
                this.sendPackageChangedBroadcast(packageName, (flags & 1) != 0, components, packageUid);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushPackageRestrictionsAsUser(int userId) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "flushPackageRestrictions");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mSettings.writePackageRestrictionsLPr(userId);
            this.mDirtyUsers.remove(userId);
            if (this.mDirtyUsers.isEmpty()) {
                this.mHandler.removeMessages(14);
            }
        }
    }

    private void sendPackageChangedBroadcast(String packageName, boolean killFlag, ArrayList<String> componentNames, int packageUid) {
        int[] nArray;
        int[] nArray2;
        Bundle extras = new Bundle(4);
        extras.putString("android.intent.extra.changed_component_name", componentNames.get(0));
        String[] nameList = new String[componentNames.size()];
        componentNames.toArray(nameList);
        extras.putStringArray("android.intent.extra.changed_component_name_list", nameList);
        extras.putBoolean("android.intent.extra.DONT_KILL_APP", killFlag);
        extras.putInt("android.intent.extra.UID", packageUid);
        int flags = !componentNames.contains(packageName) ? 0x40000000 : 0;
        int userId = UserHandle.getUserId(packageUid);
        boolean isInstantApp = this.isInstantApp(packageName, userId);
        if (isInstantApp) {
            nArray2 = EMPTY_INT_ARRAY;
        } else {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = userId;
        }
        int[] userIds = nArray2;
        if (isInstantApp) {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = userId;
        } else {
            nArray = EMPTY_INT_ARRAY;
        }
        int[] instantUserIds = nArray;
        this.sendPackageBroadcast("android.intent.action.PACKAGE_CHANGED", packageName, extras, flags, null, null, userIds, instantUserIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageStoppedState(String packageName, boolean stopped, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return;
        }
        int permission2 = this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        boolean allowedByPermission = permission2 == 0;
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, true, "stop package");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (!this.filterAppAccessLPr(ps, callingUid, userId) && this.mSettings.setPackageStoppedStateLPw(this, packageName, stopped, allowedByPermission, callingUid, userId)) {
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInstallerPackageName(String packageName) {
        int callingUid = Binder.getCallingUid();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                return null;
            }
            if (ps == null && this.mApexManager.isApexPackage(packageName)) {
                return null;
            }
            return this.mSettings.getInstallerPackageNameLPr(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOrphaned(String packageName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (!this.mPackages.containsKey(packageName)) {
                return false;
            }
            return this.mSettings.isOrphaned(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getApplicationEnabledSetting(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return 2;
        }
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "get enabled");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.filterAppAccessLPr(this.mSettings.getPackageLPr(packageName), callingUid, userId)) {
                return 2;
            }
            return this.mSettings.getApplicationEnabledSettingLPr(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getComponentEnabledSetting(ComponentName component, int userId) {
        if (component == null) {
            return 0;
        }
        if (!sUserManager.exists(userId)) {
            return 2;
        }
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, false, "getComponentEnabled");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.filterAppAccessLPr(this.mSettings.getPackageLPr(component.getPackageName()), callingUid, component, 0, userId)) {
                return 2;
            }
            return this.mSettings.getComponentEnabledSettingLPr(component, userId);
        }
    }

    @Override
    public void enterSafeMode() {
        PackageManagerService.enforceSystemOrRoot("Only the system can request entering safe mode");
        if (!this.mSystemReady) {
            this.mSafeMode = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemReady() {
        PackageManagerService.enforceSystemOrRoot("Only the system can claim the system is ready");
        this.mSystemReady = true;
        final ContentResolver resolver = this.mContext.getContentResolver();
        ContentObserver co = new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean selfChange) {
                boolean ephemeralFeatureDisabled = Settings.Global.getInt(resolver, "enable_ephemeral_feature", 1) == 0;
                for (int userId : UserManagerService.getInstance().getUserIds()) {
                    boolean instantAppsDisabledForUser = ephemeralFeatureDisabled || Settings.Secure.getIntForUser(resolver, "instant_apps_enabled", 1, userId) == 0;
                    PackageManagerService.this.mWebInstantAppsDisabled.put(userId, instantAppsDisabledForUser);
                }
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("enable_ephemeral_feature"), false, co, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("instant_apps_enabled"), false, co, -1);
        co.onChange(true);
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(this.mContext.getOpPackageName(), this, this.mContext.getContentResolver(), 0);
        this.disableSkuSpecificApps();
        boolean compatibilityModeEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "compatibility_mode", 1) == 1;
        PackageParser.setCompatibilityModeEnabled(compatibilityModeEnabled);
        int[] grantPermissionsUserIds = EMPTY_INT_ARRAY;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<PreferredActivity> removed = new ArrayList<PreferredActivity>();
            for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
                PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
                removed.clear();
                for (PreferredActivity pa : pir.filterSet()) {
                    if (this.mComponentResolver.isActivityDefined(pa.mPref.mComponent)) continue;
                    removed.add(pa);
                }
                if (removed.size() <= 0) continue;
                for (int r = 0; r < removed.size(); ++r) {
                    PreferredActivity pa;
                    pa = (PreferredActivity)removed.get(r);
                    Slog.w(TAG, "Removing dangling preferred activity: " + pa.mPref.mComponent);
                    pir.removeFilter(pa);
                }
                this.mSettings.writePackageRestrictionsLPr(this.mSettings.mPreferredActivities.keyAt(i));
            }
            for (int userId2 : UserManagerService.getInstance().getUserIds()) {
                if (this.mSettings.areDefaultRuntimePermissionsGrantedLPr(userId2)) continue;
                grantPermissionsUserIds = ArrayUtils.appendInt(grantPermissionsUserIds, userId2);
            }
        }
        sUserManager.systemReady();
        for (Object userId3 : (ArrayMap<String, PackageParser.Package>)grantPermissionsUserIds) {
            this.mDefaultPermissionPolicy.grantDefaultPermissions((int)userId3);
        }
        if (grantPermissionsUserIds == EMPTY_INT_ARRAY) {
            this.mDefaultPermissionPolicy.scheduleReadDefaultPermissionExceptions();
        }
        arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mPermissionManager.updateAllPermissions(StorageManager.UUID_PRIVATE_INTERNAL, false, this.mPackages.values(), this.mPermissionCallback);
            PermissionPolicyInternal permissionPolicyInternal = LocalServices.getService(PermissionPolicyInternal.class);
            permissionPolicyInternal.setOnInitializedCallback(userId -> {
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    this.mPermissionManager.updateAllPermissions(StorageManager.UUID_PRIVATE_INTERNAL, false, this.mPackages.values(), this.mPermissionCallback);
                }
            });
        }
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        storage.registerListener(this.mStorageListener);
        this.mInstallerService.systemReady();
        this.mApexManager.systemReady();
        this.mPackageDexOptimizer.systemReady();
        this.getStorageManagerInternal().addExternalStoragePolicy(new StorageManagerInternal.ExternalStorageMountPolicy(){

            @Override
            public int getMountMode(int uid, String packageName) {
                if (Process.isIsolated(uid)) {
                    return 0;
                }
                if (PackageManagerService.this.checkUidPermission("android.permission.READ_EXTERNAL_STORAGE", uid) == -1) {
                    return 1;
                }
                if (PackageManagerService.this.checkUidPermission("android.permission.WRITE_EXTERNAL_STORAGE", uid) == -1) {
                    return 2;
                }
                return 3;
            }

            @Override
            public boolean hasExternalStorage(int uid, String packageName) {
                return true;
            }
        });
        sUserManager.reconcileUsers(StorageManager.UUID_PRIVATE_INTERNAL);
        this.reconcileApps(StorageManager.UUID_PRIVATE_INTERNAL);
        this.mPermissionManager.systemReady();
        if (this.mInstantAppResolverConnection != null) {
            this.mContext.registerReceiver(new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    PackageManagerService.this.mInstantAppResolverConnection.optimisticBind();
                    PackageManagerService.this.mContext.unregisterReceiver(this);
                }
            }, new IntentFilter("android.intent.action.BOOT_COMPLETED"));
        }
        this.mModuleInfoProvider.systemReady();
        this.mInstallerService.restoreAndApplyStagedSessionIfNeeded();
    }

    public void waitForAppDataPrepared() {
        if (this.mPrepareAppDataFuture == null) {
            return;
        }
        ConcurrentUtils.waitForFutureNoInterrupt(this.mPrepareAppDataFuture, "wait for prepareAppData");
        this.mPrepareAppDataFuture = null;
    }

    @Override
    public boolean isSafeMode() {
        return this.mSafeMode;
    }

    @Override
    public boolean hasSystemUidErrors() {
        return this.mHasSystemUidErrors;
    }

    static String arrayToString(int[] array2) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('[');
        if (array2 != null) {
            for (int i = 0; i < array2.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(array2[i]);
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new PackageManagerShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw)) {
            return;
        }
        DumpState dumpState = new DumpState();
        boolean fullPreferred = false;
        boolean checkin = false;
        String packageName = null;
        ArraySet<String> permissionNames = null;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) continue;
            if ("-h".equals(opt)) {
                pw.println("Package manager dump options:");
                pw.println("  [-h] [-f] [--checkin] [--all-components] [cmd] ...");
                pw.println("    --checkin: dump for a checkin");
                pw.println("    -f: print details of intent filters");
                pw.println("    -h: print this help");
                pw.println("    --all-components: include all component names in package dump");
                pw.println("  cmd may be one of:");
                pw.println("    apex: list active APEXes and APEX session state");
                pw.println("    l[ibraries]: list known shared libraries");
                pw.println("    f[eatures]: list device features");
                pw.println("    k[eysets]: print known keysets");
                pw.println("    r[esolvers] [activity|service|receiver|content]: dump intent resolvers");
                pw.println("    perm[issions]: dump permissions");
                pw.println("    permission [name ...]: dump declaration and use of given permission");
                pw.println("    pref[erred]: print preferred package settings");
                pw.println("    preferred-xml [--full]: print preferred package settings as xml");
                pw.println("    prov[iders]: dump content providers");
                pw.println("    p[ackages]: dump installed packages");
                pw.println("    s[hared-users]: dump shared user IDs");
                pw.println("    m[essages]: print collected runtime messages");
                pw.println("    v[erifiers]: print package verifier info");
                pw.println("    d[omain-preferred-apps]: print domains preferred apps");
                pw.println("    i[ntent-filter-verifiers]|ifv: print intent filter verifier info");
                pw.println("    version: print database version info");
                pw.println("    write: write current settings now");
                pw.println("    installs: details about install sessions");
                pw.println("    check-permission <permission> <package> [<user>]: does pkg hold perm?");
                pw.println("    dexopt: dump dexopt state");
                pw.println("    compiler-stats: dump compiler statistics");
                pw.println("    service-permissions: dump permissions required by services");
                pw.println("    <package.name>: info about given package");
                return;
            }
            if ("--checkin".equals(opt)) {
                checkin = true;
                continue;
            }
            if ("--all-components".equals(opt)) {
                dumpState.setOptionEnabled(2);
                continue;
            }
            if ("-f".equals(opt)) {
                dumpState.setOptionEnabled(1);
                continue;
            }
            if ("--proto".equals(opt)) {
                this.dumpProto(fd);
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if (PLATFORM_PACKAGE_NAME.equals(cmd) || cmd.contains(".")) {
                packageName = cmd;
                dumpState.setOptionEnabled(1);
            } else {
                if ("check-permission".equals(cmd)) {
                    if (opti >= args.length) {
                        pw.println("Error: check-permission missing permission argument");
                        return;
                    }
                    String perm = args[opti];
                    if (++opti >= args.length) {
                        pw.println("Error: check-permission missing package argument");
                        return;
                    }
                    String pkg = args[opti];
                    int user = UserHandle.getUserId(Binder.getCallingUid());
                    if (++opti < args.length) {
                        try {
                            user = Integer.parseInt(args[opti]);
                        }
                        catch (NumberFormatException e) {
                            pw.println("Error: check-permission user argument is not a number: " + args[opti]);
                            return;
                        }
                    }
                    pkg = this.resolveInternalPackageNameLPr(pkg, -1L);
                    pw.println(this.checkPermission(perm, pkg, user));
                    return;
                }
                if ("l".equals(cmd) || "libraries".equals(cmd)) {
                    dumpState.setDump(1);
                } else if ("f".equals(cmd) || "features".equals(cmd)) {
                    dumpState.setDump(2);
                } else if ("r".equals(cmd) || "resolvers".equals(cmd)) {
                    if (opti >= args.length) {
                        dumpState.setDump(60);
                    } else {
                        while (opti < args.length) {
                            String name = args[opti];
                            if ("a".equals(name) || "activity".equals(name)) {
                                dumpState.setDump(4);
                            } else if ("s".equals(name) || "service".equals(name)) {
                                dumpState.setDump(8);
                            } else if ("r".equals(name) || "receiver".equals(name)) {
                                dumpState.setDump(16);
                            } else if ("c".equals(name) || "content".equals(name)) {
                                dumpState.setDump(32);
                            } else {
                                pw.println("Error: unknown resolver table type: " + name);
                                return;
                            }
                            ++opti;
                        }
                    }
                } else if (TAG_PERMISSION.equals(cmd) || "permissions".equals(cmd)) {
                    dumpState.setDump(64);
                } else if ("permission".equals(cmd)) {
                    if (opti >= args.length) {
                        pw.println("Error: permission requires permission name");
                        return;
                    }
                    permissionNames = new ArraySet<String>();
                    while (opti < args.length) {
                        permissionNames.add(args[opti]);
                        ++opti;
                    }
                    dumpState.setDump(448);
                } else if ("pref".equals(cmd) || "preferred".equals(cmd)) {
                    dumpState.setDump(4096);
                } else if ("preferred-xml".equals(cmd)) {
                    dumpState.setDump(8192);
                    if (opti < args.length && "--full".equals(args[opti])) {
                        fullPreferred = true;
                        ++opti;
                    }
                } else if ("d".equals(cmd) || "domain-preferred-apps".equals(cmd)) {
                    dumpState.setDump(262144);
                } else if ("p".equals(cmd) || "packages".equals(cmd)) {
                    dumpState.setDump(128);
                } else if ("s".equals(cmd) || "shared-users".equals(cmd)) {
                    dumpState.setDump(256);
                    if (opti < args.length && "noperm".equals(args[opti])) {
                        dumpState.setOptionEnabled(4);
                    }
                } else if ("prov".equals(cmd) || "providers".equals(cmd)) {
                    dumpState.setDump(1024);
                } else if ("m".equals(cmd) || "messages".equals(cmd)) {
                    dumpState.setDump(512);
                } else if ("v".equals(cmd) || "verifiers".equals(cmd)) {
                    dumpState.setDump(2048);
                } else if ("i".equals(cmd) || "ifv".equals(cmd) || "intent-filter-verifiers".equals(cmd)) {
                    dumpState.setDump(131072);
                } else if ("version".equals(cmd)) {
                    dumpState.setDump(32768);
                } else if ("k".equals(cmd) || "keysets".equals(cmd)) {
                    dumpState.setDump(16384);
                } else if ("installs".equals(cmd)) {
                    dumpState.setDump(65536);
                } else if ("frozen".equals(cmd)) {
                    dumpState.setDump(524288);
                } else if ("volumes".equals(cmd)) {
                    dumpState.setDump(0x800000);
                } else if ("dexopt".equals(cmd)) {
                    dumpState.setDump(0x100000);
                } else if ("compiler-stats".equals(cmd)) {
                    dumpState.setDump(0x200000);
                } else if ("changes".equals(cmd)) {
                    dumpState.setDump(0x400000);
                } else if ("service-permissions".equals(cmd)) {
                    dumpState.setDump(0x1000000);
                } else if ("write".equals(cmd)) {
                    ArrayMap<String, PackageParser.Package> name = this.mPackages;
                    synchronized (name) {
                        this.mSettings.writeLPr();
                        pw.println("Settings written.");
                        return;
                    }
                }
            }
        }
        if (checkin) {
            pw.println("vers,1");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (dumpState.isDumping(32768) && packageName == null && !checkin) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Database versions:");
                this.mSettings.dumpVersionLPr(new IndentingPrintWriter((Writer)pw, "  "));
            }
            if (dumpState.isDumping(2048) && packageName == null) {
                if (!checkin) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println();
                    }
                    pw.println("Verifiers:");
                    pw.print("  Required: ");
                    pw.print(this.mRequiredVerifierPackage);
                    pw.print(" (uid=");
                    pw.print(this.getPackageUid(this.mRequiredVerifierPackage, 0x10000000, 0));
                    pw.println(")");
                } else if (this.mRequiredVerifierPackage != null) {
                    pw.print("vrfy,");
                    pw.print(this.mRequiredVerifierPackage);
                    pw.print(",");
                    pw.println(this.getPackageUid(this.mRequiredVerifierPackage, 0x10000000, 0));
                }
            }
            if (dumpState.isDumping(131072) && packageName == null) {
                if (this.mIntentFilterVerifierComponent != null) {
                    String verifierPackageName = this.mIntentFilterVerifierComponent.getPackageName();
                    if (!checkin) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("Intent Filter Verifier:");
                        pw.print("  Using: ");
                        pw.print(verifierPackageName);
                        pw.print(" (uid=");
                        pw.print(this.getPackageUid(verifierPackageName, 0x10000000, 0));
                        pw.println(")");
                    } else if (verifierPackageName != null) {
                        pw.print("ifv,");
                        pw.print(verifierPackageName);
                        pw.print(",");
                        pw.println(this.getPackageUid(verifierPackageName, 0x10000000, 0));
                    }
                } else {
                    pw.println();
                    pw.println("No Intent Filter Verifier available!");
                }
            }
            if (dumpState.isDumping(1) && packageName == null) {
                boolean printedHeader = false;
                for (String libName : this.mSharedLibraries.keySet()) {
                    LongSparseArray<SharedLibraryInfo> versionedLib = this.mSharedLibraries.get(libName);
                    if (versionedLib == null) continue;
                    int versionCount = versionedLib.size();
                    for (int i = 0; i < versionCount; ++i) {
                        SharedLibraryInfo libraryInfo = versionedLib.valueAt(i);
                        if (!checkin) {
                            if (!printedHeader) {
                                if (dumpState.onTitlePrinted()) {
                                    pw.println();
                                }
                                pw.println("Libraries:");
                                printedHeader = true;
                            }
                            pw.print("  ");
                        } else {
                            pw.print("lib,");
                        }
                        pw.print(libraryInfo.getName());
                        if (libraryInfo.isStatic()) {
                            pw.print(" version=" + libraryInfo.getLongVersion());
                        }
                        if (!checkin) {
                            pw.print(" -> ");
                        }
                        if (libraryInfo.getPath() != null) {
                            pw.print(" (jar) ");
                            pw.print(libraryInfo.getPath());
                        } else {
                            pw.print(" (apk) ");
                            pw.print(libraryInfo.getPackageName());
                        }
                        pw.println();
                    }
                }
            }
            if (dumpState.isDumping(2) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                if (!checkin) {
                    pw.println("Features:");
                }
                ArrayMap<String, FeatureInfo> printedHeader = this.mAvailableFeatures;
                synchronized (printedHeader) {
                    for (FeatureInfo feat : this.mAvailableFeatures.values()) {
                        if (checkin) {
                            pw.print("feat,");
                            pw.print(feat.name);
                            pw.print(",");
                            pw.println(feat.version);
                            continue;
                        }
                        pw.print("  ");
                        pw.print(feat.name);
                        if (feat.version > 0) {
                            pw.print(" version=");
                            pw.print(feat.version);
                        }
                        pw.println();
                    }
                }
            }
            if (!checkin && dumpState.isDumping(4)) {
                this.mComponentResolver.dumpActivityResolvers(pw, dumpState, packageName);
            }
            if (!checkin && dumpState.isDumping(16)) {
                this.mComponentResolver.dumpReceiverResolvers(pw, dumpState, packageName);
            }
            if (!checkin && dumpState.isDumping(8)) {
                this.mComponentResolver.dumpServiceResolvers(pw, dumpState, packageName);
            }
            if (!checkin && dumpState.isDumping(32)) {
                this.mComponentResolver.dumpProviderResolvers(pw, dumpState, packageName);
            }
            if (!checkin && dumpState.isDumping(4096)) {
                for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
                    PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
                    int user = this.mSettings.mPreferredActivities.keyAt(i);
                    if (!pir.dump(pw, dumpState.getTitlePrinted() ? "\nPreferred Activities User " + user + ":" : "Preferred Activities User " + user + ":", "  ", packageName, true, false)) continue;
                    dumpState.setTitlePrinted(true);
                }
            }
            if (!checkin && dumpState.isDumping(8192)) {
                pw.flush();
                FileOutputStream fout = new FileOutputStream(fd);
                BufferedOutputStream str = new BufferedOutputStream(fout);
                FastXmlSerializer serializer = new FastXmlSerializer();
                try {
                    serializer.setOutput(str, StandardCharsets.UTF_8.name());
                    serializer.startDocument(null, true);
                    serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                    this.mSettings.writePreferredActivitiesLPr(serializer, 0, fullPreferred);
                    serializer.endDocument();
                    serializer.flush();
                }
                catch (IllegalArgumentException e) {
                    pw.println("Failed writing: " + e);
                }
                catch (IllegalStateException e) {
                    pw.println("Failed writing: " + e);
                }
                catch (IOException e) {
                    pw.println("Failed writing: " + e);
                }
            }
            if (!checkin && dumpState.isDumping(262144) && packageName == null) {
                pw.println();
                int count = this.mSettings.mPackages.size();
                if (count == 0) {
                    pw.println("No applications!");
                    pw.println();
                } else {
                    String prefix = "  ";
                    Collection<PackageSetting> allPackageSettings = this.mSettings.mPackages.values();
                    if (allPackageSettings.size() == 0) {
                        pw.println("No domain preferred apps!");
                        pw.println();
                    } else {
                        pw.println("App verification status:");
                        pw.println();
                        count = 0;
                        for (PackageSetting ps : allPackageSettings) {
                            IntentFilterVerificationInfo ivi = ps.getIntentFilterVerificationInfo();
                            if (ivi == null || ivi.getPackageName() == null) continue;
                            pw.println("  Package: " + ivi.getPackageName());
                            pw.println("  Domains: " + ivi.getDomainsString());
                            pw.println("  Status:  " + ivi.getStatusString());
                            pw.println();
                            ++count;
                        }
                        if (count == 0) {
                            pw.println("  No app verification established.");
                            pw.println();
                        }
                        for (Object userId : (Object)sUserManager.getUserIds()) {
                            pw.println("App linkages for user " + (int)userId + ":");
                            pw.println();
                            count = 0;
                            for (PackageSetting ps : allPackageSettings) {
                                long status = ps.getDomainVerificationStatusForUser((int)userId);
                                if (status >> 32 == 0L) continue;
                                pw.println("  Package: " + ps.name);
                                pw.println("  Domains: " + this.dumpDomainString(ps.name));
                                String statusStr = IntentFilterVerificationInfo.getStatusStringFromValue(status);
                                pw.println("  Status:  " + statusStr);
                                pw.println();
                                ++count;
                            }
                            if (count != 0) continue;
                            pw.println("  No configured app linkages.");
                            pw.println();
                        }
                    }
                }
            }
            if (!checkin && dumpState.isDumping(64)) {
                this.mSettings.dumpPermissionsLPr(pw, packageName, permissionNames, dumpState);
            }
            if (!checkin && dumpState.isDumping(1024)) {
                this.mComponentResolver.dumpContentProviders(pw, dumpState, packageName);
            }
            if (!checkin && dumpState.isDumping(16384)) {
                this.mSettings.mKeySetManagerService.dumpLPr(pw, packageName, dumpState);
            }
            if (dumpState.isDumping(128)) {
                this.mSettings.dumpPackagesLPr(pw, packageName, permissionNames, dumpState, checkin);
            }
            if (dumpState.isDumping(256)) {
                this.mSettings.dumpSharedUsersLPr(pw, packageName, permissionNames, dumpState, checkin);
            }
            if (dumpState.isDumping(0x400000)) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Package Changes:");
                pw.print("  Sequence number=");
                pw.println(this.mChangedPackagesSequenceNumber);
                int K = this.mChangedPackages.size();
                for (int i = 0; i < K; ++i) {
                    SparseArray<String> changes = this.mChangedPackages.valueAt(i);
                    pw.print("  User ");
                    pw.print(this.mChangedPackages.keyAt(i));
                    pw.println(":");
                    int N = changes.size();
                    if (N == 0) {
                        pw.print("    ");
                        pw.println("No packages changed");
                        continue;
                    }
                    for (int j = 0; j < N; ++j) {
                        String pkgName = changes.valueAt(j);
                        int sequenceNumber = changes.keyAt(j);
                        pw.print("    ");
                        pw.print("seq=");
                        pw.print(sequenceNumber);
                        pw.print(", package=");
                        pw.println(pkgName);
                    }
                }
            }
            if (!checkin && dumpState.isDumping(524288) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                IndentingPrintWriter ipw = new IndentingPrintWriter(pw, "  ", 120);
                ipw.println();
                ipw.println("Frozen packages:");
                ipw.increaseIndent();
                if (this.mFrozenPackages.size() == 0) {
                    ipw.println("(none)");
                } else {
                    for (int i = 0; i < this.mFrozenPackages.size(); ++i) {
                        ipw.println(this.mFrozenPackages.valueAt(i));
                    }
                }
                ipw.decreaseIndent();
            }
            if (!checkin && dumpState.isDumping(0x800000) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                IndentingPrintWriter ipw = new IndentingPrintWriter(pw, "  ", 120);
                ipw.println();
                ipw.println("Loaded volumes:");
                ipw.increaseIndent();
                if (this.mLoadedVolumes.size() == 0) {
                    ipw.println("(none)");
                } else {
                    for (int i = 0; i < this.mLoadedVolumes.size(); ++i) {
                        ipw.println(this.mLoadedVolumes.valueAt(i));
                    }
                }
                ipw.decreaseIndent();
            }
            if (!checkin && dumpState.isDumping(0x1000000) && packageName == null) {
                this.mComponentResolver.dumpServicePermissions(pw, dumpState, packageName);
            }
            if (!checkin && dumpState.isDumping(0x100000)) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.dumpDexoptStateLPr(pw, packageName);
            }
            if (!checkin && dumpState.isDumping(0x200000)) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.dumpCompilerStatsLPr(pw, packageName);
            }
            if (!checkin && dumpState.isDumping(512) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.mSettings.dumpReadMessagesLPr(pw, dumpState);
                pw.println();
                pw.println("Package warning messages:");
                PackageManagerServiceUtils.dumpCriticalInfo(pw, null);
            }
            if (checkin && dumpState.isDumping(512)) {
                PackageManagerServiceUtils.dumpCriticalInfo(pw, "msg,");
            }
        }
        if (!checkin && dumpState.isDumping(65536) && packageName == null) {
            if (dumpState.onTitlePrinted()) {
                pw.println();
            }
            this.mInstallerService.dump(new IndentingPrintWriter(pw, "  ", 120));
        }
        if (!checkin && dumpState.isDumping(0x2000000)) {
            this.mApexManager.dump(pw, packageName);
        }
    }

    private void disableSkuSpecificApps() {
        String[] apkList = this.mContext.getResources().getStringArray(17236009);
        String[] skuArray = this.mContext.getResources().getStringArray(17236008);
        if (ArrayUtils.isEmpty(apkList)) {
            return;
        }
        String sku = SystemProperties.get("ro.boot.hardware.sku");
        if (!TextUtils.isEmpty(sku) && ArrayUtils.contains(skuArray, sku)) {
            return;
        }
        for (String packageName : apkList) {
            this.setSystemAppHiddenUntilInstalled(packageName, true);
            for (UserInfo user : sUserManager.getUsers(false)) {
                this.setSystemAppInstallState(packageName, false, user.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpProto(FileDescriptor fd) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            long requiredVerifierPackageToken = proto.start(0x10B00000001L);
            proto.write(0x10900000001L, this.mRequiredVerifierPackage);
            proto.write(1120986464258L, this.getPackageUid(this.mRequiredVerifierPackage, 0x10000000, 0));
            proto.end(requiredVerifierPackageToken);
            if (this.mIntentFilterVerifierComponent != null) {
                String verifierPackageName = this.mIntentFilterVerifierComponent.getPackageName();
                long verifierPackageToken = proto.start(1146756268034L);
                proto.write(0x10900000001L, verifierPackageName);
                proto.write(1120986464258L, this.getPackageUid(verifierPackageName, 0x10000000, 0));
                proto.end(verifierPackageToken);
            }
            this.dumpSharedLibrariesProto(proto);
            this.dumpFeaturesProto(proto);
            this.mSettings.dumpPackagesProto(proto);
            this.mSettings.dumpSharedUsersProto(proto);
            PackageManagerServiceUtils.dumpCriticalInfo(proto);
        }
        proto.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFeaturesProto(ProtoOutputStream proto) {
        ArrayMap<String, FeatureInfo> arrayMap = this.mAvailableFeatures;
        synchronized (arrayMap) {
            int count = this.mAvailableFeatures.size();
            for (int i = 0; i < count; ++i) {
                this.mAvailableFeatures.valueAt(i).writeToProto(proto, 2246267895812L);
            }
        }
    }

    private void dumpSharedLibrariesProto(ProtoOutputStream proto) {
        int count = this.mSharedLibraries.size();
        for (int i = 0; i < count; ++i) {
            String libName = this.mSharedLibraries.keyAt(i);
            LongSparseArray<SharedLibraryInfo> versionedLib = this.mSharedLibraries.get(libName);
            if (versionedLib == null) continue;
            int versionCount = versionedLib.size();
            for (int j = 0; j < versionCount; ++j) {
                SharedLibraryInfo libraryInfo = versionedLib.valueAt(j);
                long sharedLibraryToken = proto.start(2246267895811L);
                proto.write(0x10900000001L, libraryInfo.getName());
                boolean isJar = libraryInfo.getPath() != null;
                proto.write(1133871366146L, isJar);
                if (isJar) {
                    proto.write(1138166333443L, libraryInfo.getPath());
                } else {
                    proto.write(1138166333444L, libraryInfo.getPackageName());
                }
                proto.end(sharedLibraryToken);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @GuardedBy(value={"mPackages"})
    private void dumpDexoptStateLPr(PrintWriter pw, String packageName) {
        Collection<PackageParser.Package> packages;
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        ipw.println();
        ipw.println("Dexopt state:");
        ipw.increaseIndent();
        if (packageName != null) {
            PackageParser.Package targetPackage = this.mPackages.get(packageName);
            if (targetPackage == null) {
                ipw.println("Unable to find package: " + packageName);
                return;
            }
            packages = Collections.singletonList(targetPackage);
        } else {
            packages = this.mPackages.values();
        }
        Iterator<PackageParser.Package> iterator = packages.iterator();
        while (iterator.hasNext()) {
            PackageParser.Package pkg = iterator.next();
            ipw.println("[" + pkg.packageName + "]");
            ipw.increaseIndent();
            this.mPackageDexOptimizer.dumpDexoptState(ipw, pkg, this.mDexManager.getPackageUseInfoOrDefault(pkg.packageName));
            ipw.decreaseIndent();
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @GuardedBy(value={"mPackages"})
    private void dumpCompilerStatsLPr(PrintWriter pw, String packageName) {
        Collection<PackageParser.Package> packages;
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        ipw.println();
        ipw.println("Compiler stats:");
        ipw.increaseIndent();
        if (packageName != null) {
            PackageParser.Package targetPackage = this.mPackages.get(packageName);
            if (targetPackage == null) {
                ipw.println("Unable to find package: " + packageName);
                return;
            }
            packages = Collections.singletonList(targetPackage);
        } else {
            packages = this.mPackages.values();
        }
        Iterator<PackageParser.Package> iterator = packages.iterator();
        while (iterator.hasNext()) {
            PackageParser.Package pkg = iterator.next();
            ipw.println("[" + pkg.packageName + "]");
            ipw.increaseIndent();
            CompilerStats.PackageStats stats = this.getCompilerPackageStats(pkg.packageName);
            if (stats == null) {
                ipw.println("(No recorded stats)");
            } else {
                stats.dump(ipw);
            }
            ipw.decreaseIndent();
        }
        return;
    }

    private String dumpDomainString(String packageName) {
        List iviList = this.getIntentFilterVerifications(packageName).getList();
        List filters = this.getAllIntentFilters(packageName).getList();
        ArraySet<String> result = new ArraySet<String>();
        if (iviList.size() > 0) {
            for (IntentFilterVerificationInfo ivi : iviList) {
                result.addAll(ivi.getDomains());
            }
        }
        if (filters != null && filters.size() > 0) {
            for (IntentFilter filter : filters) {
                if (!filter.hasCategory("android.intent.category.BROWSABLE") || !filter.hasDataScheme("http") && !filter.hasDataScheme("https")) continue;
                result.addAll(filter.getHostsList());
            }
        }
        StringBuilder sb = new StringBuilder(result.size() * 16);
        for (String domain : result) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(domain);
        }
        return sb.toString();
    }

    static String getEncryptKey() {
        try {
            String sdEncKey = SystemKeyStore.getInstance().retrieveKeyHexString(SD_ENCRYPTION_KEYSTORE_NAME);
            if (sdEncKey == null && (sdEncKey = SystemKeyStore.getInstance().generateNewKeyHexString(128, SD_ENCRYPTION_ALGORITHM, SD_ENCRYPTION_KEYSTORE_NAME)) == null) {
                Slog.e(TAG, "Failed to create encryption keys");
                return null;
            }
            return sdEncKey;
        }
        catch (NoSuchAlgorithmException nsae) {
            Slog.e(TAG, "Failed to create encryption keys with exception: " + nsae);
            return null;
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Failed to retrieve encryption keys with exception: " + ioe);
            return null;
        }
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, ArrayList<ApplicationInfo> infos, IIntentReceiver finishedReceiver) {
        int size = infos.size();
        String[] packageNames = new String[size];
        int[] packageUids = new int[size];
        for (int i = 0; i < size; ++i) {
            ApplicationInfo info = infos.get(i);
            packageNames[i] = info.packageName;
            packageUids[i] = info.uid;
        }
        this.sendResourcesChangedBroadcast(mediaStatus, replacing, packageNames, packageUids, finishedReceiver);
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, ArrayList<String> pkgList, int[] uidArr, IIntentReceiver finishedReceiver) {
        this.sendResourcesChangedBroadcast(mediaStatus, replacing, pkgList.toArray(new String[pkgList.size()]), uidArr, finishedReceiver);
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, String[] pkgList, int[] uidArr, IIntentReceiver finishedReceiver) {
        int size = pkgList.length;
        if (size > 0) {
            Bundle extras = new Bundle();
            extras.putStringArray("android.intent.extra.changed_package_list", pkgList);
            if (uidArr != null) {
                extras.putIntArray("android.intent.extra.changed_uid_list", uidArr);
            }
            if (replacing) {
                extras.putBoolean("android.intent.extra.REPLACING", replacing);
            }
            String action = mediaStatus ? "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE" : "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE";
            this.sendPackageBroadcast(action, null, extras, 0, null, finishedReceiver, null, null);
        }
    }

    private void loadPrivatePackages(VolumeInfo vol) {
        this.mHandler.post(() -> this.loadPrivatePackagesInner(vol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrivatePackagesInner(VolumeInfo vol) {
        List<PackageSetting> packages;
        Settings.VersionInfo ver;
        String volumeUuid = vol.fsUuid;
        if (TextUtils.isEmpty(volumeUuid)) {
            Slog.e(TAG, "Loading internal storage is probably a mistake; ignoring");
            return;
        }
        ArrayList<PackageFreezer> freezers = new ArrayList<PackageFreezer>();
        ArrayList<ApplicationInfo> loaded = new ArrayList<ApplicationInfo>();
        int parseFlags = this.mDefParseFlags | 8;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ver = this.mSettings.findOrCreateVersion(volumeUuid);
            packages = this.mSettings.getVolumePackagesLPr(volumeUuid);
        }
        for (PackageSetting ps : packages) {
            freezers.add(this.freezePackage(ps.name, "loadPrivatePackagesInner"));
            Object object = this.mInstallLock;
            synchronized (object) {
                try {
                    PackageParser.Package pkg = this.scanPackageTracedLI(ps.codePath, parseFlags, 512, 0L, null);
                    loaded.add(pkg.applicationInfo);
                }
                catch (PackageManagerException e) {
                    Slog.w(TAG, "Failed to scan " + ps.codePath + ": " + e.getMessage());
                }
                if (!Build.FINGERPRINT.equals(ver.fingerprint)) {
                    this.clearAppDataLIF(ps.pkg, -1, 39);
                }
            }
        }
        StorageManager sm = this.mContext.getSystemService(StorageManager.class);
        UserManager um = this.mContext.getSystemService(UserManager.class);
        UserManagerInternal umInternal = this.getUserManagerInternal();
        for (UserInfo user : um.getUsers()) {
            int flags;
            if (umInternal.isUserUnlockingOrUnlocked(user.id)) {
                flags = 3;
            } else {
                if (!umInternal.isUserRunning(user.id)) continue;
                flags = 1;
            }
            try {
                sm.prepareUserStorage(volumeUuid, user.id, user.serialNumber, flags);
                Object object = this.mInstallLock;
                synchronized (object) {
                    this.reconcileAppsDataLI(volumeUuid, user.id, flags, true);
                }
            }
            catch (IllegalStateException e) {
                Slog.w(TAG, "Failed to prepare storage: " + e);
            }
        }
        Iterator iterator = this.mPackages;
        synchronized (iterator) {
            boolean sdkUpdated;
            boolean bl = sdkUpdated = ver.sdkVersion != this.mSdkVersion;
            if (sdkUpdated) {
                PackageManagerServiceUtils.logCriticalInfo(4, "Platform changed from " + ver.sdkVersion + " to " + this.mSdkVersion + "; regranting permissions for " + volumeUuid);
            }
            this.mPermissionManager.updateAllPermissions(volumeUuid, sdkUpdated, this.mPackages.values(), this.mPermissionCallback);
            ver.forceCurrent();
            this.mSettings.writeLPr();
        }
        for (PackageFreezer freezer : freezers) {
            freezer.close();
        }
        this.sendResourcesChangedBroadcast(true, false, loaded, null);
        this.mLoadedVolumes.add(vol.getId());
    }

    private void unloadPrivatePackages(VolumeInfo vol) {
        this.mHandler.post(() -> this.unloadPrivatePackagesInner(vol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadPrivatePackagesInner(VolumeInfo vol) {
        String volumeUuid = vol.fsUuid;
        if (TextUtils.isEmpty(volumeUuid)) {
            Slog.e(TAG, "Unloading internal storage is probably a mistake; ignoring");
            return;
        }
        ArrayList<ApplicationInfo> unloaded = new ArrayList<ApplicationInfo>();
        Object object = this.mInstallLock;
        synchronized (object) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                List<PackageSetting> packages = this.mSettings.getVolumePackagesLPr(volumeUuid);
                for (PackageSetting ps : packages) {
                    if (ps.pkg == null) continue;
                    ApplicationInfo info = ps.pkg.applicationInfo;
                    boolean deleteFlags = true;
                    PackageRemovedInfo outInfo = new PackageRemovedInfo(this);
                    try (PackageFreezer freezer = this.freezePackageForDelete(ps.name, 1, "unloadPrivatePackagesInner");){
                        if (this.deletePackageLIF(ps.name, null, false, null, 1, outInfo, false, null)) {
                            unloaded.add(info);
                        } else {
                            Slog.w(TAG, "Failed to unload " + ps.codePath);
                        }
                    }
                    AttributeCache.instance().removePackage(ps.name);
                }
                this.mSettings.writeLPr();
            }
        }
        this.sendResourcesChangedBroadcast(false, false, unloaded, null);
        this.mLoadedVolumes.remove(vol.getId());
        ResourcesManager.getInstance().invalidatePath(vol.getPath().getAbsolutePath());
        for (int i = 0; i < 3; ++i) {
            System.gc();
            System.runFinalization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertPackageKnownAndInstalled(String volumeUuid, String packageName, int userId) throws PackageManagerException {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            packageName = this.normalizePackageNameLPr(packageName);
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                throw new PackageManagerException("Package " + packageName + " is unknown");
            }
            if (!TextUtils.equals(volumeUuid, ps.volumeUuid)) {
                throw new PackageManagerException("Package " + packageName + " found on unknown volume " + volumeUuid + "; expected volume " + ps.volumeUuid);
            }
            if (!ps.getInstalled(userId)) {
                throw new PackageManagerException("Package " + packageName + " not installed for user " + userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> collectAbsoluteCodePaths() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<String> codePaths = new ArrayList<String>();
            int packageCount = this.mSettings.mPackages.size();
            for (int i = 0; i < packageCount; ++i) {
                PackageSetting ps = this.mSettings.mPackages.valueAt(i);
                codePaths.add(ps.codePath.getAbsolutePath());
            }
            return codePaths;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileApps(String volumeUuid) {
        File[] files;
        List<String> absoluteCodePaths = this.collectAbsoluteCodePaths();
        ArrayList<File> filesToDelete = null;
        for (File file : files = FileUtils.listFilesOrEmpty(Environment.getDataAppDirectory(volumeUuid))) {
            boolean isPackage;
            boolean bl = isPackage = (PackageParser.isApkFile(file) || file.isDirectory()) && !PackageInstallerService.isStageName(file.getName());
            if (!isPackage) continue;
            String absolutePath = file.getAbsolutePath();
            boolean pathValid = false;
            int absoluteCodePathCount = absoluteCodePaths.size();
            for (int i = 0; i < absoluteCodePathCount; ++i) {
                String absoluteCodePath = absoluteCodePaths.get(i);
                if (!absolutePath.startsWith(absoluteCodePath)) continue;
                pathValid = true;
                break;
            }
            if (pathValid) continue;
            if (filesToDelete == null) {
                filesToDelete = new ArrayList<File>();
            }
            filesToDelete.add(file);
        }
        if (filesToDelete != null) {
            int fileToDeleteCount = filesToDelete.size();
            for (int i = 0; i < fileToDeleteCount; ++i) {
                File fileToDelete = (File)filesToDelete.get(i);
                PackageManagerServiceUtils.logCriticalInfo(5, "Destroying orphaned" + fileToDelete);
                Object object = this.mInstallLock;
                synchronized (object) {
                    this.removeCodePathLI(fileToDelete);
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconcileAppsData(int userId, int flags, boolean migrateAppsData) {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        for (VolumeInfo vol : storage.getWritablePrivateVolumes()) {
            String volumeUuid = vol.getFsUuid();
            Object object = this.mInstallLock;
            synchronized (object) {
                this.reconcileAppsDataLI(volumeUuid, userId, flags, migrateAppsData);
            }
        }
    }

    @GuardedBy(value={"mInstallLock"})
    private void reconcileAppsDataLI(String volumeUuid, int userId, int flags, boolean migrateAppData) {
        this.reconcileAppsDataLI(volumeUuid, userId, flags, migrateAppData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @GuardedBy(value={"mInstallLock"})
    private List<String> reconcileAppsDataLI(String volumeUuid, int userId, int flags, boolean migrateAppData, boolean onlyCoreApps) {
        void var10_15;
        List<PackageSetting> packages;
        String packageName;
        File[] files;
        Slog.v(TAG, "reconcileAppsData for " + volumeUuid + " u" + userId + " 0x" + Integer.toHexString(flags) + " migrateAppData=" + migrateAppData);
        ArrayList<String> result = onlyCoreApps ? new ArrayList<String>() : null;
        File ceDir = Environment.getDataUserCeDirectory(volumeUuid, userId);
        File deDir = Environment.getDataUserDeDirectory(volumeUuid, userId);
        if ((flags & 2) != 0) {
            if (StorageManager.isFileEncryptedNativeOrEmulated() && !StorageManager.isUserKeyUnlocked(userId)) {
                throw new RuntimeException("Yikes, someone asked us to reconcile CE storage while " + userId + " was still locked; this would have caused massive data loss!");
            }
            for (File file : files = FileUtils.listFilesOrEmpty(ceDir)) {
                packageName = file.getName();
                try {
                    this.assertPackageKnownAndInstalled(volumeUuid, packageName, userId);
                }
                catch (PackageManagerException e) {
                    PackageManagerServiceUtils.logCriticalInfo(5, "Destroying " + file + " due to: " + e);
                    try {
                        this.mInstaller.destroyAppData(volumeUuid, packageName, userId, 2, 0L);
                    }
                    catch (Installer.InstallerException e2) {
                        PackageManagerServiceUtils.logCriticalInfo(5, "Failed to destroy: " + e2);
                    }
                }
            }
        }
        if ((flags & 1) != 0) {
            for (File file : files = FileUtils.listFilesOrEmpty(deDir)) {
                packageName = file.getName();
                try {
                    this.assertPackageKnownAndInstalled(volumeUuid, packageName, userId);
                }
                catch (PackageManagerException e) {
                    PackageManagerServiceUtils.logCriticalInfo(5, "Destroying " + file + " due to: " + e);
                    try {
                        this.mInstaller.destroyAppData(volumeUuid, packageName, userId, 1, 0L);
                    }
                    catch (Installer.InstallerException e2) {
                        PackageManagerServiceUtils.logCriticalInfo(5, "Failed to destroy: " + e2);
                    }
                }
            }
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            packages = this.mSettings.getVolumePackagesLPr(volumeUuid);
        }
        boolean bl = false;
        for (PackageSetting ps : packages) {
            String packageName2 = ps.name;
            if (ps.pkg == null) {
                Slog.w(TAG, "Odd, missing scanned package " + packageName2);
                continue;
            }
            if (onlyCoreApps && !ps.pkg.coreApp) {
                result.add(packageName2);
                continue;
            }
            if (!ps.getInstalled(userId)) continue;
            this.prepareAppDataAndMigrateLIF(ps.pkg, userId, flags, migrateAppData);
            ++var10_15;
        }
        Slog.v(TAG, "reconcileAppsData finished " + (int)var10_15 + " packages");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAppDataAfterInstallLIF(PackageParser.Package pkg) {
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(pkg.packageName);
            this.mSettings.writeKernelMappingLPr(ps);
        }
        UserManager um = this.mContext.getSystemService(UserManager.class);
        UserManagerInternal umInternal = this.getUserManagerInternal();
        for (UserInfo user : um.getUsers()) {
            int flags;
            if (umInternal.isUserUnlockingOrUnlocked(user.id)) {
                flags = 3;
            } else {
                if (!umInternal.isUserRunning(user.id)) continue;
                flags = 1;
            }
            if (!ps.getInstalled(user.id)) continue;
            this.prepareAppDataLIF(pkg, user.id, flags);
        }
    }

    private void prepareAppDataLIF(PackageParser.Package pkg, int userId, int flags) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.prepareAppDataLeafLIF(pkg, userId, flags);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.prepareAppDataLeafLIF(pkg.childPackages.get(i), userId, flags);
        }
    }

    private void prepareAppDataAndMigrateLIF(PackageParser.Package pkg, int userId, int flags, boolean maybeMigrateAppData) {
        this.prepareAppDataLIF(pkg, userId, flags);
        if (maybeMigrateAppData && this.maybeMigrateAppDataLIF(pkg, userId)) {
            this.prepareAppDataLIF(pkg, userId, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAppDataLeafLIF(PackageParser.Package pkg, int userId, int flags) {
        ApplicationInfo app;
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(pkg.packageName);
        }
        String volumeUuid = pkg.volumeUuid;
        String packageName = pkg.packageName;
        ApplicationInfo applicationInfo = app = ps == null ? pkg.applicationInfo : PackageParser.generateApplicationInfo(pkg, 0, ps.readUserState(userId), userId);
        if (app == null) {
            app = pkg.applicationInfo;
        }
        int appId = UserHandle.getAppId(app.uid);
        Preconditions.checkNotNull(app.seInfo);
        String seInfo = app.seInfo + (app.seInfoUser != null ? app.seInfoUser : "");
        long ceDataInode = -1L;
        try {
            ceDataInode = this.mInstaller.createAppData(volumeUuid, packageName, userId, flags, appId, seInfo, app.targetSdkVersion);
        }
        catch (Installer.InstallerException e) {
            if (app.isSystemApp()) {
                PackageManagerServiceUtils.logCriticalInfo(6, "Failed to create app data for " + packageName + ", but trying to recover: " + e);
                this.destroyAppDataLeafLIF(pkg, userId, flags);
                try {
                    ceDataInode = this.mInstaller.createAppData(volumeUuid, packageName, userId, flags, appId, seInfo, app.targetSdkVersion);
                    PackageManagerServiceUtils.logCriticalInfo(3, "Recovery succeeded!");
                }
                catch (Installer.InstallerException e2) {
                    PackageManagerServiceUtils.logCriticalInfo(3, "Recovery failed!");
                }
            }
            Slog.e(TAG, "Failed to create app data for " + packageName + ": " + e);
        }
        if (this.mIsUpgrade || this.mFirstBoot || userId != 0) {
            this.mArtManagerService.prepareAppProfiles(pkg, userId, false);
        }
        if ((flags & 2) != 0 && ceDataInode != -1L) {
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                if (ps != null) {
                    ps.setCeDataInode(ceDataInode, userId);
                }
            }
        }
        this.prepareAppDataContentsLeafLIF(pkg, userId, flags);
    }

    private void prepareAppDataContentsLIF(PackageParser.Package pkg, int userId, int flags) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.prepareAppDataContentsLeafLIF(pkg, userId, flags);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.prepareAppDataContentsLeafLIF(pkg.childPackages.get(i), userId, flags);
        }
    }

    private void prepareAppDataContentsLeafLIF(PackageParser.Package pkg, int userId, int flags) {
        String volumeUuid = pkg.volumeUuid;
        String packageName = pkg.packageName;
        ApplicationInfo app = pkg.applicationInfo;
        if ((flags & 2) != 0 && app.primaryCpuAbi != null && !VMRuntime.is64BitAbi(app.primaryCpuAbi)) {
            String nativeLibPath = app.nativeLibraryDir;
            try {
                this.mInstaller.linkNativeLibraryDirectory(volumeUuid, packageName, nativeLibPath, userId);
            }
            catch (Installer.InstallerException e) {
                Slog.e(TAG, "Failed to link native for " + packageName + ": " + e);
            }
        }
    }

    private boolean maybeMigrateAppDataLIF(PackageParser.Package pkg, int userId) {
        if (pkg.isSystem() && !StorageManager.isFileEncryptedNativeOrEmulated()) {
            int storageTarget = pkg.applicationInfo.isDefaultToDeviceProtectedStorage() ? 1 : 2;
            try {
                this.mInstaller.migrateAppData(pkg.volumeUuid, pkg.packageName, userId, storageTarget);
            }
            catch (Installer.InstallerException e) {
                PackageManagerServiceUtils.logCriticalInfo(5, "Failed to migrate " + pkg.packageName + ": " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    public PackageFreezer freezePackage(String packageName, String killReason) {
        return this.freezePackage(packageName, -1, killReason);
    }

    public PackageFreezer freezePackage(String packageName, int userId, String killReason) {
        return new PackageFreezer(packageName, userId, killReason);
    }

    public PackageFreezer freezePackageForInstall(String packageName, int installFlags, String killReason) {
        return this.freezePackageForInstall(packageName, -1, installFlags, killReason);
    }

    public PackageFreezer freezePackageForInstall(String packageName, int userId, int installFlags, String killReason) {
        if ((installFlags & 0x1000) != 0) {
            return new PackageFreezer();
        }
        return this.freezePackage(packageName, userId, killReason);
    }

    public PackageFreezer freezePackageForDelete(String packageName, int deleteFlags, String killReason) {
        return this.freezePackageForDelete(packageName, -1, deleteFlags, killReason);
    }

    public PackageFreezer freezePackageForDelete(String packageName, int userId, int deleteFlags, String killReason) {
        if ((deleteFlags & 8) != 0) {
            return new PackageFreezer();
        }
        return this.freezePackage(packageName, userId, killReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPackageFrozen(String packageName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (!this.mFrozenPackages.contains(packageName)) {
                Slog.wtf(TAG, "Expected " + packageName + " to be frozen!", new Throwable());
            }
        }
    }

    @Override
    public int movePackage(String packageName, String volumeUuid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOVE_PACKAGE", null);
        int callingUid = Binder.getCallingUid();
        UserHandle user = new UserHandle(UserHandle.getUserId(callingUid));
        int moveId = this.mNextMoveId.getAndIncrement();
        this.mHandler.post(() -> {
            try {
                this.movePackageInternal(packageName, volumeUuid, moveId, callingUid, user);
            }
            catch (PackageManagerException e) {
                Slog.w(TAG, "Failed to move " + packageName, e);
                this.mMoveCallbacks.notifyStatusChanged(moveId, e.error);
            }
        });
        return moveId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePackageInternal(final String packageName, String volumeUuid, final int moveId, int callingUid, UserHandle user) throws PackageManagerException {
        MoveInfo move;
        File measurePath;
        boolean moveCompleteApp;
        int[] installedUserIds;
        PackageFreezer freezer;
        int targetSdkVersion;
        String label;
        String seinfo;
        int appId;
        String packageAbiOverride;
        String installerPackageName;
        File codeFile;
        boolean isCurrentLocationExternal;
        Object probe;
        String currentVolumeUuid;
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        PackageManager pm = this.mContext.getPackageManager();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (pkg == null || ps == null || this.filterAppAccessLPr(ps, callingUid, user.getIdentifier())) {
                throw new PackageManagerException(-2, "Missing package");
            }
            if (pkg.applicationInfo.isSystemApp()) {
                throw new PackageManagerException(-3, "Cannot move system application");
            }
            boolean isInternalStorage = "private".equals(volumeUuid);
            boolean allow3rdPartyOnInternal = this.mContext.getResources().getBoolean(0x111000B);
            if (isInternalStorage && !allow3rdPartyOnInternal) {
                throw new PackageManagerException(-9, "3rd party apps are not allowed on internal storage");
            }
            currentVolumeUuid = ps.volumeUuid;
            probe = new File(pkg.codePath);
            File probeOat = new File((File)probe, "oat");
            if (!((File)probe).isDirectory() || !probeOat.isDirectory()) {
                throw new PackageManagerException(-6, "Move only supported for modern cluster style installs");
            }
            if (Objects.equals(currentVolumeUuid, volumeUuid)) {
                throw new PackageManagerException(-6, "Package already moved to " + volumeUuid);
            }
            if (pkg.applicationInfo.isInternal() && this.isPackageDeviceAdminOnAnyUser(packageName)) {
                throw new PackageManagerException(-8, "Device admin cannot be moved");
            }
            if (this.mFrozenPackages.contains(packageName)) {
                throw new PackageManagerException(-7, "Failed to move already frozen package");
            }
            isCurrentLocationExternal = PackageManagerService.isExternal(pkg);
            codeFile = new File(pkg.codePath);
            installerPackageName = ps.installerPackageName;
            packageAbiOverride = ps.cpuAbiOverrideString;
            appId = UserHandle.getAppId(pkg.applicationInfo.uid);
            seinfo = pkg.applicationInfo.seInfo;
            label = String.valueOf(pm.getApplicationLabel(pkg.applicationInfo));
            targetSdkVersion = pkg.applicationInfo.targetSdkVersion;
            freezer = this.freezePackage(packageName, "movePackageInternal");
            installedUserIds = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
        }
        Bundle extras = new Bundle();
        extras.putString("android.intent.extra.PACKAGE_NAME", packageName);
        extras.putString("android.intent.extra.TITLE", label);
        this.mMoveCallbacks.notifyCreated(moveId, extras);
        int installFlags = 16;
        if (Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, volumeUuid)) {
            moveCompleteApp = true;
            measurePath = Environment.getDataAppDirectory(volumeUuid);
        } else if (Objects.equals("primary_physical", volumeUuid)) {
            moveCompleteApp = false;
            measurePath = storage.getPrimaryPhysicalVolume().getPath();
        } else {
            VolumeInfo volume = storage.findVolumeByUuid(volumeUuid);
            if (volume == null || volume.getType() != 1 || !volume.isMountedWritable()) {
                freezer.close();
                throw new PackageManagerException(-6, "Move location not mounted private volume");
            }
            moveCompleteApp = true;
            measurePath = Environment.getDataAppDirectory(volumeUuid);
        }
        if (moveCompleteApp) {
            for (int userId : installedUserIds) {
                if (!StorageManager.isFileEncryptedNativeOrEmulated() || StorageManager.isUserKeyUnlocked(userId)) continue;
                throw new PackageManagerException(-10, "User " + userId + " must be unlocked");
            }
        }
        PackageStats stats = new PackageStats(null, -1);
        probe = this.mInstaller;
        synchronized (probe) {
            for (int userId : installedUserIds) {
                if (this.getPackageSizeInfoLI(packageName, userId, stats)) continue;
                freezer.close();
                throw new PackageManagerException(-6, "Failed to measure package size");
            }
        }
        long startFreeBytes = measurePath.getUsableSpace();
        long sizeBytes = moveCompleteApp ? stats.codeSize + stats.dataSize : stats.codeSize;
        if (sizeBytes > storage.getStorageBytesUntilLow(measurePath)) {
            freezer.close();
            throw new PackageManagerException(-6, "Not enough free space to move");
        }
        this.mMoveCallbacks.notifyStatusChanged(moveId, 10);
        final CountDownLatch installedLatch = new CountDownLatch(1);
        IPackageInstallObserver2.Stub installObserver = new IPackageInstallObserver2.Stub(){

            @Override
            public void onUserActionRequired(Intent intent) throws RemoteException {
                throw new IllegalStateException();
            }

            @Override
            public void onPackageInstalled(String basePackageName, int returnCode, String msg, Bundle extras) throws RemoteException {
                installedLatch.countDown();
                freezer.close();
                int status = PackageManager.installStatusToPublicStatus(returnCode);
                switch (status) {
                    case 0: {
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, -100);
                        PackageManagerService.this.logAppMovedStorage(packageName, isCurrentLocationExternal);
                        break;
                    }
                    case 6: {
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, -1);
                        break;
                    }
                    default: {
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, -6);
                    }
                }
            }
        };
        if (moveCompleteApp) {
            new Thread(() -> {
                while (true) {
                    try {
                        if (installedLatch.await(1L, TimeUnit.SECONDS)) {
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long deltaFreeBytes = startFreeBytes - measurePath.getUsableSpace();
                    int progress = 10 + (int)MathUtils.constrain(deltaFreeBytes * 80L / sizeBytes, 0L, 80L);
                    this.mMoveCallbacks.notifyStatusChanged(moveId, progress);
                }
            }).start();
            String dataAppName = codeFile.getName();
            move = new MoveInfo(moveId, currentVolumeUuid, volumeUuid, packageName, dataAppName, appId, seinfo, targetSdkVersion);
        } else {
            move = null;
        }
        Message msg = this.mHandler.obtainMessage(5);
        OriginInfo origin = OriginInfo.fromExistingFile(codeFile);
        InstallParams params = new InstallParams(origin, move, installObserver, installFlags |= 2, installerPackageName, volumeUuid, null, user, packageAbiOverride, null, null, PackageParser.SigningDetails.UNKNOWN, 0, -1L);
        params.setTraceMethod("movePackage").setTraceCookie(System.identityHashCode(params));
        msg.obj = params;
        Trace.asyncTraceBegin(262144L, "movePackage", System.identityHashCode(msg.obj));
        Trace.asyncTraceBegin(262144L, "queueInstall", System.identityHashCode(msg.obj));
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logAppMovedStorage(String packageName, boolean isPreviousLocationExternal) {
        PackageParser.Package pkg;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkg = this.mPackages.get(packageName);
        }
        if (pkg == null) {
            return;
        }
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        VolumeInfo volume = storage.findVolumeByUuid(pkg.applicationInfo.storageUuid.toString());
        int packageExternalStorageType = PackageManagerService.getPackageExternalStorageType(volume, PackageManagerService.isExternal(pkg));
        if (!isPreviousLocationExternal && PackageManagerService.isExternal(pkg)) {
            StatsLog.write(183, packageExternalStorageType, 1, packageName);
        } else if (isPreviousLocationExternal && !PackageManagerService.isExternal(pkg)) {
            StatsLog.write(183, packageExternalStorageType, 2, packageName);
        }
    }

    @Override
    public int movePrimaryStorage(String volumeUuid) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOVE_PACKAGE", null);
        final int realMoveId = this.mNextMoveId.getAndIncrement();
        Bundle extras = new Bundle();
        extras.putString("android.os.storage.extra.FS_UUID", volumeUuid);
        this.mMoveCallbacks.notifyCreated(realMoveId, extras);
        IPackageMoveObserver.Stub callback = new IPackageMoveObserver.Stub(){

            @Override
            public void onCreated(int moveId, Bundle extras) {
            }

            @Override
            public void onStatusChanged(int moveId, int status, long estMillis) {
                PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(realMoveId, status, estMillis);
            }
        };
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        storage.setPrimaryStorageUuid(volumeUuid, callback);
        return realMoveId;
    }

    @Override
    public int getMoveStatus(int moveId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS", null);
        return this.mMoveCallbacks.mLastStatus.get(moveId);
    }

    @Override
    public void registerMoveCallback(IPackageMoveObserver callback) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS", null);
        this.mMoveCallbacks.register(callback);
    }

    @Override
    public void unregisterMoveCallback(IPackageMoveObserver callback) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS", null);
        this.mMoveCallbacks.unregister(callback);
    }

    @Override
    public boolean setInstallLocation(int loc) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", null);
        if (this.getInstallLocation() == loc) {
            return true;
        }
        if (loc == 0 || loc == 1 || loc == 2) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "default_install_location", loc);
            return true;
        }
        return false;
    }

    @Override
    public int getInstallLocation() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "default_install_location", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpUser(UserManagerService userManager, int userHandle) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mDirtyUsers.remove(userHandle);
            this.mUserNeedsBadging.delete(userHandle);
            this.mSettings.removeUserLPw(userHandle);
            this.mPendingBroadcasts.remove(userHandle);
            this.mInstantAppRegistry.onUserRemovedLPw(userHandle);
            this.removeUnusedPackagesLPw(userManager, userHandle);
        }
    }

    @GuardedBy(value={"mPackages"})
    private void removeUnusedPackagesLPw(UserManagerService userManager, int userHandle) {
        boolean DEBUG_CLEAN_APKS = false;
        int[] users = userManager.getUserIds();
        for (PackageSetting ps : this.mSettings.mPackages.values()) {
            if (ps.pkg == null) continue;
            String packageName = ps.pkg.packageName;
            if ((ps.pkgFlags & 1) != 0) continue;
            boolean keep = this.shouldKeepUninstalledPackageLPr(packageName);
            if (!keep) {
                for (int i = 0; i < users.length; ++i) {
                    if (users[i] == userHandle || !ps.getInstalled(users[i])) continue;
                    keep = true;
                    break;
                }
            }
            if (keep) continue;
            this.mHandler.post(() -> this.deletePackageX(packageName, -1L, userHandle, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createNewUser(int userId, String[] disallowedPackages) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mInstallLock;
        synchronized (arrayMap) {
            this.mSettings.createNewUserLI(this, this.mInstaller, userId, disallowedPackages);
        }
        arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.scheduleWritePackageRestrictionsLocked(userId);
            this.scheduleWritePackageListLocked(userId);
            this.primeDomainVerificationsLPw(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNewUserCreated(int userId) {
        this.mDefaultPermissionPolicy.grantDefaultPermissions(userId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mPermissionManager.updateAllPermissions(StorageManager.UUID_PRIVATE_INTERNAL, true, this.mPackages.values(), this.mPermissionCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can read the verifier device identity");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getVerifierDeviceIdentityLPw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermissionEnforced(String permission2, boolean enforced) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_RUNTIME_PERMISSIONS", "setPermissionEnforced");
        if ("android.permission.READ_EXTERNAL_STORAGE".equals(permission2)) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                if (this.mSettings.mReadExternalStorageEnforced == null || this.mSettings.mReadExternalStorageEnforced != enforced) {
                    this.mSettings.mReadExternalStorageEnforced = enforced ? Boolean.TRUE : Boolean.FALSE;
                    this.mSettings.writeLPr();
                }
            }
            IActivityManager am = ActivityManager.getService();
            if (am != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    am.killProcessesBelowForeground("setPermissionEnforcement");
                }
                catch (RemoteException remoteException) {
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        } else {
            throw new IllegalArgumentException("No selective enforcement for " + permission2);
        }
    }

    @Override
    @Deprecated
    public boolean isPermissionEnforced(String permission2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStorageLow() {
        long token = Binder.clearCallingIdentity();
        try {
            DeviceStorageMonitorInternal dsm = LocalServices.getService(DeviceStorageMonitorInternal.class);
            if (dsm != null) {
                boolean bl = dsm.isMemoryLow();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public IPackageInstaller getPackageInstaller() {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        return this.mInstallerService;
    }

    @Override
    public IArtManager getArtManager() {
        return this.mArtManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userNeedsBadging(int userId) {
        int index = this.mUserNeedsBadging.indexOfKey(userId);
        if (index < 0) {
            UserInfo userInfo;
            long token = Binder.clearCallingIdentity();
            try {
                userInfo = sUserManager.getUserInfo(userId);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            boolean b = userInfo != null && userInfo.isManagedProfile();
            this.mUserNeedsBadging.put(userId, b);
            return b;
        }
        return this.mUserNeedsBadging.valueAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeySet getKeySetByAlias(String packageName, String alias) {
        if (packageName == null || alias == null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package: " + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (this.filterAppAccessLPr(ps, Binder.getCallingUid(), UserHandle.getCallingUserId())) {
                Slog.w(TAG, "KeySet requested for filtered package: " + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            return new KeySet(ksms.getKeySetByAliasAndPackageNameLPr(packageName, alias));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeySet getSigningKeySet(String packageName) {
        if (packageName == null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package: " + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
                Slog.w(TAG, "KeySet requested for filtered package: " + packageName + ", uid:" + callingUid);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            if (pkg.applicationInfo.uid != callingUid && 1000 != callingUid) {
                throw new SecurityException("May not access signing KeySet of other apps.");
            }
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            return new KeySet(ksms.getSigningKeySetByPackageNameLPr(packageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageSignedByKeySet(String packageName, KeySet ks) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return false;
        }
        if (packageName == null || ks == null) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null || this.filterAppAccessLPr((PackageSetting)pkg.mExtras, callingUid, UserHandle.getUserId(callingUid))) {
                Slog.w(TAG, "KeySet requested for unknown package: " + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            IBinder ksh = ks.getToken();
            if (ksh instanceof KeySetHandle) {
                KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                return ksms.packageIsSignedByLPr(packageName, (KeySetHandle)ksh);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageSignedByKeySetExactly(String packageName, KeySet ks) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return false;
        }
        if (packageName == null || ks == null) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null || this.filterAppAccessLPr((PackageSetting)pkg.mExtras, callingUid, UserHandle.getUserId(callingUid))) {
                Slog.w(TAG, "KeySet requested for unknown package: " + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            IBinder ksh = ks.getToken();
            if (ksh instanceof KeySetHandle) {
                KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                return ksms.packageIsSignedByExactlyLPr(packageName, (KeySetHandle)ksh);
            }
            return false;
        }
    }

    @GuardedBy(value={"mPackages"})
    private void deletePackageIfUnusedLPr(String packageName) {
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps == null) {
            return;
        }
        if (!ps.isAnyInstalled(sUserManager.getUserIds())) {
            this.mHandler.post(() -> this.deletePackageX(packageName, -1L, 0, 2));
        }
    }

    private static void checkDowngrade(PackageParser.Package before, PackageInfoLite after) throws PackageManagerException {
        if (after.getLongVersionCode() < before.getLongVersionCode()) {
            throw new PackageManagerException(-25, "Update version code " + after.versionCode + " is older than current " + before.getLongVersionCode());
        }
        if (after.getLongVersionCode() == before.getLongVersionCode()) {
            if (after.baseRevisionCode < before.baseRevisionCode) {
                throw new PackageManagerException(-25, "Update base revision code " + after.baseRevisionCode + " is older than current " + before.baseRevisionCode);
            }
            if (!ArrayUtils.isEmpty(after.splitNames)) {
                for (int i = 0; i < after.splitNames.length; ++i) {
                    String splitName = after.splitNames[i];
                    int j = ArrayUtils.indexOf(before.splitNames, splitName);
                    if (j == -1 || after.splitRevisionCodes[i] >= before.splitRevisionCodes[j]) continue;
                    throw new PackageManagerException(-25, "Update split " + splitName + " revision code " + after.splitRevisionCodes[i] + " is older than current " + before.splitRevisionCodes[j]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mPackages"})
    private SparseArray<String> getAppsWithSharedUserIdsLocked() {
        SparseArray<String> sharedUserIds = new SparseArray<String>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (SharedUserSetting setting : this.mSettings.getAllSharedUsersLPw()) {
                sharedUserIds.put(UserHandle.getAppId(setting.userId), setting.name);
            }
        }
        return sharedUserIds;
    }

    @GuardedBy(value={"mPackages"})
    private String getSharedUserIdForPackageLocked(String packageName) {
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        return ps != null && ps.isSharedUser() ? ps.sharedUser.name : null;
    }

    @GuardedBy(value={"mPackages"})
    private String[] getPackagesForSharedUserIdLocked(String sharedUserId, int userId) {
        try {
            SharedUserSetting sus = this.mSettings.getSharedUserLPw(sharedUserId, 0, 0, false);
            if (sus == null) {
                return EmptyArray.STRING;
            }
            String[] res = new String[sus.packages.size()];
            Iterator<PackageSetting> it = sus.packages.iterator();
            int i = 0;
            while (it.hasNext()) {
                PackageSetting ps = it.next();
                if (ps.getInstalled(userId)) {
                    res[i++] = ps.name;
                    continue;
                }
                res = ArrayUtils.removeElement(String.class, res, res[i]);
            }
            return res;
        }
        catch (PackageManagerException packageManagerException) {
            return EmptyArray.STRING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRuntimePermissionsVersion(int userId) {
        Preconditions.checkArgumentNonnegative(userId);
        this.mContext.enforceCallingOrSelfPermission("android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", "setRuntimePermissionVersion");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getDefaultRuntimePermissionsVersionLPr(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRuntimePermissionsVersion(int version, int userId) {
        Preconditions.checkArgumentNonnegative(version);
        Preconditions.checkArgumentNonnegative(userId);
        this.mContext.enforceCallingOrSelfPermission("android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", "setRuntimePermissionVersion");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mSettings.setDefaultRuntimePermissionsVersionLPr(version, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, int userId) {
        PackageManagerService.enforceSystemOrPhoneCaller("grantPermissionsToEnabledCarrierApps");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mDefaultPermissionPolicy.grantDefaultPermissionsToEnabledCarrierApps(packageNames, userId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDefaultPermissionsToEnabledImsServices(String[] packageNames, int userId) {
        PackageManagerService.enforceSystemOrPhoneCaller("grantDefaultPermissionsToEnabledImsServices");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mDefaultPermissionPolicy.grantDefaultPermissionsToEnabledImsServices(packageNames, userId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] packageNames, int userId) {
        PackageManagerService.enforceSystemOrPhoneCaller("grantDefaultPermissionsToEnabledTelephonyDataServices");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Binder.withCleanCallingIdentity(() -> this.mDefaultPermissionPolicy.grantDefaultPermissionsToEnabledTelephonyDataServices(packageNames, userId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] packageNames, int userId) {
        PackageManagerService.enforceSystemOrPhoneCaller("revokeDefaultPermissionsFromDisabledTelephonyDataServices");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Binder.withCleanCallingIdentity(() -> this.mDefaultPermissionPolicy.revokeDefaultPermissionsFromDisabledTelephonyDataServices(packageNames, userId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDefaultPermissionsToActiveLuiApp(String packageName, int userId) {
        PackageManagerService.enforceSystemOrPhoneCaller("grantDefaultPermissionsToActiveLuiApp");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mDefaultPermissionPolicy.grantDefaultPermissionsToActiveLuiApp(packageName, userId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeDefaultPermissionsFromLuiApps(String[] packageNames, int userId) {
        PackageManagerService.enforceSystemOrPhoneCaller("revokeDefaultPermissionsFromLuiApps");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mDefaultPermissionPolicy.revokeDefaultPermissionsFromLuiApps(packageNames, userId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forEachPackage(Consumer<PackageParser.Package> actionLocked) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int numPackages = this.mPackages.size();
            for (int i = 0; i < numPackages; ++i) {
                actionLocked.accept(this.mPackages.valueAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forEachInstalledPackage(Consumer<PackageParser.Package> actionLocked, int userId) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int numPackages = this.mPackages.size();
            for (int i = 0; i < numPackages; ++i) {
                PackageParser.Package pkg = this.mPackages.valueAt(i);
                PackageSetting setting = this.mSettings.getPackageLPr(pkg.packageName);
                if (setting == null || !setting.getInstalled(userId)) continue;
                actionLocked.accept(pkg);
            }
        }
    }

    private static void enforceSystemOrPhoneCaller(String tag) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1001 && callingUid != 1000) {
            throw new SecurityException("Cannot call " + tag + " from UID " + callingUid);
        }
    }

    boolean isHistoricalPackageUsageAvailable() {
        return this.mPackageUsage.isHistoricalPackageUsageAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<PackageParser.Package> getPackages() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return new ArrayList<PackageParser.Package>(this.mPackages.values());
        }
    }

    @Override
    public void logAppProcessStartIfNeeded(String processName, int uid, String seinfo, String apkFile, int pid) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        if (!SecurityLog.isLoggingEnabled()) {
            return;
        }
        Bundle data = new Bundle();
        data.putLong("startTimestamp", System.currentTimeMillis());
        data.putString("processName", processName);
        data.putInt("uid", uid);
        data.putString("seinfo", seinfo);
        data.putString("apkFile", apkFile);
        data.putInt("pid", pid);
        Message msg = this.mProcessLoggingHandler.obtainMessage(1);
        msg.setData(data);
        this.mProcessLoggingHandler.sendMessage(msg);
    }

    public CompilerStats.PackageStats getCompilerPackageStats(String pkgName) {
        return this.mCompilerStats.getPackageStats(pkgName);
    }

    public CompilerStats.PackageStats getOrCreateCompilerPackageStats(PackageParser.Package pkg) {
        return this.getOrCreateCompilerPackageStats(pkg.packageName);
    }

    public CompilerStats.PackageStats getOrCreateCompilerPackageStats(String pkgName) {
        return this.mCompilerStats.getOrCreatePackageStats(pkgName);
    }

    public void deleteCompilerPackageStats(String pkgName) {
        this.mCompilerStats.deletePackageStats(pkgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInstallReason(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, false, "get install reason");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (this.filterAppAccessLPr(ps, callingUid, userId)) {
                return 0;
            }
            if (ps != null) {
                return ps.getInstallReason(userId);
            }
            return 0;
        }
    }

    @Override
    public boolean canRequestPackageInstalls(String packageName, int userId) {
        return this.canRequestPackageInstallsInternal(packageName, 0, userId, true);
    }

    private boolean canRequestPackageInstallsInternal(String packageName, int flags, int userId, boolean throwIfPermNotDeclared) {
        int uid;
        int callingUid = Binder.getCallingUid();
        if (callingUid != (uid = this.getPackageUid(packageName, 0, userId)) && callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("Caller uid " + callingUid + " does not own package " + packageName);
        }
        ApplicationInfo info = this.getApplicationInfo(packageName, flags, userId);
        if (info == null) {
            return false;
        }
        if (info.targetSdkVersion < 26) {
            return false;
        }
        if (this.isInstantApp(packageName, userId)) {
            return false;
        }
        String appOpPermission = "android.permission.REQUEST_INSTALL_PACKAGES";
        String[] packagesDeclaringPermission = this.getAppOpPermissionPackages(appOpPermission);
        if (!ArrayUtils.contains(packagesDeclaringPermission, packageName)) {
            if (throwIfPermNotDeclared) {
                throw new SecurityException("Need to declare " + appOpPermission + " to call this api");
            }
            Slog.e(TAG, "Need to declare " + appOpPermission + " to call this api");
            return false;
        }
        if (sUserManager.hasUserRestriction("no_install_unknown_sources", userId) || sUserManager.hasUserRestriction("no_install_unknown_sources_globally", userId)) {
            return false;
        }
        if (this.mExternalSourcesPolicy != null) {
            int isTrusted = this.mExternalSourcesPolicy.getPackageTrustedToInstallApps(packageName, uid);
            return isTrusted == 0;
        }
        return false;
    }

    @Override
    public ComponentName getInstantAppResolverSettingsComponent() {
        return this.mInstantAppResolverSettingsComponent;
    }

    @Override
    public ComponentName getInstantAppInstallerComponent() {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        return this.mInstantAppInstallerActivity == null ? null : this.mInstantAppInstallerActivity.getComponentName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInstantAppAndroidId(String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_INSTANT_APPS", "getInstantAppAndroidId");
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getInstantAppAndroidId");
        if (!this.isInstantApp(packageName, userId)) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mInstantAppRegistry.getInstantAppAndroidIdLPw(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canHaveOatDir(String packageName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p == null) {
                return false;
            }
            return p.canHaveOatDir();
        }
    }

    private String getOatDir(PackageParser.Package pkg) {
        if (!pkg.canHaveOatDir()) {
            return null;
        }
        File codePath = new File(pkg.codePath);
        if (codePath.isDirectory()) {
            return PackageDexOptimizer.getOatDir(codePath).getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteOatArtifactsOfPackage(String packageName) {
        PackageParser.Package pkg;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkg = this.mPackages.get(packageName);
        }
        String[] instructionSets = InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
        List<String> codePaths = pkg.getAllCodePaths();
        String oatDir = this.getOatDir(pkg);
        for (String codePath : codePaths) {
            for (String isa : instructionSets) {
                try {
                    this.mInstaller.deleteOdex(codePath, isa, oatDir);
                }
                catch (Installer.InstallerException e) {
                    Log.e(TAG, "Failed deleting oat files for " + codePath, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getUnusedPackages(long downgradeTimeThresholdMillis) {
        HashSet<String> unusedPackages = new HashSet<String>();
        long currentTimeInMillis = System.currentTimeMillis();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (PackageParser.Package pkg : this.mPackages.values()) {
                PackageDexUsage.PackageUseInfo packageUseInfo;
                PackageSetting ps = this.mSettings.mPackages.get(pkg.packageName);
                if (ps == null || !PackageManagerServiceUtils.isUnusedSinceTimeInMillis(ps.firstInstallTime, currentTimeInMillis, downgradeTimeThresholdMillis, packageUseInfo = this.getDexManager().getPackageUseInfoOrDefault(pkg.packageName), pkg.getLatestPackageUseTimeInMills(), pkg.getLatestForegroundPackageUseTimeInMills())) continue;
                unusedPackages.add(pkg.packageName);
            }
        }
        return unusedPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHarmfulAppWarning(String packageName, CharSequence warning, int userId) {
        int callingUid = Binder.getCallingUid();
        int callingAppId = UserHandle.getAppId(callingUid);
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, true, "setHarmfulAppInfo");
        if (callingAppId != 1000 && callingAppId != 0 && this.checkUidPermission("android.permission.SET_HARMFUL_APP_WARNINGS", callingUid) != 0) {
            throw new SecurityException("Caller must have the android.permission.SET_HARMFUL_APP_WARNINGS permission.");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mSettings.setHarmfulAppWarningLPw(packageName, warning, userId);
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getHarmfulAppWarning(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        int callingAppId = UserHandle.getAppId(callingUid);
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, true, "getHarmfulAppInfo");
        if (callingAppId != 1000 && callingAppId != 0 && this.checkUidPermission("android.permission.SET_HARMFUL_APP_WARNINGS", callingUid) != 0) {
            throw new SecurityException("Caller must have the android.permission.SET_HARMFUL_APP_WARNINGS permission.");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getHarmfulAppWarningLPr(packageName, userId);
        }
    }

    @Override
    public boolean isPackageStateProtected(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        int callingAppId = UserHandle.getAppId(callingUid);
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, false, true, "isPackageStateProtected");
        if (callingAppId != 1000 && callingAppId != 0 && this.checkUidPermission("android.permission.MANAGE_DEVICE_ADMINS", callingUid) != 0) {
            throw new SecurityException("Caller must have the android.permission.MANAGE_DEVICE_ADMINS permission.");
        }
        return this.mProtectedPackages.isPackageStateProtected(userId, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendDeviceCustomizationReadyBroadcast() {
        this.mContext.enforceCallingPermission("android.permission.SEND_DEVICE_CUSTOMIZATION_READY", "sendDeviceCustomizationReadyBroadcast");
        long ident = Binder.clearCallingIdentity();
        try {
            Intent intent = new Intent("android.intent.action.DEVICE_CUSTOMIZATION_READY");
            intent.setFlags(0x1000000);
            IActivityManager am = ActivityManager.getService();
            String[] requiredPermissions = new String[]{"android.permission.RECEIVE_DEVICE_CUSTOMIZATION_READY"};
            try {
                am.broadcastIntent(null, intent, null, null, 0, null, null, requiredPermissions, -1, null, false, false, -1);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private /* synthetic */ void lambda$installExistingPackageAsUser$10(PackageInstalledInfo res, IntentSender intentSender) {
        PackageManagerService.onRestoreComplete(res.returnCode, this.mContext, intentSender);
    }

    static {
        sBrowserIntent.setAction("android.intent.action.VIEW");
        sBrowserIntent.addCategory("android.intent.category.BROWSABLE");
        sBrowserIntent.setData(Uri.parse("http:"));
        sBrowserIntent.addFlags(512);
        INSTANT_APP_BROADCAST_PERMISSION = new String[]{"android.permission.ACCESS_INSTANT_APPS"};
        sAppInstallDir = new File(Environment.getDataDirectory(), "app");
        sAppLib32InstallDir = new File(Environment.getDataDirectory(), "app-lib");
        sProviderInitOrderSorter = (p1, p2) -> {
            int v1 = p1.initOrder;
            int v2 = p2.initOrder;
            return v1 > v2 ? -1 : (v1 < v2 ? 1 : 0);
        };
    }

    static class ActiveInstallSession {
        private final String mPackageName;
        private final File mStagedDir;
        private final IPackageInstallObserver2 mObserver;
        private final PackageInstaller.SessionParams mSessionParams;
        private final String mInstallerPackageName;
        private final int mInstallerUid;
        private final UserHandle mUser;
        private final PackageParser.SigningDetails mSigningDetails;

        ActiveInstallSession(String packageName, File stagedDir, IPackageInstallObserver2 observer, PackageInstaller.SessionParams sessionParams, String installerPackageName, int installerUid, UserHandle user, PackageParser.SigningDetails signingDetails) {
            this.mPackageName = packageName;
            this.mStagedDir = stagedDir;
            this.mObserver = observer;
            this.mSessionParams = sessionParams;
            this.mInstallerPackageName = installerPackageName;
            this.mInstallerUid = installerUid;
            this.mUser = user;
            this.mSigningDetails = signingDetails;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public File getStagedDir() {
            return this.mStagedDir;
        }

        public IPackageInstallObserver2 getObserver() {
            return this.mObserver;
        }

        public PackageInstaller.SessionParams getSessionParams() {
            return this.mSessionParams;
        }

        public String getInstallerPackageName() {
            return this.mInstallerPackageName;
        }

        public int getInstallerUid() {
            return this.mInstallerUid;
        }

        public UserHandle getUser() {
            return this.mUser;
        }

        public PackageParser.SigningDetails getSigningDetails() {
            return this.mSigningDetails;
        }
    }

    private class PackageManagerInternalImpl
    extends PackageManagerInternal {
        private PackageManagerInternalImpl() {
        }

        @Override
        public void updatePermissionFlagsTEMP(String permName, String packageName, int flagMask, int flagValues, int userId) {
            PackageManagerService.this.updatePermissionFlags(permName, packageName, flagMask, flagValues, true, userId);
        }

        @Override
        public List<ApplicationInfo> getInstalledApplications(int flags, int userId, int callingUid) {
            return PackageManagerService.this.getInstalledApplicationsListInternal(flags, userId, callingUid);
        }

        @Override
        public boolean isPlatformSigned(String packageName) {
            PackageSetting packageSetting = PackageManagerService.this.mSettings.mPackages.get(packageName);
            if (packageSetting == null) {
                return false;
            }
            PackageParser.Package pkg = packageSetting.pkg;
            if (pkg == null) {
                return false;
            }
            return pkg.mSigningDetails.hasAncestorOrSelf(PackageManagerService.this.mPlatformPackage.mSigningDetails) || PackageManagerService.this.mPlatformPackage.mSigningDetails.checkCapability(pkg.mSigningDetails, 4);
        }

        @Override
        public boolean isDataRestoreSafe(byte[] restoringFromSigHash, String packageName) {
            PackageParser.SigningDetails sd = this.getSigningDetails(packageName);
            if (sd == null) {
                return false;
            }
            return sd.hasSha256Certificate(restoringFromSigHash, 1);
        }

        @Override
        public boolean isDataRestoreSafe(Signature restoringFromSig, String packageName) {
            PackageParser.SigningDetails sd = this.getSigningDetails(packageName);
            if (sd == null) {
                return false;
            }
            return sd.hasCertificate(restoringFromSig, 1);
        }

        @Override
        public boolean hasSignatureCapability(int serverUid, int clientUid, @PackageParser.SigningDetails.CertCapabilities int capability) {
            PackageParser.SigningDetails clientSigningDetails;
            PackageParser.SigningDetails serverSigningDetails = this.getSigningDetails(serverUid);
            return serverSigningDetails.checkCapability(clientSigningDetails = this.getSigningDetails(clientUid), capability) || clientSigningDetails.hasAncestorOrSelf(serverSigningDetails);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PackageParser.SigningDetails getSigningDetails(String packageName) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageParser.Package p = PackageManagerService.this.mPackages.get(packageName);
                if (p == null) {
                    return null;
                }
                return p.mSigningDetails;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PackageParser.SigningDetails getSigningDetails(int uid) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                int appId = UserHandle.getAppId(uid);
                SettingBase obj = PackageManagerService.this.mSettings.getSettingLPr(appId);
                if (obj != null) {
                    if (obj instanceof SharedUserSetting) {
                        return ((SharedUserSetting)obj).signatures.mSigningDetails;
                    }
                    if (obj instanceof PackageSetting) {
                        PackageSetting ps = (PackageSetting)obj;
                        return ps.signatures.mSigningDetails;
                    }
                }
                return PackageParser.SigningDetails.UNKNOWN;
            }
        }

        @Override
        public int getPermissionFlagsTEMP(String permName, String packageName, int userId) {
            return PackageManagerService.this.getPermissionFlags(permName, packageName, userId);
        }

        @Override
        public boolean isInstantApp(String packageName, int userId) {
            return PackageManagerService.this.isInstantApp(packageName, userId);
        }

        @Override
        public String getInstantAppPackageName(int uid) {
            return PackageManagerService.this.getInstantAppPackageName(uid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean filterAppAccess(PackageParser.Package pkg, int callingUid, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.filterAppAccessLPr((PackageSetting)pkg.mExtras, callingUid, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PackageParser.Package getPackage(String packageName) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                packageName = PackageManagerService.this.resolveInternalPackageNameLPr(packageName, -1L);
                return PackageManagerService.this.mPackages.get(packageName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PackageList getPackageList(PackageManagerInternal.PackageListObserver observer) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                int N = PackageManagerService.this.mPackages.size();
                ArrayList<String> list = new ArrayList<String>(N);
                for (int i = 0; i < N; ++i) {
                    list.add(PackageManagerService.this.mPackages.keyAt(i));
                }
                PackageList packageList = new PackageList(list, observer);
                if (observer != null) {
                    PackageManagerService.this.mPackageListObservers.add(packageList);
                }
                return packageList;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePackageListObserver(PackageManagerInternal.PackageListObserver observer) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mPackageListObservers.remove(observer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PackageParser.Package getDisabledSystemPackage(String packageName) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = PackageManagerService.this.mSettings.getDisabledSystemPkgLPr(packageName);
                return ps != null ? ps.pkg : null;
            }
        }

        @Override
        public String getDisabledSystemPackageName(String packageName) {
            PackageParser.Package pkg = this.getDisabledSystemPackage(packageName);
            return pkg == null ? null : pkg.packageName;
        }

        @Override
        public String getKnownPackageName(int knownPackage, int userId) {
            switch (knownPackage) {
                case 4: {
                    return PackageManagerService.this.getDefaultBrowserPackageName(userId);
                }
                case 2: {
                    return PackageManagerService.this.mRequiredInstallerPackage;
                }
                case 1: {
                    return PackageManagerService.this.mSetupWizardPackage;
                }
                case 0: {
                    return PackageManagerService.PLATFORM_PACKAGE_NAME;
                }
                case 3: {
                    return PackageManagerService.this.mRequiredVerifierPackage;
                }
                case 5: {
                    return PackageManagerService.this.mSystemTextClassifierPackage;
                }
                case 6: {
                    return PackageManagerService.this.mRequiredPermissionControllerPackage;
                }
                case 7: {
                    return PackageManagerService.this.mWellbeingPackage;
                }
                case 8: {
                    return PackageManagerService.this.mDocumenterPackage;
                }
                case 9: {
                    return PackageManagerService.this.mConfiguratorPackage;
                }
                case 10: {
                    return PackageManagerService.this.mIncidentReportApproverPackage;
                }
                case 11: {
                    return PackageManagerService.this.mAppPredictionServicePackage;
                }
            }
            return null;
        }

        @Override
        public boolean isResolveActivityComponent(ComponentInfo component) {
            return PackageManagerService.this.mResolveActivity.packageName.equals(component.packageName) && PackageManagerService.this.mResolveActivity.name.equals(component.name);
        }

        @Override
        public void setLocationPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            PackageManagerService.this.mDefaultPermissionPolicy.setLocationPackagesProvider(provider);
        }

        @Override
        public void setLocationExtraPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            PackageManagerService.this.mDefaultPermissionPolicy.setLocationExtraPackagesProvider(provider);
        }

        @Override
        public void setVoiceInteractionPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            PackageManagerService.this.mDefaultPermissionPolicy.setVoiceInteractionPackagesProvider(provider);
        }

        @Override
        public void setUseOpenWifiAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            PackageManagerService.this.mDefaultPermissionPolicy.setUseOpenWifiAppPackagesProvider(provider);
        }

        @Override
        public void setSyncAdapterPackagesprovider(PackageManagerInternal.SyncAdapterPackagesProvider provider) {
            PackageManagerService.this.mDefaultPermissionPolicy.setSyncAdapterPackagesProvider(provider);
        }

        @Override
        public void grantDefaultPermissionsToDefaultUseOpenWifiApp(String packageName, int userId) {
            PackageManagerService.this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultUseOpenWifiApp(packageName, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setKeepUninstalledPackages(List<String> packageList) {
            Preconditions.checkNotNull(packageList);
            ArrayList<String> removedFromList = null;
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                int i;
                if (PackageManagerService.this.mKeepUninstalledPackages != null) {
                    int packagesCount = PackageManagerService.this.mKeepUninstalledPackages.size();
                    for (i = 0; i < packagesCount; ++i) {
                        String oldPackage = (String)PackageManagerService.this.mKeepUninstalledPackages.get(i);
                        if (packageList != null && packageList.contains(oldPackage)) continue;
                        if (removedFromList == null) {
                            removedFromList = new ArrayList<String>();
                        }
                        removedFromList.add(oldPackage);
                    }
                }
                PackageManagerService.this.mKeepUninstalledPackages = new ArrayList<String>(packageList);
                if (removedFromList != null) {
                    int removedCount = removedFromList.size();
                    for (i = 0; i < removedCount; ++i) {
                        PackageManagerService.this.deletePackageIfUnusedLPr((String)removedFromList.get(i));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPermissionsReviewRequired(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                if (pkg == null) {
                    return false;
                }
                return PackageManagerService.this.mPermissionManager.isPermissionsReviewRequired(pkg, userId);
            }
        }

        @Override
        public PackageInfo getPackageInfo(String packageName, int flags, int filterCallingUid, int userId) {
            return PackageManagerService.this.getPackageInfoInternal(packageName, -1L, flags, filterCallingUid, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bundle getSuspendedPackageLauncherExtras(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(packageName);
                PersistableBundle launcherExtras = null;
                if (ps != null) {
                    launcherExtras = ps.readUserState((int)userId).suspendedLauncherExtras;
                }
                return launcherExtras != null ? new Bundle(launcherExtras.deepCopy()) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPackageSuspended(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(packageName);
                return ps != null ? ps.getSuspended(userId) : false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getSuspendingPackage(String suspendedPackage, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(suspendedPackage);
                return ps != null ? ps.readUserState((int)userId).suspendingPackage : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SuspendDialogInfo getSuspendedDialogInfo(String suspendedPackage, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(suspendedPackage);
                return ps != null ? ps.readUserState((int)userId).dialogInfo : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDistractingPackageRestrictions(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(packageName);
                return ps != null ? ps.getDistractionFlags(userId) : 0;
            }
        }

        @Override
        public int getPackageUid(String packageName, int flags, int userId) {
            return PackageManagerService.this.getPackageUid(packageName, flags, userId);
        }

        @Override
        public ApplicationInfo getApplicationInfo(String packageName, int flags, int filterCallingUid, int userId) {
            return PackageManagerService.this.getApplicationInfoInternal(packageName, flags, filterCallingUid, userId);
        }

        @Override
        public ActivityInfo getActivityInfo(ComponentName component, int flags, int filterCallingUid, int userId) {
            return PackageManagerService.this.getActivityInfoInternal(component, flags, filterCallingUid, userId);
        }

        @Override
        public List<ResolveInfo> queryIntentActivities(Intent intent, int flags, int filterCallingUid, int userId) {
            String resolvedType = intent.resolveTypeIfNeeded(PackageManagerService.this.mContext.getContentResolver());
            return PackageManagerService.this.queryIntentActivitiesInternal(intent, resolvedType, flags, filterCallingUid, userId, false, true);
        }

        @Override
        public List<ResolveInfo> queryIntentServices(Intent intent, int flags, int callingUid, int userId) {
            String resolvedType = intent.resolveTypeIfNeeded(PackageManagerService.this.mContext.getContentResolver());
            return PackageManagerService.this.queryIntentServicesInternal(intent, resolvedType, flags, userId, callingUid, false);
        }

        @Override
        public ComponentName getHomeActivitiesAsUser(List<ResolveInfo> allHomeCandidates, int userId) {
            return PackageManagerService.this.getHomeActivitiesAsUser(allHomeCandidates, userId);
        }

        @Override
        public ComponentName getDefaultHomeActivity(int userId) {
            return PackageManagerService.this.getDefaultHomeActivity(userId);
        }

        @Override
        public void setDeviceAndProfileOwnerPackages(int deviceOwnerUserId, String deviceOwnerPackage, SparseArray<String> profileOwnerPackages) {
            PackageManagerService.this.mProtectedPackages.setDeviceAndProfileOwnerPackages(deviceOwnerUserId, deviceOwnerPackage, profileOwnerPackages);
            ArraySet<Integer> usersWithPoOrDo = new ArraySet<Integer>();
            if (deviceOwnerPackage != null) {
                usersWithPoOrDo.add(deviceOwnerUserId);
            }
            int sz = profileOwnerPackages.size();
            for (int i = 0; i < sz; ++i) {
                if (profileOwnerPackages.valueAt(i) == null) continue;
                usersWithPoOrDo.add(profileOwnerPackages.keyAt(i));
            }
            PackageManagerService.this.unsuspendForNonSystemSuspendingPackages(usersWithPoOrDo);
        }

        @Override
        public boolean isPackageDataProtected(int userId, String packageName) {
            return PackageManagerService.this.mProtectedPackages.isPackageDataProtected(userId, packageName);
        }

        @Override
        public boolean isPackageStateProtected(String packageName, int userId) {
            return PackageManagerService.this.mProtectedPackages.isPackageStateProtected(userId, packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPackageEphemeral(int userId, String packageName) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(packageName);
                return ps != null ? ps.getInstantApp(userId) : false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean wasPackageEverLaunched(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.mSettings.wasPackageEverLaunchedLPr(packageName, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEnabledAndMatches(ComponentInfo info, int flags, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.mSettings.isEnabledAndMatchLPr(info, flags, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean userNeedsBadging(int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.userNeedsBadging(userId);
            }
        }

        @Override
        public void grantRuntimePermission(String packageName, String permName, int userId, boolean overridePolicy) {
            PackageManagerService.this.mPermissionManager.grantRuntimePermission(permName, packageName, overridePolicy, Binder.getCallingUid(), userId, PackageManagerService.this.mPermissionCallback);
        }

        @Override
        public void revokeRuntimePermission(String packageName, String permName, int userId, boolean overridePolicy) {
            PackageManagerService.this.mPermissionManager.revokeRuntimePermission(permName, packageName, overridePolicy, userId, PackageManagerService.this.mPermissionCallback);
        }

        @Override
        public String getNameForUid(int uid) {
            return PackageManagerService.this.getNameForUid(uid);
        }

        @Override
        public void requestInstantAppResolutionPhaseTwo(AuxiliaryResolveInfo responseObj, Intent origIntent, String resolvedType, String callingPackage, Bundle verificationBundle, int userId) {
            PackageManagerService.this.requestInstantAppResolutionPhaseTwo(responseObj, origIntent, resolvedType, callingPackage, verificationBundle, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantEphemeralAccess(int userId, Intent intent, int targetAppId, int ephemeralAppId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mInstantAppRegistry.grantInstantAccessLPw(userId, intent, targetAppId, ephemeralAppId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isInstantAppInstallerComponent(ComponentName component) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.mInstantAppInstallerActivity != null && PackageManagerService.this.mInstantAppInstallerActivity.getComponentName().equals(component);
            }
        }

        @Override
        public void pruneInstantApps() {
            PackageManagerService.this.mInstantAppRegistry.pruneInstantApps();
        }

        @Override
        public String getSetupWizardPackageName() {
            return PackageManagerService.this.mSetupWizardPackage;
        }

        @Override
        public void setExternalSourcesPolicy(PackageManagerInternal.ExternalSourcesPolicy policy) {
            if (policy != null) {
                PackageManagerService.this.mExternalSourcesPolicy = policy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPackagePersistent(String packageName) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                return pkg != null ? (pkg.applicationInfo.flags & 9) == 9 : false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isLegacySystemApp(PackageParser.Package pkg) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = (PackageSetting)pkg.mExtras;
                return PackageManagerService.this.mPromoteSystemApps && ps.isSystem() && PackageManagerService.this.mExistingSystemPackages.contains(ps.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PackageInfo> getOverlayPackages(int userId) {
            ArrayList<PackageInfo> overlayPackages = new ArrayList<PackageInfo>();
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                for (PackageParser.Package p : PackageManagerService.this.mPackages.values()) {
                    PackageInfo pkg;
                    if (p.mOverlayTarget == null || (pkg = PackageManagerService.this.generatePackageInfo((PackageSetting)p.mExtras, 0, userId)) == null) continue;
                    overlayPackages.add(pkg);
                }
            }
            return overlayPackages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getTargetPackageNames(int userId) {
            ArrayList<String> targetPackages = new ArrayList<String>();
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                for (PackageParser.Package p : PackageManagerService.this.mPackages.values()) {
                    if (p.mOverlayTarget != null) continue;
                    targetPackages.add(p.packageName);
                }
            }
            return targetPackages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setEnabledOverlayPackages(int userId, String targetPackageName, List<String> overlayPackageNames) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                if (targetPackageName == null || PackageManagerService.this.mPackages.get(targetPackageName) == null) {
                    Slog.e(PackageManagerService.TAG, "failed to find package " + targetPackageName);
                    return false;
                }
                ArrayList<String> overlayPaths = null;
                if (overlayPackageNames != null && overlayPackageNames.size() > 0) {
                    int N = overlayPackageNames.size();
                    overlayPaths = new ArrayList<String>(N);
                    for (int i = 0; i < N; ++i) {
                        String packageName = overlayPackageNames.get(i);
                        PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                        if (pkg == null) {
                            Slog.e(PackageManagerService.TAG, "failed to find package " + packageName);
                            return false;
                        }
                        overlayPaths.add(pkg.baseCodePath);
                    }
                }
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(targetPackageName);
                ps.setOverlayPaths(overlayPaths, userId);
                return true;
            }
        }

        @Override
        public ResolveInfo resolveIntent(Intent intent, String resolvedType, int flags, int userId, boolean resolveForStart, int filterCallingUid) {
            return PackageManagerService.this.resolveIntentInternal(intent, resolvedType, flags, userId, resolveForStart, filterCallingUid);
        }

        @Override
        public ResolveInfo resolveService(Intent intent, String resolvedType, int flags, int userId, int callingUid) {
            return PackageManagerService.this.resolveServiceInternal(intent, resolvedType, flags, userId, callingUid);
        }

        @Override
        public ProviderInfo resolveContentProvider(String name, int flags, int userId) {
            return PackageManagerService.this.resolveContentProviderInternal(name, flags, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addIsolatedUid(int isolatedUid, int ownerUid) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mIsolatedOwners.put(isolatedUid, ownerUid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeIsolatedUid(int isolatedUid) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mIsolatedOwners.delete(isolatedUid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getUidTargetSdkVersion(int uid) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.getUidTargetSdkVersionLockedLPr(uid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getPackageTargetSdkVersion(String packageName) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.getPackageTargetSdkVersionLockedLPr(packageName);
            }
        }

        @Override
        public boolean canAccessInstantApps(int callingUid, int userId) {
            return PackageManagerService.this.canViewInstantApps(callingUid, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canAccessComponent(int callingUid, ComponentName component, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(component.getPackageName());
                return ps != null && !PackageManagerService.this.filterAppAccessLPr(ps, callingUid, component, 0, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasInstantApplicationMetadata(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.mInstantAppRegistry.hasInstantApplicationMetadataLPr(packageName, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyPackageUse(String packageName, int reason) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.notifyPackageUseLocked(packageName, reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PackageManagerInternal.CheckPermissionDelegate getCheckPermissionDelegate() {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.getCheckPermissionDelegateLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCheckPermissionDelegate(PackageManagerInternal.CheckPermissionDelegate delegate) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.setCheckPermissionDelegateLocked(delegate);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SparseArray<String> getAppsWithSharedUserIds() {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.getAppsWithSharedUserIdsLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getSharedUserIdForPackage(String packageName) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.getSharedUserIdForPackageLocked(packageName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getPackagesForSharedUserId(String sharedUserId, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.getPackagesForSharedUserIdLocked(sharedUserId, userId);
            }
        }

        @Override
        public boolean isOnlyCoreApps() {
            return PackageManagerService.this.isOnlyCoreApps();
        }

        @Override
        public void freeStorage(String volumeUuid, long bytes, int storageFlags) throws IOException {
            PackageManagerService.this.freeStorage(volumeUuid, bytes, storageFlags);
        }

        @Override
        public void forEachPackage(Consumer<PackageParser.Package> actionLocked) {
            PackageManagerService.this.forEachPackage(actionLocked);
        }

        @Override
        public void forEachInstalledPackage(Consumer<PackageParser.Package> actionLocked, int userId) {
            PackageManagerService.this.forEachInstalledPackage(actionLocked, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArraySet<String> getEnabledComponents(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting setting = PackageManagerService.this.mSettings.getPackageLPr(packageName);
                if (setting == null) {
                    return new ArraySet<String>();
                }
                return setting.getEnabledComponents(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArraySet<String> getDisabledComponents(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting setting = PackageManagerService.this.mSettings.getPackageLPr(packageName);
                if (setting == null) {
                    return new ArraySet<String>();
                }
                return setting.getDisabledComponents(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getApplicationEnabledState(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting setting = PackageManagerService.this.mSettings.getPackageLPr(packageName);
                if (setting == null) {
                    return 0;
                }
                return setting.getEnabled(userId);
            }
        }

        @Override
        public void setEnableRollbackCode(int token, int enableRollbackCode) {
            PackageManagerService.this.setEnableRollbackCode(token, enableRollbackCode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean compileLayouts(String packageName) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                if (pkg == null) {
                    return false;
                }
                return PackageManagerService.this.mArtManagerService.compileLayouts(pkg);
            }
        }

        @Override
        public void finishPackageInstall(int token, boolean didLaunch) {
            PackageManagerService.this.finishPackageInstall(token, didLaunch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String removeLegacyDefaultBrowserPackageName(int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.mSettings.removeDefaultBrowserPackageNameLPw(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDefaultBrowserProvider(PackageManagerInternal.DefaultBrowserProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultBrowserProvider = provider;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDefaultDialerProvider(PackageManagerInternal.DefaultDialerProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultDialerProvider = provider;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDefaultHomeProvider(PackageManagerInternal.DefaultHomeProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultHomeProvider = provider;
            }
        }

        @Override
        public boolean isApexPackage(String packageName) {
            return PackageManagerService.this.mApexManager.isApexPackage(packageName);
        }

        @Override
        public void uninstallApex(String packageName, long versionCode, int userId, IntentSender intentSender) {
            int callerUid = Binder.getCallingUid();
            if (callerUid != 0 && callerUid != 2000) {
                throw new SecurityException("Not allowed to uninstall apexes");
            }
            PackageInstallerService.PackageDeleteObserverAdapter adapter = new PackageInstallerService.PackageDeleteObserverAdapter(PackageManagerService.this.mContext, intentSender, packageName, false, userId);
            if (userId != -1) {
                adapter.onPackageDeleted(packageName, -5, "Can't uninstall an apex for a single user");
                return;
            }
            ApexManager am = PackageManagerService.this.mApexManager;
            PackageInfo activePackage = am.getPackageInfo(packageName, 1);
            if (activePackage == null) {
                adapter.onPackageDeleted(packageName, -5, packageName + " is not an apex package");
                return;
            }
            if (versionCode != -1L && activePackage.getLongVersionCode() != versionCode) {
                adapter.onPackageDeleted(packageName, -5, "Active version " + activePackage.getLongVersionCode() + " is not equal to " + versionCode + "]");
                return;
            }
            if (!am.uninstallApex(activePackage.applicationInfo.sourceDir)) {
                adapter.onPackageDeleted(packageName, -5, "Failed to uninstall apex " + packageName);
            } else {
                adapter.onPackageDeleted(packageName, 1, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean wereDefaultPermissionsGrantedSinceBoot(int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.mDefaultPermissionPolicy.wereDefaultPermissionsGrantedSinceBoot(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRuntimePermissionsFingerPrint(String fingerPrint, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mSettings.setRuntimePermissionsFingerPrintLPr(fingerPrint, userId);
            }
        }

        @Override
        public void migrateLegacyObbData() {
            try {
                PackageManagerService.this.mInstaller.migrateLegacyObbData();
            }
            catch (Exception e) {
                Slog.wtf(PackageManagerService.TAG, e);
            }
        }
    }

    private class PackageManagerNative
    extends IPackageManagerNative.Stub {
        private PackageManagerNative() {
        }

        @Override
        public String[] getNamesForUids(int[] uids) throws RemoteException {
            String[] results = PackageManagerService.this.getNamesForUids(uids);
            for (int i = results.length - 1; i >= 0; --i) {
                if (results[i] != null) continue;
                results[i] = "";
            }
            return results;
        }

        @Override
        public String getInstallerForPackage(String packageName) throws RemoteException {
            String installerName = PackageManagerService.this.getInstallerPackageName(packageName);
            if (!TextUtils.isEmpty(installerName)) {
                return installerName;
            }
            int callingUser = UserHandle.getUserId(Binder.getCallingUid());
            ApplicationInfo appInfo = PackageManagerService.this.getApplicationInfo(packageName, 0, callingUser);
            if (appInfo != null && (appInfo.flags & 1) != 0) {
                return "preload";
            }
            return "";
        }

        @Override
        public long getVersionCodeForPackage(String packageName) throws RemoteException {
            try {
                int callingUser = UserHandle.getUserId(Binder.getCallingUid());
                PackageInfo pInfo = PackageManagerService.this.getPackageInfo(packageName, 0, callingUser);
                if (pInfo != null) {
                    return pInfo.getLongVersionCode();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0L;
        }

        @Override
        public int getTargetSdkVersionForPackage(String packageName) throws RemoteException {
            int callingUser = UserHandle.getUserId(Binder.getCallingUid());
            ApplicationInfo info = PackageManagerService.this.getApplicationInfo(packageName, 0, callingUser);
            if (info == null) {
                throw new RemoteException("Couldn't get ApplicationInfo for package " + packageName);
            }
            return info.targetSdkVersion;
        }

        @Override
        public boolean[] isAudioPlaybackCaptureAllowed(String[] packageNames) throws RemoteException {
            int callingUser = UserHandle.getUserId(Binder.getCallingUid());
            boolean[] results = new boolean[packageNames.length];
            for (int i = results.length - 1; i >= 0; --i) {
                ApplicationInfo appInfo = PackageManagerService.this.getApplicationInfo(packageNames[i], 0, callingUser);
                results[i] = appInfo == null ? false : appInfo.isAudioPlaybackCaptureAllowed();
            }
            return results;
        }

        @Override
        public int getLocationFlags(String packageName) throws RemoteException {
            int callingUser = UserHandle.getUserId(Binder.getCallingUid());
            ApplicationInfo appInfo = PackageManagerService.this.getApplicationInfo(packageName, 0, callingUser);
            if (appInfo == null) {
                throw new RemoteException("Couldn't get ApplicationInfo for package " + packageName);
            }
            return (appInfo.isSystemApp() ? 1 : 0) | (appInfo.isVendor() ? 2 : 0) | (appInfo.isProduct() ? 4 : 0);
        }

        @Override
        public String getModuleMetadataPackageName() throws RemoteException {
            return PackageManagerService.this.mModuleInfoProvider.getPackageName();
        }
    }

    private static final class OnPermissionChangeListeners
    extends Handler {
        private static final int MSG_ON_PERMISSIONS_CHANGED = 1;
        private final RemoteCallbackList<IOnPermissionsChangeListener> mPermissionListeners = new RemoteCallbackList();

        public OnPermissionChangeListeners(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    this.handleOnPermissionsChanged(uid);
                }
            }
        }

        public void addListenerLocked(IOnPermissionsChangeListener listener) {
            this.mPermissionListeners.register(listener);
        }

        public void removeListenerLocked(IOnPermissionsChangeListener listener) {
            this.mPermissionListeners.unregister(listener);
        }

        public void onPermissionsChanged(int uid) {
            if (this.mPermissionListeners.getRegisteredCallbackCount() > 0) {
                this.obtainMessage(1, uid, 0).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleOnPermissionsChanged(int uid) {
            int count = this.mPermissionListeners.beginBroadcast();
            try {
                for (int i = 0; i < count; ++i) {
                    IOnPermissionsChangeListener callback = this.mPermissionListeners.getBroadcastItem(i);
                    try {
                        callback.onPermissionsChanged(uid);
                        continue;
                    }
                    catch (RemoteException e) {
                        Log.e(PackageManagerService.TAG, "Permission listener is dead", e);
                    }
                }
            }
            finally {
                this.mPermissionListeners.finishBroadcast();
            }
        }
    }

    private static class MoveCallbacks
    extends Handler {
        private static final int MSG_CREATED = 1;
        private static final int MSG_STATUS_CHANGED = 2;
        private final RemoteCallbackList<IPackageMoveObserver> mCallbacks = new RemoteCallbackList();
        private final SparseIntArray mLastStatus = new SparseIntArray();

        public MoveCallbacks(Looper looper) {
            super(looper);
        }

        public void register(IPackageMoveObserver callback) {
            this.mCallbacks.register(callback);
        }

        public void unregister(IPackageMoveObserver callback) {
            this.mCallbacks.unregister(callback);
        }

        @Override
        public void handleMessage(Message msg) {
            SomeArgs args = (SomeArgs)msg.obj;
            int n = this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                IPackageMoveObserver callback = this.mCallbacks.getBroadcastItem(i);
                try {
                    this.invokeCallback(callback, msg.what, args);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mCallbacks.finishBroadcast();
            args.recycle();
        }

        private void invokeCallback(IPackageMoveObserver callback, int what, SomeArgs args) throws RemoteException {
            switch (what) {
                case 1: {
                    callback.onCreated(args.argi1, (Bundle)args.arg2);
                    break;
                }
                case 2: {
                    callback.onStatusChanged(args.argi1, args.argi2, (Long)args.arg3);
                }
            }
        }

        private void notifyCreated(int moveId, Bundle extras) {
            Slog.v(PackageManagerService.TAG, "Move " + moveId + " created " + extras.toString());
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = moveId;
            args.arg2 = extras;
            this.obtainMessage(1, args).sendToTarget();
        }

        private void notifyStatusChanged(int moveId, int status) {
            this.notifyStatusChanged(moveId, status, -1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyStatusChanged(int moveId, int status, long estMillis) {
            Slog.v(PackageManagerService.TAG, "Move " + moveId + " status " + status);
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = moveId;
            args.argi2 = status;
            args.arg3 = estMillis;
            this.obtainMessage(2, args).sendToTarget();
            SparseIntArray sparseIntArray = this.mLastStatus;
            synchronized (sparseIntArray) {
                this.mLastStatus.put(moveId, status);
            }
        }
    }

    private class PackageFreezer
    implements AutoCloseable {
        private final String mPackageName;
        private final PackageFreezer[] mChildren;
        private final boolean mWeFroze;
        private final AtomicBoolean mClosed = new AtomicBoolean();
        private final CloseGuard mCloseGuard = CloseGuard.get();

        public PackageFreezer() {
            this.mPackageName = null;
            this.mChildren = null;
            this.mWeFroze = false;
            this.mCloseGuard.open("close");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PackageFreezer(String packageName, int userId, String killReason) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageParser.Package p;
                this.mPackageName = packageName;
                this.mWeFroze = PackageManagerService.this.mFrozenPackages.add(this.mPackageName);
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(this.mPackageName);
                if (ps != null) {
                    PackageManagerService.this.killApplication(ps.name, ps.appId, userId, killReason);
                }
                if ((p = PackageManagerService.this.mPackages.get(packageName)) != null && p.childPackages != null) {
                    int N = p.childPackages.size();
                    this.mChildren = new PackageFreezer[N];
                    for (int i = 0; i < N; ++i) {
                        this.mChildren[i] = new PackageFreezer(p.childPackages.get((int)i).packageName, userId, killReason);
                    }
                } else {
                    this.mChildren = null;
                }
            }
            this.mCloseGuard.open("close");
        }

        protected void finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.mCloseGuard.close();
            if (this.mClosed.compareAndSet(false, true)) {
                ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                synchronized (arrayMap) {
                    if (this.mWeFroze) {
                        PackageManagerService.this.mFrozenPackages.remove(this.mPackageName);
                    }
                    if (this.mChildren != null) {
                        for (PackageFreezer freezer : this.mChildren) {
                            freezer.close();
                        }
                    }
                }
            }
        }
    }

    private static interface BlobXmlRestorer {
        public void apply(XmlPullParser var1, int var2) throws IOException, XmlPullParserException;
    }

    private static class SystemDeleteException
    extends Exception {
        public final PackageManagerException reason;

        private SystemDeleteException(PackageManagerException reason) {
            this.reason = reason;
        }
    }

    private static class DeletePackageAction {
        public final PackageSetting deletingPs;
        public final PackageSetting disabledPs;
        public final PackageRemovedInfo outInfo;
        public final int flags;
        public final UserHandle user;

        private DeletePackageAction(PackageSetting deletingPs, PackageSetting disabledPs, PackageRemovedInfo outInfo, int flags, UserHandle user) {
            this.deletingPs = deletingPs;
            this.disabledPs = disabledPs;
            this.outInfo = outInfo;
            this.flags = flags;
            this.user = user;
        }
    }

    static class PackageRemovedInfo {
        final PackageSender packageSender;
        String removedPackage;
        String installerPackageName;
        int uid = -1;
        int removedAppId = -1;
        int[] origUsers;
        int[] removedUsers = null;
        int[] broadcastUsers = null;
        int[] instantUserIds = null;
        SparseArray<Integer> installReasons;
        boolean isRemovedPackageSystemUpdate = false;
        boolean isUpdate;
        boolean dataRemoved;
        boolean removedForAllUsers;
        boolean isStaticSharedLib;
        InstallArgs args = null;
        ArrayMap<String, PackageRemovedInfo> removedChildPackages;
        ArrayMap<String, PackageInstalledInfo> appearedChildPackages;

        PackageRemovedInfo(PackageSender packageSender) {
            this.packageSender = packageSender;
        }

        void sendPackageRemovedBroadcasts(boolean killApp) {
            this.sendPackageRemovedBroadcastInternal(killApp);
            int childCount = this.removedChildPackages != null ? this.removedChildPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                PackageRemovedInfo childInfo = this.removedChildPackages.valueAt(i);
                childInfo.sendPackageRemovedBroadcastInternal(killApp);
            }
        }

        void sendSystemPackageUpdatedBroadcasts() {
            if (this.isRemovedPackageSystemUpdate) {
                this.sendSystemPackageUpdatedBroadcastsInternal();
                int childCount = this.removedChildPackages != null ? this.removedChildPackages.size() : 0;
                for (int i = 0; i < childCount; ++i) {
                    PackageRemovedInfo childInfo = this.removedChildPackages.valueAt(i);
                    if (!childInfo.isRemovedPackageSystemUpdate) continue;
                    childInfo.sendSystemPackageUpdatedBroadcastsInternal();
                }
            }
        }

        void sendSystemPackageAppearedBroadcasts() {
            int packageCount = this.appearedChildPackages != null ? this.appearedChildPackages.size() : 0;
            for (int i = 0; i < packageCount; ++i) {
                PackageInstalledInfo installedInfo = this.appearedChildPackages.valueAt(i);
                this.packageSender.sendPackageAddedForNewUsers(installedInfo.name, true, false, UserHandle.getAppId(installedInfo.uid), installedInfo.newUsers, null);
            }
        }

        private void sendSystemPackageUpdatedBroadcastsInternal() {
            Bundle extras = new Bundle(2);
            extras.putInt("android.intent.extra.UID", this.removedAppId >= 0 ? this.removedAppId : this.uid);
            extras.putBoolean("android.intent.extra.REPLACING", true);
            this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", this.removedPackage, extras, 0, null, null, null, null);
            this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", this.removedPackage, extras, 0, null, null, null, null);
            this.packageSender.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, 0, this.removedPackage, null, null, null);
            if (this.installerPackageName != null) {
                this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", this.removedPackage, extras, 0, this.installerPackageName, null, null, null);
                this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", this.removedPackage, extras, 0, this.installerPackageName, null, null, null);
            }
        }

        private void sendPackageRemovedBroadcastInternal(boolean killApp) {
            if (this.isStaticSharedLib) {
                return;
            }
            Bundle extras = new Bundle(2);
            int removedUid = this.removedAppId >= 0 ? this.removedAppId : this.uid;
            extras.putInt("android.intent.extra.UID", removedUid);
            extras.putBoolean("android.intent.extra.DATA_REMOVED", this.dataRemoved);
            extras.putBoolean("android.intent.extra.DONT_KILL_APP", !killApp);
            if (this.isUpdate || this.isRemovedPackageSystemUpdate) {
                extras.putBoolean("android.intent.extra.REPLACING", true);
            }
            extras.putBoolean("android.intent.extra.REMOVED_FOR_ALL_USERS", this.removedForAllUsers);
            if (this.removedPackage != null) {
                this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_REMOVED", this.removedPackage, extras, 0, null, null, this.broadcastUsers, this.instantUserIds);
                if (this.installerPackageName != null) {
                    this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_REMOVED", this.removedPackage, extras, 0, this.installerPackageName, null, this.broadcastUsers, this.instantUserIds);
                }
                if (this.dataRemoved && !this.isRemovedPackageSystemUpdate) {
                    this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_FULLY_REMOVED", this.removedPackage, extras, 0x1000000, null, null, this.broadcastUsers, this.instantUserIds);
                    this.packageSender.notifyPackageRemoved(this.removedPackage, removedUid);
                }
            }
            if (this.removedAppId >= 0) {
                this.packageSender.sendPackageBroadcast("android.intent.action.UID_REMOVED", null, extras, 0x1000000, null, null, this.broadcastUsers, this.instantUserIds);
            }
        }

        void populateUsers(int[] userIds, PackageSetting deletedPackageSetting) {
            this.removedUsers = userIds;
            if (this.removedUsers == null) {
                this.broadcastUsers = null;
                return;
            }
            this.broadcastUsers = EMPTY_INT_ARRAY;
            this.instantUserIds = EMPTY_INT_ARRAY;
            for (int i = userIds.length - 1; i >= 0; --i) {
                int userId = userIds[i];
                if (deletedPackageSetting.getInstantApp(userId)) {
                    this.instantUserIds = ArrayUtils.appendInt(this.instantUserIds, userId);
                    continue;
                }
                this.broadcastUsers = ArrayUtils.appendInt(this.broadcastUsers, userId);
            }
        }
    }

    private static class PrepareFailure
    extends PackageManagerException {
        public String conflictingPackage;
        public String conflictingPermission;

        PrepareFailure(int error) {
            super(error, "Failed to prepare for install.");
        }

        PrepareFailure(int error, String detailMessage) {
            super(error, detailMessage);
        }

        PrepareFailure(String message, Exception e) {
            super(e instanceof PackageParser.PackageParserException ? ((PackageParser.PackageParserException)e).error : ((PackageManagerException)e).error, ExceptionUtils.getCompleteMessage(message, e));
        }

        PrepareFailure conflictsWithExistingPermission(String conflictingPermission, String conflictingPackage) {
            this.conflictingPermission = conflictingPermission;
            this.conflictingPackage = conflictingPackage;
            return this;
        }
    }

    private static class PrepareResult {
        public final int installReason;
        public final String volumeUuid;
        public final String installerPackageName;
        public final UserHandle user;
        public final boolean replace;
        public final int scanFlags;
        public final int parseFlags;
        public final PackageParser.Package existingPackage;
        public final PackageParser.Package packageToScan;
        public final boolean clearCodeCache;
        public final boolean system;
        public final String renamedPackage;
        public final PackageFreezer freezer;
        public final PackageSetting originalPs;
        public final PackageSetting disabledPs;
        public final PackageSetting[] childPackageSettings;

        private PrepareResult(int installReason, String volumeUuid, String installerPackageName, UserHandle user, boolean replace, int scanFlags, int parseFlags, PackageParser.Package existingPackage, PackageParser.Package packageToScan, boolean clearCodeCache, boolean system, String renamedPackage, PackageFreezer freezer, PackageSetting originalPs, PackageSetting disabledPs, PackageSetting[] childPackageSettings) {
            this.installReason = installReason;
            this.volumeUuid = volumeUuid;
            this.installerPackageName = installerPackageName;
            this.user = user;
            this.replace = replace;
            this.scanFlags = scanFlags;
            this.parseFlags = parseFlags;
            this.existingPackage = existingPackage;
            this.packageToScan = packageToScan;
            this.clearCodeCache = clearCodeCache;
            this.system = system;
            this.renamedPackage = renamedPackage;
            this.freezer = freezer;
            this.originalPs = originalPs;
            this.disabledPs = disabledPs;
            this.childPackageSettings = childPackageSettings;
        }
    }

    private static class ReconciledPackage {
        public final ReconcileRequest request;
        public final PackageSetting pkgSetting;
        public final ScanResult scanResult;
        public final PackageInstalledInfo installResult;
        public final PrepareResult prepareResult;
        public final InstallArgs installArgs;
        public final DeletePackageAction deletePackageAction;
        public final List<SharedLibraryInfo> allowedSharedLibraryInfos;
        public final PackageParser.SigningDetails signingDetails;
        public final boolean sharedUserSignaturesChanged;
        public ArrayList<SharedLibraryInfo> collectedSharedLibraryInfos;
        public final boolean removeAppKeySetData;

        private ReconciledPackage(ReconcileRequest request, InstallArgs installArgs, PackageSetting pkgSetting, PackageInstalledInfo installResult, PrepareResult prepareResult, ScanResult scanResult, DeletePackageAction deletePackageAction, List<SharedLibraryInfo> allowedSharedLibraryInfos, PackageParser.SigningDetails signingDetails, boolean sharedUserSignaturesChanged, boolean removeAppKeySetData) {
            this.request = request;
            this.installArgs = installArgs;
            this.pkgSetting = pkgSetting;
            this.installResult = installResult;
            this.prepareResult = prepareResult;
            this.scanResult = scanResult;
            this.deletePackageAction = deletePackageAction;
            this.allowedSharedLibraryInfos = allowedSharedLibraryInfos;
            this.signingDetails = signingDetails;
            this.sharedUserSignaturesChanged = sharedUserSignaturesChanged;
            this.removeAppKeySetData = removeAppKeySetData;
        }

        private Map<String, PackageParser.Package> getCombinedPackages() {
            ArrayMap<String, PackageParser.Package> combinedPackages = new ArrayMap<String, PackageParser.Package>(this.request.allPackages.size() + this.request.scannedPackages.size());
            combinedPackages.putAll(this.request.allPackages);
            for (ScanResult scanResult : this.request.scannedPackages.values()) {
                combinedPackages.put(scanResult.pkgSetting.name, scanResult.request.pkg);
            }
            return combinedPackages;
        }
    }

    private static class ReconcileFailure
    extends PackageManagerException {
        ReconcileFailure(String message) {
            super("Reconcile failed: " + message);
        }

        ReconcileFailure(int reason, String message) {
            super(reason, "Reconcile failed: " + message);
        }

        ReconcileFailure(PackageManagerException e) {
            this(e.error, e.getMessage());
        }
    }

    private static class ReconcileRequest {
        public final Map<String, ScanResult> scannedPackages;
        public final Map<String, PackageParser.Package> allPackages;
        public final Map<String, LongSparseArray<SharedLibraryInfo>> sharedLibrarySource;
        public final Map<String, InstallArgs> installArgs;
        public final Map<String, PackageInstalledInfo> installResults;
        public final Map<String, PrepareResult> preparedPackages;
        public final Map<String, Settings.VersionInfo> versionInfos;
        public final Map<String, PackageSetting> lastStaticSharedLibSettings;

        private ReconcileRequest(Map<String, ScanResult> scannedPackages, Map<String, InstallArgs> installArgs, Map<String, PackageInstalledInfo> installResults, Map<String, PrepareResult> preparedPackages, Map<String, LongSparseArray<SharedLibraryInfo>> sharedLibrarySource, Map<String, PackageParser.Package> allPackages, Map<String, Settings.VersionInfo> versionInfos, Map<String, PackageSetting> lastStaticSharedLibSettings) {
            this.scannedPackages = scannedPackages;
            this.installArgs = installArgs;
            this.installResults = installResults;
            this.preparedPackages = preparedPackages;
            this.sharedLibrarySource = sharedLibrarySource;
            this.allPackages = allPackages;
            this.versionInfos = versionInfos;
            this.lastStaticSharedLibSettings = lastStaticSharedLibSettings;
        }

        private ReconcileRequest(Map<String, ScanResult> scannedPackages, Map<String, LongSparseArray<SharedLibraryInfo>> sharedLibrarySource, Map<String, PackageParser.Package> allPackages, Map<String, Settings.VersionInfo> versionInfos, Map<String, PackageSetting> lastStaticSharedLibSettings) {
            this(scannedPackages, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), sharedLibrarySource, allPackages, versionInfos, lastStaticSharedLibSettings);
        }
    }

    private static class CommitRequest {
        final Map<String, ReconciledPackage> reconciledPackages;
        final int[] mAllUsers;

        private CommitRequest(Map<String, ReconciledPackage> reconciledPackages, int[] allUsers) {
            this.reconciledPackages = reconciledPackages;
            this.mAllUsers = allUsers;
        }
    }

    private static class InstallRequest {
        public final InstallArgs args;
        public final PackageInstalledInfo installResult;

        private InstallRequest(InstallArgs args, PackageInstalledInfo res) {
            this.args = args;
            this.installResult = res;
        }
    }

    static class PackageInstalledInfo {
        String name;
        int uid;
        int[] origUsers;
        int[] newUsers;
        PackageParser.Package pkg;
        int returnCode;
        String returnMsg;
        String installerPackageName;
        PackageRemovedInfo removedInfo;
        ArrayMap<String, PackageInstalledInfo> addedChildPackages;
        String origPackage;
        String origPermission;

        PackageInstalledInfo() {
        }

        public void setError(int code, String msg) {
            this.setReturnCode(code);
            this.setReturnMessage(msg);
            Slog.w(PackageManagerService.TAG, msg);
        }

        public void setError(String msg, PackageParser.PackageParserException e) {
            this.setReturnCode(e.error);
            this.setReturnMessage(ExceptionUtils.getCompleteMessage(msg, e));
            int childCount = this.addedChildPackages != null ? this.addedChildPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                this.addedChildPackages.valueAt(i).setError(msg, e);
            }
            Slog.w(PackageManagerService.TAG, msg, e);
        }

        public void setError(String msg, PackageManagerException e) {
            this.returnCode = e.error;
            this.setReturnMessage(ExceptionUtils.getCompleteMessage(msg, e));
            int childCount = this.addedChildPackages != null ? this.addedChildPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                this.addedChildPackages.valueAt(i).setError(msg, e);
            }
            Slog.w(PackageManagerService.TAG, msg, e);
        }

        public void setReturnCode(int returnCode) {
            this.returnCode = returnCode;
            int childCount = this.addedChildPackages != null ? this.addedChildPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                this.addedChildPackages.valueAt((int)i).returnCode = returnCode;
            }
        }

        private void setReturnMessage(String returnMsg) {
            this.returnMsg = returnMsg;
            int childCount = this.addedChildPackages != null ? this.addedChildPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                this.addedChildPackages.valueAt((int)i).returnMsg = returnMsg;
            }
        }
    }

    class MoveInstallArgs
    extends InstallArgs {
        private File codeFile;
        private File resourceFile;

        MoveInstallArgs(InstallParams params) {
            super(params.origin, params.move, params.observer, params.installFlags, params.installerPackageName, params.volumeUuid, params.getUser(), null, params.packageAbiOverride, params.grantedRuntimePermissions, params.whitelistedRestrictedPermissions, params.traceMethod, params.traceCookie, params.signingDetails, params.installReason, params.mParentInstallParams);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int copyApk() {
            Installer installer = PackageManagerService.this.mInstaller;
            synchronized (installer) {
                try {
                    PackageManagerService.this.mInstaller.moveCompleteApp(this.move.fromUuid, this.move.toUuid, this.move.packageName, this.move.dataAppName, this.move.appId, this.move.seinfo, this.move.targetSdkVersion);
                }
                catch (Installer.InstallerException e) {
                    Slog.w(PackageManagerService.TAG, "Failed to move app", e);
                    return -110;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
                this.resourceFile = this.codeFile = new File(Environment.getDataAppDirectory(this.move.toUuid), this.move.dataAppName);
                return 1;
            }
        }

        @Override
        int doPreInstall(int status) {
            if (status != 1) {
                this.cleanUp(this.move.toUuid);
            }
            return status;
        }

        @Override
        boolean doRename(int status, PackageParser.Package pkg) {
            if (status != 1) {
                this.cleanUp(this.move.toUuid);
                return false;
            }
            pkg.setApplicationVolumeUuid(pkg.volumeUuid);
            pkg.setApplicationInfoCodePath(pkg.codePath);
            pkg.setApplicationInfoBaseCodePath(pkg.baseCodePath);
            pkg.setApplicationInfoSplitCodePaths(pkg.splitCodePaths);
            pkg.setApplicationInfoResourcePath(pkg.codePath);
            pkg.setApplicationInfoBaseResourcePath(pkg.baseCodePath);
            pkg.setApplicationInfoSplitResourcePaths(pkg.splitCodePaths);
            return true;
        }

        @Override
        int doPostInstall(int status, int uid) {
            if (status == 1) {
                this.cleanUp(this.move.fromUuid);
            } else {
                this.cleanUp(this.move.toUuid);
            }
            return status;
        }

        @Override
        String getCodePath() {
            return this.codeFile != null ? this.codeFile.getAbsolutePath() : null;
        }

        @Override
        String getResourcePath() {
            return this.resourceFile != null ? this.resourceFile.getAbsolutePath() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cleanUp(String volumeUuid) {
            File codeFile = new File(Environment.getDataAppDirectory(volumeUuid), this.move.dataAppName);
            Slog.d(PackageManagerService.TAG, "Cleaning up " + this.move.packageName + " on " + volumeUuid);
            int[] userIds = sUserManager.getUserIds();
            Object object = PackageManagerService.this.mInstallLock;
            synchronized (object) {
                for (int userId : userIds) {
                    try {
                        PackageManagerService.this.mInstaller.destroyAppData(volumeUuid, this.move.packageName, userId, 3, 0L);
                    }
                    catch (Installer.InstallerException e) {
                        Slog.w(PackageManagerService.TAG, String.valueOf(e));
                    }
                }
                PackageManagerService.this.removeCodePathLI(codeFile);
            }
            return true;
        }

        @Override
        void cleanUpResourcesLI() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean doPostDeleteLI(boolean delete) {
            throw new UnsupportedOperationException();
        }
    }

    class FileInstallArgs
    extends InstallArgs {
        private File codeFile;
        private File resourceFile;

        FileInstallArgs(InstallParams params) {
            super(params.origin, params.move, params.observer, params.installFlags, params.installerPackageName, params.volumeUuid, params.getUser(), null, params.packageAbiOverride, params.grantedRuntimePermissions, params.whitelistedRestrictedPermissions, params.traceMethod, params.traceCookie, params.signingDetails, params.installReason, params.mParentInstallParams);
        }

        FileInstallArgs(String codePath, String resourcePath, String[] instructionSets) {
            super(OriginInfo.fromNothing(), null, null, 0, null, null, null, instructionSets, null, null, null, null, 0, PackageParser.SigningDetails.UNKNOWN, 0, null);
            this.codeFile = codePath != null ? new File(codePath) : null;
            this.resourceFile = resourcePath != null ? new File(resourcePath) : null;
        }

        @Override
        int copyApk() {
            Trace.traceBegin(262144L, "copyApk");
            try {
                int n = this.doCopyApk();
                return n;
            }
            finally {
                Trace.traceEnd(262144L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int doCopyApk() {
            if (this.origin.staged) {
                this.codeFile = this.origin.file;
                this.resourceFile = this.origin.file;
                return 1;
            }
            try {
                File tempDir;
                boolean isEphemeral = (this.installFlags & 0x800) != 0;
                this.codeFile = tempDir = PackageManagerService.this.mInstallerService.allocateStageDirLegacy(this.volumeUuid, isEphemeral);
                this.resourceFile = tempDir;
            }
            catch (IOException e) {
                Slog.w(PackageManagerService.TAG, "Failed to create copy file: " + e);
                return -4;
            }
            int ret = PackageManagerServiceUtils.copyPackage(this.origin.file.getAbsolutePath(), this.codeFile);
            if (ret != 1) {
                Slog.e(PackageManagerService.TAG, "Failed to copy package");
                return ret;
            }
            File libraryRoot = new File(this.codeFile, "lib");
            NativeLibraryHelper.Handle handle = null;
            try {
                handle = NativeLibraryHelper.Handle.create(this.codeFile);
                ret = NativeLibraryHelper.copyNativeBinariesWithOverride(handle, libraryRoot, this.abiOverride);
            }
            catch (IOException e) {
                Slog.e(PackageManagerService.TAG, "Copying native libraries failed", e);
                ret = -110;
            }
            finally {
                IoUtils.closeQuietly(handle);
            }
            return ret;
        }

        @Override
        int doPreInstall(int status) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        @Override
        boolean doRename(int status, PackageParser.Package pkg) {
            if (status != 1) {
                this.cleanUp();
                return false;
            }
            File targetDir = this.codeFile.getParentFile();
            File beforeCodeFile = this.codeFile;
            File afterCodeFile = PackageManagerService.this.getNextCodePath(targetDir, pkg.packageName);
            try {
                Os.rename(beforeCodeFile.getAbsolutePath(), afterCodeFile.getAbsolutePath());
            }
            catch (ErrnoException e) {
                Slog.w(PackageManagerService.TAG, "Failed to rename", e);
                return false;
            }
            if (!SELinux.restoreconRecursive(afterCodeFile)) {
                Slog.w(PackageManagerService.TAG, "Failed to restorecon");
                return false;
            }
            this.codeFile = afterCodeFile;
            this.resourceFile = afterCodeFile;
            try {
                pkg.setCodePath(afterCodeFile.getCanonicalPath());
            }
            catch (IOException e) {
                Slog.e(PackageManagerService.TAG, "Failed to get path: " + afterCodeFile, e);
                return false;
            }
            pkg.setBaseCodePath(FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.baseCodePath));
            pkg.setSplitCodePaths(FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.splitCodePaths));
            pkg.setApplicationVolumeUuid(pkg.volumeUuid);
            pkg.setApplicationInfoCodePath(pkg.codePath);
            pkg.setApplicationInfoBaseCodePath(pkg.baseCodePath);
            pkg.setApplicationInfoSplitCodePaths(pkg.splitCodePaths);
            pkg.setApplicationInfoResourcePath(pkg.codePath);
            pkg.setApplicationInfoBaseResourcePath(pkg.baseCodePath);
            pkg.setApplicationInfoSplitResourcePaths(pkg.splitCodePaths);
            return true;
        }

        @Override
        int doPostInstall(int status, int uid) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        @Override
        String getCodePath() {
            return this.codeFile != null ? this.codeFile.getAbsolutePath() : null;
        }

        @Override
        String getResourcePath() {
            return this.resourceFile != null ? this.resourceFile.getAbsolutePath() : null;
        }

        private boolean cleanUp() {
            if (this.codeFile == null || !this.codeFile.exists()) {
                return false;
            }
            PackageManagerService.this.removeCodePathLI(this.codeFile);
            if (this.resourceFile != null && !FileUtils.contains(this.codeFile, this.resourceFile)) {
                this.resourceFile.delete();
            }
            return true;
        }

        @Override
        void cleanUpResourcesLI() {
            List<String> allCodePaths = Collections.EMPTY_LIST;
            if (this.codeFile != null && this.codeFile.exists()) {
                try {
                    PackageParser.PackageLite pkg = PackageParser.parsePackageLite(this.codeFile, 0);
                    allCodePaths = pkg.getAllCodePaths();
                }
                catch (PackageParser.PackageParserException packageParserException) {
                    // empty catch block
                }
            }
            this.cleanUp();
            PackageManagerService.this.removeDexFiles(allCodePaths, this.instructionSets);
        }

        @Override
        boolean doPostDeleteLI(boolean delete) {
            this.cleanUpResourcesLI();
            return true;
        }
    }

    static abstract class InstallArgs {
        final OriginInfo origin;
        final MoveInfo move;
        final IPackageInstallObserver2 observer;
        final int installFlags;
        final String installerPackageName;
        final String volumeUuid;
        final UserHandle user;
        final String abiOverride;
        final String[] installGrantPermissions;
        final List<String> whitelistedRestrictedPermissions;
        final String traceMethod;
        final int traceCookie;
        final PackageParser.SigningDetails signingDetails;
        final int installReason;
        final MultiPackageInstallParams mMultiPackageInstallParams;
        String[] instructionSets;

        InstallArgs(OriginInfo origin, MoveInfo move, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, String volumeUuid, UserHandle user, String[] instructionSets, String abiOverride, String[] installGrantPermissions, List<String> whitelistedRestrictedPermissions, String traceMethod, int traceCookie, PackageParser.SigningDetails signingDetails, int installReason, MultiPackageInstallParams multiPackageInstallParams) {
            this.origin = origin;
            this.move = move;
            this.installFlags = installFlags;
            this.observer = observer;
            this.installerPackageName = installerPackageName;
            this.volumeUuid = volumeUuid;
            this.user = user;
            this.instructionSets = instructionSets;
            this.abiOverride = abiOverride;
            this.installGrantPermissions = installGrantPermissions;
            this.whitelistedRestrictedPermissions = whitelistedRestrictedPermissions;
            this.traceMethod = traceMethod;
            this.traceCookie = traceCookie;
            this.signingDetails = signingDetails;
            this.installReason = installReason;
            this.mMultiPackageInstallParams = multiPackageInstallParams;
        }

        abstract int copyApk();

        abstract int doPreInstall(int var1);

        abstract boolean doRename(int var1, PackageParser.Package var2);

        abstract int doPostInstall(int var1, int var2);

        abstract String getCodePath();

        abstract String getResourcePath();

        abstract void cleanUpResourcesLI();

        abstract boolean doPostDeleteLI(boolean var1);

        int doPreCopy() {
            return 1;
        }

        int doPostCopy(int uid) {
            return 1;
        }

        protected boolean isEphemeral() {
            return (this.installFlags & 0x800) != 0;
        }

        UserHandle getUser() {
            return this.user;
        }
    }

    class InstallParams
    extends HandlerParams {
        final OriginInfo origin;
        final MoveInfo move;
        final IPackageInstallObserver2 observer;
        int installFlags;
        final String installerPackageName;
        final String volumeUuid;
        private boolean mVerificationCompleted;
        private boolean mEnableRollbackCompleted;
        private InstallArgs mArgs;
        int mRet;
        final String packageAbiOverride;
        final String[] grantedRuntimePermissions;
        final List<String> whitelistedRestrictedPermissions;
        final VerificationInfo verificationInfo;
        final PackageParser.SigningDetails signingDetails;
        final int installReason;
        MultiPackageInstallParams mParentInstallParams;
        final long requiredInstalledVersionCode;

        InstallParams(OriginInfo origin, MoveInfo move, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, String volumeUuid, VerificationInfo verificationInfo, UserHandle user, String packageAbiOverride, String[] grantedPermissions, List<String> whitelistedRestrictedPermissions, PackageParser.SigningDetails signingDetails, int installReason, long requiredInstalledVersionCode) {
            super(user);
            this.origin = origin;
            this.move = move;
            this.observer = observer;
            this.installFlags = installFlags;
            this.installerPackageName = installerPackageName;
            this.volumeUuid = volumeUuid;
            this.verificationInfo = verificationInfo;
            this.packageAbiOverride = packageAbiOverride;
            this.grantedRuntimePermissions = grantedPermissions;
            this.whitelistedRestrictedPermissions = whitelistedRestrictedPermissions;
            this.signingDetails = signingDetails;
            this.installReason = installReason;
            this.requiredInstalledVersionCode = requiredInstalledVersionCode;
        }

        InstallParams(ActiveInstallSession activeInstallSession) {
            super(activeInstallSession.getUser());
            if (DEBUG_INSTANT && (activeInstallSession.getSessionParams().installFlags & 0x800) != 0) {
                Slog.d(PackageManagerService.TAG, "Ephemeral install of " + activeInstallSession.getPackageName());
            }
            this.verificationInfo = new VerificationInfo(activeInstallSession.getSessionParams().originatingUri, activeInstallSession.getSessionParams().referrerUri, activeInstallSession.getSessionParams().originatingUid, activeInstallSession.getInstallerUid());
            this.origin = OriginInfo.fromStagedFile(activeInstallSession.getStagedDir());
            this.move = null;
            this.installReason = PackageManagerService.this.fixUpInstallReason(activeInstallSession.getInstallerPackageName(), activeInstallSession.getInstallerUid(), activeInstallSession.getSessionParams().installReason);
            this.observer = activeInstallSession.getObserver();
            this.installFlags = activeInstallSession.getSessionParams().installFlags;
            this.installerPackageName = activeInstallSession.getInstallerPackageName();
            this.volumeUuid = activeInstallSession.getSessionParams().volumeUuid;
            this.packageAbiOverride = activeInstallSession.getSessionParams().abiOverride;
            this.grantedRuntimePermissions = activeInstallSession.getSessionParams().grantedRuntimePermissions;
            this.whitelistedRestrictedPermissions = activeInstallSession.getSessionParams().whitelistedRestrictedPermissions;
            this.signingDetails = activeInstallSession.getSigningDetails();
            this.requiredInstalledVersionCode = activeInstallSession.getSessionParams().requiredInstalledVersionCode;
        }

        public String toString() {
            return "InstallParams{" + Integer.toHexString(System.identityHashCode(this)) + " file=" + this.origin.file + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int installLocationPolicy(PackageInfoLite pkgLite) {
            String packageName = pkgLite.packageName;
            int installLocation = pkgLite.installLocation;
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps;
                PackageParser.Package installedPkg;
                PackageParser.Package dataOwnerPkg = installedPkg = PackageManagerService.this.mPackages.get(packageName);
                if (dataOwnerPkg == null && (ps = PackageManagerService.this.mSettings.mPackages.get(packageName)) != null) {
                    dataOwnerPkg = ps.pkg;
                }
                if (this.requiredInstalledVersionCode != -1L) {
                    if (dataOwnerPkg == null) {
                        Slog.w(PackageManagerService.TAG, "Required installed version code was " + this.requiredInstalledVersionCode + " but package is not installed");
                        return -8;
                    }
                    if (dataOwnerPkg.getLongVersionCode() != this.requiredInstalledVersionCode) {
                        Slog.w(PackageManagerService.TAG, "Required installed version code was " + this.requiredInstalledVersionCode + " but actual installed version is " + dataOwnerPkg.getLongVersionCode());
                        return -8;
                    }
                }
                if (dataOwnerPkg != null && !PackageManagerServiceUtils.isDowngradePermitted(this.installFlags, dataOwnerPkg.applicationInfo.flags)) {
                    try {
                        PackageManagerService.checkDowngrade(dataOwnerPkg, pkgLite);
                    }
                    catch (PackageManagerException e) {
                        Slog.w(PackageManagerService.TAG, "Downgrade detected: " + e.getMessage());
                        return -7;
                    }
                }
                if (installedPkg != null) {
                    if ((this.installFlags & 2) != 0) {
                        if ((installedPkg.applicationInfo.flags & 1) != 0) {
                            return 1;
                        }
                        if (installLocation == 1) {
                            return 1;
                        }
                        if (installLocation != 2) {
                            if (PackageManagerService.isExternal(installedPkg)) {
                                return 2;
                            }
                            return 1;
                        }
                    } else {
                        return -4;
                    }
                }
                return pkgLite.recommendedInstallLocation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleStartCopy() {
            int ret = 1;
            if (this.origin.staged) {
                if (this.origin.file != null) {
                    this.installFlags |= 0x10;
                } else {
                    throw new IllegalStateException("Invalid stage location");
                }
            }
            boolean onInt = (this.installFlags & 0x10) != 0;
            boolean ephemeral = (this.installFlags & 0x800) != 0;
            PackageInfoLite pkgLite = null;
            pkgLite = PackageManagerServiceUtils.getMinimalPackageInfo(PackageManagerService.this.mContext, this.origin.resolvedPath, this.installFlags, this.packageAbiOverride);
            if (DEBUG_INSTANT && ephemeral) {
                Slog.v(PackageManagerService.TAG, "pkgLite for install: " + pkgLite);
            }
            if (!this.origin.staged && pkgLite.recommendedInstallLocation == -1) {
                StorageManager storage = StorageManager.from(PackageManagerService.this.mContext);
                long lowThreshold = storage.getStorageLowBytes(Environment.getDataDirectory());
                long sizeBytes = PackageManagerServiceUtils.calculateInstalledSize(this.origin.resolvedPath, this.packageAbiOverride);
                if (sizeBytes >= 0L) {
                    try {
                        PackageManagerService.this.mInstaller.freeCache(null, sizeBytes + lowThreshold, 0L, 0);
                        pkgLite = PackageManagerServiceUtils.getMinimalPackageInfo(PackageManagerService.this.mContext, this.origin.resolvedPath, this.installFlags, this.packageAbiOverride);
                    }
                    catch (Installer.InstallerException e) {
                        Slog.w(PackageManagerService.TAG, "Failed to free cache", e);
                    }
                }
                if (pkgLite.recommendedInstallLocation == -6) {
                    pkgLite.recommendedInstallLocation = -1;
                }
            }
            if (ret == 1) {
                int loc = pkgLite.recommendedInstallLocation;
                if (loc == -3) {
                    ret = -19;
                } else if (loc == -4) {
                    ret = -1;
                } else if (loc == -1) {
                    ret = -4;
                } else if (loc == -2) {
                    ret = -2;
                } else if (loc == -6) {
                    ret = -3;
                } else if (loc == -5) {
                    ret = -20;
                } else {
                    loc = this.installLocationPolicy(pkgLite);
                    if (loc == -7) {
                        ret = -25;
                    } else if (loc == -8) {
                        ret = -121;
                    } else if (!onInt) {
                        if (loc == 2) {
                            this.installFlags &= 0xFFFFFFEF;
                        } else if (loc == 3) {
                            if (DEBUG_INSTANT) {
                                Slog.v(PackageManagerService.TAG, "...setting INSTALL_EPHEMERAL install flag");
                            }
                            this.installFlags |= 0x800;
                            this.installFlags &= 0xFFFFFFEF;
                        } else {
                            this.installFlags |= 0x10;
                        }
                    }
                }
            }
            InstallArgs args = PackageManagerService.this.createInstallArgs(this);
            this.mVerificationCompleted = true;
            this.mEnableRollbackCompleted = true;
            this.mArgs = args;
            if (ret == 1) {
                int installerUid;
                UserHandle verifierUser = this.getUser();
                if (verifierUser == UserHandle.ALL) {
                    verifierUser = UserHandle.SYSTEM;
                }
                int requiredUid = PackageManagerService.this.mRequiredVerifierPackage == null ? -1 : PackageManagerService.this.getPackageUid(PackageManagerService.this.mRequiredVerifierPackage, 0x10000000, verifierUser.getIdentifier());
                int n = installerUid = this.verificationInfo == null ? -1 : this.verificationInfo.installerUid;
                if (!this.origin.existing && requiredUid != -1 && PackageManagerService.this.isVerificationEnabled(verifierUser.getIdentifier(), this.installFlags, installerUid)) {
                    Intent verification = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
                    verification.addFlags(0x10000000);
                    verification.setDataAndType(Uri.fromFile(new File(this.origin.resolvedPath)), PackageManagerService.PACKAGE_MIME_TYPE);
                    verification.addFlags(1);
                    List receivers = PackageManagerService.this.queryIntentReceiversInternal(verification, PackageManagerService.PACKAGE_MIME_TYPE, 0, verifierUser.getIdentifier(), false);
                    final int verificationId = PackageManagerService.this.mPendingVerificationToken++;
                    verification.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_PACKAGE", this.installerPackageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALL_FLAGS", this.installFlags);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_PACKAGE_NAME", pkgLite.packageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_VERSION_CODE", pkgLite.versionCode);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_LONG_VERSION_CODE", pkgLite.getLongVersionCode());
                    if (this.verificationInfo != null) {
                        if (this.verificationInfo.originatingUri != null) {
                            verification.putExtra("android.intent.extra.ORIGINATING_URI", this.verificationInfo.originatingUri);
                        }
                        if (this.verificationInfo.referrer != null) {
                            verification.putExtra("android.intent.extra.REFERRER", this.verificationInfo.referrer);
                        }
                        if (this.verificationInfo.originatingUid >= 0) {
                            verification.putExtra("android.intent.extra.ORIGINATING_UID", this.verificationInfo.originatingUid);
                        }
                        if (this.verificationInfo.installerUid >= 0) {
                            verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_UID", this.verificationInfo.installerUid);
                        }
                    }
                    PackageVerificationState verificationState = new PackageVerificationState(requiredUid, this);
                    PackageManagerService.this.mPendingVerification.append(verificationId, verificationState);
                    List sufficientVerifiers = PackageManagerService.this.matchVerifiers(pkgLite, receivers, verificationState);
                    DeviceIdleController.LocalService idleController = PackageManagerService.this.getDeviceIdleController();
                    long idleDuration = PackageManagerService.this.getVerificationTimeout();
                    if (sufficientVerifiers != null) {
                        int N = sufficientVerifiers.size();
                        if (N == 0) {
                            Slog.i(PackageManagerService.TAG, "Additional verifiers required, but none installed.");
                            ret = -22;
                        } else {
                            for (int i = 0; i < N; ++i) {
                                ComponentName verifierComponent = (ComponentName)sufficientVerifiers.get(i);
                                idleController.addPowerSaveTempWhitelistApp(Process.myUid(), verifierComponent.getPackageName(), idleDuration, verifierUser.getIdentifier(), false, "package verifier");
                                Intent sufficientIntent = new Intent(verification);
                                sufficientIntent.setComponent(verifierComponent);
                                PackageManagerService.this.mContext.sendBroadcastAsUser(sufficientIntent, verifierUser);
                            }
                        }
                    }
                    ComponentName requiredVerifierComponent = PackageManagerService.this.matchComponentForVerifier(PackageManagerService.this.mRequiredVerifierPackage, receivers);
                    if (ret == 1 && PackageManagerService.this.mRequiredVerifierPackage != null) {
                        Trace.asyncTraceBegin(262144L, "verification", verificationId);
                        verification.setComponent(requiredVerifierComponent);
                        idleController.addPowerSaveTempWhitelistApp(Process.myUid(), PackageManagerService.this.mRequiredVerifierPackage, idleDuration, verifierUser.getIdentifier(), false, "package verifier");
                        PackageManagerService.this.mContext.sendOrderedBroadcastAsUser(verification, verifierUser, "android.permission.PACKAGE_VERIFICATION_AGENT", new BroadcastReceiver(){

                            @Override
                            public void onReceive(Context context, Intent intent) {
                                Message msg = PackageManagerService.this.mHandler.obtainMessage(16);
                                msg.arg1 = verificationId;
                                PackageManagerService.this.mHandler.sendMessageDelayed(msg, PackageManagerService.this.getVerificationTimeout());
                            }
                        }, null, 0, null, null);
                        this.mVerificationCompleted = false;
                    }
                }
                if ((this.installFlags & 0x40000) != 0) {
                    int[] installedUsers;
                    final int enableRollbackToken = PackageManagerService.this.mPendingEnableRollbackToken++;
                    Trace.asyncTraceBegin(262144L, "enable_rollback", enableRollbackToken);
                    PackageManagerService.this.mPendingEnableRollback.append(enableRollbackToken, this);
                    ArrayMap<String, PackageParser.Package> verificationId = PackageManagerService.this.mPackages;
                    synchronized (verificationId) {
                        PackageSetting ps = PackageManagerService.this.mSettings.getPackageLPr(pkgLite.packageName);
                        installedUsers = ps != null ? ps.queryInstalledUsers(sUserManager.getUserIds(), true) : new int[]{};
                    }
                    Intent enableRollbackIntent = new Intent("android.intent.action.PACKAGE_ENABLE_ROLLBACK");
                    enableRollbackIntent.putExtra("android.content.pm.extra.ENABLE_ROLLBACK_TOKEN", enableRollbackToken);
                    enableRollbackIntent.putExtra("android.content.pm.extra.ENABLE_ROLLBACK_INSTALL_FLAGS", this.installFlags);
                    enableRollbackIntent.putExtra("android.content.pm.extra.ENABLE_ROLLBACK_INSTALLED_USERS", installedUsers);
                    enableRollbackIntent.putExtra("android.content.pm.extra.ENABLE_ROLLBACK_USER", this.getRollbackUser().getIdentifier());
                    enableRollbackIntent.setDataAndType(Uri.fromFile(new File(this.origin.resolvedPath)), PackageManagerService.PACKAGE_MIME_TYPE);
                    enableRollbackIntent.addFlags(1);
                    enableRollbackIntent.addFlags(0x4000000);
                    PackageManagerService.this.mContext.sendOrderedBroadcastAsUser(enableRollbackIntent, UserHandle.SYSTEM, "android.permission.PACKAGE_ROLLBACK_AGENT", new BroadcastReceiver(){

                        @Override
                        public void onReceive(Context context, Intent intent) {
                            long rollbackTimeout = DeviceConfig.getLong("rollback", PackageManagerService.PROPERTY_ENABLE_ROLLBACK_TIMEOUT_MILLIS, 10000L);
                            if (rollbackTimeout < 0L) {
                                rollbackTimeout = 10000L;
                            }
                            Message msg = PackageManagerService.this.mHandler.obtainMessage(22);
                            msg.arg1 = enableRollbackToken;
                            PackageManagerService.this.mHandler.sendMessageDelayed(msg, rollbackTimeout);
                        }
                    }, null, 0, null, null);
                    this.mEnableRollbackCompleted = false;
                }
            }
            this.mRet = ret;
        }

        void setReturnCode(int ret) {
            if (this.mRet == 1) {
                this.mRet = ret;
            }
        }

        void handleVerificationFinished() {
            this.mVerificationCompleted = true;
            this.handleReturnCode();
        }

        void handleRollbackEnabled() {
            this.mEnableRollbackCompleted = true;
            this.handleReturnCode();
        }

        @Override
        void handleReturnCode() {
            if (this.mVerificationCompleted && this.mEnableRollbackCompleted) {
                if ((this.installFlags & 0x800000) != 0) {
                    String packageName = "";
                    try {
                        new PackageParser();
                        PackageParser.PackageLite packageInfo = PackageParser.parsePackageLite(this.origin.file, 0);
                        packageName = packageInfo.packageName;
                    }
                    catch (PackageParser.PackageParserException e) {
                        Slog.e(PackageManagerService.TAG, "Can't parse package at " + this.origin.file.getAbsolutePath(), e);
                    }
                    try {
                        this.observer.onPackageInstalled(packageName, this.mRet, "Dry run", new Bundle());
                    }
                    catch (RemoteException e) {
                        Slog.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                    return;
                }
                if (this.mRet == 1) {
                    this.mRet = this.mArgs.copyApk();
                }
                PackageManagerService.this.processPendingInstall(this.mArgs, this.mRet);
            }
        }
    }

    class MultiPackageInstallParams
    extends HandlerParams {
        private int mRet;
        private final ArrayList<InstallParams> mChildParams;
        private final Map<InstallArgs, Integer> mCurrentState;

        MultiPackageInstallParams(UserHandle user, List<ActiveInstallSession> activeInstallSessions) throws PackageManagerException {
            super(user);
            this.mRet = 1;
            if (activeInstallSessions.size() == 0) {
                throw new PackageManagerException("No child sessions found!");
            }
            this.mChildParams = new ArrayList(activeInstallSessions.size());
            for (int i = 0; i < activeInstallSessions.size(); ++i) {
                InstallParams childParams = new InstallParams(activeInstallSessions.get(i));
                childParams.mParentInstallParams = this;
                this.mChildParams.add(childParams);
            }
            this.mCurrentState = new ArrayMap<InstallArgs, Integer>(this.mChildParams.size());
        }

        @Override
        void handleStartCopy() {
            for (InstallParams params : this.mChildParams) {
                params.handleStartCopy();
                if (params.mRet == 1) continue;
                this.mRet = params.mRet;
            }
        }

        @Override
        void handleReturnCode() {
            for (InstallParams params : this.mChildParams) {
                params.handleReturnCode();
                if (params.mRet == 1) continue;
                this.mRet = params.mRet;
            }
        }

        void tryProcessInstallRequest(InstallArgs args, int currentStatus) {
            this.mCurrentState.put(args, currentStatus);
            if (this.mCurrentState.size() != this.mChildParams.size()) {
                return;
            }
            int completeStatus = 1;
            for (Integer status : this.mCurrentState.values()) {
                if (status == 0) {
                    return;
                }
                if (status == 1) continue;
                completeStatus = status;
                break;
            }
            ArrayList<InstallRequest> installRequests = new ArrayList<InstallRequest>(this.mCurrentState.size());
            for (Map.Entry<InstallArgs, Integer> entry : this.mCurrentState.entrySet()) {
                installRequests.add(new InstallRequest(entry.getKey(), PackageManagerService.this.createPackageInstalledInfo(completeStatus)));
            }
            PackageManagerService.this.processInstallRequestsAsync(completeStatus == 1, installRequests);
        }
    }

    static class VerificationInfo {
        public static final int NO_UID = -1;
        final Uri originatingUri;
        final Uri referrer;
        final int originatingUid;
        final int installerUid;

        VerificationInfo(Uri originatingUri, Uri referrer, int originatingUid, int installerUid) {
            this.originatingUri = originatingUri;
            this.referrer = referrer;
            this.originatingUid = originatingUid;
            this.installerUid = installerUid;
        }
    }

    static class MoveInfo {
        final int moveId;
        final String fromUuid;
        final String toUuid;
        final String packageName;
        final String dataAppName;
        final int appId;
        final String seinfo;
        final int targetSdkVersion;

        public MoveInfo(int moveId, String fromUuid, String toUuid, String packageName, String dataAppName, int appId, String seinfo, int targetSdkVersion) {
            this.moveId = moveId;
            this.fromUuid = fromUuid;
            this.toUuid = toUuid;
            this.packageName = packageName;
            this.dataAppName = dataAppName;
            this.appId = appId;
            this.seinfo = seinfo;
            this.targetSdkVersion = targetSdkVersion;
        }
    }

    static class OriginInfo {
        final File file;
        final boolean staged;
        final boolean existing;
        final String resolvedPath;
        final File resolvedFile;

        static OriginInfo fromNothing() {
            return new OriginInfo(null, false, false);
        }

        static OriginInfo fromUntrustedFile(File file) {
            return new OriginInfo(file, false, false);
        }

        static OriginInfo fromExistingFile(File file) {
            return new OriginInfo(file, false, true);
        }

        static OriginInfo fromStagedFile(File file) {
            return new OriginInfo(file, true, false);
        }

        private OriginInfo(File file, boolean staged, boolean existing) {
            this.file = file;
            this.staged = staged;
            this.existing = existing;
            if (file != null) {
                this.resolvedPath = file.getAbsolutePath();
                this.resolvedFile = file;
            } else {
                this.resolvedPath = null;
                this.resolvedFile = null;
            }
        }
    }

    private abstract class HandlerParams {
        private final UserHandle mUser;
        String traceMethod;
        int traceCookie;

        HandlerParams(UserHandle user) {
            this.mUser = user;
        }

        UserHandle getUser() {
            return this.mUser;
        }

        UserHandle getRollbackUser() {
            if (this.mUser == UserHandle.ALL) {
                return UserHandle.SYSTEM;
            }
            return this.mUser;
        }

        HandlerParams setTraceMethod(String traceMethod) {
            this.traceMethod = traceMethod;
            return this;
        }

        HandlerParams setTraceCookie(int traceCookie) {
            this.traceCookie = traceCookie;
            return this;
        }

        final void startCopy() {
            this.handleStartCopy();
            this.handleReturnCode();
        }

        abstract void handleStartCopy();

        abstract void handleReturnCode();
    }

    private static class ScanRequest {
        public final PackageParser.Package pkg;
        public final PackageParser.Package oldPkg;
        public final SharedUserSetting sharedUserSetting;
        public final PackageSetting pkgSetting;
        public final PackageSetting oldPkgSetting;
        public final PackageSetting disabledPkgSetting;
        public final PackageSetting originalPkgSetting;
        public final String realPkgName;
        public final int parseFlags;
        public final int scanFlags;
        public final UserHandle user;
        public final boolean isPlatformPackage;

        public ScanRequest(PackageParser.Package pkg, SharedUserSetting sharedUserSetting, PackageParser.Package oldPkg, PackageSetting pkgSetting, PackageSetting disabledPkgSetting, PackageSetting originalPkgSetting, String realPkgName, int parseFlags, int scanFlags, boolean isPlatformPackage, UserHandle user) {
            this.pkg = pkg;
            this.oldPkg = oldPkg;
            this.pkgSetting = pkgSetting;
            this.sharedUserSetting = sharedUserSetting;
            this.oldPkgSetting = pkgSetting == null ? null : new PackageSetting(pkgSetting);
            this.disabledPkgSetting = disabledPkgSetting;
            this.originalPkgSetting = originalPkgSetting;
            this.realPkgName = realPkgName;
            this.parseFlags = parseFlags;
            this.scanFlags = scanFlags;
            this.isPlatformPackage = isPlatformPackage;
            this.user = user;
        }
    }

    private static class ScanResult {
        public final ScanRequest request;
        public final boolean success;
        public final boolean existingSettingCopied;
        public final PackageSetting pkgSetting;
        public final List<String> changedAbiCodePath;
        public final SharedLibraryInfo staticSharedLibraryInfo;
        public final List<SharedLibraryInfo> dynamicSharedLibraryInfos;

        public ScanResult(ScanRequest request, boolean success, PackageSetting pkgSetting, List<String> changedAbiCodePath, boolean existingSettingCopied, SharedLibraryInfo staticSharedLibraryInfo, List<SharedLibraryInfo> dynamicSharedLibraryInfos) {
            this.request = request;
            this.success = success;
            this.pkgSetting = pkgSetting;
            this.changedAbiCodePath = changedAbiCodePath;
            this.existingSettingCopied = existingSettingCopied;
            this.staticSharedLibraryInfo = staticSharedLibraryInfo;
            this.dynamicSharedLibraryInfos = dynamicSharedLibraryInfos;
        }
    }

    private static class CrossProfileDomainInfo {
        ResolveInfo resolveInfo;
        int bestDomainVerificationStatus;

        private CrossProfileDomainInfo() {
        }
    }

    class PackageHandler
    extends Handler {
        PackageHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            try {
                this.doHandleMessage(msg);
            }
            finally {
                Process.setThreadPriority(10);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doHandleMessage(Message msg) {
            switch (msg.what) {
                case 5: {
                    HandlerParams params = (HandlerParams)msg.obj;
                    if (params == null) break;
                    Trace.asyncTraceEnd(262144L, "queueInstall", System.identityHashCode(params));
                    Trace.traceBegin(262144L, "startCopy");
                    params.startCopy();
                    Trace.traceEnd(262144L);
                    break;
                }
                case 1: {
                    int[] uids;
                    ArrayList[] components;
                    String[] packages;
                    int size = 0;
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        size = PackageManagerService.this.mPendingBroadcasts.size();
                        if (size <= 0) {
                            return;
                        }
                        packages = new String[size];
                        components = new ArrayList[size];
                        uids = new int[size];
                        int i = 0;
                        for (int n = 0; n < PackageManagerService.this.mPendingBroadcasts.userIdCount(); ++n) {
                            int packageUserId = PackageManagerService.this.mPendingBroadcasts.userIdAt(n);
                            Iterator<Map.Entry<String, ArrayList<String>>> it = PackageManagerService.this.mPendingBroadcasts.packagesForUserId(packageUserId).entrySet().iterator();
                            while (it.hasNext() && i < size) {
                                Map.Entry<String, ArrayList<String>> ent = it.next();
                                packages[i] = ent.getKey();
                                components[i] = ent.getValue();
                                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(ent.getKey());
                                uids[i] = ps != null ? UserHandle.getUid(packageUserId, ps.appId) : -1;
                                ++i;
                            }
                        }
                        size = i;
                        PackageManagerService.this.mPendingBroadcasts.clear();
                    }
                    for (int i = 0; i < size; ++i) {
                        PackageManagerService.this.sendPackageChangedBroadcast(packages[i], true, components[i], uids[i]);
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 9: {
                    PostInstallData data = PackageManagerService.this.mRunningInstalls.get(msg.arg1);
                    boolean didRestore = msg.arg2 != 0;
                    PackageManagerService.this.mRunningInstalls.delete(msg.arg1);
                    if (data != null && data.mPostInstallRunnable != null) {
                        data.mPostInstallRunnable.run();
                    } else if (data != null) {
                        InstallArgs args = data.args;
                        PackageInstalledInfo parentRes = data.res;
                        boolean grantPermissions = (args.installFlags & 0x100) != 0;
                        boolean killApp = (args.installFlags & 0x1000) == 0;
                        boolean virtualPreload = (args.installFlags & 0x10000) != 0;
                        String[] grantedPermissions = args.installGrantPermissions;
                        List<String> whitelistedRestrictedPermissions = (args.installFlags & 0x400000) != 0 && parentRes.pkg != null ? parentRes.pkg.requestedPermissions : args.whitelistedRestrictedPermissions;
                        PackageManagerService.this.handlePackagePostInstall(parentRes, grantPermissions, killApp, virtualPreload, grantedPermissions, whitelistedRestrictedPermissions, didRestore, args.installerPackageName, args.observer);
                        int childCount = parentRes.addedChildPackages != null ? parentRes.addedChildPackages.size() : 0;
                        for (int i = 0; i < childCount; ++i) {
                            PackageInstalledInfo childRes = parentRes.addedChildPackages.valueAt(i);
                            PackageManagerService.this.handlePackagePostInstall(childRes, grantPermissions, killApp, virtualPreload, grantedPermissions, whitelistedRestrictedPermissions, false, args.installerPackageName, args.observer);
                        }
                        if (args.traceMethod != null) {
                            Trace.asyncTraceEnd(262144L, args.traceMethod, args.traceCookie);
                        }
                    }
                    Trace.asyncTraceEnd(262144L, "postInstall", msg.arg1);
                    break;
                }
                case 23: {
                    Object data = PackageManagerService.this.mInstallLock;
                    synchronized (data) {
                        InstallArgs args = (InstallArgs)msg.obj;
                        if (args != null) {
                            args.doPostDeleteLI(true);
                        }
                        break;
                    }
                }
                case 24: {
                    String packageName = (String)msg.obj;
                    if (packageName == null) break;
                    PackageManagerService.this.notifyInstallObserver(packageName);
                    break;
                }
                case 13: {
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> packageName = PackageManagerService.this.mPackages;
                    synchronized (packageName) {
                        this.removeMessages(13);
                        this.removeMessages(14);
                        PackageManagerService.this.mSettings.writeLPr();
                        PackageManagerService.this.mDirtyUsers.clear();
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 14: {
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> packageName = PackageManagerService.this.mPackages;
                    synchronized (packageName) {
                        this.removeMessages(14);
                        Iterator args = PackageManagerService.this.mDirtyUsers.iterator();
                        while (args.hasNext()) {
                            int userId = (Integer)args.next();
                            PackageManagerService.this.mSettings.writePackageRestrictionsLPr(userId);
                        }
                        PackageManagerService.this.mDirtyUsers.clear();
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 19: {
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> packageName = PackageManagerService.this.mPackages;
                    synchronized (packageName) {
                        this.removeMessages(19);
                        PackageManagerService.this.mSettings.writePackageListLPr(msg.arg1);
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 16: {
                    int verificationId = msg.arg1;
                    PackageVerificationState state = PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null || state.timeoutExtended()) break;
                    InstallParams params = state.getInstallParams();
                    InstallArgs args = params.mArgs;
                    Uri originUri = Uri.fromFile(args.origin.resolvedFile);
                    Slog.i(PackageManagerService.TAG, "Verification timed out for " + originUri);
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    UserHandle user = args.getUser();
                    if (PackageManagerService.this.getDefaultVerificationResponse(user) == 1) {
                        Slog.i(PackageManagerService.TAG, "Continuing with installation of " + originUri);
                        state.setVerifierResponse(Binder.getCallingUid(), 2);
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, 1, user);
                    } else {
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, -1, user);
                        params.setReturnCode(-22);
                    }
                    Trace.asyncTraceEnd(262144L, "verification", verificationId);
                    params.handleVerificationFinished();
                    break;
                }
                case 15: {
                    int verificationId = msg.arg1;
                    PackageVerificationState state = PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null) {
                        Slog.w(PackageManagerService.TAG, "Invalid verification token " + verificationId + " received");
                        break;
                    }
                    PackageVerificationResponse response = (PackageVerificationResponse)msg.obj;
                    state.setVerifierResponse(response.callerUid, response.code);
                    if (!state.isVerificationComplete()) break;
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    InstallParams params = state.getInstallParams();
                    InstallArgs args = params.mArgs;
                    Uri originUri = Uri.fromFile(args.origin.resolvedFile);
                    if (state.isInstallAllowed()) {
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, response.code, args.getUser());
                    } else {
                        params.setReturnCode(-22);
                    }
                    Trace.asyncTraceEnd(262144L, "verification", verificationId);
                    params.handleVerificationFinished();
                    break;
                }
                case 17: {
                    IFVerificationParams params = (IFVerificationParams)msg.obj;
                    PackageManagerService.this.verifyIntentFiltersIfNeeded(params.userId, params.verifierUid, params.replacing, params.pkg);
                    break;
                }
                case 18: {
                    int verificationId = msg.arg1;
                    IntentFilterVerificationState state = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
                    if (state == null) {
                        Slog.w(PackageManagerService.TAG, "Invalid IntentFilter verification token " + verificationId + " received");
                        break;
                    }
                    int userId = state.getUserId();
                    IntentFilterVerificationResponse response = (IntentFilterVerificationResponse)msg.obj;
                    state.setVerifierResponse(response.callerUid, response.code);
                    if (response.code == -1) {
                        // empty if block
                    }
                    if (!state.isVerificationComplete()) break;
                    PackageManagerService.this.mIntentFilterVerifier.receiveVerificationResponse(verificationId);
                    break;
                }
                case 20: {
                    InstantAppResolver.doInstantAppResolutionPhaseTwo(PackageManagerService.this.mContext, PackageManagerService.this.mInstantAppResolverConnection, (InstantAppRequest)msg.obj, PackageManagerService.this.mInstantAppInstallerActivity, PackageManagerService.this.mHandler);
                    break;
                }
                case 21: {
                    int enableRollbackToken = msg.arg1;
                    int enableRollbackCode = msg.arg2;
                    InstallParams params = PackageManagerService.this.mPendingEnableRollback.get(enableRollbackToken);
                    if (params == null) {
                        Slog.w(PackageManagerService.TAG, "Invalid rollback enabled token " + enableRollbackToken + " received");
                        break;
                    }
                    PackageManagerService.this.mPendingEnableRollback.remove(enableRollbackToken);
                    if (enableRollbackCode != 1) {
                        InstallArgs args = params.mArgs;
                        Uri originUri = Uri.fromFile(args.origin.resolvedFile);
                        Slog.w(PackageManagerService.TAG, "Failed to enable rollback for " + originUri);
                        Slog.w(PackageManagerService.TAG, "Continuing with installation of " + originUri);
                    }
                    Trace.asyncTraceEnd(262144L, "enable_rollback", enableRollbackToken);
                    params.handleRollbackEnabled();
                    break;
                }
                case 22: {
                    int enableRollbackToken = msg.arg1;
                    InstallParams params = PackageManagerService.this.mPendingEnableRollback.get(enableRollbackToken);
                    if (params == null) break;
                    InstallArgs args = params.mArgs;
                    Uri originUri = Uri.fromFile(args.origin.resolvedFile);
                    Slog.w(PackageManagerService.TAG, "Enable rollback timed out for " + originUri);
                    PackageManagerService.this.mPendingEnableRollback.remove(enableRollbackToken);
                    Slog.w(PackageManagerService.TAG, "Continuing with installation of " + originUri);
                    Trace.asyncTraceEnd(262144L, "enable_rollback", enableRollbackToken);
                    params.handleRollbackEnabled();
                    Intent rollbackTimeoutIntent = new Intent("android.intent.action.CANCEL_ENABLE_ROLLBACK");
                    rollbackTimeoutIntent.putExtra("android.content.pm.extra.ENABLE_ROLLBACK_TOKEN", enableRollbackToken);
                    rollbackTimeoutIntent.addFlags(0x4000000);
                    PackageManagerService.this.mContext.sendBroadcastAsUser(rollbackTimeoutIntent, UserHandle.SYSTEM, "android.permission.PACKAGE_ROLLBACK_AGENT");
                    break;
                }
            }
        }
    }

    static class PostInstallData {
        public final InstallArgs args;
        public final PackageInstalledInfo res;
        public final Runnable mPostInstallRunnable;

        PostInstallData(InstallArgs _a, PackageInstalledInfo _r, Runnable postInstallRunnable) {
            this.args = _a;
            this.res = _r;
            this.mPostInstallRunnable = postInstallRunnable;
        }
    }

    static class PendingPackageBroadcasts {
        final SparseArray<ArrayMap<String, ArrayList<String>>> mUidMap = new SparseArray(2);

        public ArrayList<String> get(int userId, String packageName) {
            ArrayMap<String, ArrayList<String>> packages = this.getOrAllocate(userId);
            return packages.get(packageName);
        }

        public void put(int userId, String packageName, ArrayList<String> components) {
            ArrayMap<String, ArrayList<String>> packages = this.getOrAllocate(userId);
            packages.put(packageName, components);
        }

        public void remove(int userId, String packageName) {
            ArrayMap<String, ArrayList<String>> packages = this.mUidMap.get(userId);
            if (packages != null) {
                packages.remove(packageName);
            }
        }

        public void remove(int userId) {
            this.mUidMap.remove(userId);
        }

        public int userIdCount() {
            return this.mUidMap.size();
        }

        public int userIdAt(int n) {
            return this.mUidMap.keyAt(n);
        }

        public ArrayMap<String, ArrayList<String>> packagesForUserId(int userId) {
            return this.mUidMap.get(userId);
        }

        public int size() {
            int num = 0;
            for (int i = 0; i < this.mUidMap.size(); ++i) {
                num += this.mUidMap.valueAt(i).size();
            }
            return num;
        }

        public void clear() {
            this.mUidMap.clear();
        }

        private ArrayMap<String, ArrayList<String>> getOrAllocate(int userId) {
            ArrayMap<String, ArrayList<String>> map = this.mUidMap.get(userId);
            if (map == null) {
                map = new ArrayMap();
                this.mUidMap.put(userId, map);
            }
            return map;
        }
    }

    private class IntentVerifierProxy
    implements IntentFilterVerifier<PackageParser.ActivityIntentInfo> {
        private Context mContext;
        private ComponentName mIntentFilterVerifierComponent;
        private ArrayList<Integer> mCurrentIntentFilterVerifications = new ArrayList();

        public IntentVerifierProxy(Context context, ComponentName verifierComponent) {
            this.mContext = context;
            this.mIntentFilterVerifierComponent = verifierComponent;
        }

        private String getDefaultScheme() {
            return "https";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startVerifications(int userId) {
            int count = this.mCurrentIntentFilterVerifications.size();
            for (int n = 0; n < count; ++n) {
                int verificationId = this.mCurrentIntentFilterVerifications.get(n);
                IntentFilterVerificationState ivs = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
                String packageName = ivs.getPackageName();
                ArrayList<PackageParser.ActivityIntentInfo> filters = ivs.getFilters();
                int filterCount = filters.size();
                ArraySet<String> domainsSet = new ArraySet<String>();
                for (int m = 0; m < filterCount; ++m) {
                    PackageParser.ActivityIntentInfo filter = filters.get(m);
                    domainsSet.addAll(filter.getHostsList());
                }
                ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                synchronized (arrayMap) {
                    if (PackageManagerService.this.mSettings.createIntentFilterVerificationIfNeededLPw(packageName, domainsSet) != null) {
                        PackageManagerService.this.scheduleWriteSettingsLocked();
                    }
                }
                this.sendVerificationRequest(verificationId, ivs);
            }
            this.mCurrentIntentFilterVerifications.clear();
        }

        private void sendVerificationRequest(int verificationId, IntentFilterVerificationState ivs) {
            Intent verificationIntent = new Intent("android.intent.action.INTENT_FILTER_NEEDS_VERIFICATION");
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_ID", verificationId);
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_URI_SCHEME", this.getDefaultScheme());
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_HOSTS", ivs.getHostsString());
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_PACKAGE_NAME", ivs.getPackageName());
            verificationIntent.setComponent(this.mIntentFilterVerifierComponent);
            verificationIntent.addFlags(0x10000000);
            long whitelistTimeout = PackageManagerService.this.getVerificationTimeout();
            BroadcastOptions options = BroadcastOptions.makeBasic();
            options.setTemporaryAppWhitelistDuration(whitelistTimeout);
            DeviceIdleController.LocalService idleController = PackageManagerService.this.getDeviceIdleController();
            idleController.addPowerSaveTempWhitelistApp(Process.myUid(), this.mIntentFilterVerifierComponent.getPackageName(), whitelistTimeout, 0, true, "intent filter verifier");
            this.mContext.sendBroadcastAsUser(verificationIntent, UserHandle.SYSTEM, null, options.toBundle());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveVerificationResponse(int verificationId) {
            IntentFilterVerificationInfo ivi;
            IntentFilterVerificationState ivs = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
            boolean verified = ivs.isVerified();
            ArrayList<PackageParser.ActivityIntentInfo> filters = ivs.getFilters();
            int count = filters.size();
            for (int n = 0; n < count; ++n) {
                PackageParser.ActivityIntentInfo filter = filters.get(n);
                filter.setVerified(verified);
            }
            PackageManagerService.this.mIntentFilterVerificationStates.remove(verificationId);
            String packageName = ivs.getPackageName();
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                ivi = PackageManagerService.this.mSettings.getIntentFilterVerificationLPr(packageName);
            }
            if (ivi == null) {
                Slog.w(PackageManagerService.TAG, "IntentFilterVerificationInfo not found for verificationId:" + verificationId + " packageName:" + packageName);
                return;
            }
            arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                if (verified) {
                    ivi.setStatus(2);
                } else {
                    ivi.setStatus(1);
                }
                PackageManagerService.this.scheduleWriteSettingsLocked();
                int userId = ivs.getUserId();
                if (userId != -1) {
                    int userStatus = PackageManagerService.this.mSettings.getIntentFilterVerificationStatusLPr(packageName, userId);
                    int updatedStatus = 0;
                    boolean needUpdate = false;
                    switch (userStatus) {
                        case 2: {
                            SystemConfig systemConfig;
                            ArraySet<String> packages;
                            if (verified || (packages = (systemConfig = SystemConfig.getInstance()).getLinkedApps()).contains(packageName)) break;
                            needUpdate = true;
                            break;
                        }
                        case 0: {
                            if (verified) {
                                updatedStatus = 2;
                            }
                            needUpdate = true;
                            break;
                        }
                        case 1: {
                            if (!verified) break;
                            updatedStatus = 2;
                            needUpdate = true;
                            break;
                        }
                    }
                    if (needUpdate) {
                        PackageManagerService.this.mSettings.updateIntentFilterVerificationStatusLPw(packageName, updatedStatus, userId);
                        PackageManagerService.this.scheduleWritePackageRestrictionsLocked(userId);
                    }
                } else {
                    Slog.i(PackageManagerService.TAG, "autoVerify ignored when installing for all users");
                }
            }
        }

        @Override
        public boolean addOneIntentFilterVerification(int verifierUid, int userId, int verificationId, PackageParser.ActivityIntentInfo filter, String packageName) {
            if (!PackageManagerService.hasValidDomains(filter)) {
                return false;
            }
            IntentFilterVerificationState ivs = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
            if (ivs == null) {
                ivs = this.createDomainVerificationState(verifierUid, userId, verificationId, packageName);
            }
            ivs.addFilter(filter);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IntentFilterVerificationState createDomainVerificationState(int verifierUid, int userId, int verificationId, String packageName) {
            IntentFilterVerificationState ivs = new IntentFilterVerificationState(verifierUid, userId, packageName);
            ivs.setPendingState();
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mIntentFilterVerificationStates.append(verificationId, ivs);
                this.mCurrentIntentFilterVerifications.add(verificationId);
            }
            return ivs;
        }
    }

    private static interface IntentFilterVerifier<T extends IntentFilter> {
        public boolean addOneIntentFilterVerification(int var1, int var2, int var3, T var4, String var5);

        public void startVerifications(int var1);

        public void receiveVerificationResponse(int var1);
    }

    private static class IFVerificationParams {
        PackageParser.Package pkg;
        boolean replacing;
        int userId;
        int verifierUid;

        public IFVerificationParams(PackageParser.Package _pkg, boolean _replacing, int _userId, int _verifierUid) {
            this.pkg = _pkg;
            this.replacing = _replacing;
            this.userId = _userId;
            this.verifierUid = _verifierUid;
        }
    }

    class ParallelPackageParserCallback
    extends PackageParserCallback {
        List<PackageParser.Package> mOverlayPackages;

        ParallelPackageParserCallback() {
            this.mOverlayPackages = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void findStaticOverlayPackages() {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                for (PackageParser.Package p : PackageManagerService.this.mPackages.values()) {
                    if (!p.mOverlayIsStatic) continue;
                    if (this.mOverlayPackages == null) {
                        this.mOverlayPackages = new ArrayList<PackageParser.Package>();
                    }
                    this.mOverlayPackages.add(p);
                }
            }
        }

        @Override
        synchronized String[] getStaticOverlayPaths(String targetPackageName, String targetPath) {
            return this.mOverlayPackages == null ? null : this.getStaticOverlayPaths(this.getStaticOverlayPackages(this.mOverlayPackages, targetPackageName), targetPath);
        }
    }

    class PackageParserCallback
    implements PackageParser.Callback {
        PackageParserCallback() {
        }

        @Override
        public final boolean hasFeature(String feature) {
            return PackageManagerService.this.hasSystemFeature(feature, 0);
        }

        final List<PackageParser.Package> getStaticOverlayPackages(Collection<PackageParser.Package> allPackages, String targetPackageName) {
            if (PackageManagerService.PLATFORM_PACKAGE_NAME.equals(targetPackageName)) {
                return null;
            }
            ArrayList<PackageParser.Package> overlayPackages = null;
            for (PackageParser.Package p2 : allPackages) {
                if (!targetPackageName.equals(p2.mOverlayTarget) || !p2.mOverlayIsStatic) continue;
                if (overlayPackages == null) {
                    overlayPackages = new ArrayList<PackageParser.Package>();
                }
                overlayPackages.add(p2);
            }
            if (overlayPackages != null) {
                Comparator<PackageParser.Package> cmp = Comparator.comparingInt(p -> p.mOverlayPriority);
                overlayPackages.sort(cmp);
            }
            return overlayPackages;
        }

        final String[] getStaticOverlayPaths(List<PackageParser.Package> overlayPackages, String targetPath) {
            if (overlayPackages == null || overlayPackages.isEmpty()) {
                return null;
            }
            ArrayList<String> overlayPathList = null;
            for (PackageParser.Package overlayPackage : overlayPackages) {
                if (targetPath == null) {
                    if (overlayPathList == null) {
                        overlayPathList = new ArrayList<String>();
                    }
                    overlayPathList.add(overlayPackage.baseCodePath);
                    continue;
                }
                try {
                    PackageManagerService.this.mInstaller.idmap(targetPath, overlayPackage.baseCodePath, UserHandle.getSharedAppGid(UserHandle.getUserGid(0)));
                    if (overlayPathList == null) {
                        overlayPathList = new ArrayList();
                    }
                    overlayPathList.add(overlayPackage.baseCodePath);
                }
                catch (Installer.InstallerException e) {
                    Slog.e(PackageManagerService.TAG, "Failed to generate idmap for " + targetPath + " and " + overlayPackage.baseCodePath);
                }
            }
            return overlayPathList == null ? null : overlayPathList.toArray(new String[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[] getStaticOverlayPaths(String targetPackageName, String targetPath) {
            Object object = PackageManagerService.this.mInstallLock;
            synchronized (object) {
                List<PackageParser.Package> overlayPackages;
                ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                synchronized (arrayMap) {
                    overlayPackages = this.getStaticOverlayPackages(PackageManagerService.this.mPackages.values(), targetPackageName);
                }
                return this.getStaticOverlayPaths(overlayPackages, targetPath);
            }
        }

        @Override
        public final String[] getOverlayApks(String targetPackageName) {
            return this.getStaticOverlayPaths(targetPackageName, null);
        }

        @Override
        public final String[] getOverlayPaths(String targetPackageName, String targetPath) {
            return this.getStaticOverlayPaths(targetPackageName, targetPath);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ComponentType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanFlags {
    }
}

