/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.PackageParser;
import android.content.pm.PackageUserState;
import android.content.pm.Signature;
import android.content.pm.SuspendDialogInfo;
import android.os.PersistableBundle;
import android.util.ArraySet;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.pm.PackageKeySetData;
import com.android.server.pm.PackageSignatures;
import com.android.server.pm.SettingBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class PackageSettingBase
extends SettingBase {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    public final String name;
    final String realName;
    String parentPackageName;
    List<String> childPackageNames;
    File codePath;
    String codePathString;
    File resourcePath;
    String resourcePathString;
    String[] usesStaticLibraries;
    long[] usesStaticLibrariesVersions;
    @Deprecated
    String legacyNativeLibraryPathString;
    String primaryCpuAbiString;
    String secondaryCpuAbiString;
    String cpuAbiOverrideString;
    long timeStamp;
    long firstInstallTime;
    long lastUpdateTime;
    long versionCode;
    boolean uidError;
    PackageSignatures signatures;
    boolean installPermissionsFixed;
    PackageKeySetData keySetData = new PackageKeySetData();
    static final PackageUserState DEFAULT_USER_STATE = new PackageUserState();
    private final SparseArray<PackageUserState> mUserState = new SparseArray();
    Set<String> mOldCodePaths;
    String installerPackageName;
    boolean isOrphaned;
    String volumeUuid;
    int categoryHint = -1;
    boolean updateAvailable;
    IntentFilterVerificationInfo verificationInfo;

    PackageSettingBase(String name, String realName, File codePath, File resourcePath, String legacyNativeLibraryPathString, String primaryCpuAbiString, String secondaryCpuAbiString, String cpuAbiOverrideString, long pVersionCode, int pkgFlags, int pkgPrivateFlags, String parentPackageName, List<String> childPackageNames, String[] usesStaticLibraries, long[] usesStaticLibrariesVersions) {
        super(pkgFlags, pkgPrivateFlags);
        this.name = name;
        this.realName = realName;
        this.parentPackageName = parentPackageName;
        this.childPackageNames = childPackageNames != null ? new ArrayList<String>(childPackageNames) : null;
        this.usesStaticLibraries = usesStaticLibraries;
        this.usesStaticLibrariesVersions = usesStaticLibrariesVersions;
        this.init(codePath, resourcePath, legacyNativeLibraryPathString, primaryCpuAbiString, secondaryCpuAbiString, cpuAbiOverrideString, pVersionCode);
    }

    PackageSettingBase(PackageSettingBase base, String realName) {
        super(base);
        this.name = base.name;
        this.realName = realName;
        this.doCopy(base);
    }

    void init(File codePath, File resourcePath, String legacyNativeLibraryPathString, String primaryCpuAbiString, String secondaryCpuAbiString, String cpuAbiOverrideString, long pVersionCode) {
        this.codePath = codePath;
        this.codePathString = codePath.toString();
        this.resourcePath = resourcePath;
        this.resourcePathString = resourcePath.toString();
        this.legacyNativeLibraryPathString = legacyNativeLibraryPathString;
        this.primaryCpuAbiString = primaryCpuAbiString;
        this.secondaryCpuAbiString = secondaryCpuAbiString;
        this.cpuAbiOverrideString = cpuAbiOverrideString;
        this.versionCode = pVersionCode;
        this.signatures = new PackageSignatures();
    }

    public void setInstallerPackageName(String packageName) {
        this.installerPackageName = packageName;
    }

    public String getInstallerPackageName() {
        return this.installerPackageName;
    }

    public void setVolumeUuid(String volumeUuid) {
        this.volumeUuid = volumeUuid;
    }

    public String getVolumeUuid() {
        return this.volumeUuid;
    }

    public void setTimeStamp(long newStamp) {
        this.timeStamp = newStamp;
    }

    public void setUpdateAvailable(boolean updateAvailable) {
        this.updateAvailable = updateAvailable;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public boolean isSharedUser() {
        return false;
    }

    public Signature[] getSignatures() {
        return this.signatures.mSigningDetails.signatures;
    }

    public PackageParser.SigningDetails getSigningDetails() {
        return this.signatures.mSigningDetails;
    }

    public void copyFrom(PackageSettingBase orig) {
        super.copyFrom(orig);
        this.doCopy(orig);
    }

    private void doCopy(PackageSettingBase orig) {
        this.childPackageNames = orig.childPackageNames != null ? new ArrayList<String>(orig.childPackageNames) : null;
        this.codePath = orig.codePath;
        this.codePathString = orig.codePathString;
        this.cpuAbiOverrideString = orig.cpuAbiOverrideString;
        this.firstInstallTime = orig.firstInstallTime;
        this.installPermissionsFixed = orig.installPermissionsFixed;
        this.installerPackageName = orig.installerPackageName;
        this.isOrphaned = orig.isOrphaned;
        this.keySetData = orig.keySetData;
        this.lastUpdateTime = orig.lastUpdateTime;
        this.legacyNativeLibraryPathString = orig.legacyNativeLibraryPathString;
        this.parentPackageName = orig.parentPackageName;
        this.primaryCpuAbiString = orig.primaryCpuAbiString;
        this.resourcePath = orig.resourcePath;
        this.resourcePathString = orig.resourcePathString;
        this.secondaryCpuAbiString = orig.secondaryCpuAbiString;
        this.signatures = orig.signatures;
        this.timeStamp = orig.timeStamp;
        this.uidError = orig.uidError;
        this.mUserState.clear();
        for (int i = 0; i < orig.mUserState.size(); ++i) {
            this.mUserState.put(orig.mUserState.keyAt(i), orig.mUserState.valueAt(i));
        }
        this.verificationInfo = orig.verificationInfo;
        this.versionCode = orig.versionCode;
        this.volumeUuid = orig.volumeUuid;
        this.categoryHint = orig.categoryHint;
        this.usesStaticLibraries = orig.usesStaticLibraries != null ? Arrays.copyOf(orig.usesStaticLibraries, orig.usesStaticLibraries.length) : null;
        this.usesStaticLibrariesVersions = orig.usesStaticLibrariesVersions != null ? Arrays.copyOf(orig.usesStaticLibrariesVersions, orig.usesStaticLibrariesVersions.length) : null;
        this.updateAvailable = orig.updateAvailable;
    }

    private PackageUserState modifyUserState(int userId) {
        PackageUserState state = this.mUserState.get(userId);
        if (state == null) {
            state = new PackageUserState();
            this.mUserState.put(userId, state);
        }
        return state;
    }

    public PackageUserState readUserState(int userId) {
        PackageUserState state = this.mUserState.get(userId);
        if (state == null) {
            return DEFAULT_USER_STATE;
        }
        state.categoryHint = this.categoryHint;
        return state;
    }

    void setEnabled(int state, int userId, String callingPackage) {
        PackageUserState st = this.modifyUserState(userId);
        st.enabled = state;
        st.lastDisableAppCaller = callingPackage;
    }

    int getEnabled(int userId) {
        return this.readUserState((int)userId).enabled;
    }

    String getLastDisabledAppCaller(int userId) {
        return this.readUserState((int)userId).lastDisableAppCaller;
    }

    void setInstalled(boolean inst, int userId) {
        this.modifyUserState((int)userId).installed = inst;
    }

    boolean getInstalled(int userId) {
        return this.readUserState((int)userId).installed;
    }

    int getInstallReason(int userId) {
        return this.readUserState((int)userId).installReason;
    }

    void setInstallReason(int installReason, int userId) {
        this.modifyUserState((int)userId).installReason = installReason;
    }

    void setOverlayPaths(List<String> overlayPaths, int userId) {
        this.modifyUserState((int)userId).overlayPaths = overlayPaths == null ? null : overlayPaths.toArray(new String[overlayPaths.size()]);
    }

    String[] getOverlayPaths(int userId) {
        return this.readUserState((int)userId).overlayPaths;
    }

    @VisibleForTesting
    SparseArray<PackageUserState> getUserState() {
        return this.mUserState;
    }

    boolean isAnyInstalled(int[] users) {
        for (int user : users) {
            if (!this.readUserState((int)user).installed) continue;
            return true;
        }
        return false;
    }

    int[] queryInstalledUsers(int[] users, boolean installed) {
        int num = 0;
        for (int user : users) {
            if (this.getInstalled(user) != installed) continue;
            ++num;
        }
        int[] res = new int[num];
        num = 0;
        for (int user : users) {
            if (this.getInstalled(user) != installed) continue;
            res[num] = user;
            ++num;
        }
        return res;
    }

    long getCeDataInode(int userId) {
        return this.readUserState((int)userId).ceDataInode;
    }

    void setCeDataInode(long ceDataInode, int userId) {
        this.modifyUserState((int)userId).ceDataInode = ceDataInode;
    }

    boolean getStopped(int userId) {
        return this.readUserState((int)userId).stopped;
    }

    void setStopped(boolean stop, int userId) {
        this.modifyUserState((int)userId).stopped = stop;
    }

    boolean getNotLaunched(int userId) {
        return this.readUserState((int)userId).notLaunched;
    }

    void setNotLaunched(boolean stop, int userId) {
        this.modifyUserState((int)userId).notLaunched = stop;
    }

    boolean getHidden(int userId) {
        return this.readUserState((int)userId).hidden;
    }

    void setHidden(boolean hidden, int userId) {
        this.modifyUserState((int)userId).hidden = hidden;
    }

    int getDistractionFlags(int userId) {
        return this.readUserState((int)userId).distractionFlags;
    }

    void setDistractionFlags(int distractionFlags, int userId) {
        this.modifyUserState((int)userId).distractionFlags = distractionFlags;
    }

    boolean getSuspended(int userId) {
        return this.readUserState((int)userId).suspended;
    }

    void setSuspended(boolean suspended, String suspendingPackage, SuspendDialogInfo dialogInfo, PersistableBundle appExtras, PersistableBundle launcherExtras, int userId) {
        PackageUserState existingUserState = this.modifyUserState(userId);
        existingUserState.suspended = suspended;
        existingUserState.suspendingPackage = suspended ? suspendingPackage : null;
        existingUserState.dialogInfo = suspended ? dialogInfo : null;
        existingUserState.suspendedAppExtras = suspended ? appExtras : null;
        existingUserState.suspendedLauncherExtras = suspended ? launcherExtras : null;
    }

    public boolean getInstantApp(int userId) {
        return this.readUserState((int)userId).instantApp;
    }

    void setInstantApp(boolean instantApp, int userId) {
        this.modifyUserState((int)userId).instantApp = instantApp;
    }

    boolean getVirtulalPreload(int userId) {
        return this.readUserState((int)userId).virtualPreload;
    }

    void setVirtualPreload(boolean virtualPreload, int userId) {
        this.modifyUserState((int)userId).virtualPreload = virtualPreload;
    }

    void setUserState(int userId, long ceDataInode, int enabled, boolean installed, boolean stopped, boolean notLaunched, boolean hidden, int distractionFlags, boolean suspended, String suspendingPackage, SuspendDialogInfo dialogInfo, PersistableBundle suspendedAppExtras, PersistableBundle suspendedLauncherExtras, boolean instantApp, boolean virtualPreload, String lastDisableAppCaller, ArraySet<String> enabledComponents, ArraySet<String> disabledComponents, int domainVerifState, int linkGeneration, int installReason, String harmfulAppWarning) {
        PackageUserState state = this.modifyUserState(userId);
        state.ceDataInode = ceDataInode;
        state.enabled = enabled;
        state.installed = installed;
        state.stopped = stopped;
        state.notLaunched = notLaunched;
        state.hidden = hidden;
        state.distractionFlags = distractionFlags;
        state.suspended = suspended;
        state.suspendingPackage = suspendingPackage;
        state.dialogInfo = dialogInfo;
        state.suspendedAppExtras = suspendedAppExtras;
        state.suspendedLauncherExtras = suspendedLauncherExtras;
        state.lastDisableAppCaller = lastDisableAppCaller;
        state.enabledComponents = enabledComponents;
        state.disabledComponents = disabledComponents;
        state.domainVerificationStatus = domainVerifState;
        state.appLinkGeneration = linkGeneration;
        state.installReason = installReason;
        state.instantApp = instantApp;
        state.virtualPreload = virtualPreload;
        state.harmfulAppWarning = harmfulAppWarning;
    }

    ArraySet<String> getEnabledComponents(int userId) {
        return this.readUserState((int)userId).enabledComponents;
    }

    ArraySet<String> getDisabledComponents(int userId) {
        return this.readUserState((int)userId).disabledComponents;
    }

    void setEnabledComponents(ArraySet<String> components, int userId) {
        this.modifyUserState((int)userId).enabledComponents = components;
    }

    void setDisabledComponents(ArraySet<String> components, int userId) {
        this.modifyUserState((int)userId).disabledComponents = components;
    }

    void setEnabledComponentsCopy(ArraySet<String> components, int userId) {
        this.modifyUserState((int)userId).enabledComponents = components != null ? new ArraySet<String>(components) : null;
    }

    void setDisabledComponentsCopy(ArraySet<String> components, int userId) {
        this.modifyUserState((int)userId).disabledComponents = components != null ? new ArraySet<String>(components) : null;
    }

    PackageUserState modifyUserStateComponents(int userId, boolean disabled, boolean enabled) {
        PackageUserState state = this.modifyUserState(userId);
        if (disabled && state.disabledComponents == null) {
            state.disabledComponents = new ArraySet(1);
        }
        if (enabled && state.enabledComponents == null) {
            state.enabledComponents = new ArraySet(1);
        }
        return state;
    }

    void addDisabledComponent(String componentClassName, int userId) {
        this.modifyUserStateComponents((int)userId, (boolean)true, (boolean)false).disabledComponents.add(componentClassName);
    }

    void addEnabledComponent(String componentClassName, int userId) {
        this.modifyUserStateComponents((int)userId, (boolean)false, (boolean)true).enabledComponents.add(componentClassName);
    }

    boolean enableComponentLPw(String componentClassName, int userId) {
        PackageUserState state = this.modifyUserStateComponents(userId, false, true);
        boolean changed = state.disabledComponents != null ? state.disabledComponents.remove(componentClassName) : false;
        return changed |= state.enabledComponents.add(componentClassName);
    }

    boolean disableComponentLPw(String componentClassName, int userId) {
        PackageUserState state = this.modifyUserStateComponents(userId, true, false);
        boolean changed = state.enabledComponents != null ? state.enabledComponents.remove(componentClassName) : false;
        return changed |= state.disabledComponents.add(componentClassName);
    }

    boolean restoreComponentLPw(String componentClassName, int userId) {
        PackageUserState state = this.modifyUserStateComponents(userId, true, true);
        boolean changed = state.disabledComponents != null ? state.disabledComponents.remove(componentClassName) : false;
        return changed |= state.enabledComponents != null ? state.enabledComponents.remove(componentClassName) : false;
    }

    int getCurrentEnabledStateLPr(String componentName, int userId) {
        PackageUserState state = this.readUserState(userId);
        if (state.enabledComponents != null && state.enabledComponents.contains(componentName)) {
            return 1;
        }
        if (state.disabledComponents != null && state.disabledComponents.contains(componentName)) {
            return 2;
        }
        return 0;
    }

    void removeUser(int userId) {
        this.mUserState.delete(userId);
    }

    public int[] getNotInstalledUserIds() {
        int count = 0;
        int userStateCount = this.mUserState.size();
        for (int i = 0; i < userStateCount; ++i) {
            if (this.mUserState.valueAt((int)i).installed) continue;
            ++count;
        }
        if (count == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] excludedUserIds = new int[count];
        int idx = 0;
        for (int i = 0; i < userStateCount; ++i) {
            if (this.mUserState.valueAt((int)i).installed) continue;
            excludedUserIds[idx++] = this.mUserState.keyAt(i);
        }
        return excludedUserIds;
    }

    IntentFilterVerificationInfo getIntentFilterVerificationInfo() {
        return this.verificationInfo;
    }

    void setIntentFilterVerificationInfo(IntentFilterVerificationInfo info) {
        this.verificationInfo = info;
    }

    long getDomainVerificationStatusForUser(int userId) {
        PackageUserState state = this.readUserState(userId);
        long result = state.appLinkGeneration;
        return result |= (long)state.domainVerificationStatus << 32;
    }

    void setDomainVerificationStatusForUser(int status, int generation, int userId) {
        PackageUserState state = this.modifyUserState(userId);
        state.domainVerificationStatus = status;
        if (status == 2) {
            state.appLinkGeneration = generation;
        }
    }

    void clearDomainVerificationStatusForUser(int userId) {
        this.modifyUserState((int)userId).domainVerificationStatus = 0;
    }

    protected void writeUsersInfoToProto(ProtoOutputStream proto, long fieldId) {
        int count = this.mUserState.size();
        for (int i = 0; i < count; ++i) {
            long userToken = proto.start(fieldId);
            int userId = this.mUserState.keyAt(i);
            PackageUserState state = this.mUserState.valueAt(i);
            proto.write(0x10500000001L, userId);
            int installType = state.instantApp ? 2 : (state.installed ? 1 : 0);
            proto.write(1159641169922L, installType);
            proto.write(1133871366147L, state.hidden);
            proto.write(1120986464266L, state.distractionFlags);
            proto.write(1133871366148L, state.suspended);
            if (state.suspended) {
                proto.write(0x10900000009L, state.suspendingPackage);
            }
            proto.write(1133871366149L, state.stopped);
            proto.write(1133871366150L, !state.notLaunched);
            proto.write(1159641169927L, state.enabled);
            proto.write(1138166333448L, state.lastDisableAppCaller);
            proto.end(userToken);
        }
    }

    void setHarmfulAppWarning(int userId, String harmfulAppWarning) {
        PackageUserState userState = this.modifyUserState(userId);
        userState.harmfulAppWarning = harmfulAppWarning;
    }

    String getHarmfulAppWarning(int userId) {
        PackageUserState userState = this.readUserState(userId);
        return userState.harmfulAppWarning;
    }

    protected PackageSettingBase updateFrom(PackageSettingBase other) {
        super.copyFrom(other);
        this.parentPackageName = other.parentPackageName;
        this.childPackageNames = other.childPackageNames;
        this.codePath = other.codePath;
        this.codePathString = other.codePathString;
        this.resourcePath = other.resourcePath;
        this.resourcePathString = other.resourcePathString;
        this.usesStaticLibraries = other.usesStaticLibraries;
        this.usesStaticLibrariesVersions = other.usesStaticLibrariesVersions;
        this.legacyNativeLibraryPathString = other.legacyNativeLibraryPathString;
        this.primaryCpuAbiString = other.primaryCpuAbiString;
        this.secondaryCpuAbiString = other.secondaryCpuAbiString;
        this.cpuAbiOverrideString = other.cpuAbiOverrideString;
        this.timeStamp = other.timeStamp;
        this.firstInstallTime = other.firstInstallTime;
        this.lastUpdateTime = other.lastUpdateTime;
        this.versionCode = other.versionCode;
        this.uidError = other.uidError;
        this.signatures = other.signatures;
        this.installPermissionsFixed = other.installPermissionsFixed;
        this.keySetData = other.keySetData;
        this.installerPackageName = other.installerPackageName;
        this.isOrphaned = other.isOrphaned;
        this.volumeUuid = other.volumeUuid;
        this.categoryHint = other.categoryHint;
        this.updateAvailable = other.updateAvailable;
        this.verificationInfo = other.verificationInfo;
        if (this.mOldCodePaths != null) {
            if (other.mOldCodePaths != null) {
                this.mOldCodePaths.clear();
                this.mOldCodePaths.addAll(other.mOldCodePaths);
            } else {
                this.mOldCodePaths = null;
            }
        }
        this.mUserState.clear();
        for (int i = 0; i < other.mUserState.size(); ++i) {
            this.mUserState.put(other.mUserState.keyAt(i), other.mUserState.valueAt(i));
        }
        return this;
    }
}

