/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.content.pm.Signature;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.PackageManagerService;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class PackageSignatures {
    PackageParser.SigningDetails mSigningDetails;

    PackageSignatures(PackageSignatures orig) {
        this.mSigningDetails = orig != null && orig.mSigningDetails != PackageParser.SigningDetails.UNKNOWN ? new PackageParser.SigningDetails(orig.mSigningDetails) : PackageParser.SigningDetails.UNKNOWN;
    }

    PackageSignatures(PackageParser.SigningDetails signingDetails) {
        this.mSigningDetails = signingDetails;
    }

    PackageSignatures() {
        this.mSigningDetails = PackageParser.SigningDetails.UNKNOWN;
    }

    void writeXml(XmlSerializer serializer, String tagName, ArrayList<Signature> writtenSignatures) throws IOException {
        if (this.mSigningDetails.signatures == null) {
            return;
        }
        serializer.startTag(null, tagName);
        serializer.attribute(null, "count", Integer.toString(this.mSigningDetails.signatures.length));
        serializer.attribute(null, "schemeVersion", Integer.toString(this.mSigningDetails.signatureSchemeVersion));
        this.writeCertsListXml(serializer, writtenSignatures, this.mSigningDetails.signatures, false);
        if (this.mSigningDetails.pastSigningCertificates != null) {
            serializer.startTag(null, "pastSigs");
            serializer.attribute(null, "count", Integer.toString(this.mSigningDetails.pastSigningCertificates.length));
            this.writeCertsListXml(serializer, writtenSignatures, this.mSigningDetails.pastSigningCertificates, true);
            serializer.endTag(null, "pastSigs");
        }
        serializer.endTag(null, tagName);
    }

    private void writeCertsListXml(XmlSerializer serializer, ArrayList<Signature> writtenSignatures, Signature[] signatures, boolean isPastSigs) throws IOException {
        for (int i = 0; i < signatures.length; ++i) {
            int j;
            serializer.startTag(null, "cert");
            Signature sig = signatures[i];
            int sigHash = sig.hashCode();
            int numWritten = writtenSignatures.size();
            for (j = 0; j < numWritten; ++j) {
                Signature writtenSig = writtenSignatures.get(j);
                if (writtenSig.hashCode() != sigHash || !writtenSig.equals(sig)) continue;
                serializer.attribute(null, "index", Integer.toString(j));
                break;
            }
            if (j >= numWritten) {
                writtenSignatures.add(sig);
                serializer.attribute(null, "index", Integer.toString(numWritten));
                serializer.attribute(null, "key", sig.toCharsString());
            }
            if (isPastSigs) {
                serializer.attribute(null, "flags", Integer.toString(sig.getFlags()));
            }
            serializer.endTag(null, "cert");
        }
    }

    void readXml(XmlPullParser parser, ArrayList<Signature> readSignatures) throws IOException, XmlPullParserException {
        int signatureSchemeVersion;
        PackageParser.SigningDetails.Builder builder = new PackageParser.SigningDetails.Builder();
        String countStr = parser.getAttributeValue(null, "count");
        if (countStr == null) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <sigs> has no count at " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
            return;
        }
        int count = Integer.parseInt(countStr);
        String schemeVersionStr = parser.getAttributeValue(null, "schemeVersion");
        if (schemeVersionStr == null) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <sigs> has no schemeVersion at " + parser.getPositionDescription());
            signatureSchemeVersion = 0;
        } else {
            signatureSchemeVersion = Integer.parseInt(schemeVersionStr);
        }
        builder.setSignatureSchemeVersion(signatureSchemeVersion);
        ArrayList<Signature> signatureList = new ArrayList<Signature>();
        int pos = this.readCertsListXml(parser, readSignatures, signatureList, count, false, builder);
        Signature[] signatures = signatureList.toArray(new Signature[signatureList.size()]);
        builder.setSignatures(signatures);
        if (pos < count) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <sigs> count does not match number of  <cert> entries" + parser.getPositionDescription());
        }
        try {
            this.mSigningDetails = builder.build();
        }
        catch (CertificateException e) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <sigs> unable to convert certificate(s) to public key(s).");
            this.mSigningDetails = PackageParser.SigningDetails.UNKNOWN;
        }
    }

    private int readCertsListXml(XmlPullParser parser, ArrayList<Signature> readSignatures, ArrayList<Signature> signatures, int count, boolean isPastSigs, PackageParser.SigningDetails.Builder builder) throws IOException, XmlPullParserException {
        int type;
        int pos = 0;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("cert")) {
                block27: {
                    if (pos < count) {
                        String index = parser.getAttributeValue(null, "index");
                        if (index != null) {
                            boolean signatureParsed = false;
                            try {
                                Signature sig;
                                int idx = Integer.parseInt(index);
                                String key = parser.getAttributeValue(null, "key");
                                if (key == null) {
                                    if (idx >= 0 && idx < readSignatures.size()) {
                                        sig = readSignatures.get(idx);
                                        if (sig != null) {
                                            signatures.add(sig);
                                            signatureParsed = true;
                                        } else {
                                            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <cert> index " + index + " is not defined at " + parser.getPositionDescription());
                                        }
                                    } else {
                                        PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <cert> index " + index + " is out of bounds at " + parser.getPositionDescription());
                                    }
                                } else {
                                    sig = new Signature(key);
                                    while (readSignatures.size() < idx) {
                                        readSignatures.add(null);
                                    }
                                    readSignatures.add(sig);
                                    signatures.add(sig);
                                    signatureParsed = true;
                                }
                            }
                            catch (NumberFormatException e) {
                                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <cert> index " + index + " is not a number at " + parser.getPositionDescription());
                            }
                            catch (IllegalArgumentException e) {
                                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <cert> index " + index + " has an invalid signature at " + parser.getPositionDescription() + ": " + e.getMessage());
                            }
                            if (isPastSigs) {
                                String flagsStr = parser.getAttributeValue(null, "flags");
                                if (flagsStr != null) {
                                    try {
                                        int flagsValue = Integer.parseInt(flagsStr);
                                        if (signatureParsed) {
                                            signatures.get(signatures.size() - 1).setFlags(flagsValue);
                                            break block27;
                                        }
                                        PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: signature not available at index " + pos + " to set flags at " + parser.getPositionDescription());
                                    }
                                    catch (NumberFormatException e) {
                                        PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <cert> flags " + flagsStr + " is not a number at " + parser.getPositionDescription());
                                    }
                                } else {
                                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <cert> has no flags at " + parser.getPositionDescription());
                                }
                            }
                        } else {
                            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <cert> has no index at " + parser.getPositionDescription());
                        }
                    } else {
                        PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: too many <cert> tags, expected " + count + " at " + parser.getPositionDescription());
                    }
                }
                ++pos;
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("pastSigs")) {
                if (!isPastSigs) {
                    String countStr = parser.getAttributeValue(null, "count");
                    if (countStr == null) {
                        PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <pastSigs> has no count at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    try {
                        int pastSigsCount = Integer.parseInt(countStr);
                        ArrayList<Signature> pastSignatureList = new ArrayList<Signature>();
                        int pastSigsPos = this.readCertsListXml(parser, readSignatures, pastSignatureList, pastSigsCount, true, builder);
                        Signature[] pastSignatures = pastSignatureList.toArray(new Signature[pastSignatureList.size()]);
                        builder = builder.setPastSigningCertificates(pastSignatures);
                        if (pastSigsPos >= pastSigsCount) continue;
                        PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <pastSigs> count does not match number of <cert> entries " + parser.getPositionDescription());
                    }
                    catch (NumberFormatException e) {
                        PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <pastSigs> count " + countStr + " is not a number at " + parser.getPositionDescription());
                    }
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "<pastSigs> encountered multiple times under the same <sigs> at " + parser.getPositionDescription());
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <sigs>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        return pos;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(128);
        buf.append("PackageSignatures{");
        buf.append(Integer.toHexString(System.identityHashCode(this)));
        buf.append(" version:");
        buf.append(this.mSigningDetails.signatureSchemeVersion);
        buf.append(", signatures:[");
        if (this.mSigningDetails.signatures != null) {
            for (i = 0; i < this.mSigningDetails.signatures.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(Integer.toHexString(this.mSigningDetails.signatures[i].hashCode()));
            }
        }
        buf.append("]");
        buf.append(", past signatures:[");
        if (this.mSigningDetails.pastSigningCertificates != null) {
            for (i = 0; i < this.mSigningDetails.pastSigningCertificates.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(Integer.toHexString(this.mSigningDetails.pastSigningCertificates[i].hashCode()));
                buf.append(" flags: ");
                buf.append(Integer.toHexString(this.mSigningDetails.pastSigningCertificates[i].getFlags()));
            }
        }
        buf.append("]}");
        return buf.toString();
    }
}

