/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.util.SparseBooleanArray;
import com.android.server.pm.PackageManagerService;

class PackageVerificationState {
    private final PackageManagerService.InstallParams mParams;
    private final SparseBooleanArray mSufficientVerifierUids;
    private final int mRequiredVerifierUid;
    private boolean mSufficientVerificationComplete;
    private boolean mSufficientVerificationPassed;
    private boolean mRequiredVerificationComplete;
    private boolean mRequiredVerificationPassed;
    private boolean mExtendedTimeout;

    PackageVerificationState(int requiredVerifierUid, PackageManagerService.InstallParams params) {
        this.mRequiredVerifierUid = requiredVerifierUid;
        this.mParams = params;
        this.mSufficientVerifierUids = new SparseBooleanArray();
        this.mExtendedTimeout = false;
    }

    PackageManagerService.InstallParams getInstallParams() {
        return this.mParams;
    }

    void addSufficientVerifier(int uid) {
        this.mSufficientVerifierUids.put(uid, true);
    }

    boolean setVerifierResponse(int uid, int code) {
        if (uid == this.mRequiredVerifierUid) {
            this.mRequiredVerificationComplete = true;
            switch (code) {
                case 2: {
                    this.mSufficientVerifierUids.clear();
                }
                case 1: {
                    this.mRequiredVerificationPassed = true;
                    break;
                }
                default: {
                    this.mRequiredVerificationPassed = false;
                }
            }
            return true;
        }
        if (this.mSufficientVerifierUids.get(uid)) {
            if (code == 1) {
                this.mSufficientVerificationComplete = true;
                this.mSufficientVerificationPassed = true;
            }
            this.mSufficientVerifierUids.delete(uid);
            if (this.mSufficientVerifierUids.size() == 0) {
                this.mSufficientVerificationComplete = true;
            }
            return true;
        }
        return false;
    }

    boolean isVerificationComplete() {
        if (!this.mRequiredVerificationComplete) {
            return false;
        }
        if (this.mSufficientVerifierUids.size() == 0) {
            return true;
        }
        return this.mSufficientVerificationComplete;
    }

    boolean isInstallAllowed() {
        if (!this.mRequiredVerificationPassed) {
            return false;
        }
        if (this.mSufficientVerificationComplete) {
            return this.mSufficientVerificationPassed;
        }
        return true;
    }

    void extendTimeout() {
        if (!this.mExtendedTimeout) {
            this.mExtendedTimeout = true;
        }
    }

    boolean timeoutExtended() {
        return this.mExtendedTimeout;
    }
}

