/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.text.TextUtils;
import com.android.server.pm.ShortcutService;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class ShareTargetInfo {
    private static final String TAG_SHARE_TARGET = "share-target";
    private static final String ATTR_TARGET_CLASS = "targetClass";
    private static final String TAG_DATA = "data";
    private static final String ATTR_SCHEME = "scheme";
    private static final String ATTR_HOST = "host";
    private static final String ATTR_PORT = "port";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_PATH_PATTERN = "pathPattern";
    private static final String ATTR_PATH_PREFIX = "pathPrefix";
    private static final String ATTR_MIME_TYPE = "mimeType";
    private static final String TAG_CATEGORY = "category";
    private static final String ATTR_NAME = "name";
    final TargetData[] mTargetData;
    final String mTargetClass;
    final String[] mCategories;

    ShareTargetInfo(TargetData[] data, String targetClass, String[] categories) {
        this.mTargetData = data;
        this.mTargetClass = targetClass;
        this.mCategories = categories;
    }

    public String toString() {
        int i;
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("targetClass=").append(this.mTargetClass);
        for (i = 0; i < this.mTargetData.length; ++i) {
            strBuilder.append(" data={");
            this.mTargetData[i].toStringInner(strBuilder);
            strBuilder.append("}");
        }
        for (i = 0; i < this.mCategories.length; ++i) {
            strBuilder.append(" category=").append(this.mCategories[i]);
        }
        return strBuilder.toString();
    }

    void saveToXml(XmlSerializer out) throws IOException {
        int i;
        out.startTag(null, TAG_SHARE_TARGET);
        ShortcutService.writeAttr(out, ATTR_TARGET_CLASS, this.mTargetClass);
        for (i = 0; i < this.mTargetData.length; ++i) {
            out.startTag(null, TAG_DATA);
            ShortcutService.writeAttr(out, ATTR_SCHEME, this.mTargetData[i].mScheme);
            ShortcutService.writeAttr(out, ATTR_HOST, this.mTargetData[i].mHost);
            ShortcutService.writeAttr(out, ATTR_PORT, this.mTargetData[i].mPort);
            ShortcutService.writeAttr(out, ATTR_PATH, this.mTargetData[i].mPath);
            ShortcutService.writeAttr(out, ATTR_PATH_PATTERN, this.mTargetData[i].mPathPattern);
            ShortcutService.writeAttr(out, ATTR_PATH_PREFIX, this.mTargetData[i].mPathPrefix);
            ShortcutService.writeAttr(out, ATTR_MIME_TYPE, this.mTargetData[i].mMimeType);
            out.endTag(null, TAG_DATA);
        }
        for (i = 0; i < this.mCategories.length; ++i) {
            out.startTag(null, TAG_CATEGORY);
            ShortcutService.writeAttr(out, ATTR_NAME, this.mCategories[i]);
            out.endTag(null, TAG_CATEGORY);
        }
        out.endTag(null, TAG_SHARE_TARGET);
    }

    static ShareTargetInfo loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        String targetClass = ShortcutService.parseStringAttribute(parser, ATTR_TARGET_CLASS);
        ArrayList<TargetData> targetData = new ArrayList<TargetData>();
        ArrayList<String> categories = new ArrayList<String>();
        while ((type = parser.next()) != 1) {
            if (type == 2) {
                switch (parser.getName()) {
                    case "data": {
                        targetData.add(ShareTargetInfo.parseTargetData(parser));
                        break;
                    }
                    case "category": {
                        categories.add(ShortcutService.parseStringAttribute(parser, ATTR_NAME));
                    }
                }
                continue;
            }
            if (type != 3 || !parser.getName().equals(TAG_SHARE_TARGET)) continue;
        }
        if (targetData.isEmpty() || targetClass == null || categories.isEmpty()) {
            return null;
        }
        return new ShareTargetInfo(targetData.toArray(new TargetData[targetData.size()]), targetClass, categories.toArray(new String[categories.size()]));
    }

    private static TargetData parseTargetData(XmlPullParser parser) {
        String scheme = ShortcutService.parseStringAttribute(parser, ATTR_SCHEME);
        String host = ShortcutService.parseStringAttribute(parser, ATTR_HOST);
        String port = ShortcutService.parseStringAttribute(parser, ATTR_PORT);
        String path = ShortcutService.parseStringAttribute(parser, ATTR_PATH);
        String pathPattern = ShortcutService.parseStringAttribute(parser, ATTR_PATH_PATTERN);
        String pathPrefix = ShortcutService.parseStringAttribute(parser, ATTR_PATH_PREFIX);
        String mimeType = ShortcutService.parseStringAttribute(parser, ATTR_MIME_TYPE);
        return new TargetData(scheme, host, port, path, pathPattern, pathPrefix, mimeType);
    }

    static class TargetData {
        final String mScheme;
        final String mHost;
        final String mPort;
        final String mPath;
        final String mPathPattern;
        final String mPathPrefix;
        final String mMimeType;

        TargetData(String scheme, String host, String port, String path, String pathPattern, String pathPrefix, String mimeType) {
            this.mScheme = scheme;
            this.mHost = host;
            this.mPort = port;
            this.mPath = path;
            this.mPathPattern = pathPattern;
            this.mPathPrefix = pathPrefix;
            this.mMimeType = mimeType;
        }

        public void toStringInner(StringBuilder strBuilder) {
            if (!TextUtils.isEmpty(this.mScheme)) {
                strBuilder.append(" scheme=").append(this.mScheme);
            }
            if (!TextUtils.isEmpty(this.mHost)) {
                strBuilder.append(" host=").append(this.mHost);
            }
            if (!TextUtils.isEmpty(this.mPort)) {
                strBuilder.append(" port=").append(this.mPort);
            }
            if (!TextUtils.isEmpty(this.mPath)) {
                strBuilder.append(" path=").append(this.mPath);
            }
            if (!TextUtils.isEmpty(this.mPathPattern)) {
                strBuilder.append(" pathPattern=").append(this.mPathPattern);
            }
            if (!TextUtils.isEmpty(this.mPathPrefix)) {
                strBuilder.append(" pathPrefix=").append(this.mPathPrefix);
            }
            if (!TextUtils.isEmpty(this.mMimeType)) {
                strBuilder.append(" mimeType=").append(this.mMimeType);
            }
        }

        public String toString() {
            StringBuilder strBuilder = new StringBuilder();
            this.toStringInner(strBuilder);
            return strBuilder.toString();
        }
    }
}

