/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.util.ArraySet;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.ArrayUtils;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSignatures;
import com.android.server.pm.SELinuxMMAC;
import com.android.server.pm.SettingBase;
import java.util.ArrayList;
import java.util.List;
import libcore.util.EmptyArray;

public final class SharedUserSetting
extends SettingBase {
    final String name;
    int userId;
    int uidFlags;
    int uidPrivateFlags;
    int seInfoTargetSdkVersion;
    final ArraySet<PackageSetting> packages = new ArraySet();
    final PackageSignatures signatures = new PackageSignatures();
    Boolean signaturesChanged;

    SharedUserSetting(String _name, int _pkgFlags, int _pkgPrivateFlags) {
        super(_pkgFlags, _pkgPrivateFlags);
        this.uidFlags = _pkgFlags;
        this.uidPrivateFlags = _pkgPrivateFlags;
        this.name = _name;
        this.seInfoTargetSdkVersion = 10000;
    }

    public String toString() {
        return "SharedUserSetting{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "/" + this.userId + "}";
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, this.userId);
        proto.write(1138166333442L, this.name);
        proto.end(token);
    }

    boolean removePackage(PackageSetting packageSetting) {
        if (!this.packages.remove(packageSetting)) {
            return false;
        }
        if ((this.pkgFlags & packageSetting.pkgFlags) != 0) {
            int aggregatedFlags = this.uidFlags;
            for (PackageSetting ps : this.packages) {
                aggregatedFlags |= ps.pkgFlags;
            }
            this.setFlags(aggregatedFlags);
        }
        if ((this.pkgPrivateFlags & packageSetting.pkgPrivateFlags) != 0) {
            int aggregatedPrivateFlags = this.uidPrivateFlags;
            for (PackageSetting ps : this.packages) {
                aggregatedPrivateFlags |= ps.pkgPrivateFlags;
            }
            this.setPrivateFlags(aggregatedPrivateFlags);
        }
        return true;
    }

    void addPackage(PackageSetting packageSetting) {
        if (this.packages.size() == 0 && packageSetting.pkg != null) {
            this.seInfoTargetSdkVersion = packageSetting.pkg.applicationInfo.targetSdkVersion;
        }
        if (this.packages.add(packageSetting)) {
            this.setFlags(this.pkgFlags | packageSetting.pkgFlags);
            this.setPrivateFlags(this.pkgPrivateFlags | packageSetting.pkgPrivateFlags);
        }
    }

    public List<PackageParser.Package> getPackages() {
        if (this.packages == null || this.packages.size() == 0) {
            return null;
        }
        ArrayList<PackageParser.Package> pkgList = new ArrayList<PackageParser.Package>(this.packages.size());
        for (PackageSetting ps : this.packages) {
            if (ps == null || ps.pkg == null) continue;
            pkgList.add(ps.pkg);
        }
        return pkgList;
    }

    public boolean isPrivileged() {
        return (this.pkgPrivateFlags & 8) != 0;
    }

    public void fixSeInfoLocked() {
        List<PackageParser.Package> pkgList = this.getPackages();
        if (pkgList == null || pkgList.size() == 0) {
            return;
        }
        for (PackageParser.Package pkg : pkgList) {
            if (pkg.applicationInfo.targetSdkVersion >= this.seInfoTargetSdkVersion) continue;
            this.seInfoTargetSdkVersion = pkg.applicationInfo.targetSdkVersion;
        }
        for (PackageParser.Package pkg : pkgList) {
            boolean isPrivileged = this.isPrivileged() | pkg.isPrivileged();
            pkg.applicationInfo.seInfo = SELinuxMMAC.getSeInfo(pkg, isPrivileged, pkg.applicationInfo.targetSandboxVersion, this.seInfoTargetSdkVersion);
        }
    }

    public int[] getNotInstalledUserIds() {
        int[] excludedUserIds = null;
        for (PackageSetting ps : this.packages) {
            int[] userIds = ps.getNotInstalledUserIds();
            if (excludedUserIds == null) {
                excludedUserIds = userIds;
                continue;
            }
            for (int userId : excludedUserIds) {
                if (ArrayUtils.contains(userIds, userId)) continue;
                excludedUserIds = ArrayUtils.removeInt(excludedUserIds, userId);
            }
        }
        return excludedUserIds == null ? EmptyArray.INT : excludedUserIds;
    }

    public SharedUserSetting updateFrom(SharedUserSetting sharedUser) {
        this.copyFrom(sharedUser);
        this.userId = sharedUser.userId;
        this.uidFlags = sharedUser.uidFlags;
        this.uidPrivateFlags = sharedUser.uidPrivateFlags;
        this.seInfoTargetSdkVersion = sharedUser.seInfoTargetSdkVersion;
        this.packages.clear();
        this.packages.addAll(sharedUser.packages);
        this.signaturesChanged = sharedUser.signaturesChanged;
        return this;
    }
}

