/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.ShortcutInfo;
import android.graphics.Bitmap;
import android.graphics.drawable.Icon;
import android.os.StrictMode;
import android.os.SystemClock;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.server.pm.ShortcutService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Deque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;

public class ShortcutBitmapSaver {
    private static final String TAG = "ShortcutService";
    private static final boolean DEBUG = false;
    private static final boolean ADD_DELAY_BEFORE_SAVE_FOR_TEST = false;
    private static final long SAVE_DELAY_MS_FOR_TEST = 1000L;
    private final long SAVE_WAIT_TIMEOUT_MS = 30000L;
    private final ShortcutService mService;
    private final Executor mExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    @GuardedBy(value={"mPendingItems"})
    private final Deque<PendingItem> mPendingItems = new LinkedBlockingDeque<PendingItem>();
    private final Runnable mRunnable = () -> {
        while (this.processPendingItems()) {
        }
    };

    public ShortcutBitmapSaver(ShortcutService service) {
        this.mService = service;
    }

    public boolean waitForAllSavesLocked() {
        CountDownLatch latch = new CountDownLatch(1);
        this.mExecutor.execute(() -> latch.countDown());
        try {
            if (latch.await(30000L, TimeUnit.MILLISECONDS)) {
                return true;
            }
            this.mService.wtf("Timed out waiting on saving bitmaps.");
        }
        catch (InterruptedException e) {
            Slog.w(TAG, "interrupted");
        }
        return false;
    }

    public String getBitmapPathMayWaitLocked(ShortcutInfo shortcut) {
        boolean success = this.waitForAllSavesLocked();
        if (success && shortcut.hasIconFile()) {
            return shortcut.getBitmapPath();
        }
        return null;
    }

    public void removeIcon(ShortcutInfo shortcut) {
        shortcut.setIconResourceId(0);
        shortcut.setIconResName(null);
        shortcut.setBitmapPath(null);
        shortcut.clearFlags(2572);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBitmapLocked(ShortcutInfo shortcut, int maxDimension, Bitmap.CompressFormat format, int quality) {
        byte[] bytes;
        Icon icon = shortcut.getIcon();
        Preconditions.checkNotNull(icon);
        Bitmap original = icon.getBitmap();
        if (original == null) {
            Log.e(TAG, "Missing icon: " + shortcut);
            return;
        }
        StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
        try {
            StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder(oldPolicy).permitCustomSlowCalls().build());
            Bitmap shrunk = ShortcutService.shrinkBitmap(original, maxDimension);
            try (ByteArrayOutputStream out = new ByteArrayOutputStream(65536);){
                if (!shrunk.compress(format, quality, out)) {
                    Slog.wtf(TAG, "Unable to compress bitmap");
                }
                out.flush();
                bytes = out.toByteArray();
                out.close();
            }
            finally {
                if (shrunk != original) {
                    shrunk.recycle();
                }
            }
        }
        catch (IOException | OutOfMemoryError | RuntimeException e) {
            Slog.wtf(TAG, "Unable to write bitmap to file", e);
            return;
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        shortcut.addFlags(2056);
        if (icon.getType() == 5) {
            shortcut.addFlags(512);
        }
        PendingItem item = new PendingItem(shortcut, bytes);
        Deque<PendingItem> deque = this.mPendingItems;
        synchronized (deque) {
            this.mPendingItems.add(item);
        }
        this.mExecutor.execute(this.mRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPendingItems() {
        ShortcutInfo shortcut = null;
        try {
            PendingItem item;
            Deque<PendingItem> deque = this.mPendingItems;
            synchronized (deque) {
                block20: {
                    if (this.mPendingItems.size() != 0) break block20;
                    boolean bl = false;
                    return bl;
                }
                item = this.mPendingItems.pop();
            }
            shortcut = item.shortcut;
            if (!shortcut.isIconPendingSave()) {
                boolean bl = true;
                return bl;
            }
            File file = null;
            try {
                ShortcutService.FileOutputStreamWithPath out = this.mService.openIconFileForWrite(shortcut.getUserId(), shortcut);
                file = out.getFile();
                try {
                    out.write(item.bytes);
                }
                finally {
                    IoUtils.closeQuietly(out);
                }
                shortcut.setBitmapPath(file.getAbsolutePath());
            }
            catch (IOException | RuntimeException e) {
                Slog.e(TAG, "Unable to write bitmap to file", e);
                if (file != null && file.exists()) {
                    file.delete();
                }
                boolean bl = true;
                if (shortcut != null) {
                    if (shortcut.getBitmapPath() == null) {
                        this.removeIcon(shortcut);
                    }
                    shortcut.clearFlags(2048);
                }
                return bl;
            }
        }
        finally {
            if (shortcut != null) {
                if (shortcut.getBitmapPath() == null) {
                    this.removeIcon(shortcut);
                }
                shortcut.clearFlags(2048);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLocked(PrintWriter pw, String prefix) {
        Deque<PendingItem> deque = this.mPendingItems;
        synchronized (deque) {
            int N = this.mPendingItems.size();
            pw.print(prefix);
            pw.println("Pending saves: Num=" + N + " Executor=" + this.mExecutor);
            for (PendingItem item : this.mPendingItems) {
                pw.print(prefix);
                pw.print("  ");
                pw.println(item);
            }
        }
    }

    private static class PendingItem {
        public final ShortcutInfo shortcut;
        public final byte[] bytes;
        private final long mInstantiatedUptimeMillis;

        private PendingItem(ShortcutInfo shortcut, byte[] bytes) {
            this.shortcut = shortcut;
            this.bytes = bytes;
            this.mInstantiatedUptimeMillis = SystemClock.uptimeMillis();
        }

        public String toString() {
            return "PendingItem{size=" + this.bytes.length + " age=" + (SystemClock.uptimeMillis() - this.mInstantiatedUptimeMillis) + "ms shortcut=" + this.shortcut.toInsecureString() + "}";
        }
    }
}

