/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.Person;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.LocusId;
import android.content.pm.PackageInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.content.res.Resources;
import android.os.PersistableBundle;
import android.text.format.Formatter;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.ShareTargetInfo;
import com.android.server.pm.ShortcutPackageInfo;
import com.android.server.pm.ShortcutPackageItem;
import com.android.server.pm.ShortcutParser;
import com.android.server.pm.ShortcutService;
import com.android.server.pm.ShortcutUser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class ShortcutPackage
extends ShortcutPackageItem {
    private static final String TAG = "ShortcutService";
    private static final String TAG_VERIFY = "ShortcutService.verify";
    static final String TAG_ROOT = "package";
    private static final String TAG_INTENT_EXTRAS_LEGACY = "intent-extras";
    private static final String TAG_INTENT = "intent";
    private static final String TAG_EXTRAS = "extras";
    private static final String TAG_SHORTCUT = "shortcut";
    private static final String TAG_SHARE_TARGET = "share-target";
    private static final String TAG_CATEGORIES = "categories";
    private static final String TAG_PERSON = "person";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CALL_COUNT = "call-count";
    private static final String ATTR_LAST_RESET = "last-reset";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ACTIVITY = "activity";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TITLE_RES_ID = "titleid";
    private static final String ATTR_TITLE_RES_NAME = "titlename";
    private static final String ATTR_TEXT = "text";
    private static final String ATTR_TEXT_RES_ID = "textid";
    private static final String ATTR_TEXT_RES_NAME = "textname";
    private static final String ATTR_DISABLED_MESSAGE = "dmessage";
    private static final String ATTR_DISABLED_MESSAGE_RES_ID = "dmessageid";
    private static final String ATTR_DISABLED_MESSAGE_RES_NAME = "dmessagename";
    private static final String ATTR_DISABLED_REASON = "disabled-reason";
    private static final String ATTR_INTENT_LEGACY = "intent";
    private static final String ATTR_INTENT_NO_EXTRA = "intent-base";
    private static final String ATTR_RANK = "rank";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_FLAGS = "flags";
    private static final String ATTR_ICON_RES_ID = "icon-res";
    private static final String ATTR_ICON_RES_NAME = "icon-resname";
    private static final String ATTR_BITMAP_PATH = "bitmap-path";
    private static final String ATTR_LOCUS_ID = "locus-id";
    private static final String ATTR_PERSON_NAME = "name";
    private static final String ATTR_PERSON_URI = "uri";
    private static final String ATTR_PERSON_KEY = "key";
    private static final String ATTR_PERSON_IS_BOT = "is-bot";
    private static final String ATTR_PERSON_IS_IMPORTANT = "is-important";
    private static final String NAME_CATEGORIES = "categories";
    private static final String TAG_STRING_ARRAY_XMLUTILS = "string-array";
    private static final String ATTR_NAME_XMLUTILS = "name";
    private static final String KEY_DYNAMIC = "dynamic";
    private static final String KEY_MANIFEST = "manifest";
    private static final String KEY_PINNED = "pinned";
    private static final String KEY_BITMAPS = "bitmaps";
    private static final String KEY_BITMAP_BYTES = "bitmapBytes";
    private final ArrayMap<String, ShortcutInfo> mShortcuts = new ArrayMap();
    private final ArrayList<ShareTargetInfo> mShareTargets = new ArrayList(0);
    private int mApiCallCount;
    private long mLastResetTime;
    private final int mPackageUid;
    private long mLastKnownForegroundElapsedTime;
    final Comparator<ShortcutInfo> mShortcutTypeAndRankComparator = (a, b) -> {
        if (a.isManifestShortcut() && !b.isManifestShortcut()) {
            return -1;
        }
        if (!a.isManifestShortcut() && b.isManifestShortcut()) {
            return 1;
        }
        return Integer.compare(a.getRank(), b.getRank());
    };
    final Comparator<ShortcutInfo> mShortcutRankComparator = (a, b) -> {
        int ret = Integer.compare(a.getRank(), b.getRank());
        if (ret != 0) {
            return ret;
        }
        if (a.isRankChanged() != b.isRankChanged()) {
            return a.isRankChanged() ? -1 : 1;
        }
        ret = Integer.compare(a.getImplicitRank(), b.getImplicitRank());
        if (ret != 0) {
            return ret;
        }
        return a.getId().compareTo(b.getId());
    };

    private ShortcutPackage(ShortcutUser shortcutUser, int packageUserId, String packageName, ShortcutPackageInfo spi) {
        super(shortcutUser, packageUserId, packageName, spi != null ? spi : ShortcutPackageInfo.newEmpty());
        this.mPackageUid = shortcutUser.mService.injectGetPackageUid(packageName, packageUserId);
    }

    public ShortcutPackage(ShortcutUser shortcutUser, int packageUserId, String packageName) {
        this(shortcutUser, packageUserId, packageName, null);
    }

    @Override
    public int getOwnerUserId() {
        return this.getPackageUserId();
    }

    public int getPackageUid() {
        return this.mPackageUid;
    }

    public Resources getPackageResources() {
        return this.mShortcutUser.mService.injectGetResourcesForApplicationAsUser(this.getPackageName(), this.getPackageUserId());
    }

    public int getShortcutCount() {
        return this.mShortcuts.size();
    }

    @Override
    protected boolean canRestoreAnyVersion() {
        return false;
    }

    @Override
    protected void onRestored(int restoreBlockReason) {
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            si.clearFlags(4096);
            si.setDisabledReason(restoreBlockReason);
            if (restoreBlockReason == 0) continue;
            si.addFlags(64);
        }
        this.refreshPinnedFlags();
    }

    public ShortcutInfo findShortcutById(String id2) {
        return this.mShortcuts.get(id2);
    }

    public boolean isShortcutExistsAndInvisibleToPublisher(String id2) {
        ShortcutInfo si = this.findShortcutById(id2);
        return si != null && !si.isVisibleToPublisher();
    }

    public boolean isShortcutExistsAndVisibleToPublisher(String id2) {
        ShortcutInfo si = this.findShortcutById(id2);
        return si != null && si.isVisibleToPublisher();
    }

    private void ensureNotImmutable(ShortcutInfo shortcut, boolean ignoreInvisible) {
        if (shortcut != null && shortcut.isImmutable() && (!ignoreInvisible || shortcut.isVisibleToPublisher())) {
            throw new IllegalArgumentException("Manifest shortcut ID=" + shortcut.getId() + " may not be manipulated via APIs");
        }
    }

    public void ensureNotImmutable(String id2, boolean ignoreInvisible) {
        this.ensureNotImmutable(this.mShortcuts.get(id2), ignoreInvisible);
    }

    public void ensureImmutableShortcutsNotIncludedWithIds(List<String> shortcutIds, boolean ignoreInvisible) {
        for (int i = shortcutIds.size() - 1; i >= 0; --i) {
            this.ensureNotImmutable(shortcutIds.get(i), ignoreInvisible);
        }
    }

    public void ensureImmutableShortcutsNotIncluded(List<ShortcutInfo> shortcuts, boolean ignoreInvisible) {
        for (int i = shortcuts.size() - 1; i >= 0; --i) {
            this.ensureNotImmutable(shortcuts.get(i).getId(), ignoreInvisible);
        }
    }

    private ShortcutInfo forceDeleteShortcutInner(String id2) {
        ShortcutInfo shortcut = this.mShortcuts.remove(id2);
        if (shortcut != null) {
            this.mShortcutUser.mService.removeIconLocked(shortcut);
            shortcut.clearFlags(35);
        }
        return shortcut;
    }

    private void forceReplaceShortcutInner(ShortcutInfo newShortcut) {
        ShortcutService s = this.mShortcutUser.mService;
        this.forceDeleteShortcutInner(newShortcut.getId());
        s.saveIconAndFixUpShortcutLocked(newShortcut);
        s.fixUpShortcutResourceNamesAndValues(newShortcut);
        this.mShortcuts.put(newShortcut.getId(), newShortcut);
    }

    public void addOrReplaceDynamicShortcut(ShortcutInfo newShortcut) {
        boolean wasPinned;
        Preconditions.checkArgument(newShortcut.isEnabled(), "add/setDynamicShortcuts() cannot publish disabled shortcuts");
        newShortcut.addFlags(1);
        ShortcutInfo oldShortcut = this.mShortcuts.get(newShortcut.getId());
        if (oldShortcut == null) {
            wasPinned = false;
        } else {
            oldShortcut.ensureUpdatableWith(newShortcut, false);
            wasPinned = oldShortcut.isPinned();
        }
        if (wasPinned) {
            newShortcut.addFlags(2);
        }
        this.forceReplaceShortcutInner(newShortcut);
    }

    private void removeOrphans() {
        int i;
        ArrayList<String> removeList = null;
        for (i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (si.isAlive()) continue;
            if (removeList == null) {
                removeList = new ArrayList<String>();
            }
            removeList.add(si.getId());
        }
        if (removeList != null) {
            for (i = removeList.size() - 1; i >= 0; --i) {
                this.forceDeleteShortcutInner((String)removeList.get(i));
            }
        }
    }

    public void deleteAllDynamicShortcuts(boolean ignoreInvisible) {
        long now = this.mShortcutUser.mService.injectCurrentTimeMillis();
        boolean changed = false;
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (!si.isDynamic() || ignoreInvisible && !si.isVisibleToPublisher()) continue;
            changed = true;
            si.setTimestamp(now);
            si.clearFlags(1);
            si.setRank(0);
        }
        if (changed) {
            this.removeOrphans();
        }
    }

    public boolean deleteDynamicWithId(String shortcutId, boolean ignoreInvisible) {
        ShortcutInfo removed = this.deleteOrDisableWithId(shortcutId, false, false, ignoreInvisible, 0);
        return removed == null;
    }

    private boolean disableDynamicWithId(String shortcutId, boolean ignoreInvisible, int disabledReason) {
        ShortcutInfo disabled = this.deleteOrDisableWithId(shortcutId, true, false, ignoreInvisible, disabledReason);
        return disabled == null;
    }

    public void disableWithId(String shortcutId, String disabledMessage, int disabledMessageResId, boolean overrideImmutable, boolean ignoreInvisible, int disabledReason) {
        ShortcutInfo disabled = this.deleteOrDisableWithId(shortcutId, true, overrideImmutable, ignoreInvisible, disabledReason);
        if (disabled != null) {
            if (disabledMessage != null) {
                disabled.setDisabledMessage(disabledMessage);
            } else if (disabledMessageResId != 0) {
                disabled.setDisabledMessageResId(disabledMessageResId);
                this.mShortcutUser.mService.fixUpShortcutResourceNamesAndValues(disabled);
            }
        }
    }

    private ShortcutInfo deleteOrDisableWithId(String shortcutId, boolean disable, boolean overrideImmutable, boolean ignoreInvisible, int disabledReason) {
        Preconditions.checkState(disable == (disabledReason != 0), "disable and disabledReason disagree: " + disable + " vs " + disabledReason);
        ShortcutInfo oldShortcut = this.mShortcuts.get(shortcutId);
        if (oldShortcut == null || !oldShortcut.isEnabled() && ignoreInvisible && !oldShortcut.isVisibleToPublisher()) {
            return null;
        }
        if (!overrideImmutable) {
            this.ensureNotImmutable(oldShortcut, true);
        }
        if (oldShortcut.isPinned()) {
            oldShortcut.setRank(0);
            oldShortcut.clearFlags(33);
            if (disable) {
                oldShortcut.addFlags(64);
                if (oldShortcut.getDisabledReason() == 0) {
                    oldShortcut.setDisabledReason(disabledReason);
                }
            }
            oldShortcut.setTimestamp(this.mShortcutUser.mService.injectCurrentTimeMillis());
            if (this.mShortcutUser.mService.isDummyMainActivity(oldShortcut.getActivity())) {
                oldShortcut.setActivity(null);
            }
            return oldShortcut;
        }
        this.forceDeleteShortcutInner(shortcutId);
        return null;
    }

    public void enableWithId(String shortcutId) {
        ShortcutInfo shortcut = this.mShortcuts.get(shortcutId);
        if (shortcut != null) {
            this.ensureNotImmutable(shortcut, true);
            shortcut.clearFlags(64);
            shortcut.setDisabledReason(0);
        }
    }

    public void updateInvisibleShortcutForPinRequestWith(ShortcutInfo shortcut) {
        ShortcutInfo source = this.mShortcuts.get(shortcut.getId());
        Preconditions.checkNotNull(source);
        this.mShortcutUser.mService.validateShortcutForPinRequest(shortcut);
        shortcut.addFlags(2);
        this.forceReplaceShortcutInner(shortcut);
        this.adjustRanks();
    }

    public void refreshPinnedFlags() {
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            this.mShortcuts.valueAt(i).clearFlags(2);
        }
        this.mShortcutUser.forAllLaunchers(launcherShortcuts -> {
            ArraySet<String> pinned = launcherShortcuts.getPinnedShortcutIds(this.getPackageName(), this.getPackageUserId());
            if (pinned == null || pinned.size() == 0) {
                return;
            }
            for (int i = pinned.size() - 1; i >= 0; --i) {
                String id2 = pinned.valueAt(i);
                ShortcutInfo si = this.mShortcuts.get(id2);
                if (si == null) continue;
                si.addFlags(2);
            }
        });
        this.removeOrphans();
    }

    public int getApiCallCount(boolean unlimited) {
        ShortcutService s = this.mShortcutUser.mService;
        if (s.isUidForegroundLocked(this.mPackageUid) || this.mLastKnownForegroundElapsedTime < s.getUidLastForegroundElapsedTimeLocked(this.mPackageUid) || unlimited) {
            this.mLastKnownForegroundElapsedTime = s.injectElapsedRealtime();
            this.resetRateLimiting();
        }
        long last = s.getLastResetTimeLocked();
        long now = s.injectCurrentTimeMillis();
        if (ShortcutService.isClockValid(now) && this.mLastResetTime > now) {
            Slog.w(TAG, "Clock rewound");
            this.mLastResetTime = now;
            this.mApiCallCount = 0;
            return this.mApiCallCount;
        }
        if (this.mLastResetTime < last) {
            this.mApiCallCount = 0;
            this.mLastResetTime = last;
        }
        return this.mApiCallCount;
    }

    public boolean tryApiCall(boolean unlimited) {
        ShortcutService s = this.mShortcutUser.mService;
        if (this.getApiCallCount(unlimited) >= s.mMaxUpdatesPerInterval) {
            return false;
        }
        ++this.mApiCallCount;
        s.scheduleSaveUser(this.getOwnerUserId());
        return true;
    }

    public void resetRateLimiting() {
        if (this.mApiCallCount > 0) {
            this.mApiCallCount = 0;
            this.mShortcutUser.mService.scheduleSaveUser(this.getOwnerUserId());
        }
    }

    public void resetRateLimitingForCommandLineNoSaving() {
        this.mApiCallCount = 0;
        this.mLastResetTime = 0L;
    }

    public void findAll(List<ShortcutInfo> result, Predicate<ShortcutInfo> query, int cloneFlag) {
        this.findAll(result, query, cloneFlag, null, 0, false);
    }

    public void findAll(List<ShortcutInfo> result, Predicate<ShortcutInfo> query, int cloneFlag, String callingLauncher, int launcherUserId, boolean getPinnedByAnyLauncher) {
        if (this.getPackageInfo().isShadow()) {
            return;
        }
        ShortcutService s = this.mShortcutUser.mService;
        ArraySet<String> pinnedByCallerSet = callingLauncher == null ? null : s.getLauncherShortcutsLocked(callingLauncher, this.getPackageUserId(), launcherUserId).getPinnedShortcutIds(this.getPackageName(), this.getPackageUserId());
        for (int i = 0; i < this.mShortcuts.size(); ++i) {
            boolean isPinnedByCaller;
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            boolean bl = isPinnedByCaller = callingLauncher == null || pinnedByCallerSet != null && pinnedByCallerSet.contains(si.getId());
            if (!getPinnedByAnyLauncher && si.isFloating() && !isPinnedByCaller) continue;
            ShortcutInfo clone = si.clone(cloneFlag);
            if (!getPinnedByAnyLauncher && !isPinnedByCaller) {
                clone.clearFlags(2);
            }
            if (query != null && !query.test(clone)) continue;
            if (!isPinnedByCaller) {
                clone.clearFlags(2);
            }
            result.add(clone);
        }
    }

    public void resetThrottling() {
        this.mApiCallCount = 0;
    }

    public List<ShortcutManager.ShareShortcutInfo> getMatchingShareTargets(IntentFilter filter) {
        ArrayList<ShareTargetInfo> matchedTargets = new ArrayList<ShareTargetInfo>();
        block0: for (int i = 0; i < this.mShareTargets.size(); ++i) {
            ShareTargetInfo target = this.mShareTargets.get(i);
            for (ShareTargetInfo.TargetData data : target.mTargetData) {
                if (!filter.hasDataType(data.mMimeType)) continue;
                matchedTargets.add(target);
                continue block0;
            }
        }
        if (matchedTargets.isEmpty()) {
            return new ArrayList<ShortcutManager.ShareShortcutInfo>();
        }
        ArrayList<ShortcutInfo> shortcuts = new ArrayList<ShortcutInfo>();
        this.findAll(shortcuts, ShortcutInfo::isDynamicVisible, 9);
        ArrayList<ShortcutManager.ShareShortcutInfo> result = new ArrayList<ShortcutManager.ShareShortcutInfo>();
        block2: for (int i = 0; i < shortcuts.size(); ++i) {
            Set<String> categories = shortcuts.get(i).getCategories();
            if (categories == null || categories.isEmpty()) continue;
            for (int j = 0; j < matchedTargets.size(); ++j) {
                boolean hasAllCategories = true;
                ShareTargetInfo target = (ShareTargetInfo)matchedTargets.get(j);
                for (int q = 0; q < target.mCategories.length; ++q) {
                    if (categories.contains(target.mCategories[q])) continue;
                    hasAllCategories = false;
                    break;
                }
                if (!hasAllCategories) continue;
                result.add(new ShortcutManager.ShareShortcutInfo(shortcuts.get(i), new ComponentName(this.getPackageName(), target.mTargetClass)));
                continue block2;
            }
        }
        return result;
    }

    public boolean hasShareTargets() {
        return !this.mShareTargets.isEmpty();
    }

    int getSharingShortcutCount() {
        if (this.mShortcuts.isEmpty() || this.mShareTargets.isEmpty()) {
            return 0;
        }
        ArrayList<ShortcutInfo> shortcuts = new ArrayList<ShortcutInfo>();
        this.findAll(shortcuts, ShortcutInfo::isDynamicVisible, 27);
        int sharingShortcutCount = 0;
        block0: for (int i = 0; i < shortcuts.size(); ++i) {
            Set<String> categories = shortcuts.get(i).getCategories();
            if (categories == null || categories.isEmpty()) continue;
            for (int j = 0; j < this.mShareTargets.size(); ++j) {
                boolean hasAllCategories = true;
                ShareTargetInfo target = this.mShareTargets.get(j);
                for (int q = 0; q < target.mCategories.length; ++q) {
                    if (categories.contains(target.mCategories[q])) continue;
                    hasAllCategories = false;
                    break;
                }
                if (!hasAllCategories) continue;
                ++sharingShortcutCount;
                continue block0;
            }
        }
        return sharingShortcutCount;
    }

    public ArraySet<String> getUsedBitmapFiles() {
        ArraySet<String> usedFiles = new ArraySet<String>(this.mShortcuts.size());
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (si.getBitmapPath() == null) continue;
            usedFiles.add(ShortcutPackage.getFileName(si.getBitmapPath()));
        }
        return usedFiles;
    }

    private static String getFileName(String path) {
        int sep = path.lastIndexOf(File.separatorChar);
        if (sep == -1) {
            return path;
        }
        return path.substring(sep + 1);
    }

    private boolean areAllActivitiesStillEnabled() {
        if (this.mShortcuts.size() == 0) {
            return true;
        }
        ShortcutService s = this.mShortcutUser.mService;
        ArrayList<ComponentName> checked = new ArrayList<ComponentName>(4);
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            ComponentName activity = si.getActivity();
            if (checked.contains(activity)) continue;
            checked.add(activity);
            if (activity == null || s.injectIsActivityEnabledAndExported(activity, this.getOwnerUserId())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rescanPackageIfNeeded(boolean isNewApp, boolean forceRescan) {
        int manifestShortcutSize;
        PackageInfo pi;
        ShortcutService s = this.mShortcutUser.mService;
        long start = s.getStatStartTime();
        try {
            pi = this.mShortcutUser.mService.getPackageInfo(this.getPackageName(), this.getPackageUserId());
            if (pi == null) {
                boolean bl = false;
                return bl;
            }
            if (!isNewApp && !forceRescan && this.getPackageInfo().getVersionCode() == pi.getLongVersionCode() && this.getPackageInfo().getLastUpdateTime() == pi.lastUpdateTime && this.areAllActivitiesStillEnabled()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            s.logDurationStat(14, start);
        }
        List<ShortcutInfo> newManifestShortcutList = null;
        try {
            newManifestShortcutList = ShortcutParser.parseShortcuts(this.mShortcutUser.mService, this.getPackageName(), this.getPackageUserId(), this.mShareTargets);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to load shortcuts from AndroidManifest.xml.", e);
        }
        int n = manifestShortcutSize = newManifestShortcutList == null ? 0 : newManifestShortcutList.size();
        if (isNewApp && manifestShortcutSize == 0) {
            return false;
        }
        this.getPackageInfo().updateFromPackageInfo(pi);
        long newVersionCode = this.getPackageInfo().getVersionCode();
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (si.getDisabledReason() != 100 || this.getPackageInfo().getBackupSourceVersionCode() > newVersionCode) continue;
            Slog.i(TAG, String.format("Restoring shortcut: %s", si.getId()));
            si.clearFlags(64);
            si.setDisabledReason(0);
        }
        if (!isNewApp) {
            Resources publisherRes = null;
            for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
                ShortcutInfo si = this.mShortcuts.valueAt(i);
                if (si.isDynamic()) {
                    if (si.getActivity() == null) {
                        s.wtf("null activity detected.");
                    } else if (!s.injectIsMainActivity(si.getActivity(), this.getPackageUserId())) {
                        Slog.w(TAG, String.format("%s is no longer main activity. Disabling shorcut %s.", this.getPackageName(), si.getId()));
                        if (this.disableDynamicWithId(si.getId(), false, 2)) continue;
                    }
                }
                if (!si.hasAnyResources()) continue;
                if (!si.isOriginallyFromManifest()) {
                    if (publisherRes == null && (publisherRes = this.getPackageResources()) == null) break;
                    si.lookupAndFillInResourceIds(publisherRes);
                }
                si.setTimestamp(s.injectCurrentTimeMillis());
            }
        }
        this.publishManifestShortcuts(newManifestShortcutList);
        if (newManifestShortcutList != null) {
            this.pushOutExcessShortcuts();
        }
        s.verifyStates();
        s.packageShortcutsChanged(this.getPackageName(), this.getPackageUserId());
        return true;
    }

    private boolean publishManifestShortcuts(List<ShortcutInfo> newManifestShortcutList) {
        int i;
        boolean changed = false;
        ArraySet<String> toDisableList = null;
        for (i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (!si.isManifestShortcut()) continue;
            if (toDisableList == null) {
                toDisableList = new ArraySet<String>();
            }
            toDisableList.add(si.getId());
        }
        if (newManifestShortcutList != null) {
            int newListSize = newManifestShortcutList.size();
            for (int i2 = 0; i2 < newListSize; ++i2) {
                changed = true;
                ShortcutInfo newShortcut = newManifestShortcutList.get(i2);
                boolean newDisabled = !newShortcut.isEnabled();
                String id2 = newShortcut.getId();
                ShortcutInfo oldShortcut = this.mShortcuts.get(id2);
                boolean wasPinned = false;
                if (oldShortcut != null) {
                    if (!oldShortcut.isOriginallyFromManifest()) {
                        Slog.e(TAG, "Shortcut with ID=" + newShortcut.getId() + " exists but is not from AndroidManifest.xml, not updating.");
                        continue;
                    }
                    if (oldShortcut.isPinned()) {
                        wasPinned = true;
                        newShortcut.addFlags(2);
                    }
                }
                if (newDisabled && !wasPinned) continue;
                this.forceReplaceShortcutInner(newShortcut);
                if (newDisabled || toDisableList == null) continue;
                toDisableList.remove(id2);
            }
        }
        if (toDisableList != null) {
            for (i = toDisableList.size() - 1; i >= 0; --i) {
                changed = true;
                String id3 = (String)toDisableList.valueAt(i);
                this.disableWithId(id3, null, 0, true, false, 2);
            }
            this.removeOrphans();
        }
        this.adjustRanks();
        return changed;
    }

    private boolean pushOutExcessShortcuts() {
        ShortcutService service = this.mShortcutUser.mService;
        int maxShortcuts = service.getMaxActivityShortcuts();
        boolean changed = false;
        ArrayMap<ComponentName, ArrayList<ShortcutInfo>> all = this.sortShortcutsToActivities();
        for (int outer = all.size() - 1; outer >= 0; --outer) {
            ArrayList<ShortcutInfo> list = all.valueAt(outer);
            if (list.size() <= maxShortcuts) continue;
            Collections.sort(list, this.mShortcutTypeAndRankComparator);
            for (int inner = list.size() - 1; inner >= maxShortcuts; --inner) {
                ShortcutInfo shortcut = list.get(inner);
                if (shortcut.isManifestShortcut()) {
                    service.wtf("Found manifest shortcuts in excess list.");
                    continue;
                }
                this.deleteDynamicWithId(shortcut.getId(), true);
            }
        }
        return changed;
    }

    private ArrayMap<ComponentName, ArrayList<ShortcutInfo>> sortShortcutsToActivities() {
        ArrayMap<ComponentName, ArrayList<ShortcutInfo>> activitiesToShortcuts = new ArrayMap<ComponentName, ArrayList<ShortcutInfo>>();
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (si.isFloating()) continue;
            ComponentName activity = si.getActivity();
            if (activity == null) {
                this.mShortcutUser.mService.wtf("null activity detected.");
                continue;
            }
            ArrayList<ShortcutInfo> list = activitiesToShortcuts.get(activity);
            if (list == null) {
                list = new ArrayList();
                activitiesToShortcuts.put(activity, list);
            }
            list.add(si);
        }
        return activitiesToShortcuts;
    }

    private void incrementCountForActivity(ArrayMap<ComponentName, Integer> counts, ComponentName cn, int increment) {
        Integer oldValue = counts.get(cn);
        if (oldValue == null) {
            oldValue = 0;
        }
        counts.put(cn, oldValue + increment);
    }

    public void enforceShortcutCountsBeforeOperation(List<ShortcutInfo> newList, int operation) {
        int i;
        ShortcutService service = this.mShortcutUser.mService;
        ArrayMap<ComponentName, Integer> counts = new ArrayMap<ComponentName, Integer>(4);
        for (i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo shortcut = this.mShortcuts.valueAt(i);
            if (shortcut.isManifestShortcut()) {
                this.incrementCountForActivity(counts, shortcut.getActivity(), 1);
                continue;
            }
            if (!shortcut.isDynamic() || operation == 0) continue;
            this.incrementCountForActivity(counts, shortcut.getActivity(), 1);
        }
        for (i = newList.size() - 1; i >= 0; --i) {
            ShortcutInfo newShortcut = newList.get(i);
            ComponentName newActivity = newShortcut.getActivity();
            if (newActivity == null) {
                if (operation == 2) continue;
                service.wtf("Activity must not be null at this point");
                continue;
            }
            ShortcutInfo original = this.mShortcuts.get(newShortcut.getId());
            if (original == null) {
                if (operation == 2) continue;
                this.incrementCountForActivity(counts, newActivity, 1);
                continue;
            }
            if (original.isFloating() && operation == 2) continue;
            if (operation != 0) {
                ComponentName oldActivity = original.getActivity();
                if (!original.isFloating()) {
                    this.incrementCountForActivity(counts, oldActivity, -1);
                }
            }
            this.incrementCountForActivity(counts, newActivity, 1);
        }
        for (i = counts.size() - 1; i >= 0; --i) {
            service.enforceMaxActivityShortcuts(counts.valueAt(i));
        }
    }

    public void resolveResourceStrings() {
        ShortcutService s = this.mShortcutUser.mService;
        boolean changed = false;
        Resources publisherRes = null;
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (!si.hasStringResources()) continue;
            changed = true;
            if (publisherRes == null && (publisherRes = this.getPackageResources()) == null) break;
            si.resolveResourceStrings(publisherRes);
            si.setTimestamp(s.injectCurrentTimeMillis());
        }
        if (changed) {
            s.packageShortcutsChanged(this.getPackageName(), this.getPackageUserId());
        }
    }

    public void clearAllImplicitRanks() {
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            si.clearImplicitRankAndRankChangedFlag();
        }
    }

    public void adjustRanks() {
        ShortcutService s = this.mShortcutUser.mService;
        long now = s.injectCurrentTimeMillis();
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (!si.isFloating() || si.getRank() == 0) continue;
            si.setTimestamp(now);
            si.setRank(0);
        }
        ArrayMap<ComponentName, ArrayList<ShortcutInfo>> all = this.sortShortcutsToActivities();
        for (int outer = all.size() - 1; outer >= 0; --outer) {
            ArrayList<ShortcutInfo> list = all.valueAt(outer);
            Collections.sort(list, this.mShortcutRankComparator);
            int rank = 0;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                ShortcutInfo si = list.get(i);
                if (si.isManifestShortcut()) continue;
                if (!si.isDynamic()) {
                    s.wtf("Non-dynamic shortcut found.");
                    continue;
                }
                int thisRank = rank++;
                if (si.getRank() == thisRank) continue;
                si.setTimestamp(now);
                si.setRank(thisRank);
            }
        }
    }

    public boolean hasNonManifestShortcuts() {
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = this.mShortcuts.valueAt(i);
            if (si.isDeclaredInManifest()) continue;
            return true;
        }
        return false;
    }

    public void dump(PrintWriter pw, String prefix, ShortcutService.DumpFilter filter) {
        pw.println();
        pw.print(prefix);
        pw.print("Package: ");
        pw.print(this.getPackageName());
        pw.print("  UID: ");
        pw.print(this.mPackageUid);
        pw.println();
        pw.print(prefix);
        pw.print("  ");
        pw.print("Calls: ");
        pw.print(this.getApiCallCount(false));
        pw.println();
        pw.print(prefix);
        pw.print("  ");
        pw.print("Last known FG: ");
        pw.print(this.mLastKnownForegroundElapsedTime);
        pw.println();
        pw.print(prefix);
        pw.print("  ");
        pw.print("Last reset: [");
        pw.print(this.mLastResetTime);
        pw.print("] ");
        pw.print(ShortcutService.formatTime(this.mLastResetTime));
        pw.println();
        this.getPackageInfo().dump(pw, prefix + "  ");
        pw.println();
        pw.print(prefix);
        pw.println("  Shortcuts:");
        long totalBitmapSize = 0L;
        ArrayMap<String, ShortcutInfo> shortcuts = this.mShortcuts;
        int size = shortcuts.size();
        for (int i = 0; i < size; ++i) {
            ShortcutInfo si = shortcuts.valueAt(i);
            pw.println(si.toDumpString(prefix + "    "));
            if (si.getBitmapPath() == null) continue;
            long len = new File(si.getBitmapPath()).length();
            pw.print(prefix);
            pw.print("      ");
            pw.print("bitmap size=");
            pw.println(len);
            totalBitmapSize += len;
        }
        pw.print(prefix);
        pw.print("  ");
        pw.print("Total bitmap size: ");
        pw.print(totalBitmapSize);
        pw.print(" (");
        pw.print(Formatter.formatFileSize(this.mShortcutUser.mService.mContext, totalBitmapSize));
        pw.println(")");
    }

    @Override
    public JSONObject dumpCheckin(boolean clear) throws JSONException {
        JSONObject result = super.dumpCheckin(clear);
        int numDynamic = 0;
        int numPinned = 0;
        int numManifest = 0;
        int numBitmaps = 0;
        long totalBitmapSize = 0L;
        ArrayMap<String, ShortcutInfo> shortcuts = this.mShortcuts;
        int size = shortcuts.size();
        for (int i = 0; i < size; ++i) {
            ShortcutInfo si = shortcuts.valueAt(i);
            if (si.isDynamic()) {
                ++numDynamic;
            }
            if (si.isDeclaredInManifest()) {
                ++numManifest;
            }
            if (si.isPinned()) {
                ++numPinned;
            }
            if (si.getBitmapPath() == null) continue;
            ++numBitmaps;
            totalBitmapSize += new File(si.getBitmapPath()).length();
        }
        result.put(KEY_DYNAMIC, numDynamic);
        result.put(KEY_MANIFEST, numManifest);
        result.put(KEY_PINNED, numPinned);
        result.put(KEY_BITMAPS, numBitmaps);
        result.put(KEY_BITMAP_BYTES, totalBitmapSize);
        return result;
    }

    @Override
    public void saveToXml(XmlSerializer out, boolean forBackup) throws IOException, XmlPullParserException {
        int j;
        int size = this.mShortcuts.size();
        int shareTargetSize = this.mShareTargets.size();
        if (size == 0 && shareTargetSize == 0 && this.mApiCallCount == 0) {
            return;
        }
        out.startTag(null, TAG_ROOT);
        ShortcutService.writeAttr(out, "name", this.getPackageName());
        ShortcutService.writeAttr(out, ATTR_CALL_COUNT, this.mApiCallCount);
        ShortcutService.writeAttr(out, ATTR_LAST_RESET, this.mLastResetTime);
        this.getPackageInfo().saveToXml(this.mShortcutUser.mService, out, forBackup);
        for (j = 0; j < size; ++j) {
            this.saveShortcut(out, this.mShortcuts.valueAt(j), forBackup, this.getPackageInfo().isBackupAllowed());
        }
        if (!forBackup) {
            for (j = 0; j < shareTargetSize; ++j) {
                this.mShareTargets.get(j).saveToXml(out);
            }
        }
        out.endTag(null, TAG_ROOT);
    }

    private void saveShortcut(XmlSerializer out, ShortcutInfo si, boolean forBackup, boolean appSupportsBackup) throws IOException, XmlPullParserException {
        boolean shouldBackupDetails;
        ShortcutService s = this.mShortcutUser.mService;
        if (!(!forBackup || si.isPinned() && si.isEnabled())) {
            return;
        }
        boolean bl = shouldBackupDetails = !forBackup || appSupportsBackup;
        if (si.isIconPendingSave()) {
            s.removeIconLocked(si);
        }
        out.startTag(null, TAG_SHORTCUT);
        ShortcutService.writeAttr(out, ATTR_ID, si.getId());
        ShortcutService.writeAttr(out, ATTR_ACTIVITY, si.getActivity());
        ShortcutService.writeAttr(out, ATTR_TITLE, si.getTitle());
        ShortcutService.writeAttr(out, ATTR_TITLE_RES_ID, si.getTitleResId());
        ShortcutService.writeAttr(out, ATTR_TITLE_RES_NAME, si.getTitleResName());
        ShortcutService.writeAttr(out, ATTR_TEXT, si.getText());
        ShortcutService.writeAttr(out, ATTR_TEXT_RES_ID, si.getTextResId());
        ShortcutService.writeAttr(out, ATTR_TEXT_RES_NAME, si.getTextResName());
        if (shouldBackupDetails) {
            ShortcutService.writeAttr(out, ATTR_DISABLED_MESSAGE, si.getDisabledMessage());
            ShortcutService.writeAttr(out, ATTR_DISABLED_MESSAGE_RES_ID, si.getDisabledMessageResourceId());
            ShortcutService.writeAttr(out, ATTR_DISABLED_MESSAGE_RES_NAME, si.getDisabledMessageResName());
        }
        ShortcutService.writeAttr(out, ATTR_DISABLED_REASON, si.getDisabledReason());
        ShortcutService.writeAttr(out, ATTR_TIMESTAMP, si.getLastChangedTimestamp());
        LocusId locusId = si.getLocusId();
        if (locusId != null) {
            ShortcutService.writeAttr(out, ATTR_LOCUS_ID, si.getLocusId().getId());
        }
        if (forBackup) {
            int flags = si.getFlags() & 0xFFFFF7F2;
            ShortcutService.writeAttr(out, ATTR_FLAGS, flags);
            long packageVersionCode = this.getPackageInfo().getVersionCode();
            if (packageVersionCode == 0L) {
                s.wtf("Package version code should be available at this point.");
            }
        } else {
            ShortcutService.writeAttr(out, ATTR_RANK, si.getRank());
            ShortcutService.writeAttr(out, ATTR_FLAGS, si.getFlags());
            ShortcutService.writeAttr(out, ATTR_ICON_RES_ID, si.getIconResourceId());
            ShortcutService.writeAttr(out, ATTR_ICON_RES_NAME, si.getIconResName());
            ShortcutService.writeAttr(out, ATTR_BITMAP_PATH, si.getBitmapPath());
        }
        if (shouldBackupDetails) {
            Person[] persons;
            Set<String> cat = si.getCategories();
            if (cat != null && cat.size() > 0) {
                out.startTag(null, "categories");
                XmlUtils.writeStringArrayXml(cat.toArray(new String[cat.size()]), "categories", out);
                out.endTag(null, "categories");
            }
            if (!forBackup && !ArrayUtils.isEmpty(persons = si.getPersons())) {
                for (int i = 0; i < persons.length; ++i) {
                    Person p = persons[i];
                    out.startTag(null, TAG_PERSON);
                    ShortcutService.writeAttr(out, "name", p.getName());
                    ShortcutService.writeAttr(out, ATTR_PERSON_URI, p.getUri());
                    ShortcutService.writeAttr(out, ATTR_PERSON_KEY, p.getKey());
                    ShortcutService.writeAttr(out, ATTR_PERSON_IS_BOT, p.isBot());
                    ShortcutService.writeAttr(out, ATTR_PERSON_IS_IMPORTANT, p.isImportant());
                    out.endTag(null, TAG_PERSON);
                }
            }
            Intent[] intentsNoExtras = si.getIntentsNoExtras();
            PersistableBundle[] intentsExtras = si.getIntentPersistableExtrases();
            int numIntents = intentsNoExtras.length;
            for (int i = 0; i < numIntents; ++i) {
                out.startTag(null, "intent");
                ShortcutService.writeAttr(out, ATTR_INTENT_NO_EXTRA, intentsNoExtras[i]);
                ShortcutService.writeTagExtra(out, TAG_EXTRAS, intentsExtras[i]);
                out.endTag(null, "intent");
            }
            ShortcutService.writeTagExtra(out, TAG_EXTRAS, si.getExtras());
        }
        out.endTag(null, TAG_SHORTCUT);
    }

    public static ShortcutPackage loadFromXml(ShortcutService s, ShortcutUser shortcutUser, XmlPullParser parser, boolean fromBackup) throws IOException, XmlPullParserException {
        int type;
        String packageName = ShortcutService.parseStringAttribute(parser, "name");
        ShortcutPackage ret = new ShortcutPackage(shortcutUser, shortcutUser.getUserId(), packageName);
        ret.mApiCallCount = ShortcutService.parseIntAttribute(parser, ATTR_CALL_COUNT);
        ret.mLastResetTime = ShortcutService.parseLongAttribute(parser, ATTR_LAST_RESET);
        int outerDepth = parser.getDepth();
        block10: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2) continue;
            int depth = parser.getDepth();
            String tag = parser.getName();
            if (depth == outerDepth + 1) {
                switch (tag) {
                    case "package-info": {
                        ret.getPackageInfo().loadFromXml(parser, fromBackup);
                        continue block10;
                    }
                    case "shortcut": {
                        ShortcutInfo si = ShortcutPackage.parseShortcut(parser, packageName, shortcutUser.getUserId(), fromBackup);
                        ret.mShortcuts.put(si.getId(), si);
                        continue block10;
                    }
                    case "share-target": {
                        ret.mShareTargets.add(ShareTargetInfo.loadFromXml(parser));
                        continue block10;
                    }
                }
            }
            ShortcutService.warnForInvalidTag(depth, tag);
        }
        return ret;
    }

    private static ShortcutInfo parseShortcut(XmlPullParser parser, String packageName, int userId, boolean fromBackup) throws IOException, XmlPullParserException {
        int type;
        PersistableBundle intentPersistableExtrasLegacy = null;
        ArrayList<Intent> intents = new ArrayList<Intent>();
        PersistableBundle extras = null;
        ArraySet<String> categories = null;
        ArrayList<Person> persons = new ArrayList<Person>();
        String id2 = ShortcutService.parseStringAttribute(parser, ATTR_ID);
        ComponentName activityComponent = ShortcutService.parseComponentNameAttribute(parser, ATTR_ACTIVITY);
        String title = ShortcutService.parseStringAttribute(parser, ATTR_TITLE);
        int titleResId = ShortcutService.parseIntAttribute(parser, ATTR_TITLE_RES_ID);
        String titleResName = ShortcutService.parseStringAttribute(parser, ATTR_TITLE_RES_NAME);
        String text = ShortcutService.parseStringAttribute(parser, ATTR_TEXT);
        int textResId = ShortcutService.parseIntAttribute(parser, ATTR_TEXT_RES_ID);
        String textResName = ShortcutService.parseStringAttribute(parser, ATTR_TEXT_RES_NAME);
        String disabledMessage = ShortcutService.parseStringAttribute(parser, ATTR_DISABLED_MESSAGE);
        int disabledMessageResId = ShortcutService.parseIntAttribute(parser, ATTR_DISABLED_MESSAGE_RES_ID);
        String disabledMessageResName = ShortcutService.parseStringAttribute(parser, ATTR_DISABLED_MESSAGE_RES_NAME);
        int disabledReason = ShortcutService.parseIntAttribute(parser, ATTR_DISABLED_REASON);
        Intent intentLegacy = ShortcutService.parseIntentAttributeNoDefault(parser, "intent");
        int rank = (int)ShortcutService.parseLongAttribute(parser, ATTR_RANK);
        long lastChangedTimestamp = ShortcutService.parseLongAttribute(parser, ATTR_TIMESTAMP);
        int flags = (int)ShortcutService.parseLongAttribute(parser, ATTR_FLAGS);
        int iconResId = (int)ShortcutService.parseLongAttribute(parser, ATTR_ICON_RES_ID);
        String iconResName = ShortcutService.parseStringAttribute(parser, ATTR_ICON_RES_NAME);
        String bitmapPath = ShortcutService.parseStringAttribute(parser, ATTR_BITMAP_PATH);
        String locusIdString = ShortcutService.parseStringAttribute(parser, ATTR_LOCUS_ID);
        int outerDepth = parser.getDepth();
        block16: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tag;
            if (type != 2) continue;
            int depth = parser.getDepth();
            switch (tag = parser.getName()) {
                case "intent-extras": {
                    intentPersistableExtrasLegacy = PersistableBundle.restoreFromXml(parser);
                    continue block16;
                }
                case "intent": {
                    intents.add(ShortcutPackage.parseIntent(parser));
                    continue block16;
                }
                case "extras": {
                    extras = PersistableBundle.restoreFromXml(parser);
                    continue block16;
                }
                case "categories": {
                    continue block16;
                }
                case "person": {
                    persons.add(ShortcutPackage.parsePerson(parser));
                    continue block16;
                }
                case "string-array": {
                    if (!"categories".equals(ShortcutService.parseStringAttribute(parser, "name"))) continue block16;
                    String[] ar = XmlUtils.readThisStringArrayXml(parser, TAG_STRING_ARRAY_XMLUTILS, null);
                    categories = new ArraySet<String>(ar.length);
                    for (int i = 0; i < ar.length; ++i) {
                        categories.add(ar[i]);
                    }
                    continue block16;
                }
            }
            throw ShortcutService.throwForInvalidTag(depth, tag);
        }
        if (intentLegacy != null) {
            ShortcutInfo.setIntentExtras(intentLegacy, intentPersistableExtrasLegacy);
            intents.clear();
            intents.add(intentLegacy);
        }
        if (disabledReason == 0 && (flags & 0x40) != 0) {
            disabledReason = 1;
        }
        if (fromBackup) {
            flags |= 0x1000;
        }
        LocusId locusId = locusIdString == null ? null : new LocusId(locusIdString);
        return new ShortcutInfo(userId, id2, packageName, activityComponent, null, title, titleResId, titleResName, text, textResId, textResName, disabledMessage, disabledMessageResId, disabledMessageResName, categories, intents.toArray(new Intent[intents.size()]), rank, extras, lastChangedTimestamp, flags, iconResId, iconResName, bitmapPath, disabledReason, persons.toArray(new Person[persons.size()]), locusId);
    }

    private static Intent parseIntent(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        Intent intent = ShortcutService.parseIntentAttribute(parser, ATTR_INTENT_NO_EXTRA);
        int outerDepth = parser.getDepth();
        block6: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tag;
            if (type != 2) continue;
            int depth = parser.getDepth();
            switch (tag = parser.getName()) {
                case "extras": {
                    ShortcutInfo.setIntentExtras(intent, PersistableBundle.restoreFromXml(parser));
                    continue block6;
                }
            }
            throw ShortcutService.throwForInvalidTag(depth, tag);
        }
        return intent;
    }

    private static Person parsePerson(XmlPullParser parser) throws IOException, XmlPullParserException {
        String name = ShortcutService.parseStringAttribute(parser, "name");
        String uri = ShortcutService.parseStringAttribute(parser, ATTR_PERSON_URI);
        String key = ShortcutService.parseStringAttribute(parser, ATTR_PERSON_KEY);
        boolean isBot = ShortcutService.parseBooleanAttribute(parser, ATTR_PERSON_IS_BOT);
        boolean isImportant = ShortcutService.parseBooleanAttribute(parser, ATTR_PERSON_IS_IMPORTANT);
        Person.Builder builder = new Person.Builder();
        builder.setName(name).setUri(uri).setKey(key).setBot(isBot).setImportant(isImportant);
        return builder.build();
    }

    @VisibleForTesting
    List<ShortcutInfo> getAllShortcutsForTest() {
        return new ArrayList<ShortcutInfo>(this.mShortcuts.values());
    }

    @VisibleForTesting
    List<ShareTargetInfo> getAllShareTargetsForTest() {
        return new ArrayList<ShareTargetInfo>(this.mShareTargets);
    }

    @Override
    public void verifyStates() {
        super.verifyStates();
        boolean failed = false;
        ShortcutService s = this.mShortcutUser.mService;
        ArrayMap<ComponentName, ArrayList<ShortcutInfo>> all = this.sortShortcutsToActivities();
        for (int outer = all.size() - 1; outer >= 0; --outer) {
            ArrayList<ShortcutInfo> list = all.valueAt(outer);
            if (list.size() > this.mShortcutUser.mService.getMaxActivityShortcuts()) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": activity " + all.keyAt(outer) + " has " + all.valueAt(outer).size() + " shortcuts.");
            }
            Collections.sort(list, (a, b) -> Integer.compare(a.getRank(), b.getRank()));
            ArrayList<ShortcutInfo> dynamicList = new ArrayList<ShortcutInfo>(list);
            dynamicList.removeIf(si -> !si.isDynamic());
            ArrayList<ShortcutInfo> manifestList = new ArrayList<ShortcutInfo>(list);
            dynamicList.removeIf(si -> !si.isManifestShortcut());
            this.verifyRanksSequential(dynamicList);
            this.verifyRanksSequential(manifestList);
        }
        for (int i = this.mShortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si2 = this.mShortcuts.valueAt(i);
            if (!(si2.isDeclaredInManifest() || si2.isDynamic() || si2.isPinned())) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " is not manifest, dynamic or pinned.");
            }
            if (si2.isDeclaredInManifest() && si2.isDynamic()) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " is both dynamic and manifest at the same time.");
            }
            if (si2.getActivity() == null && !si2.isFloating()) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " has null activity, but not floating.");
            }
            if ((si2.isDynamic() || si2.isManifestShortcut()) && !si2.isEnabled()) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " is not floating, but is disabled.");
            }
            if (si2.isFloating() && si2.getRank() != 0) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " is floating, but has rank=" + si2.getRank());
            }
            if (si2.getIcon() != null) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " still has an icon");
            }
            if (si2.hasAdaptiveBitmap() && !si2.hasIconFile()) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " has adaptive bitmap but was not saved to a file.");
            }
            if (si2.hasIconFile() && si2.hasIconResource()) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " has both resource and bitmap icons");
            }
            if (si2.isEnabled() != (si2.getDisabledReason() == 0)) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " isEnabled() and getDisabledReason() disagree: " + si2.isEnabled() + " vs " + si2.getDisabledReason());
            }
            if (si2.getDisabledReason() == 100 && this.getPackageInfo().getBackupSourceVersionCode() == -1L) {
                failed = true;
                Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " RESTORED_VERSION_LOWER with no backup source version code.");
            }
            if (!s.isDummyMainActivity(si2.getActivity())) continue;
            failed = true;
            Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si2.getId() + " has a dummy target activity");
        }
        if (failed) {
            throw new IllegalStateException("See logcat for errors");
        }
    }

    private boolean verifyRanksSequential(List<ShortcutInfo> list) {
        boolean failed = false;
        for (int i = 0; i < list.size(); ++i) {
            ShortcutInfo si = list.get(i);
            if (si.getRank() == i) continue;
            failed = true;
            Log.e(TAG_VERIFY, "Package " + this.getPackageName() + ": shortcut " + si.getId() + " rank=" + si.getRank() + " but expected to be " + i);
        }
        return failed;
    }
}

