/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.apex.ApexInfo;
import android.apex.ApexInfoList;
import android.apex.ApexSessionInfo;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageParser;
import android.content.pm.ParceledListSlice;
import android.content.pm.Signature;
import android.content.rollback.IRollbackManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;
import android.util.SparseArray;
import android.util.apk.ApkSignatureVerifier;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.server.pm.ApexManager;
import com.android.server.pm.PackageInstallerService;
import com.android.server.pm.PackageInstallerSession;
import com.android.server.pm.PackageManagerServiceUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class StagingManager {
    private static final String TAG = "StagingManager";
    private final PackageInstallerService mPi;
    private final ApexManager mApexManager;
    private final PowerManager mPowerManager;
    private final Handler mBgHandler;
    @GuardedBy(value={"mStagedSessions"})
    private final SparseArray<PackageInstallerSession> mStagedSessions = new SparseArray();

    StagingManager(PackageInstallerService pi, ApexManager am, Context context) {
        this.mPi = pi;
        this.mApexManager = am;
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mBgHandler = BackgroundThread.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStoredSession(PackageInstallerSession sessionInfo) {
        SparseArray<PackageInstallerSession> sparseArray = this.mStagedSessions;
        synchronized (sparseArray) {
            PackageInstallerSession storedSession = this.mStagedSessions.get(sessionInfo.sessionId);
            if (storedSession != null) {
                this.mStagedSessions.put(sessionInfo.sessionId, sessionInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParceledListSlice<PackageInstaller.SessionInfo> getSessions() {
        ArrayList<PackageInstaller.SessionInfo> result = new ArrayList<PackageInstaller.SessionInfo>();
        SparseArray<PackageInstallerSession> sparseArray = this.mStagedSessions;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mStagedSessions.size(); ++i) {
                result.add(this.mStagedSessions.valueAt(i).generateInfo(false));
            }
        }
        return new ParceledListSlice<PackageInstaller.SessionInfo>(result);
    }

    private boolean validateApexSignature(String apexPath, String packageName) {
        PackageParser.SigningDetails existingSigningDetails;
        PackageParser.SigningDetails signingDetails;
        try {
            signingDetails = ApkSignatureVerifier.verify(apexPath, 1);
        }
        catch (PackageParser.PackageParserException e) {
            Slog.e(TAG, "Unable to parse APEX package: " + apexPath, e);
            return false;
        }
        PackageInfo packageInfo = this.mApexManager.getPackageInfoForApexName(packageName);
        if (packageInfo == null) {
            Slog.e(TAG, "Attempted to install a new apex " + packageName + ". Rejecting");
            return false;
        }
        try {
            existingSigningDetails = ApkSignatureVerifier.verify(packageInfo.applicationInfo.sourceDir, 1);
        }
        catch (PackageParser.PackageParserException e) {
            Slog.e(TAG, "Unable to parse APEX package: " + packageInfo.applicationInfo.sourceDir, e);
            return false;
        }
        return Signature.areExactMatch(existingSigningDetails.signatures, signingDetails.signatures);
    }

    private boolean submitSessionToApexService(PackageInstallerSession session, List<PackageInstallerSession> childSessions, ApexInfoList apexInfoList) {
        boolean submittedToApexd = this.mApexManager.submitStagedSession(session.sessionId, childSessions != null ? childSessions.stream().mapToInt(s -> s.sessionId).toArray() : new int[]{}, apexInfoList);
        if (!submittedToApexd) {
            session.setStagedSessionFailed(1, "APEX staging failed, check logcat messages from apexd for more details.");
            return false;
        }
        for (ApexInfo newPackage : apexInfoList.apexInfos) {
            PackageInfo activePackage = this.mApexManager.getPackageInfoForApexName(newPackage.packageName);
            if (activePackage == null) continue;
            long activeVersion = activePackage.applicationInfo.longVersionCode;
            if (session.params.requiredInstalledVersionCode != -1L && activeVersion != session.params.requiredInstalledVersionCode) {
                session.setStagedSessionFailed(1, "Installed version of APEX package " + newPackage.packageName + " does not match required. Active version: " + activeVersion + " required: " + session.params.requiredInstalledVersionCode);
                if (!this.mApexManager.abortActiveSession()) {
                    Slog.e(TAG, "Failed to abort apex session " + session.sessionId);
                }
                return false;
            }
            boolean allowsDowngrade = PackageManagerServiceUtils.isDowngradePermitted(session.params.installFlags, activePackage.applicationInfo.flags);
            if (activeVersion <= newPackage.versionCode || allowsDowngrade) continue;
            session.setStagedSessionFailed(1, "Downgrade of APEX package " + newPackage.packageName + " is not allowed. Active version: " + activeVersion + " attempted: " + newPackage.versionCode);
            if (!this.mApexManager.abortActiveSession()) {
                Slog.e(TAG, "Failed to abort apex session " + session.sessionId);
            }
            return false;
        }
        return true;
    }

    private static boolean isApexSession(PackageInstallerSession session) {
        return (session.params.installFlags & 0x20000) != 0;
    }

    private void preRebootVerification(PackageInstallerSession session) {
        ApexInfo[] childSessions;
        boolean success = true;
        ApexInfoList apexInfoList = new ApexInfoList();
        if (!session.isMultiPackage() && StagingManager.isApexSession(session)) {
            success = this.submitSessionToApexService(session, null, apexInfoList);
        } else if (session.isMultiPackage() && !(childSessions = Arrays.stream(session.getChildSessionIds()).mapToObj(i -> this.mStagedSessions.get(i)).filter(childSession -> StagingManager.isApexSession(childSession)).collect(Collectors.toList())).isEmpty()) {
            success = this.submitSessionToApexService(session, (List<PackageInstallerSession>)childSessions, apexInfoList);
        }
        if (!success) {
            return;
        }
        if (this.sessionContainsApk(session) && !this.installApksInSession(session, true)) {
            session.setStagedSessionFailed(1, "APK verification failed. Check logcat messages for more information.");
            return;
        }
        if (apexInfoList.apexInfos != null && apexInfoList.apexInfos.length > 0) {
            for (ApexInfo apexPackage : apexInfoList.apexInfos) {
                if (this.validateApexSignature(apexPackage.packagePath, apexPackage.packageName)) continue;
                session.setStagedSessionFailed(1, "APK-container signature verification failed for package " + apexPackage.packageName + ". Signature of file " + apexPackage.packagePath + " does not match the signature of  the package already installed.");
                return;
            }
        }
        if ((session.params.installFlags & 0x40000) != 0) {
            IRollbackManager rm = IRollbackManager.Stub.asInterface(ServiceManager.getService("rollback"));
            try {
                if (!rm.notifyStagedSession(session.sessionId)) {
                    Slog.e(TAG, "Unable to enable rollback for session: " + session.sessionId);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        session.setStagedSessionReady();
        if (this.sessionContainsApex(session) && !this.mApexManager.markStagedSessionReady(session.sessionId)) {
            session.setStagedSessionFailed(1, "APEX staging failed, check logcat messages from apexd for more details.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sessionContains(PackageInstallerSession session, Predicate<PackageInstallerSession> filter) {
        if (!session.isMultiPackage()) {
            return filter.test(session);
        }
        SparseArray<PackageInstallerSession> sparseArray = this.mStagedSessions;
        synchronized (sparseArray) {
            return !Arrays.stream(session.getChildSessionIds()).mapToObj(i -> this.mStagedSessions.get(i)).filter(childSession -> filter.test((PackageInstallerSession)childSession)).collect(Collectors.toList()).isEmpty();
        }
    }

    private boolean sessionContainsApex(PackageInstallerSession session) {
        return this.sessionContains(session, s -> StagingManager.isApexSession(s));
    }

    private boolean sessionContainsApk(PackageInstallerSession session) {
        return this.sessionContains(session, s -> !StagingManager.isApexSession(s));
    }

    private void resumeSession(PackageInstallerSession session) {
        boolean hasApex = this.sessionContainsApex(session);
        if (hasApex) {
            ApexSessionInfo apexSessionInfo = this.mApexManager.getStagedSessionInfo(session.sessionId);
            if (apexSessionInfo == null) {
                session.setStagedSessionFailed(2, "apexd did not know anything about a staged session supposed to beactivated");
                return;
            }
            if (StagingManager.isApexSessionFailed(apexSessionInfo)) {
                session.setStagedSessionFailed(2, "APEX activation failed. Check logcat messages from apexd for more information.");
                return;
            }
            if (apexSessionInfo.isVerified) {
                Slog.d(TAG, "Found pending staged session " + session.sessionId + " still to be verified, resuming pre-reboot verification");
                this.mBgHandler.post(() -> this.preRebootVerification(session));
                return;
            }
            if (!apexSessionInfo.isActivated && !apexSessionInfo.isSuccess) {
                Slog.w(TAG, "Staged session " + session.sessionId + " scheduled to be applied at boot didn't activate nor fail. This usually means that apexd will retry at next reboot.");
                return;
            }
        }
        if (!this.installApksInSession(session, false)) {
            session.setStagedSessionFailed(2, "Staged installation of APKs failed. Check logcat messages formore information.");
            if (!hasApex) {
                return;
            }
            if (!this.mApexManager.abortActiveSession()) {
                Slog.e(TAG, "Failed to abort APEXd session");
            } else {
                Slog.e(TAG, "Successfully aborted apexd session. Rebooting device in order to revert to the previous state of APEXd.");
                this.mPowerManager.reboot(null);
            }
            return;
        }
        session.setStagedSessionApplied();
        if (hasApex) {
            this.mApexManager.markStagedSessionSuccessful(session.sessionId);
        }
    }

    private List<String> findAPKsInDir(File stageDir) {
        ArrayList<String> ret = new ArrayList<String>();
        if (stageDir != null && stageDir.exists()) {
            for (File file : stageDir.listFiles()) {
                if (!file.getAbsolutePath().toLowerCase().endsWith(".apk")) continue;
                ret.add(file.getAbsolutePath());
            }
        }
        return ret;
    }

    private PackageInstallerSession createAndWriteApkSession(PackageInstallerSession originalSession, boolean preReboot) {
        if (originalSession.stageDir == null) {
            Slog.wtf(TAG, "Attempting to install a staged APK session with no staging dir");
            return null;
        }
        List<String> apkFilePaths = this.findAPKsInDir(originalSession.stageDir);
        if (apkFilePaths.isEmpty()) {
            Slog.w(TAG, "Can't find staged APK in " + originalSession.stageDir.getAbsolutePath());
            return null;
        }
        PackageInstaller.SessionParams params = originalSession.params.copy();
        params.isStaged = false;
        params.installFlags |= 0x200000;
        if (preReboot) {
            params.installFlags &= 0xFFFBFFFF;
            params.installFlags |= 0x800000;
        } else {
            params.installFlags |= 0x80000;
        }
        int apkSessionId = this.mPi.createSession(params, originalSession.getInstallerPackageName(), 0);
        PackageInstallerSession apkSession = this.mPi.getSession(apkSessionId);
        try {
            apkSession.open();
            for (String apkFilePath : apkFilePaths) {
                File apkFile = new File(apkFilePath);
                ParcelFileDescriptor pfd = ParcelFileDescriptor.open(apkFile, 0x10000000);
                long sizeBytes = pfd.getStatSize();
                if (sizeBytes < 0L) {
                    Slog.e(TAG, "Unable to get size of: " + apkFilePath);
                    return null;
                }
                apkSession.write(apkFile.getName(), 0L, sizeBytes, pfd);
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Failure to install APK staged session " + originalSession.sessionId, e);
            return null;
        }
        return apkSession;
    }

    private boolean commitApkSession(PackageInstallerSession apkSession, int originalSessionId, boolean preReboot) {
        if (!preReboot && (apkSession.params.installFlags & 0x40000) != 0) {
            IRollbackManager rm = IRollbackManager.Stub.asInterface(ServiceManager.getService("rollback"));
            try {
                rm.notifyStagedApkSession(originalSessionId, apkSession.sessionId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        LocalIntentReceiver receiver = new LocalIntentReceiver();
        apkSession.commit(receiver.getIntentSender(), false);
        Intent result = receiver.getResult();
        int status = result.getIntExtra("android.content.pm.extra.STATUS", 1);
        if (status == 0) {
            return true;
        }
        Slog.e(TAG, "Failure to install APK staged session " + originalSessionId + " [" + result.getStringExtra("android.content.pm.extra.STATUS_MESSAGE") + "]");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installApksInSession(PackageInstallerSession session, boolean preReboot) {
        if (!session.isMultiPackage() && !StagingManager.isApexSession(session)) {
            PackageInstallerSession apkSession = this.createAndWriteApkSession(session, preReboot);
            if (apkSession == null) {
                return false;
            }
            return this.commitApkSession(apkSession, session.sessionId, preReboot);
        }
        if (session.isMultiPackage()) {
            List childSessions;
            SparseArray<PackageInstallerSession> sparseArray = this.mStagedSessions;
            synchronized (sparseArray) {
                childSessions = Arrays.stream(session.getChildSessionIds()).mapToObj(i -> this.mStagedSessions.get(i)).filter(childSession -> !StagingManager.isApexSession(childSession)).collect(Collectors.toList());
            }
            if (childSessions.isEmpty()) {
                return true;
            }
            PackageInstaller.SessionParams params = session.params.copy();
            params.isStaged = false;
            if (preReboot) {
                params.installFlags &= 0xFFFBFFFF;
            }
            int apkParentSessionId = this.mPi.createSession(params, session.getInstallerPackageName(), 0);
            PackageInstallerSession apkParentSession = this.mPi.getSession(apkParentSessionId);
            try {
                apkParentSession.open();
            }
            catch (IOException e) {
                Slog.e(TAG, "Unable to prepare multi-package session for staged session " + session.sessionId);
                return false;
            }
            for (PackageInstallerSession sessionToClone : childSessions) {
                PackageInstallerSession apkChildSession = this.createAndWriteApkSession(sessionToClone, preReboot);
                if (apkChildSession == null) {
                    return false;
                }
                try {
                    apkParentSession.addChildSessionId(apkChildSession.sessionId);
                }
                catch (IllegalStateException e) {
                    Slog.e(TAG, "Failed to add a child session for installing the APK files", e);
                    return false;
                }
            }
            return this.commitApkSession(apkParentSession, session.sessionId, preReboot);
        }
        return true;
    }

    void commitSession(PackageInstallerSession session) {
        this.updateStoredSession(session);
        this.mBgHandler.post(() -> this.preRebootVerification(session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageInstallerSession getActiveSession() {
        SparseArray<PackageInstallerSession> sparseArray = this.mStagedSessions;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mStagedSessions.size(); ++i) {
                PackageInstallerSession session = this.mStagedSessions.valueAt(i);
                if (!session.isCommitted() || session.hasParentSessionId() || session.isStagedSessionApplied() || session.isStagedSessionFailed()) continue;
                return session;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSession(PackageInstallerSession sessionInfo) {
        SparseArray<PackageInstallerSession> sparseArray = this.mStagedSessions;
        synchronized (sparseArray) {
            this.mStagedSessions.append(sessionInfo.sessionId, sessionInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortSession(PackageInstallerSession session) {
        SparseArray<PackageInstallerSession> sparseArray = this.mStagedSessions;
        synchronized (sparseArray) {
            this.mStagedSessions.remove(session.sessionId);
        }
    }

    void abortCommittedSession(PackageInstallerSession session) {
        if (session.isStagedSessionApplied()) {
            Slog.w(TAG, "Cannot abort applied session : " + session.sessionId);
            return;
        }
        this.abortSession(session);
        boolean hasApex = this.sessionContainsApex(session);
        if (hasApex) {
            ApexSessionInfo apexSession = this.mApexManager.getStagedSessionInfo(session.sessionId);
            if (apexSession == null || this.isApexSessionFinalized(apexSession)) {
                Slog.w(TAG, "Cannot abort session because it is not active or APEXD is not reachable");
                return;
            }
            this.mApexManager.abortActiveSession();
        }
    }

    private boolean isApexSessionFinalized(ApexSessionInfo session) {
        return session.isUnknown || session.isActivationFailed || session.isSuccess || session.isRolledBack;
    }

    private static boolean isApexSessionFailed(ApexSessionInfo apexSessionInfo) {
        return apexSessionInfo.isActivationFailed || apexSessionInfo.isUnknown || apexSessionInfo.isRolledBack || apexSessionInfo.isRollbackInProgress || apexSessionInfo.isRollbackFailed;
    }

    @GuardedBy(value={"mStagedSessions"})
    private boolean isMultiPackageSessionComplete(PackageInstallerSession session) {
        if (session.isMultiPackage()) {
            for (int childSession : session.getChildSessionIds()) {
                if (this.mStagedSessions.get(childSession) != null) continue;
                return false;
            }
            return true;
        }
        if (session.hasParentSessionId()) {
            PackageInstallerSession parent = this.mStagedSessions.get(session.getParentSessionId());
            if (parent == null) {
                return false;
            }
            return this.isMultiPackageSessionComplete(parent);
        }
        Slog.wtf(TAG, "Attempting to restore an invalid multi-package session.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreSession(PackageInstallerSession session) {
        PackageInstallerSession sessionToResume = session;
        SparseArray<PackageInstallerSession> sparseArray = this.mStagedSessions;
        synchronized (sparseArray) {
            this.mStagedSessions.append(session.sessionId, session);
            if (session.isMultiPackage() || session.hasParentSessionId()) {
                if (!this.isMultiPackageSessionComplete(session)) {
                    return;
                }
                if (session.hasParentSessionId()) {
                    sessionToResume = this.mStagedSessions.get(session.getParentSessionId());
                }
            }
        }
        this.checkStateAndResume(sessionToResume);
    }

    private void checkStateAndResume(PackageInstallerSession session) {
        if (!session.isCommitted()) {
            return;
        }
        if (session.isStagedSessionFailed() || session.isStagedSessionApplied()) {
            return;
        }
        if (!session.isStagedSessionReady()) {
            this.mBgHandler.post(() -> this.preRebootVerification(session));
        } else {
            this.resumeSession(session);
        }
    }

    private static class LocalIntentReceiver {
        private final LinkedBlockingQueue<Intent> mResult = new LinkedBlockingQueue();
        private IIntentSender.Stub mLocalSender = new IIntentSender.Stub(){

            @Override
            public void send(int code, Intent intent, String resolvedType, IBinder whitelistToken, IIntentReceiver finishedReceiver, String requiredPermission, Bundle options) {
                try {
                    mResult.offer(intent, 5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        private LocalIntentReceiver() {
        }

        public IntentSender getIntentSender() {
            return new IntentSender(this.mLocalSender);
        }

        public Intent getResult() {
            try {
                return this.mResult.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

