/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.dex;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageParser;
import android.content.pm.dex.ArtManager;
import android.content.pm.dex.ArtManagerInternal;
import android.content.pm.dex.DexMetadataHelper;
import android.content.pm.dex.IArtManager;
import android.content.pm.dex.ISnapshotRuntimeProfileCallback;
import android.content.pm.dex.PackageOptimizationInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.system.Os;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.pm.Installer;
import com.android.server.pm.PackageManagerServiceCompilerMapping;
import dalvik.system.DexFile;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileNotFoundException;
import libcore.io.IoUtils;

public class ArtManagerService
extends IArtManager.Stub {
    private static final String TAG = "ArtManagerService";
    private static final boolean DEBUG = Log.isLoggable("ArtManagerService", 3);
    private static final String BOOT_IMAGE_ANDROID_PACKAGE = "android";
    private static final String BOOT_IMAGE_PROFILE_NAME = "android.prof";
    private final Context mContext;
    private final IPackageManager mPackageManager;
    private final Object mInstallLock;
    @GuardedBy(value={"mInstallLock"})
    private final Installer mInstaller;
    private final Handler mHandler;
    private static final int TRON_COMPILATION_FILTER_ERROR = 0;
    private static final int TRON_COMPILATION_FILTER_UNKNOWN = 1;
    private static final int TRON_COMPILATION_FILTER_ASSUMED_VERIFIED = 2;
    private static final int TRON_COMPILATION_FILTER_EXTRACT = 3;
    private static final int TRON_COMPILATION_FILTER_VERIFY = 4;
    private static final int TRON_COMPILATION_FILTER_QUICKEN = 5;
    private static final int TRON_COMPILATION_FILTER_SPACE_PROFILE = 6;
    private static final int TRON_COMPILATION_FILTER_SPACE = 7;
    private static final int TRON_COMPILATION_FILTER_SPEED_PROFILE = 8;
    private static final int TRON_COMPILATION_FILTER_SPEED = 9;
    private static final int TRON_COMPILATION_FILTER_EVERYTHING_PROFILE = 10;
    private static final int TRON_COMPILATION_FILTER_EVERYTHING = 11;
    private static final int TRON_COMPILATION_FILTER_FAKE_RUN_FROM_APK = 12;
    private static final int TRON_COMPILATION_FILTER_FAKE_RUN_FROM_APK_FALLBACK = 13;
    private static final int TRON_COMPILATION_FILTER_FAKE_RUN_FROM_VDEX_FALLBACK = 14;
    private static final int TRON_COMPILATION_REASON_ERROR = 0;
    private static final int TRON_COMPILATION_REASON_UNKNOWN = 1;
    private static final int TRON_COMPILATION_REASON_FIRST_BOOT = 2;
    private static final int TRON_COMPILATION_REASON_BOOT = 3;
    private static final int TRON_COMPILATION_REASON_INSTALL = 4;
    private static final int TRON_COMPILATION_REASON_BG_DEXOPT = 5;
    private static final int TRON_COMPILATION_REASON_AB_OTA = 6;
    private static final int TRON_COMPILATION_REASON_INACTIVE = 7;
    private static final int TRON_COMPILATION_REASON_SHARED = 8;
    private static final int TRON_COMPILATION_REASON_INSTALL_WITH_DEX_METADATA = 9;
    public static final String DEXOPT_REASON_WITH_DEX_METADATA_ANNOTATION = "-dm";

    public ArtManagerService(Context context, IPackageManager pm, Installer installer, Object installLock) {
        this.mContext = context;
        this.mPackageManager = pm;
        this.mInstaller = installer;
        this.mInstallLock = installLock;
        this.mHandler = new Handler(BackgroundThread.getHandler().getLooper());
        LocalServices.addService(ArtManagerInternal.class, new ArtManagerInternalImpl());
    }

    private boolean checkAndroidPermissions(int callingUid, String callingPackage) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_RUNTIME_PROFILES", TAG);
        switch (this.mContext.getSystemService(AppOpsManager.class).noteOp(43, callingUid, callingPackage)) {
            case 0: {
                return true;
            }
            case 3: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS", TAG);
                return true;
            }
        }
        return false;
    }

    private boolean checkShellPermissions(int profileType, String packageName, int callingUid) {
        if (callingUid != 2000) {
            return false;
        }
        if (RoSystemProperties.DEBUGGABLE) {
            return true;
        }
        if (profileType == 1) {
            return false;
        }
        PackageInfo info = null;
        try {
            info = this.mPackageManager.getPackageInfo(packageName, 0, 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (info == null) {
            return false;
        }
        return (info.applicationInfo.flags & 2) == 2;
    }

    @Override
    public void snapshotRuntimeProfile(int profileType, String packageName, String codePath, ISnapshotRuntimeProfileCallback callback, String callingPackage) {
        boolean bootImageProfile;
        int callingUid = Binder.getCallingUid();
        if (!this.checkShellPermissions(profileType, packageName, callingUid) && !this.checkAndroidPermissions(callingUid, callingPackage)) {
            try {
                callback.onError(2);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        Preconditions.checkNotNull(callback);
        boolean bl = bootImageProfile = profileType == 1;
        if (!bootImageProfile) {
            Preconditions.checkStringNotEmpty(codePath);
            Preconditions.checkStringNotEmpty(packageName);
        }
        if (!this.isRuntimeProfilingEnabled(profileType, callingPackage)) {
            throw new IllegalStateException("Runtime profiling is not enabled for " + profileType);
        }
        if (DEBUG) {
            Slog.d(TAG, "Requested snapshot for " + packageName + ":" + codePath);
        }
        if (bootImageProfile) {
            this.snapshotBootImageProfile(callback);
        } else {
            this.snapshotAppProfile(packageName, codePath, callback);
        }
    }

    private void snapshotAppProfile(String packageName, String codePath, ISnapshotRuntimeProfileCallback callback) {
        PackageInfo info = null;
        try {
            info = this.mPackageManager.getPackageInfo(packageName, 0, 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (info == null) {
            this.postError(callback, packageName, 0);
            return;
        }
        boolean pathFound = info.applicationInfo.getBaseCodePath().equals(codePath);
        String splitName = null;
        String[] splitCodePaths = info.applicationInfo.getSplitCodePaths();
        if (!pathFound && splitCodePaths != null) {
            for (int i = splitCodePaths.length - 1; i >= 0; --i) {
                if (!splitCodePaths[i].equals(codePath)) continue;
                pathFound = true;
                splitName = info.applicationInfo.splitNames[i];
                break;
            }
        }
        if (!pathFound) {
            this.postError(callback, packageName, 1);
            return;
        }
        int appId = UserHandle.getAppId(info.applicationInfo.uid);
        if (appId < 0) {
            this.postError(callback, packageName, 2);
            Slog.wtf(TAG, "AppId is -1 for package: " + packageName);
            return;
        }
        this.createProfileSnapshot(packageName, ArtManager.getProfileName(splitName), codePath, appId, callback);
        this.destroyProfileSnapshot(packageName, ArtManager.getProfileName(splitName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createProfileSnapshot(String packageName, String profileName, String classpath, int appId, ISnapshotRuntimeProfileCallback callback) {
        Object object = this.mInstallLock;
        synchronized (object) {
            try {
                if (!this.mInstaller.createProfileSnapshot(appId, packageName, profileName, classpath)) {
                    this.postError(callback, packageName, 2);
                    return;
                }
            }
            catch (Installer.InstallerException e) {
                this.postError(callback, packageName, 2);
                return;
            }
        }
        File snapshotProfile = ArtManager.getProfileSnapshotFileForName(packageName, profileName);
        ParcelFileDescriptor fd = null;
        try {
            fd = ParcelFileDescriptor.open(snapshotProfile, 0x10000000);
            if (fd != null && fd.getFileDescriptor().valid()) {
                this.postSuccess(packageName, fd, callback);
                return;
            }
            Slog.wtf(TAG, "ParcelFileDescriptor.open returned an invalid descriptor for " + packageName + ":" + snapshotProfile + ". isNull=" + (fd == null));
            this.postError(callback, packageName, 2);
            return;
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "Could not open snapshot profile for " + packageName + ":" + snapshotProfile, e);
            this.postError(callback, packageName, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyProfileSnapshot(String packageName, String profileName) {
        if (DEBUG) {
            Slog.d(TAG, "Destroying profile snapshot for" + packageName + ":" + profileName);
        }
        Object object = this.mInstallLock;
        synchronized (object) {
            try {
                this.mInstaller.destroyProfileSnapshot(packageName, profileName);
            }
            catch (Installer.InstallerException e) {
                Slog.e(TAG, "Failed to destroy profile snapshot for " + packageName + ":" + profileName, e);
            }
        }
    }

    @Override
    public boolean isRuntimeProfilingEnabled(int profileType, String callingPackage) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 2000 && !this.checkAndroidPermissions(callingUid, callingPackage)) {
            return false;
        }
        switch (profileType) {
            case 0: {
                return SystemProperties.getBoolean("dalvik.vm.usejitprofiles", false);
            }
            case 1: {
                return (Build.IS_USERDEBUG || Build.IS_ENG) && SystemProperties.getBoolean("dalvik.vm.usejitprofiles", false) && SystemProperties.getBoolean("dalvik.vm.profilebootimage", false);
            }
        }
        throw new IllegalArgumentException("Invalid profile type:" + profileType);
    }

    private void snapshotBootImageProfile(ISnapshotRuntimeProfileCallback callback) {
        String classpath = String.join((CharSequence)":", Os.getenv("BOOTCLASSPATH"), Os.getenv("SYSTEMSERVERCLASSPATH"));
        this.createProfileSnapshot(BOOT_IMAGE_ANDROID_PACKAGE, BOOT_IMAGE_PROFILE_NAME, classpath, -1, callback);
        this.destroyProfileSnapshot(BOOT_IMAGE_ANDROID_PACKAGE, BOOT_IMAGE_PROFILE_NAME);
    }

    private void postError(ISnapshotRuntimeProfileCallback callback, String packageName, int errCode) {
        if (DEBUG) {
            Slog.d(TAG, "Failed to snapshot profile for " + packageName + " with error: " + errCode);
        }
        this.mHandler.post(() -> {
            try {
                callback.onError(errCode);
            }
            catch (Exception e) {
                Slog.w(TAG, "Failed to callback after profile snapshot for " + packageName, e);
            }
        });
    }

    private void postSuccess(String packageName, ParcelFileDescriptor fd, ISnapshotRuntimeProfileCallback callback) {
        if (DEBUG) {
            Slog.d(TAG, "Successfully snapshot profile for " + packageName);
        }
        this.mHandler.post(() -> {
            try {
                if (fd.getFileDescriptor().valid()) {
                    callback.onSuccess(fd);
                } else {
                    Slog.wtf(TAG, "The snapshot FD became invalid before posting the result for " + packageName);
                    callback.onError(2);
                }
            }
            catch (Exception e) {
                Slog.w(TAG, "Failed to call onSuccess after profile snapshot for " + packageName, e);
            }
            finally {
                IoUtils.closeQuietly(fd);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareAppProfiles(PackageParser.Package pkg, int user, boolean updateReferenceProfileContent) {
        int appId = UserHandle.getAppId(pkg.applicationInfo.uid);
        if (user < 0) {
            Slog.wtf(TAG, "Invalid user id: " + user);
            return;
        }
        if (appId < 0) {
            Slog.wtf(TAG, "Invalid app id: " + appId);
            return;
        }
        try {
            ArrayMap<String, String> codePathsProfileNames = this.getPackageProfileNames(pkg);
            for (int i = codePathsProfileNames.size() - 1; i >= 0; --i) {
                String codePath = codePathsProfileNames.keyAt(i);
                String profileName = codePathsProfileNames.valueAt(i);
                String dexMetadataPath = null;
                if (updateReferenceProfileContent) {
                    File dexMetadata = DexMetadataHelper.findDexMetadataForFile(new File(codePath));
                    dexMetadataPath = dexMetadata == null ? null : dexMetadata.getAbsolutePath();
                }
                Installer installer = this.mInstaller;
                synchronized (installer) {
                    boolean result = this.mInstaller.prepareAppProfile(pkg.packageName, user, appId, profileName, codePath, dexMetadataPath);
                    if (!result) {
                        Slog.e(TAG, "Failed to prepare profile for " + pkg.packageName + ":" + codePath);
                    }
                    continue;
                }
            }
        }
        catch (Installer.InstallerException e) {
            Slog.e(TAG, "Failed to prepare profile for " + pkg.packageName, e);
        }
    }

    public void prepareAppProfiles(PackageParser.Package pkg, int[] user, boolean updateReferenceProfileContent) {
        for (int i = 0; i < user.length; ++i) {
            this.prepareAppProfiles(pkg, user[i], updateReferenceProfileContent);
        }
    }

    public void clearAppProfiles(PackageParser.Package pkg) {
        try {
            ArrayMap<String, String> packageProfileNames = this.getPackageProfileNames(pkg);
            for (int i = packageProfileNames.size() - 1; i >= 0; --i) {
                String profileName = packageProfileNames.valueAt(i);
                this.mInstaller.clearAppProfiles(pkg.packageName, profileName);
            }
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpProfiles(PackageParser.Package pkg) {
        int sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
        try {
            ArrayMap<String, String> packageProfileNames = this.getPackageProfileNames(pkg);
            for (int i = packageProfileNames.size() - 1; i >= 0; --i) {
                String codePath = packageProfileNames.keyAt(i);
                String profileName = packageProfileNames.valueAt(i);
                Object object = this.mInstallLock;
                synchronized (object) {
                    this.mInstaller.dumpProfiles(sharedGid, pkg.packageName, profileName, codePath);
                    continue;
                }
            }
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, "Failed to dump profiles", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compileLayouts(PackageParser.Package pkg) {
        try {
            String packageName = pkg.packageName;
            String apkPath = pkg.baseCodePath;
            ApplicationInfo appInfo = pkg.applicationInfo;
            String outDexFile = appInfo.dataDir + "/code_cache/compiled_view.dex";
            if (appInfo.isPrivilegedApp()) return false;
            if (appInfo.isEmbeddedDexUsed()) return false;
            if (appInfo.isDefaultToDeviceProtectedStorage()) {
                return false;
            }
            Log.i("PackageManager", "Compiling layouts in " + packageName + " (" + apkPath + ") to " + outDexFile);
            long callingId = Binder.clearCallingIdentity();
            try {
                Object object = this.mInstallLock;
                synchronized (object) {
                    boolean bl = this.mInstaller.compileLayouts(apkPath, packageName, outDexFile, appInfo.uid);
                    return bl;
                }
            }
            finally {
                Binder.restoreCallingIdentity(callingId);
            }
        }
        catch (Throwable e) {
            Log.e("PackageManager", "Failed to compile layouts", e);
            return false;
        }
    }

    private ArrayMap<String, String> getPackageProfileNames(PackageParser.Package pkg) {
        ArrayMap<String, String> result = new ArrayMap<String, String>();
        if ((pkg.applicationInfo.flags & 4) != 0) {
            result.put(pkg.baseCodePath, ArtManager.getProfileName(null));
        }
        if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
            for (int i = 0; i < pkg.splitCodePaths.length; ++i) {
                if ((pkg.splitFlags[i] & 4) == 0) continue;
                result.put(pkg.splitCodePaths[i], ArtManager.getProfileName(pkg.splitNames[i]));
            }
        }
        return result;
    }

    private static int getCompilationReasonTronValue(String compilationReason) {
        switch (compilationReason) {
            case "unknown": {
                return 1;
            }
            case "error": {
                return 0;
            }
            case "first-boot": {
                return 2;
            }
            case "boot": {
                return 3;
            }
            case "install": {
                return 4;
            }
            case "bg-dexopt": {
                return 5;
            }
            case "ab-ota": {
                return 6;
            }
            case "inactive": {
                return 7;
            }
            case "shared": {
                return 8;
            }
            case "install-dm": {
                return 9;
            }
        }
        return 1;
    }

    private static int getCompilationFilterTronValue(String compilationFilter) {
        switch (compilationFilter) {
            case "error": {
                return 0;
            }
            case "unknown": {
                return 1;
            }
            case "assume-verified": {
                return 2;
            }
            case "extract": {
                return 3;
            }
            case "verify": {
                return 4;
            }
            case "quicken": {
                return 5;
            }
            case "space-profile": {
                return 6;
            }
            case "space": {
                return 7;
            }
            case "speed-profile": {
                return 8;
            }
            case "speed": {
                return 9;
            }
            case "everything-profile": {
                return 10;
            }
            case "everything": {
                return 11;
            }
            case "run-from-apk": {
                return 12;
            }
            case "run-from-apk-fallback": {
                return 13;
            }
            case "run-from-vdex-fallback": {
                return 14;
            }
        }
        return 1;
    }

    private static void verifyTronLoggingConstants() {
        for (int i = 0; i < PackageManagerServiceCompilerMapping.REASON_STRINGS.length; ++i) {
            String reason = PackageManagerServiceCompilerMapping.REASON_STRINGS[i];
            int value = ArtManagerService.getCompilationReasonTronValue(reason);
            if (value != 0 && value != 1) continue;
            throw new IllegalArgumentException("Compilation reason not configured for TRON logging: " + reason);
        }
    }

    static {
        ArtManagerService.verifyTronLoggingConstants();
    }

    private class ArtManagerInternalImpl
    extends ArtManagerInternal {
        private ArtManagerInternalImpl() {
        }

        @Override
        public PackageOptimizationInfo getPackageOptimizationInfo(ApplicationInfo info, String abi) {
            String compilationReason;
            String compilationFilter;
            try {
                String isa = VMRuntime.getInstructionSet(abi);
                DexFile.OptimizationInfo optInfo = DexFile.getDexFileOptimizationInfo(info.getBaseCodePath(), isa);
                compilationFilter = optInfo.getStatus();
                compilationReason = optInfo.getReason();
            }
            catch (FileNotFoundException e) {
                Slog.e(ArtManagerService.TAG, "Could not get optimizations status for " + info.getBaseCodePath(), e);
                compilationFilter = "error";
                compilationReason = "error";
            }
            catch (IllegalArgumentException e) {
                Slog.wtf(ArtManagerService.TAG, "Requested optimization status for " + info.getBaseCodePath() + " due to an invalid abi " + abi, e);
                compilationFilter = "error";
                compilationReason = "error";
            }
            int compilationFilterTronValue = ArtManagerService.getCompilationFilterTronValue(compilationFilter);
            int compilationReasonTronValue = ArtManagerService.getCompilationReasonTronValue(compilationReason);
            return new PackageOptimizationInfo(compilationFilterTronValue, compilationReasonTronValue);
        }
    }
}

