/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.dex;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.os.FileUtils;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.DeviceConfig;
import android.util.Log;
import android.util.Slog;
import android.util.jar.StrictJarFile;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.pm.Installer;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageManagerServiceUtils;
import com.android.server.pm.dex.DexoptOptions;
import com.android.server.pm.dex.DexoptUtils;
import com.android.server.pm.dex.DynamicCodeLogger;
import com.android.server.pm.dex.PackageDexUsage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;

public class DexManager {
    private static final String TAG = "DexManager";
    private static final String PROPERTY_NAME_PM_DEXOPT_PRIV_APPS_OOB = "pm.dexopt.priv-apps-oob";
    private static final String PROPERTY_NAME_PM_DEXOPT_PRIV_APPS_OOB_LIST = "pm.dexopt.priv-apps-oob-list";
    private static final String PRIV_APPS_OOB_ENABLED = "priv_apps_oob_enabled";
    private static final String PRIV_APPS_OOB_WHITELIST = "priv_apps_oob_whitelist";
    private static final boolean DEBUG = Log.isLoggable("DexManager", 3);
    private final Context mContext;
    @GuardedBy(value={"mPackageCodeLocationsCache"})
    private final Map<String, PackageCodeLocations> mPackageCodeLocationsCache;
    private final PackageDexUsage mPackageDexUsage;
    private final DynamicCodeLogger mDynamicCodeLogger;
    private final IPackageManager mPackageManager;
    private final PackageDexOptimizer mPackageDexOptimizer;
    private final Object mInstallLock;
    @GuardedBy(value={"mInstallLock"})
    private final Installer mInstaller;
    private static int DEX_SEARCH_NOT_FOUND = 0;
    private static int DEX_SEARCH_FOUND_PRIMARY = 1;
    private static int DEX_SEARCH_FOUND_SPLIT = 2;
    private static int DEX_SEARCH_FOUND_SECONDARY = 3;
    private static final PackageDexUsage.PackageUseInfo DEFAULT_USE_INFO = new PackageDexUsage.PackageUseInfo();

    public DexManager(Context context, IPackageManager pms, PackageDexOptimizer pdo, Installer installer, Object installLock) {
        this.mContext = context;
        this.mPackageCodeLocationsCache = new HashMap<String, PackageCodeLocations>();
        this.mPackageDexUsage = new PackageDexUsage();
        this.mPackageManager = pms;
        this.mPackageDexOptimizer = pdo;
        this.mInstaller = installer;
        this.mInstallLock = installLock;
        this.mDynamicCodeLogger = new DynamicCodeLogger(pms, installer);
    }

    public DynamicCodeLogger getDynamicCodeLogger() {
        return this.mDynamicCodeLogger;
    }

    public void notifyDexLoad(ApplicationInfo loadingAppInfo, List<String> classLoadersNames, List<String> classPaths, String loaderIsa, int loaderUserId) {
        try {
            this.notifyDexLoadInternal(loadingAppInfo, classLoadersNames, classPaths, loaderIsa, loaderUserId);
        }
        catch (Exception e) {
            Slog.w(TAG, "Exception while notifying dex load for package " + loadingAppInfo.packageName, e);
        }
    }

    @VisibleForTesting
    void notifyDexLoadInternal(ApplicationInfo loadingAppInfo, List<String> classLoaderNames, List<String> classPaths, String loaderIsa, int loaderUserId) {
        if (classLoaderNames.size() != classPaths.size()) {
            Slog.wtf(TAG, "Bad call to noitfyDexLoad: args have different size");
            return;
        }
        if (classLoaderNames.isEmpty()) {
            Slog.wtf(TAG, "Bad call to notifyDexLoad: class loaders list is empty");
            return;
        }
        if (!PackageManagerServiceUtils.checkISA(loaderIsa)) {
            Slog.w(TAG, "Loading dex files " + classPaths + " in unsupported ISA: " + loaderIsa + "?");
            return;
        }
        String firstClassPath = classPaths.get(0);
        if (firstClassPath == null) {
            return;
        }
        String[] dexPathsToRegister = firstClassPath.split(File.pathSeparator);
        String[] classLoaderContexts = DexoptUtils.processContextForDexLoad(classLoaderNames, classPaths);
        if (classLoaderContexts == null && DEBUG) {
            Slog.i(TAG, loadingAppInfo.packageName + " uses unsupported class loader in " + classLoaderNames);
        }
        int dexPathIndex = 0;
        for (String dexPath : dexPathsToRegister) {
            DexSearchResult searchResult = this.getDexPackage(loadingAppInfo, dexPath, loaderUserId);
            if (DEBUG) {
                Slog.i(TAG, loadingAppInfo.packageName + " loads from " + searchResult + " : " + loaderUserId + " : " + dexPath);
            }
            if (searchResult.mOutcome != DEX_SEARCH_NOT_FOUND) {
                boolean primaryOrSplit;
                boolean isUsedByOtherApps = !loadingAppInfo.packageName.equals(searchResult.mOwningPackageName);
                boolean bl = primaryOrSplit = searchResult.mOutcome == DEX_SEARCH_FOUND_PRIMARY || searchResult.mOutcome == DEX_SEARCH_FOUND_SPLIT;
                if (primaryOrSplit && !isUsedByOtherApps) continue;
                if (!primaryOrSplit) {
                    this.mDynamicCodeLogger.recordDex(loaderUserId, dexPath, searchResult.mOwningPackageName, loadingAppInfo.packageName);
                }
                if (classLoaderContexts != null) {
                    String classLoaderContext = classLoaderContexts[dexPathIndex];
                    if (this.mPackageDexUsage.record(searchResult.mOwningPackageName, dexPath, loaderUserId, loaderIsa, isUsedByOtherApps, primaryOrSplit, loadingAppInfo.packageName, classLoaderContext)) {
                        this.mPackageDexUsage.maybeWriteAsync();
                    }
                }
            } else if (DEBUG) {
                Slog.i(TAG, "Could not find owning package for dex file: " + dexPath);
            }
            ++dexPathIndex;
        }
    }

    public void load(Map<Integer, List<PackageInfo>> existingPackages) {
        try {
            this.loadInternal(existingPackages);
        }
        catch (Exception e) {
            this.mPackageDexUsage.clear();
            this.mDynamicCodeLogger.clear();
            Slog.w(TAG, "Exception while loading. Starting with a fresh state.", e);
        }
    }

    public void notifyPackageInstalled(PackageInfo pi, int userId) {
        if (userId == -1) {
            throw new IllegalArgumentException("notifyPackageInstalled called with USER_ALL");
        }
        this.cachePackageInfo(pi, userId);
    }

    public void notifyPackageUpdated(String packageName, String baseCodePath, String[] splitCodePaths) {
        this.cachePackageCodeLocation(packageName, baseCodePath, splitCodePaths, null, -1);
        if (this.mPackageDexUsage.clearUsedByOtherApps(packageName)) {
            this.mPackageDexUsage.maybeWriteAsync();
        }
    }

    public void notifyPackageDataDestroyed(String packageName, int userId) {
        if (userId == -1) {
            if (this.mPackageDexUsage.removePackage(packageName)) {
                this.mPackageDexUsage.maybeWriteAsync();
            }
            this.mDynamicCodeLogger.removePackage(packageName);
        } else {
            if (this.mPackageDexUsage.removeUserPackage(packageName, userId)) {
                this.mPackageDexUsage.maybeWriteAsync();
            }
            this.mDynamicCodeLogger.removeUserPackage(packageName, userId);
        }
    }

    private void cachePackageInfo(PackageInfo pi, int userId) {
        ApplicationInfo ai = pi.applicationInfo;
        String[] dataDirs = new String[]{ai.dataDir, ai.deviceProtectedDataDir, ai.credentialProtectedDataDir};
        this.cachePackageCodeLocation(pi.packageName, ai.sourceDir, ai.splitSourceDirs, dataDirs, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachePackageCodeLocation(String packageName, String baseCodePath, String[] splitCodePaths, String[] dataDirs, int userId) {
        Map<String, PackageCodeLocations> map = this.mPackageCodeLocationsCache;
        synchronized (map) {
            PackageCodeLocations pcl = DexManager.putIfAbsent(this.mPackageCodeLocationsCache, packageName, new PackageCodeLocations(packageName, baseCodePath, splitCodePaths));
            pcl.updateCodeLocation(baseCodePath, splitCodePaths);
            if (dataDirs != null) {
                for (String dataDir : dataDirs) {
                    if (dataDir == null) continue;
                    pcl.mergeAppDataDirs(dataDir, userId);
                }
            }
        }
    }

    private void loadInternal(Map<Integer, List<PackageInfo>> existingPackages) {
        HashMap<String, Set<Integer>> packageToUsersMap = new HashMap<String, Set<Integer>>();
        HashMap<String, Set<String>> packageToCodePaths = new HashMap<String, Set<String>>();
        for (Map.Entry<Integer, List<PackageInfo>> entry : existingPackages.entrySet()) {
            List<PackageInfo> packageInfoList = entry.getValue();
            int userId = entry.getKey();
            for (PackageInfo pi : packageInfoList) {
                this.cachePackageInfo(pi, userId);
                Set users = DexManager.putIfAbsent(packageToUsersMap, pi.packageName, new HashSet());
                users.add(userId);
                Set codePaths = DexManager.putIfAbsent(packageToCodePaths, pi.packageName, new HashSet());
                codePaths.add(pi.applicationInfo.sourceDir);
                if (pi.applicationInfo.splitSourceDirs == null) continue;
                Collections.addAll(codePaths, pi.applicationInfo.splitSourceDirs);
            }
        }
        try {
            this.mPackageDexUsage.read();
            this.mPackageDexUsage.syncData(packageToUsersMap, packageToCodePaths);
        }
        catch (Exception e) {
            this.mPackageDexUsage.clear();
            Slog.w(TAG, "Exception while loading package dex usage. Starting with a fresh state.", e);
        }
        try {
            this.mDynamicCodeLogger.readAndSync(packageToUsersMap);
        }
        catch (Exception e) {
            this.mDynamicCodeLogger.clear();
            Slog.w(TAG, "Exception while loading package dynamic code usage. Starting with a fresh state.", e);
        }
    }

    public PackageDexUsage.PackageUseInfo getPackageUseInfoOrDefault(String packageName) {
        PackageDexUsage.PackageUseInfo useInfo = this.mPackageDexUsage.getPackageUseInfo(packageName);
        return useInfo == null ? DEFAULT_USE_INFO : useInfo;
    }

    @VisibleForTesting
    boolean hasInfoOnPackage(String packageName) {
        return this.mPackageDexUsage.getPackageUseInfo(packageName) != null;
    }

    public boolean dexoptSecondaryDex(DexoptOptions options) {
        PackageDexOptimizer pdo = options.isForce() ? new PackageDexOptimizer.ForcedUpdatePackageDexOptimizer(this.mPackageDexOptimizer) : this.mPackageDexOptimizer;
        String packageName = options.getPackageName();
        PackageDexUsage.PackageUseInfo useInfo = this.getPackageUseInfoOrDefault(packageName);
        if (useInfo.getDexUseInfoMap().isEmpty()) {
            if (DEBUG) {
                Slog.d(TAG, "No secondary dex use for package:" + packageName);
            }
            return true;
        }
        boolean success = true;
        for (Map.Entry<String, PackageDexUsage.DexUseInfo> entry : useInfo.getDexUseInfoMap().entrySet()) {
            PackageInfo pkg;
            String dexPath = entry.getKey();
            PackageDexUsage.DexUseInfo dexUseInfo = entry.getValue();
            try {
                pkg = this.mPackageManager.getPackageInfo(packageName, 0, dexUseInfo.getOwnerUserId());
            }
            catch (RemoteException e) {
                throw new AssertionError((Object)e);
            }
            if (pkg == null) {
                Slog.d(TAG, "Could not find package when compiling secondary dex " + packageName + " for user " + dexUseInfo.getOwnerUserId());
                this.mPackageDexUsage.removeUserPackage(packageName, dexUseInfo.getOwnerUserId());
                continue;
            }
            int result = pdo.dexOptSecondaryDexPath(pkg.applicationInfo, dexPath, dexUseInfo, options);
            success = success && result != -1;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileSecondaryDexFiles(String packageName) {
        PackageDexUsage.PackageUseInfo useInfo = this.getPackageUseInfoOrDefault(packageName);
        if (useInfo.getDexUseInfoMap().isEmpty()) {
            if (DEBUG) {
                Slog.d(TAG, "No secondary dex use for package:" + packageName);
            }
            return;
        }
        boolean updated = false;
        for (Map.Entry<String, PackageDexUsage.DexUseInfo> entry : useInfo.getDexUseInfoMap().entrySet()) {
            String dexPath = entry.getKey();
            PackageDexUsage.DexUseInfo dexUseInfo = entry.getValue();
            PackageInfo pkg = null;
            try {
                pkg = this.mPackageManager.getPackageInfo(packageName, 0, dexUseInfo.getOwnerUserId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (pkg == null) {
                Slog.d(TAG, "Could not find package when compiling secondary dex " + packageName + " for user " + dexUseInfo.getOwnerUserId());
                updated = this.mPackageDexUsage.removeUserPackage(packageName, dexUseInfo.getOwnerUserId()) || updated;
                continue;
            }
            ApplicationInfo info = pkg.applicationInfo;
            int flags = 0;
            if (info.deviceProtectedDataDir != null && FileUtils.contains(info.deviceProtectedDataDir, dexPath)) {
                flags |= 1;
            } else if (info.credentialProtectedDataDir != null && FileUtils.contains(info.credentialProtectedDataDir, dexPath)) {
                flags |= 2;
            } else {
                Slog.e(TAG, "Could not infer CE/DE storage for path " + dexPath);
                updated = this.mPackageDexUsage.removeDexFile(packageName, dexPath, dexUseInfo.getOwnerUserId()) || updated;
                continue;
            }
            boolean dexStillExists = true;
            Object object = this.mInstallLock;
            synchronized (object) {
                try {
                    String[] isas = dexUseInfo.getLoaderIsas().toArray(new String[0]);
                    dexStillExists = this.mInstaller.reconcileSecondaryDexFile(dexPath, packageName, info.uid, isas, info.volumeUuid, flags);
                }
                catch (Installer.InstallerException e) {
                    Slog.e(TAG, "Got InstallerException when reconciling dex " + dexPath + " : " + e.getMessage());
                }
            }
            if (dexStillExists) continue;
            updated = this.mPackageDexUsage.removeDexFile(packageName, dexPath, dexUseInfo.getOwnerUserId()) || updated;
        }
        if (updated) {
            this.mPackageDexUsage.maybeWriteAsync();
        }
    }

    public RegisterDexModuleResult registerDexModule(ApplicationInfo info, String dexPath, boolean isUsedByOtherApps, int userId) {
        DexoptOptions options;
        PackageDexUsage.DexUseInfo dexUseInfo;
        int result;
        DexSearchResult searchResult = this.getDexPackage(info, dexPath, userId);
        if (searchResult.mOutcome == DEX_SEARCH_NOT_FOUND) {
            return new RegisterDexModuleResult(false, "Package not found");
        }
        if (!info.packageName.equals(searchResult.mOwningPackageName)) {
            return new RegisterDexModuleResult(false, "Dex path does not belong to package");
        }
        if (searchResult.mOutcome == DEX_SEARCH_FOUND_PRIMARY || searchResult.mOutcome == DEX_SEARCH_FOUND_SPLIT) {
            return new RegisterDexModuleResult(false, "Main apks cannot be registered");
        }
        boolean update = false;
        for (String isa : InstructionSets.getAppDexInstructionSets(info)) {
            boolean newUpdate = this.mPackageDexUsage.record(searchResult.mOwningPackageName, dexPath, userId, isa, isUsedByOtherApps, false, searchResult.mOwningPackageName, "=UnknownClassLoaderContext=");
            update |= newUpdate;
        }
        if (update) {
            this.mPackageDexUsage.maybeWriteAsync();
        }
        if ((result = this.mPackageDexOptimizer.dexOptSecondaryDexPath(info, dexPath, dexUseInfo = this.mPackageDexUsage.getPackageUseInfo(searchResult.mOwningPackageName).getDexUseInfoMap().get(dexPath), options = new DexoptOptions(info.packageName, 2, 0))) != -1) {
            Slog.e(TAG, "Failed to optimize dex module " + dexPath);
        }
        return new RegisterDexModuleResult(true, "Dex module registered successfully");
    }

    public Set<String> getAllPackagesWithSecondaryDexFiles() {
        return this.mPackageDexUsage.getAllPackagesWithSecondaryDexFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DexSearchResult getDexPackage(ApplicationInfo loadingAppInfo, String dexPath, int userId) {
        if (dexPath.startsWith("/system/framework/")) {
            return new DexSearchResult("framework", DEX_SEARCH_NOT_FOUND);
        }
        PackageCodeLocations loadingPackageCodeLocations = new PackageCodeLocations(loadingAppInfo, userId);
        int outcome = loadingPackageCodeLocations.searchDex(dexPath, userId);
        if (outcome != DEX_SEARCH_NOT_FOUND) {
            return new DexSearchResult(loadingPackageCodeLocations.mPackageName, outcome);
        }
        Map<String, PackageCodeLocations> map = this.mPackageCodeLocationsCache;
        synchronized (map) {
            for (PackageCodeLocations pcl : this.mPackageCodeLocationsCache.values()) {
                outcome = pcl.searchDex(dexPath, userId);
                if (outcome == DEX_SEARCH_NOT_FOUND) continue;
                return new DexSearchResult(pcl.mPackageName, outcome);
            }
        }
        if (!DEBUG) return new DexSearchResult(null, DEX_SEARCH_NOT_FOUND);
        try {
            String dexPathReal = PackageManagerServiceUtils.realpath(new File(dexPath));
            if (dexPath.equals(dexPathReal)) return new DexSearchResult(null, DEX_SEARCH_NOT_FOUND);
            Slog.d(TAG, "Dex loaded with symlink. dexPath=" + dexPath + " dexPathReal=" + dexPathReal);
            return new DexSearchResult(null, DEX_SEARCH_NOT_FOUND);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new DexSearchResult(null, DEX_SEARCH_NOT_FOUND);
    }

    private static <K, V> V putIfAbsent(Map<K, V> map, K key, V newValue) {
        V existingValue = map.putIfAbsent(key, newValue);
        return existingValue == null ? newValue : existingValue;
    }

    public void writePackageDexUsageNow() {
        this.mPackageDexUsage.writeNow();
        this.mDynamicCodeLogger.writeNow();
    }

    public static boolean isPackageSelectedToRunOob(String packageName) {
        return DexManager.isPackageSelectedToRunOob(Arrays.asList(packageName));
    }

    public static boolean isPackageSelectedToRunOob(Collection<String> packageNamesInSameProcess) {
        return DexManager.isPackageSelectedToRunOobInternal(SystemProperties.getBoolean(PROPERTY_NAME_PM_DEXOPT_PRIV_APPS_OOB, false), SystemProperties.get(PROPERTY_NAME_PM_DEXOPT_PRIV_APPS_OOB_LIST, "ALL"), DeviceConfig.getProperty("dex_boot", PRIV_APPS_OOB_ENABLED), DeviceConfig.getProperty("dex_boot", PRIV_APPS_OOB_WHITELIST), packageNamesInSameProcess);
    }

    @VisibleForTesting
    static boolean isPackageSelectedToRunOobInternal(boolean isDefaultEnabled, String defaultWhitelist, String overrideEnabled, String overrideWhitelist, Collection<String> packageNamesInSameProcess) {
        String whitelist;
        boolean enabled;
        boolean bl = enabled = overrideEnabled != null ? overrideEnabled.equals("true") : isDefaultEnabled;
        if (!enabled) {
            return false;
        }
        String string2 = whitelist = overrideWhitelist != null ? overrideWhitelist : defaultWhitelist;
        if ("ALL".equals(whitelist)) {
            return true;
        }
        for (String oobPkgName : whitelist.split(",")) {
            if (!packageNamesInSameProcess.contains(oobPkgName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean auditUncompressedDexInApk(String fileName) {
        StrictJarFile jarFile = null;
        try {
            jarFile = new StrictJarFile(fileName, false, false);
            Iterator<ZipEntry> it = jarFile.iterator();
            boolean allCorrect = true;
            while (it.hasNext()) {
                ZipEntry entry = it.next();
                if (!entry.getName().endsWith(".dex")) continue;
                if (entry.getMethod() != 0) {
                    allCorrect = false;
                    Slog.w(TAG, "APK " + fileName + " has compressed dex code " + entry.getName());
                    continue;
                }
                if ((entry.getDataOffset() & 3L) == 0L) continue;
                allCorrect = false;
                Slog.w(TAG, "APK " + fileName + " has unaligned dex code " + entry.getName());
            }
            boolean bl = allCorrect;
            return bl;
        }
        catch (IOException ignore) {
            Slog.wtf(TAG, "Error when parsing APK " + fileName);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private class DexSearchResult {
        private String mOwningPackageName;
        private int mOutcome;

        public DexSearchResult(String owningPackageName, int outcome) {
            this.mOwningPackageName = owningPackageName;
            this.mOutcome = outcome;
        }

        public String toString() {
            return this.mOwningPackageName + "-" + this.mOutcome;
        }
    }

    private static class PackageCodeLocations {
        private final String mPackageName;
        private String mBaseCodePath;
        private final Set<String> mSplitCodePaths;
        private final Map<Integer, Set<String>> mAppDataDirs;

        public PackageCodeLocations(ApplicationInfo ai, int userId) {
            this(ai.packageName, ai.sourceDir, ai.splitSourceDirs);
            this.mergeAppDataDirs(ai.dataDir, userId);
        }

        public PackageCodeLocations(String packageName, String baseCodePath, String[] splitCodePaths) {
            this.mPackageName = packageName;
            this.mSplitCodePaths = new HashSet<String>();
            this.mAppDataDirs = new HashMap<Integer, Set<String>>();
            this.updateCodeLocation(baseCodePath, splitCodePaths);
        }

        public void updateCodeLocation(String baseCodePath, String[] splitCodePaths) {
            this.mBaseCodePath = baseCodePath;
            this.mSplitCodePaths.clear();
            if (splitCodePaths != null) {
                for (String split : splitCodePaths) {
                    this.mSplitCodePaths.add(split);
                }
            }
        }

        public void mergeAppDataDirs(String dataDir, int userId) {
            Set dataDirs = (Set)DexManager.putIfAbsent(this.mAppDataDirs, userId, new HashSet());
            dataDirs.add(dataDir);
        }

        public int searchDex(String dexPath, int userId) {
            Set<String> userDataDirs = this.mAppDataDirs.get(userId);
            if (userDataDirs == null) {
                return DEX_SEARCH_NOT_FOUND;
            }
            if (this.mBaseCodePath.equals(dexPath)) {
                return DEX_SEARCH_FOUND_PRIMARY;
            }
            if (this.mSplitCodePaths.contains(dexPath)) {
                return DEX_SEARCH_FOUND_SPLIT;
            }
            for (String dataDir : userDataDirs) {
                if (!dexPath.startsWith(dataDir)) continue;
                return DEX_SEARCH_FOUND_SECONDARY;
            }
            return DEX_SEARCH_NOT_FOUND;
        }
    }

    public static class RegisterDexModuleResult {
        public final boolean success;
        public final String message;

        public RegisterDexModuleResult() {
            this(false, null);
        }

        public RegisterDexModuleResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }
    }
}

