/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.dex;

import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.os.FileUtils;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ByteStringUtils;
import android.util.EventLog;
import android.util.PackageUtils;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.pm.Installer;
import com.android.server.pm.dex.PackageDynamicCodeLoading;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class DynamicCodeLogger {
    private static final String TAG = "DynamicCodeLogger";
    private static final int SNET_TAG = 1397638484;
    private static final String DCL_DEX_SUBTAG = "dcl";
    private static final String DCL_NATIVE_SUBTAG = "dcln";
    private final IPackageManager mPackageManager;
    private final PackageDynamicCodeLoading mPackageDynamicCodeLoading;
    private final Installer mInstaller;

    DynamicCodeLogger(IPackageManager pms, Installer installer) {
        this(pms, installer, new PackageDynamicCodeLoading());
    }

    @VisibleForTesting
    DynamicCodeLogger(IPackageManager pms, Installer installer, PackageDynamicCodeLoading packageDynamicCodeLoading) {
        this.mPackageManager = pms;
        this.mPackageDynamicCodeLoading = packageDynamicCodeLoading;
        this.mInstaller = installer;
    }

    public Set<String> getAllPackagesWithDynamicCodeLoading() {
        return this.mPackageDynamicCodeLoading.getAllPackagesWithDynamicCodeLoading();
    }

    public void logDynamicCodeLoading(String packageName) {
        PackageDynamicCodeLoading.PackageDynamicCode info = this.getPackageDynamicCodeInfo(packageName);
        if (info == null) {
            return;
        }
        SparseArray<ApplicationInfo> appInfoByUser = new SparseArray<ApplicationInfo>();
        boolean needWrite = false;
        for (Map.Entry<String, PackageDynamicCodeLoading.DynamicCodeFile> fileEntry : info.mFileUsageMap.entrySet()) {
            int storageFlags;
            ApplicationInfo appInfo;
            String filePath = fileEntry.getKey();
            PackageDynamicCodeLoading.DynamicCodeFile fileInfo = fileEntry.getValue();
            int userId = fileInfo.mUserId;
            int index = appInfoByUser.indexOfKey(userId);
            if (index >= 0) {
                appInfo = (ApplicationInfo)appInfoByUser.get(userId);
            } else {
                appInfo = null;
                try {
                    PackageInfo ownerInfo = this.mPackageManager.getPackageInfo(packageName, 0, userId);
                    appInfo = ownerInfo == null ? null : ownerInfo.applicationInfo;
                }
                catch (RemoteException ownerInfo) {
                    // empty catch block
                }
                appInfoByUser.put(userId, appInfo);
                if (appInfo == null) {
                    Slog.d(TAG, "Could not find package " + packageName + " for user " + userId);
                    needWrite |= this.mPackageDynamicCodeLoading.removeUserPackage(packageName, userId);
                }
            }
            if (appInfo == null) continue;
            if (this.fileIsUnder(filePath, appInfo.credentialProtectedDataDir)) {
                storageFlags = 2;
            } else if (this.fileIsUnder(filePath, appInfo.deviceProtectedDataDir)) {
                storageFlags = 1;
            } else {
                Slog.e(TAG, "Could not infer CE/DE storage for path " + filePath);
                needWrite |= this.mPackageDynamicCodeLoading.removeFile(packageName, filePath, userId);
                continue;
            }
            byte[] hash = null;
            try {
                hash = this.mInstaller.hashSecondaryDexFile(filePath, packageName, appInfo.uid, appInfo.volumeUuid, storageFlags);
            }
            catch (Installer.InstallerException e) {
                Slog.e(TAG, "Got InstallerException when hashing file " + filePath + ": " + e.getMessage());
            }
            String subtag = fileInfo.mFileType == 'D' ? DCL_DEX_SUBTAG : DCL_NATIVE_SUBTAG;
            String fileName = new File(filePath).getName();
            String message = PackageUtils.computeSha256Digest(fileName.getBytes());
            if (hash != null && hash.length == 32) {
                message = message + ' ' + ByteStringUtils.toHexString(hash);
            } else {
                Slog.d(TAG, "Got no hash for " + filePath);
                needWrite |= this.mPackageDynamicCodeLoading.removeFile(packageName, filePath, userId);
            }
            for (String loadingPackageName : fileInfo.mLoadingPackages) {
                int loadingUid = -1;
                if (loadingPackageName.equals(packageName)) {
                    loadingUid = appInfo.uid;
                } else {
                    try {
                        loadingUid = this.mPackageManager.getPackageUid(loadingPackageName, 0, userId);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                if (loadingUid == -1) continue;
                this.writeDclEvent(subtag, loadingUid, message);
            }
        }
        if (needWrite) {
            this.mPackageDynamicCodeLoading.maybeWriteAsync();
        }
    }

    private boolean fileIsUnder(String filePath, String directoryPath) {
        if (directoryPath == null) {
            return false;
        }
        try {
            return FileUtils.contains(new File(directoryPath).getCanonicalPath(), new File(filePath).getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    @VisibleForTesting
    PackageDynamicCodeLoading.PackageDynamicCode getPackageDynamicCodeInfo(String packageName) {
        return this.mPackageDynamicCodeLoading.getPackageDynamicCodeInfo(packageName);
    }

    @VisibleForTesting
    void writeDclEvent(String subtag, int uid, String message) {
        EventLog.writeEvent(1397638484, subtag, uid, message);
    }

    void recordDex(int loaderUserId, String dexPath, String owningPackageName, String loadingPackageName) {
        if (this.mPackageDynamicCodeLoading.record(owningPackageName, dexPath, 68, loaderUserId, loadingPackageName)) {
            this.mPackageDynamicCodeLoading.maybeWriteAsync();
        }
    }

    public void recordNative(int loadingUid, String path) {
        String[] packages;
        try {
            packages = this.mPackageManager.getPackagesForUid(loadingUid);
            if (packages == null || packages.length == 0) {
                return;
            }
        }
        catch (RemoteException e) {
            return;
        }
        String loadingPackageName = packages[0];
        int loadingUserId = UserHandle.getUserId(loadingUid);
        if (this.mPackageDynamicCodeLoading.record(loadingPackageName, path, 78, loadingUserId, loadingPackageName)) {
            this.mPackageDynamicCodeLoading.maybeWriteAsync();
        }
    }

    void clear() {
        this.mPackageDynamicCodeLoading.clear();
    }

    void removePackage(String packageName) {
        if (this.mPackageDynamicCodeLoading.removePackage(packageName)) {
            this.mPackageDynamicCodeLoading.maybeWriteAsync();
        }
    }

    void removeUserPackage(String packageName, int userId) {
        if (this.mPackageDynamicCodeLoading.removeUserPackage(packageName, userId)) {
            this.mPackageDynamicCodeLoading.maybeWriteAsync();
        }
    }

    void readAndSync(Map<String, Set<Integer>> packageToUsersMap) {
        this.mPackageDynamicCodeLoading.read();
        this.mPackageDynamicCodeLoading.syncData(packageToUsersMap);
    }

    void writeNow() {
        this.mPackageDynamicCodeLoading.writeNow();
    }
}

