/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.dex;

import android.util.AtomicFile;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastPrintWriter;
import com.android.server.pm.AbstractStatsBase;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.io.IoUtils;

class PackageDynamicCodeLoading
extends AbstractStatsBase<Void> {
    static final int FILE_TYPE_DEX = 68;
    static final int FILE_TYPE_NATIVE = 78;
    private static final String TAG = "PackageDynamicCodeLoading";
    private static final String FILE_VERSION_HEADER = "DCL1";
    private static final String PACKAGE_PREFIX = "P:";
    private static final char FIELD_SEPARATOR = ':';
    private static final String PACKAGE_SEPARATOR = ",";
    @VisibleForTesting
    static final int MAX_FILES_PER_OWNER = 100;
    private static final Pattern PACKAGE_LINE_PATTERN = Pattern.compile("([A-Z]):([0-9]+):([^:]*):(.*)");
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private Map<String, PackageDynamicCode> mPackageMap = new HashMap<String, PackageDynamicCode>();

    PackageDynamicCodeLoading() {
        super("package-dcl.list", "PackageDynamicCodeLoading_DiskWriter", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean record(String owningPackageName, String filePath, int fileType, int ownerUserId, String loadingPackageName) {
        if (!PackageDynamicCodeLoading.isValidFileType(fileType)) {
            throw new IllegalArgumentException("Bad file type: " + fileType);
        }
        Object object = this.mLock;
        synchronized (object) {
            PackageDynamicCode packageInfo = this.mPackageMap.get(owningPackageName);
            if (packageInfo == null) {
                packageInfo = new PackageDynamicCode();
                this.mPackageMap.put(owningPackageName, packageInfo);
            }
            return packageInfo.add(filePath, (char)fileType, ownerUserId, loadingPackageName);
        }
    }

    private static boolean isValidFileType(int fileType) {
        return fileType == 68 || fileType == 78;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getAllPackagesWithDynamicCodeLoading() {
        Object object = this.mLock;
        synchronized (object) {
            return new HashSet<String>(this.mPackageMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageDynamicCode getPackageDynamicCodeInfo(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            PackageDynamicCode info = this.mPackageMap.get(packageName);
            return info == null ? null : new PackageDynamicCode(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPackageMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removePackage(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPackageMap.remove(packageName) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUserPackage(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            PackageDynamicCode packageDynamicCode = this.mPackageMap.get(packageName);
            if (packageDynamicCode == null) {
                return false;
            }
            if (packageDynamicCode.removeUser(userId)) {
                if (packageDynamicCode.mFileUsageMap.isEmpty()) {
                    this.mPackageMap.remove(packageName);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFile(String packageName, String filePath, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            PackageDynamicCode packageDynamicCode = this.mPackageMap.get(packageName);
            if (packageDynamicCode == null) {
                return false;
            }
            if (packageDynamicCode.removeFile(filePath, userId)) {
                if (packageDynamicCode.mFileUsageMap.isEmpty()) {
                    this.mPackageMap.remove(packageName);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncData(Map<String, Set<Integer>> packageToUsersMap) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<Map.Entry<String, PackageDynamicCode>> it = this.mPackageMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, PackageDynamicCode> entry = it.next();
                Set<Integer> packageUsers = packageToUsersMap.get(entry.getKey());
                if (packageUsers == null) {
                    it.remove();
                    continue;
                }
                PackageDynamicCode packageDynamicCode = entry.getValue();
                packageDynamicCode.syncData(packageToUsersMap, packageUsers);
                if (!packageDynamicCode.mFileUsageMap.isEmpty()) continue;
                it.remove();
            }
        }
    }

    void maybeWriteAsync() {
        super.maybeWriteAsync(null);
    }

    void writeNow() {
        super.writeNow(null);
    }

    @Override
    protected final void writeInternal(Void data) {
        AtomicFile file = this.getFile();
        FileOutputStream output = null;
        try {
            output = file.startWrite();
            this.write(output);
            file.finishWrite(output);
        }
        catch (IOException e) {
            file.failWrite(output);
            Slog.e(TAG, "Failed to write dynamic usage for secondary code files.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void write(OutputStream output) throws IOException {
        HashMap<String, PackageDynamicCode> copiedMap;
        Object object = this.mLock;
        synchronized (object) {
            copiedMap = new HashMap<String, PackageDynamicCode>(this.mPackageMap.size());
            for (Map.Entry<String, PackageDynamicCode> entry : this.mPackageMap.entrySet()) {
                PackageDynamicCode copiedValue = new PackageDynamicCode(entry.getValue());
                copiedMap.put(entry.getKey(), copiedValue);
            }
        }
        PackageDynamicCodeLoading.write(output, copiedMap);
    }

    private static void write(OutputStream output, Map<String, PackageDynamicCode> packageMap) throws IOException {
        FastPrintWriter writer = new FastPrintWriter(output);
        writer.println(FILE_VERSION_HEADER);
        for (Map.Entry<String, PackageDynamicCode> packageEntry : packageMap.entrySet()) {
            ((PrintWriter)writer).print(PACKAGE_PREFIX);
            writer.println(packageEntry.getKey());
            Map<String, DynamicCodeFile> mFileUsageMap = packageEntry.getValue().mFileUsageMap;
            for (Map.Entry<String, DynamicCodeFile> fileEntry : mFileUsageMap.entrySet()) {
                String path = fileEntry.getKey();
                DynamicCodeFile dynamicCodeFile = fileEntry.getValue();
                ((PrintWriter)writer).print(dynamicCodeFile.mFileType);
                ((PrintWriter)writer).print(':');
                ((PrintWriter)writer).print(dynamicCodeFile.mUserId);
                ((PrintWriter)writer).print(':');
                String prefix = "";
                for (String packageName : dynamicCodeFile.mLoadingPackages) {
                    ((PrintWriter)writer).print(prefix);
                    ((PrintWriter)writer).print(packageName);
                    prefix = PACKAGE_SEPARATOR;
                }
                ((PrintWriter)writer).print(':');
                writer.println(PackageDynamicCodeLoading.escape(path));
            }
        }
        ((PrintWriter)writer).flush();
        if (((PrintWriter)writer).checkError()) {
            throw new IOException("Writer failed");
        }
    }

    void read() {
        super.read(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void readInternal(Void data) {
        AtomicFile file = this.getFile();
        FileInputStream stream = null;
        try {
            stream = file.openRead();
            this.read(stream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to parse dynamic usage for secondary code files.", e);
        }
        finally {
            IoUtils.closeQuietly(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    void read(InputStream stream) throws IOException {
        HashMap<String, PackageDynamicCode> newPackageMap = new HashMap<String, PackageDynamicCode>();
        PackageDynamicCodeLoading.read(stream, newPackageMap);
        Object object = this.mLock;
        synchronized (object) {
            this.mPackageMap = newPackageMap;
        }
    }

    private static void read(InputStream stream, Map<String, PackageDynamicCode> packageMap) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String versionLine = reader.readLine();
        if (!FILE_VERSION_HEADER.equals(versionLine)) {
            throw new IOException("Incorrect version line: " + versionLine);
        }
        String line = reader.readLine();
        if (line != null && !line.startsWith(PACKAGE_PREFIX)) {
            throw new IOException("Malformed line: " + line);
        }
        while (line != null) {
            String packageName = line.substring(PACKAGE_PREFIX.length());
            PackageDynamicCode packageInfo = new PackageDynamicCode();
            while ((line = reader.readLine()) != null && !line.startsWith(PACKAGE_PREFIX)) {
                PackageDynamicCodeLoading.readFileInfo(line, packageInfo);
            }
            if (packageInfo.mFileUsageMap.isEmpty()) continue;
            packageMap.put(packageName, packageInfo);
        }
    }

    private static void readFileInfo(String line, PackageDynamicCode output) throws IOException {
        try {
            Matcher matcher = PACKAGE_LINE_PATTERN.matcher(line);
            if (!matcher.matches()) {
                throw new IOException("Malformed line: " + line);
            }
            char type = matcher.group(1).charAt(0);
            int user = Integer.parseInt(matcher.group(2));
            String[] packages = matcher.group(3).split(PACKAGE_SEPARATOR);
            String path = PackageDynamicCodeLoading.unescape(matcher.group(4));
            if (packages.length == 0) {
                throw new IOException("Malformed line: " + line);
            }
            if (!PackageDynamicCodeLoading.isValidFileType(type)) {
                throw new IOException("Unknown file type: " + line);
            }
            output.mFileUsageMap.put(path, new DynamicCodeFile(type, user, packages));
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to parse line: " + line, e);
        }
    }

    @VisibleForTesting
    static String escape(String path) {
        if (path.indexOf(92) == -1 && path.indexOf(10) == -1 && path.indexOf(13) == -1) {
            return path;
        }
        StringBuilder result = new StringBuilder(path.length() + 10);
        block5: for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '\\': {
                    result.append("\\\\");
                    continue block5;
                }
                case '\n': {
                    result.append("\\n");
                    continue block5;
                }
                case '\r': {
                    result.append("\\r");
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    @VisibleForTesting
    static String unescape(String escaped) throws IOException {
        int start = 0;
        int finish = escaped.indexOf(92);
        if (finish == -1) {
            return escaped;
        }
        StringBuilder result = new StringBuilder(escaped.length());
        do {
            if (finish >= escaped.length() - 1) {
                throw new IOException("Unexpected \\ in: " + escaped);
            }
            result.append(escaped, start, finish);
            switch (escaped.charAt(finish + 1)) {
                case '\\': {
                    result.append('\\');
                    break;
                }
                case 'r': {
                    result.append('\r');
                    break;
                }
                case 'n': {
                    result.append('\n');
                    break;
                }
                default: {
                    throw new IOException("Bad escape in: " + escaped);
                }
            }
        } while ((finish = escaped.indexOf(92, start = finish + 2)) != -1);
        result.append(escaped, start, escaped.length());
        return result.toString();
    }

    static class DynamicCodeFile {
        final char mFileType;
        final int mUserId;
        final Set<String> mLoadingPackages;

        private DynamicCodeFile(char type, int user, String ... packages) {
            this.mFileType = type;
            this.mUserId = user;
            this.mLoadingPackages = new HashSet<String>(Arrays.asList(packages));
        }

        private DynamicCodeFile(DynamicCodeFile original) {
            this.mFileType = original.mFileType;
            this.mUserId = original.mUserId;
            this.mLoadingPackages = new HashSet<String>(original.mLoadingPackages);
        }
    }

    static class PackageDynamicCode {
        final Map<String, DynamicCodeFile> mFileUsageMap;

        private PackageDynamicCode() {
            this.mFileUsageMap = new HashMap<String, DynamicCodeFile>();
        }

        private PackageDynamicCode(PackageDynamicCode original) {
            this.mFileUsageMap = new HashMap<String, DynamicCodeFile>(original.mFileUsageMap.size());
            for (Map.Entry<String, DynamicCodeFile> entry : original.mFileUsageMap.entrySet()) {
                DynamicCodeFile newValue = new DynamicCodeFile(entry.getValue());
                this.mFileUsageMap.put(entry.getKey(), newValue);
            }
        }

        private boolean add(String path, char fileType, int userId, String loadingPackage) {
            DynamicCodeFile fileInfo = this.mFileUsageMap.get(path);
            if (fileInfo == null) {
                if (this.mFileUsageMap.size() >= 100) {
                    return false;
                }
                fileInfo = new DynamicCodeFile(fileType, userId, new String[]{loadingPackage});
                this.mFileUsageMap.put(path, fileInfo);
                return true;
            }
            if (fileInfo.mUserId != userId) {
                throw new IllegalArgumentException("Cannot change userId for '" + path + "' from " + fileInfo.mUserId + " to " + userId);
            }
            return fileInfo.mLoadingPackages.add(loadingPackage);
        }

        private boolean removeUser(int userId) {
            boolean updated = false;
            Iterator<DynamicCodeFile> it = this.mFileUsageMap.values().iterator();
            while (it.hasNext()) {
                DynamicCodeFile fileInfo = it.next();
                if (fileInfo.mUserId != userId) continue;
                it.remove();
                updated = true;
            }
            return updated;
        }

        private boolean removeFile(String filePath, int userId) {
            DynamicCodeFile fileInfo = this.mFileUsageMap.get(filePath);
            if (fileInfo == null || fileInfo.mUserId != userId) {
                return false;
            }
            this.mFileUsageMap.remove(filePath);
            return true;
        }

        private void syncData(Map<String, Set<Integer>> packageToUsersMap, Set<Integer> owningPackageUsers) {
            Iterator<DynamicCodeFile> fileIt = this.mFileUsageMap.values().iterator();
            while (fileIt.hasNext()) {
                DynamicCodeFile fileInfo = fileIt.next();
                int fileUserId = fileInfo.mUserId;
                if (!owningPackageUsers.contains(fileUserId)) {
                    fileIt.remove();
                    continue;
                }
                Iterator<String> loaderIt = fileInfo.mLoadingPackages.iterator();
                while (loaderIt.hasNext()) {
                    String loader = loaderIt.next();
                    Set<Integer> loadingPackageUsers = packageToUsersMap.get(loader);
                    if (loadingPackageUsers != null && loadingPackageUsers.contains(fileUserId)) continue;
                    loaderIt.remove();
                }
                if (!fileInfo.mLoadingPackages.isEmpty()) continue;
                fileIt.remove();
            }
        }
    }
}

