/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.permission;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.UserHandle;
import android.permission.PermissionManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import com.android.server.LocalServices;
import com.android.server.pm.permission.BasePermission;
import com.android.server.pm.permission.PermissionManagerService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class DefaultPermissionGrantPolicy {
    private static final String TAG = "DefaultPermGrantPolicy";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_INTENT_QUERY_FLAGS = 794624;
    private static final int DEFAULT_PACKAGE_INFO_QUERY_FLAGS = 0x2000B000;
    private static final String AUDIO_MIME_TYPE = "audio/mpeg";
    private static final String TAG_EXCEPTIONS = "exceptions";
    private static final String TAG_EXCEPTION = "exception";
    private static final String TAG_PERMISSION = "permission";
    private static final String ATTR_PACKAGE = "package";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FIXED = "fixed";
    private static final String ATTR_WHITELISTED = "whitelisted";
    private static final Set<String> PHONE_PERMISSIONS = new ArraySet<String>();
    private static final Set<String> CONTACTS_PERMISSIONS;
    private static final Set<String> ALWAYS_LOCATION_PERMISSIONS;
    private static final Set<String> ACTIVITY_RECOGNITION_PERMISSIONS;
    private static final Set<String> CALENDAR_PERMISSIONS;
    private static final Set<String> SMS_PERMISSIONS;
    private static final Set<String> MICROPHONE_PERMISSIONS;
    private static final Set<String> CAMERA_PERMISSIONS;
    private static final Set<String> SENSORS_PERMISSIONS;
    private static final Set<String> STORAGE_PERMISSIONS;
    private static final int MSG_READ_DEFAULT_PERMISSION_EXCEPTIONS = 1;
    private static final String ACTION_TRACK = "com.android.fitness.TRACK";
    private final Handler mHandler;
    private PackageManagerInternal.PackagesProvider mLocationPackagesProvider;
    private PackageManagerInternal.PackagesProvider mLocationExtraPackagesProvider;
    private PackageManagerInternal.PackagesProvider mVoiceInteractionPackagesProvider;
    private PackageManagerInternal.PackagesProvider mSmsAppPackagesProvider;
    private PackageManagerInternal.PackagesProvider mDialerAppPackagesProvider;
    private PackageManagerInternal.PackagesProvider mSimCallManagerPackagesProvider;
    private PackageManagerInternal.PackagesProvider mUseOpenWifiAppPackagesProvider;
    private PackageManagerInternal.SyncAdapterPackagesProvider mSyncAdapterPackagesProvider;
    private ArrayMap<String, List<DefaultPermissionGrant>> mGrantExceptions;
    private final Context mContext;
    private final Object mLock = new Object();
    private final PackageManagerInternal mServiceInternal;
    private final PermissionManagerService mPermissionManager;
    @GuardedBy(value={"mLock"})
    private SparseIntArray mDefaultPermissionsGrantedUsers = new SparseIntArray();

    DefaultPermissionGrantPolicy(Context context, Looper looper, PermissionManagerService permissionManager) {
        this.mContext = context;
        this.mHandler = new Handler(looper){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(Message msg) {
                if (msg.what == 1) {
                    Object object = DefaultPermissionGrantPolicy.this.mLock;
                    synchronized (object) {
                        if (DefaultPermissionGrantPolicy.this.mGrantExceptions == null) {
                            DefaultPermissionGrantPolicy.this.mGrantExceptions = DefaultPermissionGrantPolicy.this.readDefaultPermissionExceptionsLocked();
                        }
                    }
                }
            }
        };
        this.mPermissionManager = permissionManager;
        this.mServiceInternal = LocalServices.getService(PackageManagerInternal.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocationPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationExtraPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocationExtraPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceInteractionPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mVoiceInteractionPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSmsAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSmsAppPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDialerAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDialerAppPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSimCallManagerPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSimCallManagerPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseOpenWifiAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUseOpenWifiAppPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncAdapterPackagesProvider(PackageManagerInternal.SyncAdapterPackagesProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSyncAdapterPackagesProvider = provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wereDefaultPermissionsGrantedSinceBoot(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDefaultPermissionsGrantedUsers.indexOfKey(userId) >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantDefaultPermissions(int userId) {
        this.grantPermissionsToSysComponentsAndPrivApps(userId);
        this.grantDefaultSystemHandlerPermissions(userId);
        this.grantDefaultPermissionExceptions(userId);
        Object object = this.mLock;
        synchronized (object) {
            this.mDefaultPermissionsGrantedUsers.put(userId, userId);
        }
    }

    private void grantRuntimePermissionsForSystemPackage(int userId, PackageInfo pkg) {
        ArraySet<String> permissions = new ArraySet<String>();
        for (String permission2 : pkg.requestedPermissions) {
            BasePermission bp = this.mPermissionManager.getPermission(permission2);
            if (bp == null || !bp.isRuntime()) continue;
            permissions.add(permission2);
        }
        if (!permissions.isEmpty()) {
            this.grantRuntimePermissions(pkg, permissions, true, userId);
        }
    }

    public void scheduleReadDefaultPermissionExceptions() {
        this.mHandler.sendEmptyMessage(1);
    }

    private void grantPermissionsToSysComponentsAndPrivApps(int userId) {
        Log.i(TAG, "Granting permissions to platform components for user " + userId);
        List<PackageInfo> packages = this.mContext.getPackageManager().getInstalledPackagesAsUser(0x2000B000, 0);
        for (PackageInfo pkg : packages) {
            if (pkg == null || !this.isSysComponentOrPersistentPlatformSignedPrivApp(pkg) || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(pkg) || ArrayUtils.isEmpty(pkg.requestedPermissions)) continue;
            this.grantRuntimePermissionsForSystemPackage(userId, pkg);
        }
    }

    @SafeVarargs
    private final void grantIgnoringSystemPackage(String packageName, int userId, Set<String> ... permissionGroups) {
        this.grantPermissionsToPackage(packageName, userId, true, true, permissionGroups);
    }

    @SafeVarargs
    private final void grantSystemFixedPermissionsToSystemPackage(String packageName, int userId, Set<String> ... permissionGroups) {
        this.grantPermissionsToSystemPackage(packageName, userId, true, permissionGroups);
    }

    @SafeVarargs
    private final void grantPermissionsToSystemPackage(String packageName, int userId, Set<String> ... permissionGroups) {
        this.grantPermissionsToSystemPackage(packageName, userId, false, permissionGroups);
    }

    @SafeVarargs
    private final void grantPermissionsToSystemPackage(String packageName, int userId, boolean systemFixed, Set<String> ... permissionGroups) {
        if (!this.isSystemPackage(packageName)) {
            return;
        }
        this.grantPermissionsToPackage(this.getSystemPackageInfo(packageName), userId, systemFixed, false, true, permissionGroups);
    }

    @SafeVarargs
    private final void grantPermissionsToPackage(String packageName, int userId, boolean ignoreSystemPackage, boolean whitelistRestrictedPermissions, Set<String> ... permissionGroups) {
        this.grantPermissionsToPackage(this.getPackageInfo(packageName), userId, false, ignoreSystemPackage, whitelistRestrictedPermissions, permissionGroups);
    }

    @SafeVarargs
    private final void grantPermissionsToPackage(PackageInfo packageInfo, int userId, boolean systemFixed, boolean ignoreSystemPackage, boolean whitelistRestrictedPermissions, Set<String> ... permissionGroups) {
        if (packageInfo == null) {
            return;
        }
        if (DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(packageInfo)) {
            for (Set<String> permissionGroup : permissionGroups) {
                this.grantRuntimePermissions(packageInfo, permissionGroup, systemFixed, ignoreSystemPackage, whitelistRestrictedPermissions, userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantDefaultSystemHandlerPermissions(int userId) {
        String attentionServicePackageName;
        PackageManagerInternal.SyncAdapterPackagesProvider syncAdapterPackagesProvider;
        PackageManagerInternal.PackagesProvider useOpenWifiAppPackagesProvider;
        PackageManagerInternal.PackagesProvider simCallManagerPackagesProvider;
        PackageManagerInternal.PackagesProvider dialerAppPackagesProvider;
        PackageManagerInternal.PackagesProvider smsAppPackagesProvider;
        PackageManagerInternal.PackagesProvider voiceInteractionPackagesProvider;
        PackageManagerInternal.PackagesProvider locationExtraPackagesProvider;
        PackageManagerInternal.PackagesProvider locationPackagesProvider;
        Log.i(TAG, "Granting permissions to default platform handlers for user " + userId);
        Object object = this.mLock;
        synchronized (object) {
            locationPackagesProvider = this.mLocationPackagesProvider;
            locationExtraPackagesProvider = this.mLocationExtraPackagesProvider;
            voiceInteractionPackagesProvider = this.mVoiceInteractionPackagesProvider;
            smsAppPackagesProvider = this.mSmsAppPackagesProvider;
            dialerAppPackagesProvider = this.mDialerAppPackagesProvider;
            simCallManagerPackagesProvider = this.mSimCallManagerPackagesProvider;
            useOpenWifiAppPackagesProvider = this.mUseOpenWifiAppPackagesProvider;
            syncAdapterPackagesProvider = this.mSyncAdapterPackagesProvider;
        }
        String[] voiceInteractPackageNames = voiceInteractionPackagesProvider != null ? voiceInteractionPackagesProvider.getPackages(userId) : null;
        String[] locationPackageNames = locationPackagesProvider != null ? locationPackagesProvider.getPackages(userId) : null;
        String[] locationExtraPackageNames = locationExtraPackagesProvider != null ? locationExtraPackagesProvider.getPackages(userId) : null;
        String[] smsAppPackageNames = smsAppPackagesProvider != null ? smsAppPackagesProvider.getPackages(userId) : null;
        String[] dialerAppPackageNames = dialerAppPackagesProvider != null ? dialerAppPackagesProvider.getPackages(userId) : null;
        String[] simCallManagerPackageNames = simCallManagerPackagesProvider != null ? simCallManagerPackagesProvider.getPackages(userId) : null;
        String[] useOpenWifiAppPackageNames = useOpenWifiAppPackagesProvider != null ? useOpenWifiAppPackagesProvider.getPackages(userId) : null;
        String[] contactsSyncAdapterPackages = syncAdapterPackagesProvider != null ? syncAdapterPackagesProvider.getPackages("com.android.contacts", userId) : null;
        String[] calendarSyncAdapterPackages = syncAdapterPackagesProvider != null ? syncAdapterPackagesProvider.getPackages("com.android.calendar", userId) : null;
        this.grantSystemFixedPermissionsToSystemPackage(this.getKnownPackage(2, userId), userId, STORAGE_PERMISSIONS);
        String verifier = this.getKnownPackage(3, userId);
        this.grantSystemFixedPermissionsToSystemPackage(verifier, userId, STORAGE_PERMISSIONS);
        this.grantPermissionsToSystemPackage(verifier, userId, PHONE_PERMISSIONS, SMS_PERMISSIONS);
        this.grantPermissionsToSystemPackage(this.getKnownPackage(1, userId), userId, PHONE_PERMISSIONS, CONTACTS_PERMISSIONS, ALWAYS_LOCATION_PERMISSIONS, CAMERA_PERMISSIONS);
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage("android.media.action.IMAGE_CAPTURE", userId), userId, CAMERA_PERMISSIONS, MICROPHONE_PERMISSIONS, STORAGE_PERMISSIONS);
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage("android.provider.MediaStore.RECORD_SOUND", userId), userId, MICROPHONE_PERMISSIONS);
        this.grantSystemFixedPermissionsToSystemPackage(this.getDefaultProviderAuthorityPackage("media", userId), userId, STORAGE_PERMISSIONS, PHONE_PERMISSIONS);
        this.grantSystemFixedPermissionsToSystemPackage(this.getDefaultProviderAuthorityPackage("downloads", userId), userId, STORAGE_PERMISSIONS);
        this.grantSystemFixedPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage("android.intent.action.VIEW_DOWNLOADS", userId), userId, STORAGE_PERMISSIONS);
        this.grantSystemFixedPermissionsToSystemPackage(this.getDefaultProviderAuthorityPackage("com.android.externalstorage.documents", userId), userId, STORAGE_PERMISSIONS);
        this.grantSystemFixedPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage("android.credentials.INSTALL", userId), userId, STORAGE_PERMISSIONS);
        if (dialerAppPackageNames == null) {
            String string2 = this.getDefaultSystemHandlerActivityPackage("android.intent.action.DIAL", userId);
            this.grantDefaultPermissionsToDefaultSystemDialerApp(string2, userId);
        } else {
            for (String string3 : dialerAppPackageNames) {
                this.grantDefaultPermissionsToDefaultSystemDialerApp(string3, userId);
            }
        }
        if (simCallManagerPackageNames != null) {
            for (String string4 : simCallManagerPackageNames) {
                this.grantDefaultPermissionsToDefaultSystemSimCallManager(string4, userId);
            }
        }
        if (useOpenWifiAppPackageNames != null) {
            for (String string5 : useOpenWifiAppPackageNames) {
                this.grantDefaultPermissionsToDefaultSystemUseOpenWifiApp(string5, userId);
            }
        }
        if (smsAppPackageNames == null) {
            String string6 = this.getDefaultSystemHandlerActivityPackageForCategory("android.intent.category.APP_MESSAGING", userId);
            this.grantDefaultPermissionsToDefaultSystemSmsApp(string6, userId);
        } else {
            for (String string7 : smsAppPackageNames) {
                this.grantDefaultPermissionsToDefaultSystemSmsApp(string7, userId);
            }
        }
        this.grantSystemFixedPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage("android.provider.Telephony.SMS_CB_RECEIVED", userId), userId, SMS_PERMISSIONS);
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerServicePackage("android.provider.Telephony.SMS_CARRIER_PROVISION", userId), userId, SMS_PERMISSIONS);
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackageForCategory("android.intent.category.APP_CALENDAR", userId), userId, CALENDAR_PERMISSIONS, CONTACTS_PERMISSIONS);
        String string8 = this.getDefaultProviderAuthorityPackage("com.android.calendar", userId);
        this.grantPermissionsToSystemPackage(string8, userId, CONTACTS_PERMISSIONS, STORAGE_PERMISSIONS);
        this.grantSystemFixedPermissionsToSystemPackage(string8, userId, CALENDAR_PERMISSIONS);
        this.grantPermissionToEachSystemPackage(this.getHeadlessSyncAdapterPackages(calendarSyncAdapterPackages, userId), userId, CALENDAR_PERMISSIONS);
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackageForCategory("android.intent.category.APP_CONTACTS", userId), userId, CONTACTS_PERMISSIONS, PHONE_PERMISSIONS);
        this.grantPermissionToEachSystemPackage(this.getHeadlessSyncAdapterPackages(contactsSyncAdapterPackages, userId), userId, CONTACTS_PERMISSIONS);
        String contactsProviderPackage = this.getDefaultProviderAuthorityPackage("com.android.contacts", userId);
        this.grantSystemFixedPermissionsToSystemPackage(contactsProviderPackage, userId, CONTACTS_PERMISSIONS, PHONE_PERMISSIONS);
        this.grantPermissionsToSystemPackage(contactsProviderPackage, userId, STORAGE_PERMISSIONS);
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage("android.app.action.PROVISION_MANAGED_DEVICE", userId), userId, CONTACTS_PERMISSIONS);
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackageForCategory("android.intent.category.APP_MAPS", userId), userId, ALWAYS_LOCATION_PERMISSIONS);
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackageForCategory("android.intent.category.APP_GALLERY", userId), userId, STORAGE_PERMISSIONS);
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackageForCategory("android.intent.category.APP_EMAIL", userId), userId, CONTACTS_PERMISSIONS, CALENDAR_PERMISSIONS);
        String browserPackage = this.getKnownPackage(4, userId);
        if (browserPackage == null && !this.isSystemPackage(browserPackage = this.getDefaultSystemHandlerActivityPackageForCategory("android.intent.category.APP_BROWSER", userId))) {
            browserPackage = null;
        }
        this.grantPermissionsToPackage(browserPackage, userId, false, true, ALWAYS_LOCATION_PERMISSIONS);
        if (voiceInteractPackageNames != null) {
            for (String voiceInteractPackageName : voiceInteractPackageNames) {
                this.grantPermissionsToSystemPackage(voiceInteractPackageName, userId, CONTACTS_PERMISSIONS, CALENDAR_PERMISSIONS, MICROPHONE_PERMISSIONS, PHONE_PERMISSIONS, SMS_PERMISSIONS, ALWAYS_LOCATION_PERMISSIONS);
            }
        }
        if (ActivityManager.isLowRamDeviceStatic()) {
            this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage("android.search.action.GLOBAL_SEARCH", userId), userId, MICROPHONE_PERMISSIONS, ALWAYS_LOCATION_PERMISSIONS);
        }
        Intent intent = new Intent("android.speech.RecognitionService").addCategory("android.intent.category.DEFAULT");
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerServicePackage(intent, userId), userId, MICROPHONE_PERMISSIONS);
        if (locationPackageNames != null) {
            for (String packageName : locationPackageNames) {
                this.grantPermissionsToSystemPackage(packageName, userId, CONTACTS_PERMISSIONS, CALENDAR_PERMISSIONS, MICROPHONE_PERMISSIONS, PHONE_PERMISSIONS, SMS_PERMISSIONS, CAMERA_PERMISSIONS, SENSORS_PERMISSIONS, STORAGE_PERMISSIONS);
                this.grantSystemFixedPermissionsToSystemPackage(packageName, userId, ALWAYS_LOCATION_PERMISSIONS, ACTIVITY_RECOGNITION_PERMISSIONS);
            }
        }
        if (locationExtraPackageNames != null) {
            for (String packageName : locationExtraPackageNames) {
                this.grantPermissionsToSystemPackage(packageName, userId, ALWAYS_LOCATION_PERMISSIONS);
            }
        }
        Intent musicIntent = new Intent("android.intent.action.VIEW").addCategory("android.intent.category.DEFAULT").setDataAndType(Uri.fromFile(new File("foo.mp3")), AUDIO_MIME_TYPE);
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage(musicIntent, userId), userId, STORAGE_PERMISSIONS);
        Intent homeIntent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME").addCategory("android.intent.category.LAUNCHER_APP");
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage(homeIntent, userId), userId, ALWAYS_LOCATION_PERMISSIONS);
        if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.watch", 0)) {
            String wearPackage = this.getDefaultSystemHandlerActivityPackageForCategory("android.intent.category.HOME_MAIN", userId);
            this.grantPermissionsToSystemPackage(wearPackage, userId, CONTACTS_PERMISSIONS, MICROPHONE_PERMISSIONS, ALWAYS_LOCATION_PERMISSIONS);
            this.grantSystemFixedPermissionsToSystemPackage(wearPackage, userId, PHONE_PERMISSIONS);
            this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage(ACTION_TRACK, userId), userId, SENSORS_PERMISSIONS, ALWAYS_LOCATION_PERMISSIONS);
        }
        this.grantSystemFixedPermissionsToSystemPackage("com.android.printspooler", userId, ALWAYS_LOCATION_PERMISSIONS);
        this.grantSystemFixedPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage("android.telephony.action.EMERGENCY_ASSISTANCE", userId), userId, CONTACTS_PERMISSIONS, PHONE_PERMISSIONS);
        Intent nfcTagIntent = new Intent("android.intent.action.VIEW").setType("vnd.android.cursor.item/ndef_msg");
        this.grantPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage(nfcTagIntent, userId), userId, CONTACTS_PERMISSIONS, PHONE_PERMISSIONS);
        this.grantSystemFixedPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage("android.os.storage.action.MANAGE_STORAGE", userId), userId, STORAGE_PERMISSIONS);
        this.grantSystemFixedPermissionsToSystemPackage("com.android.companiondevicemanager", userId, ALWAYS_LOCATION_PERMISSIONS);
        this.grantSystemFixedPermissionsToSystemPackage(this.getDefaultSystemHandlerActivityPackage("android.intent.action.RINGTONE_PICKER", userId), userId, STORAGE_PERMISSIONS);
        String textClassifierPackageName = this.mContext.getPackageManager().getSystemTextClassifierPackageName();
        if (!TextUtils.isEmpty(textClassifierPackageName)) {
            this.grantPermissionsToSystemPackage(textClassifierPackageName, userId, PHONE_PERMISSIONS, SMS_PERMISSIONS, CALENDAR_PERMISSIONS, ALWAYS_LOCATION_PERMISSIONS, CONTACTS_PERMISSIONS);
        }
        if (!TextUtils.isEmpty(attentionServicePackageName = this.mContext.getPackageManager().getAttentionServicePackageName())) {
            this.grantPermissionsToSystemPackage(attentionServicePackageName, userId, CAMERA_PERMISSIONS);
        }
        this.grantSystemFixedPermissionsToSystemPackage("com.android.sharedstoragebackup", userId, STORAGE_PERMISSIONS);
        String systemCaptionsServicePackageName = this.mContext.getPackageManager().getSystemCaptionsServicePackageName();
        if (!TextUtils.isEmpty(systemCaptionsServicePackageName)) {
            this.grantPermissionsToSystemPackage(systemCaptionsServicePackageName, userId, MICROPHONE_PERMISSIONS);
        }
    }

    private String getDefaultSystemHandlerActivityPackageForCategory(String category, int userId) {
        return this.getDefaultSystemHandlerActivityPackage(new Intent("android.intent.action.MAIN").addCategory(category), userId);
    }

    @SafeVarargs
    private final void grantPermissionToEachSystemPackage(ArrayList<String> packages, int userId, Set<String> ... permissions) {
        if (packages == null) {
            return;
        }
        int count = packages.size();
        for (int i = 0; i < count; ++i) {
            this.grantPermissionsToSystemPackage(packages.get(i), userId, permissions);
        }
    }

    private String getKnownPackage(int knownPkgId, int userId) {
        return this.mServiceInternal.getKnownPackageName(knownPkgId, userId);
    }

    private void grantDefaultPermissionsToDefaultSystemDialerApp(String dialerPackage, int userId) {
        if (dialerPackage == null) {
            return;
        }
        boolean isPhonePermFixed = this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.watch", 0);
        if (isPhonePermFixed) {
            this.grantSystemFixedPermissionsToSystemPackage(dialerPackage, userId, PHONE_PERMISSIONS);
        } else {
            this.grantPermissionsToSystemPackage(dialerPackage, userId, PHONE_PERMISSIONS);
        }
        this.grantPermissionsToSystemPackage(dialerPackage, userId, CONTACTS_PERMISSIONS, SMS_PERMISSIONS, MICROPHONE_PERMISSIONS, CAMERA_PERMISSIONS);
    }

    private void grantDefaultPermissionsToDefaultSystemSmsApp(String smsPackage, int userId) {
        this.grantPermissionsToSystemPackage(smsPackage, userId, PHONE_PERMISSIONS, CONTACTS_PERMISSIONS, SMS_PERMISSIONS, STORAGE_PERMISSIONS, MICROPHONE_PERMISSIONS, CAMERA_PERMISSIONS);
    }

    private void grantDefaultPermissionsToDefaultSystemUseOpenWifiApp(String useOpenWifiPackage, int userId) {
        this.grantPermissionsToSystemPackage(useOpenWifiPackage, userId, ALWAYS_LOCATION_PERMISSIONS);
    }

    public void grantDefaultPermissionsToDefaultUseOpenWifiApp(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to default Use Open WiFi app for user:" + userId);
        this.grantIgnoringSystemPackage(packageName, userId, ALWAYS_LOCATION_PERMISSIONS);
    }

    public void grantDefaultPermissionsToDefaultSimCallManager(String packageName, int userId) {
        if (packageName == null) {
            return;
        }
        Log.i(TAG, "Granting permissions to sim call manager for user:" + userId);
        this.grantPermissionsToPackage(packageName, userId, false, true, PHONE_PERMISSIONS, MICROPHONE_PERMISSIONS);
    }

    private void grantDefaultPermissionsToDefaultSystemSimCallManager(String packageName, int userId) {
        if (this.isSystemPackage(packageName)) {
            this.grantDefaultPermissionsToDefaultSimCallManager(packageName, userId);
        }
    }

    public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, int userId) {
        Log.i(TAG, "Granting permissions to enabled carrier apps for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            this.grantPermissionsToSystemPackage(packageName, userId, PHONE_PERMISSIONS, ALWAYS_LOCATION_PERMISSIONS, SMS_PERMISSIONS);
        }
    }

    public void grantDefaultPermissionsToEnabledImsServices(String[] packageNames, int userId) {
        Log.i(TAG, "Granting permissions to enabled ImsServices for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            this.grantPermissionsToSystemPackage(packageName, userId, PHONE_PERMISSIONS, MICROPHONE_PERMISSIONS, ALWAYS_LOCATION_PERMISSIONS, CAMERA_PERMISSIONS, CONTACTS_PERMISSIONS);
        }
    }

    public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] packageNames, int userId) {
        Log.i(TAG, "Granting permissions to enabled data services for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            this.grantSystemFixedPermissionsToSystemPackage(packageName, userId, PHONE_PERMISSIONS, ALWAYS_LOCATION_PERMISSIONS);
        }
    }

    public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] packageNames, int userId) {
        Log.i(TAG, "Revoking permissions from disabled data services for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            PackageInfo pkg = this.getSystemPackageInfo(packageName);
            if (!this.isSystemPackage(pkg) || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(pkg)) continue;
            this.revokeRuntimePermissions(packageName, PHONE_PERMISSIONS, true, userId);
            this.revokeRuntimePermissions(packageName, ALWAYS_LOCATION_PERMISSIONS, true, userId);
        }
    }

    public void grantDefaultPermissionsToActiveLuiApp(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to active LUI app for user:" + userId);
        this.grantSystemFixedPermissionsToSystemPackage(packageName, userId, CAMERA_PERMISSIONS);
    }

    public void revokeDefaultPermissionsFromLuiApps(String[] packageNames, int userId) {
        Log.i(TAG, "Revoke permissions from LUI apps for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            PackageInfo pkg = this.getSystemPackageInfo(packageName);
            if (!this.isSystemPackage(pkg) || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(pkg)) continue;
            this.revokeRuntimePermissions(packageName, CAMERA_PERMISSIONS, true, userId);
        }
    }

    public void grantDefaultPermissionsToDefaultBrowser(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to default browser for user:" + userId);
        this.grantPermissionsToSystemPackage(packageName, userId, ALWAYS_LOCATION_PERMISSIONS);
    }

    private String getDefaultSystemHandlerActivityPackage(String intentAction, int userId) {
        return this.getDefaultSystemHandlerActivityPackage(new Intent(intentAction), userId);
    }

    private String getDefaultSystemHandlerActivityPackage(Intent intent, int userId) {
        ResolveInfo handler = this.mContext.getPackageManager().resolveActivityAsUser(intent, 794624, userId);
        if (handler == null || handler.activityInfo == null) {
            return null;
        }
        if (this.mServiceInternal.isResolveActivityComponent(handler.activityInfo)) {
            return null;
        }
        String packageName = handler.activityInfo.packageName;
        return this.isSystemPackage(packageName) ? packageName : null;
    }

    private String getDefaultSystemHandlerServicePackage(String intentAction, int userId) {
        return this.getDefaultSystemHandlerServicePackage(new Intent(intentAction), userId);
    }

    private String getDefaultSystemHandlerServicePackage(Intent intent, int userId) {
        List<ResolveInfo> handlers = this.mContext.getPackageManager().queryIntentServicesAsUser(intent, 794624, userId);
        if (handlers == null) {
            return null;
        }
        int handlerCount = handlers.size();
        for (int i = 0; i < handlerCount; ++i) {
            ResolveInfo handler = handlers.get(i);
            String handlerPackage = handler.serviceInfo.packageName;
            if (!this.isSystemPackage(handlerPackage)) continue;
            return handlerPackage;
        }
        return null;
    }

    private ArrayList<String> getHeadlessSyncAdapterPackages(String[] syncAdapterPackageNames, int userId) {
        ArrayList<String> syncAdapterPackages = new ArrayList<String>();
        Intent homeIntent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER");
        for (String syncAdapterPackageName : syncAdapterPackageNames) {
            homeIntent.setPackage(syncAdapterPackageName);
            ResolveInfo homeActivity = this.mContext.getPackageManager().resolveActivityAsUser(homeIntent, 794624, userId);
            if (homeActivity != null || !this.isSystemPackage(syncAdapterPackageName)) continue;
            syncAdapterPackages.add(syncAdapterPackageName);
        }
        return syncAdapterPackages;
    }

    private String getDefaultProviderAuthorityPackage(String authority, int userId) {
        ProviderInfo provider = this.mContext.getPackageManager().resolveContentProviderAsUser(authority, 794624, userId);
        if (provider != null) {
            return provider.packageName;
        }
        return null;
    }

    private boolean isSystemPackage(String packageName) {
        return this.isSystemPackage(this.getPackageInfo(packageName));
    }

    private boolean isSystemPackage(PackageInfo pkg) {
        if (pkg == null) {
            return false;
        }
        return pkg.applicationInfo.isSystemApp() && !this.isSysComponentOrPersistentPlatformSignedPrivApp(pkg);
    }

    private void grantRuntimePermissions(PackageInfo pkg, Set<String> permissions, boolean systemFixed, int userId) {
        this.grantRuntimePermissions(pkg, permissions, systemFixed, false, true, userId);
    }

    private void revokeRuntimePermissions(String packageName, Set<String> permissions, boolean systemFixed, int userId) {
        PackageInfo pkg = this.getSystemPackageInfo(packageName);
        if (ArrayUtils.isEmpty(pkg.requestedPermissions)) {
            return;
        }
        ArraySet<String> revokablePermissions = new ArraySet<String>(Arrays.asList(pkg.requestedPermissions));
        for (String permission2 : permissions) {
            if (!revokablePermissions.contains(permission2)) continue;
            UserHandle user = UserHandle.of(userId);
            int flags = this.mContext.getPackageManager().getPermissionFlags(permission2, packageName, user);
            if ((flags & 0x20) == 0 || (flags & 4) != 0 || (flags & 0x10) != 0 && !systemFixed) continue;
            this.mContext.getPackageManager().revokeRuntimePermission(packageName, permission2, user);
            this.mContext.getPackageManager().updatePermissionFlags(permission2, packageName, 32, 0, user);
        }
    }

    private boolean isFixedOrUserSet(int flags) {
        return (flags & 0x17) != 0;
    }

    private String getBackgroundPermission(String permission2) {
        try {
            return this.mContext.getPackageManager().getPermissionInfo((String)permission2, (int)0).backgroundPermission;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private void grantRuntimePermissions(PackageInfo pkg, Set<String> permissionsWithoutSplits, boolean systemFixed, boolean ignoreSystemPackage, boolean whitelistRestrictedPermissions, int userId) {
        Object permission2;
        PackageInfo disabledPkg;
        PackageManager pm;
        UserHandle user = UserHandle.of(userId);
        if (pkg == null) {
            return;
        }
        Object[] requestedPermissions = pkg.requestedPermissions;
        if (ArrayUtils.isEmpty(requestedPermissions)) {
            return;
        }
        String[] requestedByNonSystemPackage = this.getPackageInfo((String)pkg.packageName).requestedPermissions;
        int size = requestedPermissions.length;
        for (int i = 0; i < size; ++i) {
            if (ArrayUtils.contains(requestedByNonSystemPackage, requestedPermissions[i])) continue;
            requestedPermissions[i] = null;
        }
        requestedPermissions = ArrayUtils.filterNotNull(requestedPermissions, String[]::new);
        try {
            pm = this.mContext.createPackageContextAsUser(this.mContext.getPackageName(), 0, user).getPackageManager();
        }
        catch (PackageManager.NameNotFoundException doesNotHappen) {
            throw new IllegalStateException(doesNotHappen);
        }
        ArraySet<String> permissions = new ArraySet<String>(permissionsWithoutSplits);
        ApplicationInfo applicationInfo = pkg.applicationInfo;
        int newFlags = 32;
        if (systemFixed) {
            newFlags |= 0x10;
        }
        List<PermissionManager.SplitPermissionInfo> splitPermissions = this.mContext.getSystemService(PermissionManager.class).getSplitPermissions();
        int numSplitPerms = splitPermissions.size();
        for (int splitPermNum = 0; splitPermNum < numSplitPerms; ++splitPermNum) {
            PermissionManager.SplitPermissionInfo splitPerm = splitPermissions.get(splitPermNum);
            if (applicationInfo == null || applicationInfo.targetSdkVersion >= splitPerm.getTargetSdk() || !permissionsWithoutSplits.contains(splitPerm.getSplitPermission())) continue;
            permissions.addAll(splitPerm.getNewPermissions());
        }
        ArraySet<Object> grantablePermissions = null;
        if (!ignoreSystemPackage && applicationInfo != null && applicationInfo.isUpdatedSystemApp() && (disabledPkg = this.getSystemPackageInfo(this.mServiceInternal.getDisabledSystemPackageName(pkg.packageName))) != null) {
            if (ArrayUtils.isEmpty(disabledPkg.requestedPermissions)) {
                return;
            }
            if (!Arrays.equals(requestedPermissions, disabledPkg.requestedPermissions)) {
                grantablePermissions = new ArraySet<Object>(Arrays.asList(requestedPermissions));
                requestedPermissions = disabledPkg.requestedPermissions;
            }
        }
        int numRequestedPermissions = requestedPermissions.length;
        String[] sortedRequestedPermissions = new String[numRequestedPermissions];
        int numForeground = 0;
        int numOther = 0;
        for (int i = 0; i < numRequestedPermissions; ++i) {
            permission2 = requestedPermissions[i];
            if (this.getBackgroundPermission((String)permission2) != null) {
                sortedRequestedPermissions[numForeground] = permission2;
                ++numForeground;
                continue;
            }
            sortedRequestedPermissions[numRequestedPermissions - 1 - numOther] = permission2;
            ++numOther;
        }
        for (int requestedPermissionNum = 0; requestedPermissionNum < numRequestedPermissions; ++requestedPermissionNum) {
            boolean changingGrantForSystemFixed;
            permission2 = requestedPermissions[requestedPermissionNum];
            if (grantablePermissions != null && !grantablePermissions.contains(permission2) || !permissions.contains(permission2)) continue;
            int flags = this.mContext.getPackageManager().getPermissionFlags((String)permission2, pkg.packageName, user);
            boolean bl = changingGrantForSystemFixed = systemFixed && (flags & 0x10) != 0;
            if (!this.isFixedOrUserSet(flags) || ignoreSystemPackage || changingGrantForSystemFixed) {
                if ((flags & 4) != 0) continue;
                newFlags |= flags & 0x3800;
                if (whitelistRestrictedPermissions && this.isPermissionRestricted((String)permission2)) {
                    this.mContext.getPackageManager().updatePermissionFlags((String)permission2, pkg.packageName, 4096, 4096, user);
                }
                if (changingGrantForSystemFixed) {
                    this.mContext.getPackageManager().updatePermissionFlags((String)permission2, pkg.packageName, flags, flags & 0xFFFFFFEF, user);
                }
                if (pm.checkPermission((String)permission2, pkg.packageName) != 0) {
                    this.mContext.getPackageManager().grantRuntimePermission(pkg.packageName, (String)permission2, user);
                }
                this.mContext.getPackageManager().updatePermissionFlags((String)permission2, pkg.packageName, newFlags, newFlags, user);
                int uid = UserHandle.getUid(userId, UserHandle.getAppId(pkg.applicationInfo.uid));
                List<String> fgPerms = this.mPermissionManager.getBackgroundPermissions().get(permission2);
                if (fgPerms != null) {
                    int numFgPerms = fgPerms.size();
                    for (int fgPermNum = 0; fgPermNum < numFgPerms; ++fgPermNum) {
                        String fgPerm = fgPerms.get(fgPermNum);
                        if (pm.checkPermission(fgPerm, pkg.packageName) != 0) continue;
                        this.mContext.getSystemService(AppOpsManager.class).setUidMode(AppOpsManager.permissionToOp(fgPerm), uid, 0);
                        break;
                    }
                }
                String bgPerm = this.getBackgroundPermission((String)permission2);
                String op = AppOpsManager.permissionToOp((String)permission2);
                if (bgPerm == null) {
                    if (op != null) {
                        this.mContext.getSystemService(AppOpsManager.class).setUidMode(op, uid, 0);
                    }
                } else {
                    int mode = pm.checkPermission(bgPerm, pkg.packageName) == 0 ? 0 : 4;
                    this.mContext.getSystemService(AppOpsManager.class).setUidMode(op, uid, mode);
                }
            }
            if ((flags & 0x20) == 0 || (flags & 0x10) == 0 || systemFixed) continue;
            this.mContext.getPackageManager().updatePermissionFlags((String)permission2, pkg.packageName, 16, 0, user);
        }
    }

    private PackageInfo getSystemPackageInfo(String pkg) {
        return this.getPackageInfo(pkg, 0x100000);
    }

    private PackageInfo getPackageInfo(String pkg) {
        return this.getPackageInfo(pkg, 0);
    }

    private PackageInfo getPackageInfo(String pkg, int extraFlags) {
        if (pkg == null) {
            return null;
        }
        try {
            return this.mContext.getPackageManager().getPackageInfo(pkg, 0x2000B000 | extraFlags);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "PackageNot found: " + pkg, e);
            return null;
        }
    }

    private boolean isSysComponentOrPersistentPlatformSignedPrivApp(PackageInfo pkg) {
        ApplicationInfo disabledPackageAppInfo;
        if (UserHandle.getAppId(pkg.applicationInfo.uid) < 10000) {
            return true;
        }
        if (!pkg.applicationInfo.isPrivilegedApp()) {
            return false;
        }
        PackageInfo disabledPkg = this.getSystemPackageInfo(this.mServiceInternal.getDisabledSystemPackageName(pkg.applicationInfo.packageName));
        if (disabledPkg != null ? (disabledPackageAppInfo = disabledPkg.applicationInfo) != null && (disabledPackageAppInfo.flags & 8) == 0 : (pkg.applicationInfo.flags & 8) == 0) {
            return false;
        }
        return this.mServiceInternal.isPlatformSigned(pkg.packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantDefaultPermissionExceptions(int userId) {
        this.mHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mGrantExceptions == null) {
                this.mGrantExceptions = this.readDefaultPermissionExceptionsLocked();
            }
        }
        ArraySet<String> permissions = null;
        int exceptionCount = this.mGrantExceptions.size();
        for (int i = 0; i < exceptionCount; ++i) {
            String packageName = this.mGrantExceptions.keyAt(i);
            PackageInfo pkg = this.getSystemPackageInfo(packageName);
            List<DefaultPermissionGrant> permissionGrants = this.mGrantExceptions.valueAt(i);
            int permissionGrantCount = permissionGrants.size();
            for (int j = 0; j < permissionGrantCount; ++j) {
                DefaultPermissionGrant permissionGrant = permissionGrants.get(j);
                if (!this.isPermissionDangerous(permissionGrant.name)) {
                    Log.w(TAG, "Ignoring permission " + permissionGrant.name + " which isn't dangerous");
                    continue;
                }
                if (permissions == null) {
                    permissions = new ArraySet<String>();
                } else {
                    permissions.clear();
                }
                permissions.add(permissionGrant.name);
                this.grantRuntimePermissions(pkg, permissions, permissionGrant.fixed, permissionGrant.whitelisted, true, userId);
            }
        }
    }

    private File[] getDefaultPermissionFiles() {
        ArrayList ret = new ArrayList();
        File dir = new File(Environment.getRootDirectory(), "etc/default-permissions");
        if (dir.isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        if ((dir = new File(Environment.getVendorDirectory(), "etc/default-permissions")).isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        if ((dir = new File(Environment.getOdmDirectory(), "etc/default-permissions")).isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        if ((dir = new File(Environment.getProductDirectory(), "etc/default-permissions")).isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        if ((dir = new File(Environment.getProductServicesDirectory(), "etc/default-permissions")).isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.embedded", 0) && (dir = new File(Environment.getOemDirectory(), "etc/default-permissions")).isDirectory() && dir.canRead()) {
            Collections.addAll(ret, dir.listFiles());
        }
        return ret.isEmpty() ? null : ret.toArray(new File[0]);
    }

    private ArrayMap<String, List<DefaultPermissionGrant>> readDefaultPermissionExceptionsLocked() {
        File[] files = this.getDefaultPermissionFiles();
        if (files == null) {
            return new ArrayMap<String, List<DefaultPermissionGrant>>(0);
        }
        ArrayMap<String, List<DefaultPermissionGrant>> grantExceptions = new ArrayMap<String, List<DefaultPermissionGrant>>();
        for (File file : files) {
            if (!file.getPath().endsWith(".xml")) {
                Slog.i(TAG, "Non-xml file " + file + " in " + file.getParent() + " directory, ignoring");
                continue;
            }
            if (!file.canRead()) {
                Slog.w(TAG, "Default permissions file " + file + " cannot be read");
                continue;
            }
            try (BufferedInputStream str = new BufferedInputStream(new FileInputStream(file));){
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(str, null);
                this.parse(parser, grantExceptions);
            }
            catch (IOException | XmlPullParserException e) {
                Slog.w(TAG, "Error reading default permissions file " + file, e);
            }
        }
        return grantExceptions;
    }

    private void parse(XmlPullParser parser, Map<String, List<DefaultPermissionGrant>> outGrantExceptions) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (TAG_EXCEPTIONS.equals(parser.getName())) {
                this.parseExceptions(parser, outGrantExceptions);
                continue;
            }
            Log.e(TAG, "Unknown tag " + parser.getName());
        }
    }

    private void parseExceptions(XmlPullParser parser, Map<String, List<DefaultPermissionGrant>> outGrantExceptions) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (TAG_EXCEPTION.equals(parser.getName())) {
                String packageName = parser.getAttributeValue(null, ATTR_PACKAGE);
                List<DefaultPermissionGrant> packageExceptions = outGrantExceptions.get(packageName);
                if (packageExceptions == null) {
                    PackageInfo packageInfo = this.getSystemPackageInfo(packageName);
                    if (packageInfo == null) {
                        Log.w(TAG, "No such package:" + packageName);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    if (!this.isSystemPackage(packageInfo)) {
                        Log.w(TAG, "Unknown system package:" + packageName);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    if (!DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(packageInfo)) {
                        Log.w(TAG, "Skipping non supporting runtime permissions package:" + packageName);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    packageExceptions = new ArrayList<DefaultPermissionGrant>();
                    outGrantExceptions.put(packageName, packageExceptions);
                }
                this.parsePermission(parser, packageExceptions);
                continue;
            }
            Log.e(TAG, "Unknown tag " + parser.getName() + "under <exceptions>");
        }
    }

    private void parsePermission(XmlPullParser parser, List<DefaultPermissionGrant> outPackageExceptions) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (TAG_PERMISSION.contains(parser.getName())) {
                String name = parser.getAttributeValue(null, ATTR_NAME);
                if (name == null) {
                    Log.w(TAG, "Mandatory name attribute missing for permission tag");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                boolean fixed = XmlUtils.readBooleanAttribute(parser, ATTR_FIXED);
                boolean whitelisted = XmlUtils.readBooleanAttribute(parser, ATTR_WHITELISTED);
                DefaultPermissionGrant exception = new DefaultPermissionGrant(name, fixed, whitelisted);
                outPackageExceptions.add(exception);
                continue;
            }
            Log.e(TAG, "Unknown tag " + parser.getName() + "under <exception>");
        }
    }

    private static boolean doesPackageSupportRuntimePermissions(PackageInfo pkg) {
        return pkg.applicationInfo != null && pkg.applicationInfo.targetSdkVersion > 22;
    }

    private boolean isPermissionRestricted(String name) {
        try {
            return this.mContext.getPackageManager().getPermissionInfo(name, 0).isRestricted();
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private boolean isPermissionDangerous(String name) {
        try {
            PermissionInfo pi = this.mContext.getPackageManager().getPermissionInfo(name, 0);
            return pi.getProtection() == 1;
        }
        catch (PackageManager.NameNotFoundException e) {
            return true;
        }
    }

    static {
        PHONE_PERMISSIONS.add("android.permission.READ_PHONE_STATE");
        PHONE_PERMISSIONS.add("android.permission.CALL_PHONE");
        PHONE_PERMISSIONS.add("android.permission.READ_CALL_LOG");
        PHONE_PERMISSIONS.add("android.permission.WRITE_CALL_LOG");
        PHONE_PERMISSIONS.add("com.android.voicemail.permission.ADD_VOICEMAIL");
        PHONE_PERMISSIONS.add("android.permission.USE_SIP");
        PHONE_PERMISSIONS.add("android.permission.PROCESS_OUTGOING_CALLS");
        CONTACTS_PERMISSIONS = new ArraySet<String>();
        CONTACTS_PERMISSIONS.add("android.permission.READ_CONTACTS");
        CONTACTS_PERMISSIONS.add("android.permission.WRITE_CONTACTS");
        CONTACTS_PERMISSIONS.add("android.permission.GET_ACCOUNTS");
        ALWAYS_LOCATION_PERMISSIONS = new ArraySet<String>();
        ALWAYS_LOCATION_PERMISSIONS.add("android.permission.ACCESS_FINE_LOCATION");
        ALWAYS_LOCATION_PERMISSIONS.add("android.permission.ACCESS_COARSE_LOCATION");
        ALWAYS_LOCATION_PERMISSIONS.add("android.permission.ACCESS_BACKGROUND_LOCATION");
        ACTIVITY_RECOGNITION_PERMISSIONS = new ArraySet<String>();
        ACTIVITY_RECOGNITION_PERMISSIONS.add("android.permission.ACTIVITY_RECOGNITION");
        CALENDAR_PERMISSIONS = new ArraySet<String>();
        CALENDAR_PERMISSIONS.add("android.permission.READ_CALENDAR");
        CALENDAR_PERMISSIONS.add("android.permission.WRITE_CALENDAR");
        SMS_PERMISSIONS = new ArraySet<String>();
        SMS_PERMISSIONS.add("android.permission.SEND_SMS");
        SMS_PERMISSIONS.add("android.permission.RECEIVE_SMS");
        SMS_PERMISSIONS.add("android.permission.READ_SMS");
        SMS_PERMISSIONS.add("android.permission.RECEIVE_WAP_PUSH");
        SMS_PERMISSIONS.add("android.permission.RECEIVE_MMS");
        SMS_PERMISSIONS.add("android.permission.READ_CELL_BROADCASTS");
        MICROPHONE_PERMISSIONS = new ArraySet<String>();
        MICROPHONE_PERMISSIONS.add("android.permission.RECORD_AUDIO");
        CAMERA_PERMISSIONS = new ArraySet<String>();
        CAMERA_PERMISSIONS.add("android.permission.CAMERA");
        SENSORS_PERMISSIONS = new ArraySet<String>();
        SENSORS_PERMISSIONS.add("android.permission.BODY_SENSORS");
        STORAGE_PERMISSIONS = new ArraySet<String>();
        STORAGE_PERMISSIONS.add("android.permission.READ_EXTERNAL_STORAGE");
        STORAGE_PERMISSIONS.add("android.permission.WRITE_EXTERNAL_STORAGE");
    }

    private static final class DefaultPermissionGrant {
        final String name;
        final boolean fixed;
        final boolean whitelisted;

        public DefaultPermissionGrant(String name, boolean fixed, boolean whitelisted) {
            this.name = name;
            this.fixed = fixed;
            this.whitelisted = whitelisted;
        }
    }
}

