/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.permission;

import android.content.Context;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.metrics.LogMaker;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.os.storage.StorageManager;
import android.os.storage.StorageManagerInternal;
import android.permission.PermissionControllerManager;
import android.permission.PermissionManager;
import android.permission.PermissionManagerInternal;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.SystemConfig;
import com.android.server.Watchdog;
import com.android.server.pm.PackageManagerServiceUtils;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.SharedUserSetting;
import com.android.server.pm.UserManagerService;
import com.android.server.pm.permission.BasePermission;
import com.android.server.pm.permission.DefaultPermissionGrantPolicy;
import com.android.server.pm.permission.PermissionManagerServiceInternal;
import com.android.server.pm.permission.PermissionSettings;
import com.android.server.pm.permission.PermissionsState;
import com.android.server.policy.PermissionPolicyInternal;
import com.android.server.policy.SoftRestrictedPermissionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import libcore.util.EmptyArray;

public class PermissionManagerService {
    private static final String TAG = "PackageManager";
    private static final int GRANT_DENIED = 1;
    private static final int GRANT_INSTALL = 2;
    private static final int GRANT_RUNTIME = 3;
    private static final int GRANT_UPGRADE = 4;
    private static final long BACKUP_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final int MAX_PERMISSION_TREE_FOOTPRINT = 32768;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int BLOCKING_PERMISSION_FLAGS = 52;
    private static final int USER_PERMISSION_FLAGS = 3;
    private static final Map<String, String> FULLER_PERMISSION_MAP = new HashMap<String, String>();
    private final Object mLock;
    private final PackageManagerInternal mPackageManagerInt;
    private final UserManagerInternal mUserManagerInt;
    private PermissionControllerManager mPermissionControllerManager;
    private final DefaultPermissionGrantPolicy mDefaultPermissionGrantPolicy;
    private final SparseArray<ArraySet<String>> mSystemPermissions;
    private final int[] mGlobalGids;
    private final HandlerThread mHandlerThread;
    private final Handler mHandler;
    private final Context mContext;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    @GuardedBy(value={"mLock"})
    private final PermissionSettings mSettings;
    @GuardedBy(value={"mLock"})
    private ArraySet<String> mPrivappPermissionsViolations;
    @GuardedBy(value={"mLock"})
    private boolean mSystemReady;
    @GuardedBy(value={"mLock"})
    private PermissionPolicyInternal mPermissionPolicyInternal;
    @GuardedBy(value={"mLock"})
    private ArrayMap<String, List<String>> mBackgroundPermissions;
    @GuardedBy(value={"mLock"})
    private final SparseBooleanArray mHasNoDelayedPermBackup = new SparseBooleanArray();
    @GuardedBy(value={"mLock"})
    private final ArrayList<PermissionManagerInternal.OnRuntimePermissionStateChangedListener> mRuntimePermissionStateChangedListeners = new ArrayList();
    private static final int UPDATE_PERMISSIONS_ALL = 1;
    private static final int UPDATE_PERMISSIONS_REPLACE_PKG = 2;
    private static final int UPDATE_PERMISSIONS_REPLACE_ALL = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PermissionManagerService(Context context, Object externalLock) {
        this.mContext = context;
        this.mLock = externalLock;
        this.mPackageManagerInt = LocalServices.getService(PackageManagerInternal.class);
        this.mUserManagerInt = LocalServices.getService(UserManagerInternal.class);
        this.mSettings = new PermissionSettings(this.mLock);
        this.mHandlerThread = new ServiceThread(TAG, 10, true);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        Watchdog.getInstance().addThread(this.mHandler);
        this.mDefaultPermissionGrantPolicy = new DefaultPermissionGrantPolicy(context, this.mHandlerThread.getLooper(), this);
        SystemConfig systemConfig = SystemConfig.getInstance();
        this.mSystemPermissions = systemConfig.getSystemPermissions();
        this.mGlobalGids = systemConfig.getGlobalGids();
        ArrayMap<String, SystemConfig.PermissionEntry> permConfig = SystemConfig.getInstance().getPermissions();
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < permConfig.size(); ++i) {
                SystemConfig.PermissionEntry perm = permConfig.valueAt(i);
                BasePermission bp = this.mSettings.getPermissionLocked(perm.name);
                if (bp == null) {
                    bp = new BasePermission(perm.name, "android", 1);
                    this.mSettings.putPermissionLocked(perm.name, bp);
                }
                if (perm.gids == null) continue;
                bp.setGids(perm.gids, perm.perUser);
            }
        }
        PermissionManagerServiceInternalImpl localService = new PermissionManagerServiceInternalImpl();
        LocalServices.addService(PermissionManagerServiceInternal.class, localService);
        LocalServices.addService(PermissionManagerInternal.class, localService);
    }

    public static PermissionManagerServiceInternal create(Context context, Object externalLock) {
        PermissionManagerServiceInternal permMgrInt = LocalServices.getService(PermissionManagerServiceInternal.class);
        if (permMgrInt != null) {
            return permMgrInt;
        }
        new PermissionManagerService(context, externalLock);
        return LocalServices.getService(PermissionManagerServiceInternal.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BasePermission getPermission(String permName) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSettings.getPermissionLocked(permName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkPermission(String permName, String pkgName, int callingUid, int userId) {
        if (!this.mUserManagerInt.exists(userId)) {
            return -1;
        }
        PackageParser.Package pkg = this.mPackageManagerInt.getPackage(pkgName);
        if (pkg != null && pkg.mExtras != null) {
            PermissionsState permissionsState;
            block11: {
                if (this.mPackageManagerInt.filterAppAccess(pkg, callingUid, userId)) {
                    return -1;
                }
                PackageSetting ps = (PackageSetting)pkg.mExtras;
                boolean instantApp = ps.getInstantApp(userId);
                permissionsState = ps.getPermissionsState();
                if (permissionsState.hasPermission(permName, userId)) {
                    if (instantApp) {
                        Object object = this.mLock;
                        synchronized (object) {
                            BasePermission bp = this.mSettings.getPermissionLocked(permName);
                            if (bp != null && bp.isInstant()) {
                                return 0;
                            }
                            break block11;
                        }
                    }
                    return 0;
                }
            }
            if (PermissionManagerService.isImpliedPermissionGranted(permissionsState, permName, userId)) {
                return 0;
            }
        }
        return -1;
    }

    private int checkUidPermission(String permName, PackageParser.Package pkg, int uid, int callingUid) {
        int callingUserId = UserHandle.getUserId(callingUid);
        boolean isCallerInstantApp = this.mPackageManagerInt.getInstantAppPackageName(callingUid) != null;
        boolean isUidInstantApp = this.mPackageManagerInt.getInstantAppPackageName(uid) != null;
        int userId = UserHandle.getUserId(uid);
        if (!this.mUserManagerInt.exists(userId)) {
            return -1;
        }
        if (pkg != null) {
            if (pkg.mSharedUserId != null ? isCallerInstantApp : this.mPackageManagerInt.filterAppAccess(pkg, callingUid, callingUserId)) {
                return -1;
            }
            PermissionsState permissionsState = ((PackageSetting)pkg.mExtras).getPermissionsState();
            if (permissionsState.hasPermission(permName, userId)) {
                if (isUidInstantApp) {
                    if (this.mSettings.isPermissionInstant(permName)) {
                        return 0;
                    }
                } else {
                    return 0;
                }
            }
            if (PermissionManagerService.isImpliedPermissionGranted(permissionsState, permName, userId)) {
                return 0;
            }
        } else {
            ArraySet<String> perms = this.mSystemPermissions.get(uid);
            if (perms != null) {
                if (perms.contains(permName)) {
                    return 0;
                }
                if (FULLER_PERMISSION_MAP.containsKey(permName) && perms.contains(FULLER_PERMISSION_MAP.get(permName))) {
                    return 0;
                }
            }
        }
        return -1;
    }

    private byte[] backupRuntimePermissions(UserHandle user) {
        CompletableFuture backup = new CompletableFuture();
        this.mPermissionControllerManager.getRuntimePermissionBackup(user, this.mContext.getMainExecutor(), backup::complete);
        try {
            return (byte[])backup.get(BACKUP_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Slog.e(TAG, "Cannot create permission backup for " + user, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreRuntimePermissions(byte[] backup, UserHandle user) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHasNoDelayedPermBackup.delete(user.getIdentifier());
            this.mPermissionControllerManager.restoreRuntimePermissionBackup(backup, user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreDelayedRuntimePermissions(String packageName, UserHandle user) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHasNoDelayedPermBackup.get(user.getIdentifier(), false)) {
                return;
            }
            this.mPermissionControllerManager.restoreDelayedRuntimePermissionBackup(packageName, user, this.mContext.getMainExecutor(), hasMoreBackup -> {
                if (hasMoreBackup.booleanValue()) {
                    return;
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mHasNoDelayedPermBackup.put(user.getIdentifier(), true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOnRuntimePermissionStateChangedListener(PermissionManagerInternal.OnRuntimePermissionStateChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRuntimePermissionStateChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOnRuntimePermissionStateChangedListener(PermissionManagerInternal.OnRuntimePermissionStateChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRuntimePermissionStateChangedListeners.remove(listener);
        }
    }

    private void notifyRuntimePermissionStateChanged(String packageName, int userId) {
        FgThread.getHandler().sendMessage(PooledLambda.obtainMessage(PermissionManagerService::doNotifyRuntimePermissionStateChanged, this, packageName, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotifyRuntimePermissionStateChanged(String packageName, int userId) {
        ArrayList<PermissionManagerInternal.OnRuntimePermissionStateChangedListener> listeners;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRuntimePermissionStateChangedListeners.isEmpty()) {
                return;
            }
            listeners = new ArrayList<PermissionManagerInternal.OnRuntimePermissionStateChangedListener>(this.mRuntimePermissionStateChangedListeners);
        }
        int listenerCount = listeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            listeners.get(i).onRuntimePermissionStateChanged(packageName, userId);
        }
    }

    private static boolean isImpliedPermissionGranted(PermissionsState permissionsState, String permName, int userId) {
        return FULLER_PERMISSION_MAP.containsKey(permName) && permissionsState.hasPermission(FULLER_PERMISSION_MAP.get(permName), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionGroupInfo getPermissionGroupInfo(String groupName, int flags, int callingUid) {
        if (this.mPackageManagerInt.getInstantAppPackageName(callingUid) != null) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            return PackageParser.generatePermissionGroupInfo(this.mSettings.mPermissionGroups.get(groupName), flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PermissionGroupInfo> getAllPermissionGroups(int flags, int callingUid) {
        if (this.mPackageManagerInt.getInstantAppPackageName(callingUid) != null) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            int N = this.mSettings.mPermissionGroups.size();
            ArrayList<PermissionGroupInfo> out = new ArrayList<PermissionGroupInfo>(N);
            for (PackageParser.PermissionGroup pg : this.mSettings.mPermissionGroups.values()) {
                out.add(PackageParser.generatePermissionGroupInfo(pg, flags));
            }
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionInfo getPermissionInfo(String permName, String packageName, int flags, int callingUid) {
        if (this.mPackageManagerInt.getInstantAppPackageName(callingUid) != null) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            BasePermission bp = this.mSettings.getPermissionLocked(permName);
            if (bp == null) {
                return null;
            }
            int adjustedProtectionLevel = this.adjustPermissionProtectionFlagsLocked(bp.getProtectionLevel(), packageName, callingUid);
            return bp.generatePermissionInfo(adjustedProtectionLevel, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PermissionInfo> getPermissionInfoByGroup(String groupName, int flags, int callingUid) {
        if (this.mPackageManagerInt.getInstantAppPackageName(callingUid) != null) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (groupName != null && !this.mSettings.mPermissionGroups.containsKey(groupName)) {
                return null;
            }
            ArrayList<PermissionInfo> out = new ArrayList<PermissionInfo>(10);
            for (BasePermission bp : this.mSettings.mPermissions.values()) {
                PermissionInfo pi = bp.generatePermissionInfo(groupName, flags);
                if (pi == null) continue;
                out.add(pi);
            }
            return out;
        }
    }

    private int adjustPermissionProtectionFlagsLocked(int protectionLevel, String packageName, int uid) {
        int protectionLevelMasked = protectionLevel & 3;
        if (protectionLevelMasked == 2) {
            return protectionLevel;
        }
        int appId = UserHandle.getAppId(uid);
        if (appId == 1000 || appId == 0 || appId == 2000) {
            return protectionLevel;
        }
        PackageParser.Package pkg = this.mPackageManagerInt.getPackage(packageName);
        if (pkg == null) {
            return protectionLevel;
        }
        if (pkg.applicationInfo.targetSdkVersion < 26) {
            return protectionLevelMasked;
        }
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return protectionLevel;
        }
        if (ps.getAppId() != appId) {
            return protectionLevel;
        }
        return protectionLevel;
    }

    private void revokeRuntimePermissionsIfGroupChanged(PackageParser.Package newPackage, PackageParser.Package oldPackage, ArrayList<String> allPackageNames, PermissionManagerServiceInternal.PermissionCallback permissionCallback) {
        int numOldPackagePermissions = oldPackage.permissions.size();
        ArrayMap<String, String> oldPermissionNameToGroupName = new ArrayMap<String, String>(numOldPackagePermissions);
        for (int i = 0; i < numOldPackagePermissions; ++i) {
            PackageParser.Permission permission2 = oldPackage.permissions.get(i);
            if (permission2.group == null) continue;
            oldPermissionNameToGroupName.put(permission2.info.name, permission2.group.info.name);
        }
        int numNewPackagePermissions = newPackage.permissions.size();
        for (int newPermissionNum = 0; newPermissionNum < numNewPackagePermissions; ++newPermissionNum) {
            PackageParser.Permission newPermission = newPackage.permissions.get(newPermissionNum);
            int newProtection = newPermission.info.getProtection();
            if ((newProtection & 1) == 0) continue;
            String permissionName = newPermission.info.name;
            String newPermissionGroupName = newPermission.group == null ? null : newPermission.group.info.name;
            String oldPermissionGroupName = (String)oldPermissionNameToGroupName.get(permissionName);
            if (newPermissionGroupName == null || newPermissionGroupName.equals(oldPermissionGroupName)) continue;
            for (int userId : this.mUserManagerInt.getUserIds()) {
                int numPackages = allPackageNames.size();
                for (int packageNum = 0; packageNum < numPackages; ++packageNum) {
                    String packageName = allPackageNames.get(packageNum);
                    if (this.checkPermission(permissionName, packageName, 0, userId) != 0) continue;
                    EventLog.writeEvent(1397638484, "72710897", newPackage.applicationInfo.uid, "Revoking permission " + permissionName + " from package " + packageName + " as the group changed from " + oldPermissionGroupName + " to " + newPermissionGroupName);
                    try {
                        this.revokeRuntimePermission(permissionName, packageName, false, userId, permissionCallback);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Slog.e(TAG, "Could not revoke " + permissionName + " from " + packageName, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllPermissions(PackageParser.Package pkg, boolean chatty) {
        int N = pkg.permissions.size();
        for (int i = 0; i < N; ++i) {
            PackageParser.Permission p = pkg.permissions.get(i);
            p.info.flags &= 0xBFFFFFFF;
            Object object = this.mLock;
            synchronized (object) {
                BasePermission bp;
                if (pkg.applicationInfo.targetSdkVersion > 22) {
                    p.group = this.mSettings.mPermissionGroups.get(p.info.group);
                }
                if (p.tree) {
                    bp = BasePermission.createOrUpdate(this.mSettings.getPermissionTreeLocked(p.info.name), p, pkg, this.mSettings.getAllPermissionTreesLocked(), chatty);
                    this.mSettings.putPermissionTreeLocked(p.info.name, bp);
                } else {
                    bp = BasePermission.createOrUpdate(this.mSettings.getPermissionLocked(p.info.name), p, pkg, this.mSettings.getAllPermissionTreesLocked(), chatty);
                    this.mSettings.putPermissionLocked(p.info.name, bp);
                }
                continue;
            }
        }
    }

    private void addAllPermissionGroups(PackageParser.Package pkg, boolean chatty) {
        int N = pkg.permissionGroups.size();
        Object r = null;
        for (int i = 0; i < N; ++i) {
            PackageParser.PermissionGroup pg = pkg.permissionGroups.get(i);
            PackageParser.PermissionGroup cur = this.mSettings.mPermissionGroups.get(pg.info.name);
            String curPackageName = cur == null ? null : cur.info.packageName;
            boolean isPackageUpdate = pg.info.packageName.equals(curPackageName);
            if (cur == null || isPackageUpdate) {
                this.mSettings.mPermissionGroups.put(pg.info.name, pg);
                if (!chatty) continue;
                continue;
            }
            Slog.w(TAG, "Permission group " + pg.info.name + " from package " + pg.info.packageName + " ignored: original from " + cur.info.packageName);
            if (!chatty) continue;
        }
        if (r != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllPermissions(PackageParser.Package pkg, boolean chatty) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            int N = pkg.permissions.size();
            Object r = null;
            for (i = 0; i < N; ++i) {
                ArraySet<String> appOpPkgs;
                PackageParser.Permission p = pkg.permissions.get(i);
                BasePermission bp = this.mSettings.mPermissions.get(p.info.name);
                if (bp == null) {
                    bp = this.mSettings.mPermissionTrees.get(p.info.name);
                }
                if (bp != null && bp.isPermission(p)) {
                    bp.setPermission(null);
                }
                if (!p.isAppOp() || (appOpPkgs = this.mSettings.mAppOpPermissionPackages.get(p.info.name)) == null) continue;
                appOpPkgs.remove(pkg.packageName);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.requestedPermissions.size();
            r = null;
            for (i = 0; i < N; ++i) {
                ArraySet<String> appOpPkgs;
                String perm = pkg.requestedPermissions.get(i);
                if (!this.mSettings.isPermissionAppOp(perm) || (appOpPkgs = this.mSettings.mAppOpPermissionPackages.get(perm)) == null) continue;
                appOpPkgs.remove(pkg.packageName);
                if (!appOpPkgs.isEmpty()) continue;
                this.mSettings.mAppOpPermissionPackages.remove(perm);
            }
            if (r != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDynamicPermission(PermissionInfo info, int callingUid, PermissionManagerServiceInternal.PermissionCallback callback) {
        boolean changed;
        boolean added;
        if (this.mPackageManagerInt.getInstantAppPackageName(callingUid) != null) {
            throw new SecurityException("Instant apps can't add permissions");
        }
        if (info.labelRes == 0 && info.nonLocalizedLabel == null) {
            throw new SecurityException("Label must be specified in permission");
        }
        BasePermission tree = this.mSettings.enforcePermissionTree(info.name, callingUid);
        Object object = this.mLock;
        synchronized (object) {
            BasePermission bp = this.mSettings.getPermissionLocked(info.name);
            added = bp == null;
            int fixedLevel = PermissionInfo.fixProtectionLevel(info.protectionLevel);
            if (added) {
                this.enforcePermissionCapLocked(info, tree);
                bp = new BasePermission(info.name, tree.getSourcePackageName(), 2);
            } else if (!bp.isDynamic()) {
                throw new SecurityException("Not allowed to modify non-dynamic permission " + info.name);
            }
            changed = bp.addToTree(fixedLevel, info, tree);
            if (added) {
                this.mSettings.putPermissionLocked(info.name, bp);
            }
        }
        if (changed && callback != null) {
            callback.onPermissionChanged();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDynamicPermission(String permName, int callingUid, PermissionManagerServiceInternal.PermissionCallback callback) {
        if (this.mPackageManagerInt.getInstantAppPackageName(callingUid) != null) {
            throw new SecurityException("Instant applications don't have access to this method");
        }
        BasePermission tree = this.mSettings.enforcePermissionTree(permName, callingUid);
        Object object = this.mLock;
        synchronized (object) {
            BasePermission bp = this.mSettings.getPermissionLocked(permName);
            if (bp == null) {
                return;
            }
            if (bp.isDynamic()) {
                Slog.wtf(TAG, "Not allowed to modify non-dynamic permission " + permName);
            }
            this.mSettings.removePermissionLocked(permName);
            if (callback != null) {
                callback.onPermissionRemoved();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePermissionState(PackageParser.Package pkg, boolean replace, String packageOfInterest, PermissionManagerServiceInternal.PermissionCallback callback) {
        Object object;
        PermissionsState permissionsState;
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        PermissionsState origPermissions = permissionsState = ps.getPermissionsState();
        int[] currentUserIds = UserManagerService.getInstance().getUserIds();
        boolean runtimePermissionsRevoked = false;
        int[] updatedUserIds = EMPTY_INT_ARRAY;
        boolean changedInstallPermission = false;
        if (replace) {
            ps.setInstallPermissionsFixed(false);
            if (!ps.isSharedUser()) {
                origPermissions = new PermissionsState(permissionsState);
                permissionsState.reset();
            } else {
                object = this.mLock;
                synchronized (object) {
                    updatedUserIds = this.revokeUnusedSharedUserPermissionsLocked(ps.getSharedUser(), UserManagerService.getInstance().getUserIds());
                    if (!ArrayUtils.isEmpty(updatedUserIds)) {
                        runtimePermissionsRevoked = true;
                    }
                }
            }
        }
        permissionsState.setGlobalGids(this.mGlobalGids);
        object = this.mLock;
        synchronized (object) {
            ArraySet<String> newImplicitPermissions = new ArraySet<String>();
            int N = pkg.requestedPermissions.size();
            block11: for (int i = 0; i < N; ++i) {
                Object splitPermName;
                String permName = pkg.requestedPermissions.get(i);
                BasePermission bp = this.mSettings.getPermissionLocked(permName);
                boolean appSupportsRuntimePermissions = pkg.applicationInfo.targetSdkVersion >= 23;
                Object upgradedActivityRecognitionPermission = null;
                if (bp == null || bp.getSourcePackageSetting() == null) {
                    if (packageOfInterest == null || !packageOfInterest.equals(pkg.packageName)) continue;
                    continue;
                }
                if (!origPermissions.hasRequestedPermission(permName) && (pkg.implicitPermissions.contains(permName) || permName.equals("android.permission.ACTIVITY_RECOGNITION"))) {
                    if (pkg.implicitPermissions.contains(permName)) {
                        newImplicitPermissions.add(permName);
                    } else {
                        int numSplitPerms = PermissionManager.SPLIT_PERMISSIONS.size();
                        for (int splitPermNum = 0; splitPermNum < numSplitPerms; ++splitPermNum) {
                            PermissionManager.SplitPermissionInfo sp = PermissionManager.SPLIT_PERMISSIONS.get(splitPermNum);
                            splitPermName = sp.getSplitPermission();
                            if (!sp.getNewPermissions().contains(permName) || !origPermissions.hasInstallPermission((String)splitPermName)) continue;
                            upgradedActivityRecognitionPermission = splitPermName;
                            newImplicitPermissions.add(permName);
                            break;
                        }
                    }
                }
                if (pkg.applicationInfo.isInstantApp() && !bp.isInstant() || bp.isRuntimeOnly() && !appSupportsRuntimePermissions) continue;
                String perm = bp.getName();
                boolean allowedSig = false;
                int grant = 1;
                if (bp.isAppOp()) {
                    this.mSettings.addAppOpPackage(perm, pkg.packageName);
                }
                if (bp.isNormal()) {
                    grant = 2;
                } else if (bp.isRuntime()) {
                    grant = origPermissions.hasInstallPermission(bp.getName()) || upgradedActivityRecognitionPermission != null ? 4 : 3;
                } else if (bp.isSignature() && (allowedSig = this.grantSignaturePermission(perm, pkg, bp, origPermissions))) {
                    grant = 2;
                }
                if (grant != 1) {
                    if (!(ps.isSystem() || !ps.areInstallPermissionsFixed() || bp.isRuntime() || allowedSig || origPermissions.hasInstallPermission(perm) || this.isNewPlatformPermissionForPackage(perm, pkg))) {
                        grant = 1;
                    }
                    switch (grant) {
                        case 2: {
                            splitPermName = UserManagerService.getInstance().getUserIds();
                            int n = ((Object)splitPermName).length;
                            for (int j = 0; j < n; ++j) {
                                Object userId = splitPermName[j];
                                if (origPermissions.getRuntimePermissionState(perm, (int)userId) == null) continue;
                                origPermissions.revokeRuntimePermission(bp, (int)userId);
                                origPermissions.updatePermissionFlags(bp, (int)userId, 64511, 0);
                                updatedUserIds = ArrayUtils.appendInt(updatedUserIds, userId);
                            }
                            if (permissionsState.grantInstallPermission(bp) == -1) continue block11;
                            changedInstallPermission = true;
                            break;
                        }
                        case 3: {
                            boolean hardRestricted = bp.isHardRestricted();
                            boolean softRestricted = bp.isSoftRestricted();
                            for (int userId : currentUserIds) {
                                boolean restrictionApplied;
                                boolean permissionPolicyInitialized = this.mPermissionPolicyInternal != null && this.mPermissionPolicyInternal.isInitialized(userId);
                                PermissionsState.PermissionState permState = origPermissions.getRuntimePermissionState(perm, userId);
                                int flags = permState != null ? permState.getFlags() : 0;
                                boolean wasChanged = false;
                                boolean restrictionExempt = (origPermissions.getPermissionFlags(bp.name, userId) & 0x3800) != 0;
                                boolean bl = restrictionApplied = (origPermissions.getPermissionFlags(bp.name, userId) & 0x4000) != 0;
                                if (appSupportsRuntimePermissions) {
                                    if (permissionPolicyInitialized && hardRestricted) {
                                        if (!restrictionExempt) {
                                            if (permState != null && permState.isGranted() && permissionsState.revokeRuntimePermission(bp, userId) != -1) {
                                                wasChanged = true;
                                            }
                                            if (!restrictionApplied) {
                                                flags |= 0x4000;
                                                wasChanged = true;
                                            }
                                        }
                                    } else if (permissionPolicyInitialized && softRestricted && !restrictionExempt && !restrictionApplied) {
                                        flags |= 0x4000;
                                        wasChanged = true;
                                    }
                                    if ((flags & 0x40) != 0) {
                                        flags &= 0xFFFFFFBF;
                                        wasChanged = true;
                                    }
                                    if ((flags & 8) != 0) {
                                        flags &= 0xFFFFFFF7;
                                        wasChanged = true;
                                    } else if ((!permissionPolicyInitialized || !hardRestricted || restrictionExempt) && permState != null && permState.isGranted() && permissionsState.grantRuntimePermission(bp, userId) == -1) {
                                        wasChanged = true;
                                    }
                                } else {
                                    if (permState == null && "android".equals(bp.getSourcePackageName()) && !bp.isRemoved()) {
                                        flags |= 0x48;
                                        wasChanged = true;
                                    }
                                    if (!permissionsState.hasRuntimePermission(bp.name, userId) && permissionsState.grantRuntimePermission(bp, userId) != -1) {
                                        wasChanged = true;
                                    }
                                    if (permissionPolicyInitialized && (hardRestricted || softRestricted) && !restrictionExempt && !restrictionApplied) {
                                        flags |= 0x4000;
                                        wasChanged = true;
                                    }
                                }
                                if (permissionPolicyInitialized && (!hardRestricted && !softRestricted || restrictionExempt) && restrictionApplied) {
                                    flags &= 0xFFFFBFFF;
                                    if (!appSupportsRuntimePermissions) {
                                        flags |= 0x40;
                                    }
                                    wasChanged = true;
                                }
                                if (wasChanged) {
                                    updatedUserIds = ArrayUtils.appendInt(updatedUserIds, userId);
                                }
                                permissionsState.updatePermissionFlags(bp, userId, 64511, flags);
                            }
                            continue block11;
                        }
                        case 4: {
                            BasePermission bpToRevoke;
                            PermissionsState.PermissionState permState = origPermissions.getInstallPermissionState(perm);
                            int flags = permState != null ? permState.getFlags() : 0;
                            BasePermission basePermission = bpToRevoke = upgradedActivityRecognitionPermission == null ? bp : this.mSettings.getPermissionLocked((String)upgradedActivityRecognitionPermission);
                            if (origPermissions.revokeInstallPermission(bpToRevoke) != -1) {
                                origPermissions.updatePermissionFlags(bpToRevoke, -1, 48127, 0);
                                changedInstallPermission = true;
                            }
                            boolean hardRestricted = bp.isHardRestricted();
                            boolean softRestricted = bp.isSoftRestricted();
                            for (int userId : currentUserIds) {
                                boolean restrictionApplied;
                                boolean permissionPolicyInitialized = this.mPermissionPolicyInternal != null && this.mPermissionPolicyInternal.isInitialized(userId);
                                boolean wasChanged = false;
                                boolean restrictionExempt = (origPermissions.getPermissionFlags(bp.name, userId) & 0x3800) != 0;
                                boolean bl = restrictionApplied = (origPermissions.getPermissionFlags(bp.name, userId) & 0x4000) != 0;
                                if (appSupportsRuntimePermissions) {
                                    if (permissionPolicyInitialized && hardRestricted) {
                                        if (!restrictionExempt) {
                                            if (permState != null && permState.isGranted() && permissionsState.revokeRuntimePermission(bp, userId) != -1) {
                                                wasChanged = true;
                                            }
                                            if (!restrictionApplied) {
                                                flags |= 0x4000;
                                                wasChanged = true;
                                            }
                                        }
                                    } else if (permissionPolicyInitialized && softRestricted && !restrictionExempt && !restrictionApplied) {
                                        flags |= 0x4000;
                                        wasChanged = true;
                                    }
                                    if ((flags & 0x40) != 0) {
                                        flags &= 0xFFFFFFBF;
                                        wasChanged = true;
                                    }
                                    if ((flags & 8) != 0) {
                                        flags &= 0xFFFFFFF7;
                                        wasChanged = true;
                                    } else if (!(permissionPolicyInitialized && hardRestricted && !restrictionExempt || permissionsState.grantRuntimePermission(bp, userId) == -1)) {
                                        wasChanged = true;
                                    }
                                } else {
                                    if (!permissionsState.hasRuntimePermission(bp.name, userId) && permissionsState.grantRuntimePermission(bp, userId) != -1) {
                                        flags |= 0x40;
                                        wasChanged = true;
                                    }
                                    if (permissionPolicyInitialized && (hardRestricted || softRestricted) && !restrictionExempt && !restrictionApplied) {
                                        flags |= 0x4000;
                                        wasChanged = true;
                                    }
                                }
                                if (permissionPolicyInitialized && (!hardRestricted && !softRestricted || restrictionExempt) && restrictionApplied) {
                                    flags &= 0xFFFFBFFF;
                                    if (!appSupportsRuntimePermissions) {
                                        flags |= 0x40;
                                    }
                                    wasChanged = true;
                                }
                                if (wasChanged) {
                                    updatedUserIds = ArrayUtils.appendInt(updatedUserIds, userId);
                                }
                                permissionsState.updatePermissionFlags(bp, userId, 64511, flags);
                            }
                            continue block11;
                        }
                        default: {
                            if (packageOfInterest == null || !packageOfInterest.equals(pkg.packageName)) continue block11;
                            break;
                        }
                    }
                    continue;
                }
                if (permissionsState.revokeInstallPermission(bp) != -1) {
                    permissionsState.updatePermissionFlags(bp, -1, 64511, 0);
                    changedInstallPermission = true;
                    Slog.i(TAG, "Un-granting permission " + perm + " from package " + pkg.packageName + " (protectionLevel=" + bp.getProtectionLevel() + " flags=0x" + Integer.toHexString(pkg.applicationInfo.flags) + ")");
                    continue;
                }
                if (!bp.isAppOp()) continue;
            }
            if ((changedInstallPermission || replace) && !ps.areInstallPermissionsFixed() && !ps.isSystem() || ps.isUpdatedSystem()) {
                ps.setInstallPermissionsFixed(true);
            }
            updatedUserIds = this.revokePermissionsNoLongerImplicitLocked(permissionsState, pkg, updatedUserIds);
            updatedUserIds = this.setInitialGrantForNewImplicitPermissionsLocked(origPermissions, permissionsState, pkg, newImplicitPermissions, updatedUserIds);
            updatedUserIds = this.checkIfLegacyStorageOpsNeedToBeUpdated(pkg, replace, updatedUserIds);
        }
        if (callback != null) {
            callback.onPermissionUpdated(updatedUserIds, runtimePermissionsRevoked);
        }
        for (Object userId : (Object)updatedUserIds) {
            this.notifyRuntimePermissionStateChanged(pkg.packageName, (int)userId);
        }
    }

    private int[] revokePermissionsNoLongerImplicitLocked(PermissionsState ps, PackageParser.Package pkg, int[] updatedUserIds) {
        String pkgName = pkg.packageName;
        boolean supportsRuntimePermissions = pkg.applicationInfo.targetSdkVersion >= 23;
        for (int userId : UserManagerService.getInstance().getUserIds()) {
            for (String permission2 : ps.getPermissions(userId)) {
                int flags;
                if (pkg.implicitPermissions.contains(permission2) || ps.hasInstallPermission(permission2) || ((flags = ps.getRuntimePermissionState(permission2, userId).getFlags()) & 0x80) == 0) continue;
                BasePermission bp = this.mSettings.getPermissionLocked(permission2);
                int flagsToRemove = 128;
                if ((flags & 0x34) == 0 && supportsRuntimePermissions) {
                    int revokeResult = ps.revokeRuntimePermission(bp, userId);
                    if (revokeResult != -1) {
                        // empty if block
                    }
                    flagsToRemove |= 3;
                }
                ps.updatePermissionFlags(bp, userId, flagsToRemove, 0);
                updatedUserIds = ArrayUtils.appendInt(updatedUserIds, userId);
            }
        }
        return updatedUserIds;
    }

    private void inheritPermissionStateToNewImplicitPermissionLocked(ArraySet<String> sourcePerms, String newPerm, PermissionsState ps, PackageParser.Package pkg, int userId) {
        String pkgName = pkg.packageName;
        boolean isGranted = false;
        int flags = 0;
        int numSourcePerm = sourcePerms.size();
        for (int i = 0; i < numSourcePerm; ++i) {
            String sourcePerm = sourcePerms.valueAt(i);
            if (ps.hasRuntimePermission(sourcePerm, userId) || ps.hasInstallPermission(sourcePerm)) {
                if (!isGranted) {
                    flags = 0;
                }
                isGranted = true;
                flags |= ps.getPermissionFlags(sourcePerm, userId);
                continue;
            }
            if (isGranted) continue;
            flags |= ps.getPermissionFlags(sourcePerm, userId);
        }
        if (isGranted) {
            ps.grantRuntimePermission(this.mSettings.getPermissionLocked(newPerm), userId);
        }
        ps.updatePermissionFlags(this.mSettings.getPermission(newPerm), userId, flags, flags);
    }

    private int[] checkIfLegacyStorageOpsNeedToBeUpdated(PackageParser.Package pkg, boolean replace, int[] updatedUserIds) {
        if (replace && pkg.applicationInfo.hasRequestedLegacyExternalStorage() && (pkg.requestedPermissions.contains("android.permission.READ_EXTERNAL_STORAGE") || pkg.requestedPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE"))) {
            return UserManagerService.getInstance().getUserIds();
        }
        return updatedUserIds;
    }

    private int[] setInitialGrantForNewImplicitPermissionsLocked(PermissionsState origPs, PermissionsState ps, PackageParser.Package pkg, ArraySet<String> newImplicitPermissions, int[] updatedUserIds) {
        String pkgName = pkg.packageName;
        ArrayMap<String, ArraySet<String>> newToSplitPerms = new ArrayMap<String, ArraySet<String>>();
        int numSplitPerms = PermissionManager.SPLIT_PERMISSIONS.size();
        for (int splitPermNum = 0; splitPermNum < numSplitPerms; ++splitPermNum) {
            PermissionManager.SplitPermissionInfo spi = PermissionManager.SPLIT_PERMISSIONS.get(splitPermNum);
            List<String> newPerms = spi.getNewPermissions();
            int numNewPerms = newPerms.size();
            for (int newPermNum = 0; newPermNum < numNewPerms; ++newPermNum) {
                String newPerm = newPerms.get(newPermNum);
                ArraySet<String> splitPerms = (ArraySet<String>)newToSplitPerms.get(newPerm);
                if (splitPerms == null) {
                    splitPerms = new ArraySet<String>();
                    newToSplitPerms.put(newPerm, splitPerms);
                }
                splitPerms.add(spi.getSplitPermission());
            }
        }
        int numNewImplicitPerms = newImplicitPermissions.size();
        block2: for (int newImplicitPermNum = 0; newImplicitPermNum < numNewImplicitPerms; ++newImplicitPermNum) {
            String newPerm = newImplicitPermissions.valueAt(newImplicitPermNum);
            ArraySet sourcePerms = (ArraySet)newToSplitPerms.get(newPerm);
            if (sourcePerms == null || ps.hasInstallPermission(newPerm)) continue;
            BasePermission bp = this.mSettings.getPermissionLocked(newPerm);
            for (int userId : UserManagerService.getInstance().getUserIds()) {
                if (!newPerm.equals("android.permission.ACTIVITY_RECOGNITION")) {
                    ps.updatePermissionFlags(bp, userId, 128, 128);
                }
                updatedUserIds = ArrayUtils.appendInt(updatedUserIds, userId);
                boolean inheritsFromInstallPerm = false;
                for (int sourcePermNum = 0; sourcePermNum < sourcePerms.size(); ++sourcePermNum) {
                    if (!ps.hasInstallPermission((String)sourcePerms.valueAt(sourcePermNum))) continue;
                    inheritsFromInstallPerm = true;
                    break;
                }
                if (!origPs.hasRequestedPermission(sourcePerms) && !inheritsFromInstallPerm) continue block2;
                this.inheritPermissionStateToNewImplicitPermissionLocked(sourcePerms, newPerm, ps, pkg, userId);
            }
        }
        return updatedUserIds;
    }

    private boolean isNewPlatformPermissionForPackage(String perm, PackageParser.Package pkg) {
        boolean allowed = false;
        for (PackageParser.NewPermissionInfo npi : PackageParser.NEW_PERMISSIONS) {
            if (!npi.name.equals(perm) || pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) continue;
            allowed = true;
            Log.i(TAG, "Auto-granting " + perm + " to old pkg " + pkg.packageName);
            break;
        }
        return allowed;
    }

    private boolean hasPrivappWhitelistEntry(String perm, PackageParser.Package pkg) {
        ArraySet<String> wlPermissions = null;
        wlPermissions = pkg.isVendor() ? SystemConfig.getInstance().getVendorPrivAppPermissions(pkg.packageName) : (pkg.isProduct() ? SystemConfig.getInstance().getProductPrivAppPermissions(pkg.packageName) : (pkg.isProductServices() ? SystemConfig.getInstance().getProductServicesPrivAppPermissions(pkg.packageName) : SystemConfig.getInstance().getPrivAppPermissions(pkg.packageName)));
        boolean whitelisted = wlPermissions != null && wlPermissions.contains(perm);
        return whitelisted || pkg.parentPackage != null && this.hasPrivappWhitelistEntry(perm, pkg.parentPackage);
    }

    private boolean grantSignaturePermission(String perm, PackageParser.Package pkg, BasePermission bp, PermissionsState origPermissions) {
        boolean allowed;
        boolean oemPermission = bp.isOEM();
        boolean vendorPrivilegedPermission = bp.isVendorPrivileged();
        boolean privilegedPermission = bp.isPrivileged() || bp.isVendorPrivileged();
        boolean privappPermissionsDisable = RoSystemProperties.CONTROL_PRIVAPP_PERMISSIONS_DISABLE;
        boolean platformPermission = "android".equals(bp.getSourcePackageName());
        boolean platformPackage = "android".equals(pkg.packageName);
        if (!privappPermissionsDisable && privilegedPermission && pkg.isPrivileged() && !platformPackage && platformPermission && !this.hasPrivappWhitelistEntry(perm, pkg)) {
            if (!this.mSystemReady && !pkg.isUpdatedSystemApp()) {
                boolean permissionViolation;
                ArraySet<String> deniedPermissions = null;
                deniedPermissions = pkg.isVendor() ? SystemConfig.getInstance().getVendorPrivAppDenyPermissions(pkg.packageName) : (pkg.isProduct() ? SystemConfig.getInstance().getProductPrivAppDenyPermissions(pkg.packageName) : (pkg.isProductServices() ? SystemConfig.getInstance().getProductServicesPrivAppDenyPermissions(pkg.packageName) : SystemConfig.getInstance().getPrivAppDenyPermissions(pkg.packageName)));
                boolean bl = permissionViolation = deniedPermissions == null || !deniedPermissions.contains(perm);
                if (permissionViolation) {
                    Slog.w(TAG, "Privileged permission " + perm + " for package " + pkg.packageName + " - not in privapp-permissions whitelist");
                    if (RoSystemProperties.CONTROL_PRIVAPP_PERMISSIONS_ENFORCE) {
                        if (this.mPrivappPermissionsViolations == null) {
                            this.mPrivappPermissionsViolations = new ArraySet();
                        }
                        this.mPrivappPermissionsViolations.add(pkg.packageName + ": " + perm);
                    }
                } else {
                    return false;
                }
            }
            if (RoSystemProperties.CONTROL_PRIVAPP_PERMISSIONS_ENFORCE) {
                return false;
            }
        }
        String systemPackageName = this.mPackageManagerInt.getKnownPackageName(0, 0);
        PackageParser.Package systemPackage = this.mPackageManagerInt.getPackage(systemPackageName);
        boolean bl = allowed = pkg.mSigningDetails.hasAncestorOrSelf(bp.getSourcePackageSetting().getSigningDetails()) || bp.getSourcePackageSetting().getSigningDetails().checkCapability(pkg.mSigningDetails, 4) || pkg.mSigningDetails.hasAncestorOrSelf(systemPackage.mSigningDetails) || systemPackage.mSigningDetails.checkCapability(pkg.mSigningDetails, 4);
        if (!allowed && (privilegedPermission || oemPermission) && pkg.isSystem()) {
            if (pkg.isUpdatedSystemApp()) {
                PackageSetting disabledPs;
                PackageParser.Package disabledPkg = this.mPackageManagerInt.getDisabledSystemPackage(pkg.packageName);
                PackageSetting packageSetting = disabledPs = disabledPkg != null ? (PackageSetting)disabledPkg.mExtras : null;
                if (disabledPs != null && disabledPs.getPermissionsState().hasInstallPermission(perm)) {
                    if (privilegedPermission && disabledPs.isPrivileged() || oemPermission && disabledPs.isOem() && PermissionManagerService.canGrantOemPermission(disabledPs, perm)) {
                        allowed = true;
                    }
                } else {
                    if (disabledPs != null && disabledPkg != null && this.isPackageRequestingPermission(disabledPkg, perm) && (privilegedPermission && disabledPs.isPrivileged() || oemPermission && disabledPs.isOem() && PermissionManagerService.canGrantOemPermission(disabledPs, perm))) {
                        allowed = true;
                    }
                    if (pkg.parentPackage != null) {
                        PackageSetting disabledParentPs;
                        PackageParser.Package disabledParentPkg = this.mPackageManagerInt.getDisabledSystemPackage(pkg.parentPackage.packageName);
                        PackageSetting packageSetting2 = disabledParentPs = disabledParentPkg != null ? (PackageSetting)disabledParentPkg.mExtras : null;
                        if (disabledParentPkg != null && (privilegedPermission && disabledParentPs.isPrivileged() || oemPermission && disabledParentPs.isOem())) {
                            if (this.isPackageRequestingPermission(disabledParentPkg, perm) && PermissionManagerService.canGrantOemPermission(disabledParentPs, perm)) {
                                allowed = true;
                            } else if (disabledParentPkg.childPackages != null) {
                                for (PackageParser.Package disabledChildPkg : disabledParentPkg.childPackages) {
                                    PackageSetting disabledChildPs;
                                    PackageSetting packageSetting3 = disabledChildPs = disabledChildPkg != null ? (PackageSetting)disabledChildPkg.mExtras : null;
                                    if (!this.isPackageRequestingPermission(disabledChildPkg, perm) || !PermissionManagerService.canGrantOemPermission(disabledChildPs, perm)) continue;
                                    allowed = true;
                                    break;
                                }
                            }
                        }
                    }
                }
            } else {
                PackageSetting ps = (PackageSetting)pkg.mExtras;
                boolean bl2 = allowed = privilegedPermission && pkg.isPrivileged() || oemPermission && pkg.isOem() && PermissionManagerService.canGrantOemPermission(ps, perm);
            }
            if (allowed && privilegedPermission && !vendorPrivilegedPermission && pkg.isVendor()) {
                Slog.w(TAG, "Permission " + perm + " cannot be granted to privileged vendor apk " + pkg.packageName + " because it isn't a 'vendorPrivileged' permission.");
                allowed = false;
            }
        }
        if (!allowed) {
            if (!allowed && bp.isPre23() && pkg.applicationInfo.targetSdkVersion < 23) {
                allowed = true;
            }
            if (!allowed && bp.isInstaller() && (pkg.packageName.equals(this.mPackageManagerInt.getKnownPackageName(2, 0)) || pkg.packageName.equals(this.mPackageManagerInt.getKnownPackageName(6, 0)))) {
                allowed = true;
            }
            if (!allowed && bp.isVerifier() && pkg.packageName.equals(this.mPackageManagerInt.getKnownPackageName(3, 0))) {
                allowed = true;
            }
            if (!allowed && bp.isPreInstalled() && pkg.isSystem()) {
                allowed = true;
            }
            if (!allowed && bp.isDevelopment()) {
                allowed = origPermissions.hasInstallPermission(perm);
            }
            if (!allowed && bp.isSetup() && pkg.packageName.equals(this.mPackageManagerInt.getKnownPackageName(1, 0))) {
                allowed = true;
            }
            if (!allowed && bp.isSystemTextClassifier() && pkg.packageName.equals(this.mPackageManagerInt.getKnownPackageName(5, 0))) {
                allowed = true;
            }
            if (!allowed && bp.isConfigurator() && pkg.packageName.equals(this.mPackageManagerInt.getKnownPackageName(9, 0))) {
                allowed = true;
            }
            if (!allowed && bp.isWellbeing() && pkg.packageName.equals(this.mPackageManagerInt.getKnownPackageName(7, 0))) {
                allowed = true;
            }
            if (!allowed && bp.isDocumenter() && pkg.packageName.equals(this.mPackageManagerInt.getKnownPackageName(8, 0))) {
                allowed = true;
            }
            if (!allowed && bp.isIncidentReportApprover() && pkg.packageName.equals(this.mPackageManagerInt.getKnownPackageName(10, 0))) {
                allowed = true;
            }
            if (!allowed && bp.isAppPredictor() && pkg.packageName.equals(this.mPackageManagerInt.getKnownPackageName(11, 0))) {
                allowed = true;
            }
        }
        return allowed;
    }

    private static boolean canGrantOemPermission(PackageSetting ps, String permission2) {
        if (!ps.isOem()) {
            return false;
        }
        Boolean granted = SystemConfig.getInstance().getOemPermissions(ps.name).get(permission2);
        if (granted == null) {
            throw new IllegalStateException("OEM permission" + permission2 + " requested by package " + ps.name + " must be explicitly declared granted or not");
        }
        return Boolean.TRUE == granted;
    }

    private boolean isPermissionsReviewRequired(PackageParser.Package pkg, int userId) {
        if (pkg.applicationInfo.targetSdkVersion >= 23) {
            return false;
        }
        if (pkg.mExtras == null) {
            return false;
        }
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        PermissionsState permissionsState = ps.getPermissionsState();
        return permissionsState.isPermissionReviewRequired(userId);
    }

    private boolean isPackageRequestingPermission(PackageParser.Package pkg, String permission2) {
        int permCount = pkg.requestedPermissions.size();
        for (int j = 0; j < permCount; ++j) {
            String requestedPermission = pkg.requestedPermissions.get(j);
            if (!permission2.equals(requestedPermission)) continue;
            return true;
        }
        return false;
    }

    @GuardedBy(value={"mLock"})
    private void grantRuntimePermissionsGrantedToDisabledPackageLocked(PackageParser.Package pkg, int callingUid, PermissionManagerServiceInternal.PermissionCallback callback) {
        if (pkg.parentPackage == null) {
            return;
        }
        if (pkg.requestedPermissions == null) {
            return;
        }
        PackageParser.Package disabledPkg = this.mPackageManagerInt.getDisabledSystemPackage(pkg.parentPackage.packageName);
        if (disabledPkg == null || disabledPkg.mExtras == null) {
            return;
        }
        PackageSetting disabledPs = (PackageSetting)disabledPkg.mExtras;
        if (!disabledPs.isPrivileged() || disabledPs.hasChildPackages()) {
            return;
        }
        int permCount = pkg.requestedPermissions.size();
        for (int i = 0; i < permCount; ++i) {
            String permission2 = pkg.requestedPermissions.get(i);
            BasePermission bp = this.mSettings.getPermissionLocked(permission2);
            if (bp == null || !bp.isRuntime() && !bp.isDevelopment()) continue;
            for (int userId : this.mUserManagerInt.getUserIds()) {
                if (!disabledPs.getPermissionsState().hasRuntimePermission(permission2, userId)) continue;
                this.grantRuntimePermission(permission2, pkg.packageName, false, callingUid, userId, callback);
            }
        }
    }

    private void grantRequestedRuntimePermissions(PackageParser.Package pkg, int[] userIds, String[] grantedPermissions, int callingUid, PermissionManagerServiceInternal.PermissionCallback callback) {
        for (int userId : userIds) {
            this.grantRequestedRuntimePermissionsForUser(pkg, userId, grantedPermissions, callingUid, callback);
        }
    }

    private List<String> getWhitelistedRestrictedPermissions(PackageParser.Package pkg, int whitelistFlags, int userId) {
        PackageSetting packageSetting = (PackageSetting)pkg.mExtras;
        if (packageSetting == null) {
            return null;
        }
        PermissionsState permissionsState = packageSetting.getPermissionsState();
        int queryFlags = 0;
        if ((whitelistFlags & 1) != 0) {
            queryFlags |= 0x1000;
        }
        if ((whitelistFlags & 4) != 0) {
            queryFlags |= 0x2000;
        }
        if ((whitelistFlags & 2) != 0) {
            queryFlags |= 0x800;
        }
        ArrayList<String> whitelistedPermissions = null;
        int permissionCount = pkg.requestedPermissions.size();
        for (int i = 0; i < permissionCount; ++i) {
            String permissionName = pkg.requestedPermissions.get(i);
            int currentFlags = permissionsState.getPermissionFlags(permissionName, userId);
            if ((currentFlags & queryFlags) == 0) continue;
            if (whitelistedPermissions == null) {
                whitelistedPermissions = new ArrayList<String>();
            }
            whitelistedPermissions.add(permissionName);
        }
        return whitelistedPermissions;
    }

    private void setWhitelistedRestrictedPermissions(PackageParser.Package pkg, int[] userIds, List<String> permissions, int callingUid, int whitelistFlags, PermissionManagerServiceInternal.PermissionCallback callback) {
        for (int userId : userIds) {
            this.setWhitelistedRestrictedPermissionsForUser(pkg, userId, permissions, callingUid, whitelistFlags, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantRequestedRuntimePermissionsForUser(PackageParser.Package pkg, int userId, String[] grantedPermissions, int callingUid, PermissionManagerServiceInternal.PermissionCallback callback) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        PermissionsState permissionsState = ps.getPermissionsState();
        int immutableFlags = 20;
        boolean supportsRuntimePermissions = pkg.applicationInfo.targetSdkVersion >= 23;
        boolean instantApp = this.mPackageManagerInt.isInstantApp(pkg.packageName, userId);
        for (String permission2 : pkg.requestedPermissions) {
            BasePermission bp;
            Object object = this.mLock;
            synchronized (object) {
                bp = this.mSettings.getPermissionLocked(permission2);
            }
            if (bp == null || !bp.isRuntime() && !bp.isDevelopment() || instantApp && !bp.isInstant() || !supportsRuntimePermissions && bp.isRuntimeOnly() || grantedPermissions != null && !ArrayUtils.contains(grantedPermissions, permission2)) continue;
            int flags = permissionsState.getPermissionFlags(permission2, userId);
            if (supportsRuntimePermissions) {
                if ((flags & 0x14) != 0) continue;
                this.grantRuntimePermission(permission2, pkg.packageName, false, callingUid, userId, callback);
                continue;
            }
            if ((flags & 0x40) == 0) continue;
            this.updatePermissionFlags(permission2, pkg.packageName, 64, 0, callingUid, userId, false, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantRuntimePermission(String permName, String packageName, boolean overridePolicy, int callingUid, int userId, PermissionManagerServiceInternal.PermissionCallback callback) {
        BasePermission bp;
        if (!this.mUserManagerInt.exists(userId)) {
            Log.e(TAG, "No such user:" + userId);
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_RUNTIME_PERMISSIONS", "grantRuntimePermission");
        this.enforceCrossUserPermission(callingUid, userId, true, true, false, "grantRuntimePermission");
        PackageParser.Package pkg = this.mPackageManagerInt.getPackage(packageName);
        if (pkg == null || pkg.mExtras == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        Object object = this.mLock;
        synchronized (object) {
            bp = this.mSettings.getPermissionLocked(permName);
        }
        if (bp == null) {
            throw new IllegalArgumentException("Unknown permission: " + permName);
        }
        if (this.mPackageManagerInt.filterAppAccess(pkg, callingUid, userId)) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        bp.enforceDeclaredUsedAndRuntimeOrDevelopment(pkg);
        if (pkg.applicationInfo.targetSdkVersion < 23 && bp.isRuntime()) {
            return;
        }
        int uid = UserHandle.getUid(userId, pkg.applicationInfo.uid);
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        PermissionsState permissionsState = ps.getPermissionsState();
        int flags = permissionsState.getPermissionFlags(permName, userId);
        if ((flags & 0x10) != 0) {
            Log.e(TAG, "Cannot grant system fixed permission " + permName + " for package " + packageName);
            return;
        }
        if (!overridePolicy && (flags & 4) != 0) {
            Log.e(TAG, "Cannot grant policy fixed permission " + permName + " for package " + packageName);
            return;
        }
        if (bp.isHardRestricted() && (flags & 0x3800) == 0) {
            Log.e(TAG, "Cannot grant hard restricted non-exempt permission " + permName + " for package " + packageName);
            return;
        }
        if (bp.isSoftRestricted() && !SoftRestrictedPermissionPolicy.forPermission(this.mContext, pkg.applicationInfo, UserHandle.of(userId), permName).canBeGranted()) {
            Log.e(TAG, "Cannot grant soft restricted permission " + permName + " for package " + packageName);
            return;
        }
        if (bp.isDevelopment()) {
            if (permissionsState.grantInstallPermission(bp) != -1 && callback != null) {
                callback.onInstallPermissionGranted();
            }
            return;
        }
        if (ps.getInstantApp(userId) && !bp.isInstant()) {
            throw new SecurityException("Cannot grant non-ephemeral permission" + permName + " for package " + packageName);
        }
        if (pkg.applicationInfo.targetSdkVersion < 23) {
            Slog.w(TAG, "Cannot grant runtime permission to a legacy app");
            return;
        }
        int result = permissionsState.grantRuntimePermission(bp, userId);
        switch (result) {
            case -1: {
                return;
            }
            case 1: {
                if (callback == null) break;
                callback.onGidsChanged(UserHandle.getAppId(pkg.applicationInfo.uid), userId);
            }
        }
        if (bp.isRuntime()) {
            this.logPermission(1243, permName, packageName);
        }
        if (callback != null) {
            callback.onPermissionGranted(uid, userId);
        }
        if (bp.isRuntime()) {
            this.notifyRuntimePermissionStateChanged(packageName, userId);
        }
        if ("android.permission.READ_EXTERNAL_STORAGE".equals(permName) || "android.permission.WRITE_EXTERNAL_STORAGE".equals(permName)) {
            long token = Binder.clearCallingIdentity();
            try {
                if (this.mUserManagerInt.isUserInitialized(userId)) {
                    StorageManagerInternal storageManagerInternal = LocalServices.getService(StorageManagerInternal.class);
                    storageManagerInternal.onExternalStoragePolicyChanged(uid, packageName);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    private void revokeRuntimePermission(String permName, String packageName, boolean overridePolicy, int userId, PermissionManagerServiceInternal.PermissionCallback callback) {
        if (!this.mUserManagerInt.exists(userId)) {
            Log.e(TAG, "No such user:" + userId);
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS", "revokeRuntimePermission");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, true, false, "revokeRuntimePermission");
        PackageParser.Package pkg = this.mPackageManagerInt.getPackage(packageName);
        if (pkg == null || pkg.mExtras == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        if (this.mPackageManagerInt.filterAppAccess(pkg, Binder.getCallingUid(), userId)) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        BasePermission bp = this.mSettings.getPermissionLocked(permName);
        if (bp == null) {
            throw new IllegalArgumentException("Unknown permission: " + permName);
        }
        bp.enforceDeclaredUsedAndRuntimeOrDevelopment(pkg);
        if (pkg.applicationInfo.targetSdkVersion < 23 && bp.isRuntime()) {
            return;
        }
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        PermissionsState permissionsState = ps.getPermissionsState();
        int flags = permissionsState.getPermissionFlags(permName, userId);
        if ((flags & 0x10) != 0 && UserHandle.getCallingAppId() != 1000) {
            throw new SecurityException("Non-System UID cannot revoke system fixed permission " + permName + " for package " + packageName);
        }
        if (!overridePolicy && (flags & 4) != 0) {
            throw new SecurityException("Cannot revoke policy fixed permission " + permName + " for package " + packageName);
        }
        if (bp.isDevelopment()) {
            if (permissionsState.revokeInstallPermission(bp) != -1 && callback != null) {
                callback.onInstallPermissionRevoked();
            }
            return;
        }
        if (!permissionsState.hasRuntimePermission(permName, userId)) {
            return;
        }
        if (permissionsState.revokeRuntimePermission(bp, userId) == -1) {
            return;
        }
        if (bp.isRuntime()) {
            this.logPermission(1245, permName, packageName);
        }
        if (callback != null) {
            callback.onPermissionRevoked(pkg.applicationInfo.uid, userId);
        }
        if (bp.isRuntime()) {
            this.notifyRuntimePermissionStateChanged(packageName, userId);
        }
    }

    private void setWhitelistedRestrictedPermissionsForUser(PackageParser.Package pkg, int userId, List<String> permissions, int callingUid, int whitelistFlags, PermissionManagerServiceInternal.PermissionCallback callback) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        PermissionsState permissionsState = ps.getPermissionsState();
        ArraySet<String> oldGrantedRestrictedPermissions = null;
        boolean updatePermissions = false;
        int permissionCount = pkg.requestedPermissions.size();
        for (int i = 0; i < permissionCount; ++i) {
            boolean isWhitelisted;
            int oldFlags;
            String permissionName = pkg.requestedPermissions.get(i);
            BasePermission bp = this.mSettings.getPermissionLocked(permissionName);
            if (bp == null) {
                Slog.w(TAG, "Cannot whitelist unknown permission: " + permissionName);
                continue;
            }
            if (!bp.isHardOrSoftRestricted()) continue;
            if (permissionsState.hasPermission(permissionName, userId)) {
                if (oldGrantedRestrictedPermissions == null) {
                    oldGrantedRestrictedPermissions = new ArraySet<String>();
                }
                oldGrantedRestrictedPermissions.add(permissionName);
            }
            int newFlags = oldFlags = permissionsState.getPermissionFlags(permissionName, userId);
            int mask = 0;
            int whitelistFlagsCopy = whitelistFlags;
            while (whitelistFlagsCopy != 0) {
                int flag = 1 << Integer.numberOfTrailingZeros(whitelistFlagsCopy);
                whitelistFlagsCopy &= ~flag;
                switch (flag) {
                    case 1: {
                        mask |= 0x1000;
                        if (permissions != null && permissions.contains(permissionName)) {
                            newFlags |= 0x1000;
                            break;
                        }
                        newFlags &= 0xFFFFEFFF;
                        break;
                    }
                    case 4: {
                        mask |= 0x2000;
                        if (permissions != null && permissions.contains(permissionName)) {
                            newFlags |= 0x2000;
                            break;
                        }
                        newFlags &= 0xFFFFDFFF;
                        break;
                    }
                    case 2: {
                        mask |= 0x800;
                        if (permissions != null && permissions.contains(permissionName)) {
                            newFlags |= 0x800;
                            break;
                        }
                        newFlags &= 0xFFFFF7FF;
                    }
                }
            }
            if (oldFlags == newFlags) continue;
            updatePermissions = true;
            boolean wasWhitelisted = (oldFlags & 0x3800) != 0;
            boolean bl = isWhitelisted = (newFlags & 0x3800) != 0;
            if ((oldFlags & 4) != 0) {
                boolean isGranted = permissionsState.hasPermission(permissionName, userId);
                if (!isWhitelisted && isGranted) {
                    mask |= 4;
                    newFlags &= 0xFFFFFFFB;
                }
            }
            if (pkg.applicationInfo.targetSdkVersion < 23 && !wasWhitelisted && isWhitelisted) {
                mask |= 0x40;
                newFlags |= 0x40;
            }
            this.updatePermissionFlags(permissionName, pkg.packageName, mask, newFlags, callingUid, userId, false, null);
        }
        if (updatePermissions) {
            this.restorePermissionState(pkg, false, pkg.packageName, callback);
            if (oldGrantedRestrictedPermissions != null) {
                int oldGrantedCount = oldGrantedRestrictedPermissions.size();
                for (int i = 0; i < oldGrantedCount; ++i) {
                    String permission2 = (String)oldGrantedRestrictedPermissions.valueAt(i);
                    if (ps.getPermissionsState().hasPermission(permission2, userId)) continue;
                    callback.onPermissionRevoked(pkg.applicationInfo.uid, userId);
                    break;
                }
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private int[] revokeUnusedSharedUserPermissionsLocked(SharedUserSetting suSetting, int[] allUserIds) {
        BasePermission bp;
        ArraySet<String> usedPermissions = new ArraySet<String>();
        List<PackageParser.Package> pkgList = suSetting.getPackages();
        if (pkgList == null || pkgList.size() == 0) {
            return EmptyArray.INT;
        }
        for (PackageParser.Package pkg : pkgList) {
            if (pkg.requestedPermissions == null) continue;
            int requestedPermCount = pkg.requestedPermissions.size();
            for (int j = 0; j < requestedPermCount; ++j) {
                String permission2 = pkg.requestedPermissions.get(j);
                bp = this.mSettings.getPermissionLocked(permission2);
                if (bp == null) continue;
                usedPermissions.add(permission2);
            }
        }
        PermissionsState permissionsState = suSetting.getPermissionsState();
        List<PermissionsState.PermissionState> installPermStates = permissionsState.getInstallPermissionStates();
        int installPermCount = installPermStates.size();
        for (int i = installPermCount - 1; i >= 0; --i) {
            PermissionsState.PermissionState permissionState = installPermStates.get(i);
            if (usedPermissions.contains(permissionState.getName()) || (bp = this.mSettings.getPermissionLocked(permissionState.getName())) == null) continue;
            permissionsState.revokeInstallPermission(bp);
            permissionsState.updatePermissionFlags(bp, -1, 64511, 0);
        }
        int[] runtimePermissionChangedUserIds = EmptyArray.INT;
        for (int userId : allUserIds) {
            List<PermissionsState.PermissionState> runtimePermStates = permissionsState.getRuntimePermissionStates(userId);
            int runtimePermCount = runtimePermStates.size();
            for (int i = runtimePermCount - 1; i >= 0; --i) {
                BasePermission bp2;
                PermissionsState.PermissionState permissionState = runtimePermStates.get(i);
                if (usedPermissions.contains(permissionState.getName()) || (bp2 = this.mSettings.getPermissionLocked(permissionState.getName())) == null) continue;
                permissionsState.revokeRuntimePermission(bp2, userId);
                permissionsState.updatePermissionFlags(bp2, userId, 64511, 0);
                runtimePermissionChangedUserIds = ArrayUtils.appendInt(runtimePermissionChangedUserIds, userId);
            }
        }
        return runtimePermissionChangedUserIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAppOpPermissionPackages(String permName) {
        if (this.mPackageManagerInt.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            ArraySet<String> pkgs = this.mSettings.mAppOpPermissionPackages.get(permName);
            if (pkgs == null) {
                return null;
            }
            return pkgs.toArray(new String[pkgs.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPermissionFlags(String permName, String packageName, int callingUid, int userId) {
        PackageParser.Package pkg;
        block7: {
            if (!this.mUserManagerInt.exists(userId)) {
                return 0;
            }
            this.enforceGrantRevokeGetRuntimePermissionPermissions("getPermissionFlags");
            this.enforceCrossUserPermission(callingUid, userId, true, false, false, "getPermissionFlags");
            pkg = this.mPackageManagerInt.getPackage(packageName);
            if (pkg == null || pkg.mExtras == null) {
                return 0;
            }
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSettings.getPermissionLocked(permName) == null) {
                    return 0;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var6_6
                if (!this.mPackageManagerInt.filterAppAccess(pkg, callingUid, userId)) break block7;
                return 0;
            }
        }
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        PermissionsState permissionsState = ps.getPermissionsState();
        return permissionsState.getPermissionFlags(permName, userId);
    }

    private void updatePermissions(String packageName, PackageParser.Package pkg, boolean replaceGrant, Collection<PackageParser.Package> allPackages, PermissionManagerServiceInternal.PermissionCallback callback) {
        int flags = (pkg != null ? 1 : 0) | (replaceGrant ? 2 : 0);
        this.updatePermissions(packageName, pkg, PermissionManagerService.getVolumeUuidForPackage(pkg), flags, allPackages, callback);
        if (pkg != null && pkg.childPackages != null) {
            for (PackageParser.Package childPkg : pkg.childPackages) {
                this.updatePermissions(childPkg.packageName, childPkg, PermissionManagerService.getVolumeUuidForPackage(childPkg), flags, allPackages, callback);
            }
        }
    }

    private void updateAllPermissions(String volumeUuid, boolean sdkUpdated, Collection<PackageParser.Package> allPackages, PermissionManagerServiceInternal.PermissionCallback callback) {
        int flags = 1 | (sdkUpdated ? 6 : 0);
        this.updatePermissions(null, null, volumeUuid, flags, allPackages, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePermissions(String changingPkgName, PackageParser.Package changingPkg, String replaceVolumeUuid, int flags, Collection<PackageParser.Package> allPackages, PermissionManagerServiceInternal.PermissionCallback callback) {
        flags = this.updatePermissionTrees(changingPkgName, changingPkg, flags);
        flags = this.updatePermissions(changingPkgName, changingPkg, flags);
        Iterator<PackageParser.Package> iterator = this.mLock;
        synchronized (iterator) {
            if (this.mBackgroundPermissions == null) {
                this.mBackgroundPermissions = new ArrayMap();
                for (BasePermission bp : this.mSettings.getAllPermissionsLocked()) {
                    if (bp.perm == null || bp.perm.info == null || bp.perm.info.backgroundPermission == null) continue;
                    String fgPerm = bp.name;
                    String bgPerm = bp.perm.info.backgroundPermission;
                    List<String> fgPerms = this.mBackgroundPermissions.get(bgPerm);
                    if (fgPerms == null) {
                        fgPerms = new ArrayList<String>();
                        this.mBackgroundPermissions.put(bgPerm, fgPerms);
                    }
                    fgPerms.add(fgPerm);
                }
            }
        }
        Trace.traceBegin(262144L, "restorePermissionState");
        if ((flags & 1) != 0) {
            for (PackageParser.Package pkg : allPackages) {
                if (pkg == changingPkg) continue;
                String volumeUuid = PermissionManagerService.getVolumeUuidForPackage(pkg);
                boolean replace = (flags & 4) != 0 && Objects.equals(replaceVolumeUuid, volumeUuid);
                this.restorePermissionState(pkg, replace, changingPkgName, callback);
            }
        }
        if (changingPkg != null) {
            String volumeUuid = PermissionManagerService.getVolumeUuidForPackage(changingPkg);
            boolean replace = (flags & 2) != 0 && Objects.equals(replaceVolumeUuid, volumeUuid);
            this.restorePermissionState(changingPkg, replace, changingPkgName, callback);
        }
        Trace.traceEnd(262144L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updatePermissions(String packageName, PackageParser.Package pkg, int flags) {
        ArraySet<BasePermission> needsUpdate = null;
        Iterator iterator = this.mLock;
        synchronized (iterator) {
            Iterator<BasePermission> it = this.mSettings.mPermissions.values().iterator();
            while (it.hasNext()) {
                BasePermission bp = it.next();
                if (bp.isDynamic()) {
                    bp.updateDynamicPermission(this.mSettings.mPermissionTrees.values());
                }
                if (bp.getSourcePackageSetting() != null) {
                    if (packageName == null || !packageName.equals(bp.getSourcePackageName()) || pkg != null && PermissionManagerService.hasPermission(pkg, bp.getName())) continue;
                    Slog.i(TAG, "Removing old permission tree: " + bp.getName() + " from package " + bp.getSourcePackageName());
                    flags |= 1;
                    it.remove();
                    continue;
                }
                if (needsUpdate == null) {
                    needsUpdate = new ArraySet<BasePermission>(this.mSettings.mPermissions.size());
                }
                needsUpdate.add(bp);
            }
        }
        if (needsUpdate != null) {
            for (BasePermission bp : needsUpdate) {
                PackageParser.Package sourcePkg = this.mPackageManagerInt.getPackage(bp.getSourcePackageName());
                Object object = this.mLock;
                synchronized (object) {
                    if (sourcePkg != null && sourcePkg.mExtras != null) {
                        PackageSetting sourcePs = (PackageSetting)sourcePkg.mExtras;
                        if (bp.getSourcePackageSetting() == null) {
                            bp.setSourcePackageSetting(sourcePs);
                        }
                        continue;
                    }
                    Slog.w(TAG, "Removing dangling permission: " + bp.getName() + " from package " + bp.getSourcePackageName());
                    this.mSettings.removePermissionLocked(bp.getName());
                }
            }
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updatePermissionTrees(String packageName, PackageParser.Package pkg, int flags) {
        ArraySet<BasePermission> needsUpdate = null;
        Iterator iterator = this.mLock;
        synchronized (iterator) {
            Iterator<BasePermission> it = this.mSettings.mPermissionTrees.values().iterator();
            while (it.hasNext()) {
                BasePermission bp = it.next();
                if (bp.getSourcePackageSetting() != null) {
                    if (packageName == null || !packageName.equals(bp.getSourcePackageName()) || pkg != null && PermissionManagerService.hasPermission(pkg, bp.getName())) continue;
                    Slog.i(TAG, "Removing old permission tree: " + bp.getName() + " from package " + bp.getSourcePackageName());
                    flags |= 1;
                    it.remove();
                    continue;
                }
                if (needsUpdate == null) {
                    needsUpdate = new ArraySet<BasePermission>(this.mSettings.mPermissionTrees.size());
                }
                needsUpdate.add(bp);
            }
        }
        if (needsUpdate != null) {
            for (BasePermission bp : needsUpdate) {
                PackageParser.Package sourcePkg = this.mPackageManagerInt.getPackage(bp.getSourcePackageName());
                Object object = this.mLock;
                synchronized (object) {
                    if (sourcePkg != null && sourcePkg.mExtras != null) {
                        PackageSetting sourcePs = (PackageSetting)sourcePkg.mExtras;
                        if (bp.getSourcePackageSetting() == null) {
                            bp.setSourcePackageSetting(sourcePs);
                        }
                        continue;
                    }
                    Slog.w(TAG, "Removing dangling permission tree: " + bp.getName() + " from package " + bp.getSourcePackageName());
                    this.mSettings.removePermissionLocked(bp.getName());
                }
            }
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePermissionFlags(String permName, String packageName, int flagMask, int flagValues, int callingUid, int userId, boolean overridePolicy, PermissionManagerServiceInternal.PermissionCallback callback) {
        BasePermission bp;
        PackageParser.Package pkg;
        if (!this.mUserManagerInt.exists(userId)) {
            return;
        }
        this.enforceGrantRevokeRuntimePermissionPermissions("updatePermissionFlags");
        this.enforceCrossUserPermission(callingUid, userId, true, true, false, "updatePermissionFlags");
        if ((flagMask & 4) != 0 && !overridePolicy) {
            throw new SecurityException("updatePermissionFlags requires android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY");
        }
        if (callingUid != 1000) {
            flagMask &= 0xFFFFFFEF;
            flagValues &= 0xFFFFFFEF;
            flagMask &= 0xFFFFFFDF;
            flagValues &= 0xFFFFFFDF;
            flagValues &= 0xFFFFFFBF;
            flagValues &= 0xFFFFEFFF;
            flagValues &= 0xFFFFF7FF;
            flagValues &= 0xFFFFDFFF;
            flagValues &= 0xFFFFBFFF;
        }
        if ((pkg = this.mPackageManagerInt.getPackage(packageName)) == null || pkg.mExtras == null) {
            Log.e(TAG, "Unknown package: " + packageName);
            return;
        }
        if (this.mPackageManagerInt.filterAppAccess(pkg, callingUid, userId)) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        Object object = this.mLock;
        synchronized (object) {
            bp = this.mSettings.getPermissionLocked(permName);
        }
        if (bp == null) {
            throw new IllegalArgumentException("Unknown permission: " + permName);
        }
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        PermissionsState permissionsState = ps.getPermissionsState();
        boolean hadState = permissionsState.getRuntimePermissionState(permName, userId) != null;
        boolean permissionUpdated = permissionsState.updatePermissionFlags(bp, userId, flagMask, flagValues);
        if (permissionUpdated && bp.isRuntime()) {
            this.notifyRuntimePermissionStateChanged(packageName, userId);
        }
        if (permissionUpdated && callback != null) {
            if (permissionsState.getInstallPermissionState(permName) != null) {
                callback.onInstallPermissionUpdated();
            } else if (permissionsState.getRuntimePermissionState(permName, userId) != null || hadState) {
                callback.onPermissionUpdated(new int[]{userId}, false);
            }
        }
    }

    private boolean updatePermissionFlagsForAllApps(int flagMask, int flagValues, int callingUid, int userId, Collection<PackageParser.Package> packages, PermissionManagerServiceInternal.PermissionCallback callback) {
        if (!this.mUserManagerInt.exists(userId)) {
            return false;
        }
        this.enforceGrantRevokeRuntimePermissionPermissions("updatePermissionFlagsForAllApps");
        this.enforceCrossUserPermission(callingUid, userId, true, true, false, "updatePermissionFlagsForAllApps");
        if (callingUid != 1000) {
            flagMask &= 0xFFFFFFEF;
            flagValues &= 0xFFFFFFEF;
        }
        boolean changed = false;
        for (PackageParser.Package pkg : packages) {
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (ps == null) continue;
            PermissionsState permissionsState = ps.getPermissionsState();
            changed |= permissionsState.updatePermissionFlagsForAllPermissions(userId, flagMask, flagValues);
        }
        return changed;
    }

    private void enforceGrantRevokeRuntimePermissionPermissions(String message) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.GRANT_RUNTIME_PERMISSIONS") != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS") != 0) {
            throw new SecurityException(message + " requires " + "android.permission.GRANT_RUNTIME_PERMISSIONS" + " or " + "android.permission.REVOKE_RUNTIME_PERMISSIONS");
        }
    }

    private void enforceGrantRevokeGetRuntimePermissionPermissions(String message) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.GET_RUNTIME_PERMISSIONS") != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.GRANT_RUNTIME_PERMISSIONS") != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS") != 0) {
            throw new SecurityException(message + " requires " + "android.permission.GRANT_RUNTIME_PERMISSIONS" + " or " + "android.permission.REVOKE_RUNTIME_PERMISSIONS" + " or " + "android.permission.GET_RUNTIME_PERMISSIONS");
        }
    }

    private void enforceCrossUserPermission(int callingUid, int userId, boolean requireFullPermission, boolean checkShell, boolean requirePermissionWhenSameUser, String message) {
        if (userId < 0) {
            throw new IllegalArgumentException("Invalid userId " + userId);
        }
        if (checkShell) {
            PackageManagerServiceUtils.enforceShellRestriction("no_debugging_features", callingUid, userId);
        }
        if (!requirePermissionWhenSameUser && userId == UserHandle.getUserId(callingUid)) {
            return;
        }
        if (callingUid != 1000 && callingUid != 0) {
            if (requireFullPermission) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
            } else {
                try {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
                }
                catch (SecurityException se) {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", message);
                }
            }
        }
    }

    @GuardedBy(value={"mSettings.mLock", "mLock"})
    private int calculateCurrentPermissionFootprintLocked(BasePermission tree) {
        int size = 0;
        for (BasePermission perm : this.mSettings.mPermissions.values()) {
            size += tree.calculateFootprint(perm);
        }
        return size;
    }

    @GuardedBy(value={"mSettings.mLock", "mLock"})
    private void enforcePermissionCapLocked(PermissionInfo info, BasePermission tree) {
        int curTreeSize;
        if (tree.getUid() != 1000 && (curTreeSize = this.calculateCurrentPermissionFootprintLocked(tree)) + info.calculateFootprint() > 32768) {
            throw new SecurityException("Permission tree size cap exceeded");
        }
    }

    private void systemReady() {
        this.mSystemReady = true;
        if (this.mPrivappPermissionsViolations != null) {
            throw new IllegalStateException("Signature|privileged permissions not in privapp-permissions whitelist: " + this.mPrivappPermissionsViolations);
        }
        this.mPermissionControllerManager = this.mContext.getSystemService(PermissionControllerManager.class);
        this.mPermissionPolicyInternal = LocalServices.getService(PermissionPolicyInternal.class);
    }

    private static String getVolumeUuidForPackage(PackageParser.Package pkg) {
        if (pkg == null) {
            return StorageManager.UUID_PRIVATE_INTERNAL;
        }
        if (pkg.isExternal()) {
            if (TextUtils.isEmpty(pkg.volumeUuid)) {
                return "primary_physical";
            }
            return pkg.volumeUuid;
        }
        return StorageManager.UUID_PRIVATE_INTERNAL;
    }

    private static boolean hasPermission(PackageParser.Package pkgInfo, String permName) {
        for (int i = pkgInfo.permissions.size() - 1; i >= 0; --i) {
            if (!pkgInfo.permissions.get((int)i).info.name.equals(permName)) continue;
            return true;
        }
        return false;
    }

    private void logPermission(int action, String name, String packageName) {
        LogMaker log = new LogMaker(action);
        log.setPackageName(packageName);
        log.addTaggedData(1241, name);
        this.mMetricsLogger.write(log);
    }

    public ArrayMap<String, List<String>> getBackgroundPermissions() {
        return this.mBackgroundPermissions;
    }

    static {
        FULLER_PERMISSION_MAP.put("android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION");
        FULLER_PERMISSION_MAP.put("android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL");
    }

    private class PermissionManagerServiceInternalImpl
    extends PermissionManagerServiceInternal {
        private PermissionManagerServiceInternalImpl() {
        }

        @Override
        public void systemReady() {
            PermissionManagerService.this.systemReady();
        }

        @Override
        public boolean isPermissionsReviewRequired(PackageParser.Package pkg, int userId) {
            return PermissionManagerService.this.isPermissionsReviewRequired(pkg, userId);
        }

        @Override
        public void revokeRuntimePermissionsIfGroupChanged(PackageParser.Package newPackage, PackageParser.Package oldPackage, ArrayList<String> allPackageNames, PermissionManagerServiceInternal.PermissionCallback permissionCallback) {
            PermissionManagerService.this.revokeRuntimePermissionsIfGroupChanged(newPackage, oldPackage, allPackageNames, permissionCallback);
        }

        @Override
        public void addAllPermissions(PackageParser.Package pkg, boolean chatty) {
            PermissionManagerService.this.addAllPermissions(pkg, chatty);
        }

        @Override
        public void addAllPermissionGroups(PackageParser.Package pkg, boolean chatty) {
            PermissionManagerService.this.addAllPermissionGroups(pkg, chatty);
        }

        @Override
        public void removeAllPermissions(PackageParser.Package pkg, boolean chatty) {
            PermissionManagerService.this.removeAllPermissions(pkg, chatty);
        }

        @Override
        public boolean addDynamicPermission(PermissionInfo info, boolean async, int callingUid, PermissionManagerServiceInternal.PermissionCallback callback) {
            return PermissionManagerService.this.addDynamicPermission(info, callingUid, callback);
        }

        @Override
        public void removeDynamicPermission(String permName, int callingUid, PermissionManagerServiceInternal.PermissionCallback callback) {
            PermissionManagerService.this.removeDynamicPermission(permName, callingUid, callback);
        }

        @Override
        public void grantRuntimePermission(String permName, String packageName, boolean overridePolicy, int callingUid, int userId, PermissionManagerServiceInternal.PermissionCallback callback) {
            PermissionManagerService.this.grantRuntimePermission(permName, packageName, overridePolicy, callingUid, userId, callback);
        }

        @Override
        public void grantRequestedRuntimePermissions(PackageParser.Package pkg, int[] userIds, String[] grantedPermissions, int callingUid, PermissionManagerServiceInternal.PermissionCallback callback) {
            PermissionManagerService.this.grantRequestedRuntimePermissions(pkg, userIds, grantedPermissions, callingUid, callback);
        }

        @Override
        public List<String> getWhitelistedRestrictedPermissions(PackageParser.Package pkg, int whitelistFlags, int userId) {
            return PermissionManagerService.this.getWhitelistedRestrictedPermissions(pkg, whitelistFlags, userId);
        }

        @Override
        public void setWhitelistedRestrictedPermissions(PackageParser.Package pkg, int[] userIds, List<String> permissions, int callingUid, int whitelistFlags, PermissionManagerServiceInternal.PermissionCallback callback) {
            PermissionManagerService.this.setWhitelistedRestrictedPermissions(pkg, userIds, permissions, callingUid, whitelistFlags, callback);
        }

        @Override
        public void grantRuntimePermissionsGrantedToDisabledPackage(PackageParser.Package pkg, int callingUid, PermissionManagerServiceInternal.PermissionCallback callback) {
            PermissionManagerService.this.grantRuntimePermissionsGrantedToDisabledPackageLocked(pkg, callingUid, callback);
        }

        @Override
        public void revokeRuntimePermission(String permName, String packageName, boolean overridePolicy, int userId, PermissionManagerServiceInternal.PermissionCallback callback) {
            PermissionManagerService.this.revokeRuntimePermission(permName, packageName, overridePolicy, userId, callback);
        }

        @Override
        public void updatePermissions(String packageName, PackageParser.Package pkg, boolean replaceGrant, Collection<PackageParser.Package> allPackages, PermissionManagerServiceInternal.PermissionCallback callback) {
            PermissionManagerService.this.updatePermissions(packageName, pkg, replaceGrant, allPackages, callback);
        }

        @Override
        public void updateAllPermissions(String volumeUuid, boolean sdkUpdated, Collection<PackageParser.Package> allPackages, PermissionManagerServiceInternal.PermissionCallback callback) {
            PermissionManagerService.this.updateAllPermissions(volumeUuid, sdkUpdated, allPackages, callback);
        }

        @Override
        public String[] getAppOpPermissionPackages(String permName) {
            return PermissionManagerService.this.getAppOpPermissionPackages(permName);
        }

        @Override
        public int getPermissionFlags(String permName, String packageName, int callingUid, int userId) {
            return PermissionManagerService.this.getPermissionFlags(permName, packageName, callingUid, userId);
        }

        @Override
        public void updatePermissionFlags(String permName, String packageName, int flagMask, int flagValues, int callingUid, int userId, boolean overridePolicy, PermissionManagerServiceInternal.PermissionCallback callback) {
            PermissionManagerService.this.updatePermissionFlags(permName, packageName, flagMask, flagValues, callingUid, userId, overridePolicy, callback);
        }

        @Override
        public boolean updatePermissionFlagsForAllApps(int flagMask, int flagValues, int callingUid, int userId, Collection<PackageParser.Package> packages, PermissionManagerServiceInternal.PermissionCallback callback) {
            return PermissionManagerService.this.updatePermissionFlagsForAllApps(flagMask, flagValues, callingUid, userId, packages, callback);
        }

        @Override
        public void enforceCrossUserPermission(int callingUid, int userId, boolean requireFullPermission, boolean checkShell, String message) {
            PermissionManagerService.this.enforceCrossUserPermission(callingUid, userId, requireFullPermission, checkShell, false, message);
        }

        @Override
        public void enforceCrossUserPermission(int callingUid, int userId, boolean requireFullPermission, boolean checkShell, boolean requirePermissionWhenSameUser, String message) {
            PermissionManagerService.this.enforceCrossUserPermission(callingUid, userId, requireFullPermission, checkShell, requirePermissionWhenSameUser, message);
        }

        @Override
        public void enforceGrantRevokeRuntimePermissionPermissions(String message) {
            PermissionManagerService.this.enforceGrantRevokeRuntimePermissionPermissions(message);
        }

        @Override
        public int checkPermission(String permName, String packageName, int callingUid, int userId) {
            return PermissionManagerService.this.checkPermission(permName, packageName, callingUid, userId);
        }

        @Override
        public int checkUidPermission(String permName, PackageParser.Package pkg, int uid, int callingUid) {
            return PermissionManagerService.this.checkUidPermission(permName, pkg, uid, callingUid);
        }

        @Override
        public PermissionGroupInfo getPermissionGroupInfo(String groupName, int flags, int callingUid) {
            return PermissionManagerService.this.getPermissionGroupInfo(groupName, flags, callingUid);
        }

        @Override
        public List<PermissionGroupInfo> getAllPermissionGroups(int flags, int callingUid) {
            return PermissionManagerService.this.getAllPermissionGroups(flags, callingUid);
        }

        @Override
        public PermissionInfo getPermissionInfo(String permName, String packageName, int flags, int callingUid) {
            return PermissionManagerService.this.getPermissionInfo(permName, packageName, flags, callingUid);
        }

        @Override
        public List<PermissionInfo> getPermissionInfoByGroup(String group, int flags, int callingUid) {
            return PermissionManagerService.this.getPermissionInfoByGroup(group, flags, callingUid);
        }

        @Override
        public PermissionSettings getPermissionSettings() {
            return PermissionManagerService.this.mSettings;
        }

        @Override
        public DefaultPermissionGrantPolicy getDefaultPermissionGrantPolicy() {
            return PermissionManagerService.this.mDefaultPermissionGrantPolicy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BasePermission getPermissionTEMP(String permName) {
            Object object = PermissionManagerService.this.mLock;
            synchronized (object) {
                return PermissionManagerService.this.mSettings.getPermissionLocked(permName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<PermissionInfo> getAllPermissionWithProtectionLevel(int protectionLevel) {
            ArrayList<PermissionInfo> matchingPermissions = new ArrayList<PermissionInfo>();
            Object object = PermissionManagerService.this.mLock;
            synchronized (object) {
                int numTotalPermissions = ((PermissionManagerService)PermissionManagerService.this).mSettings.mPermissions.size();
                for (int i = 0; i < numTotalPermissions; ++i) {
                    BasePermission bp = ((PermissionManagerService)PermissionManagerService.this).mSettings.mPermissions.valueAt(i);
                    if (bp.perm == null || bp.perm.info == null || bp.protectionLevel != protectionLevel) continue;
                    matchingPermissions.add(bp.perm.info);
                }
            }
            return matchingPermissions;
        }

        @Override
        public byte[] backupRuntimePermissions(UserHandle user) {
            return PermissionManagerService.this.backupRuntimePermissions(user);
        }

        @Override
        public void restoreRuntimePermissions(byte[] backup, UserHandle user) {
            PermissionManagerService.this.restoreRuntimePermissions(backup, user);
        }

        @Override
        public void restoreDelayedRuntimePermissions(String packageName, UserHandle user) {
            PermissionManagerService.this.restoreDelayedRuntimePermissions(packageName, user);
        }

        @Override
        public void addOnRuntimePermissionStateChangedListener(PermissionManagerInternal.OnRuntimePermissionStateChangedListener listener) {
            PermissionManagerService.this.addOnRuntimePermissionStateChangedListener(listener);
        }

        @Override
        public void removeOnRuntimePermissionStateChangedListener(PermissionManagerInternal.OnRuntimePermissionStateChangedListener listener) {
            PermissionManagerService.this.removeOnRuntimePermissionStateChangedListener(listener);
        }
    }
}

