/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.display.DisplayManagerInternal;
import android.os.Handler;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.view.DisplayInfo;
import android.view.IDisplayFoldListener;
import com.android.server.DisplayThread;
import com.android.server.LocalServices;
import com.android.server.policy.DisplayFoldDurationLogger;
import com.android.server.wm.WindowManagerInternal;

class DisplayFoldController {
    private static final String TAG = "DisplayFoldController";
    private final WindowManagerInternal mWindowManagerInternal;
    private final DisplayManagerInternal mDisplayManagerInternal;
    private final int mDisplayId;
    private final Handler mHandler;
    private final Rect mFoldedArea;
    private Rect mOverrideFoldedArea = new Rect();
    private final DisplayInfo mNonOverrideDisplayInfo = new DisplayInfo();
    private final RemoteCallbackList<IDisplayFoldListener> mListeners = new RemoteCallbackList();
    private Boolean mFolded;
    private String mFocusedApp;
    private final DisplayFoldDurationLogger mDurationLogger = new DisplayFoldDurationLogger();

    DisplayFoldController(WindowManagerInternal windowManagerInternal, DisplayManagerInternal displayManagerInternal, int displayId, Rect foldedArea, Handler handler) {
        this.mWindowManagerInternal = windowManagerInternal;
        this.mDisplayManagerInternal = displayManagerInternal;
        this.mDisplayId = displayId;
        this.mFoldedArea = new Rect(foldedArea);
        this.mHandler = handler;
    }

    void finishedGoingToSleep() {
        this.mDurationLogger.onFinishedGoingToSleep();
    }

    void finishedWakingUp() {
        this.mDurationLogger.onFinishedWakingUp(this.mFolded);
    }

    void requestDeviceFolded(boolean folded) {
        this.mHandler.post(() -> this.setDeviceFolded(folded));
    }

    void setDeviceFolded(boolean folded) {
        if (this.mFolded != null && this.mFolded == folded) {
            return;
        }
        if (folded) {
            Rect foldedArea;
            if (!this.mOverrideFoldedArea.isEmpty()) {
                foldedArea = this.mOverrideFoldedArea;
            } else if (!this.mFoldedArea.isEmpty()) {
                foldedArea = this.mFoldedArea;
            } else {
                return;
            }
            this.mDisplayManagerInternal.getNonOverrideDisplayInfo(this.mDisplayId, this.mNonOverrideDisplayInfo);
            int dx = (this.mNonOverrideDisplayInfo.logicalWidth - foldedArea.width()) / 2 - foldedArea.left;
            int dy = (this.mNonOverrideDisplayInfo.logicalHeight - foldedArea.height()) / 2 - foldedArea.top;
            this.mDisplayManagerInternal.setDisplayScalingDisabled(this.mDisplayId, true);
            this.mWindowManagerInternal.setForcedDisplaySize(this.mDisplayId, foldedArea.width(), foldedArea.height());
            this.mDisplayManagerInternal.setDisplayOffsets(this.mDisplayId, -dx, -dy);
        } else {
            this.mDisplayManagerInternal.setDisplayScalingDisabled(this.mDisplayId, false);
            this.mWindowManagerInternal.clearForcedDisplaySize(this.mDisplayId);
            this.mDisplayManagerInternal.setDisplayOffsets(this.mDisplayId, 0, 0);
        }
        this.mDurationLogger.setDeviceFolded(folded);
        this.mDurationLogger.logFocusedAppWithFoldState(folded, this.mFocusedApp);
        this.mFolded = folded;
        int n = this.mListeners.beginBroadcast();
        for (int i = 0; i < n; ++i) {
            try {
                this.mListeners.getBroadcastItem(i).onDisplayFoldChanged(this.mDisplayId, folded);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mListeners.finishBroadcast();
    }

    void registerDisplayFoldListener(IDisplayFoldListener listener) {
        this.mListeners.register(listener);
        if (this.mFolded == null) {
            return;
        }
        this.mHandler.post(() -> {
            try {
                listener.onDisplayFoldChanged(this.mDisplayId, this.mFolded);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        });
    }

    void unregisterDisplayFoldListener(IDisplayFoldListener listener) {
        this.mListeners.unregister(listener);
    }

    void setOverrideFoldedArea(Rect area) {
        this.mOverrideFoldedArea.set(area);
    }

    Rect getFoldedArea() {
        if (!this.mOverrideFoldedArea.isEmpty()) {
            return this.mOverrideFoldedArea;
        }
        return this.mFoldedArea;
    }

    static DisplayFoldController createWithProxSensor(Context context, int displayId) {
        SensorManager sensorManager = context.getSystemService(SensorManager.class);
        Sensor proxSensor = sensorManager.getDefaultSensor(8);
        if (proxSensor == null) {
            return null;
        }
        final DisplayFoldController result = DisplayFoldController.create(context, displayId);
        sensorManager.registerListener(new SensorEventListener(){

            @Override
            public void onSensorChanged(SensorEvent event) {
                result.requestDeviceFolded(event.values[0] < 1.0f);
            }

            @Override
            public void onAccuracyChanged(Sensor sensor, int accuracy) {
            }
        }, proxSensor, 3);
        return result;
    }

    void onDefaultDisplayFocusChanged(String pkg) {
        this.mFocusedApp = pkg;
    }

    static DisplayFoldController create(Context context, int displayId) {
        DisplayManagerInternal displayService = LocalServices.getService(DisplayManagerInternal.class);
        String configFoldedArea = context.getResources().getString(17039731);
        Rect foldedArea = configFoldedArea == null || configFoldedArea.isEmpty() ? new Rect() : Rect.unflattenFromString(configFoldedArea);
        return new DisplayFoldController(LocalServices.getService(WindowManagerInternal.class), displayService, displayId, foldedArea, DisplayThread.getHandler());
    }
}

