/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.metrics.LogMaker;
import android.os.SystemClock;
import com.android.internal.logging.MetricsLogger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class DisplayFoldDurationLogger {
    static final int SCREEN_STATE_UNKNOWN = -1;
    static final int SCREEN_STATE_OFF = 0;
    static final int SCREEN_STATE_ON_UNFOLDED = 1;
    static final int SCREEN_STATE_ON_FOLDED = 2;
    private int mScreenState = -1;
    private Long mLastChanged = null;
    private static final int LOG_SUBTYPE_UNFOLDED = 0;
    private static final int LOG_SUBTYPE_FOLDED = 1;
    private static final int LOG_SUBTYPE_DURATION_MASK = Integer.MIN_VALUE;
    private final MetricsLogger mLogger = new MetricsLogger();

    DisplayFoldDurationLogger() {
    }

    void onFinishedWakingUp(Boolean folded) {
        this.mScreenState = folded == null ? -1 : (folded != false ? 2 : 1);
        this.mLastChanged = SystemClock.uptimeMillis();
    }

    void onFinishedGoingToSleep() {
        this.log();
        this.mScreenState = 0;
        this.mLastChanged = null;
    }

    void setDeviceFolded(boolean folded) {
        if (!this.isOn()) {
            return;
        }
        this.log();
        this.mScreenState = folded ? 2 : 1;
        this.mLastChanged = SystemClock.uptimeMillis();
    }

    void logFocusedAppWithFoldState(boolean folded, String packageName) {
        this.mLogger.write(new LogMaker(1594).setType(4).setSubtype(folded ? 1 : 0).setPackageName(packageName));
    }

    private void log() {
        int subtype;
        if (this.mLastChanged == null) {
            return;
        }
        switch (this.mScreenState) {
            case 1: {
                subtype = Integer.MIN_VALUE;
                break;
            }
            case 2: {
                subtype = -2147483647;
                break;
            }
            default: {
                return;
            }
        }
        this.mLogger.write(new LogMaker(1594).setType(4).setSubtype(subtype).setLatency(SystemClock.uptimeMillis() - this.mLastChanged));
    }

    private boolean isOn() {
        return this.mScreenState == 1 || this.mScreenState == 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScreenState {
    }
}

