/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.PermissionInfo;
import android.os.Build;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.permission.PermissionControllerManager;
import android.util.ArraySet;
import android.util.LongSparseLongArray;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import com.android.internal.util.IntPair;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.pm.permission.PermissionManagerServiceInternal;
import com.android.server.policy.PermissionPolicyInternal;
import com.android.server.policy.SoftRestrictedPermissionPolicy;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

public final class PermissionPolicyService
extends SystemService {
    private static final String LOG_TAG = PermissionPolicyService.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final SparseBooleanArray mIsStarted = new SparseBooleanArray();
    @GuardedBy(value={"mLock"})
    private PermissionPolicyInternal.OnInitializedCallback mOnInitializedCallback;
    @GuardedBy(value={"mLock"})
    private final ArraySet<Pair<String, Integer>> mIsPackageSyncsScheduled = new ArraySet();

    public PermissionPolicyService(Context context) {
        super(context);
        LocalServices.addService(PermissionPolicyInternal.class, new Internal());
    }

    @Override
    public void onStart() {
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        PermissionManagerServiceInternal permManagerInternal = LocalServices.getService(PermissionManagerServiceInternal.class);
        IAppOpsService appOpsService = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        packageManagerInternal.getPackageList(new PackageManagerInternal.PackageListObserver(){

            @Override
            public void onPackageAdded(String packageName, int uid) {
                this.onPackageChanged(packageName, uid);
            }

            @Override
            public void onPackageChanged(String packageName, int uid) {
                int userId = UserHandle.getUserId(uid);
                if (PermissionPolicyService.this.isStarted(userId)) {
                    PermissionPolicyService.this.synchronizePackagePermissionsAndAppOpsForUser(packageName, userId);
                }
            }

            @Override
            public void onPackageRemoved(String packageName, int uid) {
            }
        });
        permManagerInternal.addOnRuntimePermissionStateChangedListener(this::synchronizePackagePermissionsAndAppOpsAsyncForUser);
        IAppOpsCallback.Stub appOpsListener = new IAppOpsCallback.Stub(){

            @Override
            public void opChanged(int op, int uid, String packageName) {
                PermissionPolicyService.this.synchronizePackagePermissionsAndAppOpsAsyncForUser(packageName, UserHandle.getUserId(uid));
            }
        };
        ArrayList<PermissionInfo> dangerousPerms = permManagerInternal.getAllPermissionWithProtectionLevel(1);
        try {
            int numDangerousPerms = dangerousPerms.size();
            for (int i = 0; i < numDangerousPerms; ++i) {
                PermissionInfo perm = dangerousPerms.get(i);
                if (perm.isHardRestricted() || perm.backgroundPermission != null) {
                    appOpsService.startWatchingMode(PermissionPolicyService.getSwitchOp(perm.name), null, appOpsListener);
                    continue;
                }
                if (!perm.isSoftRestricted()) continue;
                appOpsService.startWatchingMode(PermissionPolicyService.getSwitchOp(perm.name), null, appOpsListener);
                SoftRestrictedPermissionPolicy policy = SoftRestrictedPermissionPolicy.forPermission(null, null, null, perm.name);
                if (policy.resolveAppOp() == -1) continue;
                appOpsService.startWatchingMode(policy.resolveAppOp(), null, appOpsListener);
            }
        }
        catch (RemoteException doesNotHappen) {
            Slog.wtf(LOG_TAG, "Cannot set up app-ops listener");
        }
    }

    private static int getSwitchOp(String permission2) {
        int op = AppOpsManager.permissionToOpCode(permission2);
        if (op == -1) {
            return -1;
        }
        return AppOpsManager.opToSwitch(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizePackagePermissionsAndAppOpsAsyncForUser(String packageName, int changedUserId) {
        if (this.isStarted(changedUserId)) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mIsPackageSyncsScheduled.add(new Pair<String, Integer>(packageName, changedUserId))) {
                    FgThread.getHandler().sendMessage(PooledLambda.obtainMessage(PermissionPolicyService::synchronizePackagePermissionsAndAppOpsForUser, this, packageName, changedUserId));
                }
            }
        }
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 550) {
            UserManagerInternal um = LocalServices.getService(UserManagerInternal.class);
            for (int userId : um.getUserIds()) {
                if (!um.isUserRunning(userId)) continue;
                this.onStartUser(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStarted(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsStarted.get(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStartUser(int userId) {
        PermissionPolicyInternal.OnInitializedCallback callback;
        if (this.isStarted(userId)) {
            return;
        }
        this.grantOrUpgradeDefaultRuntimePermissionsIfNeeded(userId);
        Object object = this.mLock;
        synchronized (object) {
            this.mIsStarted.put(userId, true);
            callback = this.mOnInitializedCallback;
        }
        this.synchronizePermissionsAndAppOpsForUser(userId);
        if (callback != null) {
            callback.onInitialized(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStopUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsStarted.delete(userId);
        }
    }

    private void grantOrUpgradeDefaultRuntimePermissionsIfNeeded(int userId) {
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        if (packageManagerInternal.wereDefaultPermissionsGrantedSinceBoot(userId)) {
            CountDownLatch latch = new CountDownLatch(1);
            PermissionControllerManager permissionControllerManager = new PermissionControllerManager(PermissionPolicyService.getUserContext(this.getContext(), UserHandle.of(userId)), FgThread.getHandler());
            permissionControllerManager.grantOrUpgradeDefaultRuntimePermissions(FgThread.getExecutor(), success -> {
                if (!success.booleanValue()) {
                    String message = "Error granting/upgrading runtime permissions";
                    Slog.wtf(LOG_TAG, "Error granting/upgrading runtime permissions");
                    throw new IllegalStateException("Error granting/upgrading runtime permissions");
                }
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            packageManagerInternal.setRuntimePermissionsFingerPrint(Build.FINGERPRINT, userId);
        }
    }

    private static Context getUserContext(Context context, UserHandle user) {
        if (context.getUser().equals(user)) {
            return context;
        }
        try {
            return context.createPackageContextAsUser(context.getPackageName(), 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(LOG_TAG, "Cannot create context for user " + user, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizePackagePermissionsAndAppOpsForUser(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsPackageSyncsScheduled.remove(new Pair<String, Integer>(packageName, userId));
        }
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        PackageInfo pkg = packageManagerInternal.getPackageInfo(packageName, 0, 1000, userId);
        if (pkg == null) {
            return;
        }
        PermissionToOpSynchroniser synchroniser = new PermissionToOpSynchroniser(PermissionPolicyService.getUserContext(this.getContext(), UserHandle.of(userId)));
        synchroniser.addPackage(pkg.packageName);
        String[] sharedPkgNames = packageManagerInternal.getPackagesForSharedUserId(pkg.sharedUserId, userId);
        if (sharedPkgNames != null) {
            for (String sharedPkgName : sharedPkgNames) {
                PackageParser.Package sharedPkg = packageManagerInternal.getPackage(sharedPkgName);
                if (sharedPkg == null) continue;
                synchroniser.addPackage(sharedPkg.packageName);
            }
        }
        synchroniser.syncPackages();
    }

    private void synchronizePermissionsAndAppOpsForUser(int userId) {
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        PermissionToOpSynchroniser synchronizer = new PermissionToOpSynchroniser(PermissionPolicyService.getUserContext(this.getContext(), UserHandle.of(userId)));
        packageManagerInternal.forEachPackage(pkg -> synchronizer.addPackage(pkg.packageName));
        synchronizer.syncPackages();
    }

    private class Internal
    extends PermissionPolicyInternal {
        private Internal() {
        }

        @Override
        public boolean checkStartActivity(Intent intent, int callingUid, String callingPackage) {
            if (callingPackage != null && this.isActionRemovedForCallingPackage(intent, callingUid, callingPackage)) {
                Slog.w(LOG_TAG, "Action Removed: starting " + intent.toString() + " from " + callingPackage + " (uid=" + callingUid + ")");
                return false;
            }
            return true;
        }

        @Override
        public boolean isInitialized(int userId) {
            return PermissionPolicyService.this.isStarted(userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOnInitializedCallback(PermissionPolicyInternal.OnInitializedCallback callback) {
            Object object = PermissionPolicyService.this.mLock;
            synchronized (object) {
                PermissionPolicyService.this.mOnInitializedCallback = callback;
            }
        }

        private boolean isActionRemovedForCallingPackage(Intent intent, int callingUid, String callingPackage) {
            String action = intent.getAction();
            if (action == null) {
                return false;
            }
            switch (action) {
                case "android.telecom.action.CHANGE_DEFAULT_DIALER": 
                case "android.provider.Telephony.ACTION_CHANGE_DEFAULT": {
                    try {
                        ApplicationInfo applicationInfo = PermissionPolicyService.this.getContext().getPackageManager().getApplicationInfoAsUser(callingPackage, 0, UserHandle.getUserId(callingUid));
                        if (applicationInfo.targetSdkVersion >= 29) {
                            return true;
                        }
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.i(LOG_TAG, "Cannot find application info for " + callingPackage);
                    }
                    intent.putExtra("android.intent.extra.CALLING_PACKAGE", callingPackage);
                    return false;
                }
            }
            return false;
        }
    }

    private static class PermissionToOpSynchroniser {
        private final Context mContext;
        private final PackageManager mPackageManager;
        private final AppOpsManager mAppOpsManager;
        private final SparseIntArray mAllUids = new SparseIntArray();
        private final ArrayList<OpToChange> mOpsToDefault = new ArrayList();
        private final ArrayList<OpToChange> mOpsToAllowIfDefault = new ArrayList();
        private final ArrayList<OpToChange> mOpsToAllow = new ArrayList();
        private final ArrayList<OpToChange> mOpsToIgnoreIfDefault = new ArrayList();
        private final ArrayList<OpToChange> mOpsToIgnore = new ArrayList();
        private final ArrayList<OpToChange> mOpsToForeground = new ArrayList();
        private final ArrayList<OpToChange> mOpsToForegroundIfAllow = new ArrayList();

        PermissionToOpSynchroniser(Context context) {
            this.mContext = context;
            this.mPackageManager = context.getPackageManager();
            this.mAppOpsManager = context.getSystemService(AppOpsManager.class);
        }

        private void syncPackages() {
            LongSparseLongArray alreadySetAppOps = new LongSparseLongArray();
            int allowCount = this.mOpsToAllow.size();
            for (int i = 0; i < allowCount; ++i) {
                OpToChange op = this.mOpsToAllow.get(i);
                this.setUidModeAllowed(op.code, op.uid, op.packageName);
                alreadySetAppOps.put(IntPair.of(op.uid, op.code), 1L);
            }
            int allowIfDefaultCount = this.mOpsToAllowIfDefault.size();
            for (int i = 0; i < allowIfDefaultCount; ++i) {
                boolean wasSet;
                OpToChange op = this.mOpsToAllowIfDefault.get(i);
                if (alreadySetAppOps.indexOfKey(IntPair.of(op.uid, op.code)) >= 0 || !(wasSet = this.setUidModeAllowedIfDefault(op.code, op.uid, op.packageName))) continue;
                alreadySetAppOps.put(IntPair.of(op.uid, op.code), 1L);
            }
            int foregroundIfAllowedCount = this.mOpsToForegroundIfAllow.size();
            for (int i = 0; i < foregroundIfAllowedCount; ++i) {
                boolean wasSet;
                OpToChange op = this.mOpsToForegroundIfAllow.get(i);
                if (alreadySetAppOps.indexOfKey(IntPair.of(op.uid, op.code)) >= 0 || !(wasSet = this.setUidModeForegroundIfAllow(op.code, op.uid, op.packageName))) continue;
                alreadySetAppOps.put(IntPair.of(op.uid, op.code), 1L);
            }
            int foregroundCount = this.mOpsToForeground.size();
            for (int i = 0; i < foregroundCount; ++i) {
                OpToChange op = this.mOpsToForeground.get(i);
                if (alreadySetAppOps.indexOfKey(IntPair.of(op.uid, op.code)) >= 0) continue;
                this.setUidModeForeground(op.code, op.uid, op.packageName);
                alreadySetAppOps.put(IntPair.of(op.uid, op.code), 1L);
            }
            int ignoreCount = this.mOpsToIgnore.size();
            for (int i = 0; i < ignoreCount; ++i) {
                OpToChange op = this.mOpsToIgnore.get(i);
                if (alreadySetAppOps.indexOfKey(IntPair.of(op.uid, op.code)) >= 0) continue;
                this.setUidModeIgnored(op.code, op.uid, op.packageName);
                alreadySetAppOps.put(IntPair.of(op.uid, op.code), 1L);
            }
            int ignoreIfDefaultCount = this.mOpsToIgnoreIfDefault.size();
            for (int i = 0; i < ignoreIfDefaultCount; ++i) {
                boolean wasSet;
                OpToChange op = this.mOpsToIgnoreIfDefault.get(i);
                if (alreadySetAppOps.indexOfKey(IntPair.of(op.uid, op.code)) >= 0 || !(wasSet = this.setUidModeIgnoredIfDefault(op.code, op.uid, op.packageName))) continue;
                alreadySetAppOps.put(IntPair.of(op.uid, op.code), 1L);
            }
            int defaultCount = this.mOpsToDefault.size();
            for (int i = 0; i < defaultCount; ++i) {
                OpToChange op = this.mOpsToDefault.get(i);
                if (alreadySetAppOps.indexOfKey(IntPair.of(op.uid, op.code)) >= 0) continue;
                this.setUidModeDefault(op.code, op.uid, op.packageName);
                alreadySetAppOps.put(IntPair.of(op.uid, op.code), 1L);
            }
        }

        private void addOpIfRestricted(PermissionInfo permissionInfo, PackageInfo pkg) {
            boolean applyRestriction;
            String permission2 = permissionInfo.name;
            int opCode = PermissionPolicyService.getSwitchOp(permission2);
            int uid = pkg.applicationInfo.uid;
            if (!permissionInfo.isRestricted()) {
                return;
            }
            boolean bl = applyRestriction = (this.mPackageManager.getPermissionFlags(permission2, pkg.packageName, this.mContext.getUser()) & 0x4000) != 0;
            if (permissionInfo.isHardRestricted()) {
                if (opCode != -1) {
                    if (applyRestriction) {
                        this.mOpsToDefault.add(new OpToChange(uid, pkg.packageName, opCode));
                    } else {
                        this.mOpsToAllowIfDefault.add(new OpToChange(uid, pkg.packageName, opCode));
                    }
                }
            } else if (permissionInfo.isSoftRestricted()) {
                int op;
                SoftRestrictedPermissionPolicy policy = SoftRestrictedPermissionPolicy.forPermission(this.mContext, pkg.applicationInfo, this.mContext.getUser(), permission2);
                if (opCode != -1) {
                    if (policy.canBeGranted()) {
                        this.mOpsToAllowIfDefault.add(new OpToChange(uid, pkg.packageName, opCode));
                    } else {
                        this.mOpsToDefault.add(new OpToChange(uid, pkg.packageName, opCode));
                    }
                }
                if ((op = policy.resolveAppOp()) != -1) {
                    switch (policy.getDesiredOpMode()) {
                        case 3: {
                            this.mOpsToDefault.add(new OpToChange(uid, pkg.packageName, op));
                            break;
                        }
                        case 0: {
                            if (policy.shouldSetAppOpIfNotDefault()) {
                                this.mOpsToAllow.add(new OpToChange(uid, pkg.packageName, op));
                                break;
                            }
                            this.mOpsToAllowIfDefault.add(new OpToChange(uid, pkg.packageName, op));
                            break;
                        }
                        case 4: {
                            Slog.wtf(LOG_TAG, "Setting appop to foreground is not implemented");
                            break;
                        }
                        case 1: {
                            if (policy.shouldSetAppOpIfNotDefault()) {
                                this.mOpsToIgnore.add(new OpToChange(uid, pkg.packageName, op));
                                break;
                            }
                            this.mOpsToIgnoreIfDefault.add(new OpToChange(uid, pkg.packageName, op));
                            break;
                        }
                        case 2: {
                            Slog.wtf(LOG_TAG, "Setting appop to errored is not implemented");
                        }
                    }
                }
            }
        }

        private boolean isBgPermRestricted(String pkg, String perm, int uid) {
            try {
                PermissionInfo bgPermInfo = this.mPackageManager.getPermissionInfo(perm, 0);
                if (bgPermInfo.isSoftRestricted()) {
                    Slog.wtf(LOG_TAG, "Support for soft restricted background permissions not implemented");
                }
                return bgPermInfo.isHardRestricted() && (this.mPackageManager.getPermissionFlags(perm, pkg, UserHandle.getUserHandleForUid(uid)) & 0x4000) != 0;
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w(LOG_TAG, "Cannot read permission state of " + perm, e);
                return false;
            }
        }

        private void addOpIfFgPermissions(PermissionInfo permissionInfo, PackageInfo pkg) {
            String bgPermissionName = permissionInfo.backgroundPermission;
            if (bgPermissionName == null) {
                return;
            }
            String permission2 = permissionInfo.name;
            int opCode = PermissionPolicyService.getSwitchOp(permission2);
            String pkgName = pkg.packageName;
            int uid = pkg.applicationInfo.uid;
            if (pkg.applicationInfo.targetSdkVersion < 23) {
                int flags = this.mPackageManager.getPermissionFlags(bgPermissionName, pkg.packageName, UserHandle.getUserHandleForUid(uid));
                if ((flags & 0x40) == 0 && this.isBgPermRestricted(pkgName, bgPermissionName, uid)) {
                    this.mOpsToForegroundIfAllow.add(new OpToChange(uid, pkgName, opCode));
                }
                return;
            }
            if (this.mPackageManager.checkPermission(permission2, pkgName) == 0) {
                boolean isBgPermGranted;
                boolean isBgHardRestricted = this.isBgPermRestricted(pkgName, bgPermissionName, uid);
                boolean bl = isBgPermGranted = this.mPackageManager.checkPermission(bgPermissionName, pkgName) == 0;
                if (!isBgHardRestricted && isBgPermGranted) {
                    this.mOpsToAllow.add(new OpToChange(uid, pkgName, opCode));
                } else {
                    this.mOpsToForeground.add(new OpToChange(uid, pkgName, opCode));
                }
            } else {
                this.mOpsToIgnore.add(new OpToChange(uid, pkgName, opCode));
            }
        }

        void addPackage(String pkgName) {
            PackageInfo pkg;
            try {
                pkg = this.mPackageManager.getPackageInfo(pkgName, 4096);
            }
            catch (PackageManager.NameNotFoundException e) {
                return;
            }
            this.mAllUids.put(pkg.applicationInfo.uid, pkg.applicationInfo.uid);
            if (pkg.requestedPermissions == null) {
                return;
            }
            for (String permission2 : pkg.requestedPermissions) {
                PermissionInfo permissionInfo;
                int opCode = PermissionPolicyService.getSwitchOp(permission2);
                if (opCode == -1) continue;
                try {
                    permissionInfo = this.mPackageManager.getPermissionInfo(permission2, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    continue;
                }
                this.addOpIfRestricted(permissionInfo, pkg);
                this.addOpIfFgPermissions(permissionInfo, pkg);
            }
        }

        private boolean setUidModeAllowedIfDefault(int opCode, int uid, String packageName) {
            return this.setUidModeIfMode(opCode, uid, 3, 0, packageName);
        }

        private void setUidModeAllowed(int opCode, int uid, String packageName) {
            this.setUidMode(opCode, uid, 0, packageName);
        }

        private boolean setUidModeForegroundIfAllow(int opCode, int uid, String packageName) {
            return this.setUidModeIfMode(opCode, uid, 0, 4, packageName);
        }

        private void setUidModeForeground(int opCode, int uid, String packageName) {
            this.setUidMode(opCode, uid, 4, packageName);
        }

        private boolean setUidModeIgnoredIfDefault(int opCode, int uid, String packageName) {
            return this.setUidModeIfMode(opCode, uid, 3, 1, packageName);
        }

        private void setUidModeIgnored(int opCode, int uid, String packageName) {
            this.setUidMode(opCode, uid, 1, packageName);
        }

        private void setUidMode(int opCode, int uid, int mode, String packageName) {
            int currentMode = this.mAppOpsManager.unsafeCheckOpRaw(AppOpsManager.opToPublicName(opCode), uid, packageName);
            if (currentMode != mode) {
                this.mAppOpsManager.setUidMode(opCode, uid, mode);
            }
        }

        private boolean setUidModeIfMode(int opCode, int uid, int requiredModeBefore, int newMode, String packageName) {
            int currentMode = this.mAppOpsManager.unsafeCheckOpRaw(AppOpsManager.opToPublicName(opCode), uid, packageName);
            if (currentMode == requiredModeBefore) {
                this.mAppOpsManager.setUidMode(opCode, uid, newMode);
                return true;
            }
            return false;
        }

        private void setUidModeDefault(int opCode, int uid, String packageName) {
            this.setUidMode(opCode, uid, 3, packageName);
        }

        private class OpToChange {
            final int uid;
            final String packageName;
            final int code;

            OpToChange(int uid, String packageName, int code) {
                this.uid = uid;
                this.packageName = packageName;
                this.code = code;
            }
        }
    }
}

