/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityTaskManager;
import android.app.AppOpsManager;
import android.app.IUiModeManager;
import android.app.ProgressDialog;
import android.app.SearchManager;
import android.app.UiModeManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.hardware.hdmi.HdmiAudioSystemClient;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiPlaybackClient;
import android.hardware.input.InputManagerInternal;
import android.media.AudioAttributes;
import android.media.AudioManagerInternal;
import android.media.AudioSystem;
import android.media.IAudioService;
import android.media.session.MediaSessionLegacyHelper;
import android.os.Binder;
import android.os.Bundle;
import android.os.FactoryTest;
import android.os.Handler;
import android.os.IBinder;
import android.os.IDeviceIdleController;
import android.os.Message;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.dreams.DreamManagerInternal;
import android.service.dreams.IDreamManager;
import android.service.vr.IPersistentVrStateCallbacks;
import android.telecom.TelecomManager;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.MutableBoolean;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.IDisplayFoldListener;
import android.view.IWindowManager;
import android.view.InputDevice;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.autofill.AutofillManagerInternal;
import com.android.internal.R;
import com.android.internal.accessibility.AccessibilityShortcutController;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IShortcutService;
import com.android.internal.policy.PhoneWindow;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.util.ArrayUtils;
import com.android.server.ExtconStateObserver;
import com.android.server.ExtconUEventObserver;
import com.android.server.GestureLauncherService;
import com.android.server.LocalServices;
import com.android.server.SystemServiceManager;
import com.android.server.inputmethod.InputMethodManagerInternal;
import com.android.server.policy.BurnInProtectionHelper;
import com.android.server.policy.DisplayFoldController;
import com.android.server.policy.EventLogTags;
import com.android.server.policy.GlobalActions;
import com.android.server.policy.GlobalKeyManager;
import com.android.server.policy.LogDecelerateInterpolator;
import com.android.server.policy.ShortcutManager;
import com.android.server.policy.SplashScreenSurface;
import com.android.server.policy.WakeGestureListener;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.policy.keyguard.KeyguardServiceDelegate;
import com.android.server.policy.keyguard.KeyguardStateMonitor;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.vr.VrManagerInternal;
import com.android.server.wm.ActivityTaskManagerInternal;
import com.android.server.wm.AppTransition;
import com.android.server.wm.DisplayPolicy;
import com.android.server.wm.DisplayRotation;
import com.android.server.wm.WindowManagerInternal;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;

public class PhoneWindowManager
implements WindowManagerPolicy {
    static final String TAG = "WindowManager";
    static final boolean localLOGV = false;
    static final boolean DEBUG_INPUT = false;
    static final boolean DEBUG_KEYGUARD = false;
    static final boolean DEBUG_SPLASH_SCREEN = false;
    static final boolean DEBUG_WAKEUP = false;
    static final boolean SHOW_SPLASH_SCREENS = true;
    static final boolean ENABLE_DESK_DOCK_HOME_CAPTURE = false;
    static final boolean ENABLE_VR_HEADSET_HOME_CAPTURE = true;
    static final int SHORT_PRESS_POWER_NOTHING = 0;
    static final int SHORT_PRESS_POWER_GO_TO_SLEEP = 1;
    static final int SHORT_PRESS_POWER_REALLY_GO_TO_SLEEP = 2;
    static final int SHORT_PRESS_POWER_REALLY_GO_TO_SLEEP_AND_GO_HOME = 3;
    static final int SHORT_PRESS_POWER_GO_HOME = 4;
    static final int SHORT_PRESS_POWER_CLOSE_IME_OR_GO_HOME = 5;
    static final int LONG_PRESS_POWER_NOTHING = 0;
    static final int LONG_PRESS_POWER_GLOBAL_ACTIONS = 1;
    static final int LONG_PRESS_POWER_SHUT_OFF = 2;
    static final int LONG_PRESS_POWER_SHUT_OFF_NO_CONFIRM = 3;
    static final int LONG_PRESS_POWER_GO_TO_VOICE_ASSIST = 4;
    static final int LONG_PRESS_POWER_ASSISTANT = 5;
    static final int VERY_LONG_PRESS_POWER_NOTHING = 0;
    static final int VERY_LONG_PRESS_POWER_GLOBAL_ACTIONS = 1;
    static final int MULTI_PRESS_POWER_NOTHING = 0;
    static final int MULTI_PRESS_POWER_THEATER_MODE = 1;
    static final int MULTI_PRESS_POWER_BRIGHTNESS_BOOST = 2;
    static final int LONG_PRESS_BACK_NOTHING = 0;
    static final int LONG_PRESS_BACK_GO_TO_VOICE_ASSIST = 1;
    static final int LONG_PRESS_HOME_NOTHING = 0;
    static final int LONG_PRESS_HOME_ALL_APPS = 1;
    static final int LONG_PRESS_HOME_ASSIST = 2;
    static final int LAST_LONG_PRESS_HOME_BEHAVIOR = 2;
    static final int DOUBLE_TAP_HOME_NOTHING = 0;
    static final int DOUBLE_TAP_HOME_RECENT_SYSTEM_UI = 1;
    static final int SHORT_PRESS_WINDOW_NOTHING = 0;
    static final int SHORT_PRESS_WINDOW_PICTURE_IN_PICTURE = 1;
    static final int SHORT_PRESS_SLEEP_GO_TO_SLEEP = 0;
    static final int SHORT_PRESS_SLEEP_GO_TO_SLEEP_AND_GO_HOME = 1;
    static final int PENDING_KEY_NULL = -1;
    public static final String SYSTEM_DIALOG_REASON_KEY = "reason";
    public static final String SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS = "globalactions";
    public static final String SYSTEM_DIALOG_REASON_RECENT_APPS = "recentapps";
    public static final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";
    public static final String SYSTEM_DIALOG_REASON_ASSIST = "assist";
    public static final String SYSTEM_DIALOG_REASON_SCREENSHOT = "screenshot";
    private static final int POWER_BUTTON_SUPPRESSION_DELAY_DEFAULT_MILLIS = 800;
    private static final AudioAttributes VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    private boolean mKeyguardDrawnOnce;
    static SparseArray<String> sApplicationLaunchKeyCategories = new SparseArray();
    private static final int USER_ACTIVITY_NOTIFICATION_DELAY = 200;
    static final int WAITING_FOR_DRAWN_TIMEOUT = 1000;
    public static final int TOAST_WINDOW_TIMEOUT = 3500;
    private final Object mLock = new Object();
    Context mContext;
    IWindowManager mWindowManager;
    WindowManagerPolicy.WindowManagerFuncs mWindowManagerFuncs;
    WindowManagerInternal mWindowManagerInternal;
    PowerManager mPowerManager;
    ActivityManagerInternal mActivityManagerInternal;
    ActivityTaskManagerInternal mActivityTaskManagerInternal;
    AutofillManagerInternal mAutofillManagerInternal;
    InputManagerInternal mInputManagerInternal;
    InputMethodManagerInternal mInputMethodManagerInternal;
    DreamManagerInternal mDreamManagerInternal;
    PowerManagerInternal mPowerManagerInternal;
    IStatusBarService mStatusBarService;
    StatusBarManagerInternal mStatusBarManagerInternal;
    AudioManagerInternal mAudioManagerInternal;
    DisplayManager mDisplayManager;
    boolean mPreloadedRecentApps;
    final Object mServiceAquireLock = new Object();
    Vibrator mVibrator;
    SearchManager mSearchManager;
    AccessibilityManager mAccessibilityManager;
    BurnInProtectionHelper mBurnInProtectionHelper;
    private DisplayFoldController mDisplayFoldController;
    AppOpsManager mAppOpsManager;
    private boolean mHasFeatureWatch;
    private boolean mHasFeatureLeanback;
    private boolean mHasFeatureHdmiCec;
    volatile VrManagerInternal mVrManagerInternal;
    long[] mLongPressVibePattern;
    long[] mCalendarDateVibePattern;
    long[] mSafeModeEnabledVibePattern;
    boolean mEnableShiftMenuBugReports = false;
    private AccessibilityShortcutController mAccessibilityShortcutController;
    boolean mSafeMode;
    private WindowManagerPolicy.WindowState mKeyguardCandidate = null;
    private LongSparseArray<IShortcutService> mShortcutKeyServices = new LongSparseArray();
    private boolean mEnableCarDockHomeCapture = true;
    boolean mBootMessageNeedsHiding;
    KeyguardServiceDelegate mKeyguardDelegate;
    private boolean mKeyguardBound;
    final Runnable mWindowManagerDrawCallback = new Runnable(){

        @Override
        public void run() {
            PhoneWindowManager.this.mHandler.sendEmptyMessage(7);
        }
    };
    final KeyguardServiceDelegate.DrawnListener mKeyguardDrawnCallback = new KeyguardServiceDelegate.DrawnListener(){

        @Override
        public void onDrawn() {
            PhoneWindowManager.this.mHandler.sendEmptyMessage(5);
        }
    };
    GlobalActions mGlobalActions;
    Handler mHandler;
    volatile boolean mPowerKeyHandled;
    volatile boolean mBackKeyHandled;
    volatile boolean mBeganFromNonInteractive;
    volatile int mPowerKeyPressCounter;
    volatile boolean mEndCallKeyHandled;
    volatile boolean mCameraGestureTriggeredDuringGoingToSleep;
    volatile boolean mGoingToSleep;
    volatile boolean mRequestedOrGoingToSleep;
    volatile boolean mRecentsVisible;
    volatile boolean mNavBarVirtualKeyHapticFeedbackEnabled = true;
    volatile boolean mPictureInPictureVisible;
    private volatile boolean mDismissImeOnBackKeyPressed;
    volatile int mPendingWakeKey = -1;
    int mRecentAppsHeldModifiers;
    boolean mLanguageSwitchKeyPressed;
    int mCameraLensCoverState = -1;
    boolean mHaveBuiltInKeyboard;
    boolean mSystemReady;
    boolean mSystemBooted;
    HdmiControl mHdmiControl;
    IUiModeManager mUiModeManager;
    int mUiMode;
    boolean mWakeGestureEnabledSetting;
    MyWakeGestureListener mWakeGestureListener;
    int mLidKeyboardAccessibility;
    int mLidNavigationAccessibility;
    private boolean mLidControlsDisplayFold;
    int mShortPressOnPowerBehavior;
    int mLongPressOnPowerBehavior;
    int mVeryLongPressOnPowerBehavior;
    int mDoublePressOnPowerBehavior;
    int mTriplePressOnPowerBehavior;
    int mLongPressOnBackBehavior;
    int mShortPressOnSleepBehavior;
    int mShortPressOnWindowBehavior;
    boolean mHasSoftInput = false;
    boolean mHapticTextHandleEnabled;
    boolean mUseTvRouting;
    int mVeryLongPressTimeout;
    boolean mAllowStartActivityForLongPressOnPowerDuringSetup;
    MetricsLogger mLogger;
    private boolean mHandleVolumeKeysInWM;
    private boolean mPendingKeyguardOccluded;
    private boolean mKeyguardOccludedChanged;
    private boolean mNotifyUserActivity;
    ActivityTaskManagerInternal.SleepToken mScreenOffSleepToken;
    volatile boolean mKeyguardOccluded;
    Intent mHomeIntent;
    Intent mCarDockIntent;
    Intent mDeskDockIntent;
    Intent mVrHeadsetHomeIntent;
    boolean mSearchKeyShortcutPending;
    boolean mConsumeSearchKeyUp;
    boolean mPendingMetaAction;
    boolean mPendingCapsLockToggle;
    int mMetaState;
    int mInitialMetaState;
    private HashSet<Integer> mAllowLockscreenWhenOnDisplays = new HashSet();
    int mLockScreenTimeout;
    boolean mLockScreenTimerActive;
    int mEndcallBehavior;
    int mIncallPowerBehavior;
    int mIncallBackBehavior;
    boolean mSystemNavigationKeysEnabled;
    Display mDefaultDisplay;
    DisplayRotation mDefaultDisplayRotation;
    DisplayPolicy mDefaultDisplayPolicy;
    private int mLongPressOnHomeBehavior;
    private int mDoubleTapOnHomeBehavior;
    private boolean mAllowTheaterModeWakeFromKey;
    private boolean mAllowTheaterModeWakeFromPowerKey;
    private boolean mAllowTheaterModeWakeFromMotion;
    private boolean mAllowTheaterModeWakeFromMotionWhenNotDreaming;
    private boolean mAllowTheaterModeWakeFromCameraLens;
    private boolean mAllowTheaterModeWakeFromLidSwitch;
    private boolean mAllowTheaterModeWakeFromWakeGesture;
    private boolean mSupportLongPressPowerWhenNonInteractive;
    private boolean mGoToSleepOnButtonPressTheaterMode;
    private static final long SCREENSHOT_CHORD_DEBOUNCE_DELAY_MILLIS = 150L;
    private static final float KEYGUARD_SCREENSHOT_CHORD_DELAY_MULTIPLIER = 2.5f;
    private boolean mScreenshotChordEnabled;
    private boolean mScreenshotChordVolumeDownKeyTriggered;
    private long mScreenshotChordVolumeDownKeyTime;
    private boolean mScreenshotChordVolumeDownKeyConsumed;
    private boolean mA11yShortcutChordVolumeUpKeyTriggered;
    private long mA11yShortcutChordVolumeUpKeyTime;
    private boolean mA11yShortcutChordVolumeUpKeyConsumed;
    private boolean mScreenshotChordPowerKeyTriggered;
    private long mScreenshotChordPowerKeyTime;
    private static final long MOVING_DISPLAY_TO_TOP_DURATION_MILLIS = 10L;
    private volatile boolean mMovingDisplayToTopKeyTriggered;
    private volatile long mMovingDisplayToTopKeyTime;
    private int mRingerToggleChord = 0;
    private static final long BUGREPORT_TV_GESTURE_TIMEOUT_MILLIS = 1000L;
    private boolean mBugreportTvKey1Pressed;
    private boolean mBugreportTvKey2Pressed;
    private boolean mBugreportTvScheduled;
    private boolean mAccessibilityTvKey1Pressed;
    private boolean mAccessibilityTvKey2Pressed;
    private boolean mAccessibilityTvScheduled;
    private static final int BRIGHTNESS_STEPS = 10;
    SettingsObserver mSettingsObserver;
    ShortcutManager mShortcutManager;
    PowerManager.WakeLock mBroadcastWakeLock;
    PowerManager.WakeLock mPowerKeyWakeLock;
    boolean mHavePendingMediaKeyRepeatWithWakeLock;
    private int mCurrentUserId;
    private GlobalKeyManager mGlobalKeyManager;
    private final SparseArray<KeyCharacterMap.FallbackAction> mFallbackActions = new SparseArray();
    private final LogDecelerateInterpolator mLogDecelerateInterpolator = new LogDecelerateInterpolator(100, 0);
    private final MutableBoolean mTmpBoolean = new MutableBoolean(false);
    private boolean mAodShowing;
    private boolean mPerDisplayFocusEnabled = false;
    private volatile int mTopFocusedDisplayId = -1;
    private int mPowerButtonSuppressionDelayMillis = 800;
    private static final int MSG_DISPATCH_MEDIA_KEY_WITH_WAKE_LOCK = 3;
    private static final int MSG_DISPATCH_MEDIA_KEY_REPEAT_WITH_WAKE_LOCK = 4;
    private static final int MSG_KEYGUARD_DRAWN_COMPLETE = 5;
    private static final int MSG_KEYGUARD_DRAWN_TIMEOUT = 6;
    private static final int MSG_WINDOW_MANAGER_DRAWN_COMPLETE = 7;
    private static final int MSG_DISPATCH_SHOW_RECENTS = 9;
    private static final int MSG_DISPATCH_SHOW_GLOBAL_ACTIONS = 10;
    private static final int MSG_HIDE_BOOT_MESSAGE = 11;
    private static final int MSG_LAUNCH_VOICE_ASSIST_WITH_WAKE_LOCK = 12;
    private static final int MSG_POWER_DELAYED_PRESS = 13;
    private static final int MSG_POWER_LONG_PRESS = 14;
    private static final int MSG_SHOW_PICTURE_IN_PICTURE_MENU = 15;
    private static final int MSG_BACK_LONG_PRESS = 16;
    private static final int MSG_ACCESSIBILITY_SHORTCUT = 17;
    private static final int MSG_BUGREPORT_TV = 18;
    private static final int MSG_ACCESSIBILITY_TV = 19;
    private static final int MSG_DISPATCH_BACK_KEY_TO_AUTOFILL = 20;
    private static final int MSG_SYSTEM_KEY_PRESS = 21;
    private static final int MSG_HANDLE_ALL_APPS = 22;
    private static final int MSG_LAUNCH_ASSIST = 23;
    private static final int MSG_LAUNCH_ASSIST_LONG_PRESS = 24;
    private static final int MSG_POWER_VERY_LONG_PRESS = 25;
    private static final int MSG_NOTIFY_USER_ACTIVITY = 26;
    private static final int MSG_RINGER_TOGGLE_CHORD = 27;
    private static final int MSG_MOVE_DISPLAY_TO_TOP = 28;
    private UEventObserver mHDMIObserver = new UEventObserver(){

        @Override
        public void onUEvent(UEventObserver.UEvent event) {
            PhoneWindowManager.this.mDefaultDisplayPolicy.setHdmiPlugged("1".equals(event.get("SWITCH_STATE")));
        }
    };
    final IPersistentVrStateCallbacks mPersistentVrModeListener = new IPersistentVrStateCallbacks.Stub(){

        @Override
        public void onPersistentVrStateChanged(boolean enabled) {
            PhoneWindowManager.this.mDefaultDisplayPolicy.setPersistentVrModeEnabled(enabled);
        }
    };
    private Runnable mPossibleVeryLongPressReboot = new Runnable(){

        @Override
        public void run() {
            PhoneWindowManager.this.mActivityManagerInternal.prepareForPossibleShutdown();
        }
    };
    private final Runnable mEndCallLongPress = new Runnable(){

        @Override
        public void run() {
            PhoneWindowManager.this.mEndCallKeyHandled = true;
            PhoneWindowManager.this.performHapticFeedback(0, false, "End Call - Long Press - Show Global Actions");
            PhoneWindowManager.this.showGlobalActionsInternal();
        }
    };
    private final ScreenshotRunnable mScreenshotRunnable = new ScreenshotRunnable();
    private final SparseArray<DisplayHomeButtonHandler> mDisplayHomeButtonHandlers = new SparseArray();
    private static final int[] WINDOW_TYPES_WHERE_HOME_DOESNT_WORK;
    BroadcastReceiver mDockReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.DOCK_EVENT".equals(intent.getAction())) {
                PhoneWindowManager.this.mDefaultDisplayPolicy.setDockMode(intent.getIntExtra("android.intent.extra.DOCK_STATE", 0));
            } else {
                try {
                    IUiModeManager uiModeService = IUiModeManager.Stub.asInterface(ServiceManager.getService("uimode"));
                    PhoneWindowManager.this.mUiMode = uiModeService.getCurrentModeType();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            PhoneWindowManager.this.updateRotation(true);
            PhoneWindowManager.this.mDefaultDisplayRotation.updateOrientationListener();
        }
    };
    BroadcastReceiver mDreamReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.DREAMING_STARTED".equals(intent.getAction())) {
                if (PhoneWindowManager.this.mKeyguardDelegate != null) {
                    PhoneWindowManager.this.mKeyguardDelegate.onDreamingStarted();
                }
            } else if ("android.intent.action.DREAMING_STOPPED".equals(intent.getAction()) && PhoneWindowManager.this.mKeyguardDelegate != null) {
                PhoneWindowManager.this.mKeyguardDelegate.onDreamingStopped();
            }
        }
    };
    BroadcastReceiver mMultiuserReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_SWITCHED".equals(intent.getAction())) {
                PhoneWindowManager.this.mSettingsObserver.onChange(false);
                PhoneWindowManager.this.mDefaultDisplayRotation.onUserSwitch();
                PhoneWindowManager.this.mWindowManagerFuncs.onUserSwitched();
            }
        }
    };
    ProgressDialog mBootMsgDialog = null;
    ScreenLockTimeout mScreenLockTimeout = new ScreenLockTimeout();

    private void handleRingerChordGesture() {
        if (this.mRingerToggleChord == 0) {
            return;
        }
        this.getAudioManagerInternal();
        this.mAudioManagerInternal.silenceRingerModeInternal("volume_hush");
        Settings.Secure.putInt(this.mContext.getContentResolver(), "hush_gesture_used", 1);
        this.mLogger.action(1440, this.mRingerToggleChord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IStatusBarService getStatusBarService() {
        Object object = this.mServiceAquireLock;
        synchronized (object) {
            if (this.mStatusBarService == null) {
                this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
            }
            return this.mStatusBarService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatusBarManagerInternal getStatusBarManagerInternal() {
        Object object = this.mServiceAquireLock;
        synchronized (object) {
            if (this.mStatusBarManagerInternal == null) {
                this.mStatusBarManagerInternal = LocalServices.getService(StatusBarManagerInternal.class);
            }
            return this.mStatusBarManagerInternal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AudioManagerInternal getAudioManagerInternal() {
        Object object = this.mServiceAquireLock;
        synchronized (object) {
            if (this.mAudioManagerInternal == null) {
                this.mAudioManagerInternal = LocalServices.getService(AudioManagerInternal.class);
            }
            return this.mAudioManagerInternal;
        }
    }

    private void interceptBackKeyDown() {
        this.mLogger.count("key_back_down", 1);
        this.mBackKeyHandled = false;
        if (this.hasLongPressOnBackBehavior()) {
            Message msg = this.mHandler.obtainMessage(16);
            msg.setAsynchronous(true);
            this.mHandler.sendMessageDelayed(msg, ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
        }
    }

    private boolean interceptBackKeyUp(KeyEvent event) {
        TelecomManager telecomManager;
        this.mLogger.count("key_back_up", 1);
        boolean handled = this.mBackKeyHandled;
        this.cancelPendingBackKeyAction();
        if (this.mHasFeatureWatch && (telecomManager = this.getTelecommService()) != null) {
            if (telecomManager.isRinging()) {
                telecomManager.silenceRinger();
                return false;
            }
            if ((this.mIncallBackBehavior & 1) != 0 && telecomManager.isInCall()) {
                return telecomManager.endCall();
            }
        }
        if (this.mAutofillManagerInternal != null && event.getKeyCode() == 4) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(20));
        }
        return handled;
    }

    private void interceptPowerKeyDown(KeyEvent event, boolean interactive) {
        if (!this.mPowerKeyWakeLock.isHeld()) {
            this.mPowerKeyWakeLock.acquire();
        }
        if (this.mPowerKeyPressCounter != 0) {
            this.mHandler.removeMessages(13);
        }
        this.mWindowManagerFuncs.onPowerKeyDown(interactive);
        if (interactive && !this.mScreenshotChordPowerKeyTriggered && (event.getFlags() & 0x400) == 0) {
            this.mScreenshotChordPowerKeyTriggered = true;
            this.mScreenshotChordPowerKeyTime = event.getDownTime();
            this.interceptScreenshotChord();
            this.interceptRingerToggleChord();
        }
        TelecomManager telecomManager = this.getTelecommService();
        boolean hungUp = false;
        if (telecomManager != null) {
            if (telecomManager.isRinging()) {
                telecomManager.silenceRinger();
            } else if ((this.mIncallPowerBehavior & 2) != 0 && telecomManager.isInCall() && interactive) {
                hungUp = telecomManager.endCall();
            }
        }
        GestureLauncherService gestureService = LocalServices.getService(GestureLauncherService.class);
        boolean gesturedServiceIntercepted = false;
        if (gestureService != null) {
            gesturedServiceIntercepted = gestureService.interceptPowerKeyDown(event, interactive, this.mTmpBoolean);
            if (this.mTmpBoolean.value && this.mRequestedOrGoingToSleep) {
                this.mCameraGestureTriggeredDuringGoingToSleep = true;
            }
        }
        this.sendSystemKeyToStatusBarAsync(event.getKeyCode());
        this.schedulePossibleVeryLongPressReboot();
        boolean bl = this.mPowerKeyHandled = hungUp || this.mScreenshotChordVolumeDownKeyTriggered || this.mA11yShortcutChordVolumeUpKeyTriggered || gesturedServiceIntercepted;
        if (!this.mPowerKeyHandled) {
            if (interactive) {
                if (this.hasLongPressOnPowerBehavior()) {
                    if ((event.getFlags() & 0x80) != 0) {
                        this.powerLongPress();
                    } else {
                        Message msg = this.mHandler.obtainMessage(14);
                        msg.setAsynchronous(true);
                        this.mHandler.sendMessageDelayed(msg, ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
                        if (this.hasVeryLongPressOnPowerBehavior()) {
                            Message longMsg = this.mHandler.obtainMessage(25);
                            longMsg.setAsynchronous(true);
                            this.mHandler.sendMessageDelayed(longMsg, this.mVeryLongPressTimeout);
                        }
                    }
                }
            } else {
                this.wakeUpFromPowerKey(event.getDownTime());
                if (this.mSupportLongPressPowerWhenNonInteractive && this.hasLongPressOnPowerBehavior()) {
                    if ((event.getFlags() & 0x80) != 0) {
                        this.powerLongPress();
                    } else {
                        Message msg = this.mHandler.obtainMessage(14);
                        msg.setAsynchronous(true);
                        this.mHandler.sendMessageDelayed(msg, ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
                        if (this.hasVeryLongPressOnPowerBehavior()) {
                            Message longMsg = this.mHandler.obtainMessage(25);
                            longMsg.setAsynchronous(true);
                            this.mHandler.sendMessageDelayed(longMsg, this.mVeryLongPressTimeout);
                        }
                    }
                    this.mBeganFromNonInteractive = true;
                } else {
                    int maxCount = this.getMaxMultiPressPowerCount();
                    if (maxCount <= 1) {
                        this.mPowerKeyHandled = true;
                    } else {
                        this.mBeganFromNonInteractive = true;
                    }
                }
            }
        }
    }

    private void interceptPowerKeyUp(KeyEvent event, boolean interactive, boolean canceled) {
        boolean handled = canceled || this.mPowerKeyHandled;
        this.mScreenshotChordPowerKeyTriggered = false;
        this.cancelPendingScreenshotChordAction();
        this.cancelPendingPowerKeyAction();
        if (!handled) {
            if ((event.getFlags() & 0x80) == 0) {
                this.mHandler.post(this.mWindowManagerFuncs::triggerAnimationFailsafe);
            }
            ++this.mPowerKeyPressCounter;
            int maxCount = this.getMaxMultiPressPowerCount();
            long eventTime = event.getDownTime();
            if (this.mPowerKeyPressCounter < maxCount) {
                Message msg = this.mHandler.obtainMessage(13, interactive ? 1 : 0, this.mPowerKeyPressCounter, eventTime);
                msg.setAsynchronous(true);
                this.mHandler.sendMessageDelayed(msg, ViewConfiguration.getMultiPressTimeout());
                return;
            }
            this.powerPress(eventTime, interactive, this.mPowerKeyPressCounter);
        }
        this.finishPowerKeyPress();
    }

    private void finishPowerKeyPress() {
        this.mBeganFromNonInteractive = false;
        this.mPowerKeyPressCounter = 0;
        if (this.mPowerKeyWakeLock.isHeld()) {
            this.mPowerKeyWakeLock.release();
        }
    }

    private void cancelPendingPowerKeyAction() {
        if (!this.mPowerKeyHandled) {
            this.mPowerKeyHandled = true;
            this.mHandler.removeMessages(14);
        }
        if (this.hasVeryLongPressOnPowerBehavior()) {
            this.mHandler.removeMessages(25);
        }
        this.cancelPossibleVeryLongPressReboot();
    }

    private void cancelPendingBackKeyAction() {
        if (!this.mBackKeyHandled) {
            this.mBackKeyHandled = true;
            this.mHandler.removeMessages(16);
        }
    }

    private void powerPress(long eventTime, boolean interactive, int count) {
        if (this.mDefaultDisplayPolicy.isScreenOnEarly() && !this.mDefaultDisplayPolicy.isScreenOnFully()) {
            Slog.i(TAG, "Suppressed redundant power key press while already in the process of turning the screen on.");
            return;
        }
        Slog.d(TAG, "powerPress: eventTime=" + eventTime + " interactive=" + interactive + " count=" + count + " beganFromNonInteractive=" + this.mBeganFromNonInteractive + " mShortPressOnPowerBehavior=" + this.mShortPressOnPowerBehavior);
        if (count == 2) {
            this.powerMultiPressAction(eventTime, interactive, this.mDoublePressOnPowerBehavior);
        } else if (count == 3) {
            this.powerMultiPressAction(eventTime, interactive, this.mTriplePressOnPowerBehavior);
        } else if (interactive && !this.mBeganFromNonInteractive) {
            switch (this.mShortPressOnPowerBehavior) {
                case 0: {
                    break;
                }
                case 1: {
                    this.goToSleepFromPowerButton(eventTime, 0);
                    break;
                }
                case 2: {
                    this.goToSleepFromPowerButton(eventTime, 1);
                    break;
                }
                case 3: {
                    if (!this.goToSleepFromPowerButton(eventTime, 1)) break;
                    this.launchHomeFromHotKey(0);
                    break;
                }
                case 4: {
                    this.shortPressPowerGoHome();
                    break;
                }
                case 5: {
                    if (this.mDismissImeOnBackKeyPressed) {
                        if (this.mInputMethodManagerInternal == null) {
                            this.mInputMethodManagerInternal = LocalServices.getService(InputMethodManagerInternal.class);
                        }
                        if (this.mInputMethodManagerInternal == null) break;
                        this.mInputMethodManagerInternal.hideCurrentInputMethod();
                        break;
                    }
                    this.shortPressPowerGoHome();
                }
            }
        }
    }

    private boolean goToSleepFromPowerButton(long eventTime, int flags) {
        PowerManager.WakeData lastWakeUp = this.mPowerManagerInternal.getLastWakeup();
        if (lastWakeUp != null && lastWakeUp.wakeReason == 4) {
            int gestureDelayMillis = Settings.Global.getInt(this.mContext.getContentResolver(), "power_button_suppression_delay_after_gesture_wake", 800);
            long now = SystemClock.uptimeMillis();
            if (this.mPowerButtonSuppressionDelayMillis > 0 && now < lastWakeUp.wakeTime + (long)this.mPowerButtonSuppressionDelayMillis) {
                Slog.i(TAG, "Sleep from power button suppressed. Time since gesture: " + (now - lastWakeUp.wakeTime) + "ms");
                return false;
            }
        }
        this.goToSleep(eventTime, 4, flags);
        return true;
    }

    private void goToSleep(long eventTime, int reason, int flags) {
        this.mRequestedOrGoingToSleep = true;
        this.mPowerManager.goToSleep(eventTime, reason, flags);
    }

    private void shortPressPowerGoHome() {
        this.launchHomeFromHotKey(0, true, false);
        if (this.isKeyguardShowingAndNotOccluded()) {
            this.mKeyguardDelegate.onShortPowerPressedGoHome();
        }
    }

    private void powerMultiPressAction(long eventTime, boolean interactive, int behavior) {
        switch (behavior) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.isUserSetupComplete()) {
                    Slog.i(TAG, "Ignoring toggling theater mode - device not setup.");
                    break;
                }
                if (this.isTheaterModeEnabled()) {
                    Slog.i(TAG, "Toggling theater mode off.");
                    Settings.Global.putInt(this.mContext.getContentResolver(), "theater_mode_on", 0);
                    if (interactive) break;
                    this.wakeUpFromPowerKey(eventTime);
                    break;
                }
                Slog.i(TAG, "Toggling theater mode on.");
                Settings.Global.putInt(this.mContext.getContentResolver(), "theater_mode_on", 1);
                if (!this.mGoToSleepOnButtonPressTheaterMode || !interactive) break;
                this.goToSleep(eventTime, 4, 0);
                break;
            }
            case 2: {
                Slog.i(TAG, "Starting brightness boost.");
                if (!interactive) {
                    this.wakeUpFromPowerKey(eventTime);
                }
                this.mPowerManager.boostScreenBrightness(eventTime);
            }
        }
    }

    private int getLidBehavior() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "lid_behavior", 0);
    }

    private int getMaxMultiPressPowerCount() {
        if (this.mTriplePressOnPowerBehavior != 0) {
            return 3;
        }
        if (this.mDoublePressOnPowerBehavior != 0) {
            return 2;
        }
        return 1;
    }

    private void powerLongPress() {
        int behavior = this.getResolvedLongPressOnPowerBehavior();
        switch (behavior) {
            case 0: {
                break;
            }
            case 1: {
                this.mPowerKeyHandled = true;
                this.performHapticFeedback(0, false, "Power - Long Press - Global Actions");
                this.showGlobalActionsInternal();
                break;
            }
            case 2: 
            case 3: {
                this.mPowerKeyHandled = true;
                this.performHapticFeedback(0, false, "Power - Long Press - Shut Off");
                this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS);
                this.mWindowManagerFuncs.shutdown(behavior == 2);
                break;
            }
            case 4: {
                this.mPowerKeyHandled = true;
                this.performHapticFeedback(0, false, "Power - Long Press - Go To Voice Assist");
                this.launchVoiceAssist(this.mAllowStartActivityForLongPressOnPowerDuringSetup);
                break;
            }
            case 5: {
                this.mPowerKeyHandled = true;
                this.performHapticFeedback(0, false, "Power - Long Press - Go To Assistant");
                int powerKeyDeviceId = Integer.MIN_VALUE;
                this.launchAssistAction(null, Integer.MIN_VALUE);
            }
        }
    }

    private void powerVeryLongPress() {
        switch (this.mVeryLongPressOnPowerBehavior) {
            case 0: {
                break;
            }
            case 1: {
                this.mPowerKeyHandled = true;
                this.performHapticFeedback(0, false, "Power - Very Long Press - Show Global Actions");
                this.showGlobalActionsInternal();
            }
        }
    }

    private void backLongPress() {
        this.mBackKeyHandled = true;
        switch (this.mLongPressOnBackBehavior) {
            case 0: {
                break;
            }
            case 1: {
                this.launchVoiceAssist(false);
            }
        }
    }

    private void accessibilityShortcutActivated() {
        this.mAccessibilityShortcutController.performAccessibilityShortcut();
    }

    private void sleepPress() {
        if (this.mShortPressOnSleepBehavior == 1) {
            this.launchHomeFromHotKey(0, false, true);
        }
    }

    private void sleepRelease(long eventTime) {
        switch (this.mShortPressOnSleepBehavior) {
            case 0: 
            case 1: {
                Slog.i(TAG, "sleepRelease() calling goToSleep(GO_TO_SLEEP_REASON_SLEEP_BUTTON)");
                this.goToSleep(eventTime, 6, 0);
            }
        }
    }

    private int getResolvedLongPressOnPowerBehavior() {
        if (FactoryTest.isLongPressOnPowerOffEnabled()) {
            return 3;
        }
        return this.mLongPressOnPowerBehavior;
    }

    private boolean hasLongPressOnPowerBehavior() {
        return this.getResolvedLongPressOnPowerBehavior() != 0;
    }

    private boolean hasVeryLongPressOnPowerBehavior() {
        return this.mVeryLongPressOnPowerBehavior != 0;
    }

    private boolean hasLongPressOnBackBehavior() {
        return this.mLongPressOnBackBehavior != 0;
    }

    private void interceptScreenshotChord() {
        long now;
        if (this.mScreenshotChordEnabled && this.mScreenshotChordVolumeDownKeyTriggered && this.mScreenshotChordPowerKeyTriggered && !this.mA11yShortcutChordVolumeUpKeyTriggered && (now = SystemClock.uptimeMillis()) <= this.mScreenshotChordVolumeDownKeyTime + 150L && now <= this.mScreenshotChordPowerKeyTime + 150L) {
            this.mScreenshotChordVolumeDownKeyConsumed = true;
            this.cancelPendingPowerKeyAction();
            this.mScreenshotRunnable.setScreenshotType(1);
            this.mHandler.postDelayed(this.mScreenshotRunnable, this.getScreenshotChordLongPressDelay());
        }
    }

    private void interceptAccessibilityShortcutChord() {
        long now;
        if (this.mAccessibilityShortcutController.isAccessibilityShortcutAvailable(this.isKeyguardLocked()) && this.mScreenshotChordVolumeDownKeyTriggered && this.mA11yShortcutChordVolumeUpKeyTriggered && !this.mScreenshotChordPowerKeyTriggered && (now = SystemClock.uptimeMillis()) <= this.mScreenshotChordVolumeDownKeyTime + 150L && now <= this.mA11yShortcutChordVolumeUpKeyTime + 150L) {
            this.mScreenshotChordVolumeDownKeyConsumed = true;
            this.mA11yShortcutChordVolumeUpKeyConsumed = true;
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(17), this.getAccessibilityShortcutTimeout());
        }
    }

    private void interceptRingerToggleChord() {
        long now;
        if (this.mRingerToggleChord != 0 && this.mScreenshotChordPowerKeyTriggered && this.mA11yShortcutChordVolumeUpKeyTriggered && (now = SystemClock.uptimeMillis()) <= this.mA11yShortcutChordVolumeUpKeyTime + 150L && now <= this.mScreenshotChordPowerKeyTime + 150L) {
            this.mA11yShortcutChordVolumeUpKeyConsumed = true;
            this.cancelPendingPowerKeyAction();
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(27), this.getRingerToggleChordDelay());
        }
    }

    private long getAccessibilityShortcutTimeout() {
        ViewConfiguration config = ViewConfiguration.get(this.mContext);
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_shortcut_dialog_shown", 0, this.mCurrentUserId) == 0 ? config.getAccessibilityShortcutKeyTimeout() : config.getAccessibilityShortcutKeyTimeoutAfterConfirmation();
    }

    private long getScreenshotChordLongPressDelay() {
        if (this.mKeyguardDelegate.isShowing()) {
            return (long)(2.5f * (float)ViewConfiguration.get(this.mContext).getScreenshotChordKeyTimeout());
        }
        return ViewConfiguration.get(this.mContext).getScreenshotChordKeyTimeout();
    }

    private long getRingerToggleChordDelay() {
        return ViewConfiguration.getTapTimeout();
    }

    private void cancelPendingScreenshotChordAction() {
        this.mHandler.removeCallbacks(this.mScreenshotRunnable);
    }

    private void cancelPendingAccessibilityShortcutAction() {
        this.mHandler.removeMessages(17);
    }

    private void cancelPendingRingerToggleChordAction() {
        this.mHandler.removeMessages(27);
    }

    @Override
    public void showGlobalActions() {
        this.mHandler.removeMessages(10);
        this.mHandler.sendEmptyMessage(10);
    }

    void showGlobalActionsInternal() {
        if (this.mGlobalActions == null) {
            this.mGlobalActions = new GlobalActions(this.mContext, this.mWindowManagerFuncs);
        }
        boolean keyguardShowing = this.isKeyguardShowingAndNotOccluded();
        this.mGlobalActions.showDialog(keyguardShowing, this.isDeviceProvisioned());
        this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
    }

    boolean isDeviceProvisioned() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) != 0;
    }

    @Override
    public boolean isUserSetupComplete() {
        boolean isSetupComplete;
        boolean bl = isSetupComplete = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "user_setup_complete", 0, -2) != 0;
        if (this.mHasFeatureLeanback) {
            isSetupComplete &= this.isTvUserSetupComplete();
        }
        return isSetupComplete;
    }

    private boolean isTvUserSetupComplete() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "tv_user_setup_complete", 0, -2) != 0;
    }

    private void handleShortPressOnHome(int displayId) {
        HdmiControl hdmiControl = this.getHdmiControl();
        if (hdmiControl != null) {
            hdmiControl.turnOnTv();
        }
        if (this.mDreamManagerInternal != null && this.mDreamManagerInternal.isDreaming()) {
            this.mDreamManagerInternal.stopDream(false);
            return;
        }
        this.launchHomeFromHotKey(displayId);
    }

    private HdmiControl getHdmiControl() {
        if (null == this.mHdmiControl) {
            if (!this.mHasFeatureHdmiCec) {
                return null;
            }
            HdmiControlManager manager = (HdmiControlManager)this.mContext.getSystemService("hdmi_control");
            HdmiPlaybackClient client = null;
            if (manager != null) {
                client = manager.getPlaybackClient();
            }
            this.mHdmiControl = new HdmiControl(client);
        }
        return this.mHdmiControl;
    }

    private void launchAllAppsAction() {
        Intent intent = new Intent("android.intent.action.ALL_APPS");
        if (this.mHasFeatureLeanback) {
            PackageManager pm = this.mContext.getPackageManager();
            Intent intentLauncher = new Intent("android.intent.action.MAIN");
            intentLauncher.addCategory("android.intent.category.HOME");
            ResolveInfo resolveInfo = pm.resolveActivityAsUser(intentLauncher, 0x100000, this.mCurrentUserId);
            if (resolveInfo != null) {
                intent.setPackage(resolveInfo.activityInfo.packageName);
            }
        }
        this.startActivityAsUser(intent, UserHandle.CURRENT);
    }

    private void showPictureInPictureMenu(KeyEvent event) {
        this.mHandler.removeMessages(15);
        Message msg = this.mHandler.obtainMessage(15);
        msg.setAsynchronous(true);
        msg.sendToTarget();
    }

    private void showPictureInPictureMenuInternal() {
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.showPictureInPictureMenu();
        }
    }

    private boolean isRoundWindow() {
        return this.mContext.getResources().getConfiguration().isScreenRound();
    }

    @Override
    public void setDefaultDisplay(WindowManagerPolicy.DisplayContentInfo displayContentInfo) {
        this.mDefaultDisplay = displayContentInfo.getDisplay();
        this.mDefaultDisplayRotation = displayContentInfo.getDisplayRotation();
        this.mDefaultDisplayPolicy = this.mDefaultDisplayRotation.getDisplayPolicy();
    }

    @Override
    public void init(Context context, IWindowManager windowManager, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs) {
        this.mContext = context;
        this.mWindowManager = windowManager;
        this.mWindowManagerFuncs = windowManagerFuncs;
        this.mWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
        this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mActivityTaskManagerInternal = LocalServices.getService(ActivityTaskManagerInternal.class);
        this.mInputManagerInternal = LocalServices.getService(InputManagerInternal.class);
        this.mDreamManagerInternal = LocalServices.getService(DreamManagerInternal.class);
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        this.mAppOpsManager = this.mContext.getSystemService(AppOpsManager.class);
        this.mDisplayManager = this.mContext.getSystemService(DisplayManager.class);
        this.mHasFeatureWatch = this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        this.mHasFeatureLeanback = this.mContext.getPackageManager().hasSystemFeature("android.software.leanback");
        this.mHasFeatureHdmiCec = this.mContext.getPackageManager().hasSystemFeature("android.hardware.hdmi.cec");
        this.mAccessibilityShortcutController = new AccessibilityShortcutController(this.mContext, new Handler(), this.mCurrentUserId);
        this.mLogger = new MetricsLogger();
        boolean burnInProtectionEnabled = context.getResources().getBoolean(17891433);
        boolean burnInProtectionDevMode = SystemProperties.getBoolean("persist.debug.force_burn_in", false);
        if (burnInProtectionEnabled || burnInProtectionDevMode) {
            int maxRadius;
            int maxVertical;
            int minVertical;
            int maxHorizontal;
            int minHorizontal;
            if (burnInProtectionDevMode) {
                minHorizontal = -8;
                maxHorizontal = 8;
                minVertical = -8;
                maxVertical = -4;
                maxRadius = this.isRoundWindow() ? 6 : -1;
            } else {
                Resources resources = context.getResources();
                minHorizontal = resources.getInteger(17694756);
                maxHorizontal = resources.getInteger(17694753);
                minVertical = resources.getInteger(17694757);
                maxVertical = resources.getInteger(17694755);
                maxRadius = resources.getInteger(17694754);
            }
            this.mBurnInProtectionHelper = new BurnInProtectionHelper(context, minHorizontal, maxHorizontal, minVertical, maxVertical, maxRadius);
        }
        this.mHandler = new PolicyHandler();
        this.mWakeGestureListener = new MyWakeGestureListener(this.mContext, this.mHandler);
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mSettingsObserver.observe();
        this.mShortcutManager = new ShortcutManager(context);
        this.mUiMode = context.getResources().getInteger(17694782);
        this.mHomeIntent = new Intent("android.intent.action.MAIN", null);
        this.mHomeIntent.addCategory("android.intent.category.HOME");
        this.mHomeIntent.addFlags(0x10200000);
        this.mEnableCarDockHomeCapture = context.getResources().getBoolean(17891434);
        this.mCarDockIntent = new Intent("android.intent.action.MAIN", null);
        this.mCarDockIntent.addCategory("android.intent.category.CAR_DOCK");
        this.mCarDockIntent.addFlags(0x10200000);
        this.mDeskDockIntent = new Intent("android.intent.action.MAIN", null);
        this.mDeskDockIntent.addCategory("android.intent.category.DESK_DOCK");
        this.mDeskDockIntent.addFlags(0x10200000);
        this.mVrHeadsetHomeIntent = new Intent("android.intent.action.MAIN", null);
        this.mVrHeadsetHomeIntent.addCategory("android.intent.category.VR_HOME");
        this.mVrHeadsetHomeIntent.addFlags(0x10200000);
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mBroadcastWakeLock = this.mPowerManager.newWakeLock(1, "PhoneWindowManager.mBroadcastWakeLock");
        this.mPowerKeyWakeLock = this.mPowerManager.newWakeLock(1, "PhoneWindowManager.mPowerKeyWakeLock");
        this.mEnableShiftMenuBugReports = "1".equals(SystemProperties.get("ro.debuggable"));
        this.mLidKeyboardAccessibility = this.mContext.getResources().getInteger(17694817);
        this.mLidNavigationAccessibility = this.mContext.getResources().getInteger(17694818);
        this.mLidControlsDisplayFold = this.mContext.getResources().getBoolean(17891470);
        this.mAllowTheaterModeWakeFromKey = this.mContext.getResources().getBoolean(0x1110017);
        this.mAllowTheaterModeWakeFromPowerKey = this.mAllowTheaterModeWakeFromKey || this.mContext.getResources().getBoolean(0x111001B);
        this.mAllowTheaterModeWakeFromMotion = this.mContext.getResources().getBoolean(0x1110019);
        this.mAllowTheaterModeWakeFromMotionWhenNotDreaming = this.mContext.getResources().getBoolean(0x111001A);
        this.mAllowTheaterModeWakeFromCameraLens = this.mContext.getResources().getBoolean(0x1110014);
        this.mAllowTheaterModeWakeFromLidSwitch = this.mContext.getResources().getBoolean(0x1110018);
        this.mAllowTheaterModeWakeFromWakeGesture = this.mContext.getResources().getBoolean(0x1110016);
        this.mGoToSleepOnButtonPressTheaterMode = this.mContext.getResources().getBoolean(17891460);
        this.mSupportLongPressPowerWhenNonInteractive = this.mContext.getResources().getBoolean(0x11100CC);
        this.mLongPressOnBackBehavior = this.mContext.getResources().getInteger(17694822);
        this.mShortPressOnPowerBehavior = this.mContext.getResources().getInteger(17694890);
        this.mLongPressOnPowerBehavior = this.mContext.getResources().getInteger(17694824);
        this.mVeryLongPressOnPowerBehavior = this.mContext.getResources().getInteger(17694904);
        this.mDoublePressOnPowerBehavior = this.mContext.getResources().getInteger(17694796);
        this.mTriplePressOnPowerBehavior = this.mContext.getResources().getInteger(17694901);
        this.mShortPressOnSleepBehavior = this.mContext.getResources().getInteger(17694891);
        this.mVeryLongPressTimeout = this.mContext.getResources().getInteger(17694905);
        this.mAllowStartActivityForLongPressOnPowerDuringSetup = this.mContext.getResources().getBoolean(0x1110013);
        this.mHapticTextHandleEnabled = this.mContext.getResources().getBoolean(17891439);
        this.mUseTvRouting = AudioSystem.getPlatformType(this.mContext) == 2;
        this.mHandleVolumeKeysInWM = this.mContext.getResources().getBoolean(17891462);
        this.mPerDisplayFocusEnabled = this.mContext.getResources().getBoolean(0x1110004);
        this.readConfigurationDependentBehaviors();
        if (this.mLidControlsDisplayFold) {
            this.mDisplayFoldController = DisplayFoldController.create(context, 0);
        } else if (SystemProperties.getBoolean("persist.debug.force_foldable", false)) {
            this.mDisplayFoldController = DisplayFoldController.createWithProxSensor(context, 0);
        }
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        IntentFilter filter = new IntentFilter();
        filter.addAction(UiModeManager.ACTION_ENTER_CAR_MODE);
        filter.addAction(UiModeManager.ACTION_EXIT_CAR_MODE);
        filter.addAction(UiModeManager.ACTION_ENTER_DESK_MODE);
        filter.addAction(UiModeManager.ACTION_EXIT_DESK_MODE);
        filter.addAction("android.intent.action.DOCK_EVENT");
        Intent intent = context.registerReceiver(this.mDockReceiver, filter);
        if (intent != null) {
            this.mDefaultDisplayPolicy.setDockMode(intent.getIntExtra("android.intent.extra.DOCK_STATE", 0));
        }
        filter = new IntentFilter();
        filter.addAction("android.intent.action.DREAMING_STARTED");
        filter.addAction("android.intent.action.DREAMING_STOPPED");
        context.registerReceiver(this.mDreamReceiver, filter);
        filter = new IntentFilter("android.intent.action.USER_SWITCHED");
        context.registerReceiver(this.mMultiuserReceiver, filter);
        this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        this.mLongPressVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236034);
        this.mCalendarDateVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235994);
        this.mSafeModeEnabledVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236052);
        this.mScreenshotChordEnabled = this.mContext.getResources().getBoolean(0x1110077);
        this.mGlobalKeyManager = new GlobalKeyManager(this.mContext);
        this.initializeHdmiState();
        if (!this.mPowerManager.isInteractive()) {
            this.startedGoingToSleep(2);
            this.finishedGoingToSleep(2);
        }
        this.mWindowManagerInternal.registerAppTransitionListener(new WindowManagerInternal.AppTransitionListener(){

            @Override
            public int onAppTransitionStartingLocked(int transit, long duration, long statusBarAnimationStartTime, long statusBarAnimationDuration) {
                return PhoneWindowManager.this.handleStartTransitionForKeyguardLw(transit, duration);
            }

            @Override
            public void onAppTransitionCancelledLocked(int transit) {
                PhoneWindowManager.this.handleStartTransitionForKeyguardLw(transit, 0L);
            }
        });
        this.mKeyguardDelegate = new KeyguardServiceDelegate(this.mContext, new KeyguardStateMonitor.StateCallback(){

            @Override
            public void onTrustedChanged() {
                PhoneWindowManager.this.mWindowManagerFuncs.notifyKeyguardTrustedChanged();
            }

            @Override
            public void onShowingChanged() {
                PhoneWindowManager.this.mWindowManagerFuncs.onKeyguardShowingAndNotOccludedChanged();
            }
        });
    }

    private void readConfigurationDependentBehaviors() {
        Resources res = this.mContext.getResources();
        this.mLongPressOnHomeBehavior = res.getInteger(17694823);
        if (this.mLongPressOnHomeBehavior < 0 || this.mLongPressOnHomeBehavior > 2) {
            this.mLongPressOnHomeBehavior = 0;
        }
        this.mDoubleTapOnHomeBehavior = res.getInteger(17694797);
        if (this.mDoubleTapOnHomeBehavior < 0 || this.mDoubleTapOnHomeBehavior > 1) {
            this.mDoubleTapOnHomeBehavior = 0;
        }
        this.mShortPressOnWindowBehavior = 0;
        if (this.mContext.getPackageManager().hasSystemFeature("android.software.picture_in_picture")) {
            this.mShortPressOnWindowBehavior = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings() {
        ContentResolver resolver = this.mContext.getContentResolver();
        boolean updateRotation = false;
        Object object = this.mLock;
        synchronized (object) {
            boolean hasSoftInput;
            boolean wakeGestureEnabledSetting;
            this.mEndcallBehavior = Settings.System.getIntForUser(resolver, "end_button_behavior", 2, -2);
            this.mIncallPowerBehavior = Settings.Secure.getIntForUser(resolver, "incall_power_button_behavior", 1, -2);
            this.mIncallBackBehavior = Settings.Secure.getIntForUser(resolver, "incall_back_button_behavior", 0, -2);
            this.mSystemNavigationKeysEnabled = Settings.Secure.getIntForUser(resolver, "system_navigation_keys_enabled", 0, -2) == 1;
            this.mRingerToggleChord = Settings.Secure.getIntForUser(resolver, "volume_hush_gesture", 0, -2);
            this.mPowerButtonSuppressionDelayMillis = Settings.Global.getInt(resolver, "power_button_suppression_delay_after_gesture_wake", 800);
            if (!this.mContext.getResources().getBoolean(17891571)) {
                this.mRingerToggleChord = 0;
            }
            boolean bl = wakeGestureEnabledSetting = Settings.Secure.getIntForUser(resolver, "wake_gesture_enabled", 0, -2) != 0;
            if (this.mWakeGestureEnabledSetting != wakeGestureEnabledSetting) {
                this.mWakeGestureEnabledSetting = wakeGestureEnabledSetting;
                this.updateWakeGestureListenerLp();
            }
            this.mLockScreenTimeout = Settings.System.getIntForUser(resolver, "screen_off_timeout", 0, -2);
            String imId = Settings.Secure.getStringForUser(resolver, "default_input_method", -2);
            boolean bl2 = hasSoftInput = imId != null && imId.length() > 0;
            if (this.mHasSoftInput != hasSoftInput) {
                this.mHasSoftInput = hasSoftInput;
                updateRotation = true;
            }
            this.mLongPressOnPowerBehavior = Settings.Global.getInt(resolver, "power_button_long_press", this.mContext.getResources().getInteger(17694824));
            this.mVeryLongPressOnPowerBehavior = Settings.Global.getInt(resolver, "power_button_very_long_press", this.mContext.getResources().getInteger(17694904));
        }
        if (updateRotation) {
            this.updateRotation(true);
        }
    }

    private void updateWakeGestureListenerLp() {
        if (this.shouldEnableWakeGestureLp()) {
            this.mWakeGestureListener.requestWakeUpTrigger();
        } else {
            this.mWakeGestureListener.cancelWakeUpTrigger();
        }
    }

    private boolean shouldEnableWakeGestureLp() {
        return this.mWakeGestureEnabledSetting && !this.mDefaultDisplayPolicy.isAwake() && (this.getLidBehavior() != 1 || this.mDefaultDisplayPolicy.getLidState() != 0) && this.mWakeGestureListener.isSupported();
    }

    @Override
    public int checkAddPermission(WindowManager.LayoutParams attrs, int[] outAppOp) {
        ApplicationInfo appInfo;
        boolean isRoundedCornerOverlay;
        int type = attrs.type;
        boolean bl = isRoundedCornerOverlay = (attrs.privateFlags & 0x100000) != 0;
        if (isRoundedCornerOverlay && this.mContext.checkCallingOrSelfPermission("android.permission.INTERNAL_SYSTEM_WINDOW") != 0) {
            return -8;
        }
        outAppOp[0] = -1;
        if (!(type >= 1 && type <= 99 || type >= 1000 && type <= 1999 || type >= 2000 && type <= 2999)) {
            return -10;
        }
        if (type < 2000 || type > 2999) {
            return 0;
        }
        if (!WindowManager.LayoutParams.isSystemAlertWindowType(type)) {
            switch (type) {
                case 2005: {
                    outAppOp[0] = 45;
                    return 0;
                }
                case 2011: 
                case 2013: 
                case 2023: 
                case 2030: 
                case 2031: 
                case 2032: 
                case 2035: 
                case 2037: {
                    return 0;
                }
            }
            return this.mContext.checkCallingOrSelfPermission("android.permission.INTERNAL_SYSTEM_WINDOW") == 0 ? 0 : -8;
        }
        outAppOp[0] = 24;
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callingUid) == 1000) {
            return 0;
        }
        try {
            appInfo = this.mContext.getPackageManager().getApplicationInfoAsUser(attrs.packageName, 0, UserHandle.getUserId(callingUid));
        }
        catch (PackageManager.NameNotFoundException e) {
            appInfo = null;
        }
        if (appInfo == null || type != 2038 && appInfo.targetSdkVersion >= 26) {
            return this.mContext.checkCallingOrSelfPermission("android.permission.INTERNAL_SYSTEM_WINDOW") == 0 ? 0 : -8;
        }
        int mode = this.mAppOpsManager.noteOpNoThrow(outAppOp[0], callingUid, attrs.packageName);
        switch (mode) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                if (appInfo.targetSdkVersion < 23) {
                    return 0;
                }
                return -8;
            }
        }
        return this.mContext.checkCallingOrSelfPermission("android.permission.SYSTEM_ALERT_WINDOW") == 0 ? 0 : -8;
    }

    @Override
    public boolean checkShowToOwnerOnly(WindowManager.LayoutParams attrs) {
        switch (attrs.type) {
            default: {
                if ((attrs.privateFlags & 0x10) != 0) break;
                return true;
            }
            case 3: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2014: 
            case 2017: 
            case 2018: 
            case 2019: 
            case 2020: 
            case 2021: 
            case 2022: 
            case 2024: 
            case 2026: 
            case 2027: 
            case 2030: 
            case 2034: 
            case 2037: 
        }
        return this.mContext.checkCallingOrSelfPermission("android.permission.INTERNAL_SYSTEM_WINDOW") != 0;
    }

    void readLidState() {
        this.mDefaultDisplayPolicy.setLidState(this.mWindowManagerFuncs.getLidState());
    }

    private void readCameraLensCoverState() {
        this.mCameraLensCoverState = this.mWindowManagerFuncs.getCameraLensCoverState();
    }

    private boolean isHidden(int accessibilityMode) {
        int lidState = this.mDefaultDisplayPolicy.getLidState();
        switch (accessibilityMode) {
            case 1: {
                return lidState == 0;
            }
            case 2: {
                return lidState == 1;
            }
        }
        return false;
    }

    @Override
    public void adjustConfigurationLw(Configuration config, int keyboardPresence, int navigationPresence) {
        this.mHaveBuiltInKeyboard = (keyboardPresence & 1) != 0;
        this.readConfigurationDependentBehaviors();
        this.readLidState();
        if (config.keyboard == 1 || keyboardPresence == 1 && this.isHidden(this.mLidKeyboardAccessibility)) {
            config.hardKeyboardHidden = 2;
            if (!this.mHasSoftInput) {
                config.keyboardHidden = 2;
            }
        }
        if (config.navigation == 1 || navigationPresence == 1 && this.isHidden(this.mLidNavigationAccessibility)) {
            config.navigationHidden = 2;
        }
    }

    @Override
    public int getMaxWallpaperLayer() {
        return this.getWindowLayerFromTypeLw(2000);
    }

    @Override
    public boolean isKeyguardHostWindow(WindowManager.LayoutParams attrs) {
        return attrs.type == 2000;
    }

    @Override
    public boolean canBeHiddenByKeyguardLw(WindowManagerPolicy.WindowState win) {
        if (win.getAppToken() != null) {
            return false;
        }
        switch (win.getAttrs().type) {
            case 2000: 
            case 2013: 
            case 2019: 
            case 2023: {
                return false;
            }
        }
        return this.getWindowLayerLw(win) < this.getWindowLayerFromTypeLw(2000);
    }

    private boolean shouldBeHiddenByKeyguard(WindowManagerPolicy.WindowState win, WindowManagerPolicy.WindowState imeTarget) {
        boolean hideIme;
        boolean hideDockDivider;
        WindowManager.LayoutParams attrs = win.getAttrs();
        boolean bl = hideDockDivider = attrs.type == 2034 && !this.mWindowManagerInternal.isStackVisibleLw(3);
        if (hideDockDivider) {
            return true;
        }
        boolean bl2 = hideIme = win.isInputMethodWindow() && (this.mAodShowing || !this.mDefaultDisplayPolicy.isWindowManagerDrawComplete());
        if (hideIme) {
            return true;
        }
        boolean showImeOverKeyguard = imeTarget != null && imeTarget.isVisibleLw() && (imeTarget.canShowWhenLocked() || !this.canBeHiddenByKeyguardLw(imeTarget));
        boolean allowWhenLocked = win.isInputMethodWindow() && showImeOverKeyguard;
        boolean isKeyguardShowing = this.mKeyguardDelegate.isShowing();
        if (isKeyguardShowing && this.isKeyguardOccluded()) {
            allowWhenLocked |= win.canShowWhenLocked() || (attrs.privateFlags & 0x100) != 0;
        }
        return isKeyguardShowing && !allowWhenLocked && win.getDisplayId() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowManagerPolicy.StartingSurface addSplashScreen(IBinder appToken, String packageName, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, Configuration overrideConfig, int displayId) {
        if (packageName == null) {
            return null;
        }
        WindowManager wm = null;
        View view = null;
        try {
            Context context = this.mContext;
            Context displayContext = this.getDisplayContext(context, displayId);
            if (displayContext == null) {
                WindowManagerPolicy.StartingSurface startingSurface = null;
                return startingSurface;
            }
            context = displayContext;
            if (theme != context.getThemeResId() || labelRes != 0) {
                try {
                    context = context.createPackageContext(packageName, 4);
                    context.setTheme(theme);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if (overrideConfig != null && !overrideConfig.equals(Configuration.EMPTY)) {
                Context overrideContext = context.createConfigurationContext(overrideConfig);
                overrideContext.setTheme(theme);
                TypedArray typedArray = overrideContext.obtainStyledAttributes(R.styleable.Window);
                int resId = typedArray.getResourceId(1, 0);
                if (resId != 0 && overrideContext.getDrawable(resId) != null) {
                    context = overrideContext;
                }
                typedArray.recycle();
            }
            PhoneWindow win = new PhoneWindow(context);
            win.setIsStartingWindow(true);
            CharSequence label = context.getResources().getText(labelRes, null);
            if (label != null) {
                win.setTitle(label, true);
            } else {
                win.setTitle(nonLocalizedLabel, false);
            }
            win.setType(3);
            Object resId = this.mWindowManagerFuncs.getWindowManagerLock();
            synchronized (resId) {
                if (displayId == 0 && this.mKeyguardOccluded) {
                    windowFlags |= 0x80000;
                }
            }
            win.setFlags(windowFlags | 0x10 | 8 | 0x20000, windowFlags | 0x10 | 8 | 0x20000);
            win.setDefaultIcon(icon);
            win.setDefaultLogo(logo);
            win.setLayout(-1, -1);
            WindowManager.LayoutParams params = win.getAttributes();
            params.token = appToken;
            params.packageName = packageName;
            params.windowAnimations = win.getWindowStyle().getResourceId(8, 0);
            params.privateFlags |= 1;
            params.privateFlags |= 0x10;
            if (!compatInfo.supportsScreen()) {
                params.privateFlags |= 0x80;
            }
            params.setTitle("Splash Screen " + packageName);
            this.addSplashscreenContent(win, context);
            wm = (WindowManager)context.getSystemService("window");
            view = win.getDecorView();
            wm.addView(view, params);
            SplashScreenSurface splashScreenSurface = view.getParent() != null ? new SplashScreenSurface(view, appToken) : null;
            return splashScreenSurface;
        }
        catch (WindowManager.BadTokenException e) {
            Log.w(TAG, appToken + " already running, starting window not displayed. " + e.getMessage());
        }
        catch (RuntimeException e) {
            Log.w(TAG, appToken + " failed creating starting window", e);
        }
        finally {
            if (view != null && view.getParent() == null) {
                Log.w(TAG, "view not successfully added to wm, removing view");
                wm.removeViewImmediate(view);
            }
        }
        return null;
    }

    private void addSplashscreenContent(PhoneWindow win, Context ctx) {
        TypedArray a = ctx.obtainStyledAttributes(R.styleable.Window);
        int resId = a.getResourceId(48, 0);
        a.recycle();
        if (resId == 0) {
            return;
        }
        Drawable drawable2 = ctx.getDrawable(resId);
        if (drawable2 == null) {
            return;
        }
        View v = new View(ctx);
        v.setBackground(drawable2);
        win.setContentView(v);
    }

    private Context getDisplayContext(Context context, int displayId) {
        if (displayId == 0) {
            return context;
        }
        Display targetDisplay = this.mDisplayManager.getDisplay(displayId);
        if (targetDisplay == null) {
            return null;
        }
        return context.createDisplayContext(targetDisplay);
    }

    @Override
    public Animation createHiddenByKeyguardExit(boolean onWallpaper, boolean goingToNotificationShade) {
        if (goingToNotificationShade) {
            return AnimationUtils.loadAnimation(this.mContext, 17432819);
        }
        AnimationSet set = (AnimationSet)AnimationUtils.loadAnimation(this.mContext, onWallpaper ? 17432820 : 17432818);
        List<Animation> animations = set.getAnimations();
        for (int i = animations.size() - 1; i >= 0; --i) {
            animations.get(i).setInterpolator(this.mLogDecelerateInterpolator);
        }
        return set;
    }

    @Override
    public Animation createKeyguardWallpaperExit(boolean goingToNotificationShade) {
        if (goingToNotificationShade) {
            return null;
        }
        return AnimationUtils.loadAnimation(this.mContext, 17432823);
    }

    private static void awakenDreams() {
        IDreamManager dreamManager = PhoneWindowManager.getDreamManager();
        if (dreamManager != null) {
            try {
                dreamManager.awaken();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    static IDreamManager getDreamManager() {
        return IDreamManager.Stub.asInterface(ServiceManager.checkService("dreams"));
    }

    TelecomManager getTelecommService() {
        return (TelecomManager)this.mContext.getSystemService("telecom");
    }

    static IAudioService getAudioService() {
        IAudioService audioService = IAudioService.Stub.asInterface(ServiceManager.checkService("audio"));
        if (audioService == null) {
            Log.w(TAG, "Unable to find IAudioService interface.");
        }
        return audioService;
    }

    boolean keyguardOn() {
        return this.isKeyguardShowingAndNotOccluded() || this.inKeyguardRestrictedKeyInputMode();
    }

    @Override
    public long interceptKeyBeforeDispatching(WindowManagerPolicy.WindowState win, KeyEvent event, int policyFlags) {
        long result = this.interceptKeyBeforeDispatchingInner(win, event, policyFlags);
        int eventDisplayId = event.getDisplayId();
        if (result == 0L && !this.mPerDisplayFocusEnabled && eventDisplayId != -1 && eventDisplayId != this.mTopFocusedDisplayId) {
            long eventDownTime = event.getDownTime();
            if (this.mMovingDisplayToTopKeyTime < eventDownTime) {
                this.mMovingDisplayToTopKeyTime = eventDownTime;
                this.mMovingDisplayToTopKeyTriggered = true;
                this.mHandler.sendMessage(this.mHandler.obtainMessage(28, eventDisplayId, 0));
                return 10L;
            }
            if (this.mMovingDisplayToTopKeyTriggered) {
                return 10L;
            }
            Slog.w(TAG, "Dropping key targeting non-focused display #" + eventDisplayId + " keyCode=" + KeyEvent.keyCodeToString(event.getKeyCode()));
            return -1L;
        }
        return result;
    }

    private long interceptKeyBeforeDispatchingInner(WindowManagerPolicy.WindowState win, KeyEvent event, int policyFlags) {
        boolean isCtrlOrMetaSpace;
        String category;
        Intent shortcutIntent;
        KeyCharacterMap kcm;
        long timeoutTime;
        long now;
        boolean keyguardOn = this.keyguardOn();
        int keyCode = event.getKeyCode();
        int repeatCount = event.getRepeatCount();
        int metaState = event.getMetaState();
        int flags = event.getFlags();
        boolean down = event.getAction() == 0;
        boolean canceled = event.isCanceled();
        int displayId = event.getDisplayId();
        if (this.mScreenshotChordEnabled && (flags & 0x400) == 0) {
            if (this.mScreenshotChordVolumeDownKeyTriggered && !this.mScreenshotChordPowerKeyTriggered && (now = SystemClock.uptimeMillis()) < (timeoutTime = this.mScreenshotChordVolumeDownKeyTime + 150L)) {
                return timeoutTime - now;
            }
            if (keyCode == 25 && this.mScreenshotChordVolumeDownKeyConsumed) {
                if (!down) {
                    this.mScreenshotChordVolumeDownKeyConsumed = false;
                }
                return -1L;
            }
        }
        if (this.mAccessibilityShortcutController.isAccessibilityShortcutAvailable(false) && (flags & 0x400) == 0) {
            if (this.mScreenshotChordVolumeDownKeyTriggered ^ this.mA11yShortcutChordVolumeUpKeyTriggered && (now = SystemClock.uptimeMillis()) < (timeoutTime = (this.mScreenshotChordVolumeDownKeyTriggered ? this.mScreenshotChordVolumeDownKeyTime : this.mA11yShortcutChordVolumeUpKeyTime) + 150L)) {
                return timeoutTime - now;
            }
            if (keyCode == 25 && this.mScreenshotChordVolumeDownKeyConsumed) {
                if (!down) {
                    this.mScreenshotChordVolumeDownKeyConsumed = false;
                }
                return -1L;
            }
            if (keyCode == 24 && this.mA11yShortcutChordVolumeUpKeyConsumed) {
                if (!down) {
                    this.mA11yShortcutChordVolumeUpKeyConsumed = false;
                }
                return -1L;
            }
        }
        if (this.mRingerToggleChord != 0 && (flags & 0x400) == 0) {
            if (this.mA11yShortcutChordVolumeUpKeyTriggered && !this.mScreenshotChordPowerKeyTriggered && (now = SystemClock.uptimeMillis()) < (timeoutTime = this.mA11yShortcutChordVolumeUpKeyTime + 150L)) {
                return timeoutTime - now;
            }
            if (keyCode == 24 && this.mA11yShortcutChordVolumeUpKeyConsumed) {
                if (!down) {
                    this.mA11yShortcutChordVolumeUpKeyConsumed = false;
                }
                return -1L;
            }
        }
        if (this.mPendingMetaAction && !KeyEvent.isMetaKey(keyCode)) {
            this.mPendingMetaAction = false;
        }
        if (this.mPendingCapsLockToggle && !KeyEvent.isMetaKey(keyCode) && !KeyEvent.isAltKey(keyCode)) {
            this.mPendingCapsLockToggle = false;
        }
        if (keyCode == 3) {
            DisplayHomeButtonHandler handler = this.mDisplayHomeButtonHandlers.get(displayId);
            if (handler == null) {
                handler = new DisplayHomeButtonHandler(displayId);
                this.mDisplayHomeButtonHandlers.put(displayId, handler);
            }
            return handler.handleHomeButton(win, event);
        }
        if (keyCode == 82) {
            boolean chordBug = true;
            if (down && repeatCount == 0 && this.mEnableShiftMenuBugReports && (metaState & 1) == 1) {
                Intent intent = new Intent("android.intent.action.BUG_REPORT");
                this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.CURRENT, null, null, null, 0, null, null);
                return -1L;
            }
        } else {
            if (keyCode == 84) {
                if (down) {
                    if (repeatCount == 0) {
                        this.mSearchKeyShortcutPending = true;
                        this.mConsumeSearchKeyUp = false;
                    }
                } else {
                    this.mSearchKeyShortcutPending = false;
                    if (this.mConsumeSearchKeyUp) {
                        this.mConsumeSearchKeyUp = false;
                        return -1L;
                    }
                }
                return 0L;
            }
            if (keyCode == 187) {
                if (!keyguardOn) {
                    if (down && repeatCount == 0) {
                        this.preloadRecentApps();
                    } else if (!down) {
                        this.toggleRecentApps();
                    }
                }
                return -1L;
            }
            if (keyCode == 42 && event.isMetaPressed()) {
                IStatusBarService service;
                if (down && (service = this.getStatusBarService()) != null) {
                    try {
                        service.expandNotificationsPanel();
                    }
                    catch (RemoteException intent) {}
                }
            } else if (keyCode == 47 && event.isMetaPressed() && event.isCtrlPressed()) {
                if (down && repeatCount == 0) {
                    int type = event.isShiftPressed() ? 2 : 1;
                    this.mScreenshotRunnable.setScreenshotType(type);
                    this.mHandler.post(this.mScreenshotRunnable);
                    return -1L;
                }
            } else if (keyCode == 76 && event.isMetaPressed()) {
                if (down && repeatCount == 0 && !this.isKeyguardLocked()) {
                    this.toggleKeyboardShortcutsMenu(event.getDeviceId());
                }
            } else {
                if (keyCode == 219) {
                    Slog.wtf(TAG, "KEYCODE_ASSIST should be handled in interceptKeyBeforeQueueing");
                    return -1L;
                }
                if (keyCode == 231) {
                    Slog.wtf(TAG, "KEYCODE_VOICE_ASSIST should be handled in interceptKeyBeforeQueueing");
                    return -1L;
                }
                if (keyCode == 120) {
                    if (down && repeatCount == 0) {
                        this.mScreenshotRunnable.setScreenshotType(1);
                        this.mHandler.post(this.mScreenshotRunnable);
                    }
                    return -1L;
                }
                if (keyCode == 221 || keyCode == 220) {
                    if (down) {
                        int direction = keyCode == 221 ? 1 : -1;
                        int auto = Settings.System.getIntForUser(this.mContext.getContentResolver(), "screen_brightness_mode", 0, -3);
                        if (auto != 0) {
                            Settings.System.putIntForUser(this.mContext.getContentResolver(), "screen_brightness_mode", 0, -3);
                        }
                        int min = this.mPowerManager.getMinimumScreenBrightnessSetting();
                        int max = this.mPowerManager.getMaximumScreenBrightnessSetting();
                        int step = (max - min + 10 - 1) / 10 * direction;
                        int brightness = Settings.System.getIntForUser(this.mContext.getContentResolver(), "screen_brightness", this.mPowerManager.getDefaultScreenBrightnessSetting(), -3);
                        brightness += step;
                        brightness = Math.min(max, brightness);
                        brightness = Math.max(min, brightness);
                        Settings.System.putIntForUser(this.mContext.getContentResolver(), "screen_brightness", brightness, -3);
                        this.startActivityAsUser(new Intent("com.android.intent.action.SHOW_BRIGHTNESS_DIALOG"), UserHandle.CURRENT_OR_SELF);
                    }
                    return -1L;
                }
                if (keyCode == 24 || keyCode == 25 || keyCode == 164) {
                    InputDevice d;
                    if (this.mUseTvRouting || this.mHandleVolumeKeysInWM) {
                        this.dispatchDirectAudioEvent(event);
                        return -1L;
                    }
                    if (this.mDefaultDisplayPolicy.isPersistentVrModeEnabled() && (d = event.getDevice()) != null && !d.isExternal()) {
                        return -1L;
                    }
                } else {
                    if (keyCode == 61 && event.isMetaPressed()) {
                        return 0L;
                    }
                    if (this.mHasFeatureLeanback && this.interceptBugreportGestureTv(keyCode, down)) {
                        return -1L;
                    }
                    if (keyCode == 284) {
                        if (!down) {
                            this.mHandler.removeMessages(22);
                            Message msg = this.mHandler.obtainMessage(22);
                            msg.setAsynchronous(true);
                            msg.sendToTarget();
                        }
                        return -1L;
                    }
                }
            }
        }
        boolean actionTriggered = false;
        if (KeyEvent.isModifierKey(keyCode)) {
            if (!this.mPendingCapsLockToggle) {
                this.mInitialMetaState = this.mMetaState;
                this.mPendingCapsLockToggle = true;
            } else if (event.getAction() == 1) {
                int altOnMask = this.mMetaState & 0x32;
                int metaOnMask = this.mMetaState & 0x70000;
                if (metaOnMask != 0 && altOnMask != 0 && this.mInitialMetaState == (this.mMetaState ^ (altOnMask | metaOnMask))) {
                    this.mInputManagerInternal.toggleCapsLock(event.getDeviceId());
                    actionTriggered = true;
                }
                this.mPendingCapsLockToggle = false;
            }
        }
        this.mMetaState = metaState;
        if (actionTriggered) {
            return -1L;
        }
        if (KeyEvent.isMetaKey(keyCode)) {
            if (down) {
                this.mPendingMetaAction = true;
            } else if (this.mPendingMetaAction) {
                this.launchAssistAction("android.intent.extra.ASSIST_INPUT_HINT_KEYBOARD", event.getDeviceId());
            }
            return -1L;
        }
        if (this.mSearchKeyShortcutPending && (kcm = event.getKeyCharacterMap()).isPrintingKey(keyCode)) {
            this.mConsumeSearchKeyUp = true;
            this.mSearchKeyShortcutPending = false;
            if (down && repeatCount == 0 && !keyguardOn) {
                Intent shortcutIntent2 = this.mShortcutManager.getIntent(kcm, keyCode, metaState);
                if (shortcutIntent2 != null) {
                    shortcutIntent2.addFlags(0x10000000);
                    try {
                        this.startActivityAsUser(shortcutIntent2, UserHandle.CURRENT);
                        this.dismissKeyboardShortcutsMenu();
                    }
                    catch (ActivityNotFoundException ex) {
                        Slog.w(TAG, "Dropping shortcut key combination because the activity to which it is registered was not found: SEARCH+" + KeyEvent.keyCodeToString(keyCode), ex);
                    }
                } else {
                    Slog.i(TAG, "Dropping unregistered shortcut key combination: SEARCH+" + KeyEvent.keyCodeToString(keyCode));
                }
            }
            return -1L;
        }
        if (down && repeatCount == 0 && !keyguardOn && (metaState & 0x10000) != 0 && (kcm = event.getKeyCharacterMap()).isPrintingKey(keyCode) && (shortcutIntent = this.mShortcutManager.getIntent(kcm, keyCode, metaState & 0xFFF8FFFF)) != null) {
            shortcutIntent.addFlags(0x10000000);
            try {
                this.startActivityAsUser(shortcutIntent, UserHandle.CURRENT);
                this.dismissKeyboardShortcutsMenu();
            }
            catch (ActivityNotFoundException ex) {
                Slog.w(TAG, "Dropping shortcut key combination because the activity to which it is registered was not found: META+" + KeyEvent.keyCodeToString(keyCode), ex);
            }
            return -1L;
        }
        if (down && repeatCount == 0 && !keyguardOn && (category = sApplicationLaunchKeyCategories.get(keyCode)) != null) {
            Intent intent = Intent.makeMainSelectorActivity("android.intent.action.MAIN", category);
            intent.setFlags(0x10000000);
            try {
                this.startActivityAsUser(intent, UserHandle.CURRENT);
                this.dismissKeyboardShortcutsMenu();
            }
            catch (ActivityNotFoundException ex) {
                Slog.w(TAG, "Dropping application launch key because the activity to which it is registered was not found: keyCode=" + keyCode + ", category=" + category, ex);
            }
            return -1L;
        }
        if (down && repeatCount == 0 && keyCode == 61) {
            int shiftlessModifiers;
            if (this.mRecentAppsHeldModifiers == 0 && !keyguardOn && this.isUserSetupComplete() && KeyEvent.metaStateHasModifiers(shiftlessModifiers = event.getModifiers() & 0xFFFFFF3E, 2)) {
                this.mRecentAppsHeldModifiers = shiftlessModifiers;
                this.showRecentApps(true);
                return -1L;
            }
        } else if (!down && this.mRecentAppsHeldModifiers != 0 && (metaState & this.mRecentAppsHeldModifiers) == 0) {
            this.mRecentAppsHeldModifiers = 0;
            this.hideRecentApps(true, false);
        }
        boolean bl = isCtrlOrMetaSpace = keyCode == 62 && (metaState & 0x77000) != 0;
        if (down && repeatCount == 0 && (keyCode == 204 || isCtrlOrMetaSpace)) {
            int direction = (metaState & 0xC1) != 0 ? -1 : 1;
            this.mWindowManagerFuncs.switchKeyboardLayout(event.getDeviceId(), direction);
            return -1L;
        }
        if (this.mLanguageSwitchKeyPressed && !down && (keyCode == 204 || keyCode == 62)) {
            this.mLanguageSwitchKeyPressed = false;
            return -1L;
        }
        if (PhoneWindowManager.isValidGlobalKey(keyCode) && this.mGlobalKeyManager.handleGlobalKey(this.mContext, keyCode, event)) {
            return -1L;
        }
        if (down) {
            IShortcutService shortcutService;
            long shortcutCode = keyCode;
            if (event.isCtrlPressed()) {
                shortcutCode |= 0x100000000000L;
            }
            if (event.isAltPressed()) {
                shortcutCode |= 0x200000000L;
            }
            if (event.isShiftPressed()) {
                shortcutCode |= 0x100000000L;
            }
            if (event.isMetaPressed()) {
                shortcutCode |= 0x1000000000000L;
            }
            if ((shortcutService = this.mShortcutKeyServices.get(shortcutCode)) != null) {
                try {
                    if (this.isUserSetupComplete()) {
                        shortcutService.notifyShortcutKeyPressed(shortcutCode);
                    }
                }
                catch (RemoteException e) {
                    this.mShortcutKeyServices.delete(shortcutCode);
                }
                return -1L;
            }
        }
        if ((metaState & 0x10000) != 0) {
            return -1L;
        }
        return 0L;
    }

    private boolean interceptBugreportGestureTv(int keyCode, boolean down) {
        if (keyCode == 23) {
            this.mBugreportTvKey1Pressed = down;
        } else if (keyCode == 4) {
            this.mBugreportTvKey2Pressed = down;
        }
        if (this.mBugreportTvKey1Pressed && this.mBugreportTvKey2Pressed) {
            if (!this.mBugreportTvScheduled) {
                this.mBugreportTvScheduled = true;
                Message msg = Message.obtain(this.mHandler, 18);
                msg.setAsynchronous(true);
                this.mHandler.sendMessageDelayed(msg, 1000L);
            }
        } else if (this.mBugreportTvScheduled) {
            this.mHandler.removeMessages(18);
            this.mBugreportTvScheduled = false;
        }
        return this.mBugreportTvScheduled;
    }

    private boolean interceptAccessibilityGestureTv(int keyCode, boolean down) {
        if (keyCode == 4) {
            this.mAccessibilityTvKey1Pressed = down;
        } else if (keyCode == 20) {
            this.mAccessibilityTvKey2Pressed = down;
        }
        if (this.mAccessibilityTvKey1Pressed && this.mAccessibilityTvKey2Pressed) {
            if (!this.mAccessibilityTvScheduled) {
                this.mAccessibilityTvScheduled = true;
                Message msg = Message.obtain(this.mHandler, 19);
                msg.setAsynchronous(true);
                this.mHandler.sendMessageDelayed(msg, this.getAccessibilityShortcutTimeout());
            }
        } else if (this.mAccessibilityTvScheduled) {
            this.mHandler.removeMessages(19);
            this.mAccessibilityTvScheduled = false;
        }
        return this.mAccessibilityTvScheduled;
    }

    private void requestFullBugreport() {
        if ("1".equals(SystemProperties.get("ro.debuggable")) || Settings.Global.getInt(this.mContext.getContentResolver(), "development_settings_enabled", 0) == 1) {
            try {
                ActivityManager.getService().requestBugReport(0);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error taking bugreport", e);
            }
        }
    }

    @Override
    public KeyEvent dispatchUnhandledKey(WindowManagerPolicy.WindowState win, KeyEvent event, int policyFlags) {
        KeyEvent fallbackEvent = null;
        if ((event.getFlags() & 0x400) == 0) {
            KeyCharacterMap kcm = event.getKeyCharacterMap();
            int keyCode = event.getKeyCode();
            int metaState = event.getMetaState();
            boolean initialDown = event.getAction() == 0 && event.getRepeatCount() == 0;
            KeyCharacterMap.FallbackAction fallbackAction = initialDown ? kcm.getFallbackAction(keyCode, metaState) : this.mFallbackActions.get(keyCode);
            if (fallbackAction != null) {
                int flags = event.getFlags() | 0x400;
                fallbackEvent = KeyEvent.obtain(event.getDownTime(), event.getEventTime(), event.getAction(), fallbackAction.keyCode, event.getRepeatCount(), fallbackAction.metaState, event.getDeviceId(), event.getScanCode(), flags, event.getSource(), event.getDisplayId(), null);
                if (!this.interceptFallback(win, fallbackEvent, policyFlags)) {
                    fallbackEvent.recycle();
                    fallbackEvent = null;
                }
                if (initialDown) {
                    this.mFallbackActions.put(keyCode, fallbackAction);
                } else if (event.getAction() == 1) {
                    this.mFallbackActions.remove(keyCode);
                    fallbackAction.recycle();
                }
            }
        }
        return fallbackEvent;
    }

    private boolean interceptFallback(WindowManagerPolicy.WindowState win, KeyEvent fallbackEvent, int policyFlags) {
        long delayMillis;
        int actions = this.interceptKeyBeforeQueueing(fallbackEvent, policyFlags);
        return (actions & 1) != 0 && (delayMillis = this.interceptKeyBeforeDispatching(win, fallbackEvent, policyFlags)) == 0L;
    }

    @Override
    public void setTopFocusedDisplay(int displayId) {
        this.mTopFocusedDisplayId = displayId;
    }

    @Override
    public void registerDisplayFoldListener(IDisplayFoldListener listener) {
        if (this.mDisplayFoldController != null) {
            this.mDisplayFoldController.registerDisplayFoldListener(listener);
        }
    }

    @Override
    public void unregisterDisplayFoldListener(IDisplayFoldListener listener) {
        if (this.mDisplayFoldController != null) {
            this.mDisplayFoldController.unregisterDisplayFoldListener(listener);
        }
    }

    @Override
    public void setOverrideFoldedArea(Rect area) {
        if (this.mDisplayFoldController != null) {
            this.mDisplayFoldController.setOverrideFoldedArea(area);
        }
    }

    @Override
    public Rect getFoldedArea() {
        if (this.mDisplayFoldController != null) {
            return this.mDisplayFoldController.getFoldedArea();
        }
        return new Rect();
    }

    @Override
    public void onDefaultDisplayFocusChangedLw(WindowManagerPolicy.WindowState newFocus) {
        if (this.mDisplayFoldController != null) {
            this.mDisplayFoldController.onDefaultDisplayFocusChanged(newFocus != null ? newFocus.getOwningPackage() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerShortcutKey(long shortcutCode, IShortcutService shortcutService) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            IShortcutService service = this.mShortcutKeyServices.get(shortcutCode);
            if (service != null && service.asBinder().pingBinder()) {
                throw new RemoteException("Key already exists.");
            }
            this.mShortcutKeyServices.put(shortcutCode, shortcutService);
        }
    }

    @Override
    public void onKeyguardOccludedChangedLw(boolean occluded) {
        if (this.mKeyguardDelegate != null && this.mKeyguardDelegate.isShowing()) {
            this.mPendingKeyguardOccluded = occluded;
            this.mKeyguardOccludedChanged = true;
        } else {
            this.setKeyguardOccludedLw(occluded, false);
        }
    }

    private int handleStartTransitionForKeyguardLw(int transit, long duration) {
        if (this.mKeyguardOccludedChanged) {
            this.mKeyguardOccludedChanged = false;
            if (this.setKeyguardOccludedLw(this.mPendingKeyguardOccluded, false)) {
                return 5;
            }
        }
        if (AppTransition.isKeyguardGoingAwayTransit(transit)) {
            this.startKeyguardExitAnimation(SystemClock.uptimeMillis(), duration);
        }
        return 0;
    }

    private void launchAssistLongPressAction() {
        this.performHapticFeedback(0, false, "Assist - Long Press");
        this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_ASSIST);
        Intent intent = new Intent("android.intent.action.SEARCH_LONG_PRESS");
        intent.setFlags(0x10000000);
        try {
            SearchManager searchManager = this.getSearchManager();
            if (searchManager != null) {
                searchManager.stopSearch();
            }
            this.startActivityAsUser(intent, UserHandle.CURRENT);
        }
        catch (ActivityNotFoundException e) {
            Slog.w(TAG, "No activity to handle assist long press action.", e);
        }
    }

    private void launchAssistAction(String hint, int deviceId) {
        this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_ASSIST);
        if (!this.isUserSetupComplete()) {
            return;
        }
        Bundle args = null;
        if (deviceId > Integer.MIN_VALUE) {
            args = new Bundle();
            args.putInt("android.intent.extra.ASSIST_INPUT_DEVICE_ID", deviceId);
        }
        if ((this.mContext.getResources().getConfiguration().uiMode & 0xF) == 4) {
            ((SearchManager)this.mContext.getSystemService("search")).launchLegacyAssist(hint, UserHandle.myUserId(), args);
        } else {
            StatusBarManagerInternal statusbar;
            if (hint != null) {
                if (args == null) {
                    args = new Bundle();
                }
                args.putBoolean(hint, true);
            }
            if ((statusbar = this.getStatusBarManagerInternal()) != null) {
                statusbar.startAssist(args);
            }
        }
    }

    private void launchVoiceAssist(boolean allowDuringSetup) {
        boolean keyguardActive;
        boolean bl = keyguardActive = this.mKeyguardDelegate == null ? false : this.mKeyguardDelegate.isShowing();
        if (!keyguardActive) {
            Intent intent = new Intent("android.intent.action.VOICE_ASSIST");
            this.startActivityAsUser(intent, null, UserHandle.CURRENT_OR_SELF, allowDuringSetup);
        }
    }

    private void startActivityAsUser(Intent intent, UserHandle handle) {
        this.startActivityAsUser(intent, null, handle);
    }

    private void startActivityAsUser(Intent intent, Bundle bundle, UserHandle handle) {
        this.startActivityAsUser(intent, bundle, handle, false);
    }

    private void startActivityAsUser(Intent intent, Bundle bundle, UserHandle handle, boolean allowDuringSetup) {
        if (allowDuringSetup || this.isUserSetupComplete()) {
            this.mContext.startActivityAsUser(intent, bundle, handle);
        } else {
            Slog.i(TAG, "Not starting activity because user setup is in progress: " + intent);
        }
    }

    private SearchManager getSearchManager() {
        if (this.mSearchManager == null) {
            this.mSearchManager = (SearchManager)this.mContext.getSystemService("search");
        }
        return this.mSearchManager;
    }

    private void preloadRecentApps() {
        this.mPreloadedRecentApps = true;
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.preloadRecentApps();
        }
    }

    private void cancelPreloadRecentApps() {
        if (this.mPreloadedRecentApps) {
            this.mPreloadedRecentApps = false;
            StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
            if (statusbar != null) {
                statusbar.cancelPreloadRecentApps();
            }
        }
    }

    private void toggleRecentApps() {
        this.mPreloadedRecentApps = false;
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.toggleRecentApps();
        }
    }

    @Override
    public void showRecentApps() {
        this.mHandler.removeMessages(9);
        this.mHandler.obtainMessage(9).sendToTarget();
    }

    private void showRecentApps(boolean triggeredFromAltTab) {
        this.mPreloadedRecentApps = false;
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.showRecentApps(triggeredFromAltTab);
        }
    }

    private void toggleKeyboardShortcutsMenu(int deviceId) {
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.toggleKeyboardShortcutsMenu(deviceId);
        }
    }

    private void dismissKeyboardShortcutsMenu() {
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.dismissKeyboardShortcutsMenu();
        }
    }

    private void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHome) {
        this.mPreloadedRecentApps = false;
        StatusBarManagerInternal statusbar = this.getStatusBarManagerInternal();
        if (statusbar != null) {
            statusbar.hideRecentApps(triggeredFromAltTab, triggeredFromHome);
        }
    }

    void launchHomeFromHotKey(int displayId) {
        this.launchHomeFromHotKey(displayId, true, true);
    }

    void launchHomeFromHotKey(final int displayId, final boolean awakenFromDreams, boolean respectKeyguard) {
        if (respectKeyguard) {
            if (this.isKeyguardShowingAndNotOccluded()) {
                return;
            }
            if (!this.mKeyguardOccluded && this.mKeyguardDelegate.isInputRestricted()) {
                this.mKeyguardDelegate.verifyUnlock(new WindowManagerPolicy.OnKeyguardExitResult(){

                    @Override
                    public void onKeyguardExitResult(boolean success) {
                        if (success) {
                            PhoneWindowManager.this.startDockOrHome(displayId, true, awakenFromDreams);
                        }
                    }
                });
                return;
            }
        }
        if (this.mRecentsVisible) {
            try {
                ActivityManager.getService().stopAppSwitches();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (awakenFromDreams) {
                PhoneWindowManager.awakenDreams();
            }
            this.hideRecentApps(false, true);
        } else {
            this.startDockOrHome(displayId, true, awakenFromDreams);
        }
    }

    @Override
    public void setRecentsVisibilityLw(boolean visible) {
        this.mRecentsVisible = visible;
    }

    @Override
    public void setPipVisibilityLw(boolean visible) {
        this.mPictureInPictureVisible = visible;
    }

    @Override
    public void setNavBarVirtualKeyHapticFeedbackEnabledLw(boolean enabled) {
        this.mNavBarVirtualKeyHapticFeedbackEnabled = enabled;
    }

    @Override
    public void applyKeyguardPolicyLw(WindowManagerPolicy.WindowState win, WindowManagerPolicy.WindowState imeTarget) {
        if (this.canBeHiddenByKeyguardLw(win)) {
            if (this.shouldBeHiddenByKeyguard(win, imeTarget)) {
                win.hideLw(false);
            } else {
                win.showLw(false);
            }
        }
    }

    @Override
    public void setKeyguardCandidateLw(WindowManagerPolicy.WindowState win) {
        this.mKeyguardCandidate = win;
        this.setKeyguardOccludedLw(this.mKeyguardOccluded, true);
    }

    private boolean setKeyguardOccludedLw(boolean isOccluded, boolean force) {
        boolean changed;
        boolean wasOccluded = this.mKeyguardOccluded;
        boolean showing = this.mKeyguardDelegate.isShowing();
        boolean bl = changed = wasOccluded != isOccluded || force;
        if (!isOccluded && changed && showing) {
            this.mKeyguardOccluded = false;
            this.mKeyguardDelegate.setOccluded(false, true);
            if (this.mKeyguardCandidate != null) {
                this.mKeyguardCandidate.getAttrs().privateFlags |= 0x400;
                if (!this.mKeyguardDelegate.hasLockscreenWallpaper()) {
                    this.mKeyguardCandidate.getAttrs().flags |= 0x100000;
                }
            }
            return true;
        }
        if (isOccluded && changed && showing) {
            this.mKeyguardOccluded = true;
            this.mKeyguardDelegate.setOccluded(true, false);
            if (this.mKeyguardCandidate != null) {
                this.mKeyguardCandidate.getAttrs().privateFlags &= 0xFFFFFBFF;
                this.mKeyguardCandidate.getAttrs().flags &= 0xFFEFFFFF;
            }
            return true;
        }
        if (changed) {
            this.mKeyguardOccluded = isOccluded;
            this.mKeyguardDelegate.setOccluded(isOccluded, false);
            return false;
        }
        return false;
    }

    @Override
    public void notifyLidSwitchChanged(long whenNanos, boolean lidOpen) {
        int newLidState;
        int n = newLidState = lidOpen ? 1 : 0;
        if (newLidState == this.mDefaultDisplayPolicy.getLidState()) {
            return;
        }
        this.mDefaultDisplayPolicy.setLidState(newLidState);
        this.applyLidSwitchState();
        this.updateRotation(true);
        if (lidOpen) {
            this.wakeUp(SystemClock.uptimeMillis(), this.mAllowTheaterModeWakeFromLidSwitch, 9, "android.policy:LID");
        } else if (this.getLidBehavior() != 1) {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
        }
    }

    @Override
    public void notifyCameraLensCoverSwitchChanged(long whenNanos, boolean lensCovered) {
        int lensCoverState;
        int n = lensCoverState = lensCovered ? 1 : 0;
        if (this.mCameraLensCoverState == lensCoverState) {
            return;
        }
        if (this.mCameraLensCoverState == 1 && lensCoverState == 0) {
            boolean keyguardActive = this.mKeyguardDelegate == null ? false : this.mKeyguardDelegate.isShowing();
            Intent intent = keyguardActive ? new Intent("android.media.action.STILL_IMAGE_CAMERA_SECURE") : new Intent("android.media.action.STILL_IMAGE_CAMERA");
            this.wakeUp(whenNanos / 1000000L, this.mAllowTheaterModeWakeFromCameraLens, 5, "android.policy:CAMERA_COVER");
            this.startActivityAsUser(intent, UserHandle.CURRENT_OR_SELF);
        }
        this.mCameraLensCoverState = lensCoverState;
    }

    void initializeHdmiState() {
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        try {
            this.initializeHdmiStateInternal();
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void initializeHdmiStateInternal() {
        plugged = false;
        if (new File("/sys/devices/virtual/switch/hdmi/state").exists()) {
            this.mHDMIObserver.startObserving("DEVPATH=/devices/virtual/switch/hdmi");
            filename = "/sys/class/switch/hdmi/state";
            reader = null;
            try {
                reader = new FileReader("/sys/class/switch/hdmi/state");
                buf = new char[15];
                n = reader.read(buf);
                if (n <= 1) ** GOTO lbl32
                plugged = 0 != Integer.parseInt(new String(buf, 0, n - 1));
            }
            catch (IOException ex) {
                Slog.w("WindowManager", "Couldn't read hdmi state from /sys/class/switch/hdmi/state: " + ex);
            }
            catch (NumberFormatException ex) {
                Slog.w("WindowManager", "Couldn't read hdmi state from /sys/class/switch/hdmi/state: " + ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        } else if (ExtconUEventObserver.extconExists() && ExtconUEventObserver.namedExtconDirExists("hdmi")) {
            observer = new HdmiVideoExtconUEventObserver();
            plugged = HdmiVideoExtconUEventObserver.access$3800(observer);
            this.mHDMIObserver = observer;
        }
lbl32:
        // 7 sources

        this.mDefaultDisplayPolicy.setHdmiPlugged(plugged, true);
    }

    @Override
    public int interceptKeyBeforeQueueing(KeyEvent event, int policyFlags) {
        int result;
        boolean isWakeKey;
        boolean isInjected;
        if (!this.mSystemBooted) {
            return 0;
        }
        boolean interactive = (policyFlags & 0x20000000) != 0;
        boolean down = event.getAction() == 0;
        boolean canceled = event.isCanceled();
        int keyCode = event.getKeyCode();
        int displayId = event.getDisplayId();
        boolean bl = isInjected = (policyFlags & 0x1000000) != 0;
        boolean keyguardActive = this.mKeyguardDelegate == null ? false : (interactive ? this.isKeyguardShowingAndNotOccluded() : this.mKeyguardDelegate.isShowing());
        boolean bl2 = isWakeKey = (policyFlags & 1) != 0 || event.isWakeKey();
        if (interactive || isInjected && !isWakeKey) {
            result = 1;
            isWakeKey = false;
            if (interactive) {
                if (keyCode == this.mPendingWakeKey && !down) {
                    result = 0;
                }
                this.mPendingWakeKey = -1;
            }
        } else if (!interactive && this.shouldDispatchInputWhenNonInteractive(displayId, keyCode)) {
            result = 1;
            this.mPendingWakeKey = -1;
        } else {
            result = 0;
            if (!(!isWakeKey || down && this.isWakeKeyWhenScreenOff(keyCode))) {
                isWakeKey = false;
            }
            if (isWakeKey && down) {
                this.mPendingWakeKey = keyCode;
            }
        }
        if (PhoneWindowManager.isValidGlobalKey(keyCode) && this.mGlobalKeyManager.shouldHandleGlobalKey(keyCode, event)) {
            if (isWakeKey) {
                this.wakeUp(event.getEventTime(), this.mAllowTheaterModeWakeFromKey, 6, "android.policy:KEY");
            }
            return result;
        }
        boolean isNavBarVirtKey = (event.getFlags() & 0x40) != 0;
        boolean useHapticFeedback = down && (policyFlags & 2) != 0 && (!isNavBarVirtKey || this.mNavBarVirtualKeyHapticFeedbackEnabled) && event.getRepeatCount() == 0;
        switch (keyCode) {
            case 4: {
                if (down) {
                    this.interceptBackKeyDown();
                    break;
                }
                boolean handled = this.interceptBackKeyUp(event);
                if (!handled) break;
                result &= 0xFFFFFFFE;
                break;
            }
            case 24: 
            case 25: 
            case 164: {
                if (keyCode == 25) {
                    if (down) {
                        this.cancelPendingRingerToggleChordAction();
                        if (interactive && !this.mScreenshotChordVolumeDownKeyTriggered && (event.getFlags() & 0x400) == 0) {
                            this.mScreenshotChordVolumeDownKeyTriggered = true;
                            this.mScreenshotChordVolumeDownKeyTime = event.getDownTime();
                            this.mScreenshotChordVolumeDownKeyConsumed = false;
                            this.cancelPendingPowerKeyAction();
                            this.interceptScreenshotChord();
                            this.interceptAccessibilityShortcutChord();
                        }
                    } else {
                        this.mScreenshotChordVolumeDownKeyTriggered = false;
                        this.cancelPendingScreenshotChordAction();
                        this.cancelPendingAccessibilityShortcutAction();
                    }
                } else if (keyCode == 24) {
                    if (down) {
                        if (interactive && !this.mA11yShortcutChordVolumeUpKeyTriggered && (event.getFlags() & 0x400) == 0) {
                            this.mA11yShortcutChordVolumeUpKeyTriggered = true;
                            this.mA11yShortcutChordVolumeUpKeyTime = event.getDownTime();
                            this.mA11yShortcutChordVolumeUpKeyConsumed = false;
                            this.cancelPendingPowerKeyAction();
                            this.cancelPendingScreenshotChordAction();
                            this.cancelPendingRingerToggleChordAction();
                            this.interceptAccessibilityShortcutChord();
                            this.interceptRingerToggleChord();
                        }
                    } else {
                        this.mA11yShortcutChordVolumeUpKeyTriggered = false;
                        this.cancelPendingScreenshotChordAction();
                        this.cancelPendingAccessibilityShortcutAction();
                        this.cancelPendingRingerToggleChordAction();
                    }
                }
                if (down) {
                    boolean isInCall;
                    this.sendSystemKeyToStatusBarAsync(event.getKeyCode());
                    TelecomManager telecomManager = this.getTelecommService();
                    if (telecomManager != null && !this.mHandleVolumeKeysInWM && telecomManager.isRinging()) {
                        Log.i(TAG, "interceptKeyBeforeQueueing: VOLUME key-down while ringing: Silence ringer!");
                        telecomManager.silenceRinger();
                        result &= 0xFFFFFFFE;
                        break;
                    }
                    int audioMode = 0;
                    try {
                        audioMode = PhoneWindowManager.getAudioService().getMode();
                    }
                    catch (Exception e) {
                        Log.e(TAG, "Error getting AudioService in interceptKeyBeforeQueueing.", e);
                    }
                    boolean bl3 = isInCall = telecomManager != null && telecomManager.isInCall() || audioMode == 3;
                    if (isInCall && (result & 1) == 0) {
                        MediaSessionLegacyHelper.getHelper(this.mContext).sendVolumeKeyEvent(event, Integer.MIN_VALUE, false);
                        break;
                    }
                }
                if (this.mUseTvRouting || this.mHandleVolumeKeysInWM) {
                    result |= 1;
                    break;
                }
                if ((result & 1) != 0) break;
                MediaSessionLegacyHelper.getHelper(this.mContext).sendVolumeKeyEvent(event, Integer.MIN_VALUE, true);
                break;
            }
            case 6: {
                result &= 0xFFFFFFFE;
                if (down) {
                    TelecomManager telecomManager = this.getTelecommService();
                    boolean hungUp = false;
                    if (telecomManager != null) {
                        hungUp = telecomManager.endCall();
                    }
                    if (interactive && !hungUp) {
                        this.mEndCallKeyHandled = false;
                        this.mHandler.postDelayed(this.mEndCallLongPress, ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
                        break;
                    }
                    this.mEndCallKeyHandled = true;
                    break;
                }
                if (this.mEndCallKeyHandled) break;
                this.mHandler.removeCallbacks(this.mEndCallLongPress);
                if (canceled || (this.mEndcallBehavior & 1) != 0 && this.goHome() || (this.mEndcallBehavior & 2) == 0) break;
                this.goToSleep(event.getEventTime(), 4, 0);
                isWakeKey = false;
                break;
            }
            case 26: {
                EventLogTags.writeInterceptPower(KeyEvent.actionToString(event.getAction()), this.mPowerKeyHandled ? 1 : 0, this.mPowerKeyPressCounter);
                this.cancelPendingAccessibilityShortcutAction();
                result &= 0xFFFFFFFE;
                isWakeKey = false;
                if (down) {
                    this.interceptPowerKeyDown(event, interactive);
                    break;
                }
                this.interceptPowerKeyUp(event, interactive, canceled);
                break;
            }
            case 280: 
            case 281: 
            case 282: 
            case 283: {
                result &= 0xFFFFFFFE;
                this.interceptSystemNavigationKey(event);
                break;
            }
            case 223: {
                result &= 0xFFFFFFFE;
                isWakeKey = false;
                if (!this.mPowerManager.isInteractive()) {
                    useHapticFeedback = false;
                }
                if (down) {
                    this.sleepPress();
                    break;
                }
                this.sleepRelease(event.getEventTime());
                break;
            }
            case 276: {
                result &= 0xFFFFFFFE;
                isWakeKey = false;
                if (down) break;
                this.mPowerManagerInternal.setUserInactiveOverrideFromWindowManager();
                break;
            }
            case 224: {
                result &= 0xFFFFFFFE;
                isWakeKey = true;
                break;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: 
            case 222: {
                if (MediaSessionLegacyHelper.getHelper(this.mContext).isGlobalPriorityActive()) {
                    result &= 0xFFFFFFFE;
                }
                if ((result & 1) != 0) break;
                this.mBroadcastWakeLock.acquire();
                Message msg = this.mHandler.obtainMessage(3, new KeyEvent(event));
                msg.setAsynchronous(true);
                msg.sendToTarget();
                break;
            }
            case 5: {
                TelecomManager telecomManager;
                if (!down || (telecomManager = this.getTelecommService()) == null || !telecomManager.isRinging()) break;
                Log.i(TAG, "interceptKeyBeforeQueueing: CALL key-down while ringing: Answer the call!");
                telecomManager.acceptRingingCall();
                result &= 0xFFFFFFFE;
                break;
            }
            case 219: {
                Message msg;
                boolean longPressed;
                boolean bl4 = longPressed = event.getRepeatCount() > 0;
                if (down && longPressed) {
                    msg = this.mHandler.obtainMessage(24);
                    msg.setAsynchronous(true);
                    msg.sendToTarget();
                }
                if (!down && !longPressed) {
                    msg = this.mHandler.obtainMessage(23, event.getDeviceId(), 0, null);
                    msg.setAsynchronous(true);
                    msg.sendToTarget();
                }
                result &= 0xFFFFFFFE;
                break;
            }
            case 231: {
                if (!down) {
                    this.mBroadcastWakeLock.acquire();
                    Message msg = this.mHandler.obtainMessage(12);
                    msg.setAsynchronous(true);
                    msg.sendToTarget();
                }
                result &= 0xFFFFFFFE;
                break;
            }
            case 171: {
                if (this.mShortPressOnWindowBehavior != 1 || !this.mPictureInPictureVisible) break;
                if (!down) {
                    this.showPictureInPictureMenu(event);
                }
                result &= 0xFFFFFFFE;
            }
        }
        if (this.mHasFeatureLeanback) {
            switch (keyCode) {
                case 4: 
                case 20: {
                    boolean handled = this.interceptAccessibilityGestureTv(keyCode, down);
                    if (!handled) break;
                    result &= 0xFFFFFFFE;
                    break;
                }
            }
        }
        if (this.mAccessibilityShortcutController.isAccessibilityShortcutAvailable(this.isKeyguardLocked())) {
            switch (keyCode) {
                case 54: {
                    if (!down || !event.isCtrlPressed() || !event.isAltPressed()) break;
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(17));
                    result &= 0xFFFFFFFE;
                }
            }
        }
        if (useHapticFeedback) {
            this.performHapticFeedback(1, false, "Virtual Key - Press");
        }
        if (isWakeKey) {
            this.wakeUp(event.getEventTime(), this.mAllowTheaterModeWakeFromKey, 6, "android.policy:KEY");
        }
        return result;
    }

    private void interceptSystemNavigationKey(KeyEvent event) {
        if (!(event.getAction() != 1 || this.mAccessibilityManager.isEnabled() && this.mAccessibilityManager.sendFingerprintGesture(event.getKeyCode()) || !this.mSystemNavigationKeysEnabled)) {
            this.sendSystemKeyToStatusBarAsync(event.getKeyCode());
        }
    }

    private void sendSystemKeyToStatusBar(int keyCode) {
        IStatusBarService statusBar = this.getStatusBarService();
        if (statusBar != null) {
            try {
                statusBar.handleSystemKey(keyCode);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void sendSystemKeyToStatusBarAsync(int keyCode) {
        Message message = this.mHandler.obtainMessage(21, keyCode, 0);
        message.setAsynchronous(true);
        this.mHandler.sendMessage(message);
    }

    private static boolean isValidGlobalKey(int keyCode) {
        switch (keyCode) {
            case 26: 
            case 223: 
            case 224: {
                return false;
            }
        }
        return true;
    }

    private boolean isWakeKeyWhenScreenOff(int keyCode) {
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                return this.mDefaultDisplayPolicy.getDockMode() != 0;
            }
            case 27: 
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: 
            case 222: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int interceptMotionBeforeQueueingNonInteractive(int displayId, long whenNanos, int policyFlags) {
        if ((policyFlags & 1) != 0 && this.wakeUp(whenNanos / 1000000L, this.mAllowTheaterModeWakeFromMotion, 7, "android.policy:MOTION")) {
            return 0;
        }
        if (this.shouldDispatchInputWhenNonInteractive(displayId, 0)) {
            return 1;
        }
        if (this.isTheaterModeEnabled() && (policyFlags & 1) != 0) {
            this.wakeUp(whenNanos / 1000000L, this.mAllowTheaterModeWakeFromMotionWhenNotDreaming, 7, "android.policy:MOTION");
        }
        return 0;
    }

    private boolean shouldDispatchInputWhenNonInteractive(int displayId, int keyCode) {
        boolean displayOff;
        boolean isDefaultDisplay = displayId == 0 || displayId == -1;
        Display display = isDefaultDisplay ? this.mDefaultDisplay : this.mDisplayManager.getDisplay(displayId);
        boolean bl = displayOff = display == null || display.getState() == 1;
        if (displayOff && !this.mHasFeatureWatch) {
            return false;
        }
        if (this.isKeyguardShowingAndNotOccluded() && !displayOff) {
            return true;
        }
        if (this.mHasFeatureWatch && (keyCode == 4 || keyCode == 264)) {
            return false;
        }
        if (isDefaultDisplay) {
            IDreamManager dreamManager = PhoneWindowManager.getDreamManager();
            try {
                if (dreamManager != null && dreamManager.isDreaming()) {
                    return true;
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "RemoteException when checking if dreaming", e);
            }
        }
        return false;
    }

    private void dispatchDirectAudioEvent(KeyEvent event) {
        HdmiAudioSystemClient audioSystemClient;
        HdmiControlManager hdmiControlManager = this.getHdmiControlManager();
        if (null != hdmiControlManager && !hdmiControlManager.getSystemAudioMode() && this.shouldCecAudioDeviceForwardVolumeKeysSystemAudioModeOff() && (audioSystemClient = hdmiControlManager.getAudioSystemClient()) != null) {
            audioSystemClient.sendKeyEvent(event.getKeyCode(), event.getAction() == 0);
            return;
        }
        if (event.getAction() != 0) {
            return;
        }
        int keyCode = event.getKeyCode();
        int flags = 4101;
        String pkgName = this.mContext.getOpPackageName();
        switch (keyCode) {
            case 24: {
                try {
                    PhoneWindowManager.getAudioService().adjustSuggestedStreamVolume(1, Integer.MIN_VALUE, flags, pkgName, TAG);
                }
                catch (Exception e) {
                    Log.e(TAG, "Error dispatching volume up in dispatchTvAudioEvent.", e);
                }
                break;
            }
            case 25: {
                try {
                    PhoneWindowManager.getAudioService().adjustSuggestedStreamVolume(-1, Integer.MIN_VALUE, flags, pkgName, TAG);
                }
                catch (Exception e) {
                    Log.e(TAG, "Error dispatching volume down in dispatchTvAudioEvent.", e);
                }
                break;
            }
            case 164: {
                try {
                    if (event.getRepeatCount() != 0) break;
                    PhoneWindowManager.getAudioService().adjustSuggestedStreamVolume(101, Integer.MIN_VALUE, flags, pkgName, TAG);
                    break;
                }
                catch (Exception e) {
                    Log.e(TAG, "Error dispatching mute in dispatchTvAudioEvent.", e);
                }
            }
        }
    }

    private HdmiControlManager getHdmiControlManager() {
        if (!this.mHasFeatureHdmiCec) {
            return null;
        }
        return this.mContext.getSystemService(HdmiControlManager.class);
    }

    private boolean shouldCecAudioDeviceForwardVolumeKeysSystemAudioModeOff() {
        return RoSystemProperties.CEC_AUDIO_DEVICE_FORWARD_VOLUME_KEYS_SYSTEM_AUDIO_MODE_OFF;
    }

    void dispatchMediaKeyWithWakeLock(KeyEvent event) {
        if (this.mHavePendingMediaKeyRepeatWithWakeLock) {
            this.mHandler.removeMessages(4);
            this.mHavePendingMediaKeyRepeatWithWakeLock = false;
            this.mBroadcastWakeLock.release();
        }
        this.dispatchMediaKeyWithWakeLockToAudioService(event);
        if (event.getAction() == 0 && event.getRepeatCount() == 0) {
            this.mHavePendingMediaKeyRepeatWithWakeLock = true;
            Message msg = this.mHandler.obtainMessage(4, event);
            msg.setAsynchronous(true);
            this.mHandler.sendMessageDelayed(msg, ViewConfiguration.getKeyRepeatTimeout());
        } else {
            this.mBroadcastWakeLock.release();
        }
    }

    void dispatchMediaKeyRepeatWithWakeLock(KeyEvent event) {
        this.mHavePendingMediaKeyRepeatWithWakeLock = false;
        KeyEvent repeatEvent = KeyEvent.changeTimeRepeat(event, SystemClock.uptimeMillis(), 1, event.getFlags() | 0x80);
        this.dispatchMediaKeyWithWakeLockToAudioService(repeatEvent);
        this.mBroadcastWakeLock.release();
    }

    void dispatchMediaKeyWithWakeLockToAudioService(KeyEvent event) {
        if (this.mActivityManagerInternal.isSystemReady()) {
            MediaSessionLegacyHelper.getHelper(this.mContext).sendMediaButtonEvent(event, true);
        }
    }

    void launchVoiceAssistWithWakeLock() {
        Intent voiceIntent;
        this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_ASSIST);
        if (!this.keyguardOn()) {
            voiceIntent = new Intent("android.speech.action.WEB_SEARCH");
        } else {
            IDeviceIdleController dic = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
            if (dic != null) {
                try {
                    dic.exitIdle("voice-search");
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
            voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", true);
        }
        this.startActivityAsUser(voiceIntent, UserHandle.CURRENT_OR_SELF);
        this.mBroadcastWakeLock.release();
    }

    @Override
    public void startedGoingToSleep(int why) {
        this.mGoingToSleep = true;
        this.mRequestedOrGoingToSleep = true;
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.onStartedGoingToSleep(why);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishedGoingToSleep(int why) {
        EventLogTags.writeScreenToggled(0);
        MetricsLogger.histogram(this.mContext, "screen_timeout", this.mLockScreenTimeout / 1000);
        this.mGoingToSleep = false;
        this.mRequestedOrGoingToSleep = false;
        this.mDefaultDisplayPolicy.setAwake(false);
        Object object = this.mLock;
        synchronized (object) {
            this.updateWakeGestureListenerLp();
            this.updateLockScreenTimeout();
        }
        this.mDefaultDisplayRotation.updateOrientationListener();
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.onFinishedGoingToSleep(why, this.mCameraGestureTriggeredDuringGoingToSleep);
        }
        if (this.mDisplayFoldController != null) {
            this.mDisplayFoldController.finishedGoingToSleep();
        }
        this.mCameraGestureTriggeredDuringGoingToSleep = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startedWakingUp(int why) {
        EventLogTags.writeScreenToggled(1);
        this.mDefaultDisplayPolicy.setAwake(true);
        Object object = this.mLock;
        synchronized (object) {
            this.updateWakeGestureListenerLp();
            this.updateLockScreenTimeout();
        }
        this.mDefaultDisplayRotation.updateOrientationListener();
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.onStartedWakingUp();
        }
    }

    @Override
    public void finishedWakingUp(int why) {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.onFinishedWakingUp();
        }
        if (this.mDisplayFoldController != null) {
            this.mDisplayFoldController.finishedWakingUp();
        }
    }

    private void wakeUpFromPowerKey(long eventTime) {
        this.wakeUp(eventTime, this.mAllowTheaterModeWakeFromPowerKey, 1, "android.policy:POWER");
    }

    private boolean wakeUp(long wakeTime, boolean wakeInTheaterMode, int reason, String details) {
        boolean theaterModeEnabled = this.isTheaterModeEnabled();
        if (!wakeInTheaterMode && theaterModeEnabled) {
            return false;
        }
        if (theaterModeEnabled) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "theater_mode_on", 0);
        }
        this.mPowerManager.wakeUp(wakeTime, reason, details);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishKeyguardDrawn() {
        if (!this.mDefaultDisplayPolicy.finishKeyguardDrawn()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mKeyguardDelegate != null) {
                this.mHandler.removeMessages(6);
            }
        }
        this.mWindowManagerInternal.waitForAllWindowsDrawn(this.mWindowManagerDrawCallback, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void screenTurnedOff() {
        this.updateScreenOffSleepToken(true);
        this.mDefaultDisplayPolicy.screenTurnedOff();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mKeyguardDelegate != null) {
                this.mKeyguardDelegate.onScreenTurnedOff();
            }
        }
        this.mDefaultDisplayRotation.updateOrientationListener();
        this.reportScreenStateToVrManager(false);
    }

    private long getKeyguardDrawnTimeout() {
        boolean bootCompleted = LocalServices.getService(SystemServiceManager.class).isBootCompleted();
        return bootCompleted ? 1000L : 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void screenTurningOn(WindowManagerPolicy.ScreenOnListener screenOnListener) {
        this.updateScreenOffSleepToken(false);
        this.mDefaultDisplayPolicy.screenTurnedOn(screenOnListener);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mKeyguardDelegate != null && this.mKeyguardDelegate.hasKeyguard()) {
                this.mHandler.removeMessages(6);
                this.mHandler.sendEmptyMessageDelayed(6, this.getKeyguardDrawnTimeout());
                this.mKeyguardDelegate.onScreenTurningOn(this.mKeyguardDrawnCallback);
            } else {
                this.mHandler.sendEmptyMessage(5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void screenTurnedOn() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mKeyguardDelegate != null) {
                this.mKeyguardDelegate.onScreenTurnedOn();
            }
        }
        this.reportScreenStateToVrManager(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void screenTurningOff(WindowManagerPolicy.ScreenOffListener screenOffListener) {
        this.mWindowManagerFuncs.screenTurningOff(screenOffListener);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mKeyguardDelegate != null) {
                this.mKeyguardDelegate.onScreenTurningOff();
            }
        }
    }

    private void reportScreenStateToVrManager(boolean isScreenOn) {
        if (this.mVrManagerInternal == null) {
            return;
        }
        this.mVrManagerInternal.onScreenStateChanged(isScreenOn);
    }

    private void finishWindowsDrawn() {
        if (!this.mDefaultDisplayPolicy.finishWindowsDrawn()) {
            return;
        }
        this.finishScreenTurningOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishScreenTurningOn() {
        boolean enableScreen;
        this.mDefaultDisplayRotation.updateOrientationListener();
        WindowManagerPolicy.ScreenOnListener listener = this.mDefaultDisplayPolicy.getScreenOnListener();
        if (!this.mDefaultDisplayPolicy.finishScreenTurningOn()) {
            return;
        }
        boolean awake = this.mDefaultDisplayPolicy.isAwake();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mKeyguardDrawnOnce && awake) {
                this.mKeyguardDrawnOnce = true;
                enableScreen = true;
                if (this.mBootMessageNeedsHiding) {
                    this.mBootMessageNeedsHiding = false;
                    this.hideBootMessages();
                }
            } else {
                enableScreen = false;
            }
        }
        if (listener != null) {
            listener.onScreenOn();
        }
        if (enableScreen) {
            try {
                this.mWindowManager.enableScreenIfNeeded();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHideBootMessage() {
        block5: {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mKeyguardDrawnOnce) {
                    this.mBootMessageNeedsHiding = true;
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                if (this.mBootMsgDialog == null) break block5;
            }
            this.mBootMsgDialog.dismiss();
            this.mBootMsgDialog = null;
        }
    }

    @Override
    public boolean isScreenOn() {
        return this.mDefaultDisplayPolicy.isScreenOnEarly();
    }

    @Override
    public boolean okToAnimate() {
        return this.mDefaultDisplayPolicy.isAwake() && !this.mGoingToSleep;
    }

    @Override
    public void enableKeyguard(boolean enabled) {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.setKeyguardEnabled(enabled);
        }
    }

    @Override
    public void exitKeyguardSecurely(WindowManagerPolicy.OnKeyguardExitResult callback) {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.verifyUnlock(callback);
        }
    }

    @Override
    public boolean isKeyguardShowingAndNotOccluded() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isShowing() && !this.mKeyguardOccluded;
    }

    @Override
    public boolean isKeyguardTrustedLw() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isTrusted();
    }

    @Override
    public boolean isKeyguardLocked() {
        return this.keyguardOn();
    }

    @Override
    public boolean isKeyguardSecure(int userId) {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isSecure(userId);
    }

    @Override
    public boolean isKeyguardOccluded() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardOccluded;
    }

    @Override
    public boolean inKeyguardRestrictedKeyInputMode() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isInputRestricted();
    }

    @Override
    public void dismissKeyguardLw(IKeyguardDismissCallback callback, CharSequence message) {
        if (this.mKeyguardDelegate != null && this.mKeyguardDelegate.isShowing()) {
            this.mKeyguardDelegate.dismiss(callback, message);
        } else if (callback != null) {
            try {
                callback.onDismissError();
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to call callback", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeyguardDrawnLw() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mKeyguardDrawnOnce;
        }
    }

    @Override
    public void startKeyguardExitAnimation(long startTime, long fadeoutDuration) {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.startKeyguardExitAnimation(startTime, fadeoutDuration);
        }
    }

    void sendCloseSystemWindows() {
        PhoneWindow.sendCloseSystemWindows(this.mContext, null);
    }

    void sendCloseSystemWindows(String reason) {
        PhoneWindow.sendCloseSystemWindows(this.mContext, reason);
    }

    @Override
    public void setSafeMode(boolean safeMode) {
        this.mSafeMode = safeMode;
        if (safeMode) {
            this.performHapticFeedback(10001, true, "Safe Mode Enabled");
        }
    }

    static long[] getLongIntArray(Resources r, int resid) {
        return ArrayUtils.convertToLongArray(r.getIntArray(resid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindKeyguard() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mKeyguardBound) {
                return;
            }
            this.mKeyguardBound = true;
        }
        this.mKeyguardDelegate.bindService(this.mContext);
    }

    @Override
    public void onSystemUiStarted() {
        this.bindKeyguard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemReady() {
        this.mKeyguardDelegate.onSystemReady();
        this.mVrManagerInternal = LocalServices.getService(VrManagerInternal.class);
        if (this.mVrManagerInternal != null) {
            this.mVrManagerInternal.addPersistentVrModeStateListener(this.mPersistentVrModeListener);
        }
        this.readCameraLensCoverState();
        this.updateUiMode();
        this.mDefaultDisplayRotation.updateOrientationListener();
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemReady = true;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PhoneWindowManager.this.updateSettings();
                }
            });
            if (this.mSystemBooted) {
                this.mKeyguardDelegate.onBootCompleted();
            }
        }
        this.mAutofillManagerInternal = LocalServices.getService(AutofillManagerInternal.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemBooted() {
        this.bindKeyguard();
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemBooted = true;
            if (this.mSystemReady) {
                this.mKeyguardDelegate.onBootCompleted();
            }
        }
        this.startedWakingUp(3);
        this.finishedWakingUp(3);
        this.screenTurningOn(null);
        this.screenTurnedOn();
    }

    @Override
    public boolean canDismissBootAnimation() {
        return this.mDefaultDisplayPolicy.isKeyguardDrawComplete();
    }

    @Override
    public void showBootMessage(final CharSequence msg, boolean always) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (PhoneWindowManager.this.mBootMsgDialog == null) {
                    int theme = PhoneWindowManager.this.mContext.getPackageManager().hasSystemFeature("android.software.leanback") ? 16974873 : 0;
                    PhoneWindowManager.this.mBootMsgDialog = new ProgressDialog(PhoneWindowManager.this.mContext, theme){

                        @Override
                        public boolean dispatchKeyEvent(KeyEvent event) {
                            return true;
                        }

                        @Override
                        public boolean dispatchKeyShortcutEvent(KeyEvent event) {
                            return true;
                        }

                        @Override
                        public boolean dispatchTouchEvent(MotionEvent ev) {
                            return true;
                        }

                        @Override
                        public boolean dispatchTrackballEvent(MotionEvent ev) {
                            return true;
                        }

                        @Override
                        public boolean dispatchGenericMotionEvent(MotionEvent ev) {
                            return true;
                        }

                        @Override
                        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
                            return true;
                        }
                    };
                    if (PhoneWindowManager.this.mContext.getPackageManager().isDeviceUpgrading()) {
                        PhoneWindowManager.this.mBootMsgDialog.setTitle(17039496);
                    } else {
                        PhoneWindowManager.this.mBootMsgDialog.setTitle(17039489);
                    }
                    PhoneWindowManager.this.mBootMsgDialog.setProgressStyle(0);
                    PhoneWindowManager.this.mBootMsgDialog.setIndeterminate(true);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setType(2021);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().addFlags(258);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setDimAmount(1.0f);
                    WindowManager.LayoutParams lp = PhoneWindowManager.this.mBootMsgDialog.getWindow().getAttributes();
                    lp.screenOrientation = 5;
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setAttributes(lp);
                    PhoneWindowManager.this.mBootMsgDialog.setCancelable(false);
                    PhoneWindowManager.this.mBootMsgDialog.show();
                }
                PhoneWindowManager.this.mBootMsgDialog.setMessage(msg);
            }
        });
    }

    @Override
    public void hideBootMessages() {
        this.mHandler.sendEmptyMessage(11);
    }

    @Override
    public void requestUserActivityNotification() {
        if (!this.mNotifyUserActivity && !this.mHandler.hasMessages(26)) {
            this.mNotifyUserActivity = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userActivity() {
        ScreenLockTimeout screenLockTimeout = this.mScreenLockTimeout;
        synchronized (screenLockTimeout) {
            if (this.mLockScreenTimerActive) {
                this.mHandler.removeCallbacks(this.mScreenLockTimeout);
                this.mHandler.postDelayed(this.mScreenLockTimeout, this.mLockScreenTimeout);
            }
        }
        if (this.mDefaultDisplayPolicy.isAwake() && this.mNotifyUserActivity) {
            this.mHandler.sendEmptyMessageDelayed(26, 200L);
            this.mNotifyUserActivity = false;
        }
    }

    @Override
    public void lockNow(Bundle options) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        this.mHandler.removeCallbacks(this.mScreenLockTimeout);
        if (options != null) {
            this.mScreenLockTimeout.setLockOptions(options);
        }
        this.mHandler.post(this.mScreenLockTimeout);
    }

    @Override
    public void setAllowLockscreenWhenOn(int displayId, boolean allow) {
        if (allow) {
            this.mAllowLockscreenWhenOnDisplays.add(displayId);
        } else {
            this.mAllowLockscreenWhenOnDisplays.remove(displayId);
        }
        this.updateLockScreenTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLockScreenTimeout() {
        ScreenLockTimeout screenLockTimeout = this.mScreenLockTimeout;
        synchronized (screenLockTimeout) {
            boolean enable;
            boolean bl = enable = !this.mAllowLockscreenWhenOnDisplays.isEmpty() && this.mDefaultDisplayPolicy.isAwake() && this.mKeyguardDelegate != null && this.mKeyguardDelegate.isSecure(this.mCurrentUserId);
            if (this.mLockScreenTimerActive != enable) {
                if (enable) {
                    this.mHandler.removeCallbacks(this.mScreenLockTimeout);
                    this.mHandler.postDelayed(this.mScreenLockTimeout, this.mLockScreenTimeout);
                } else {
                    this.mHandler.removeCallbacks(this.mScreenLockTimeout);
                }
                this.mLockScreenTimerActive = enable;
            }
        }
    }

    private void schedulePossibleVeryLongPressReboot() {
        this.mHandler.removeCallbacks(this.mPossibleVeryLongPressReboot);
        this.mHandler.postDelayed(this.mPossibleVeryLongPressReboot, this.mVeryLongPressTimeout);
    }

    private void cancelPossibleVeryLongPressReboot() {
        this.mHandler.removeCallbacks(this.mPossibleVeryLongPressReboot);
    }

    private void updateScreenOffSleepToken(boolean acquire) {
        if (acquire) {
            if (this.mScreenOffSleepToken == null) {
                this.mScreenOffSleepToken = this.mActivityTaskManagerInternal.acquireSleepToken("ScreenOff", 0);
            }
        } else if (this.mScreenOffSleepToken != null) {
            this.mScreenOffSleepToken.release();
            this.mScreenOffSleepToken = null;
        }
    }

    @Override
    public void enableScreenAfterBoot() {
        this.readLidState();
        this.applyLidSwitchState();
        this.updateRotation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLidSwitchState() {
        int lidState = this.mDefaultDisplayPolicy.getLidState();
        if (this.mLidControlsDisplayFold && this.mDisplayFoldController != null) {
            this.mDisplayFoldController.requestDeviceFolded(lidState == 0);
        } else if (lidState == 0) {
            int lidBehavior = this.getLidBehavior();
            switch (lidBehavior) {
                case 2: {
                    this.mWindowManagerFuncs.lockDeviceNow();
                    break;
                }
                case 1: {
                    this.goToSleep(SystemClock.uptimeMillis(), 3, 1);
                    break;
                }
            }
        }
        Object object = this.mLock;
        synchronized (object) {
            this.updateWakeGestureListenerLp();
        }
    }

    void updateUiMode() {
        if (this.mUiModeManager == null) {
            this.mUiModeManager = IUiModeManager.Stub.asInterface(ServiceManager.getService("uimode"));
        }
        try {
            this.mUiMode = this.mUiModeManager.getCurrentModeType();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public int getUiMode() {
        return this.mUiMode;
    }

    void updateRotation(boolean alwaysSendConfiguration) {
        try {
            this.mWindowManager.updateRotation(alwaysSendConfiguration, false);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    Intent createHomeDockIntent() {
        Intent intent = null;
        if (this.mUiMode == 3) {
            if (this.mEnableCarDockHomeCapture) {
                intent = this.mCarDockIntent;
            }
        } else if (this.mUiMode != 2) {
            if (this.mUiMode == 6) {
                int dockMode = this.mDefaultDisplayPolicy.getDockMode();
                if (dockMode == 1 || dockMode == 4 || dockMode == 3) {
                    intent = this.mDeskDockIntent;
                }
            } else if (this.mUiMode == 7) {
                intent = this.mVrHeadsetHomeIntent;
            }
        }
        if (intent == null) {
            return null;
        }
        ActivityInfo ai = null;
        ResolveInfo info = this.mContext.getPackageManager().resolveActivityAsUser(intent, 65664, this.mCurrentUserId);
        if (info != null) {
            ai = info.activityInfo;
        }
        if (ai != null && ai.metaData != null && ai.metaData.getBoolean("android.dock_home")) {
            intent = new Intent(intent);
            intent.setClassName(ai.packageName, ai.name);
            return intent;
        }
        return null;
    }

    void startDockOrHome(int displayId, boolean fromHomeKey, boolean awakenFromDreams) {
        try {
            ActivityManager.getService().stopAppSwitches();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_HOME_KEY);
        if (awakenFromDreams) {
            PhoneWindowManager.awakenDreams();
        }
        if (!this.isUserSetupComplete()) {
            Slog.i(TAG, "Not going home because user setup is in progress.");
            return;
        }
        Intent dock = this.createHomeDockIntent();
        if (dock != null) {
            try {
                if (fromHomeKey) {
                    dock.putExtra("android.intent.extra.FROM_HOME_KEY", fromHomeKey);
                }
                this.startActivityAsUser(dock, UserHandle.CURRENT);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                // empty catch block
            }
        }
        this.mActivityTaskManagerInternal.startHomeOnDisplay(this.mCurrentUserId, "startDockOrHome", displayId, true, fromHomeKey);
    }

    boolean goHome() {
        if (!this.isUserSetupComplete()) {
            Slog.i(TAG, "Not going home because user setup is in progress.");
            return false;
        }
        try {
            if (SystemProperties.getInt("persist.sys.uts-test-mode", 0) == 1) {
                Log.d(TAG, "UTS-TEST-MODE");
            } else {
                int result;
                ActivityManager.getService().stopAppSwitches();
                this.sendCloseSystemWindows();
                Intent dock = this.createHomeDockIntent();
                if (dock != null && (result = ActivityTaskManager.getService().startActivityAsUser(null, null, dock, dock.resolveTypeIfNeeded(this.mContext.getContentResolver()), null, null, 0, 1, null, null, -2)) == 1) {
                    return false;
                }
            }
            int result = ActivityTaskManager.getService().startActivityAsUser(null, null, this.mHomeIntent, this.mHomeIntent.resolveTypeIfNeeded(this.mContext.getContentResolver()), null, null, 0, 1, null, null, -2);
            if (result == 1) {
                return false;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    private boolean isTheaterModeEnabled() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "theater_mode_on", 0) == 1;
    }

    private boolean performHapticFeedback(int effectId, boolean always, String reason) {
        return this.performHapticFeedback(Process.myUid(), this.mContext.getOpPackageName(), effectId, always, reason);
    }

    @Override
    public boolean performHapticFeedback(int uid, String packageName, int effectId, boolean always, String reason) {
        boolean hapticsDisabled;
        if (!this.mVibrator.hasVibrator()) {
            return false;
        }
        boolean bl = hapticsDisabled = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 0, -2) == 0;
        if (hapticsDisabled && !always) {
            return false;
        }
        VibrationEffect effect = this.getVibrationEffect(effectId);
        if (effect == null) {
            return false;
        }
        this.mVibrator.vibrate(uid, packageName, effect, reason, VIBRATION_ATTRIBUTES);
        return true;
    }

    private VibrationEffect getVibrationEffect(int effectId) {
        long[] pattern;
        switch (effectId) {
            case 6: {
                return VibrationEffect.get(2);
            }
            case 9: {
                if (!this.mHapticTextHandleEnabled) {
                    return null;
                }
            }
            case 4: {
                return VibrationEffect.get(21);
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                return VibrationEffect.get(2, false);
            }
            case 1: 
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                return VibrationEffect.get(0);
            }
            case 0: 
            case 14: {
                return VibrationEffect.get(5);
            }
            case 17: {
                return VibrationEffect.get(1);
            }
            case 5: {
                pattern = this.mCalendarDateVibePattern;
                break;
            }
            case 10001: {
                pattern = this.mSafeModeEnabledVibePattern;
                break;
            }
            default: {
                return null;
            }
        }
        if (pattern.length == 0) {
            return null;
        }
        if (pattern.length == 1) {
            return VibrationEffect.createOneShot(pattern[0], -1);
        }
        return VibrationEffect.createWaveform(pattern, -1);
    }

    @Override
    public void keepScreenOnStartedLw() {
    }

    @Override
    public void keepScreenOnStoppedLw() {
        if (this.isKeyguardShowingAndNotOccluded()) {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
        }
    }

    @Override
    public boolean hasNavigationBar() {
        return this.mDefaultDisplayPolicy.hasNavigationBar();
    }

    @Override
    public void setDismissImeOnBackKeyPressed(boolean newValue) {
        this.mDismissImeOnBackKeyPressed = newValue;
    }

    @Override
    public void setCurrentUserLw(int newUserId) {
        StatusBarManagerInternal statusBar;
        this.mCurrentUserId = newUserId;
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.setCurrentUser(newUserId);
        }
        if (this.mAccessibilityShortcutController != null) {
            this.mAccessibilityShortcutController.setCurrentUser(newUserId);
        }
        if ((statusBar = this.getStatusBarManagerInternal()) != null) {
            statusBar.setCurrentUser(newUserId);
        }
    }

    @Override
    public void setSwitchingUser(boolean switching) {
        this.mKeyguardDelegate.setSwitchingUser(switching);
    }

    @Override
    public boolean isTopLevelWindow(int windowType) {
        if (windowType >= 1000 && windowType <= 1999) {
            return windowType == 1003;
        }
        return true;
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(1159641169922L, this.mDefaultDisplayRotation.getUserRotationMode());
        proto.write(1159641169923L, this.mDefaultDisplayRotation.getUserRotation());
        proto.write(1159641169924L, this.mDefaultDisplayRotation.getCurrentAppOrientation());
        proto.write(1133871366149L, this.mDefaultDisplayPolicy.isScreenOnFully());
        proto.write(1133871366150L, this.mDefaultDisplayPolicy.isKeyguardDrawComplete());
        proto.write(1133871366151L, this.mDefaultDisplayPolicy.isWindowManagerDrawComplete());
        proto.write(1133871366156L, this.mKeyguardOccluded);
        proto.write(1133871366157L, this.mKeyguardOccludedChanged);
        proto.write(1133871366158L, this.mPendingKeyguardOccluded);
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.writeToProto(proto, 1146756268052L);
        }
        proto.end(token);
    }

    @Override
    public void dump(String prefix, PrintWriter pw, String[] args) {
        pw.print(prefix);
        pw.print("mSafeMode=");
        pw.print(this.mSafeMode);
        pw.print(" mSystemReady=");
        pw.print(this.mSystemReady);
        pw.print(" mSystemBooted=");
        pw.println(this.mSystemBooted);
        pw.print(prefix);
        pw.print("mCameraLensCoverState=");
        pw.println(WindowManagerPolicy.WindowManagerFuncs.cameraLensStateToString(this.mCameraLensCoverState));
        pw.print(prefix);
        pw.print("mWakeGestureEnabledSetting=");
        pw.println(this.mWakeGestureEnabledSetting);
        pw.print(prefix);
        pw.print("mUiMode=");
        pw.print(Configuration.uiModeToString(this.mUiMode));
        pw.print("mEnableCarDockHomeCapture=");
        pw.println(this.mEnableCarDockHomeCapture);
        pw.print(prefix);
        pw.print("mLidKeyboardAccessibility=");
        pw.print(this.mLidKeyboardAccessibility);
        pw.print(" mLidNavigationAccessibility=");
        pw.print(this.mLidNavigationAccessibility);
        pw.print(" getLidBehavior=");
        pw.println(PhoneWindowManager.lidBehaviorToString(this.getLidBehavior()));
        pw.print(prefix);
        pw.print("mLongPressOnBackBehavior=");
        pw.println(PhoneWindowManager.longPressOnBackBehaviorToString(this.mLongPressOnBackBehavior));
        pw.print(prefix);
        pw.print("mLongPressOnHomeBehavior=");
        pw.println(PhoneWindowManager.longPressOnHomeBehaviorToString(this.mLongPressOnHomeBehavior));
        pw.print(prefix);
        pw.print("mDoubleTapOnHomeBehavior=");
        pw.println(PhoneWindowManager.doubleTapOnHomeBehaviorToString(this.mDoubleTapOnHomeBehavior));
        pw.print(prefix);
        pw.print("mShortPressOnPowerBehavior=");
        pw.println(PhoneWindowManager.shortPressOnPowerBehaviorToString(this.mShortPressOnPowerBehavior));
        pw.print(prefix);
        pw.print("mLongPressOnPowerBehavior=");
        pw.println(PhoneWindowManager.longPressOnPowerBehaviorToString(this.mLongPressOnPowerBehavior));
        pw.print(prefix);
        pw.print("mVeryLongPressOnPowerBehavior=");
        pw.println(PhoneWindowManager.veryLongPressOnPowerBehaviorToString(this.mVeryLongPressOnPowerBehavior));
        pw.print(prefix);
        pw.print("mDoublePressOnPowerBehavior=");
        pw.println(PhoneWindowManager.multiPressOnPowerBehaviorToString(this.mDoublePressOnPowerBehavior));
        pw.print(prefix);
        pw.print("mTriplePressOnPowerBehavior=");
        pw.println(PhoneWindowManager.multiPressOnPowerBehaviorToString(this.mTriplePressOnPowerBehavior));
        pw.print(prefix);
        pw.print("mShortPressOnSleepBehavior=");
        pw.println(PhoneWindowManager.shortPressOnSleepBehaviorToString(this.mShortPressOnSleepBehavior));
        pw.print(prefix);
        pw.print("mShortPressOnWindowBehavior=");
        pw.println(PhoneWindowManager.shortPressOnWindowBehaviorToString(this.mShortPressOnWindowBehavior));
        pw.print(prefix);
        pw.print("mAllowStartActivityForLongPressOnPowerDuringSetup=");
        pw.println(this.mAllowStartActivityForLongPressOnPowerDuringSetup);
        pw.print(prefix);
        pw.print("mHasSoftInput=");
        pw.print(this.mHasSoftInput);
        pw.print(" mHapticTextHandleEnabled=");
        pw.println(this.mHapticTextHandleEnabled);
        pw.print(prefix);
        pw.print("mDismissImeOnBackKeyPressed=");
        pw.print(this.mDismissImeOnBackKeyPressed);
        pw.print(" mIncallPowerBehavior=");
        pw.println(PhoneWindowManager.incallPowerBehaviorToString(this.mIncallPowerBehavior));
        pw.print(prefix);
        pw.print("mIncallBackBehavior=");
        pw.print(PhoneWindowManager.incallBackBehaviorToString(this.mIncallBackBehavior));
        pw.print(" mEndcallBehavior=");
        pw.println(PhoneWindowManager.endcallBehaviorToString(this.mEndcallBehavior));
        pw.print(prefix);
        pw.print("mDisplayHomeButtonHandlers=");
        for (int i = 0; i < this.mDisplayHomeButtonHandlers.size(); ++i) {
            int key = this.mDisplayHomeButtonHandlers.keyAt(i);
            pw.println(this.mDisplayHomeButtonHandlers.get(key));
        }
        pw.print(prefix);
        pw.print("mKeyguardOccluded=");
        pw.print(this.mKeyguardOccluded);
        pw.print(" mKeyguardOccludedChanged=");
        pw.print(this.mKeyguardOccludedChanged);
        pw.print(" mPendingKeyguardOccluded=");
        pw.println(this.mPendingKeyguardOccluded);
        pw.print(prefix);
        pw.print("mAllowLockscreenWhenOnDisplays=");
        pw.print(!this.mAllowLockscreenWhenOnDisplays.isEmpty());
        pw.print(" mLockScreenTimeout=");
        pw.print(this.mLockScreenTimeout);
        pw.print(" mLockScreenTimerActive=");
        pw.println(this.mLockScreenTimerActive);
        if (this.mHasFeatureLeanback) {
            pw.print(prefix);
            pw.print("mAccessibilityTvKey1Pressed=");
            pw.println(this.mAccessibilityTvKey1Pressed);
            pw.print(prefix);
            pw.print("mAccessibilityTvKey2Pressed=");
            pw.println(this.mAccessibilityTvKey2Pressed);
            pw.print(prefix);
            pw.print("mAccessibilityTvScheduled=");
            pw.println(this.mAccessibilityTvScheduled);
        }
        this.mGlobalKeyManager.dump(prefix, pw);
        if (this.mWakeGestureListener != null) {
            this.mWakeGestureListener.dump(pw, prefix);
        }
        if (this.mBurnInProtectionHelper != null) {
            this.mBurnInProtectionHelper.dump(prefix, pw);
        }
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.dump(prefix, pw);
        }
        pw.print(prefix);
        pw.println("Looper state:");
        this.mHandler.getLooper().dump(new PrintWriterPrinter(pw), prefix + "  ");
    }

    private static String endcallBehaviorToString(int behavior) {
        int N;
        StringBuilder sb = new StringBuilder();
        if ((behavior & 1) != 0) {
            sb.append("home|");
        }
        if ((behavior & 2) != 0) {
            sb.append("sleep|");
        }
        if ((N = sb.length()) == 0) {
            return "<nothing>";
        }
        return sb.substring(0, N - 1);
    }

    private static String incallPowerBehaviorToString(int behavior) {
        if ((behavior & 2) != 0) {
            return "hangup";
        }
        return "sleep";
    }

    private static String incallBackBehaviorToString(int behavior) {
        if ((behavior & 1) != 0) {
            return "hangup";
        }
        return "<nothing>";
    }

    private static String longPressOnBackBehaviorToString(int behavior) {
        switch (behavior) {
            case 0: {
                return "LONG_PRESS_BACK_NOTHING";
            }
            case 1: {
                return "LONG_PRESS_BACK_GO_TO_VOICE_ASSIST";
            }
        }
        return Integer.toString(behavior);
    }

    private static String longPressOnHomeBehaviorToString(int behavior) {
        switch (behavior) {
            case 0: {
                return "LONG_PRESS_HOME_NOTHING";
            }
            case 1: {
                return "LONG_PRESS_HOME_ALL_APPS";
            }
            case 2: {
                return "LONG_PRESS_HOME_ASSIST";
            }
        }
        return Integer.toString(behavior);
    }

    private static String doubleTapOnHomeBehaviorToString(int behavior) {
        switch (behavior) {
            case 0: {
                return "DOUBLE_TAP_HOME_NOTHING";
            }
            case 1: {
                return "DOUBLE_TAP_HOME_RECENT_SYSTEM_UI";
            }
        }
        return Integer.toString(behavior);
    }

    private static String shortPressOnPowerBehaviorToString(int behavior) {
        switch (behavior) {
            case 0: {
                return "SHORT_PRESS_POWER_NOTHING";
            }
            case 1: {
                return "SHORT_PRESS_POWER_GO_TO_SLEEP";
            }
            case 2: {
                return "SHORT_PRESS_POWER_REALLY_GO_TO_SLEEP";
            }
            case 3: {
                return "SHORT_PRESS_POWER_REALLY_GO_TO_SLEEP_AND_GO_HOME";
            }
            case 4: {
                return "SHORT_PRESS_POWER_GO_HOME";
            }
            case 5: {
                return "SHORT_PRESS_POWER_CLOSE_IME_OR_GO_HOME";
            }
        }
        return Integer.toString(behavior);
    }

    private static String longPressOnPowerBehaviorToString(int behavior) {
        switch (behavior) {
            case 0: {
                return "LONG_PRESS_POWER_NOTHING";
            }
            case 1: {
                return "LONG_PRESS_POWER_GLOBAL_ACTIONS";
            }
            case 2: {
                return "LONG_PRESS_POWER_SHUT_OFF";
            }
            case 3: {
                return "LONG_PRESS_POWER_SHUT_OFF_NO_CONFIRM";
            }
            case 4: {
                return "LONG_PRESS_POWER_GO_TO_VOICE_ASSIST";
            }
            case 5: {
                return "LONG_PRESS_POWER_ASSISTANT";
            }
        }
        return Integer.toString(behavior);
    }

    private static String veryLongPressOnPowerBehaviorToString(int behavior) {
        switch (behavior) {
            case 0: {
                return "VERY_LONG_PRESS_POWER_NOTHING";
            }
            case 1: {
                return "VERY_LONG_PRESS_POWER_GLOBAL_ACTIONS";
            }
        }
        return Integer.toString(behavior);
    }

    private static String multiPressOnPowerBehaviorToString(int behavior) {
        switch (behavior) {
            case 0: {
                return "MULTI_PRESS_POWER_NOTHING";
            }
            case 1: {
                return "MULTI_PRESS_POWER_THEATER_MODE";
            }
            case 2: {
                return "MULTI_PRESS_POWER_BRIGHTNESS_BOOST";
            }
        }
        return Integer.toString(behavior);
    }

    private static String shortPressOnSleepBehaviorToString(int behavior) {
        switch (behavior) {
            case 0: {
                return "SHORT_PRESS_SLEEP_GO_TO_SLEEP";
            }
            case 1: {
                return "SHORT_PRESS_SLEEP_GO_TO_SLEEP_AND_GO_HOME";
            }
        }
        return Integer.toString(behavior);
    }

    private static String shortPressOnWindowBehaviorToString(int behavior) {
        switch (behavior) {
            case 0: {
                return "SHORT_PRESS_WINDOW_NOTHING";
            }
            case 1: {
                return "SHORT_PRESS_WINDOW_PICTURE_IN_PICTURE";
            }
        }
        return Integer.toString(behavior);
    }

    private static String lidBehaviorToString(int behavior) {
        switch (behavior) {
            case 2: {
                return "LID_BEHAVIOR_LOCK";
            }
            case 1: {
                return "LID_BEHAVIOR_SLEEP";
            }
            case 0: {
                return "LID_BEHAVIOR_NONE";
            }
        }
        return Integer.toString(behavior);
    }

    @Override
    public boolean setAodShowing(boolean aodShowing) {
        if (this.mAodShowing != aodShowing) {
            this.mAodShowing = aodShowing;
            return true;
        }
        return false;
    }

    static {
        sApplicationLaunchKeyCategories.append(64, "android.intent.category.APP_BROWSER");
        sApplicationLaunchKeyCategories.append(65, "android.intent.category.APP_EMAIL");
        sApplicationLaunchKeyCategories.append(207, "android.intent.category.APP_CONTACTS");
        sApplicationLaunchKeyCategories.append(208, "android.intent.category.APP_CALENDAR");
        sApplicationLaunchKeyCategories.append(209, "android.intent.category.APP_MUSIC");
        sApplicationLaunchKeyCategories.append(210, "android.intent.category.APP_CALCULATOR");
        WINDOW_TYPES_WHERE_HOME_DOESNT_WORK = new int[]{2003, 2010};
    }

    private class HdmiVideoExtconUEventObserver
    extends ExtconStateObserver<Boolean> {
        private static final String HDMI_EXIST = "HDMI=1";
        private static final String NAME = "hdmi";
        private final ExtconUEventObserver.ExtconInfo mHdmi = new ExtconUEventObserver.ExtconInfo("hdmi");

        private HdmiVideoExtconUEventObserver() {
        }

        private boolean init() {
            boolean plugged = false;
            try {
                plugged = (Boolean)this.parseStateFromFile(this.mHdmi);
            }
            catch (FileNotFoundException e) {
                Slog.w(PhoneWindowManager.TAG, this.mHdmi.getStatePath() + " not found while attempting to determine initial state", e);
            }
            catch (IOException e) {
                Slog.e(PhoneWindowManager.TAG, "Error reading " + this.mHdmi.getStatePath() + " while attempting to determine initial state", e);
            }
            this.startObserving(this.mHdmi);
            return plugged;
        }

        @Override
        public void updateState(ExtconUEventObserver.ExtconInfo extconInfo, String eventName, Boolean state) {
            PhoneWindowManager.this.mDefaultDisplayPolicy.setHdmiPlugged(state);
        }

        @Override
        public Boolean parseState(ExtconUEventObserver.ExtconInfo extconIfno, String state) {
            return state.contains(HDMI_EXIST);
        }

        static /* synthetic */ boolean access$3800(HdmiVideoExtconUEventObserver x0) {
            return x0.init();
        }
    }

    class ScreenLockTimeout
    implements Runnable {
        Bundle options;

        ScreenLockTimeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ScreenLockTimeout screenLockTimeout = this;
            synchronized (screenLockTimeout) {
                if (PhoneWindowManager.this.mKeyguardDelegate != null) {
                    PhoneWindowManager.this.mKeyguardDelegate.doKeyguardTimeout(this.options);
                }
                PhoneWindowManager.this.mLockScreenTimerActive = false;
                this.options = null;
            }
        }

        public void setLockOptions(Bundle options) {
            this.options = options;
        }
    }

    private class DisplayHomeButtonHandler {
        private final int mDisplayId;
        private boolean mHomeDoubleTapPending;
        private boolean mHomePressed;
        private boolean mHomeConsumed;
        private final Runnable mHomeDoubleTapTimeoutRunnable = new Runnable(){

            @Override
            public void run() {
                if (DisplayHomeButtonHandler.this.mHomeDoubleTapPending) {
                    DisplayHomeButtonHandler.this.mHomeDoubleTapPending = false;
                    PhoneWindowManager.this.handleShortPressOnHome(DisplayHomeButtonHandler.this.mDisplayId);
                }
            }
        };

        DisplayHomeButtonHandler(int displayId) {
            this.mDisplayId = displayId;
        }

        int handleHomeButton(WindowManagerPolicy.WindowState win, KeyEvent event) {
            WindowManager.LayoutParams attrs;
            boolean keyguardOn = PhoneWindowManager.this.keyguardOn();
            int repeatCount = event.getRepeatCount();
            boolean down = event.getAction() == 0;
            boolean canceled = event.isCanceled();
            if (!down) {
                if (this.mDisplayId == 0) {
                    PhoneWindowManager.this.cancelPreloadRecentApps();
                }
                this.mHomePressed = false;
                if (this.mHomeConsumed) {
                    this.mHomeConsumed = false;
                    return -1;
                }
                if (canceled) {
                    Log.i(PhoneWindowManager.TAG, "Ignoring HOME; event canceled.");
                    return -1;
                }
                if (PhoneWindowManager.this.mDoubleTapOnHomeBehavior != 0) {
                    PhoneWindowManager.this.mHandler.removeCallbacks(this.mHomeDoubleTapTimeoutRunnable);
                    this.mHomeDoubleTapPending = true;
                    PhoneWindowManager.this.mHandler.postDelayed(this.mHomeDoubleTapTimeoutRunnable, ViewConfiguration.getDoubleTapTimeout());
                    return -1;
                }
                PhoneWindowManager.this.mHandler.post(() -> PhoneWindowManager.this.handleShortPressOnHome(this.mDisplayId));
                return -1;
            }
            WindowManager.LayoutParams layoutParams = attrs = win != null ? win.getAttrs() : null;
            if (attrs != null) {
                int type = attrs.type;
                if (type == 2009 || (attrs.privateFlags & 0x400) != 0) {
                    return 0;
                }
                for (int t : WINDOW_TYPES_WHERE_HOME_DOESNT_WORK) {
                    if (type != t) continue;
                    return -1;
                }
            }
            if (repeatCount == 0) {
                this.mHomePressed = true;
                if (this.mHomeDoubleTapPending) {
                    this.mHomeDoubleTapPending = false;
                    PhoneWindowManager.this.mHandler.removeCallbacks(this.mHomeDoubleTapTimeoutRunnable);
                    this.handleDoubleTapOnHome();
                } else if (PhoneWindowManager.this.mDoubleTapOnHomeBehavior == 1 && this.mDisplayId == 0) {
                    PhoneWindowManager.this.preloadRecentApps();
                }
            } else if ((event.getFlags() & 0x80) != 0 && !keyguardOn) {
                PhoneWindowManager.this.mHandler.post(() -> this.handleLongPressOnHome(event.getDeviceId()));
            }
            return -1;
        }

        private void handleDoubleTapOnHome() {
            if (PhoneWindowManager.this.mDoubleTapOnHomeBehavior == 1) {
                this.mHomeConsumed = true;
                PhoneWindowManager.this.toggleRecentApps();
            }
        }

        private void handleLongPressOnHome(int deviceId) {
            if (PhoneWindowManager.this.mLongPressOnHomeBehavior == 0) {
                return;
            }
            this.mHomeConsumed = true;
            PhoneWindowManager.this.performHapticFeedback(0, false, "Home - Long Press");
            switch (PhoneWindowManager.this.mLongPressOnHomeBehavior) {
                case 1: {
                    PhoneWindowManager.this.launchAllAppsAction();
                    break;
                }
                case 2: {
                    PhoneWindowManager.this.launchAssistAction(null, deviceId);
                    break;
                }
                default: {
                    Log.w(PhoneWindowManager.TAG, "Undefined home long press behavior: " + PhoneWindowManager.this.mLongPressOnHomeBehavior);
                }
            }
        }

        public String toString() {
            return String.format("mDisplayId = %d, mHomePressed = %b", this.mDisplayId, this.mHomePressed);
        }
    }

    private static class HdmiControl {
        private final HdmiPlaybackClient mClient;

        private HdmiControl(HdmiPlaybackClient client) {
            this.mClient = client;
        }

        public void turnOnTv() {
            if (this.mClient == null) {
                return;
            }
            this.mClient.oneTouchPlay(new HdmiPlaybackClient.OneTouchPlayCallback(){

                @Override
                public void onComplete(int result) {
                    if (result != 0) {
                        Log.w(PhoneWindowManager.TAG, "One touch play failed: " + result);
                    }
                }
            });
        }
    }

    private class ScreenshotRunnable
    implements Runnable {
        private int mScreenshotType = 1;

        private ScreenshotRunnable() {
        }

        public void setScreenshotType(int screenshotType) {
            this.mScreenshotType = screenshotType;
        }

        @Override
        public void run() {
            PhoneWindowManager.this.mDefaultDisplayPolicy.takeScreenshot(this.mScreenshotType);
        }
    }

    class MyWakeGestureListener
    extends WakeGestureListener {
        MyWakeGestureListener(Context context, Handler handler) {
            super(context, handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWakeUp() {
            Object object = PhoneWindowManager.this.mLock;
            synchronized (object) {
                if (PhoneWindowManager.this.shouldEnableWakeGestureLp()) {
                    PhoneWindowManager.this.performHapticFeedback(1, false, "Wake Up");
                    PhoneWindowManager.this.wakeUp(SystemClock.uptimeMillis(), PhoneWindowManager.this.mAllowTheaterModeWakeFromWakeGesture, 4, "android.policy:GESTURE");
                }
            }
        }
    }

    class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
        }

        void observe() {
            ContentResolver resolver = PhoneWindowManager.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.System.getUriFor("end_button_behavior"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("incall_power_button_behavior"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("incall_back_button_behavior"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("wake_gesture_enabled"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("screen_off_timeout"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("default_input_method"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("volume_hush_gesture"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("system_navigation_keys_enabled"), false, this, -1);
            resolver.registerContentObserver(Settings.Global.getUriFor("power_button_long_press"), false, this, -1);
            resolver.registerContentObserver(Settings.Global.getUriFor("power_button_very_long_press"), false, this, -1);
            resolver.registerContentObserver(Settings.Global.getUriFor("power_button_suppression_delay_after_gesture_wake"), false, this, -1);
            PhoneWindowManager.this.updateSettings();
        }

        @Override
        public void onChange(boolean selfChange) {
            PhoneWindowManager.this.updateSettings();
            PhoneWindowManager.this.updateRotation(false);
        }
    }

    private class PolicyHandler
    extends Handler {
        private PolicyHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    PhoneWindowManager.this.dispatchMediaKeyWithWakeLock((KeyEvent)msg.obj);
                    break;
                }
                case 4: {
                    PhoneWindowManager.this.dispatchMediaKeyRepeatWithWakeLock((KeyEvent)msg.obj);
                    break;
                }
                case 9: {
                    PhoneWindowManager.this.showRecentApps(false);
                    break;
                }
                case 10: {
                    PhoneWindowManager.this.showGlobalActionsInternal();
                    break;
                }
                case 5: {
                    PhoneWindowManager.this.finishKeyguardDrawn();
                    break;
                }
                case 6: {
                    Slog.w(PhoneWindowManager.TAG, "Keyguard drawn timeout. Setting mKeyguardDrawComplete");
                    PhoneWindowManager.this.finishKeyguardDrawn();
                    break;
                }
                case 7: {
                    PhoneWindowManager.this.finishWindowsDrawn();
                    break;
                }
                case 11: {
                    PhoneWindowManager.this.handleHideBootMessage();
                    break;
                }
                case 23: {
                    int deviceId = msg.arg1;
                    String hint = (String)msg.obj;
                    PhoneWindowManager.this.launchAssistAction(hint, deviceId);
                    break;
                }
                case 24: {
                    PhoneWindowManager.this.launchAssistLongPressAction();
                    break;
                }
                case 12: {
                    PhoneWindowManager.this.launchVoiceAssistWithWakeLock();
                    break;
                }
                case 13: {
                    PhoneWindowManager.this.powerPress((Long)msg.obj, msg.arg1 != 0, msg.arg2);
                    PhoneWindowManager.this.finishPowerKeyPress();
                    break;
                }
                case 14: {
                    PhoneWindowManager.this.powerLongPress();
                    break;
                }
                case 25: {
                    PhoneWindowManager.this.powerVeryLongPress();
                    break;
                }
                case 15: {
                    PhoneWindowManager.this.showPictureInPictureMenuInternal();
                    break;
                }
                case 16: {
                    PhoneWindowManager.this.backLongPress();
                    break;
                }
                case 17: {
                    PhoneWindowManager.this.accessibilityShortcutActivated();
                    break;
                }
                case 18: {
                    PhoneWindowManager.this.requestFullBugreport();
                    break;
                }
                case 19: {
                    if (!PhoneWindowManager.this.mAccessibilityShortcutController.isAccessibilityShortcutAvailable(false)) break;
                    PhoneWindowManager.this.accessibilityShortcutActivated();
                    break;
                }
                case 20: {
                    PhoneWindowManager.this.mAutofillManagerInternal.onBackKeyPressed();
                    break;
                }
                case 21: {
                    PhoneWindowManager.this.sendSystemKeyToStatusBar(msg.arg1);
                    break;
                }
                case 22: {
                    PhoneWindowManager.this.launchAllAppsAction();
                    break;
                }
                case 26: {
                    this.removeMessages(26);
                    Intent intent = new Intent("android.intent.action.USER_ACTIVITY_NOTIFICATION");
                    intent.addFlags(0x40000000);
                    PhoneWindowManager.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.USER_ACTIVITY");
                    break;
                }
                case 27: {
                    PhoneWindowManager.this.handleRingerChordGesture();
                    break;
                }
                case 28: {
                    PhoneWindowManager.this.mWindowManagerFuncs.moveDisplayToTop(msg.arg1);
                    PhoneWindowManager.this.mMovingDisplayToTopKeyTriggered = false;
                }
            }
        }
    }
}

