/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.Context;
import android.os.UserManager;
import com.android.internal.globalactions.LongPressAction;
import com.android.internal.globalactions.SinglePressAction;
import com.android.server.policy.WindowManagerPolicy;

public final class RestartAction
extends SinglePressAction
implements LongPressAction {
    private final Context mContext;
    private final WindowManagerPolicy.WindowManagerFuncs mWindowManagerFuncs;

    public RestartAction(Context context, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs) {
        super(17302786, 17040056);
        this.mContext = context;
        this.mWindowManagerFuncs = windowManagerFuncs;
    }

    @Override
    public boolean onLongPress() {
        UserManager um = this.mContext.getSystemService(UserManager.class);
        if (!um.hasUserRestriction("no_safe_boot")) {
            this.mWindowManagerFuncs.rebootSafeMode(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean showDuringKeyguard() {
        return true;
    }

    @Override
    public boolean showBeforeProvisioning() {
        return true;
    }

    @Override
    public void onPress() {
        this.mWindowManagerFuncs.reboot(false);
    }
}

