/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.UserHandle;

public abstract class SoftRestrictedPermissionPolicy {
    private static final int FLAGS_PERMISSION_RESTRICTION_ANY_EXEMPT = 14336;
    private static final SoftRestrictedPermissionPolicy DUMMY_POLICY = new SoftRestrictedPermissionPolicy(){

        @Override
        public int resolveAppOp() {
            return -1;
        }

        @Override
        public int getDesiredOpMode() {
            return 3;
        }

        @Override
        public boolean shouldSetAppOpIfNotDefault() {
            return false;
        }

        @Override
        public boolean canBeGranted() {
            return true;
        }
    };

    private static int getMinimumTargetSDK(Context context, ApplicationInfo appInfo, UserHandle user) {
        PackageManager pm = context.getPackageManager();
        int minimumTargetSDK = appInfo.targetSdkVersion;
        String[] uidPkgs = pm.getPackagesForUid(appInfo.uid);
        if (uidPkgs != null) {
            for (String uidPkg : uidPkgs) {
                ApplicationInfo uidPkgInfo;
                if (uidPkg.equals(appInfo.packageName)) continue;
                try {
                    uidPkgInfo = pm.getApplicationInfoAsUser(uidPkg, 0, user);
                }
                catch (PackageManager.NameNotFoundException e) {
                    continue;
                }
                minimumTargetSDK = Integer.min(minimumTargetSDK, uidPkgInfo.targetSdkVersion);
            }
        }
        return minimumTargetSDK;
    }

    public static SoftRestrictedPermissionPolicy forPermission(Context context, ApplicationInfo appInfo, UserHandle user, String permission2) {
        switch (permission2) {
            case "android.permission.READ_EXTERNAL_STORAGE": {
                boolean hasRequestedLegacyExternalStorage;
                int targetSDK;
                boolean isWhiteListed;
                boolean applyRestriction;
                if (appInfo != null) {
                    PackageManager pm = context.getPackageManager();
                    int flags = pm.getPermissionFlags(permission2, appInfo.packageName, user);
                    applyRestriction = (flags & 0x4000) != 0;
                    isWhiteListed = (flags & 0x3800) != 0;
                    targetSDK = SoftRestrictedPermissionPolicy.getMinimumTargetSDK(context, appInfo, user);
                    boolean hasAnyRequestedLegacyExternalStorage = appInfo.hasRequestedLegacyExternalStorage();
                    String[] uidPkgs = pm.getPackagesForUid(appInfo.uid);
                    if (uidPkgs != null) {
                        for (String uidPkg : uidPkgs) {
                            ApplicationInfo uidPkgInfo;
                            if (uidPkg.equals(appInfo.packageName)) continue;
                            try {
                                uidPkgInfo = pm.getApplicationInfoAsUser(uidPkg, 0, user);
                            }
                            catch (PackageManager.NameNotFoundException e) {
                                continue;
                            }
                            hasAnyRequestedLegacyExternalStorage |= uidPkgInfo.hasRequestedLegacyExternalStorage();
                        }
                    }
                    hasRequestedLegacyExternalStorage = hasAnyRequestedLegacyExternalStorage;
                } else {
                    boolean flags = false;
                    applyRestriction = false;
                    isWhiteListed = false;
                    hasRequestedLegacyExternalStorage = false;
                    targetSDK = 0;
                }
                return new SoftRestrictedPermissionPolicy(){

                    @Override
                    public int resolveAppOp() {
                        return 87;
                    }

                    @Override
                    public int getDesiredOpMode() {
                        if (applyRestriction) {
                            return 3;
                        }
                        if (hasRequestedLegacyExternalStorage) {
                            return 0;
                        }
                        return 1;
                    }

                    @Override
                    public boolean shouldSetAppOpIfNotDefault() {
                        return this.getDesiredOpMode() != 1;
                    }

                    @Override
                    public boolean canBeGranted() {
                        return isWhiteListed || targetSDK >= 29;
                    }
                };
            }
            case "android.permission.WRITE_EXTERNAL_STORAGE": {
                int targetSDK;
                boolean isWhiteListed;
                if (appInfo != null) {
                    int flags = context.getPackageManager().getPermissionFlags(permission2, appInfo.packageName, user);
                    isWhiteListed = (flags & 0x3800) != 0;
                    targetSDK = SoftRestrictedPermissionPolicy.getMinimumTargetSDK(context, appInfo, user);
                } else {
                    isWhiteListed = false;
                    targetSDK = 0;
                }
                return new SoftRestrictedPermissionPolicy(){

                    @Override
                    public int resolveAppOp() {
                        return -1;
                    }

                    @Override
                    public int getDesiredOpMode() {
                        return 3;
                    }

                    @Override
                    public boolean shouldSetAppOpIfNotDefault() {
                        return false;
                    }

                    @Override
                    public boolean canBeGranted() {
                        return isWhiteListed || targetSDK >= 29;
                    }
                };
            }
        }
        return DUMMY_POLICY;
    }

    public abstract int resolveAppOp();

    public abstract int getDesiredOpMode();

    public abstract boolean shouldSetAppOpIfNotDefault();

    public abstract boolean canBeGranted();
}

