/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy.role;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ResolveInfo;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.util.CollectionUtils;
import com.android.server.LocalServices;
import com.android.server.role.RoleManagerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LegacyRoleResolutionPolicy
implements RoleManagerService.RoleHoldersResolver {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "LegacyRoleResolutionPol";
    private final Context mContext;

    public LegacyRoleResolutionPolicy(Context context) {
        this.mContext = context;
    }

    @Override
    public List<String> getRoleHolders(String roleName, int userId) {
        switch (roleName) {
            case "android.app.role.ASSISTANT": {
                String legacyAssistant = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "assistant", userId);
                if (legacyAssistant == null || legacyAssistant.isEmpty()) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(ComponentName.unflattenFromString(legacyAssistant).getPackageName());
            }
            case "android.app.role.BROWSER": {
                PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
                String packageName = packageManagerInternal.removeLegacyDefaultBrowserPackageName(userId);
                return CollectionUtils.singletonOrEmpty(packageName);
            }
            case "android.app.role.DIALER": {
                String setting = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "dialer_default_application", userId);
                return CollectionUtils.singletonOrEmpty(!TextUtils.isEmpty(setting) ? setting : this.mContext.getSystemService(TelecomManager.class).getSystemDialerPackage());
            }
            case "android.app.role.SMS": {
                String result = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "sms_default_application", userId);
                if (result == null) {
                    SmsApplication.SmsApplicationData app;
                    String defaultPackage;
                    Collection<SmsApplication.SmsApplicationData> applications = SmsApplication.getApplicationCollectionAsUser(this.mContext, userId);
                    SmsApplication.SmsApplicationData applicationData = SmsApplication.getApplicationForPackage(applications, defaultPackage = this.mContext.getResources().getString(17039847));
                    if (applicationData == null && applications.size() != 0) {
                        applicationData = (SmsApplication.SmsApplicationData)applications.toArray()[0];
                    }
                    result = (app = applicationData) == null ? null : app.mPackageName;
                }
                return CollectionUtils.singletonOrEmpty(result);
            }
            case "android.app.role.HOME": {
                PackageManager packageManager = this.mContext.getPackageManager();
                ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
                ComponentName componentName = packageManager.getHomeActivities(resolveInfos);
                String packageName = componentName != null ? componentName.getPackageName() : null;
                return CollectionUtils.singletonOrEmpty(packageName);
            }
            case "android.app.role.EMERGENCY": {
                String defaultEmergencyApp = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "emergency_assistance_application", userId);
                return CollectionUtils.singletonOrEmpty(defaultEmergencyApp);
            }
        }
        Slog.e(LOG_TAG, "Don't know how to find legacy role holders for " + roleName);
        return Collections.emptyList();
    }
}

