/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.app.ActivityManager;
import android.app.SynchronousUserSwitchObserver;
import android.attention.AttentionManagerInternal;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.os.Handler;
import android.os.RemoteException;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Slog;
import android.util.StatsLog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.LocalServices;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class AttentionDetector {
    private static final String TAG = "AttentionDetector";
    private static final boolean DEBUG = false;
    private Context mContext;
    private boolean mIsSettingEnabled;
    private final Runnable mOnUserAttention;
    @VisibleForTesting
    protected long mMaximumExtensionMillis;
    private final Object mLock;
    private final AtomicBoolean mRequested;
    private long mLastActedOnNextScreenDimming;
    @VisibleForTesting
    protected int mRequestId;
    private long mMaxAttentionApiTimeoutMillis;
    private long mLastUserActivityTime;
    @VisibleForTesting
    protected AttentionManagerInternal mAttentionManager;
    @VisibleForTesting
    protected PackageManager mPackageManager;
    @VisibleForTesting
    protected ContentResolver mContentResolver;
    private int mWakefulness;
    private AtomicLong mConsecutiveTimeoutExtendedCount = new AtomicLong(0L);
    @VisibleForTesting
    AttentionCallbackInternalImpl mCallback;

    public AttentionDetector(Runnable onUserAttention, Object lock) {
        this.mOnUserAttention = onUserAttention;
        this.mLock = lock;
        this.mRequested = new AtomicBoolean(false);
        this.mRequestId = 0;
        this.mWakefulness = 1;
    }

    @VisibleForTesting
    void updateEnabledFromSettings(Context context) {
        this.mIsSettingEnabled = Settings.System.getIntForUser(context.getContentResolver(), "adaptive_sleep", 0, -2) == 1;
    }

    public void systemReady(final Context context) {
        this.mContext = context;
        this.updateEnabledFromSettings(context);
        this.mPackageManager = context.getPackageManager();
        this.mContentResolver = context.getContentResolver();
        this.mAttentionManager = LocalServices.getService(AttentionManagerInternal.class);
        this.mMaximumExtensionMillis = context.getResources().getInteger(17694735);
        this.mMaxAttentionApiTimeoutMillis = context.getResources().getInteger(0x10E000E);
        try {
            UserSwitchObserver observer = new UserSwitchObserver();
            ActivityManager.getService().registerUserSwitchObserver(observer, TAG);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        context.getContentResolver().registerContentObserver(Settings.System.getUriFor("adaptive_sleep"), false, new ContentObserver(new Handler()){

            @Override
            public void onChange(boolean selfChange) {
                AttentionDetector.this.updateEnabledFromSettings(context);
            }
        }, -1);
    }

    public long updateUserActivity(long nextScreenDimming) {
        if (nextScreenDimming == this.mLastActedOnNextScreenDimming) {
            return nextScreenDimming;
        }
        if (!this.mIsSettingEnabled) {
            return nextScreenDimming;
        }
        if (!this.isAttentionServiceSupported()) {
            return nextScreenDimming;
        }
        if (!this.serviceHasSufficientPermissions()) {
            Settings.System.putInt(this.mContentResolver, "adaptive_sleep", 0);
            return nextScreenDimming;
        }
        long now = SystemClock.uptimeMillis();
        long whenToCheck = nextScreenDimming - this.getAttentionTimeout();
        long whenToStopExtending = this.mLastUserActivityTime + this.mMaximumExtensionMillis;
        if (now < whenToCheck) {
            return whenToCheck;
        }
        if (whenToStopExtending < whenToCheck) {
            return nextScreenDimming;
        }
        if (this.mRequested.get()) {
            return whenToCheck;
        }
        this.mRequested.set(true);
        ++this.mRequestId;
        this.mLastActedOnNextScreenDimming = nextScreenDimming;
        this.mCallback = new AttentionCallbackInternalImpl(this.mRequestId);
        Slog.v(TAG, "Checking user attention, ID: " + this.mRequestId);
        boolean sent = this.mAttentionManager.checkAttention(this.getAttentionTimeout(), this.mCallback);
        if (!sent) {
            this.mRequested.set(false);
        }
        return whenToCheck;
    }

    public int onUserActivity(long eventTime, int event) {
        switch (event) {
            case 4: {
                this.mConsecutiveTimeoutExtendedCount.incrementAndGet();
                return 0;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.cancelCurrentRequestIfAny();
                this.mLastUserActivityTime = eventTime;
                this.resetConsecutiveExtensionCount();
                return 1;
            }
        }
        return -1;
    }

    public void onWakefulnessChangeStarted(int wakefulness) {
        this.mWakefulness = wakefulness;
        if (wakefulness != 1) {
            this.cancelCurrentRequestIfAny();
            this.resetConsecutiveExtensionCount();
        }
    }

    private void cancelCurrentRequestIfAny() {
        if (this.mRequested.get()) {
            this.mAttentionManager.cancelAttentionCheck(this.mCallback);
            this.mRequested.set(false);
        }
    }

    private void resetConsecutiveExtensionCount() {
        long previousCount = this.mConsecutiveTimeoutExtendedCount.getAndSet(0L);
        if (previousCount > 0L) {
            StatsLog.write(168, previousCount);
        }
    }

    @VisibleForTesting
    long getAttentionTimeout() {
        return this.mMaxAttentionApiTimeoutMillis;
    }

    @VisibleForTesting
    boolean isAttentionServiceSupported() {
        return this.mAttentionManager != null && this.mAttentionManager.isAttentionServiceSupported();
    }

    @VisibleForTesting
    boolean serviceHasSufficientPermissions() {
        String attentionPackage = this.mPackageManager.getAttentionServicePackageName();
        return attentionPackage != null && this.mPackageManager.checkPermission("android.permission.CAMERA", attentionPackage) == 0;
    }

    public void dump(PrintWriter pw) {
        pw.println("AttentionDetector:");
        pw.println(" mMaximumExtensionMillis=" + this.mMaximumExtensionMillis);
        pw.println(" mMaxAttentionApiTimeoutMillis=" + this.mMaxAttentionApiTimeoutMillis);
        pw.println(" mLastUserActivityTime(excludingAttention)=" + this.mLastUserActivityTime);
        pw.println(" mAttentionServiceSupported=" + this.isAttentionServiceSupported());
        pw.println(" mRequested=" + this.mRequested);
    }

    private final class UserSwitchObserver
    extends SynchronousUserSwitchObserver {
        private UserSwitchObserver() {
        }

        @Override
        public void onUserSwitching(int newUserId) throws RemoteException {
            AttentionDetector.this.updateEnabledFromSettings(AttentionDetector.this.mContext);
        }
    }

    @VisibleForTesting
    final class AttentionCallbackInternalImpl
    extends AttentionManagerInternal.AttentionCallbackInternal {
        private final int mId;

        AttentionCallbackInternalImpl(int id2) {
            this.mId = id2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(int result, long timestamp) {
            Slog.v(AttentionDetector.TAG, "onSuccess: " + result + ", ID: " + this.mId);
            if (this.mId == AttentionDetector.this.mRequestId && AttentionDetector.this.mRequested.getAndSet(false)) {
                Object object = AttentionDetector.this.mLock;
                synchronized (object) {
                    if (AttentionDetector.this.mWakefulness != 1) {
                        return;
                    }
                    if (result == 1) {
                        AttentionDetector.this.mOnUserAttention.run();
                    } else {
                        AttentionDetector.this.resetConsecutiveExtensionCount();
                    }
                }
            }
        }

        @Override
        public void onFailure(int error) {
            Slog.i(AttentionDetector.TAG, "Failed to check attention: " + error + ", ID: " + this.mId);
            AttentionDetector.this.mRequested.set(false);
        }
    }
}

