/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.IActivityManager;
import android.app.ProgressDialog;
import android.app.admin.SecurityLog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.os.FileUtils;
import android.os.Handler;
import android.os.PowerManager;
import android.os.RecoverySystem;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.SystemVibrator;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.TimingsTraceLog;
import com.android.internal.telephony.ITelephony;
import com.android.server.LocalServices;
import com.android.server.RescueParty;
import com.android.server.pm.PackageManagerService;
import com.android.server.power.PowerManagerService;
import com.android.server.statusbar.StatusBarManagerInternal;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public final class ShutdownThread
extends Thread {
    private static final String TAG = "ShutdownThread";
    private static final int ACTION_DONE_POLL_WAIT_MS = 500;
    private static final int RADIOS_STATE_POLL_SLEEP_MS = 100;
    private static final int MAX_BROADCAST_TIME = 10000;
    private static final int MAX_SHUTDOWN_WAIT_TIME = 20000;
    private static final int MAX_RADIO_WAIT_TIME = 12000;
    private static final int MAX_UNCRYPT_WAIT_TIME = 900000;
    private static final int BROADCAST_STOP_PERCENT = 2;
    private static final int ACTIVITY_MANAGER_STOP_PERCENT = 4;
    private static final int PACKAGE_MANAGER_STOP_PERCENT = 6;
    private static final int RADIO_STOP_PERCENT = 18;
    private static final int MOUNT_SERVICE_STOP_PERCENT = 20;
    private static final int SHUTDOWN_VIBRATE_MS = 500;
    private static final Object sIsStartedGuard = new Object();
    private static boolean sIsStarted = false;
    private static boolean mReboot;
    private static boolean mRebootSafeMode;
    private static boolean mRebootHasProgressBar;
    private static String mReason;
    public static final String SHUTDOWN_ACTION_PROPERTY = "sys.shutdown.requested";
    public static final String REBOOT_SAFEMODE_PROPERTY = "persist.sys.safemode";
    public static final String RO_SAFEMODE_PROPERTY = "ro.sys.safemode";
    private static final ShutdownThread sInstance;
    private static final AudioAttributes VIBRATION_ATTRIBUTES;
    private static final ArrayMap<String, Long> TRON_METRICS;
    private static final String METRICS_FILE_BASENAME = "/data/system/shutdown-metrics";
    private static String METRIC_SYSTEM_SERVER;
    private static String METRIC_SEND_BROADCAST;
    private static String METRIC_AM;
    private static String METRIC_PM;
    private static String METRIC_RADIOS;
    private static String METRIC_RADIO;
    private static String METRIC_SHUTDOWN_TIME_START;
    private final Object mActionDoneSync = new Object();
    private boolean mActionDone;
    private Context mContext;
    private PowerManager mPowerManager;
    private PowerManager.WakeLock mCpuWakeLock;
    private PowerManager.WakeLock mScreenWakeLock;
    private Handler mHandler;
    private static AlertDialog sConfirmDialog;
    private ProgressDialog mProgressDialog;

    private ShutdownThread() {
    }

    public static void shutdown(Context context, String reason, boolean confirm) {
        mReboot = false;
        mRebootSafeMode = false;
        mReason = reason;
        ShutdownThread.shutdownInner(context, confirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownInner(final Context context, boolean confirm) {
        context.assertRuntimeOverlayThemable();
        Object object = sIsStartedGuard;
        synchronized (object) {
            if (sIsStarted) {
                Log.d(TAG, "Request to shutdown already running, returning.");
                return;
            }
        }
        int longPressBehavior = context.getResources().getInteger(17694824);
        int resourceId = mRebootSafeMode ? 17040894 : (longPressBehavior == 2 ? 17041021 : 17041020);
        Log.d(TAG, "Notifying thread to start shutdown longPressBehavior=" + longPressBehavior);
        if (confirm) {
            CloseDialogReceiver closer = new CloseDialogReceiver(context);
            if (sConfirmDialog != null) {
                sConfirmDialog.dismiss();
            }
            sConfirmDialog = new AlertDialog.Builder(context).setTitle(mRebootSafeMode ? 17040895 : 17040877).setMessage(resourceId).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    ShutdownThread.beginShutdownSequence(context);
                }
            }).setNegativeButton(17039369, null).create();
            closer.dialog = sConfirmDialog;
            sConfirmDialog.setOnDismissListener(closer);
            sConfirmDialog.getWindow().setType(2009);
            sConfirmDialog.show();
        } else {
            ShutdownThread.beginShutdownSequence(context);
        }
    }

    public static void reboot(Context context, String reason, boolean confirm) {
        mReboot = true;
        mRebootSafeMode = false;
        mRebootHasProgressBar = false;
        mReason = reason;
        ShutdownThread.shutdownInner(context, confirm);
    }

    public static void rebootSafeMode(Context context, boolean confirm) {
        UserManager um = (UserManager)context.getSystemService("user");
        if (um.hasUserRestriction("no_safe_boot")) {
            return;
        }
        mReboot = true;
        mRebootSafeMode = true;
        mRebootHasProgressBar = false;
        mReason = null;
        ShutdownThread.shutdownInner(context, confirm);
    }

    private static ProgressDialog showShutdownDialog(Context context) {
        ProgressDialog pd = new ProgressDialog(context);
        if (mReason != null && mReason.startsWith("recovery-update")) {
            mRebootHasProgressBar = RecoverySystem.UNCRYPT_PACKAGE_FILE.exists() && !RecoverySystem.BLOCK_MAP_FILE.exists();
            pd.setTitle(context.getText(17040901));
            if (mRebootHasProgressBar) {
                pd.setMax(100);
                pd.setProgress(0);
                pd.setIndeterminate(false);
                pd.setProgressNumberFormat(null);
                pd.setProgressStyle(1);
                pd.setMessage(context.getText(17040899));
            } else {
                if (ShutdownThread.showSysuiReboot()) {
                    return null;
                }
                pd.setIndeterminate(true);
                pd.setMessage(context.getText(17040900));
            }
        } else if (mReason != null && mReason.equals("recovery")) {
            if (RescueParty.isAttemptingFactoryReset()) {
                pd.setTitle(context.getText(17040877));
                pd.setMessage(context.getText(17041022));
                pd.setIndeterminate(true);
            } else {
                pd.setTitle(context.getText(17040897));
                pd.setMessage(context.getText(17040896));
                pd.setIndeterminate(true);
            }
        } else {
            if (ShutdownThread.showSysuiReboot()) {
                return null;
            }
            pd.setTitle(context.getText(17040877));
            pd.setMessage(context.getText(17041022));
            pd.setIndeterminate(true);
        }
        pd.setCancelable(false);
        pd.getWindow().setType(2009);
        pd.show();
        return pd;
    }

    private static boolean showSysuiReboot() {
        Log.d(TAG, "Attempting to use SysUI shutdown UI");
        try {
            StatusBarManagerInternal service = LocalServices.getService(StatusBarManagerInternal.class);
            if (service.showShutdownUi(mReboot, mReason)) {
                Log.d(TAG, "SysUI handling shutdown UI");
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.d(TAG, "SysUI is unavailable");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void beginShutdownSequence(Context context) {
        Object object = sIsStartedGuard;
        synchronized (object) {
            if (sIsStarted) {
                Log.d(TAG, "Shutdown sequence already running, returning.");
                return;
            }
            sIsStarted = true;
        }
        ShutdownThread.sInstance.mProgressDialog = ShutdownThread.showShutdownDialog(context);
        ShutdownThread.sInstance.mContext = context;
        ShutdownThread.sInstance.mPowerManager = (PowerManager)context.getSystemService("power");
        ShutdownThread.sInstance.mCpuWakeLock = null;
        try {
            ShutdownThread.sInstance.mCpuWakeLock = ShutdownThread.sInstance.mPowerManager.newWakeLock(1, "ShutdownThread-cpu");
            ShutdownThread.sInstance.mCpuWakeLock.setReferenceCounted(false);
            ShutdownThread.sInstance.mCpuWakeLock.acquire();
        }
        catch (SecurityException e) {
            Log.w(TAG, "No permission to acquire wake lock", e);
            ShutdownThread.sInstance.mCpuWakeLock = null;
        }
        ShutdownThread.sInstance.mScreenWakeLock = null;
        if (ShutdownThread.sInstance.mPowerManager.isScreenOn()) {
            try {
                ShutdownThread.sInstance.mScreenWakeLock = ShutdownThread.sInstance.mPowerManager.newWakeLock(26, "ShutdownThread-screen");
                ShutdownThread.sInstance.mScreenWakeLock.setReferenceCounted(false);
                ShutdownThread.sInstance.mScreenWakeLock.acquire();
            }
            catch (SecurityException e) {
                Log.w(TAG, "No permission to acquire wake lock", e);
                ShutdownThread.sInstance.mScreenWakeLock = null;
            }
        }
        if (SecurityLog.isLoggingEnabled()) {
            SecurityLog.writeEvent(210010, new Object[0]);
        }
        ShutdownThread.sInstance.mHandler = new Handler(){};
        sInstance.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void actionDone() {
        Object object = this.mActionDoneSync;
        synchronized (object) {
            this.mActionDone = true;
            this.mActionDoneSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        TimingsTraceLog shutdownTimingLog = ShutdownThread.newTimingsLog();
        shutdownTimingLog.traceBegin("SystemServerShutdown");
        ShutdownThread.metricShutdownStart();
        ShutdownThread.metricStarted(METRIC_SYSTEM_SERVER);
        BroadcastReceiver br = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                ShutdownThread.this.actionDone();
            }
        };
        String reason = (mReboot ? "1" : "0") + (mReason != null ? mReason : "");
        SystemProperties.set(SHUTDOWN_ACTION_PROPERTY, reason);
        if (mRebootSafeMode) {
            SystemProperties.set(REBOOT_SAFEMODE_PROPERTY, "1");
        }
        ShutdownThread.metricStarted(METRIC_SEND_BROADCAST);
        shutdownTimingLog.traceBegin("SendShutdownBroadcast");
        Log.i(TAG, "Sending shutdown broadcast...");
        this.mActionDone = false;
        Intent intent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        intent.addFlags(0x50000000);
        this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, null, br, this.mHandler, 0, null, null);
        long endTime = SystemClock.elapsedRealtime() + 10000L;
        Object object = this.mActionDoneSync;
        // MONITORENTER : object
        while (!this.mActionDone) {
            long delay = endTime - SystemClock.elapsedRealtime();
            if (delay <= 0L) {
                Log.w(TAG, "Shutdown broadcast timed out");
                break;
            }
            if (mRebootHasProgressBar) {
                int status = (int)((double)(10000L - delay) * 1.0 * 2.0 / 10000.0);
                sInstance.setRebootProgress(status, null);
            }
            try {
                this.mActionDoneSync.wait(Math.min(delay, 500L));
            }
            catch (InterruptedException interruptedException) {}
        }
        // MONITOREXIT : object
        if (mRebootHasProgressBar) {
            sInstance.setRebootProgress(2, null);
        }
        shutdownTimingLog.traceEnd();
        ShutdownThread.metricEnded(METRIC_SEND_BROADCAST);
        Log.i(TAG, "Shutting down activity manager...");
        shutdownTimingLog.traceBegin("ShutdownActivityManager");
        ShutdownThread.metricStarted(METRIC_AM);
        IActivityManager am = IActivityManager.Stub.asInterface(ServiceManager.checkService("activity"));
        if (am != null) {
            try {
                am.shutdown(10000);
            }
            catch (RemoteException delay) {
                // empty catch block
            }
        }
        if (mRebootHasProgressBar) {
            sInstance.setRebootProgress(4, null);
        }
        shutdownTimingLog.traceEnd();
        ShutdownThread.metricEnded(METRIC_AM);
        Log.i(TAG, "Shutting down package manager...");
        shutdownTimingLog.traceBegin("ShutdownPackageManager");
        ShutdownThread.metricStarted(METRIC_PM);
        PackageManagerService pm = (PackageManagerService)ServiceManager.getService("package");
        if (pm != null) {
            pm.shutdown();
        }
        if (mRebootHasProgressBar) {
            sInstance.setRebootProgress(6, null);
        }
        shutdownTimingLog.traceEnd();
        ShutdownThread.metricEnded(METRIC_PM);
        shutdownTimingLog.traceBegin("ShutdownRadios");
        ShutdownThread.metricStarted(METRIC_RADIOS);
        this.shutdownRadios(12000);
        if (mRebootHasProgressBar) {
            sInstance.setRebootProgress(18, null);
        }
        shutdownTimingLog.traceEnd();
        ShutdownThread.metricEnded(METRIC_RADIOS);
        if (mRebootHasProgressBar) {
            sInstance.setRebootProgress(20, null);
            this.uncrypt();
        }
        shutdownTimingLog.traceEnd();
        ShutdownThread.metricEnded(METRIC_SYSTEM_SERVER);
        ShutdownThread.saveMetrics(mReboot, mReason);
        ShutdownThread.rebootOrShutdown(this.mContext, mReboot, mReason);
    }

    private static TimingsTraceLog newTimingsLog() {
        return new TimingsTraceLog("ShutdownTiming", 524288L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void metricStarted(String metricKey) {
        ArrayMap<String, Long> arrayMap = TRON_METRICS;
        synchronized (arrayMap) {
            TRON_METRICS.put(metricKey, -1L * SystemClock.elapsedRealtime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void metricEnded(String metricKey) {
        ArrayMap<String, Long> arrayMap = TRON_METRICS;
        synchronized (arrayMap) {
            TRON_METRICS.put(metricKey, SystemClock.elapsedRealtime() + TRON_METRICS.get(metricKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void metricShutdownStart() {
        ArrayMap<String, Long> arrayMap = TRON_METRICS;
        synchronized (arrayMap) {
            TRON_METRICS.put(METRIC_SHUTDOWN_TIME_START, System.currentTimeMillis());
        }
    }

    private void setRebootProgress(final int progress, final CharSequence message) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ShutdownThread.this.mProgressDialog != null) {
                    ShutdownThread.this.mProgressDialog.setProgress(progress);
                    if (message != null) {
                        ShutdownThread.this.mProgressDialog.setMessage(message);
                    }
                }
            }
        });
    }

    private void shutdownRadios(final int timeout) {
        final long endTime = SystemClock.elapsedRealtime() + (long)timeout;
        final boolean[] done = new boolean[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                boolean radioOff;
                TimingsTraceLog shutdownTimingsTraceLog = ShutdownThread.newTimingsLog();
                ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
                try {
                    boolean bl = radioOff = phone == null || !phone.needMobileRadioShutdown();
                    if (!radioOff) {
                        Log.w(ShutdownThread.TAG, "Turning off cellular radios...");
                        ShutdownThread.metricStarted(METRIC_RADIO);
                        phone.shutdownMobileRadios();
                    }
                }
                catch (RemoteException ex) {
                    Log.e(ShutdownThread.TAG, "RemoteException during radio shutdown", ex);
                    radioOff = true;
                }
                Log.i(ShutdownThread.TAG, "Waiting for Radio...");
                long delay = endTime - SystemClock.elapsedRealtime();
                while (delay > 0L) {
                    if (mRebootHasProgressBar) {
                        int status = (int)((double)((long)timeout - delay) * 1.0 * 12.0 / (double)timeout);
                        sInstance.setRebootProgress(status += 6, null);
                    }
                    if (!radioOff) {
                        try {
                            radioOff = !phone.needMobileRadioShutdown();
                        }
                        catch (RemoteException ex) {
                            Log.e(ShutdownThread.TAG, "RemoteException during radio shutdown", ex);
                            radioOff = true;
                        }
                        if (radioOff) {
                            Log.i(ShutdownThread.TAG, "Radio turned off.");
                            ShutdownThread.metricEnded(METRIC_RADIO);
                            shutdownTimingsTraceLog.logDuration("ShutdownRadio", (Long)TRON_METRICS.get(METRIC_RADIO));
                        }
                    }
                    if (radioOff) {
                        Log.i(ShutdownThread.TAG, "Radio shutdown complete.");
                        done[0] = true;
                        break;
                    }
                    SystemClock.sleep(100L);
                    delay = endTime - SystemClock.elapsedRealtime();
                }
            }
        };
        t.start();
        try {
            t.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!done[0]) {
            Log.w(TAG, "Timed out waiting for Radio shutdown.");
        }
    }

    public static void rebootOrShutdown(Context context, boolean reboot, String reason) {
        if (reboot) {
            Log.i(TAG, "Rebooting, reason: " + reason);
            PowerManagerService.lowLevelReboot(reason);
            Log.e(TAG, "Reboot failed, will attempt shutdown instead");
            reason = null;
        } else if (context != null) {
            SystemVibrator vibrator = new SystemVibrator(context);
            try {
                vibrator.vibrate(500L, VIBRATION_ATTRIBUTES);
            }
            catch (Exception e) {
                Log.w(TAG, "Failed to vibrate during shutdown.", e);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Log.i(TAG, "Performing low-level shutdown...");
        PowerManagerService.lowLevelShutdown(reason);
    }

    private static void saveMetrics(boolean reboot, String reason) {
        StringBuilder metricValue = new StringBuilder();
        metricValue.append("reboot:");
        metricValue.append(reboot ? "y" : "n");
        metricValue.append(",").append("reason:").append(reason);
        int metricsSize = TRON_METRICS.size();
        for (int i = 0; i < metricsSize; ++i) {
            String name = TRON_METRICS.keyAt(i);
            long value = TRON_METRICS.valueAt(i);
            if (value < 0L) {
                Log.e(TAG, "metricEnded wasn't called for " + name);
                continue;
            }
            metricValue.append(',').append(name).append(':').append(value);
        }
        File tmp = new File("/data/system/shutdown-metrics.tmp");
        boolean saved = false;
        try (FileOutputStream fos = new FileOutputStream(tmp);){
            fos.write(metricValue.toString().getBytes(StandardCharsets.UTF_8));
            saved = true;
        }
        catch (IOException e) {
            Log.e(TAG, "Cannot save shutdown metrics", e);
        }
        if (saved) {
            tmp.renameTo(new File("/data/system/shutdown-metrics.txt"));
        }
    }

    private void uncrypt() {
        Log.i(TAG, "Calling uncrypt and monitoring the progress...");
        final RecoverySystem.ProgressListener progressListener = new RecoverySystem.ProgressListener(){

            @Override
            public void onProgress(int status) {
                if (status >= 0 && status < 100) {
                    status = (int)((double)status * 80.0 / 100.0);
                    CharSequence msg = ShutdownThread.this.mContext.getText(17040898);
                    sInstance.setRebootProgress(status += 20, msg);
                } else if (status == 100) {
                    CharSequence msg = ShutdownThread.this.mContext.getText(17040900);
                    sInstance.setRebootProgress(status, msg);
                }
            }
        };
        final boolean[] done = new boolean[]{false};
        Thread t = new Thread(){

            @Override
            public void run() {
                RecoverySystem rs = (RecoverySystem)ShutdownThread.this.mContext.getSystemService("recovery");
                String filename = null;
                try {
                    filename = FileUtils.readTextFile(RecoverySystem.UNCRYPT_PACKAGE_FILE, 0, null);
                    RecoverySystem.processPackage(ShutdownThread.this.mContext, new File(filename), progressListener);
                }
                catch (IOException e) {
                    Log.e(ShutdownThread.TAG, "Error uncrypting file", e);
                }
                done[0] = true;
            }
        };
        t.start();
        try {
            t.join(900000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!done[0]) {
            Log.w(TAG, "Timed out waiting for uncrypt.");
            int uncryptTimeoutError = 100;
            String timeoutMessage = String.format("uncrypt_time: %d\nuncrypt_error: %d\n", 900, 100);
            try {
                FileUtils.stringToFile(RecoverySystem.UNCRYPT_STATUS_FILE, timeoutMessage);
            }
            catch (IOException e) {
                Log.e(TAG, "Failed to write timeout message to uncrypt status", e);
            }
        }
    }

    static {
        sInstance = new ShutdownThread();
        VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
        TRON_METRICS = new ArrayMap();
        METRIC_SYSTEM_SERVER = "shutdown_system_server";
        METRIC_SEND_BROADCAST = "shutdown_send_shutdown_broadcast";
        METRIC_AM = "shutdown_activity_manager";
        METRIC_PM = "shutdown_package_manager";
        METRIC_RADIOS = "shutdown_radios";
        METRIC_RADIO = "shutdown_radio";
        METRIC_SHUTDOWN_TIME_START = "begin_shutdown";
    }

    private static class CloseDialogReceiver
    extends BroadcastReceiver
    implements DialogInterface.OnDismissListener {
        private Context mContext;
        public Dialog dialog;

        CloseDialogReceiver(Context context) {
            this.mContext = context;
            IntentFilter filter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
            context.registerReceiver(this, filter);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            this.dialog.cancel();
        }

        @Override
        public void onDismiss(DialogInterface unused) {
            this.mContext.unregisterReceiver(this);
        }
    }
}

