/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.content.Context;
import android.hardware.thermal.V1_0.IThermal;
import android.hardware.thermal.V1_1.IThermalCallback;
import android.hardware.thermal.V2_0.CoolingDevice;
import android.hardware.thermal.V2_0.IThermalChangedCallback;
import android.os.Binder;
import android.os.IHwBinder;
import android.os.IThermalEventListener;
import android.os.IThermalService;
import android.os.IThermalStatusListener;
import android.os.PowerManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.Temperature;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.DumpUtils;
import com.android.server.FgThread;
import com.android.server.SystemService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThermalManagerService
extends SystemService {
    private static final String TAG = ThermalManagerService.class.getSimpleName();
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final RemoteCallbackList<IThermalEventListener> mThermalEventListeners = new RemoteCallbackList();
    @GuardedBy(value={"mLock"})
    private final RemoteCallbackList<IThermalStatusListener> mThermalStatusListeners = new RemoteCallbackList();
    @GuardedBy(value={"mLock"})
    private int mStatus;
    @GuardedBy(value={"mLock"})
    private boolean mIsStatusOverride;
    @GuardedBy(value={"mLock"})
    private ArrayMap<String, Temperature> mTemperatureMap = new ArrayMap();
    private ThermalHalWrapper mHalWrapper;
    private final AtomicBoolean mHalReady = new AtomicBoolean();
    private static final int INVALID_THROTTLING = Integer.MIN_VALUE;
    @VisibleForTesting
    final IThermalService.Stub mService = new IThermalService.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean registerThermalEventListener(IThermalEventListener listener) {
            ThermalManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            Object object = ThermalManagerService.this.mLock;
            synchronized (object) {
                long token = Binder.clearCallingIdentity();
                try {
                    if (!ThermalManagerService.this.mThermalEventListeners.register(listener, null)) {
                        boolean bl = false;
                        return bl;
                    }
                    ThermalManagerService.this.postEventListenerCurrentTemperatures(listener, null);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean registerThermalEventListenerWithType(IThermalEventListener listener, int type) {
            ThermalManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            Object object = ThermalManagerService.this.mLock;
            synchronized (object) {
                long token = Binder.clearCallingIdentity();
                try {
                    if (!ThermalManagerService.this.mThermalEventListeners.register(listener, new Integer(type))) {
                        boolean bl = false;
                        return bl;
                    }
                    ThermalManagerService.this.postEventListenerCurrentTemperatures(listener, new Integer(type));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean unregisterThermalEventListener(IThermalEventListener listener) {
            ThermalManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            Object object = ThermalManagerService.this.mLock;
            synchronized (object) {
                boolean bl;
                long token = Binder.clearCallingIdentity();
                try {
                    bl = ThermalManagerService.this.mThermalEventListeners.unregister(listener);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(token);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(token);
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Temperature> getCurrentTemperatures() {
            ThermalManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long token = Binder.clearCallingIdentity();
            try {
                if (!ThermalManagerService.this.mHalReady.get()) {
                    ArrayList<Temperature> arrayList = new ArrayList<Temperature>();
                    return arrayList;
                }
                List<Temperature> list = ThermalManagerService.this.mHalWrapper.getCurrentTemperatures(false, 0);
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Temperature> getCurrentTemperaturesWithType(int type) {
            ThermalManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long token = Binder.clearCallingIdentity();
            try {
                if (!ThermalManagerService.this.mHalReady.get()) {
                    ArrayList<Temperature> arrayList = new ArrayList<Temperature>();
                    return arrayList;
                }
                List<Temperature> list = ThermalManagerService.this.mHalWrapper.getCurrentTemperatures(true, type);
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean registerThermalStatusListener(IThermalStatusListener listener) {
            Object object = ThermalManagerService.this.mLock;
            synchronized (object) {
                long token = Binder.clearCallingIdentity();
                try {
                    if (!ThermalManagerService.this.mThermalStatusListeners.register(listener)) {
                        boolean bl = false;
                        return bl;
                    }
                    ThermalManagerService.this.postStatusListener(listener);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean unregisterThermalStatusListener(IThermalStatusListener listener) {
            Object object = ThermalManagerService.this.mLock;
            synchronized (object) {
                boolean bl;
                long token = Binder.clearCallingIdentity();
                try {
                    bl = ThermalManagerService.this.mThermalStatusListeners.unregister(listener);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(token);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(token);
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCurrentThermalStatus() {
            Object object = ThermalManagerService.this.mLock;
            synchronized (object) {
                int n;
                long token = Binder.clearCallingIdentity();
                try {
                    n = Temperature.isValidStatus(ThermalManagerService.this.mStatus) ? ThermalManagerService.this.mStatus : 0;
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(token);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(token);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<android.os.CoolingDevice> getCurrentCoolingDevices() {
            ThermalManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long token = Binder.clearCallingIdentity();
            try {
                if (!ThermalManagerService.this.mHalReady.get()) {
                    ArrayList<android.os.CoolingDevice> arrayList = new ArrayList<android.os.CoolingDevice>();
                    return arrayList;
                }
                List<android.os.CoolingDevice> list = ThermalManagerService.this.mHalWrapper.getCurrentCoolingDevices(false, 0);
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<android.os.CoolingDevice> getCurrentCoolingDevicesWithType(int type) {
            ThermalManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long token = Binder.clearCallingIdentity();
            try {
                if (!ThermalManagerService.this.mHalReady.get()) {
                    ArrayList<android.os.CoolingDevice> arrayList = new ArrayList<android.os.CoolingDevice>();
                    return arrayList;
                }
                List<android.os.CoolingDevice> list = ThermalManagerService.this.mHalWrapper.getCurrentCoolingDevices(true, type);
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        private void dumpItemsLocked(PrintWriter pw, String prefix, Collection<?> items) {
            Iterator<?> iterator = items.iterator();
            while (iterator.hasNext()) {
                pw.println(prefix + iterator.next().toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(ThermalManagerService.this.getContext(), TAG, pw)) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                Object object = ThermalManagerService.this.mLock;
                synchronized (object) {
                    pw.println("IsStatusOverride: " + ThermalManagerService.this.mIsStatusOverride);
                    pw.println("ThermalEventListeners:");
                    ThermalManagerService.this.mThermalEventListeners.dump(pw, "\t");
                    pw.println("ThermalStatusListeners:");
                    ThermalManagerService.this.mThermalStatusListeners.dump(pw, "\t");
                    pw.println("Thermal Status: " + ThermalManagerService.this.mStatus);
                    pw.println("Cached temperatures:");
                    this.dumpItemsLocked(pw, "\t", ThermalManagerService.this.mTemperatureMap.values());
                    pw.println("HAL Ready: " + ThermalManagerService.this.mHalReady.get());
                    if (ThermalManagerService.this.mHalReady.get()) {
                        pw.println("HAL connection:");
                        ThermalManagerService.this.mHalWrapper.dump(pw, "\t");
                        pw.println("Current temperatures from HAL:");
                        this.dumpItemsLocked(pw, "\t", ThermalManagerService.this.mHalWrapper.getCurrentTemperatures(false, 0));
                        pw.println("Current cooling devices from HAL:");
                        this.dumpItemsLocked(pw, "\t", ThermalManagerService.this.mHalWrapper.getCurrentCoolingDevices(false, 0));
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        private boolean isCallerShell() {
            int callingUid = Binder.getCallingUid();
            return callingUid == 2000 || callingUid == 0;
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            if (!this.isCallerShell()) {
                Slog.w(TAG, "Only shell is allowed to call thermalservice shell commands");
                return;
            }
            new ThermalShellCommand().exec(this, in, out, err, args, callback, resultReceiver);
        }
    };

    public ThermalManagerService(Context context) {
        this(context, null);
    }

    @VisibleForTesting
    ThermalManagerService(Context context, ThermalHalWrapper halWrapper) {
        super(context);
        this.mHalWrapper = halWrapper;
        this.mStatus = Integer.MIN_VALUE;
    }

    @Override
    public void onStart() {
        this.publishBinderService("thermalservice", this.mService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 550) {
            this.onActivityManagerReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onActivityManagerReady() {
        Object object = this.mLock;
        synchronized (object) {
            boolean halConnected;
            boolean bl = halConnected = this.mHalWrapper != null;
            if (!halConnected) {
                this.mHalWrapper = new ThermalHal20Wrapper();
                halConnected = this.mHalWrapper.connectToHal();
            }
            if (!halConnected) {
                this.mHalWrapper = new ThermalHal11Wrapper();
                halConnected = this.mHalWrapper.connectToHal();
            }
            if (!halConnected) {
                this.mHalWrapper = new ThermalHal10Wrapper();
                halConnected = this.mHalWrapper.connectToHal();
            }
            this.mHalWrapper.setCallback(this::onTemperatureChangedCallback);
            if (!halConnected) {
                return;
            }
            List<Temperature> temperatures = this.mHalWrapper.getCurrentTemperatures(false, 0);
            int count = temperatures.size();
            for (int i = 0; i < count; ++i) {
                this.onTemperatureChanged(temperatures.get(i), false);
            }
            this.onTemperatureMapChangedLocked();
            this.mHalReady.set(true);
        }
    }

    private void postStatusListener(IThermalStatusListener listener) {
        boolean thermalCallbackQueued = FgThread.getHandler().post(() -> {
            try {
                listener.onStatusChange(this.mStatus);
            }
            catch (RemoteException | RuntimeException e) {
                Slog.e(TAG, "Thermal callback failed to call", e);
            }
        });
        if (!thermalCallbackQueued) {
            Slog.e(TAG, "Thermal callback failed to queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStatusListenersLocked() {
        if (!Temperature.isValidStatus(this.mStatus)) {
            return;
        }
        int length = this.mThermalStatusListeners.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                IThermalStatusListener listener = this.mThermalStatusListeners.getBroadcastItem(i);
                this.postStatusListener(listener);
            }
        }
        finally {
            this.mThermalStatusListeners.finishBroadcast();
        }
    }

    private void onTemperatureMapChangedLocked() {
        int newStatus = Integer.MIN_VALUE;
        int count = this.mTemperatureMap.size();
        for (int i = 0; i < count; ++i) {
            Temperature t = this.mTemperatureMap.valueAt(i);
            if (t.getStatus() < newStatus) continue;
            newStatus = t.getStatus();
        }
        if (!this.mIsStatusOverride) {
            this.setStatusLocked(newStatus);
        }
    }

    private void setStatusLocked(int newStatus) {
        if (newStatus != this.mStatus) {
            this.mStatus = newStatus;
            this.notifyStatusListenersLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEventListenerCurrentTemperatures(IThermalEventListener listener, Integer type) {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mTemperatureMap.size();
            for (int i = 0; i < count; ++i) {
                this.postEventListener(this.mTemperatureMap.valueAt(i), listener, type);
            }
        }
    }

    private void postEventListener(Temperature temperature, IThermalEventListener listener, Integer type) {
        if (type != null && type.intValue() != temperature.getType()) {
            return;
        }
        boolean thermalCallbackQueued = FgThread.getHandler().post(() -> {
            try {
                listener.notifyThrottling(temperature);
            }
            catch (RemoteException | RuntimeException e) {
                Slog.e(TAG, "Thermal callback failed to call", e);
            }
        });
        if (!thermalCallbackQueued) {
            Slog.e(TAG, "Thermal callback failed to queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEventListenersLocked(Temperature temperature) {
        int length = this.mThermalEventListeners.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                IThermalEventListener listener = this.mThermalEventListeners.getBroadcastItem(i);
                Integer type = (Integer)this.mThermalEventListeners.getBroadcastCookie(i);
                this.postEventListener(temperature, listener, type);
            }
        }
        finally {
            this.mThermalEventListeners.finishBroadcast();
        }
    }

    private void shutdownIfNeeded(Temperature temperature) {
        if (temperature.getStatus() != 6) {
            return;
        }
        PowerManager powerManager = this.getContext().getSystemService(PowerManager.class);
        switch (temperature.getType()) {
            case 0: 
            case 1: 
            case 3: 
            case 9: {
                powerManager.shutdown(false, "thermal", false);
                break;
            }
            case 2: {
                powerManager.shutdown(false, "thermal,battery", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTemperatureChanged(Temperature temperature, boolean sendStatus) {
        this.shutdownIfNeeded(temperature);
        Object object = this.mLock;
        synchronized (object) {
            Temperature old = this.mTemperatureMap.put(temperature.getName(), temperature);
            if (old != null) {
                if (old.getStatus() != temperature.getStatus()) {
                    this.notifyEventListenersLocked(temperature);
                }
            } else {
                this.notifyEventListenersLocked(temperature);
            }
            if (sendStatus) {
                this.onTemperatureMapChangedLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTemperatureChangedCallback(Temperature temperature) {
        long token = Binder.clearCallingIdentity();
        try {
            this.onTemperatureChanged(temperature, true);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    static class ThermalHal20Wrapper
    extends ThermalHalWrapper {
        @GuardedBy(value={"mHalLock"})
        private android.hardware.thermal.V2_0.IThermal mThermalHal20 = null;
        private final IThermalChangedCallback.Stub mThermalCallback20 = new IThermalChangedCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyThrottling(android.hardware.thermal.V2_0.Temperature temperature) {
                Temperature thermalSvcTemp = new Temperature(temperature.value, temperature.type, temperature.name, temperature.throttlingStatus);
                long token = Binder.clearCallingIdentity();
                try {
                    mCallback.onValues(thermalSvcTemp);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };

        ThermalHal20Wrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<Temperature> getCurrentTemperatures(boolean shouldFilter, int type) {
            Object object = this.mHalLock;
            synchronized (object) {
                ArrayList<Temperature> ret = new ArrayList<Temperature>();
                if (this.mThermalHal20 == null) {
                    return ret;
                }
                try {
                    this.mThermalHal20.getCurrentTemperatures(shouldFilter, type, (status, temperatures) -> {
                        if (0 == status.code) {
                            for (android.hardware.thermal.V2_0.Temperature temperature : temperatures) {
                                ret.add(new Temperature(temperature.value, temperature.type, temperature.name, temperature.throttlingStatus));
                            }
                        } else {
                            Slog.e(TAG, "Couldn't get temperatures because of HAL error: " + status.debugMessage);
                        }
                    });
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Couldn't getCurrentTemperatures, reconnecting...", e);
                    this.connectToHal();
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<android.os.CoolingDevice> getCurrentCoolingDevices(boolean shouldFilter, int type) {
            Object object = this.mHalLock;
            synchronized (object) {
                ArrayList<android.os.CoolingDevice> ret = new ArrayList<android.os.CoolingDevice>();
                if (this.mThermalHal20 == null) {
                    return ret;
                }
                try {
                    this.mThermalHal20.getCurrentCoolingDevices(shouldFilter, type, (status, coolingDevices) -> {
                        if (0 == status.code) {
                            for (CoolingDevice coolingDevice : coolingDevices) {
                                ret.add(new android.os.CoolingDevice(coolingDevice.value, coolingDevice.type, coolingDevice.name));
                            }
                        } else {
                            Slog.e(TAG, "Couldn't get cooling device because of HAL error: " + status.debugMessage);
                        }
                    });
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Couldn't getCurrentCoolingDevices, reconnecting...", e);
                    this.connectToHal();
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean connectToHal() {
            Object object = this.mHalLock;
            synchronized (object) {
                try {
                    this.mThermalHal20 = android.hardware.thermal.V2_0.IThermal.getService();
                    this.mThermalHal20.linkToDeath(new ThermalHalWrapper.DeathRecipient(), 5612L);
                    this.mThermalHal20.registerThermalChangedCallback(this.mThermalCallback20, false, 0);
                }
                catch (RemoteException | NoSuchElementException e) {
                    Slog.e(TAG, "Thermal HAL 2.0 service not connected, trying 1.1.");
                    this.mThermalHal20 = null;
                }
                return this.mThermalHal20 != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(PrintWriter pw, String prefix) {
            Object object = this.mHalLock;
            synchronized (object) {
                pw.print(prefix);
                pw.println("ThermalHAL 2.0 connected: " + (this.mThermalHal20 != null ? "yes" : "no"));
            }
        }
    }

    static class ThermalHal11Wrapper
    extends ThermalHalWrapper {
        @GuardedBy(value={"mHalLock"})
        private android.hardware.thermal.V1_1.IThermal mThermalHal11 = null;
        private final IThermalCallback.Stub mThermalCallback11 = new IThermalCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyThrottling(boolean isThrottling, android.hardware.thermal.V1_0.Temperature temperature) {
                Temperature thermalSvcTemp = new Temperature(temperature.currentValue, temperature.type, temperature.name, isThrottling ? 3 : 0);
                long token = Binder.clearCallingIdentity();
                try {
                    mCallback.onValues(thermalSvcTemp);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };

        ThermalHal11Wrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<Temperature> getCurrentTemperatures(boolean shouldFilter, int type) {
            Object object = this.mHalLock;
            synchronized (object) {
                ArrayList<Temperature> ret = new ArrayList<Temperature>();
                if (this.mThermalHal11 == null) {
                    return ret;
                }
                try {
                    this.mThermalHal11.getTemperatures((status, temperatures) -> {
                        if (0 == status.code) {
                            for (android.hardware.thermal.V1_0.Temperature temperature : temperatures) {
                                if (shouldFilter && type != temperature.type) continue;
                                ret.add(new Temperature(temperature.currentValue, temperature.type, temperature.name, 0));
                            }
                        } else {
                            Slog.e(TAG, "Couldn't get temperatures because of HAL error: " + status.debugMessage);
                        }
                    });
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Couldn't getCurrentTemperatures, reconnecting...", e);
                    this.connectToHal();
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<android.os.CoolingDevice> getCurrentCoolingDevices(boolean shouldFilter, int type) {
            Object object = this.mHalLock;
            synchronized (object) {
                ArrayList<android.os.CoolingDevice> ret = new ArrayList<android.os.CoolingDevice>();
                if (this.mThermalHal11 == null) {
                    return ret;
                }
                try {
                    this.mThermalHal11.getCoolingDevices((status, coolingDevices) -> {
                        if (0 == status.code) {
                            for (android.hardware.thermal.V1_0.CoolingDevice coolingDevice : coolingDevices) {
                                if (shouldFilter && type != coolingDevice.type) continue;
                                ret.add(new android.os.CoolingDevice((long)coolingDevice.currentValue, coolingDevice.type, coolingDevice.name));
                            }
                        } else {
                            Slog.e(TAG, "Couldn't get cooling device because of HAL error: " + status.debugMessage);
                        }
                    });
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Couldn't getCurrentCoolingDevices, reconnecting...", e);
                    this.connectToHal();
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean connectToHal() {
            Object object = this.mHalLock;
            synchronized (object) {
                try {
                    this.mThermalHal11 = android.hardware.thermal.V1_1.IThermal.getService();
                    this.mThermalHal11.linkToDeath(new ThermalHalWrapper.DeathRecipient(), 5612L);
                    this.mThermalHal11.registerThermalCallback(this.mThermalCallback11);
                }
                catch (RemoteException | NoSuchElementException e) {
                    Slog.e(TAG, "Thermal HAL 1.1 service not connected, no thermal call back will be called.");
                    this.mThermalHal11 = null;
                }
                return this.mThermalHal11 != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(PrintWriter pw, String prefix) {
            Object object = this.mHalLock;
            synchronized (object) {
                pw.print(prefix);
                pw.println("ThermalHAL 1.1 connected: " + (this.mThermalHal11 != null ? "yes" : "no"));
            }
        }
    }

    static class ThermalHal10Wrapper
    extends ThermalHalWrapper {
        @GuardedBy(value={"mHalLock"})
        private IThermal mThermalHal10 = null;

        ThermalHal10Wrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<Temperature> getCurrentTemperatures(boolean shouldFilter, int type) {
            Object object = this.mHalLock;
            synchronized (object) {
                ArrayList<Temperature> ret = new ArrayList<Temperature>();
                if (this.mThermalHal10 == null) {
                    return ret;
                }
                try {
                    this.mThermalHal10.getTemperatures((status, temperatures) -> {
                        if (0 == status.code) {
                            for (android.hardware.thermal.V1_0.Temperature temperature : temperatures) {
                                if (shouldFilter && type != temperature.type) continue;
                                ret.add(new Temperature(temperature.currentValue, temperature.type, temperature.name, 0));
                            }
                        } else {
                            Slog.e(TAG, "Couldn't get temperatures because of HAL error: " + status.debugMessage);
                        }
                    });
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Couldn't getCurrentTemperatures, reconnecting...", e);
                    this.connectToHal();
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<android.os.CoolingDevice> getCurrentCoolingDevices(boolean shouldFilter, int type) {
            Object object = this.mHalLock;
            synchronized (object) {
                ArrayList<android.os.CoolingDevice> ret = new ArrayList<android.os.CoolingDevice>();
                if (this.mThermalHal10 == null) {
                    return ret;
                }
                try {
                    this.mThermalHal10.getCoolingDevices((status, coolingDevices) -> {
                        if (0 == status.code) {
                            for (android.hardware.thermal.V1_0.CoolingDevice coolingDevice : coolingDevices) {
                                if (shouldFilter && type != coolingDevice.type) continue;
                                ret.add(new android.os.CoolingDevice((long)coolingDevice.currentValue, coolingDevice.type, coolingDevice.name));
                            }
                        } else {
                            Slog.e(TAG, "Couldn't get cooling device because of HAL error: " + status.debugMessage);
                        }
                    });
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Couldn't getCurrentCoolingDevices, reconnecting...", e);
                    this.connectToHal();
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean connectToHal() {
            Object object = this.mHalLock;
            synchronized (object) {
                try {
                    this.mThermalHal10 = IThermal.getService();
                    this.mThermalHal10.linkToDeath(new ThermalHalWrapper.DeathRecipient(), 5612L);
                    Slog.i(TAG, "Thermal HAL 1.0 service connected, no thermal call back will be called due to legacy API.");
                }
                catch (RemoteException | NoSuchElementException e) {
                    Slog.e(TAG, "Thermal HAL 1.0 service not connected.");
                    this.mThermalHal10 = null;
                }
                return this.mThermalHal10 != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(PrintWriter pw, String prefix) {
            Object object = this.mHalLock;
            synchronized (object) {
                pw.print(prefix);
                pw.println("ThermalHAL 1.0 connected: " + (this.mThermalHal10 != null ? "yes" : "no"));
            }
        }
    }

    static abstract class ThermalHalWrapper {
        protected static final String TAG = ThermalHalWrapper.class.getSimpleName();
        protected final Object mHalLock = new Object();
        protected TemperatureChangedCallback mCallback;
        protected static final int THERMAL_HAL_DEATH_COOKIE = 5612;

        ThermalHalWrapper() {
        }

        @VisibleForTesting
        protected void setCallback(TemperatureChangedCallback cb) {
            this.mCallback = cb;
        }

        protected abstract List<Temperature> getCurrentTemperatures(boolean var1, int var2);

        protected abstract List<android.os.CoolingDevice> getCurrentCoolingDevices(boolean var1, int var2);

        protected abstract boolean connectToHal();

        protected abstract void dump(PrintWriter var1, String var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resendCurrentTemperatures() {
            Object object = this.mHalLock;
            synchronized (object) {
                List<Temperature> temperatures = this.getCurrentTemperatures(false, 0);
                int count = temperatures.size();
                for (int i = 0; i < count; ++i) {
                    this.mCallback.onValues(temperatures.get(i));
                }
            }
        }

        final class DeathRecipient
        implements IHwBinder.DeathRecipient {
            DeathRecipient() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serviceDied(long cookie) {
                if (cookie == 5612L) {
                    Slog.e(TAG, "Thermal HAL service died cookie: " + cookie);
                    Object object = ThermalHalWrapper.this.mHalLock;
                    synchronized (object) {
                        ThermalHalWrapper.this.connectToHal();
                        ThermalHalWrapper.this.resendCurrentTemperatures();
                    }
                }
            }
        }

        @FunctionalInterface
        static interface TemperatureChangedCallback {
            public void onValues(Temperature var1);
        }
    }

    class ThermalShellCommand
    extends ShellCommand {
        ThermalShellCommand() {
        }

        @Override
        public int onCommand(String cmd) {
            switch (cmd != null ? cmd : "") {
                case "override-status": {
                    return this.runOverrideStatus();
                }
                case "reset": {
                    return this.runReset();
                }
            }
            return this.handleDefaultCommands(cmd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int runReset() {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = ThermalManagerService.this.mLock;
                synchronized (object) {
                    ThermalManagerService.this.mIsStatusOverride = false;
                    ThermalManagerService.this.onTemperatureMapChangedLocked();
                    int n = 0;
                    return n;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int runOverrideStatus() {
            long token = Binder.clearCallingIdentity();
            try {
                int status;
                PrintWriter pw = this.getOutPrintWriter();
                try {
                    status = Integer.parseInt(this.getNextArgRequired());
                }
                catch (RuntimeException ex) {
                    pw.println("Error: " + ex.toString());
                    int n = -1;
                    Binder.restoreCallingIdentity(token);
                    return n;
                }
                if (!Temperature.isValidStatus(status)) {
                    pw.println("Invalid status: " + status);
                    int n = -1;
                    return n;
                }
                Object object = ThermalManagerService.this.mLock;
                synchronized (object) {
                    ThermalManagerService.this.mIsStatusOverride = true;
                    ThermalManagerService.this.setStatusLocked(status);
                }
                int n = 0;
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("Thermal service (thermalservice) commands:");
            pw.println("  help");
            pw.println("    Print this help text.");
            pw.println("");
            pw.println("  override-status STATUS");
            pw.println("    sets and locks the thermal status of the device to STATUS.");
            pw.println("    status code is defined in android.os.Temperature.");
            pw.println("  reset");
            pw.println("    unlocks the thermal status of the device.");
            pw.println();
        }
    }
}

