/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power.batterysaver;

import android.app.ActivityManagerInternal;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.BatterySaverPolicyConfig;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.power.batterysaver.BatterySaverLocationPlugin;
import com.android.server.power.batterysaver.BatterySaverPolicy;
import com.android.server.power.batterysaver.BatterySavingStats;
import com.android.server.power.batterysaver.FileUpdater;
import java.util.ArrayList;

public class BatterySaverController
implements BatterySaverPolicy.BatterySaverPolicyListener {
    static final String TAG = "BatterySaverController";
    static final boolean DEBUG = false;
    private final Object mLock;
    private final Context mContext;
    private final MyHandler mHandler;
    private final FileUpdater mFileUpdater;
    private PowerManager mPowerManager;
    private final BatterySaverPolicy mBatterySaverPolicy;
    private final BatterySavingStats mBatterySavingStats;
    @GuardedBy(value={"mLock"})
    private final ArrayList<PowerManagerInternal.LowPowerModeListener> mListeners = new ArrayList();
    @GuardedBy(value={"mLock"})
    private boolean mFullEnabled;
    @GuardedBy(value={"mLock"})
    private boolean mAdaptiveEnabled;
    @GuardedBy(value={"mLock"})
    private boolean mIsPluggedIn;
    private boolean mFullPreviouslyEnabled;
    private boolean mAdaptivePreviouslyEnabled;
    @GuardedBy(value={"mLock"})
    private boolean mIsInteractive;
    private final Plugin[] mPlugins;
    public static final int REASON_PERCENTAGE_AUTOMATIC_ON = 0;
    public static final int REASON_PERCENTAGE_AUTOMATIC_OFF = 1;
    public static final int REASON_MANUAL_ON = 2;
    public static final int REASON_MANUAL_OFF = 3;
    public static final int REASON_STICKY_RESTORE = 4;
    public static final int REASON_INTERACTIVE_CHANGED = 5;
    public static final int REASON_POLICY_CHANGED = 6;
    public static final int REASON_PLUGGED_IN = 7;
    public static final int REASON_SETTING_CHANGED = 8;
    public static final int REASON_DYNAMIC_POWER_SAVINGS_AUTOMATIC_ON = 9;
    public static final int REASON_DYNAMIC_POWER_SAVINGS_AUTOMATIC_OFF = 10;
    public static final int REASON_ADAPTIVE_DYNAMIC_POWER_SAVINGS_CHANGED = 11;
    public static final int REASON_TIMEOUT = 12;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.intent.action.SCREEN_ON": 
                case "android.intent.action.SCREEN_OFF": {
                    if (!BatterySaverController.this.isPolicyEnabled()) {
                        BatterySaverController.this.updateBatterySavingStats();
                        return;
                    }
                    BatterySaverController.this.mHandler.postStateChanged(false, 5);
                    break;
                }
                case "android.intent.action.BATTERY_CHANGED": {
                    Object object = BatterySaverController.this.mLock;
                    synchronized (object) {
                        BatterySaverController.this.mIsPluggedIn = intent.getIntExtra("plugged", 0) != 0;
                    }
                }
                case "android.os.action.DEVICE_IDLE_MODE_CHANGED": 
                case "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED": {
                    BatterySaverController.this.updateBatterySavingStats();
                }
            }
        }
    };

    static String reasonToString(int reason) {
        switch (reason) {
            case 0: {
                return "Percentage Auto ON";
            }
            case 1: {
                return "Percentage Auto OFF";
            }
            case 2: {
                return "Manual ON";
            }
            case 3: {
                return "Manual OFF";
            }
            case 4: {
                return "Sticky restore";
            }
            case 5: {
                return "Interactivity changed";
            }
            case 6: {
                return "Policy changed";
            }
            case 7: {
                return "Plugged in";
            }
            case 8: {
                return "Setting changed";
            }
            case 9: {
                return "Dynamic Warning Auto ON";
            }
            case 10: {
                return "Dynamic Warning Auto OFF";
            }
            case 11: {
                return "Adaptive Power Savings changed";
            }
            case 12: {
                return "timeout";
            }
        }
        return "Unknown reason: " + reason;
    }

    public BatterySaverController(Object lock, Context context, Looper looper, BatterySaverPolicy policy, BatterySavingStats batterySavingStats) {
        this.mLock = lock;
        this.mContext = context;
        this.mHandler = new MyHandler(looper);
        this.mBatterySaverPolicy = policy;
        this.mBatterySaverPolicy.addListener(this);
        this.mFileUpdater = new FileUpdater(context);
        this.mBatterySavingStats = batterySavingStats;
        this.mPlugins = new Plugin[]{new BatterySaverLocationPlugin(this.mContext)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PowerManagerInternal.LowPowerModeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListeners.add(listener);
        }
    }

    public void systemReady() {
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.BATTERY_CHANGED");
        filter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        filter.addAction("android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED");
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.mFileUpdater.systemReady(LocalServices.getService(ActivityManagerInternal.class).isRuntimeRestarted());
        this.mHandler.postSystemReady();
    }

    private PowerManager getPowerManager() {
        if (this.mPowerManager == null) {
            this.mPowerManager = Preconditions.checkNotNull(this.mContext.getSystemService(PowerManager.class));
        }
        return this.mPowerManager;
    }

    @Override
    public void onBatterySaverPolicyChanged(BatterySaverPolicy policy) {
        if (!this.isPolicyEnabled()) {
            return;
        }
        this.mHandler.postStateChanged(true, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void enableBatterySaver(boolean enable, int reason) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mFullEnabled == enable) {
                return;
            }
            this.mFullEnabled = enable;
            if (this.updatePolicyLevelLocked()) {
                this.mHandler.postStateChanged(true, reason);
            }
        }
    }

    private boolean updatePolicyLevelLocked() {
        if (this.mFullEnabled) {
            return this.mBatterySaverPolicy.setPolicyLevel(2);
        }
        if (this.mAdaptiveEnabled) {
            return this.mBatterySaverPolicy.setPolicyLevel(1);
        }
        return this.mBatterySaverPolicy.setPolicyLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFullEnabled || this.mAdaptiveEnabled && this.mBatterySaverPolicy.shouldAdvertiseIsEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPolicyEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFullEnabled || this.mAdaptiveEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFullEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFullEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAdaptiveEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAdaptiveEnabled;
        }
    }

    boolean setAdaptivePolicyLocked(String settings, String deviceSpecificSettings, int reason) {
        return this.setAdaptivePolicyLocked(BatterySaverPolicy.Policy.fromSettings(settings, deviceSpecificSettings), reason);
    }

    boolean setAdaptivePolicyLocked(BatterySaverPolicyConfig config, int reason) {
        return this.setAdaptivePolicyLocked(BatterySaverPolicy.Policy.fromConfig(config), reason);
    }

    boolean setAdaptivePolicyLocked(BatterySaverPolicy.Policy policy, int reason) {
        if (this.mBatterySaverPolicy.setAdaptivePolicyLocked(policy)) {
            this.mHandler.postStateChanged(true, reason);
            return true;
        }
        return false;
    }

    boolean resetAdaptivePolicyLocked(int reason) {
        if (this.mBatterySaverPolicy.resetAdaptivePolicyLocked()) {
            this.mHandler.postStateChanged(true, reason);
            return true;
        }
        return false;
    }

    boolean setAdaptivePolicyEnabledLocked(boolean enabled, int reason) {
        if (this.mAdaptiveEnabled == enabled) {
            return false;
        }
        this.mAdaptiveEnabled = enabled;
        if (this.updatePolicyLevelLocked()) {
            this.mHandler.postStateChanged(true, reason);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInteractive() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsInteractive;
        }
    }

    public BatterySaverPolicy getBatterySaverPolicy() {
        return this.mBatterySaverPolicy;
    }

    public boolean isLaunchBoostDisabled() {
        return this.isPolicyEnabled() && this.mBatterySaverPolicy.isLaunchBoostDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBatterySaverStateChanged(boolean sendBroadcast, int reason) {
        ArrayMap<String, String> fileValues;
        PowerManagerInternal.LowPowerModeListener[] listeners;
        boolean isInteractive = this.getPowerManager().isInteractive();
        Object object = this.mLock;
        synchronized (object) {
            boolean enabled = this.mFullEnabled || this.mAdaptiveEnabled;
            EventLogTags.writeBatterySaverMode(this.mFullPreviouslyEnabled ? 1 : 0, this.mAdaptivePreviouslyEnabled ? 1 : 0, this.mFullEnabled ? 1 : 0, this.mAdaptiveEnabled ? 1 : 0, isInteractive ? 1 : 0, enabled ? this.mBatterySaverPolicy.toEventLogString() : "", reason);
            this.mFullPreviouslyEnabled = this.mFullEnabled;
            this.mAdaptivePreviouslyEnabled = this.mAdaptiveEnabled;
            listeners = this.mListeners.toArray(new PowerManagerInternal.LowPowerModeListener[0]);
            this.mIsInteractive = isInteractive;
            fileValues = enabled ? this.mBatterySaverPolicy.getFileValues(isInteractive) : null;
        }
        PowerManagerInternal pmi = LocalServices.getService(PowerManagerInternal.class);
        if (pmi != null) {
            pmi.powerHint(5, this.isEnabled() ? 1 : 0);
        }
        this.updateBatterySavingStats();
        if (ArrayUtils.isEmpty(fileValues)) {
            this.mFileUpdater.restoreDefault();
        } else {
            this.mFileUpdater.writeFiles(fileValues);
        }
        for (Plugin p : this.mPlugins) {
            p.onBatterySaverChanged(this);
        }
        if (sendBroadcast) {
            Intent intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGING").putExtra("mode", this.isEnabled()).addFlags(0x40000000);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGED");
            intent.addFlags(0x40000000);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGED_INTERNAL");
            intent.addFlags(0x40000000);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.DEVICE_POWER");
            for (PowerManagerInternal.LowPowerModeListener listener : listeners) {
                PowerSaveState result = this.mBatterySaverPolicy.getBatterySaverPolicy(listener.getServiceType());
                listener.onLowPowerModeChanged(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBatterySavingStats() {
        PowerManager pm = this.getPowerManager();
        if (pm == null) {
            Slog.wtf(TAG, "PowerManager not initialized");
            return;
        }
        boolean isInteractive = pm.isInteractive();
        int dozeMode = pm.isDeviceIdleMode() ? 2 : (pm.isLightDeviceIdleMode() ? 1 : 0);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsPluggedIn) {
                this.mBatterySavingStats.startCharging();
                return;
            }
            this.mBatterySavingStats.transitionState(this.mFullEnabled ? 1 : (this.mAdaptiveEnabled ? 2 : 0), isInteractive ? 1 : 0, dozeMode);
        }
    }

    private class MyHandler
    extends Handler {
        private static final int MSG_STATE_CHANGED = 1;
        private static final int ARG_DONT_SEND_BROADCAST = 0;
        private static final int ARG_SEND_BROADCAST = 1;
        private static final int MSG_SYSTEM_READY = 2;

        public MyHandler(Looper looper) {
            super(looper);
        }

        void postStateChanged(boolean sendBroadcast, int reason) {
            this.obtainMessage(1, sendBroadcast ? 1 : 0, reason).sendToTarget();
        }

        public void postSystemReady() {
            this.obtainMessage(2, 0, 0).sendToTarget();
        }

        @Override
        public void dispatchMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    BatterySaverController.this.handleBatterySaverStateChanged(msg.arg1 == 1, msg.arg2);
                    break;
                }
                case 2: {
                    for (Plugin p : BatterySaverController.this.mPlugins) {
                        p.onSystemReady(BatterySaverController.this);
                    }
                    break;
                }
            }
        }
    }

    public static interface Plugin {
        public void onSystemReady(BatterySaverController var1);

        public void onBatterySaverChanged(BatterySaverController var1);
    }
}

