/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power.batterysaver;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.BatterySaverPolicyConfig;
import android.os.Handler;
import android.os.PowerSaveState;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.KeyValueListParser;
import android.util.Slog;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.ConcurrentUtils;
import com.android.server.power.batterysaver.BatterySavingStats;
import com.android.server.power.batterysaver.CpuFrequencies;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BatterySaverPolicy
extends ContentObserver {
    private static final String TAG = "BatterySaverPolicy";
    static final boolean DEBUG = false;
    private static final String KEY_GPS_MODE = "gps_mode";
    private static final String KEY_VIBRATION_DISABLED = "vibration_disabled";
    private static final String KEY_ANIMATION_DISABLED = "animation_disabled";
    private static final String KEY_SOUNDTRIGGER_DISABLED = "soundtrigger_disabled";
    private static final String KEY_ACTIVATE_FIREWALL_DISABLED = "firewall_disabled";
    private static final String KEY_ADJUST_BRIGHTNESS_DISABLED = "adjust_brightness_disabled";
    private static final String KEY_ACTIVATE_DATASAVER_DISABLED = "datasaver_disabled";
    private static final String KEY_ADVERTISE_IS_ENABLED = "advertise_is_enabled";
    private static final String KEY_LAUNCH_BOOST_DISABLED = "launch_boost_disabled";
    private static final String KEY_ADJUST_BRIGHTNESS_FACTOR = "adjust_brightness_factor";
    private static final String KEY_FULLBACKUP_DEFERRED = "fullbackup_deferred";
    private static final String KEY_KEYVALUE_DEFERRED = "keyvaluebackup_deferred";
    private static final String KEY_FORCE_ALL_APPS_STANDBY = "force_all_apps_standby";
    private static final String KEY_FORCE_BACKGROUND_CHECK = "force_background_check";
    private static final String KEY_OPTIONAL_SENSORS_DISABLED = "optional_sensors_disabled";
    private static final String KEY_AOD_DISABLED = "aod_disabled";
    private static final String KEY_QUICK_DOZE_ENABLED = "quick_doze_enabled";
    private static final String KEY_ENABLE_NIGHT_MODE = "enable_night_mode";
    private static final String KEY_CPU_FREQ_INTERACTIVE = "cpufreq-i";
    private static final String KEY_CPU_FREQ_NONINTERACTIVE = "cpufreq-n";
    @VisibleForTesting
    static final Policy OFF_POLICY;
    private static final Policy DEFAULT_ADAPTIVE_POLICY;
    private static final Policy DEFAULT_FULL_POLICY;
    private final Object mLock;
    private final Handler mHandler;
    @GuardedBy(value={"mLock"})
    private String mSettings;
    @GuardedBy(value={"mLock"})
    private String mDeviceSpecificSettings;
    @GuardedBy(value={"mLock"})
    private String mDeviceSpecificSettingsSource;
    @GuardedBy(value={"mLock"})
    private String mAdaptiveSettings;
    @GuardedBy(value={"mLock"})
    private String mAdaptiveDeviceSpecificSettings;
    @GuardedBy(value={"mLock"})
    private String mEventLogKeys;
    @GuardedBy(value={"mLock"})
    private boolean mDisableVibrationEffective;
    @GuardedBy(value={"mLock"})
    private boolean mAccessibilityEnabled;
    @GuardedBy(value={"mLock"})
    private Policy mDefaultAdaptivePolicy = DEFAULT_ADAPTIVE_POLICY;
    @GuardedBy(value={"mLock"})
    private Policy mAdaptivePolicy = DEFAULT_ADAPTIVE_POLICY;
    @GuardedBy(value={"mLock"})
    private Policy mFullPolicy = DEFAULT_FULL_POLICY;
    static final int POLICY_LEVEL_OFF = 0;
    static final int POLICY_LEVEL_ADAPTIVE = 1;
    static final int POLICY_LEVEL_FULL = 2;
    @GuardedBy(value={"mLock"})
    private int mPolicyLevel = 0;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final BatterySavingStats mBatterySavingStats;
    @GuardedBy(value={"mLock"})
    private final List<BatterySaverPolicyListener> mListeners = new ArrayList<BatterySaverPolicyListener>();

    public BatterySaverPolicy(Object lock, Context context, BatterySavingStats batterySavingStats) {
        super(BackgroundThread.getHandler());
        this.mLock = lock;
        this.mHandler = BackgroundThread.getHandler();
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mBatterySavingStats = batterySavingStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        ConcurrentUtils.wtfIfLockHeld(TAG, this.mLock);
        this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("battery_saver_constants"), false, this);
        this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("battery_saver_device_specific_constants"), false, this);
        this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("battery_saver_adaptive_constants"), false, this);
        this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("battery_saver_adaptive_device_specific_constants"), false, this);
        AccessibilityManager acm = this.mContext.getSystemService(AccessibilityManager.class);
        acm.addAccessibilityStateChangeListener(enabled -> {
            Object object = this.mLock;
            synchronized (object) {
                this.mAccessibilityEnabled = enabled;
            }
            this.refreshSettings();
        });
        boolean enabled2 = acm.isEnabled();
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityEnabled = enabled2;
        }
        this.onChange(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void addListener(BatterySaverPolicyListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListeners.add(listener);
        }
    }

    @VisibleForTesting
    String getGlobalSetting(String key) {
        return Settings.Global.getString(this.mContentResolver, key);
    }

    @VisibleForTesting
    int getDeviceSpecificConfigResId() {
        return 17039673;
    }

    @Override
    public void onChange(boolean selfChange, Uri uri) {
        this.refreshSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSettings() {
        BatterySaverPolicyListener[] listeners;
        Object object = this.mLock;
        synchronized (object) {
            String adaptiveDeviceSpecificSetting;
            String adaptiveSetting;
            String setting = this.getGlobalSetting("battery_saver_constants");
            String deviceSpecificSetting = this.getGlobalSetting("battery_saver_device_specific_constants");
            this.mDeviceSpecificSettingsSource = "battery_saver_device_specific_constants";
            if (TextUtils.isEmpty(deviceSpecificSetting) || "null".equals(deviceSpecificSetting)) {
                deviceSpecificSetting = this.mContext.getString(this.getDeviceSpecificConfigResId());
                this.mDeviceSpecificSettingsSource = "(overlay)";
            }
            if (!this.updateConstantsLocked(setting, deviceSpecificSetting, adaptiveSetting = this.getGlobalSetting("battery_saver_adaptive_constants"), adaptiveDeviceSpecificSetting = this.getGlobalSetting("battery_saver_adaptive_device_specific_constants"))) {
                return;
            }
            listeners = this.mListeners.toArray(new BatterySaverPolicyListener[0]);
        }
        this.mHandler.post(() -> {
            for (BatterySaverPolicyListener listener : listeners) {
                listener.onBatterySaverPolicyChanged(this);
            }
        });
    }

    @GuardedBy(value={"mLock"})
    @VisibleForTesting
    void updateConstantsLocked(String setting, String deviceSpecificSetting) {
        this.updateConstantsLocked(setting, deviceSpecificSetting, "", "");
    }

    private boolean updateConstantsLocked(String setting, String deviceSpecificSetting, String adaptiveSetting, String adaptiveDeviceSpecificSetting) {
        setting = TextUtils.emptyIfNull(setting);
        deviceSpecificSetting = TextUtils.emptyIfNull(deviceSpecificSetting);
        adaptiveSetting = TextUtils.emptyIfNull(adaptiveSetting);
        adaptiveDeviceSpecificSetting = TextUtils.emptyIfNull(adaptiveDeviceSpecificSetting);
        if (setting.equals(this.mSettings) && deviceSpecificSetting.equals(this.mDeviceSpecificSettings) && adaptiveSetting.equals(this.mAdaptiveSettings) && adaptiveDeviceSpecificSetting.equals(this.mAdaptiveDeviceSpecificSettings)) {
            return false;
        }
        this.mSettings = setting;
        this.mDeviceSpecificSettings = deviceSpecificSetting;
        this.mAdaptiveSettings = adaptiveSetting;
        this.mAdaptiveDeviceSpecificSettings = adaptiveDeviceSpecificSetting;
        boolean changed = false;
        Policy newFullPolicy = Policy.fromSettings(setting, deviceSpecificSetting, DEFAULT_FULL_POLICY);
        if (this.mPolicyLevel == 2 && !this.mFullPolicy.equals(newFullPolicy)) {
            changed = true;
        }
        this.mFullPolicy = newFullPolicy;
        this.mDefaultAdaptivePolicy = Policy.fromSettings(adaptiveSetting, adaptiveDeviceSpecificSetting, DEFAULT_ADAPTIVE_POLICY);
        if (this.mPolicyLevel == 1 && !this.mAdaptivePolicy.equals(this.mDefaultAdaptivePolicy)) {
            changed = true;
        }
        this.mAdaptivePolicy = this.mDefaultAdaptivePolicy;
        this.updatePolicyDependenciesLocked();
        return changed;
    }

    @GuardedBy(value={"mLock"})
    private void updatePolicyDependenciesLocked() {
        Policy currPolicy = this.getCurrentPolicyLocked();
        this.mDisableVibrationEffective = currPolicy.disableVibration && !this.mAccessibilityEnabled;
        StringBuilder sb = new StringBuilder();
        if (currPolicy.forceAllAppsStandby) {
            sb.append("A");
        }
        if (currPolicy.forceBackgroundCheck) {
            sb.append("B");
        }
        if (this.mDisableVibrationEffective) {
            sb.append("v");
        }
        if (currPolicy.disableAnimation) {
            sb.append("a");
        }
        if (currPolicy.disableSoundTrigger) {
            sb.append("s");
        }
        if (currPolicy.deferFullBackup) {
            sb.append("F");
        }
        if (currPolicy.deferKeyValueBackup) {
            sb.append("K");
        }
        if (currPolicy.enableFirewall) {
            sb.append("f");
        }
        if (currPolicy.enableDataSaver) {
            sb.append("d");
        }
        if (currPolicy.enableAdjustBrightness) {
            sb.append("b");
        }
        if (currPolicy.disableLaunchBoost) {
            sb.append("l");
        }
        if (currPolicy.disableOptionalSensors) {
            sb.append("S");
        }
        if (currPolicy.disableAod) {
            sb.append("o");
        }
        if (currPolicy.enableQuickDoze) {
            sb.append("q");
        }
        sb.append(currPolicy.locationMode);
        this.mEventLogKeys = sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerSaveState getBatterySaverPolicy(int type) {
        Object object = this.mLock;
        synchronized (object) {
            Policy currPolicy = this.getCurrentPolicyLocked();
            PowerSaveState.Builder builder = new PowerSaveState.Builder().setGlobalBatterySaverEnabled(currPolicy.advertiseIsEnabled);
            switch (type) {
                case 1: {
                    boolean isEnabled = currPolicy.advertiseIsEnabled || currPolicy.locationMode != 0;
                    return builder.setBatterySaverEnabled(isEnabled).setLocationMode(currPolicy.locationMode).build();
                }
                case 3: {
                    return builder.setBatterySaverEnabled(currPolicy.disableAnimation).build();
                }
                case 4: {
                    return builder.setBatterySaverEnabled(currPolicy.deferFullBackup).build();
                }
                case 5: {
                    return builder.setBatterySaverEnabled(currPolicy.deferKeyValueBackup).build();
                }
                case 6: {
                    return builder.setBatterySaverEnabled(currPolicy.enableFirewall).build();
                }
                case 7: {
                    return builder.setBatterySaverEnabled(currPolicy.enableAdjustBrightness).setBrightnessFactor(currPolicy.adjustBrightnessFactor).build();
                }
                case 10: {
                    return builder.setBatterySaverEnabled(currPolicy.enableDataSaver).build();
                }
                case 8: {
                    return builder.setBatterySaverEnabled(currPolicy.disableSoundTrigger).build();
                }
                case 2: {
                    return builder.setBatterySaverEnabled(this.mDisableVibrationEffective).build();
                }
                case 11: {
                    return builder.setBatterySaverEnabled(currPolicy.forceAllAppsStandby).build();
                }
                case 12: {
                    return builder.setBatterySaverEnabled(currPolicy.forceBackgroundCheck).build();
                }
                case 16: {
                    return builder.setBatterySaverEnabled(currPolicy.enableNightMode).build();
                }
                case 13: {
                    return builder.setBatterySaverEnabled(currPolicy.disableOptionalSensors).build();
                }
                case 14: {
                    return builder.setBatterySaverEnabled(currPolicy.disableAod).build();
                }
                case 15: {
                    return builder.setBatterySaverEnabled(currPolicy.enableQuickDoze).build();
                }
            }
            return builder.setBatterySaverEnabled(currPolicy.advertiseIsEnabled).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setPolicyLevel(int level) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPolicyLevel == level) {
                return false;
            }
            switch (level) {
                case 0: 
                case 1: 
                case 2: {
                    this.mPolicyLevel = level;
                    break;
                }
                default: {
                    Slog.wtf(TAG, "setPolicyLevel invalid level given: " + level);
                    return false;
                }
            }
            this.updatePolicyDependenciesLocked();
            return true;
        }
    }

    boolean setAdaptivePolicyLocked(Policy p) {
        if (p == null) {
            Slog.wtf(TAG, "setAdaptivePolicy given null policy");
            return false;
        }
        if (this.mAdaptivePolicy.equals(p)) {
            return false;
        }
        this.mAdaptivePolicy = p;
        if (this.mPolicyLevel == 1) {
            this.updatePolicyDependenciesLocked();
            return true;
        }
        return false;
    }

    boolean resetAdaptivePolicyLocked() {
        return this.setAdaptivePolicyLocked(this.mDefaultAdaptivePolicy);
    }

    private Policy getCurrentPolicyLocked() {
        switch (this.mPolicyLevel) {
            case 2: {
                return this.mFullPolicy;
            }
            case 1: {
                return this.mAdaptivePolicy;
            }
        }
        return OFF_POLICY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGpsMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getCurrentPolicyLocked().locationMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayMap<String, String> getFileValues(boolean interactive) {
        Object object = this.mLock;
        synchronized (object) {
            return interactive ? this.getCurrentPolicyLocked().filesForInteractive : this.getCurrentPolicyLocked().filesForNoninteractive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLaunchBoostDisabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getCurrentPolicyLocked().disableLaunchBoost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldAdvertiseIsEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getCurrentPolicyLocked().advertiseIsEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toEventLogString() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEventLogKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println();
            this.mBatterySavingStats.dump(pw, "");
            pw.println();
            pw.println("Battery saver policy (*NOTE* they only apply when battery saver is ON):");
            pw.println("  Settings: battery_saver_constants");
            pw.println("    value: " + this.mSettings);
            pw.println("  Settings: " + this.mDeviceSpecificSettingsSource);
            pw.println("    value: " + this.mDeviceSpecificSettings);
            pw.println("  Adaptive Settings: battery_saver_adaptive_constants");
            pw.println("    value: " + this.mAdaptiveSettings);
            pw.println("  Adaptive Device Specific Settings: battery_saver_adaptive_device_specific_constants");
            pw.println("    value: " + this.mAdaptiveDeviceSpecificSettings);
            pw.println("  mAccessibilityEnabled=" + this.mAccessibilityEnabled);
            pw.println("  mPolicyLevel=" + this.mPolicyLevel);
            this.dumpPolicyLocked(pw, "  ", "full", this.mFullPolicy);
            this.dumpPolicyLocked(pw, "  ", "default adaptive", this.mDefaultAdaptivePolicy);
            this.dumpPolicyLocked(pw, "  ", "current adaptive", this.mAdaptivePolicy);
        }
    }

    private void dumpPolicyLocked(PrintWriter pw, String indent, String label, Policy p) {
        pw.println();
        pw.print(indent);
        pw.println("Policy '" + label + "'");
        pw.print(indent);
        pw.println("  advertise_is_enabled=" + p.advertiseIsEnabled);
        pw.print(indent);
        pw.println("  vibration_disabled:config=" + p.disableVibration);
        pw.print(indent);
        pw.println("  vibration_disabled:effective=" + (p.disableVibration && !this.mAccessibilityEnabled));
        pw.print(indent);
        pw.println("  animation_disabled=" + p.disableAnimation);
        pw.print(indent);
        pw.println("  fullbackup_deferred=" + p.deferFullBackup);
        pw.print(indent);
        pw.println("  keyvaluebackup_deferred=" + p.deferKeyValueBackup);
        pw.print(indent);
        pw.println("  firewall_disabled=" + !p.enableFirewall);
        pw.print(indent);
        pw.println("  datasaver_disabled=" + !p.enableDataSaver);
        pw.print(indent);
        pw.println("  launch_boost_disabled=" + p.disableLaunchBoost);
        pw.println("    adjust_brightness_disabled=" + !p.enableAdjustBrightness);
        pw.print(indent);
        pw.println("  adjust_brightness_factor=" + p.adjustBrightnessFactor);
        pw.print(indent);
        pw.println("  gps_mode=" + p.locationMode);
        pw.print(indent);
        pw.println("  force_all_apps_standby=" + p.forceAllAppsStandby);
        pw.print(indent);
        pw.println("  force_background_check=" + p.forceBackgroundCheck);
        pw.println("    optional_sensors_disabled=" + p.disableOptionalSensors);
        pw.print(indent);
        pw.println("  aod_disabled=" + p.disableAod);
        pw.print(indent);
        pw.println("  soundtrigger_disabled=" + p.disableSoundTrigger);
        pw.print(indent);
        pw.println("  quick_doze_enabled=" + p.enableQuickDoze);
        pw.print(indent);
        pw.println("  enable_night_mode=" + p.enableNightMode);
        pw.print("    Interactive File values:\n");
        this.dumpMap(pw, "      ", p.filesForInteractive);
        pw.println();
        pw.print("    Noninteractive File values:\n");
        this.dumpMap(pw, "      ", p.filesForNoninteractive);
    }

    private void dumpMap(PrintWriter pw, String prefix, ArrayMap<String, String> map) {
        if (map == null) {
            return;
        }
        int size = map.size();
        for (int i = 0; i < size; ++i) {
            pw.print(prefix);
            pw.print(map.keyAt(i));
            pw.print(": '");
            pw.print(map.valueAt(i));
            pw.println("'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void setAccessibilityEnabledForTest(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityEnabled = enabled;
            this.updatePolicyDependenciesLocked();
        }
    }

    static {
        DEFAULT_ADAPTIVE_POLICY = OFF_POLICY = new Policy(1.0f, false, false, false, false, false, false, false, false, false, false, false, false, false, false, new ArrayMap<String, String>(), new ArrayMap<String, String>(), false, false, 0);
        DEFAULT_FULL_POLICY = new Policy(0.5f, true, true, true, false, true, true, true, true, true, false, false, true, true, true, new ArrayMap<String, String>(), new ArrayMap<String, String>(), true, true, 2);
    }

    static class Policy {
        public final float adjustBrightnessFactor;
        public final boolean advertiseIsEnabled;
        public final boolean deferFullBackup;
        public final boolean deferKeyValueBackup;
        public final boolean disableAnimation;
        public final boolean disableAod;
        public final boolean disableLaunchBoost;
        public final boolean disableOptionalSensors;
        public final boolean disableSoundTrigger;
        public final boolean disableVibration;
        public final boolean enableAdjustBrightness;
        public final boolean enableDataSaver;
        public final boolean enableFirewall;
        public final boolean enableNightMode;
        public final boolean enableQuickDoze;
        public final ArrayMap<String, String> filesForInteractive;
        public final ArrayMap<String, String> filesForNoninteractive;
        public final boolean forceAllAppsStandby;
        public final boolean forceBackgroundCheck;
        public final int locationMode;
        private final int mHashCode;

        Policy(float adjustBrightnessFactor, boolean advertiseIsEnabled, boolean deferFullBackup, boolean deferKeyValueBackup, boolean disableAnimation, boolean disableAod, boolean disableLaunchBoost, boolean disableOptionalSensors, boolean disableSoundTrigger, boolean disableVibration, boolean enableAdjustBrightness, boolean enableDataSaver, boolean enableFirewall, boolean enableNightMode, boolean enableQuickDoze, ArrayMap<String, String> filesForInteractive, ArrayMap<String, String> filesForNoninteractive, boolean forceAllAppsStandby, boolean forceBackgroundCheck, int locationMode) {
            this.adjustBrightnessFactor = Math.min(1.0f, Math.max(0.0f, adjustBrightnessFactor));
            this.advertiseIsEnabled = advertiseIsEnabled;
            this.deferFullBackup = deferFullBackup;
            this.deferKeyValueBackup = deferKeyValueBackup;
            this.disableAnimation = disableAnimation;
            this.disableAod = disableAod;
            this.disableLaunchBoost = disableLaunchBoost;
            this.disableOptionalSensors = disableOptionalSensors;
            this.disableSoundTrigger = disableSoundTrigger;
            this.disableVibration = disableVibration;
            this.enableAdjustBrightness = enableAdjustBrightness;
            this.enableDataSaver = enableDataSaver;
            this.enableFirewall = enableFirewall;
            this.enableNightMode = enableNightMode;
            this.enableQuickDoze = enableQuickDoze;
            this.filesForInteractive = filesForInteractive;
            this.filesForNoninteractive = filesForNoninteractive;
            this.forceAllAppsStandby = forceAllAppsStandby;
            this.forceBackgroundCheck = forceBackgroundCheck;
            if (locationMode < 0 || 4 < locationMode) {
                Slog.e(BatterySaverPolicy.TAG, "Invalid location mode: " + locationMode);
                this.locationMode = 0;
            } else {
                this.locationMode = locationMode;
            }
            this.mHashCode = Objects.hash(Float.valueOf(adjustBrightnessFactor), advertiseIsEnabled, deferFullBackup, deferKeyValueBackup, disableAnimation, disableAod, disableLaunchBoost, disableOptionalSensors, disableSoundTrigger, disableVibration, enableAdjustBrightness, enableDataSaver, enableFirewall, enableNightMode, enableQuickDoze, filesForInteractive, filesForNoninteractive, forceAllAppsStandby, forceBackgroundCheck, locationMode);
        }

        static Policy fromConfig(BatterySaverPolicyConfig config) {
            if (config == null) {
                Slog.e(BatterySaverPolicy.TAG, "Null config passed down to BatterySaverPolicy");
                return OFF_POLICY;
            }
            Map<String, String> deviceSpecificSettings = config.getDeviceSpecificSettings();
            String cpuFreqInteractive = deviceSpecificSettings.getOrDefault(BatterySaverPolicy.KEY_CPU_FREQ_INTERACTIVE, "");
            String cpuFreqNoninteractive = deviceSpecificSettings.getOrDefault(BatterySaverPolicy.KEY_CPU_FREQ_NONINTERACTIVE, "");
            return new Policy(config.getAdjustBrightnessFactor(), config.getAdvertiseIsEnabled(), config.getDeferFullBackup(), config.getDeferKeyValueBackup(), config.getDisableAnimation(), config.getDisableAod(), config.getDisableLaunchBoost(), config.getDisableOptionalSensors(), config.getDisableSoundTrigger(), config.getDisableVibration(), config.getEnableAdjustBrightness(), config.getEnableDataSaver(), config.getEnableFirewall(), config.getEnableNightMode(), config.getEnableQuickDoze(), new CpuFrequencies().parseString(cpuFreqInteractive).toSysFileMap(), new CpuFrequencies().parseString(cpuFreqNoninteractive).toSysFileMap(), config.getForceAllAppsStandby(), config.getForceBackgroundCheck(), config.getLocationMode());
        }

        static Policy fromSettings(String settings, String deviceSpecificSettings) {
            return Policy.fromSettings(settings, deviceSpecificSettings, OFF_POLICY);
        }

        static Policy fromSettings(String settings, String deviceSpecificSettings, Policy defaultPolicy) {
            KeyValueListParser parser = new KeyValueListParser(',');
            try {
                parser.setString(deviceSpecificSettings == null ? "" : deviceSpecificSettings);
            }
            catch (IllegalArgumentException e) {
                Slog.wtf(BatterySaverPolicy.TAG, "Bad device specific battery saver constants: " + deviceSpecificSettings);
            }
            String cpuFreqInteractive = parser.getString(BatterySaverPolicy.KEY_CPU_FREQ_INTERACTIVE, "");
            String cpuFreqNoninteractive = parser.getString(BatterySaverPolicy.KEY_CPU_FREQ_NONINTERACTIVE, "");
            try {
                parser.setString(settings == null ? "" : settings);
            }
            catch (IllegalArgumentException e) {
                Slog.wtf(BatterySaverPolicy.TAG, "Bad battery saver constants: " + settings);
            }
            float adjustBrightnessFactor = parser.getFloat(BatterySaverPolicy.KEY_ADJUST_BRIGHTNESS_FACTOR, defaultPolicy.adjustBrightnessFactor);
            boolean advertiseIsEnabled = parser.getBoolean(BatterySaverPolicy.KEY_ADVERTISE_IS_ENABLED, defaultPolicy.advertiseIsEnabled);
            boolean deferFullBackup = parser.getBoolean(BatterySaverPolicy.KEY_FULLBACKUP_DEFERRED, defaultPolicy.deferFullBackup);
            boolean deferKeyValueBackup = parser.getBoolean(BatterySaverPolicy.KEY_KEYVALUE_DEFERRED, defaultPolicy.deferKeyValueBackup);
            boolean disableAnimation = parser.getBoolean(BatterySaverPolicy.KEY_ANIMATION_DISABLED, defaultPolicy.disableAnimation);
            boolean disableAod = parser.getBoolean(BatterySaverPolicy.KEY_AOD_DISABLED, defaultPolicy.disableAod);
            boolean disableLaunchBoost = parser.getBoolean(BatterySaverPolicy.KEY_LAUNCH_BOOST_DISABLED, defaultPolicy.disableLaunchBoost);
            boolean disableOptionalSensors = parser.getBoolean(BatterySaverPolicy.KEY_OPTIONAL_SENSORS_DISABLED, defaultPolicy.disableOptionalSensors);
            boolean disableSoundTrigger = parser.getBoolean(BatterySaverPolicy.KEY_SOUNDTRIGGER_DISABLED, defaultPolicy.disableSoundTrigger);
            boolean disableVibrationConfig = parser.getBoolean(BatterySaverPolicy.KEY_VIBRATION_DISABLED, defaultPolicy.disableVibration);
            boolean enableAdjustBrightness = !parser.getBoolean(BatterySaverPolicy.KEY_ADJUST_BRIGHTNESS_DISABLED, !defaultPolicy.enableAdjustBrightness);
            boolean enableDataSaver = !parser.getBoolean(BatterySaverPolicy.KEY_ACTIVATE_DATASAVER_DISABLED, !defaultPolicy.enableDataSaver);
            boolean enableFirewall = !parser.getBoolean(BatterySaverPolicy.KEY_ACTIVATE_FIREWALL_DISABLED, !defaultPolicy.enableFirewall);
            boolean enableNightMode = parser.getBoolean(BatterySaverPolicy.KEY_ENABLE_NIGHT_MODE, defaultPolicy.enableNightMode);
            boolean enableQuickDoze = parser.getBoolean(BatterySaverPolicy.KEY_QUICK_DOZE_ENABLED, defaultPolicy.enableQuickDoze);
            boolean forceAllAppsStandby = parser.getBoolean(BatterySaverPolicy.KEY_FORCE_ALL_APPS_STANDBY, defaultPolicy.forceAllAppsStandby);
            boolean forceBackgroundCheck = parser.getBoolean(BatterySaverPolicy.KEY_FORCE_BACKGROUND_CHECK, defaultPolicy.forceBackgroundCheck);
            int locationMode = parser.getInt(BatterySaverPolicy.KEY_GPS_MODE, defaultPolicy.locationMode);
            return new Policy(adjustBrightnessFactor, advertiseIsEnabled, deferFullBackup, deferKeyValueBackup, disableAnimation, disableAod, disableLaunchBoost, disableOptionalSensors, disableSoundTrigger, disableVibrationConfig, enableAdjustBrightness, enableDataSaver, enableFirewall, enableNightMode, enableQuickDoze, new CpuFrequencies().parseString(cpuFreqInteractive).toSysFileMap(), new CpuFrequencies().parseString(cpuFreqNoninteractive).toSysFileMap(), forceAllAppsStandby, forceBackgroundCheck, locationMode);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Policy)) {
                return false;
            }
            Policy other = (Policy)obj;
            return Float.compare(other.adjustBrightnessFactor, this.adjustBrightnessFactor) == 0 && this.advertiseIsEnabled == other.advertiseIsEnabled && this.deferFullBackup == other.deferFullBackup && this.deferKeyValueBackup == other.deferKeyValueBackup && this.disableAnimation == other.disableAnimation && this.disableAod == other.disableAod && this.disableLaunchBoost == other.disableLaunchBoost && this.disableOptionalSensors == other.disableOptionalSensors && this.disableSoundTrigger == other.disableSoundTrigger && this.disableVibration == other.disableVibration && this.enableAdjustBrightness == other.enableAdjustBrightness && this.enableDataSaver == other.enableDataSaver && this.enableFirewall == other.enableFirewall && this.enableNightMode == other.enableNightMode && this.enableQuickDoze == other.enableQuickDoze && this.forceAllAppsStandby == other.forceAllAppsStandby && this.forceBackgroundCheck == other.forceBackgroundCheck && this.locationMode == other.locationMode && this.filesForInteractive.equals(other.filesForInteractive) && this.filesForNoninteractive.equals(other.filesForNoninteractive);
        }

        public int hashCode() {
            return this.mHashCode;
        }
    }

    public static interface BatterySaverPolicyListener {
        public void onBatterySaverPolicyChanged(BatterySaverPolicy var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface PolicyLevel {
    }
}

