/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power.batterysaver;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.os.BatterySaverPolicyConfig;
import android.os.Handler;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.server.EventLogTags;
import com.android.server.power.batterysaver.BatterySaverController;
import java.io.PrintWriter;
import java.text.NumberFormat;

public class BatterySaverStateMachine {
    private static final String TAG = "BatterySaverStateMachine";
    private static final String DYNAMIC_MODE_NOTIF_CHANNEL_ID = "dynamic_mode_notification";
    private static final String BATTERY_SAVER_NOTIF_CHANNEL_ID = "battery_saver_channel";
    private static final int DYNAMIC_MODE_NOTIFICATION_ID = 1992;
    private static final int STICKY_AUTO_DISABLED_NOTIFICATION_ID = 1993;
    private final Object mLock;
    private static final boolean DEBUG = false;
    private static final long ADAPTIVE_CHANGE_TIMEOUT_MS = 86400000L;
    private static final int ADAPTIVE_AUTO_DISABLE_BATTERY_LEVEL = 80;
    private static final int STATE_OFF = 1;
    private static final int STATE_MANUAL_ON = 2;
    private static final int STATE_AUTOMATIC_ON = 3;
    private static final int STATE_OFF_AUTOMATIC_SNOOZED = 4;
    private static final int STATE_PENDING_STICKY_ON = 5;
    private final Context mContext;
    private final BatterySaverController mBatterySaverController;
    @GuardedBy(value={"mLock"})
    private boolean mBootCompleted;
    @GuardedBy(value={"mLock"})
    private boolean mSettingsLoaded;
    @GuardedBy(value={"mLock"})
    private boolean mBatteryStatusSet;
    @GuardedBy(value={"mLock"})
    private int mState;
    @GuardedBy(value={"mLock"})
    private boolean mIsPowered;
    @GuardedBy(value={"mLock"})
    private int mBatteryLevel;
    @GuardedBy(value={"mLock"})
    private boolean mIsBatteryLevelLow;
    @GuardedBy(value={"mLock"})
    private boolean mSettingBatterySaverEnabled;
    @GuardedBy(value={"mLock"})
    private boolean mSettingBatterySaverEnabledSticky;
    private final boolean mBatterySaverStickyBehaviourDisabled;
    @GuardedBy(value={"mLock"})
    private boolean mSettingBatterySaverStickyAutoDisableEnabled;
    @GuardedBy(value={"mLock"})
    private int mSettingBatterySaverStickyAutoDisableThreshold;
    @GuardedBy(value={"mLock"})
    private final int mDynamicPowerSavingsDefaultDisableThreshold;
    @GuardedBy(value={"mLock"})
    private int mSettingBatterySaverTriggerThreshold;
    @GuardedBy(value={"mLock"})
    private int mSettingAutomaticBatterySaver;
    @GuardedBy(value={"mLock"})
    private int mDynamicPowerSavingsDisableThreshold;
    @GuardedBy(value={"mLock"})
    private boolean mDynamicPowerSavingsBatterySaver;
    @GuardedBy(value={"mLock"})
    private int mLastChangedIntReason;
    @GuardedBy(value={"mLock"})
    private String mLastChangedStrReason;
    @GuardedBy(value={"mLock"})
    private long mLastAdaptiveBatterySaverChangedExternallyElapsed;
    private final ContentObserver mSettingsObserver = new ContentObserver(null){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange) {
            Object object = BatterySaverStateMachine.this.mLock;
            synchronized (object) {
                BatterySaverStateMachine.this.refreshSettingsLocked();
            }
        }
    };
    private final Runnable mThresholdChangeLogger = () -> EventLogTags.writeBatterySaverSetting(this.mSettingBatterySaverTriggerThreshold);

    public BatterySaverStateMachine(Object lock, Context context, BatterySaverController batterySaverController) {
        this.mLock = lock;
        this.mContext = context;
        this.mBatterySaverController = batterySaverController;
        this.mState = 1;
        this.mBatterySaverStickyBehaviourDisabled = this.mContext.getResources().getBoolean(17891370);
        this.mDynamicPowerSavingsDefaultDisableThreshold = this.mContext.getResources().getInteger(17694806);
    }

    private boolean isAutomaticModeActiveLocked() {
        return this.mSettingAutomaticBatterySaver == 0 && this.mSettingBatterySaverTriggerThreshold > 0;
    }

    private boolean isInAutomaticLowZoneLocked() {
        return this.mIsBatteryLevelLow;
    }

    private boolean isDynamicModeActiveLocked() {
        return this.mSettingAutomaticBatterySaver == 1 && this.mDynamicPowerSavingsBatterySaver;
    }

    private boolean isInDynamicLowZoneLocked() {
        return this.mBatteryLevel <= this.mDynamicPowerSavingsDisableThreshold;
    }

    public void onBootCompleted() {
        this.putGlobalSetting("low_power", 0);
        this.runOnBgThread(() -> {
            ContentResolver cr = this.mContext.getContentResolver();
            cr.registerContentObserver(Settings.Global.getUriFor("low_power"), false, this.mSettingsObserver, 0);
            cr.registerContentObserver(Settings.Global.getUriFor("low_power_sticky"), false, this.mSettingsObserver, 0);
            cr.registerContentObserver(Settings.Global.getUriFor("low_power_trigger_level"), false, this.mSettingsObserver, 0);
            cr.registerContentObserver(Settings.Global.getUriFor("automatic_power_save_mode"), false, this.mSettingsObserver, 0);
            cr.registerContentObserver(Settings.Global.getUriFor("dynamic_power_savings_enabled"), false, this.mSettingsObserver, 0);
            cr.registerContentObserver(Settings.Global.getUriFor("dynamic_power_savings_disable_threshold"), false, this.mSettingsObserver, 0);
            cr.registerContentObserver(Settings.Global.getUriFor("low_power_sticky_auto_disable_enabled"), false, this.mSettingsObserver, 0);
            cr.registerContentObserver(Settings.Global.getUriFor("low_power_sticky_auto_disable_level"), false, this.mSettingsObserver, 0);
            Object object = this.mLock;
            synchronized (object) {
                boolean lowPowerModeEnabledSticky;
                boolean bl = lowPowerModeEnabledSticky = this.getGlobalSetting("low_power_sticky", 0) != 0;
                if (lowPowerModeEnabledSticky) {
                    this.mState = 5;
                }
                this.mBootCompleted = true;
                this.refreshSettingsLocked();
                this.doAutoBatterySaverLocked();
            }
        });
    }

    @VisibleForTesting
    void runOnBgThread(Runnable r) {
        BackgroundThread.getHandler().post(r);
    }

    @VisibleForTesting
    void runOnBgThreadLazy(Runnable r, int delayMillis) {
        Handler h = BackgroundThread.getHandler();
        h.removeCallbacks(r);
        h.postDelayed(r, delayMillis);
    }

    @GuardedBy(value={"mLock"})
    private void refreshSettingsLocked() {
        boolean lowPowerModeEnabled = this.getGlobalSetting("low_power", 0) != 0;
        boolean lowPowerModeEnabledSticky = this.getGlobalSetting("low_power_sticky", 0) != 0;
        boolean dynamicPowerSavingsBatterySaver = this.getGlobalSetting("dynamic_power_savings_enabled", 0) != 0;
        int lowPowerModeTriggerLevel = this.getGlobalSetting("low_power_trigger_level", 0);
        int automaticBatterySaverMode = this.getGlobalSetting("automatic_power_save_mode", 0);
        int dynamicPowerSavingsDisableThreshold = this.getGlobalSetting("dynamic_power_savings_disable_threshold", this.mDynamicPowerSavingsDefaultDisableThreshold);
        boolean isStickyAutoDisableEnabled = this.getGlobalSetting("low_power_sticky_auto_disable_enabled", 1) != 0;
        int stickyAutoDisableThreshold = this.getGlobalSetting("low_power_sticky_auto_disable_level", 90);
        this.setSettingsLocked(lowPowerModeEnabled, lowPowerModeEnabledSticky, lowPowerModeTriggerLevel, isStickyAutoDisableEnabled, stickyAutoDisableThreshold, automaticBatterySaverMode, dynamicPowerSavingsBatterySaver, dynamicPowerSavingsDisableThreshold);
    }

    @GuardedBy(value={"mLock"})
    @VisibleForTesting
    void setSettingsLocked(boolean batterySaverEnabled, boolean batterySaverEnabledSticky, int batterySaverTriggerThreshold, boolean isStickyAutoDisableEnabled, int stickyAutoDisableThreshold, int automaticBatterySaver, boolean dynamicPowerSavingsBatterySaver, int dynamicPowerSavingsDisableThreshold) {
        boolean dynamicPowerSavingsBatterySaverChanged;
        this.mSettingsLoaded = true;
        stickyAutoDisableThreshold = Math.max(stickyAutoDisableThreshold, batterySaverTriggerThreshold);
        boolean enabledChanged = this.mSettingBatterySaverEnabled != batterySaverEnabled;
        boolean stickyChanged = this.mSettingBatterySaverEnabledSticky != batterySaverEnabledSticky;
        boolean thresholdChanged = this.mSettingBatterySaverTriggerThreshold != batterySaverTriggerThreshold;
        boolean stickyAutoDisableEnabledChanged = this.mSettingBatterySaverStickyAutoDisableEnabled != isStickyAutoDisableEnabled;
        boolean stickyAutoDisableThresholdChanged = this.mSettingBatterySaverStickyAutoDisableThreshold != stickyAutoDisableThreshold;
        boolean automaticModeChanged = this.mSettingAutomaticBatterySaver != automaticBatterySaver;
        boolean dynamicPowerSavingsThresholdChanged = this.mDynamicPowerSavingsDisableThreshold != dynamicPowerSavingsDisableThreshold;
        boolean bl = dynamicPowerSavingsBatterySaverChanged = this.mDynamicPowerSavingsBatterySaver != dynamicPowerSavingsBatterySaver;
        if (!(enabledChanged || stickyChanged || thresholdChanged || automaticModeChanged || stickyAutoDisableEnabledChanged || stickyAutoDisableThresholdChanged || dynamicPowerSavingsThresholdChanged || dynamicPowerSavingsBatterySaverChanged)) {
            return;
        }
        this.mSettingBatterySaverEnabled = batterySaverEnabled;
        this.mSettingBatterySaverEnabledSticky = batterySaverEnabledSticky;
        this.mSettingBatterySaverTriggerThreshold = batterySaverTriggerThreshold;
        this.mSettingBatterySaverStickyAutoDisableEnabled = isStickyAutoDisableEnabled;
        this.mSettingBatterySaverStickyAutoDisableThreshold = stickyAutoDisableThreshold;
        this.mSettingAutomaticBatterySaver = automaticBatterySaver;
        this.mDynamicPowerSavingsDisableThreshold = dynamicPowerSavingsDisableThreshold;
        this.mDynamicPowerSavingsBatterySaver = dynamicPowerSavingsBatterySaver;
        if (thresholdChanged) {
            this.runOnBgThreadLazy(this.mThresholdChangeLogger, 2000);
        }
        if (!this.mSettingBatterySaverStickyAutoDisableEnabled) {
            this.hideStickyDisabledNotification();
        }
        if (enabledChanged) {
            String reason = batterySaverEnabled ? "Global.low_power changed to 1" : "Global.low_power changed to 0";
            this.enableBatterySaverLocked(batterySaverEnabled, true, 8, reason);
        } else {
            this.doAutoBatterySaverLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBatteryStatus(boolean newPowered, int newLevel, boolean newBatteryLevelLow) {
        Object object = this.mLock;
        synchronized (object) {
            boolean lowChanged;
            this.mBatteryStatusSet = true;
            boolean poweredChanged = this.mIsPowered != newPowered;
            boolean levelChanged = this.mBatteryLevel != newLevel;
            boolean bl = lowChanged = this.mIsBatteryLevelLow != newBatteryLevelLow;
            if (!(poweredChanged || levelChanged || lowChanged)) {
                return;
            }
            this.mIsPowered = newPowered;
            this.mBatteryLevel = newLevel;
            this.mIsBatteryLevelLow = newBatteryLevelLow;
            this.doAutoBatterySaverLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAdaptiveBatterySaverEnabled(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLastAdaptiveBatterySaverChangedExternallyElapsed = SystemClock.elapsedRealtime();
            return this.mBatterySaverController.setAdaptivePolicyEnabledLocked(enabled, 11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAdaptiveBatterySaverPolicy(BatterySaverPolicyConfig config) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLastAdaptiveBatterySaverChangedExternallyElapsed = SystemClock.elapsedRealtime();
            return this.mBatterySaverController.setAdaptivePolicyLocked(config, 11);
        }
    }

    @GuardedBy(value={"mLock"})
    private void doAutoBatterySaverLocked() {
        if (!(this.mBootCompleted && this.mSettingsLoaded && this.mBatteryStatusSet)) {
            return;
        }
        this.updateStateLocked(false, false);
        if (SystemClock.elapsedRealtime() - this.mLastAdaptiveBatterySaverChangedExternallyElapsed > 86400000L) {
            this.mBatterySaverController.setAdaptivePolicyEnabledLocked(false, 12);
            this.mBatterySaverController.resetAdaptivePolicyLocked(12);
        } else if (this.mIsPowered && this.mBatteryLevel >= 80) {
            this.mBatterySaverController.setAdaptivePolicyEnabledLocked(false, 7);
        }
    }

    @GuardedBy(value={"mLock"})
    private void updateStateLocked(boolean manual, boolean enable) {
        if (!(manual || this.mBootCompleted && this.mSettingsLoaded && this.mBatteryStatusSet)) {
            return;
        }
        switch (this.mState) {
            case 1: {
                if (this.mIsPowered) break;
                if (manual) {
                    if (!enable) {
                        Slog.e(TAG, "Tried to disable BS when it's already OFF");
                        return;
                    }
                    this.enableBatterySaverLocked(true, true, 2);
                    this.hideStickyDisabledNotification();
                    this.mState = 2;
                    break;
                }
                if (this.isAutomaticModeActiveLocked() && this.isInAutomaticLowZoneLocked()) {
                    this.enableBatterySaverLocked(true, false, 0);
                    this.hideStickyDisabledNotification();
                    this.mState = 3;
                    break;
                }
                if (!this.isDynamicModeActiveLocked() || !this.isInDynamicLowZoneLocked()) break;
                this.enableBatterySaverLocked(true, false, 9);
                this.hideStickyDisabledNotification();
                this.mState = 3;
                break;
            }
            case 2: {
                if (manual) {
                    if (enable) {
                        Slog.e(TAG, "Tried to enable BS when it's already MANUAL_ON");
                        return;
                    }
                    this.enableBatterySaverLocked(false, true, 3);
                    this.mState = 1;
                    break;
                }
                if (!this.mIsPowered) break;
                this.enableBatterySaverLocked(false, false, 7);
                if (this.mSettingBatterySaverEnabledSticky && !this.mBatterySaverStickyBehaviourDisabled) {
                    this.mState = 5;
                    break;
                }
                this.mState = 1;
                break;
            }
            case 3: {
                if (this.mIsPowered) {
                    this.enableBatterySaverLocked(false, false, 7);
                    this.mState = 1;
                    break;
                }
                if (manual) {
                    if (enable) {
                        Slog.e(TAG, "Tried to enable BS when it's already AUTO_ON");
                        return;
                    }
                    this.enableBatterySaverLocked(false, true, 3);
                    this.mState = 4;
                    break;
                }
                if (this.isAutomaticModeActiveLocked() && !this.isInAutomaticLowZoneLocked()) {
                    this.enableBatterySaverLocked(false, false, 1);
                    this.mState = 1;
                    break;
                }
                if (this.isDynamicModeActiveLocked() && !this.isInDynamicLowZoneLocked()) {
                    this.enableBatterySaverLocked(false, false, 10);
                    this.mState = 1;
                    break;
                }
                if (this.isAutomaticModeActiveLocked() || this.isDynamicModeActiveLocked()) break;
                this.enableBatterySaverLocked(false, false, 8);
                this.mState = 1;
                break;
            }
            case 4: {
                if (manual) {
                    if (!enable) {
                        Slog.e(TAG, "Tried to disable BS when it's already AUTO_SNOOZED");
                        return;
                    }
                    this.enableBatterySaverLocked(true, true, 2);
                    this.mState = 2;
                    break;
                }
                if (!(this.mIsPowered || this.isAutomaticModeActiveLocked() && !this.isInAutomaticLowZoneLocked() || this.isDynamicModeActiveLocked() && !this.isInDynamicLowZoneLocked()) && (this.isAutomaticModeActiveLocked() || this.isDynamicModeActiveLocked())) break;
                this.mState = 1;
                break;
            }
            case 5: {
                boolean isStickyDisabled;
                if (manual) {
                    Slog.e(TAG, "Tried to manually change BS state from PENDING_STICKY_ON");
                    return;
                }
                boolean shouldTurnOffSticky = this.mSettingBatterySaverStickyAutoDisableEnabled && this.mBatteryLevel >= this.mSettingBatterySaverStickyAutoDisableThreshold;
                boolean bl = isStickyDisabled = this.mBatterySaverStickyBehaviourDisabled || !this.mSettingBatterySaverEnabledSticky;
                if (isStickyDisabled || shouldTurnOffSticky) {
                    this.mState = 1;
                    this.setStickyActive(false);
                    this.triggerStickyDisabledNotification();
                    break;
                }
                if (this.mIsPowered) break;
                this.enableBatterySaverLocked(true, true, 4);
                this.mState = 2;
                break;
            }
            default: {
                Slog.wtf(TAG, "Unknown state: " + this.mState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBatterySaverEnabledManually(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateStateLocked(true, enabled);
        }
    }

    @GuardedBy(value={"mLock"})
    private void enableBatterySaverLocked(boolean enable, boolean manual, int intReason) {
        this.enableBatterySaverLocked(enable, manual, intReason, BatterySaverController.reasonToString(intReason));
    }

    @GuardedBy(value={"mLock"})
    private void enableBatterySaverLocked(boolean enable, boolean manual, int intReason, String strReason) {
        boolean wasEnabled = this.mBatterySaverController.isFullEnabled();
        if (wasEnabled == enable) {
            return;
        }
        if (enable && this.mIsPowered) {
            return;
        }
        this.mLastChangedIntReason = intReason;
        this.mLastChangedStrReason = strReason;
        this.mSettingBatterySaverEnabled = enable;
        this.putGlobalSetting("low_power", enable ? 1 : 0);
        if (manual) {
            this.setStickyActive(!this.mBatterySaverStickyBehaviourDisabled && enable);
        }
        this.mBatterySaverController.enableBatterySaver(enable, intReason);
        if (intReason == 9) {
            this.runOnBgThread(this::triggerDynamicModeNotification);
        } else if (!enable) {
            this.runOnBgThread(this::hideDynamicModeNotification);
        }
    }

    @VisibleForTesting
    void triggerDynamicModeNotification() {
        NotificationManager manager = this.mContext.getSystemService(NotificationManager.class);
        this.ensureNotificationChannelExists(manager, DYNAMIC_MODE_NOTIF_CHANNEL_ID, 17039882);
        manager.notifyAsUser(TAG, 1992, this.buildNotification(DYNAMIC_MODE_NOTIF_CHANNEL_ID, this.mContext.getResources().getString(17039884), 17039883, "android.intent.action.POWER_USAGE_SUMMARY"), UserHandle.ALL);
    }

    @VisibleForTesting
    void triggerStickyDisabledNotification() {
        NotificationManager manager = this.mContext.getSystemService(NotificationManager.class);
        this.ensureNotificationChannelExists(manager, BATTERY_SAVER_NOTIF_CHANNEL_ID, 17039603);
        String percentage = NumberFormat.getPercentInstance().format((double)this.mBatteryLevel / 100.0);
        manager.notifyAsUser(TAG, 1993, this.buildNotification(BATTERY_SAVER_NOTIF_CHANNEL_ID, this.mContext.getResources().getString(17039600, percentage), 17039605, "android.settings.BATTERY_SAVER_SETTINGS"), UserHandle.ALL);
    }

    private void ensureNotificationChannelExists(NotificationManager manager, String channelId, int nameId) {
        NotificationChannel channel = new NotificationChannel(channelId, this.mContext.getText(nameId), 3);
        channel.setSound(null, null);
        channel.setBlockableSystem(true);
        manager.createNotificationChannel(channel);
    }

    private Notification buildNotification(String channelId, String title, int summaryId, String intentAction) {
        Resources res = this.mContext.getResources();
        Intent intent = new Intent(intentAction);
        intent.setFlags(0x10008000);
        PendingIntent batterySaverIntent = PendingIntent.getActivity(this.mContext, 0, intent, 0x8000000);
        String summary = res.getString(summaryId);
        return new Notification.Builder(this.mContext, channelId).setSmallIcon(17302300).setContentTitle(title).setContentText(summary).setContentIntent(batterySaverIntent).setStyle(new Notification.BigTextStyle().bigText(summary)).setOnlyAlertOnce(true).setAutoCancel(true).build();
    }

    private void hideDynamicModeNotification() {
        this.hideNotification(1992);
    }

    private void hideStickyDisabledNotification() {
        this.hideNotification(1993);
    }

    private void hideNotification(int notificationId) {
        NotificationManager manager = this.mContext.getSystemService(NotificationManager.class);
        manager.cancel(notificationId);
    }

    private void setStickyActive(boolean active) {
        this.mSettingBatterySaverEnabledSticky = active;
        this.putGlobalSetting("low_power_sticky", this.mSettingBatterySaverEnabledSticky ? 1 : 0);
    }

    @VisibleForTesting
    protected void putGlobalSetting(String key, int value) {
        Settings.Global.putInt(this.mContext.getContentResolver(), key, value);
    }

    @VisibleForTesting
    protected int getGlobalSetting(String key, int defValue) {
        return Settings.Global.getInt(this.mContext.getContentResolver(), key, defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println();
            pw.println("Battery saver state machine:");
            pw.print("  Enabled=");
            pw.println(this.mBatterySaverController.isEnabled());
            pw.print("    full=");
            pw.println(this.mBatterySaverController.isFullEnabled());
            pw.print("    adaptive=");
            pw.print(this.mBatterySaverController.isAdaptiveEnabled());
            if (this.mBatterySaverController.isAdaptiveEnabled()) {
                pw.print(" (advertise=");
                pw.print(this.mBatterySaverController.getBatterySaverPolicy().shouldAdvertiseIsEnabled());
                pw.print(")");
            }
            pw.println();
            pw.print("  mState=");
            pw.println(this.mState);
            pw.print("  mLastChangedIntReason=");
            pw.println(this.mLastChangedIntReason);
            pw.print("  mLastChangedStrReason=");
            pw.println(this.mLastChangedStrReason);
            pw.print("  mBootCompleted=");
            pw.println(this.mBootCompleted);
            pw.print("  mSettingsLoaded=");
            pw.println(this.mSettingsLoaded);
            pw.print("  mBatteryStatusSet=");
            pw.println(this.mBatteryStatusSet);
            pw.print("  mIsPowered=");
            pw.println(this.mIsPowered);
            pw.print("  mBatteryLevel=");
            pw.println(this.mBatteryLevel);
            pw.print("  mIsBatteryLevelLow=");
            pw.println(this.mIsBatteryLevelLow);
            pw.print("  mSettingBatterySaverEnabled=");
            pw.println(this.mSettingBatterySaverEnabled);
            pw.print("  mSettingBatterySaverEnabledSticky=");
            pw.println(this.mSettingBatterySaverEnabledSticky);
            pw.print("  mSettingBatterySaverStickyAutoDisableEnabled=");
            pw.println(this.mSettingBatterySaverStickyAutoDisableEnabled);
            pw.print("  mSettingBatterySaverStickyAutoDisableThreshold=");
            pw.println(this.mSettingBatterySaverStickyAutoDisableThreshold);
            pw.print("  mSettingBatterySaverTriggerThreshold=");
            pw.println(this.mSettingBatterySaverTriggerThreshold);
            pw.print("  mBatterySaverStickyBehaviourDisabled=");
            pw.println(this.mBatterySaverStickyBehaviourDisabled);
            pw.print("  mLastAdaptiveBatterySaverChangedExternallyElapsed=");
            pw.println(this.mLastAdaptiveBatterySaverChangedExternallyElapsed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpProto(ProtoOutputStream proto, long tag) {
        Object object = this.mLock;
        synchronized (object) {
            long token = proto.start(tag);
            proto.write(0x10800000001L, this.mBatterySaverController.isEnabled());
            proto.write(1159641169938L, this.mState);
            proto.write(1133871366158L, this.mBatterySaverController.isFullEnabled());
            proto.write(1133871366159L, this.mBatterySaverController.isAdaptiveEnabled());
            proto.write(0x10800000010L, this.mBatterySaverController.getBatterySaverPolicy().shouldAdvertiseIsEnabled());
            proto.write(1133871366146L, this.mBootCompleted);
            proto.write(1133871366147L, this.mSettingsLoaded);
            proto.write(1133871366148L, this.mBatteryStatusSet);
            proto.write(1133871366150L, this.mIsPowered);
            proto.write(1120986464263L, this.mBatteryLevel);
            proto.write(0x10800000008L, this.mIsBatteryLevelLow);
            proto.write(1133871366153L, this.mSettingBatterySaverEnabled);
            proto.write(1133871366154L, this.mSettingBatterySaverEnabledSticky);
            proto.write(1120986464267L, this.mSettingBatterySaverTriggerThreshold);
            proto.write(1133871366156L, this.mSettingBatterySaverStickyAutoDisableEnabled);
            proto.write(1120986464269L, this.mSettingBatterySaverStickyAutoDisableThreshold);
            proto.write(0x10300000011L, this.mLastAdaptiveBatterySaverChangedExternallyElapsed);
            proto.end(token);
        }
    }
}

