/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power.batterysaver;

import android.os.BatteryManagerInternal;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BatterySavingStats {
    private static final String TAG = "BatterySavingStats";
    private static final boolean DEBUG = false;
    private final Object mLock;
    private BatteryManagerInternal mBatteryManagerInternal;
    private static final int STATE_NOT_INITIALIZED = -1;
    private static final int STATE_CHARGING = -2;
    @GuardedBy(value={"mLock"})
    private int mCurrentState = -1;
    @VisibleForTesting
    @GuardedBy(value={"mLock"})
    final ArrayMap<Integer, Stat> mStats = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private int mBatterySaverEnabledCount = 0;
    @GuardedBy(value={"mLock"})
    private boolean mIsBatterySaverEnabled;
    @GuardedBy(value={"mLock"})
    private long mLastBatterySaverEnabledTime = 0L;
    @GuardedBy(value={"mLock"})
    private long mLastBatterySaverDisabledTime = 0L;

    @VisibleForTesting
    public BatterySavingStats(Object lock) {
        this.mLock = lock;
        this.mBatteryManagerInternal = LocalServices.getService(BatteryManagerInternal.class);
    }

    private BatteryManagerInternal getBatteryManagerInternal() {
        if (this.mBatteryManagerInternal == null) {
            this.mBatteryManagerInternal = LocalServices.getService(BatteryManagerInternal.class);
            if (this.mBatteryManagerInternal == null) {
                Slog.wtf(TAG, "BatteryManagerInternal not initialized");
            }
        }
        return this.mBatteryManagerInternal;
    }

    @VisibleForTesting
    static int statesToIndex(int batterySaverState, int interactiveState, int dozeState) {
        int ret = batterySaverState & 3;
        ret |= (interactiveState & 1) << 2;
        return ret |= (dozeState & 3) << 3;
    }

    @VisibleForTesting
    static String stateToString(int state) {
        switch (state) {
            case -1: {
                return "NotInitialized";
            }
            case -2: {
                return "Charging";
            }
        }
        return "BS=" + BatterySaverState.fromIndex(state) + ",I=" + InteractiveState.fromIndex(state) + ",D=" + DozeState.fromIndex(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Stat getStat(int stateIndex) {
        Object object = this.mLock;
        synchronized (object) {
            Stat stat = this.mStats.get(stateIndex);
            if (stat == null) {
                stat = new Stat();
                this.mStats.put(stateIndex, stat);
            }
            return stat;
        }
    }

    private Stat getStat(int batterySaverState, int interactiveState, int dozeState) {
        return this.getStat(BatterySavingStats.statesToIndex(batterySaverState, interactiveState, dozeState));
    }

    @VisibleForTesting
    long injectCurrentTime() {
        return SystemClock.elapsedRealtime();
    }

    @VisibleForTesting
    int injectBatteryLevel() {
        BatteryManagerInternal bmi = this.getBatteryManagerInternal();
        if (bmi == null) {
            return 0;
        }
        return bmi.getBatteryChargeCounter();
    }

    @VisibleForTesting
    int injectBatteryPercent() {
        BatteryManagerInternal bmi = this.getBatteryManagerInternal();
        if (bmi == null) {
            return 0;
        }
        return bmi.getBatteryLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transitionState(int batterySaverState, int interactiveState, int dozeState) {
        Object object = this.mLock;
        synchronized (object) {
            int newState = BatterySavingStats.statesToIndex(batterySaverState, interactiveState, dozeState);
            this.transitionStateLocked(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCharging() {
        Object object = this.mLock;
        synchronized (object) {
            this.transitionStateLocked(-2);
        }
    }

    @GuardedBy(value={"mLock"})
    private void transitionStateLocked(int newState) {
        boolean newBatterySaverEnabled;
        if (this.mCurrentState == newState) {
            return;
        }
        long now = this.injectCurrentTime();
        int batteryLevel = this.injectBatteryLevel();
        int batteryPercent = this.injectBatteryPercent();
        boolean oldBatterySaverEnabled = BatterySaverState.fromIndex(this.mCurrentState) != 0;
        boolean bl = newBatterySaverEnabled = BatterySaverState.fromIndex(newState) != 0;
        if (oldBatterySaverEnabled != newBatterySaverEnabled) {
            this.mIsBatterySaverEnabled = newBatterySaverEnabled;
            if (newBatterySaverEnabled) {
                ++this.mBatterySaverEnabledCount;
                this.mLastBatterySaverEnabledTime = this.injectCurrentTime();
            } else {
                this.mLastBatterySaverDisabledTime = this.injectCurrentTime();
            }
        }
        this.endLastStateLocked(now, batteryLevel, batteryPercent);
        this.startNewStateLocked(newState, now, batteryLevel, batteryPercent);
    }

    @GuardedBy(value={"mLock"})
    private void endLastStateLocked(long now, int batteryLevel, int batteryPercent) {
        if (this.mCurrentState < 0) {
            return;
        }
        Stat stat = this.getStat(this.mCurrentState);
        stat.endBatteryLevel = batteryLevel;
        stat.endBatteryPercent = batteryPercent;
        stat.endTime = now;
        long deltaTime = stat.endTime - stat.startTime;
        int deltaDrain = stat.startBatteryLevel - stat.endBatteryLevel;
        int deltaPercent = stat.startBatteryPercent - stat.endBatteryPercent;
        stat.totalTimeMillis += deltaTime;
        stat.totalBatteryDrain += deltaDrain;
        stat.totalBatteryDrainPercent += deltaPercent;
        EventLogTags.writeBatterySavingStats(BatterySaverState.fromIndex(this.mCurrentState), InteractiveState.fromIndex(this.mCurrentState), DozeState.fromIndex(this.mCurrentState), deltaTime, deltaDrain, deltaPercent, stat.totalTimeMillis, stat.totalBatteryDrain, stat.totalBatteryDrainPercent);
    }

    @GuardedBy(value={"mLock"})
    private void startNewStateLocked(int newState, long now, int batteryLevel, int batteryPercent) {
        this.mCurrentState = newState;
        if (this.mCurrentState < 0) {
            return;
        }
        Stat stat = this.getStat(this.mCurrentState);
        stat.startBatteryLevel = batteryLevel;
        stat.startBatteryPercent = batteryPercent;
        stat.startTime = now;
        stat.endTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String indent) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print(indent);
            pw.println("Battery saving stats:");
            indent = indent + "  ";
            long now = System.currentTimeMillis();
            long nowElapsed = this.injectCurrentTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            pw.print(indent);
            pw.print("Battery Saver is currently: ");
            pw.println(this.mIsBatterySaverEnabled ? "ON" : "OFF");
            if (this.mLastBatterySaverEnabledTime > 0L) {
                pw.print(indent);
                pw.print("  ");
                pw.print("Last ON time: ");
                pw.print(sdf.format(new Date(now - nowElapsed + this.mLastBatterySaverEnabledTime)));
                pw.print(" ");
                TimeUtils.formatDuration(this.mLastBatterySaverEnabledTime, nowElapsed, pw);
                pw.println();
            }
            if (this.mLastBatterySaverDisabledTime > 0L) {
                pw.print(indent);
                pw.print("  ");
                pw.print("Last OFF time: ");
                pw.print(sdf.format(new Date(now - nowElapsed + this.mLastBatterySaverDisabledTime)));
                pw.print(" ");
                TimeUtils.formatDuration(this.mLastBatterySaverDisabledTime, nowElapsed, pw);
                pw.println();
            }
            pw.print(indent);
            pw.print("  ");
            pw.print("Times enabled: ");
            pw.println(this.mBatterySaverEnabledCount);
            pw.println();
            pw.print(indent);
            pw.println("Drain stats:");
            pw.print(indent);
            pw.println("                   Battery saver OFF                          ON");
            this.dumpLineLocked(pw, indent, 0, "NonIntr", 0, "NonDoze");
            this.dumpLineLocked(pw, indent, 1, "   Intr", 0, "       ");
            this.dumpLineLocked(pw, indent, 0, "NonIntr", 2, "Deep   ");
            this.dumpLineLocked(pw, indent, 1, "   Intr", 2, "       ");
            this.dumpLineLocked(pw, indent, 0, "NonIntr", 1, "Light  ");
            this.dumpLineLocked(pw, indent, 1, "   Intr", 1, "       ");
        }
    }

    private void dumpLineLocked(PrintWriter pw, String indent, int interactiveState, String interactiveLabel, int dozeState, String dozeLabel) {
        pw.print(indent);
        pw.print(dozeLabel);
        pw.print(" ");
        pw.print(interactiveLabel);
        pw.print(": ");
        Stat offStat = this.getStat(0, interactiveState, dozeState);
        Stat onStat = this.getStat(1, interactiveState, dozeState);
        pw.println(String.format("%6dm %6dmAh(%3d%%) %8.1fmAh/h     %6dm %6dmAh(%3d%%) %8.1fmAh/h", offStat.totalMinutes(), offStat.totalBatteryDrain / 1000, offStat.totalBatteryDrainPercent, offStat.drainPerHour() / 1000.0, onStat.totalMinutes(), onStat.totalBatteryDrain / 1000, onStat.totalBatteryDrainPercent, onStat.drainPerHour() / 1000.0));
    }

    static class Stat {
        public long startTime;
        public long endTime;
        public int startBatteryLevel;
        public int endBatteryLevel;
        public int startBatteryPercent;
        public int endBatteryPercent;
        public long totalTimeMillis;
        public int totalBatteryDrain;
        public int totalBatteryDrainPercent;

        Stat() {
        }

        public long totalMinutes() {
            return this.totalTimeMillis / 60000L;
        }

        public double drainPerHour() {
            if (this.totalTimeMillis == 0L) {
                return 0.0;
            }
            return (double)this.totalBatteryDrain / ((double)this.totalTimeMillis / 3600000.0);
        }

        public double drainPercentPerHour() {
            if (this.totalTimeMillis == 0L) {
                return 0.0;
            }
            return (double)this.totalBatteryDrainPercent / ((double)this.totalTimeMillis / 3600000.0);
        }

        @VisibleForTesting
        String toStringForTest() {
            return "{" + this.totalMinutes() + "m," + this.totalBatteryDrain + "," + String.format("%.2f", this.drainPerHour()) + "uA/H," + String.format("%.2f", this.drainPercentPerHour()) + "%}";
        }
    }

    static interface DozeState {
        public static final int NOT_DOZING = 0;
        public static final int LIGHT = 1;
        public static final int DEEP = 2;
        public static final int SHIFT = 3;
        public static final int BITS = 2;
        public static final int MASK = 3;

        public static int fromIndex(int index) {
            return index >> 3 & 3;
        }
    }

    static interface InteractiveState {
        public static final int NON_INTERACTIVE = 0;
        public static final int INTERACTIVE = 1;
        public static final int SHIFT = 2;
        public static final int BITS = 1;
        public static final int MASK = 1;

        public static int fromIndex(int index) {
            return index >> 2 & 1;
        }
    }

    static interface BatterySaverState {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int ADAPTIVE = 2;
        public static final int SHIFT = 0;
        public static final int BITS = 2;
        public static final int MASK = 3;

        public static int fromIndex(int index) {
            return index >> 0 & 3;
        }
    }
}

