/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power.batterysaver;

import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import java.util.Map;

public class CpuFrequencies {
    private static final String TAG = "CpuFrequencies";
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<Integer, Long> mCoreAndFrequencies = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CpuFrequencies parseString(String cpuNumberAndFrequencies) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCoreAndFrequencies.clear();
            try {
                for (String pair : cpuNumberAndFrequencies.split("/")) {
                    if ((pair = pair.trim()).length() == 0) continue;
                    String[] coreAndFreq = pair.split(":", 2);
                    if (coreAndFreq.length != 2) {
                        throw new IllegalArgumentException("Wrong format");
                    }
                    int core = Integer.parseInt(coreAndFreq[0]);
                    long freq = Long.parseLong(coreAndFreq[1]);
                    this.mCoreAndFrequencies.put(core, freq);
                }
            }
            catch (IllegalArgumentException e) {
                Slog.wtf(TAG, "Invalid configuration: '" + cpuNumberAndFrequencies + "'");
            }
        }
        return this;
    }

    public ArrayMap<String, String> toSysFileMap() {
        ArrayMap<String, String> map = new ArrayMap<String, String>();
        this.addToSysFileMap(map);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSysFileMap(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mCoreAndFrequencies.size();
            for (int i = 0; i < size; ++i) {
                int core = this.mCoreAndFrequencies.keyAt(i);
                long freq = this.mCoreAndFrequencies.valueAt(i);
                String file = "/sys/devices/system/cpu/cpu" + Integer.toString(core) + "/cpufreq/scaling_max_freq";
                map.put(file, Long.toString(freq));
            }
        }
    }
}

