/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.role;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.sms.IFinancialSmsService;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import java.io.PrintWriter;
import java.util.ArrayList;

final class FinancialSmsManager {
    private static final String TAG = "FinancialSmsManager";
    private final Context mContext;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private ServiceConnection mServiceConnection;
    @GuardedBy(value={"mLock"})
    private IFinancialSmsService mRemoteService;
    @GuardedBy(value={"mLock"})
    private ArrayList<Command> mQueuedCommands;

    FinancialSmsManager(Context context) {
        this.mContext = context;
    }

    ServiceInfo getServiceInfo() {
        String packageName = this.mContext.getPackageManager().getServicesSystemSharedLibraryPackageName();
        if (packageName == null) {
            Slog.w(TAG, "no external services package!");
            return null;
        }
        Intent intent = new Intent("android.service.sms.action.FINANCIAL_SERVICE_INTENT");
        intent.setPackage(packageName);
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveService(intent, 4);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Slog.w(TAG, "No valid components found.");
            return null;
        }
        return resolveInfo.serviceInfo;
    }

    private ComponentName getServiceComponentName() {
        ServiceInfo serviceInfo = this.getServiceInfo();
        if (serviceInfo == null) {
            return null;
        }
        ComponentName name = new ComponentName(serviceInfo.packageName, serviceInfo.name);
        if (!"android.permission.BIND_FINANCIAL_SMS_SERVICE".equals(serviceInfo.permission)) {
            Slog.w(TAG, name.flattenToShortString() + " does not require permission " + "android.permission.BIND_FINANCIAL_SMS_SERVICE");
            return null;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                this.mContext.unbindService(this.mServiceConnection);
                this.mServiceConnection = null;
            } else {
                Slog.d(TAG, "reset(): service is not bound. Do nothing.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndRun(Command command) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRemoteService != null) {
                try {
                    command.run(this.mRemoteService);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "exception calling service: " + e);
                }
                return;
            }
            if (this.mQueuedCommands == null) {
                this.mQueuedCommands = new ArrayList(1);
            }
            this.mQueuedCommands.add(command);
            if (this.mServiceConnection != null) {
                return;
            }
            this.mServiceConnection = new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceConnected(ComponentName name, IBinder service) {
                    Object object = FinancialSmsManager.this.mLock;
                    synchronized (object) {
                        FinancialSmsManager.this.mRemoteService = IFinancialSmsService.Stub.asInterface(service);
                        if (FinancialSmsManager.this.mQueuedCommands != null) {
                            int size = FinancialSmsManager.this.mQueuedCommands.size();
                            for (int i = 0; i < size; ++i) {
                                Command queuedCommand = (Command)FinancialSmsManager.this.mQueuedCommands.get(i);
                                try {
                                    queuedCommand.run(FinancialSmsManager.this.mRemoteService);
                                    continue;
                                }
                                catch (RemoteException e) {
                                    Slog.w(FinancialSmsManager.TAG, "exception calling " + name + ": " + e);
                                }
                            }
                            FinancialSmsManager.this.mQueuedCommands = null;
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceDisconnected(ComponentName name) {
                    Object object = FinancialSmsManager.this.mLock;
                    synchronized (object) {
                        FinancialSmsManager.this.mRemoteService = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBindingDied(ComponentName name) {
                    Object object = FinancialSmsManager.this.mLock;
                    synchronized (object) {
                        FinancialSmsManager.this.mRemoteService = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNullBinding(ComponentName name) {
                    Object object = FinancialSmsManager.this.mLock;
                    synchronized (object) {
                        FinancialSmsManager.this.mRemoteService = null;
                    }
                }
            };
            ComponentName component = this.getServiceComponentName();
            if (component != null) {
                Intent intent = new Intent();
                intent.setComponent(component);
                long token = Binder.clearCallingIdentity();
                try {
                    this.mContext.bindServiceAsUser(intent, this.mServiceConnection, 1, UserHandle.getUserHandleForUid(UserHandle.getCallingUserId()));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }
    }

    void getSmsMessages(RemoteCallback callback, Bundle params) {
        this.connectAndRun(service -> service.getSmsMessages(callback, params));
    }

    void dump(String prefix, PrintWriter pw) {
        ComponentName impl = this.getServiceComponentName();
        pw.print(prefix);
        pw.print("User ID: ");
        pw.println(UserHandle.getCallingUserId());
        pw.print(prefix);
        pw.print("Queued commands: ");
        if (this.mQueuedCommands == null) {
            pw.println("N/A");
        } else {
            pw.println(this.mQueuedCommands.size());
        }
        pw.print(prefix);
        pw.print("Implementation: ");
        if (impl == null) {
            pw.println("N/A");
            return;
        }
        pw.println(impl.flattenToShortString());
    }

    private static interface Command {
        public void run(IFinancialSmsService var1) throws RemoteException;
    }
}

