/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.role;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.role.IOnRoleHoldersChangedListener;
import android.app.role.IRoleManager;
import android.app.role.RoleControllerManager;
import android.app.role.RoleManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.PermissionChecker;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.Signature;
import android.database.CursorWindow;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteCallback;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.telephony.IFinancialSmsCallback;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.PackageUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.BitUtils;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FunctionalUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.role.FinancialSmsManager;
import com.android.server.role.RoleManagerInternal;
import com.android.server.role.RoleManagerShellCommand;
import com.android.server.role.RoleUserState;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class RoleManagerService
extends SystemService
implements RoleUserState.Callback {
    private static final String LOG_TAG = RoleManagerService.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final UserManagerInternal mUserManagerInternal;
    private final AppOpsManager mAppOpsManager;
    private final Object mLock = new Object();
    private final RoleHoldersResolver mLegacyRoleResolver;
    @GuardedBy(value={"mLock"})
    private final SparseArray<RoleUserState> mUserStates = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final SparseArray<RoleControllerManager> mControllers = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final SparseArray<RemoteCallbackList<IOnRoleHoldersChangedListener>> mListeners = new SparseArray();
    private final Handler mListenerHandler = FgThread.getHandler();

    public RoleManagerService(Context context, RoleHoldersResolver legacyRoleResolver) {
        super(context);
        this.mLegacyRoleResolver = legacyRoleResolver;
        RoleControllerManager.initializeRemoteServiceComponentName(context);
        this.mUserManagerInternal = LocalServices.getService(UserManagerInternal.class);
        this.mAppOpsManager = context.getSystemService(AppOpsManager.class);
        LocalServices.addService(RoleManagerInternal.class, new Internal());
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        packageManagerInternal.setDefaultBrowserProvider(new DefaultBrowserProvider());
        packageManagerInternal.setDefaultDialerProvider(new DefaultDialerProvider());
        packageManagerInternal.setDefaultHomeProvider(new DefaultHomeProvider());
        this.registerUserRemovedReceiver();
    }

    private void registerUserRemovedReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        this.getContext().registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (TextUtils.equals(intent.getAction(), "android.intent.action.USER_REMOVED")) {
                    int userId = intent.getIntExtra("android.intent.extra.user_handle", 0);
                    RoleManagerService.this.onRemoveUser(userId);
                }
            }
        }, UserHandle.ALL, intentFilter, null, null);
    }

    @Override
    public void onStart() {
        this.publishBinderService("role", new Stub());
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        intentFilter.setPriority(1000);
        this.getContext().registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                int userId = UserHandle.getUserId(intent.getIntExtra("android.intent.extra.UID", -1));
                if ("android.intent.action.PACKAGE_REMOVED".equals(intent.getAction()) && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    return;
                }
                RoleManagerService.this.performInitialGrantsIfNecessaryAsync(userId);
            }
        }, UserHandle.ALL, intentFilter, null, null);
    }

    @Override
    public void onStartUser(int userId) {
        this.performInitialGrantsIfNecessary(userId);
    }

    private CompletableFuture<Void> performInitialGrantsIfNecessaryAsync(int userId) {
        String oldPackagesHash;
        boolean needGrant;
        RoleUserState userState = this.getOrCreateUserState(userId);
        String packagesHash = RoleManagerService.computeComponentStateHash(userId);
        boolean bl = needGrant = !Objects.equals(packagesHash, oldPackagesHash = userState.getPackagesHash());
        if (needGrant) {
            this.migrateRoleIfNecessary("android.app.role.SMS", userId);
            this.migrateRoleIfNecessary("android.app.role.ASSISTANT", userId);
            this.migrateRoleIfNecessary("android.app.role.DIALER", userId);
            this.migrateRoleIfNecessary("android.app.role.EMERGENCY", userId);
            Slog.i(LOG_TAG, "Granting default permissions...");
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            this.getOrCreateController(userId).grantDefaultRoles(FgThread.getExecutor(), successful -> {
                if (successful.booleanValue()) {
                    userState.setPackagesHash(packagesHash);
                    result.complete(null);
                } else {
                    result.completeExceptionally(new RuntimeException());
                }
            });
            return result;
        }
        return CompletableFuture.completedFuture(null);
    }

    private void performInitialGrantsIfNecessary(int userId) {
        CompletableFuture<Void> result = this.performInitialGrantsIfNecessaryAsync(userId);
        try {
            result.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Slog.e(LOG_TAG, "Failed to grant defaults for user " + userId, e);
        }
    }

    private void migrateRoleIfNecessary(String role, int userId) {
        RoleUserState userState = this.getOrCreateUserState(userId);
        if (!userState.isRoleAvailable(role)) {
            List<String> roleHolders = this.mLegacyRoleResolver.getRoleHolders(role, userId);
            if (roleHolders.isEmpty()) {
                return;
            }
            Slog.i(LOG_TAG, "Migrating " + role + ", legacy holders: " + roleHolders);
            userState.addRoleName(role);
            int size = roleHolders.size();
            for (int i = 0; i < size; ++i) {
                userState.addRoleHolder(role, roleHolders.get(i));
            }
        }
    }

    private static String computeComponentStateHash(int userId) {
        PackageManagerInternal pm = LocalServices.getService(PackageManagerInternal.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        pm.forEachInstalledPackage(FunctionalUtils.uncheckExceptions(pkg -> {
            out.write(pkg.packageName.getBytes());
            out.write(BitUtils.toBytes(pkg.getLongVersionCode()));
            out.write(pm.getApplicationEnabledState(pkg.packageName, userId));
            ArraySet<String> enabledComponents = pm.getEnabledComponents(pkg.packageName, userId);
            int numComponents = CollectionUtils.size(enabledComponents);
            out.write(numComponents);
            for (int i = 0; i < numComponents; ++i) {
                out.write(enabledComponents.valueAt(i).getBytes());
            }
            ArraySet<String> disabledComponents = pm.getDisabledComponents(pkg.packageName, userId);
            numComponents = CollectionUtils.size(disabledComponents);
            for (int i = 0; i < numComponents; ++i) {
                out.write(disabledComponents.valueAt(i).getBytes());
            }
            for (Signature signature : pkg.mSigningDetails.signatures) {
                out.write(signature.toByteArray());
            }
        }), userId);
        return PackageUtils.computeSha256Digest(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoleUserState getOrCreateUserState(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            RoleUserState userState = this.mUserStates.get(userId);
            if (userState == null) {
                userState = new RoleUserState(userId, this);
                this.mUserStates.put(userId, userState);
            }
            return userState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoleControllerManager getOrCreateController(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            RoleControllerManager controller = this.mControllers.get(userId);
            if (controller == null) {
                Context context;
                Context systemContext = this.getContext();
                try {
                    context = systemContext.createPackageContextAsUser(systemContext.getPackageName(), 0, UserHandle.of(userId));
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new RuntimeException(e);
                }
                controller = RoleControllerManager.createWithInitializedRemoteServiceComponentName(FgThread.getHandler(), context);
                this.mControllers.put(userId, controller);
            }
            return controller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteCallbackList<IOnRoleHoldersChangedListener> getListeners(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mListeners.get(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteCallbackList<IOnRoleHoldersChangedListener> getOrCreateListeners(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            RemoteCallbackList<IOnRoleHoldersChangedListener> listeners = this.mListeners.get(userId);
            if (listeners == null) {
                listeners = new RemoteCallbackList();
                this.mListeners.put(userId, listeners);
            }
            return listeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRemoveUser(int userId) {
        RoleUserState userState;
        RemoteCallbackList<IOnRoleHoldersChangedListener> listeners;
        Object object = this.mLock;
        synchronized (object) {
            listeners = this.mListeners.removeReturnOld(userId);
            this.mControllers.remove(userId);
            userState = this.mUserStates.removeReturnOld(userId);
        }
        if (listeners != null) {
            listeners.kill();
        }
        if (userState != null) {
            userState.destroy();
        }
    }

    @Override
    public void onRoleHoldersChanged(String roleName, int userId, String removedHolder, String addedHolder) {
        this.mListenerHandler.sendMessage(PooledLambda.obtainMessage(RoleManagerService::notifyRoleHoldersChanged, this, roleName, userId, removedHolder, addedHolder));
    }

    private void notifyRoleHoldersChanged(String roleName, int userId, String removedHolder, String addedHolder) {
        RemoteCallbackList<IOnRoleHoldersChangedListener> allUsersListeners;
        RemoteCallbackList<IOnRoleHoldersChangedListener> listeners = this.getListeners(userId);
        if (listeners != null) {
            this.notifyRoleHoldersChangedForListeners(listeners, roleName, userId);
        }
        if ((allUsersListeners = this.getListeners(-1)) != null) {
            this.notifyRoleHoldersChangedForListeners(allUsersListeners, roleName, userId);
        }
        if ("android.app.role.SMS".equals(roleName)) {
            SmsApplication.broadcastSmsAppChange(this.getContext(), UserHandle.of(userId), removedHolder, addedHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRoleHoldersChangedForListeners(RemoteCallbackList<IOnRoleHoldersChangedListener> listeners, String roleName, int userId) {
        int broadcastCount = listeners.beginBroadcast();
        try {
            for (int i = 0; i < broadcastCount; ++i) {
                IOnRoleHoldersChangedListener listener = listeners.getBroadcastItem(i);
                try {
                    listener.onRoleHoldersChanged(roleName, userId);
                    continue;
                }
                catch (RemoteException e) {
                    Slog.e(LOG_TAG, "Error calling OnRoleHoldersChangedListener", e);
                }
            }
        }
        finally {
            listeners.finishBroadcast();
        }
    }

    private class DefaultHomeProvider
    implements PackageManagerInternal.DefaultHomeProvider {
        private DefaultHomeProvider() {
        }

        @Override
        public String getDefaultHome(int userId) {
            return CollectionUtils.firstOrNull(RoleManagerService.this.getOrCreateUserState(userId).getRoleHolders("android.app.role.HOME"));
        }

        @Override
        public void setDefaultHomeAsync(String packageName, int userId, Consumer<Boolean> callback) {
            RemoteCallback remoteCallback = new RemoteCallback(result -> {
                boolean successful;
                boolean bl = successful = result != null;
                if (!successful) {
                    Slog.e(LOG_TAG, "Failed to set default home: " + packageName);
                }
                callback.accept(successful);
            });
            if (packageName != null) {
                RoleManagerService.this.getOrCreateController(userId).onAddRoleHolder("android.app.role.HOME", packageName, 0, remoteCallback);
            } else {
                RoleManagerService.this.getOrCreateController(userId).onClearRoleHolders("android.app.role.HOME", 0, remoteCallback);
            }
        }
    }

    private class DefaultDialerProvider
    implements PackageManagerInternal.DefaultDialerProvider {
        private DefaultDialerProvider() {
        }

        @Override
        public String getDefaultDialer(int userId) {
            return CollectionUtils.firstOrNull(RoleManagerService.this.getOrCreateUserState(userId).getRoleHolders("android.app.role.DIALER"));
        }
    }

    private class DefaultBrowserProvider
    implements PackageManagerInternal.DefaultBrowserProvider {
        private DefaultBrowserProvider() {
        }

        @Override
        public String getDefaultBrowser(int userId) {
            return CollectionUtils.firstOrNull(RoleManagerService.this.getOrCreateUserState(userId).getRoleHolders("android.app.role.BROWSER"));
        }

        @Override
        public boolean setDefaultBrowser(String packageName, int userId) {
            CompletableFuture future = new CompletableFuture();
            RemoteCallback callback = new RemoteCallback(result -> {
                boolean successful;
                boolean bl = successful = result != null;
                if (successful) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(new RuntimeException());
                }
            });
            if (packageName != null) {
                RoleManagerService.this.getOrCreateController(userId).onAddRoleHolder("android.app.role.BROWSER", packageName, 0, callback);
            } else {
                RoleManagerService.this.getOrCreateController(userId).onClearRoleHolders("android.app.role.BROWSER", 0, callback);
            }
            try {
                future.get(5L, TimeUnit.SECONDS);
                return true;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Slog.e(LOG_TAG, "Exception while setting default browser: " + packageName, e);
                return false;
            }
        }

        @Override
        public void setDefaultBrowserAsync(String packageName, int userId) {
            RemoteCallback callback = new RemoteCallback(result -> {
                boolean successful;
                boolean bl = successful = result != null;
                if (!successful) {
                    Slog.e(LOG_TAG, "Failed to set default browser: " + packageName);
                }
            });
            if (packageName != null) {
                RoleManagerService.this.getOrCreateController(userId).onAddRoleHolder("android.app.role.BROWSER", packageName, 0, callback);
            } else {
                RoleManagerService.this.getOrCreateController(userId).onClearRoleHolders("android.app.role.BROWSER", 0, callback);
            }
        }
    }

    private class Internal
    extends RoleManagerInternal {
        private Internal() {
        }

        @Override
        public ArrayMap<String, ArraySet<String>> getRolesAndHolders(int userId) {
            return RoleManagerService.this.getOrCreateUserState(userId).getRolesAndHolders();
        }
    }

    private class Stub
    extends IRoleManager.Stub {
        private Stub() {
        }

        @Override
        public boolean isRoleAvailable(String roleName) {
            Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
            int userId = UserHandle.getUserId(Stub.getCallingUid());
            return RoleManagerService.this.getOrCreateUserState(userId).isRoleAvailable(roleName);
        }

        @Override
        public boolean isRoleHeld(String roleName, String packageName) {
            int callingUid = Stub.getCallingUid();
            RoleManagerService.this.mAppOpsManager.checkPackage(callingUid, packageName);
            Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
            Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
            int userId = UserHandle.getUserId(callingUid);
            ArraySet<String> roleHolders = RoleManagerService.this.getOrCreateUserState(userId).getRoleHolders(roleName);
            if (roleHolders == null) {
                return false;
            }
            return roleHolders.contains(packageName);
        }

        @Override
        public List<String> getRoleHoldersAsUser(String roleName, int userId) {
            if (!RoleManagerService.this.mUserManagerInternal.exists(userId)) {
                Slog.e(LOG_TAG, "user " + userId + " does not exist");
                return Collections.emptyList();
            }
            userId = this.handleIncomingUser(userId, false, "getRoleHoldersAsUser");
            RoleManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.MANAGE_ROLE_HOLDERS", "getRoleHoldersAsUser");
            Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
            ArraySet<String> roleHolders = RoleManagerService.this.getOrCreateUserState(userId).getRoleHolders(roleName);
            if (roleHolders == null) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(roleHolders);
        }

        @Override
        public void addRoleHolderAsUser(String roleName, String packageName, @RoleManager.ManageHoldersFlags int flags, int userId, RemoteCallback callback) {
            if (!RoleManagerService.this.mUserManagerInternal.exists(userId)) {
                Slog.e(LOG_TAG, "user " + userId + " does not exist");
                return;
            }
            userId = this.handleIncomingUser(userId, false, "addRoleHolderAsUser");
            RoleManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.MANAGE_ROLE_HOLDERS", "addRoleHolderAsUser");
            Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
            Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
            Preconditions.checkNotNull(callback, "callback cannot be null");
            RoleManagerService.this.getOrCreateController(userId).onAddRoleHolder(roleName, packageName, flags, callback);
        }

        @Override
        public void removeRoleHolderAsUser(String roleName, String packageName, @RoleManager.ManageHoldersFlags int flags, int userId, RemoteCallback callback) {
            if (!RoleManagerService.this.mUserManagerInternal.exists(userId)) {
                Slog.e(LOG_TAG, "user " + userId + " does not exist");
                return;
            }
            userId = this.handleIncomingUser(userId, false, "removeRoleHolderAsUser");
            RoleManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.MANAGE_ROLE_HOLDERS", "removeRoleHolderAsUser");
            Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
            Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
            Preconditions.checkNotNull(callback, "callback cannot be null");
            RoleManagerService.this.getOrCreateController(userId).onRemoveRoleHolder(roleName, packageName, flags, callback);
        }

        @Override
        public void clearRoleHoldersAsUser(String roleName, @RoleManager.ManageHoldersFlags int flags, int userId, RemoteCallback callback) {
            if (!RoleManagerService.this.mUserManagerInternal.exists(userId)) {
                Slog.e(LOG_TAG, "user " + userId + " does not exist");
                return;
            }
            userId = this.handleIncomingUser(userId, false, "clearRoleHoldersAsUser");
            RoleManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.MANAGE_ROLE_HOLDERS", "clearRoleHoldersAsUser");
            Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
            Preconditions.checkNotNull(callback, "callback cannot be null");
            RoleManagerService.this.getOrCreateController(userId).onClearRoleHolders(roleName, flags, callback);
        }

        @Override
        public void addOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) {
            if (userId != -1 && !RoleManagerService.this.mUserManagerInternal.exists(userId)) {
                Slog.e(LOG_TAG, "user " + userId + " does not exist");
                return;
            }
            userId = this.handleIncomingUser(userId, true, "addOnRoleHoldersChangedListenerAsUser");
            RoleManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.OBSERVE_ROLE_HOLDERS", "addOnRoleHoldersChangedListenerAsUser");
            Preconditions.checkNotNull(listener, "listener cannot be null");
            RemoteCallbackList listeners = RoleManagerService.this.getOrCreateListeners(userId);
            listeners.register(listener);
        }

        @Override
        public void removeOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) {
            if (userId != -1 && !RoleManagerService.this.mUserManagerInternal.exists(userId)) {
                Slog.e(LOG_TAG, "user " + userId + " does not exist");
                return;
            }
            userId = this.handleIncomingUser(userId, true, "removeOnRoleHoldersChangedListenerAsUser");
            RoleManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.OBSERVE_ROLE_HOLDERS", "removeOnRoleHoldersChangedListenerAsUser");
            Preconditions.checkNotNull(listener, "listener cannot be null");
            RemoteCallbackList listeners = RoleManagerService.this.getListeners(userId);
            if (listener == null) {
                return;
            }
            listeners.unregister(listener);
        }

        @Override
        public void setRoleNamesFromController(List<String> roleNames) {
            RoleManagerService.this.getContext().enforceCallingOrSelfPermission("com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER", "setRoleNamesFromController");
            Preconditions.checkNotNull(roleNames, "roleNames cannot be null");
            int userId = UserHandle.getCallingUserId();
            RoleManagerService.this.getOrCreateUserState(userId).setRoleNames(roleNames);
        }

        @Override
        public boolean addRoleHolderFromController(String roleName, String packageName) {
            RoleManagerService.this.getContext().enforceCallingOrSelfPermission("com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER", "addRoleHolderFromController");
            Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
            Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
            int userId = UserHandle.getCallingUserId();
            return RoleManagerService.this.getOrCreateUserState(userId).addRoleHolder(roleName, packageName);
        }

        @Override
        public boolean removeRoleHolderFromController(String roleName, String packageName) {
            RoleManagerService.this.getContext().enforceCallingOrSelfPermission("com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER", "removeRoleHolderFromController");
            Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
            Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
            int userId = UserHandle.getCallingUserId();
            return RoleManagerService.this.getOrCreateUserState(userId).removeRoleHolder(roleName, packageName);
        }

        @Override
        public List<String> getHeldRolesFromController(String packageName) {
            RoleManagerService.this.getContext().enforceCallingOrSelfPermission("com.android.permissioncontroller.permission.MANAGE_ROLES_FROM_CONTROLLER", "getRolesHeldFromController");
            Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
            int userId = UserHandle.getCallingUserId();
            return RoleManagerService.this.getOrCreateUserState(userId).getHeldRoles(packageName);
        }

        private int handleIncomingUser(int userId, boolean allowAll, String name) {
            return ActivityManager.handleIncomingUser(Stub.getCallingPid(), Stub.getCallingUid(), userId, allowAll, true, name, null);
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new RoleManagerShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getDefaultSmsPackage(int userId) {
            long identity = Binder.clearCallingIdentity();
            try {
                String string2 = CollectionUtils.firstOrNull(this.getRoleHoldersAsUser("android.app.role.SMS", userId));
                return string2;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
            DualDumpOutputStream dumpOutputStream;
            boolean dumpAsProto;
            if (!DumpUtils.checkDumpPermission(RoleManagerService.this.getContext(), LOG_TAG, fout)) {
                return;
            }
            boolean bl = dumpAsProto = args != null && ArrayUtils.contains(args, "--proto");
            if (dumpAsProto) {
                dumpOutputStream = new DualDumpOutputStream(new ProtoOutputStream(fd));
            } else {
                fout.println("ROLE MANAGER STATE (dumpsys role):");
                dumpOutputStream = new DualDumpOutputStream(new IndentingPrintWriter((Writer)fout, "  "));
            }
            for (int userId : RoleManagerService.this.mUserManagerInternal.getUserIds()) {
                RoleUserState userState = RoleManagerService.this.getOrCreateUserState(userId);
                userState.dump(dumpOutputStream, "user_states", 2246267895809L);
            }
            dumpOutputStream.flush();
        }

        @Override
        public void getSmsMessagesForFinancialApp(String callingPkg, Bundle params, IFinancialSmsCallback callback) {
            int mode = PermissionChecker.checkCallingOrSelfPermission(RoleManagerService.this.getContext(), "android:sms_financial_transactions");
            if (mode == 0) {
                FinancialSmsManager financialSmsManager = new FinancialSmsManager(RoleManagerService.this.getContext());
                financialSmsManager.getSmsMessages(new RemoteCallback(result -> {
                    CursorWindow messages = null;
                    if (result == null) {
                        Slog.w(LOG_TAG, "result is null.");
                    } else {
                        messages = (CursorWindow)result.getParcelable("sms_messages");
                    }
                    try {
                        callback.onGetSmsMessagesForFinancialApp(messages);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }), params);
            } else {
                try {
                    callback.onGetSmsMessagesForFinancialApp(null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getUidForPackage(String packageName) {
            long ident = Binder.clearCallingIdentity();
            try {
                int n = RoleManagerService.this.getContext().getPackageManager().getApplicationInfo((String)packageName, (int)0x400000).uid;
                return n;
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                int n = -1;
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    public static interface RoleHoldersResolver {
        public List<String> getRoleHolders(String var1, int var2);
    }
}

