/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.role;

import android.app.role.IRoleManager;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ShellCommand;
import android.os.UserHandle;
import android.util.Log;
import java.io.PrintWriter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

class RoleManagerShellCommand
extends ShellCommand {
    private final IRoleManager mRoleManager;

    RoleManagerShellCommand(IRoleManager roleManager) {
        this.mRoleManager = roleManager;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd) {
                case "add-role-holder": {
                    return this.runAddRoleHolder();
                }
                case "remove-role-holder": {
                    return this.runRemoveRoleHolder();
                }
                case "clear-role-holders": {
                    return this.runClearRoleHolders();
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private int getUserIdMaybe() {
        int userId = 0;
        String option = this.getNextOption();
        if (option != null && option.equals("--user")) {
            userId = UserHandle.parseUserArg(this.getNextArgRequired());
        }
        return userId;
    }

    private int getFlagsMaybe() {
        String flags = this.getNextArg();
        if (flags == null) {
            return 0;
        }
        return Integer.parseInt(flags);
    }

    private int runAddRoleHolder() throws RemoteException {
        int userId = this.getUserIdMaybe();
        String roleName = this.getNextArgRequired();
        String packageName = this.getNextArgRequired();
        int flags = this.getFlagsMaybe();
        CallbackFuture future = new CallbackFuture();
        this.mRoleManager.addRoleHolderAsUser(roleName, packageName, flags, userId, future.createCallback());
        return future.waitForResult();
    }

    private int runRemoveRoleHolder() throws RemoteException {
        int userId = this.getUserIdMaybe();
        String roleName = this.getNextArgRequired();
        String packageName = this.getNextArgRequired();
        int flags = this.getFlagsMaybe();
        CallbackFuture future = new CallbackFuture();
        this.mRoleManager.removeRoleHolderAsUser(roleName, packageName, flags, userId, future.createCallback());
        return future.waitForResult();
    }

    private int runClearRoleHolders() throws RemoteException {
        int userId = this.getUserIdMaybe();
        String roleName = this.getNextArgRequired();
        int flags = this.getFlagsMaybe();
        CallbackFuture future = new CallbackFuture();
        this.mRoleManager.clearRoleHoldersAsUser(roleName, flags, userId, future.createCallback());
        return future.waitForResult();
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Role manager (role) commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println();
        pw.println("  add-role-holder [--user USER_ID] ROLE PACKAGE [FLAGS]");
        pw.println("  remove-role-holder [--user USER_ID] ROLE PACKAGE [FLAGS]");
        pw.println("  clear-role-holders [--user USER_ID] ROLE [FLAGS]");
        pw.println();
    }

    private class CallbackFuture
    extends CompletableFuture<Void> {
        private CallbackFuture() {
        }

        public RemoteCallback createCallback() {
            return new RemoteCallback(result -> {
                boolean successful;
                boolean bl = successful = result != null;
                if (successful) {
                    this.complete(null);
                } else {
                    this.completeExceptionally(new RuntimeException("Failed"));
                }
            });
        }

        public int waitForResult() {
            try {
                this.get(5L, TimeUnit.SECONDS);
                return 0;
            }
            catch (Exception e) {
                RoleManagerShellCommand.this.getErrPrintWriter().println("Error: see logcat for details.\n" + Log.getStackTraceString(e));
                return -1;
            }
        }
    }
}

