/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.role;

import android.os.Environment;
import android.os.Handler;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class RoleUserState {
    private static final String LOG_TAG = RoleUserState.class.getSimpleName();
    public static final int VERSION_UNDEFINED = -1;
    private static final String ROLES_FILE_NAME = "roles.xml";
    private static final long WRITE_DELAY_MILLIS = 200L;
    private static final String TAG_ROLES = "roles";
    private static final String TAG_ROLE = "role";
    private static final String TAG_HOLDER = "holder";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PACKAGES_HASH = "packagesHash";
    private final int mUserId;
    private final Callback mCallback;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private int mVersion = -1;
    @GuardedBy(value={"mLock"})
    private String mPackagesHash;
    @GuardedBy(value={"mLock"})
    private ArrayMap<String, ArraySet<String>> mRoles = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private boolean mWriteScheduled;
    @GuardedBy(value={"mLock"})
    private boolean mDestroyed;
    private final Handler mWriteHandler = new Handler(BackgroundThread.getHandler().getLooper());

    public RoleUserState(int userId, Callback callback) {
        this.mUserId = userId;
        this.mCallback = callback;
        this.readFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            return this.mVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(int version) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mVersion == version) {
                return;
            }
            this.mVersion = version;
            this.scheduleWriteFileLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPackagesHash() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPackagesHash;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackagesHash(String packagesHash) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (Objects.equals(this.mPackagesHash, packagesHash)) {
                return;
            }
            this.mPackagesHash = packagesHash;
            this.scheduleWriteFileLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRoleAvailable(String roleName) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            return this.mRoles.containsKey(roleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArraySet<String> getRoleHolders(String roleName) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            ArraySet<String> packageNames = this.mRoles.get(roleName);
            if (packageNames == null) {
                return null;
            }
            return new ArraySet<String>(packageNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRoleName(String roleName) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (!this.mRoles.containsKey(roleName)) {
                this.mRoles.put(roleName, new ArraySet());
                Slog.i(LOG_TAG, "Added new role: " + roleName);
                this.scheduleWriteFileLocked();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoleNames(List<String> roleNames) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            boolean changed = false;
            for (int i = this.mRoles.size() - 1; i >= 0; --i) {
                String roleName = this.mRoles.keyAt(i);
                if (roleNames.contains(roleName)) continue;
                ArraySet<String> packageNames = this.mRoles.valueAt(i);
                if (!packageNames.isEmpty()) {
                    Slog.e(LOG_TAG, "Holders of a removed role should have been cleaned up, role: " + roleName + ", holders: " + packageNames);
                }
                this.mRoles.removeAt(i);
                changed = true;
            }
            int roleNamesSize = roleNames.size();
            for (int i = 0; i < roleNamesSize; ++i) {
                changed |= this.addRoleName(roleNames.get(i));
            }
            if (changed) {
                this.scheduleWriteFileLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRoleHolder(String roleName, String packageName) {
        boolean changed;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            ArraySet<String> roleHolders = this.mRoles.get(roleName);
            if (roleHolders == null) {
                Slog.e(LOG_TAG, "Cannot add role holder for unknown role, role: " + roleName + ", package: " + packageName);
                return false;
            }
            changed = roleHolders.add(packageName);
            if (changed) {
                this.scheduleWriteFileLocked();
            }
        }
        if (changed) {
            this.mCallback.onRoleHoldersChanged(roleName, this.mUserId, null, packageName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRoleHolder(String roleName, String packageName) {
        boolean changed;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            ArraySet<String> roleHolders = this.mRoles.get(roleName);
            if (roleHolders == null) {
                Slog.e(LOG_TAG, "Cannot remove role holder for unknown role, role: " + roleName + ", package: " + packageName);
                return false;
            }
            changed = roleHolders.remove(packageName);
            if (changed) {
                this.scheduleWriteFileLocked();
            }
        }
        if (changed) {
            this.mCallback.onRoleHoldersChanged(roleName, this.mUserId, packageName, null);
        }
        return true;
    }

    public List<String> getHeldRoles(String packageName) {
        ArrayList<String> result = new ArrayList<String>();
        int size = this.mRoles.size();
        for (int i = 0; i < size; ++i) {
            if (!this.mRoles.valueAt(i).contains(packageName)) continue;
            result.add(this.mRoles.keyAt(i));
        }
        return result;
    }

    @GuardedBy(value={"mLock"})
    private void scheduleWriteFileLocked() {
        this.throwIfDestroyedLocked();
        if (!this.mWriteScheduled) {
            this.mWriteHandler.sendMessageDelayed(PooledLambda.obtainMessage(RoleUserState::writeFile, this), 200L);
            this.mWriteScheduled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile() {
        ArrayMap<String, ArraySet<String>> roles;
        String packagesHash;
        int version;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            this.mWriteScheduled = false;
            version = this.mVersion;
            packagesHash = this.mPackagesHash;
            roles = this.snapshotRolesLocked();
        }
        AtomicFile atomicFile = new AtomicFile(RoleUserState.getFile(this.mUserId), "roles-" + this.mUserId);
        FileOutputStream out = null;
        try {
            out = atomicFile.startWrite();
            XmlSerializer serializer = Xml.newSerializer();
            serializer.setOutput(out, StandardCharsets.UTF_8.name());
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startDocument(null, true);
            this.serializeRoles(serializer, version, packagesHash, roles);
            serializer.endDocument();
            atomicFile.finishWrite(out);
            Slog.i(LOG_TAG, "Wrote roles.xml successfully");
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            Slog.wtf(LOG_TAG, "Failed to write roles.xml, restoring backup", e);
            if (out != null) {
                atomicFile.failWrite(out);
            }
        }
        finally {
            IoUtils.closeQuietly(out);
        }
    }

    private void serializeRoles(XmlSerializer serializer, int version, String packagesHash, ArrayMap<String, ArraySet<String>> roles) throws IOException {
        serializer.startTag(null, TAG_ROLES);
        serializer.attribute(null, ATTRIBUTE_VERSION, Integer.toString(version));
        if (packagesHash != null) {
            serializer.attribute(null, ATTRIBUTE_PACKAGES_HASH, packagesHash);
        }
        int size = roles.size();
        for (int i = 0; i < size; ++i) {
            String roleName = roles.keyAt(i);
            ArraySet<String> roleHolders = roles.valueAt(i);
            serializer.startTag(null, TAG_ROLE);
            serializer.attribute(null, ATTRIBUTE_NAME, roleName);
            this.serializeRoleHolders(serializer, roleHolders);
            serializer.endTag(null, TAG_ROLE);
        }
        serializer.endTag(null, TAG_ROLES);
    }

    private void serializeRoleHolders(XmlSerializer serializer, ArraySet<String> roleHolders) throws IOException {
        int size = roleHolders.size();
        for (int i = 0; i < size; ++i) {
            String roleHolder = roleHolders.valueAt(i);
            serializer.startTag(null, TAG_HOLDER);
            serializer.attribute(null, ATTRIBUTE_NAME, roleHolder);
            serializer.endTag(null, TAG_HOLDER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile() {
        Object object = this.mLock;
        synchronized (object) {
            File file = RoleUserState.getFile(this.mUserId);
            try (FileInputStream in = new AtomicFile(file).openRead();){
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(in, null);
                this.parseXmlLocked(parser);
                Slog.i(LOG_TAG, "Read roles.xml successfully");
            }
            catch (FileNotFoundException e) {
                Slog.i(LOG_TAG, "roles.xml not found");
            }
            catch (IOException | XmlPullParserException e) {
                throw new IllegalStateException("Failed to parse roles.xml: " + file, e);
            }
        }
    }

    private void parseXmlLocked(XmlPullParser parser) throws IOException, XmlPullParserException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (depth > innerDepth || type != 2 || !parser.getName().equals(TAG_ROLES)) continue;
            this.parseRolesLocked(parser);
            return;
        }
        Slog.w(LOG_TAG, "Missing <roles> in roles.xml");
    }

    private void parseRolesLocked(XmlPullParser parser) throws IOException, XmlPullParserException {
        int depth;
        int type;
        this.mVersion = Integer.parseInt(parser.getAttributeValue(null, ATTRIBUTE_VERSION));
        this.mPackagesHash = parser.getAttributeValue(null, ATTRIBUTE_PACKAGES_HASH);
        this.mRoles.clear();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (depth > innerDepth || type != 2 || !parser.getName().equals(TAG_ROLE)) continue;
            String roleName = parser.getAttributeValue(null, ATTRIBUTE_NAME);
            ArraySet<String> roleHolders = this.parseRoleHoldersLocked(parser);
            this.mRoles.put(roleName, roleHolders);
        }
    }

    private ArraySet<String> parseRoleHoldersLocked(XmlPullParser parser) throws IOException, XmlPullParserException {
        int depth;
        int type;
        ArraySet<String> roleHolders = new ArraySet<String>();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (depth > innerDepth || type != 2 || !parser.getName().equals(TAG_HOLDER)) continue;
            String roleHolder = parser.getAttributeValue(null, ATTRIBUTE_NAME);
            roleHolders.add(roleHolder);
        }
        return roleHolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(DualDumpOutputStream dumpOutputStream, String fieldName, long fieldId) {
        ArrayMap<String, ArraySet<String>> roles;
        String packagesHash;
        int version;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            version = this.mVersion;
            packagesHash = this.mPackagesHash;
            roles = this.snapshotRolesLocked();
        }
        long fieldToken = dumpOutputStream.start(fieldName, fieldId);
        dumpOutputStream.write("user_id", 0x10500000001L, this.mUserId);
        dumpOutputStream.write(ATTRIBUTE_VERSION, 1120986464258L, version);
        dumpOutputStream.write("packages_hash", 1138166333443L, packagesHash);
        int rolesSize = roles.size();
        for (int rolesIndex = 0; rolesIndex < rolesSize; ++rolesIndex) {
            String roleName = roles.keyAt(rolesIndex);
            ArraySet<String> roleHolders = roles.valueAt(rolesIndex);
            long rolesToken = dumpOutputStream.start(TAG_ROLES, 2246267895812L);
            dumpOutputStream.write(ATTRIBUTE_NAME, 0x10900000001L, roleName);
            int roleHoldersSize = roleHolders.size();
            for (int roleHoldersIndex = 0; roleHoldersIndex < roleHoldersSize; ++roleHoldersIndex) {
                String roleHolder = roleHolders.valueAt(roleHoldersIndex);
                dumpOutputStream.write("holders", 0x20900000002L, roleHolder);
            }
            dumpOutputStream.end(rolesToken);
        }
        dumpOutputStream.end(fieldToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayMap<String, ArraySet<String>> getRolesAndHolders() {
        Object object = this.mLock;
        synchronized (object) {
            return this.snapshotRolesLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private ArrayMap<String, ArraySet<String>> snapshotRolesLocked() {
        ArrayMap<String, ArraySet<String>> roles = new ArrayMap<String, ArraySet<String>>();
        int size = CollectionUtils.size(this.mRoles);
        for (int i = 0; i < size; ++i) {
            String roleName = this.mRoles.keyAt(i);
            ArraySet<String> roleHolders = this.mRoles.valueAt(i);
            roleHolders = new ArraySet<String>(roleHolders);
            roles.put(roleName, roleHolders);
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.mWriteHandler.removeCallbacksAndMessages(null);
            RoleUserState.getFile(this.mUserId).delete();
            this.mDestroyed = true;
        }
    }

    @GuardedBy(value={"mLock"})
    private void throwIfDestroyedLocked() {
        if (this.mDestroyed) {
            throw new IllegalStateException("This RoleUserState has already been destroyed");
        }
    }

    private static File getFile(int userId) {
        return new File(Environment.getUserSystemDirectory(userId), ROLES_FILE_NAME);
    }

    public static interface Callback {
        public void onRoleHoldersChanged(String var1, int var2, String var3, String var4);
    }
}

