/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.rollback;

import android.content.rollback.PackageRollbackInfo;
import android.os.storage.StorageManager;
import android.util.IntArray;
import android.util.Log;
import android.util.SparseLongArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.pm.Installer;
import com.android.server.rollback.RollbackData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@VisibleForTesting
public class AppDataRollbackHelper {
    private static final String TAG = "RollbackManager";
    private final Installer mInstaller;

    public AppDataRollbackHelper(Installer installer) {
        this.mInstaller = installer;
    }

    public void snapshotAppData(int snapshotId, PackageRollbackInfo packageRollbackInfo) {
        int[] installedUsers;
        for (int user : installedUsers = packageRollbackInfo.getInstalledUsers().toArray()) {
            int storageFlags;
            if (this.isUserCredentialLocked(user)) {
                Log.v(TAG, "User: " + user + " isn't unlocked, skipping CE userdata backup.");
                storageFlags = 1;
                packageRollbackInfo.addPendingBackup(user);
            } else {
                storageFlags = 3;
            }
            try {
                long ceSnapshotInode = this.mInstaller.snapshotAppData(packageRollbackInfo.getPackageName(), user, snapshotId, storageFlags);
                if ((storageFlags & 2) == 0) continue;
                packageRollbackInfo.putCeSnapshotInode(user, ceSnapshotInode);
            }
            catch (Installer.InstallerException ie) {
                Log.e(TAG, "Unable to create app data snapshot for: " + packageRollbackInfo.getPackageName() + ", userId: " + user, ie);
            }
        }
    }

    public boolean restoreAppData(int rollbackId, PackageRollbackInfo packageRollbackInfo, int userId, int appId, String seInfo) {
        int storageFlags = 1;
        IntArray pendingBackups = packageRollbackInfo.getPendingBackups();
        ArrayList<PackageRollbackInfo.RestoreInfo> pendingRestores = packageRollbackInfo.getPendingRestores();
        boolean changedRollbackData = false;
        if (pendingBackups != null && pendingBackups.indexOf(userId) != -1) {
            pendingBackups.remove(pendingBackups.indexOf(userId));
            changedRollbackData = true;
        } else if (this.isUserCredentialLocked(userId)) {
            pendingRestores.add(new PackageRollbackInfo.RestoreInfo(userId, appId, seInfo));
            changedRollbackData = true;
        } else {
            storageFlags |= 2;
        }
        try {
            this.mInstaller.restoreAppDataSnapshot(packageRollbackInfo.getPackageName(), appId, seInfo, userId, rollbackId, storageFlags);
        }
        catch (Installer.InstallerException ie) {
            Log.e(TAG, "Unable to restore app data snapshot: " + packageRollbackInfo.getPackageName(), ie);
        }
        return changedRollbackData;
    }

    public void destroyAppDataSnapshot(int rollbackId, PackageRollbackInfo packageRollbackInfo, int user) {
        int storageFlags = 1;
        SparseLongArray ceSnapshotInodes = packageRollbackInfo.getCeSnapshotInodes();
        long ceSnapshotInode = ceSnapshotInodes.get(user);
        if (ceSnapshotInode > 0L) {
            storageFlags |= 2;
        }
        try {
            this.mInstaller.destroyAppDataSnapshot(packageRollbackInfo.getPackageName(), user, ceSnapshotInode, rollbackId, storageFlags);
            if ((storageFlags & 2) != 0) {
                ceSnapshotInodes.delete(user);
            }
        }
        catch (Installer.InstallerException ie) {
            Log.e(TAG, "Unable to delete app data snapshot for " + packageRollbackInfo.getPackageName(), ie);
        }
    }

    private static List<RollbackData> computePendingBackups(int userId, Map<String, PackageRollbackInfo> pendingBackupPackages, List<RollbackData> rollbacks) {
        ArrayList<RollbackData> rd = new ArrayList<RollbackData>();
        for (RollbackData data : rollbacks) {
            for (PackageRollbackInfo info : data.info.getPackages()) {
                int idx;
                IntArray pendingBackupUsers = info.getPendingBackups();
                if (pendingBackupUsers == null || (idx = pendingBackupUsers.indexOf(userId)) == -1) continue;
                pendingBackupPackages.put(info.getPackageName(), info);
                if (rd.indexOf(data) != -1) continue;
                rd.add(data);
            }
        }
        return rd;
    }

    private static List<RollbackData> computePendingRestores(int userId, Map<String, PackageRollbackInfo> pendingRestorePackages, List<RollbackData> rollbacks) {
        ArrayList<RollbackData> rd = new ArrayList<RollbackData>();
        for (RollbackData data : rollbacks) {
            for (PackageRollbackInfo info : data.info.getPackages()) {
                PackageRollbackInfo.RestoreInfo ri = info.getRestoreInfo(userId);
                if (ri == null) continue;
                pendingRestorePackages.put(info.getPackageName(), info);
                if (rd.indexOf(data) != -1) continue;
                rd.add(data);
            }
        }
        return rd;
    }

    public Set<RollbackData> commitPendingBackupAndRestoreForUser(int userId, List<RollbackData> rollbacks) {
        HashMap<String, PackageRollbackInfo> pendingBackupPackages = new HashMap<String, PackageRollbackInfo>();
        List<RollbackData> pendingBackups = AppDataRollbackHelper.computePendingBackups(userId, pendingBackupPackages, rollbacks);
        HashMap<String, PackageRollbackInfo> pendingRestorePackages = new HashMap<String, PackageRollbackInfo>();
        List<RollbackData> pendingRestores = AppDataRollbackHelper.computePendingRestores(userId, pendingRestorePackages, rollbacks);
        Iterator iter = pendingBackupPackages.entrySet().iterator();
        while (iter.hasNext()) {
            PackageRollbackInfo backupPackage = (PackageRollbackInfo)iter.next().getValue();
            PackageRollbackInfo restorePackage = (PackageRollbackInfo)pendingRestorePackages.get(backupPackage.getPackageName());
            if (restorePackage == null) continue;
            backupPackage.removePendingBackup(userId);
            backupPackage.removePendingRestoreInfo(userId);
            iter.remove();
            pendingRestorePackages.remove(backupPackage.getPackageName());
        }
        if (!pendingBackupPackages.isEmpty()) {
            for (RollbackData data : pendingBackups) {
                for (PackageRollbackInfo info : data.info.getPackages()) {
                    IntArray pendingBackupUsers = info.getPendingBackups();
                    int idx = pendingBackupUsers.indexOf(userId);
                    if (idx == -1) continue;
                    try {
                        long ceSnapshotInode = this.mInstaller.snapshotAppData(info.getPackageName(), userId, data.info.getRollbackId(), 2);
                        info.putCeSnapshotInode(userId, ceSnapshotInode);
                        pendingBackupUsers.remove(idx);
                    }
                    catch (Installer.InstallerException ie) {
                        Log.e(TAG, "Unable to create app data snapshot for: " + info.getPackageName() + ", userId: " + userId, ie);
                    }
                }
            }
        }
        if (!pendingRestorePackages.isEmpty()) {
            for (RollbackData data : pendingRestores) {
                for (PackageRollbackInfo info : data.info.getPackages()) {
                    PackageRollbackInfo.RestoreInfo ri = info.getRestoreInfo(userId);
                    if (ri == null) continue;
                    try {
                        this.mInstaller.restoreAppDataSnapshot(info.getPackageName(), ri.appId, ri.seInfo, userId, data.info.getRollbackId(), 2);
                        info.removeRestoreInfo(ri);
                    }
                    catch (Installer.InstallerException ie) {
                        Log.e(TAG, "Unable to restore app data snapshot for: " + info.getPackageName(), ie);
                    }
                }
            }
        }
        HashSet<RollbackData> changed = new HashSet<RollbackData>(pendingBackups);
        changed.addAll(pendingRestores);
        return changed;
    }

    @VisibleForTesting
    public boolean isUserCredentialLocked(int userId) {
        return StorageManager.isFileEncryptedNativeOrEmulated() && !StorageManager.isUserKeyUnlocked(userId);
    }
}

