/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.rollback;

import android.content.pm.VersionedPackage;
import android.content.rollback.PackageRollbackInfo;
import android.content.rollback.RollbackInfo;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;

class RollbackData {
    static final int ROLLBACK_STATE_ENABLING = 0;
    static final int ROLLBACK_STATE_AVAILABLE = 1;
    static final int ROLLBACK_STATE_COMMITTED = 3;
    public final RollbackInfo info;
    public final File backupDir;
    public Instant timestamp;
    public final int stagedSessionId;
    public int state;
    public int apkSessionId = -1;
    public boolean restoreUserDataInProgress = false;

    RollbackData(int rollbackId, File backupDir, int stagedSessionId) {
        this.info = new RollbackInfo(rollbackId, new ArrayList<PackageRollbackInfo>(), stagedSessionId != -1, new ArrayList<VersionedPackage>(), -1);
        this.backupDir = backupDir;
        this.stagedSessionId = stagedSessionId;
        this.state = 0;
        this.timestamp = Instant.now();
    }

    RollbackData(RollbackInfo info, File backupDir, Instant timestamp, int stagedSessionId, int state, int apkSessionId, boolean restoreUserDataInProgress) {
        this.info = info;
        this.backupDir = backupDir;
        this.timestamp = timestamp;
        this.stagedSessionId = stagedSessionId;
        this.state = state;
        this.apkSessionId = apkSessionId;
        this.restoreUserDataInProgress = restoreUserDataInProgress;
    }

    public boolean isStaged() {
        return this.info.isStaged();
    }

    static String rollbackStateToString(int state) {
        switch (state) {
            case 0: {
                return "enabling";
            }
            case 1: {
                return "available";
            }
            case 3: {
                return "committed";
            }
        }
        throw new AssertionError((Object)("Invalid rollback state: " + state));
    }

    static int rollbackStateFromString(String state) throws ParseException {
        switch (state) {
            case "enabling": {
                return 0;
            }
            case "available": {
                return 1;
            }
            case "committed": {
                return 3;
            }
        }
        throw new ParseException("Invalid rollback state: " + state, 0);
    }

    public String getStateAsString() {
        return RollbackData.rollbackStateToString(this.state);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface RollbackState {
    }
}

