/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.rollback;

import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.ModuleInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.pm.VersionedPackage;
import android.content.rollback.IRollbackManager;
import android.content.rollback.PackageRollbackInfo;
import android.content.rollback.RollbackInfo;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.DeviceConfig;
import android.util.ArraySet;
import android.util.IntArray;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.util.SparseLongArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.LocalServices;
import com.android.server.Watchdog;
import com.android.server.pm.Installer;
import com.android.server.rollback.AppDataRollbackHelper;
import com.android.server.rollback.LocalIntentReceiver;
import com.android.server.rollback.RollbackData;
import com.android.server.rollback.RollbackPackageHealthObserver;
import com.android.server.rollback.RollbackStore;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class RollbackManagerServiceImpl
extends IRollbackManager.Stub {
    private static final String TAG = "RollbackManager";
    private static final long DEFAULT_ROLLBACK_LIFETIME_DURATION_MILLIS = TimeUnit.DAYS.toMillis(14L);
    private final Object mLock = new Object();
    private long mRollbackLifetimeDurationInMillis = DEFAULT_ROLLBACK_LIFETIME_DURATION_MILLIS;
    private static final long HANDLER_THREAD_TIMEOUT_DURATION_MILLIS = TimeUnit.MINUTES.toMillis(10L);
    private final Random mRandom = new SecureRandom();
    @GuardedBy(value={"mLock"})
    private final SparseBooleanArray mAllocatedRollbackIds = new SparseBooleanArray();
    @GuardedBy(value={"mLock"})
    private final Set<NewRollback> mNewRollbacks = new ArraySet<NewRollback>();
    @GuardedBy(value={"mLock"})
    private List<RollbackData> mRollbacks;
    private final RollbackStore mRollbackStore;
    private final Context mContext;
    private final HandlerThread mHandlerThread;
    private final Installer mInstaller;
    private final RollbackPackageHealthObserver mPackageHealthObserver;
    private final AppDataRollbackHelper mAppDataRollbackHelper;
    private long mRelativeBootTime = RollbackManagerServiceImpl.calculateRelativeBootTime();

    RollbackManagerServiceImpl(Context context) {
        this.mContext = context;
        this.mInstaller = new Installer(this.mContext);
        this.mInstaller.onStart();
        this.mHandlerThread = new HandlerThread("RollbackManagerServiceHandler");
        this.mHandlerThread.start();
        Watchdog.getInstance().addThread(this.getHandler(), HANDLER_THREAD_TIMEOUT_DURATION_MILLIS);
        this.mRollbackStore = new RollbackStore(new File(Environment.getDataDirectory(), "rollback"));
        this.mPackageHealthObserver = new RollbackPackageHealthObserver(this.mContext);
        this.mAppDataRollbackHelper = new AppDataRollbackHelper(this.mInstaller);
        this.getHandler().post(() -> this.ensureRollbackDataLoaded());
        SessionCallback sessionCallback = new SessionCallback();
        for (UserInfo userInfo : UserManager.get(this.mContext).getUsers(true)) {
            this.registerUserCallbacks(userInfo.getUserHandle());
        }
        IntentFilter enableRollbackFilter = new IntentFilter();
        enableRollbackFilter.addAction("android.intent.action.PACKAGE_ENABLE_ROLLBACK");
        try {
            enableRollbackFilter.addDataType("application/vnd.android.package-archive");
        }
        catch (IntentFilter.MalformedMimeTypeException e) {
            Log.e(TAG, "addDataType", e);
        }
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if ("android.intent.action.PACKAGE_ENABLE_ROLLBACK".equals(intent.getAction())) {
                    int token = intent.getIntExtra("android.content.pm.extra.ENABLE_ROLLBACK_TOKEN", -1);
                    int installFlags = intent.getIntExtra("android.content.pm.extra.ENABLE_ROLLBACK_INSTALL_FLAGS", 0);
                    int[] installedUsers = intent.getIntArrayExtra("android.content.pm.extra.ENABLE_ROLLBACK_INSTALLED_USERS");
                    int user = intent.getIntExtra("android.content.pm.extra.ENABLE_ROLLBACK_USER", 0);
                    File newPackageCodePath = new File(intent.getData().getPath());
                    RollbackManagerServiceImpl.this.getHandler().post(() -> {
                        boolean success = RollbackManagerServiceImpl.this.enableRollback(installFlags, newPackageCodePath, installedUsers, user, token);
                        int ret = 1;
                        if (!success) {
                            ret = -1;
                        }
                        PackageManagerInternal pm = LocalServices.getService(PackageManagerInternal.class);
                        pm.setEnableRollbackCode(token, ret);
                    });
                    this.abortBroadcast();
                }
            }
        }, enableRollbackFilter, null, this.getHandler());
        IntentFilter enableRollbackTimedOutFilter = new IntentFilter();
        enableRollbackTimedOutFilter.addAction("android.intent.action.CANCEL_ENABLE_ROLLBACK");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                if (!"android.intent.action.CANCEL_ENABLE_ROLLBACK".equals(intent.getAction())) return;
                int token = intent.getIntExtra("android.content.pm.extra.ENABLE_ROLLBACK_TOKEN", -1);
                Object object = RollbackManagerServiceImpl.this.mLock;
                synchronized (object) {
                    NewRollback rollback;
                    Iterator iterator = RollbackManagerServiceImpl.this.mNewRollbacks.iterator();
                    do {
                        if (!iterator.hasNext()) return;
                    } while (!(rollback = (NewRollback)iterator.next()).hasToken(token));
                    rollback.isCancelled = true;
                    return;
                }
            }
        }, enableRollbackTimedOutFilter, null, this.getHandler());
        IntentFilter userAddedIntentFilter = new IntentFilter("android.intent.action.USER_ADDED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if ("android.intent.action.USER_ADDED".equals(intent.getAction())) {
                    int newUserId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                    if (newUserId == -1) {
                        return;
                    }
                    RollbackManagerServiceImpl.this.registerUserCallbacks(UserHandle.of(newUserId));
                }
            }
        }, userAddedIntentFilter, null, this.getHandler());
        this.registerTimeChangeReceiver();
    }

    private void registerUserCallbacks(UserHandle user) {
        Context context = this.getContextAsUser(user);
        if (context == null) {
            Log.e(TAG, "Unable to register user callbacks for user " + user);
            return;
        }
        context.getPackageManager().getPackageInstaller().registerSessionCallback(new SessionCallback(), this.getHandler());
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_REPLACED");
        filter.addAction("android.intent.action.PACKAGE_FULLY_REMOVED");
        filter.addDataScheme("package");
        context.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String packageName;
                String action = intent.getAction();
                if ("android.intent.action.PACKAGE_REPLACED".equals(action)) {
                    packageName = intent.getData().getSchemeSpecificPart();
                    RollbackManagerServiceImpl.this.onPackageReplaced(packageName);
                }
                if ("android.intent.action.PACKAGE_FULLY_REMOVED".equals(action)) {
                    packageName = intent.getData().getSchemeSpecificPart();
                    RollbackManagerServiceImpl.this.onPackageFullyRemoved(packageName);
                }
            }
        }, filter, null, this.getHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice getAvailableRollbacks() {
        this.enforceManageRollbacks("getAvailableRollbacks");
        if (Thread.currentThread().equals(this.mHandlerThread)) {
            Log.wtf(TAG, "Calling getAvailableRollbacks from mHandlerThread causes a deadlock");
            throw new IllegalStateException("Cannot call RollbackManager#getAvailableRollbacks from the handler thread!");
        }
        LinkedBlockingQueue result = new LinkedBlockingQueue();
        this.getHandler().post(() -> result.offer(true));
        try {
            result.take();
        }
        catch (InterruptedException ie) {
            Log.w(TAG, "Interrupted while waiting for handler thread in getAvailableRollbacks");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
            ArrayList<RollbackInfo> rollbacks = new ArrayList<RollbackInfo>();
            for (int i = 0; i < this.mRollbacks.size(); ++i) {
                RollbackData data = this.mRollbacks.get(i);
                if (data.state != 1) continue;
                rollbacks.add(data.info);
            }
            return new ParceledListSlice(rollbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<RollbackInfo> getRecentlyExecutedRollbacks() {
        this.enforceManageRollbacks("getRecentlyCommittedRollbacks");
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
            ArrayList<RollbackInfo> rollbacks = new ArrayList<RollbackInfo>();
            for (int i = 0; i < this.mRollbacks.size(); ++i) {
                RollbackData data = this.mRollbacks.get(i);
                if (data.state != 3) continue;
                rollbacks.add(data.info);
            }
            return new ParceledListSlice<RollbackInfo>(rollbacks);
        }
    }

    @Override
    public void commitRollback(int rollbackId, ParceledListSlice causePackages, String callerPackageName, IntentSender statusReceiver) {
        this.enforceManageRollbacks("executeRollback");
        int callingUid = Binder.getCallingUid();
        AppOpsManager appOps = this.mContext.getSystemService(AppOpsManager.class);
        appOps.checkPackage(callingUid, callerPackageName);
        this.getHandler().post(() -> this.commitRollbackInternal(rollbackId, causePackages.getList(), callerPackageName, statusReceiver));
    }

    private void registerTimeChangeReceiver() {
        BroadcastReceiver timeChangeIntentReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                long oldRelativeBootTime = RollbackManagerServiceImpl.this.mRelativeBootTime;
                RollbackManagerServiceImpl.this.mRelativeBootTime = RollbackManagerServiceImpl.calculateRelativeBootTime();
                long timeDifference = RollbackManagerServiceImpl.this.mRelativeBootTime - oldRelativeBootTime;
                Object object = RollbackManagerServiceImpl.this.mLock;
                synchronized (object) {
                    RollbackManagerServiceImpl.this.ensureRollbackDataLoadedLocked();
                    for (RollbackData data : RollbackManagerServiceImpl.this.mRollbacks) {
                        data.timestamp = data.timestamp.plusMillis(timeDifference);
                        RollbackManagerServiceImpl.this.saveRollbackData(data);
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.TIME_SET");
        this.mContext.registerReceiver(timeChangeIntentReceiver, filter, null, this.getHandler());
    }

    private static long calculateRelativeBootTime() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRollbackInternal(int rollbackId, List<VersionedPackage> causePackages, String callerPackageName, IntentSender statusReceiver) {
        Log.i(TAG, "Initiating rollback");
        RollbackData data = this.getRollbackForId(rollbackId);
        if (data == null || data.state != 1) {
            this.sendFailure(statusReceiver, 2, "Rollback unavailable");
            return;
        }
        Context context = null;
        try {
            context = this.mContext.createPackageContext(callerPackageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            this.sendFailure(statusReceiver, 1, "Invalid callerPackageName");
            return;
        }
        PackageManager pm = context.getPackageManager();
        try {
            PackageInstaller packageInstaller = pm.getPackageInstaller();
            PackageInstaller.SessionParams parentParams = new PackageInstaller.SessionParams(1);
            parentParams.setRequestDowngrade(true);
            parentParams.setMultiPackage();
            if (data.isStaged()) {
                parentParams.setStaged();
            }
            int parentSessionId = packageInstaller.createSession(parentParams);
            PackageInstaller.Session parentSession = packageInstaller.openSession(parentSessionId);
            for (PackageRollbackInfo info : data.info.getPackages()) {
                String installerPackageName;
                PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(1);
                if (!info.isApex() && (installerPackageName = pm.getInstallerPackageName(info.getPackageName())) != null) {
                    params.setInstallerPackageName(installerPackageName);
                }
                params.setRequestDowngrade(true);
                params.setRequiredInstalledVersionCode(info.getVersionRolledBackFrom().getLongVersionCode());
                if (data.isStaged()) {
                    params.setStaged();
                }
                if (info.isApex()) {
                    params.setInstallAsApex();
                }
                int sessionId = packageInstaller.createSession(params);
                PackageInstaller.Session session = packageInstaller.openSession(sessionId);
                File[] packageCodePaths = RollbackStore.getPackageCodePaths(data, info.getPackageName());
                if (packageCodePaths == null) {
                    this.sendFailure(statusReceiver, 1, "Backup copy of package inaccessible");
                    return;
                }
                for (File packageCodePath : packageCodePaths) {
                    try (ParcelFileDescriptor fd = ParcelFileDescriptor.open(packageCodePath, 0x10000000);){
                        long token = Binder.clearCallingIdentity();
                        try {
                            session.write(packageCodePath.getName(), 0L, packageCodePath.length(), fd);
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                        }
                    }
                }
                parentSession.addChildSessionId(sessionId);
            }
            LocalIntentReceiver receiver = new LocalIntentReceiver(result -> this.getHandler().post(() -> {
                int status = result.getIntExtra("android.content.pm.extra.STATUS", 1);
                if (status != 0) {
                    Object object = this.mLock;
                    synchronized (object) {
                        data.state = 1;
                        data.restoreUserDataInProgress = false;
                    }
                    this.sendFailure(statusReceiver, 3, "Rollback downgrade install failed: " + result.getStringExtra("android.content.pm.extra.STATUS_MESSAGE"));
                    return;
                }
                Object object = this.mLock;
                synchronized (object) {
                    if (!data.isStaged()) {
                        data.restoreUserDataInProgress = false;
                    }
                    data.info.setCommittedSessionId(parentSessionId);
                    data.info.getCausePackages().addAll(causePackages);
                }
                RollbackStore.deletePackageCodePaths(data);
                this.saveRollbackData(data);
                this.sendSuccess(statusReceiver);
                Intent broadcast = new Intent("android.intent.action.ROLLBACK_COMMITTED");
                this.mContext.sendBroadcastAsUser(broadcast, UserHandle.SYSTEM, "android.permission.MANAGE_ROLLBACKS");
            }));
            Object object = this.mLock;
            synchronized (object) {
                data.state = 3;
                data.restoreUserDataInProgress = true;
            }
            parentSession.commit(receiver.getIntentSender());
        }
        catch (IOException e) {
            Log.e(TAG, "Rollback failed", e);
            this.sendFailure(statusReceiver, 1, "IOException: " + e.toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadPersistedData() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.TEST_MANAGE_ROLLBACKS", "reloadPersistedData");
        Object object = this.mLock;
        synchronized (object) {
            this.mRollbacks = null;
        }
        this.getHandler().post(() -> {
            this.updateRollbackLifetimeDurationInMillis();
            this.ensureRollbackDataLoaded();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireRollbackForPackage(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.TEST_MANAGE_ROLLBACKS", "expireRollbackForPackage");
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
            Iterator<RollbackData> iter = this.mRollbacks.iterator();
            block3: while (iter.hasNext()) {
                RollbackData data = iter.next();
                for (PackageRollbackInfo info : data.info.getPackages()) {
                    if (!info.getPackageName().equals(packageName)) continue;
                    iter.remove();
                    this.deleteRollback(data);
                    continue block3;
                }
            }
        }
    }

    void onUnlockUser(int userId) {
        this.getHandler().post(() -> {
            ArrayList<RollbackData> rollbacks;
            Object object = this.mLock;
            synchronized (object) {
                rollbacks = new ArrayList<RollbackData>(this.mRollbacks);
            }
            Set<RollbackData> changed = this.mAppDataRollbackHelper.commitPendingBackupAndRestoreForUser(userId, rollbacks);
            for (RollbackData rd : changed) {
                this.saveRollbackData(rd);
            }
        });
    }

    private void updateRollbackLifetimeDurationInMillis() {
        this.mRollbackLifetimeDurationInMillis = DeviceConfig.getLong("rollback_boot", "rollback_lifetime_in_millis", DEFAULT_ROLLBACK_LIFETIME_DURATION_MILLIS);
        if (this.mRollbackLifetimeDurationInMillis < 0L) {
            this.mRollbackLifetimeDurationInMillis = DEFAULT_ROLLBACK_LIFETIME_DURATION_MILLIS;
        }
    }

    void onBootCompleted() {
        this.getHandler().post(() -> this.updateRollbackLifetimeDurationInMillis());
        this.scheduleExpiration(0L);
        this.getHandler().post(() -> {
            PackageInstaller.SessionInfo session;
            PackageInstaller installer;
            ArrayList<RollbackData> enabling = new ArrayList<RollbackData>();
            ArrayList<RollbackData> restoreInProgress = new ArrayList<RollbackData>();
            HashSet<String> apexPackageNames = new HashSet<String>();
            Iterator iterator = this.mLock;
            synchronized (iterator) {
                this.ensureRollbackDataLoadedLocked();
                for (RollbackData data : this.mRollbacks) {
                    if (!data.isStaged()) continue;
                    if (data.state == 0) {
                        enabling.add(data);
                    } else if (data.restoreUserDataInProgress) {
                        restoreInProgress.add(data);
                    }
                    for (PackageRollbackInfo info : data.info.getPackages()) {
                        if (!info.isApex()) continue;
                        apexPackageNames.add(info.getPackageName());
                    }
                }
            }
            for (RollbackData data : enabling) {
                installer = this.mContext.getPackageManager().getPackageInstaller();
                session = installer.getSessionInfo(data.stagedSessionId);
                if (session == null) continue;
                if (session.isStagedSessionApplied()) {
                    this.makeRollbackAvailable(data);
                    continue;
                }
                if (!session.isStagedSessionFailed()) continue;
                this.deleteRollback(data);
            }
            for (RollbackData data : restoreInProgress) {
                installer = this.mContext.getPackageManager().getPackageInstaller();
                session = installer.getSessionInfo(data.stagedSessionId);
                if (session == null || !session.isStagedSessionApplied() && !session.isStagedSessionFailed()) continue;
                Object object = this.mLock;
                synchronized (object) {
                    data.restoreUserDataInProgress = false;
                }
                this.saveRollbackData(data);
            }
            for (String apexPackageName : apexPackageNames) {
                this.onPackageReplaced(apexPackageName);
            }
            this.mPackageHealthObserver.onBootCompletedAsync();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRollbackDataLoaded() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private void ensureRollbackDataLoadedLocked() {
        if (this.mRollbacks == null) {
            this.loadAllRollbackDataLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private void loadAllRollbackDataLocked() {
        this.mRollbacks = this.mRollbackStore.loadAllRollbackData();
        for (RollbackData data : this.mRollbacks) {
            this.mAllocatedRollbackIds.put(data.info.getRollbackId(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPackageReplaced(String packageName) {
        VersionedPackage installedVersion = this.getInstalledPackageVersion(packageName);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
            Iterator<RollbackData> iter = this.mRollbacks.iterator();
            block3: while (iter.hasNext()) {
                RollbackData data = iter.next();
                if (data.state != 1 && data.state != 0) continue;
                for (PackageRollbackInfo info : data.info.getPackages()) {
                    if (!info.getPackageName().equals(packageName) || this.packageVersionsEqual(info.getVersionRolledBackFrom(), installedVersion)) continue;
                    iter.remove();
                    this.deleteRollback(data);
                    continue block3;
                }
            }
        }
    }

    private void onPackageFullyRemoved(String packageName) {
        this.expireRollbackForPackage(packageName);
    }

    private void sendFailure(IntentSender statusReceiver, int status, String message) {
        Log.e(TAG, message);
        try {
            Intent fillIn = new Intent();
            fillIn.putExtra("android.content.rollback.extra.STATUS", status);
            fillIn.putExtra("android.content.rollback.extra.STATUS_MESSAGE", message);
            statusReceiver.sendIntent(this.mContext, 0, fillIn, null, null);
        }
        catch (IntentSender.SendIntentException sendIntentException) {
            // empty catch block
        }
    }

    private void sendSuccess(IntentSender statusReceiver) {
        try {
            Intent fillIn = new Intent();
            fillIn.putExtra("android.content.rollback.extra.STATUS", 0);
            statusReceiver.sendIntent(this.mContext, 0, fillIn, null, null);
        }
        catch (IntentSender.SendIntentException sendIntentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExpiration() {
        Instant now = Instant.now();
        Instant oldest = null;
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
            Iterator<RollbackData> iter = this.mRollbacks.iterator();
            while (iter.hasNext()) {
                RollbackData data = iter.next();
                if (data.state != 1) continue;
                if (!now.isBefore(data.timestamp.plusMillis(this.mRollbackLifetimeDurationInMillis))) {
                    iter.remove();
                    this.deleteRollback(data);
                    continue;
                }
                if (oldest != null && !oldest.isAfter(data.timestamp)) continue;
                oldest = data.timestamp;
            }
        }
        if (oldest != null) {
            this.scheduleExpiration(now.until(oldest.plusMillis(this.mRollbackLifetimeDurationInMillis), ChronoUnit.MILLIS));
        }
    }

    private void scheduleExpiration(long duration) {
        this.getHandler().postDelayed(() -> this.runExpiration(), duration);
    }

    private Handler getHandler() {
        return this.mHandlerThread.getThreadHandler();
    }

    private boolean sessionMatchesForEnableRollback(PackageInstaller.SessionInfo session, int installFlags, File newPackageCodePath) {
        if (session == null || session.resolvedBaseCodePath == null) {
            return false;
        }
        File packageCodePath = new File(session.resolvedBaseCodePath).getParentFile();
        return newPackageCodePath.equals(packageCodePath) && installFlags == session.installFlags;
    }

    private Context getContextAsUser(UserHandle user) {
        try {
            return this.mContext.createPackageContextAsUser(this.mContext.getPackageName(), 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean enableRollback(int installFlags, File newPackageCodePath, int[] installedUsers, int user, int token) {
        void var11_17;
        Context context = this.getContextAsUser(UserHandle.of(user));
        if (context == null) {
            Log.e(TAG, "Unable to create context for install session user.");
            return false;
        }
        PackageInstaller.SessionInfo parentSession = null;
        PackageInstaller.SessionInfo packageSession = null;
        PackageInstaller installer = context.getPackageManager().getPackageInstaller();
        block8: for (PackageInstaller.SessionInfo sessionInfo : installer.getAllSessions()) {
            if (sessionInfo.isMultiPackage()) {
                for (int childId : sessionInfo.getChildSessionIds()) {
                    PackageInstaller.SessionInfo child = installer.getSessionInfo(childId);
                    if (!this.sessionMatchesForEnableRollback(child, installFlags, newPackageCodePath)) continue;
                    parentSession = sessionInfo;
                    packageSession = child;
                    continue block8;
                }
                continue;
            }
            if (!this.sessionMatchesForEnableRollback(sessionInfo, installFlags, newPackageCodePath)) continue;
            parentSession = sessionInfo;
            packageSession = sessionInfo;
            break;
        }
        if (parentSession == null || packageSession == null) {
            Log.e(TAG, "Unable to find session for enabled rollback.");
            return false;
        }
        RollbackData rd = null;
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
            for (int i = 0; i < this.mRollbacks.size(); ++i) {
                RollbackData data = this.mRollbacks.get(i);
                if (data.apkSessionId != parentSession.getSessionId()) continue;
                rd = data;
                break;
            }
        }
        if (rd != null) {
            PackageParser.PackageLite packageLite;
            Object var11_13 = null;
            try {
                packageLite = PackageParser.parsePackageLite(new File(packageSession.resolvedBaseCodePath), 0);
            }
            catch (PackageParser.PackageParserException e) {
                Log.e(TAG, "Unable to parse new package", e);
                return false;
            }
            String packageName = packageLite.packageName;
            for (PackageRollbackInfo info3 : rd.info.getPackages()) {
                if (!info3.getPackageName().equals(packageName)) continue;
                info3.getInstalledUsers().addAll(IntArray.wrap(installedUsers));
                return true;
            }
            Log.e(TAG, "Unable to find package in apk session");
            return false;
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            NewRollback newRollback = this.getNewRollbackForPackageSessionLocked(packageSession.getSessionId());
            if (newRollback == null) {
                NewRollback newRollback2 = this.createNewRollbackLocked(parentSession);
                this.mNewRollbacks.add(newRollback2);
            }
        }
        var11_17.addToken(token);
        return this.enableRollbackForPackageSession(var11_17.data, packageSession, installedUsers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enableRollbackForPackageSession(RollbackData data, PackageInstaller.SessionInfo session, int[] installedUsers) {
        PackageInfo pkgInfo;
        int installFlags = session.installFlags;
        if ((installFlags & 0x40000) == 0) {
            Log.e(TAG, "Rollback is not enabled.");
            return false;
        }
        if ((installFlags & 0x800) != 0) {
            Log.e(TAG, "Rollbacks not supported for instant app install");
            return false;
        }
        if (session.resolvedBaseCodePath == null) {
            Log.e(TAG, "Session code path has not been resolved.");
            return false;
        }
        PackageParser.PackageLite newPackage = null;
        try {
            newPackage = PackageParser.parsePackageLite(new File(session.resolvedBaseCodePath), 0);
        }
        catch (PackageParser.PackageParserException e) {
            Log.e(TAG, "Unable to parse new package", e);
            return false;
        }
        String packageName = newPackage.packageName;
        Log.i(TAG, "Enabling rollback for install of " + packageName + ", session:" + session.sessionId);
        String installerPackageName = session.getInstallerPackageName();
        if (!this.enableRollbackAllowed(installerPackageName, packageName)) {
            Log.e(TAG, "Installer " + installerPackageName + " is not allowed to enable rollback on " + packageName);
            return false;
        }
        VersionedPackage newVersion = new VersionedPackage(packageName, newPackage.versionCode);
        boolean isApex = (installFlags & 0x20000) != 0;
        PackageManager pm = this.mContext.getPackageManager();
        try {
            pkgInfo = this.getPackageInfo(packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, packageName + " is not installed");
            return false;
        }
        VersionedPackage installedVersion = new VersionedPackage(packageName, pkgInfo.getLongVersionCode());
        PackageRollbackInfo packageRollbackInfo = new PackageRollbackInfo(newVersion, installedVersion, new IntArray(), new ArrayList<PackageRollbackInfo.RestoreInfo>(), isApex, IntArray.wrap(installedUsers), new SparseLongArray());
        try {
            ApplicationInfo appInfo = pkgInfo.applicationInfo;
            RollbackStore.backupPackageCodePath(data, packageName, appInfo.sourceDir);
            if (!ArrayUtils.isEmpty(appInfo.splitSourceDirs)) {
                for (String sourceDir : appInfo.splitSourceDirs) {
                    RollbackStore.backupPackageCodePath(data, packageName, sourceDir);
                }
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to copy package for rollback for " + packageName, e);
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            data.info.getPackages().add(packageRollbackInfo);
        }
        return true;
    }

    @Override
    public void snapshotAndRestoreUserData(String packageName, int[] userIds, int appId, long ceDataInode, String seInfo, int token) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("snapshotAndRestoreUserData may only be called by the system.");
        }
        this.getHandler().post(() -> {
            this.snapshotUserDataInternal(packageName);
            this.restoreUserDataInternal(packageName, userIds, appId, ceDataInode, seInfo, token);
            PackageManagerInternal pmi = LocalServices.getService(PackageManagerInternal.class);
            pmi.finishPackageInstall(token, false);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshotUserDataInternal(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
            block3: for (int i = 0; i < this.mRollbacks.size(); ++i) {
                RollbackData data = this.mRollbacks.get(i);
                if (data.state != 0) continue;
                for (PackageRollbackInfo info : data.info.getPackages()) {
                    if (!info.getPackageName().equals(packageName)) continue;
                    this.mAppDataRollbackHelper.snapshotAppData(data.info.getRollbackId(), info);
                    this.saveRollbackData(data);
                    continue block3;
                }
            }
            for (NewRollback rollback : this.mNewRollbacks) {
                PackageRollbackInfo info = RollbackManagerServiceImpl.getPackageRollbackInfo(rollback.data, packageName);
                if (info == null) continue;
                this.mAppDataRollbackHelper.snapshotAppData(rollback.data.info.getRollbackId(), info);
                this.saveRollbackData(rollback.data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreUserDataInternal(String packageName, int[] userIds, int appId, long ceDataInode, String seInfo, int token) {
        PackageRollbackInfo info = null;
        RollbackData rollbackData = null;
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
            for (int i = 0; i < this.mRollbacks.size(); ++i) {
                RollbackData data = this.mRollbacks.get(i);
                if (!data.restoreUserDataInProgress || (info = RollbackManagerServiceImpl.getPackageRollbackInfo(data, packageName)) == null) continue;
                rollbackData = data;
                break;
            }
        }
        if (rollbackData == null) {
            return;
        }
        for (Object userId : (Object)userIds) {
            boolean changedRollbackData = this.mAppDataRollbackHelper.restoreAppData(rollbackData.info.getRollbackId(), info, (int)userId, appId, seInfo);
            if (!changedRollbackData) continue;
            this.saveRollbackData(rollbackData);
        }
    }

    @Override
    public boolean notifyStagedSession(int sessionId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("notifyStagedSession may only be called by the system.");
        }
        LinkedBlockingQueue result = new LinkedBlockingQueue();
        this.getHandler().post(() -> {
            NewRollback newRollback;
            PackageInstaller installer = this.mContext.getPackageManager().getPackageInstaller();
            PackageInstaller.SessionInfo session = installer.getSessionInfo(sessionId);
            if (session == null) {
                Log.e(TAG, "No matching install session for: " + sessionId);
                result.offer(false);
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                newRollback = this.createNewRollbackLocked(session);
            }
            if (!session.isMultiPackage()) {
                if (!this.enableRollbackForPackageSession(newRollback.data, session, new int[0])) {
                    Log.e(TAG, "Unable to enable rollback for session: " + sessionId);
                    result.offer(false);
                    return;
                }
            } else {
                for (Object childSessionId : (Object)session.getChildSessionIds()) {
                    PackageInstaller.SessionInfo childSession = installer.getSessionInfo((int)childSessionId);
                    if (childSession == null) {
                        Log.e(TAG, "No matching child install session for: " + (int)childSessionId);
                        result.offer(false);
                        return;
                    }
                    if (this.enableRollbackForPackageSession(newRollback.data, childSession, new int[0])) continue;
                    Log.e(TAG, "Unable to enable rollback for session: " + sessionId);
                    result.offer(false);
                    return;
                }
            }
            result.offer(this.completeEnableRollback(newRollback, true) != null);
        });
        try {
            return (Boolean)result.take();
        }
        catch (InterruptedException ie) {
            Log.e(TAG, "Interrupted while waiting for notifyStagedSession response");
            return false;
        }
    }

    @Override
    public void notifyStagedApkSession(int originalSessionId, int apkSessionId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("notifyStagedApkSession may only be called by the system.");
        }
        this.getHandler().post(() -> {
            RollbackData rd = null;
            Object object = this.mLock;
            synchronized (object) {
                this.ensureRollbackDataLoadedLocked();
                for (int i = 0; i < this.mRollbacks.size(); ++i) {
                    RollbackData data = this.mRollbacks.get(i);
                    if (data.stagedSessionId != originalSessionId) continue;
                    data.apkSessionId = apkSessionId;
                    rd = data;
                    break;
                }
            }
            if (rd != null) {
                this.saveRollbackData(rd);
            }
        });
    }

    private boolean enableRollbackAllowed(String installerPackageName, String packageName) {
        if (installerPackageName == null) {
            return false;
        }
        PackageManager pm = this.mContext.getPackageManager();
        boolean manageRollbacksGranted = pm.checkPermission("android.permission.MANAGE_ROLLBACKS", installerPackageName) == 0;
        boolean testManageRollbacksGranted = pm.checkPermission("android.permission.TEST_MANAGE_ROLLBACKS", installerPackageName) == 0;
        return this.isModule(packageName) && manageRollbacksGranted || testManageRollbacksGranted;
    }

    private boolean isModule(String packageName) {
        ModuleInfo moduleInfo;
        PackageManager pm = this.mContext.getPackageManager();
        try {
            moduleInfo = pm.getModuleInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return moduleInfo != null;
    }

    private VersionedPackage getInstalledPackageVersion(String packageName) {
        PackageManager pm = this.mContext.getPackageManager();
        PackageInfo pkgInfo = null;
        try {
            pkgInfo = this.getPackageInfo(packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        return new VersionedPackage(packageName, pkgInfo.getLongVersionCode());
    }

    private PackageInfo getPackageInfo(String packageName) throws PackageManager.NameNotFoundException {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            return pm.getPackageInfo(packageName, 0x400000);
        }
        catch (PackageManager.NameNotFoundException e) {
            return pm.getPackageInfo(packageName, 0x40000000);
        }
    }

    private boolean packageVersionsEqual(VersionedPackage a, VersionedPackage b) {
        return a != null && b != null && a.getPackageName().equals(b.getPackageName()) && a.getLongVersionCode() == b.getLongVersionCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RollbackData completeEnableRollback(NewRollback newRollback, boolean success) {
        RollbackData data = newRollback.data;
        if (!success) {
            this.deleteRollback(data);
            return null;
        }
        if (newRollback.isCancelled) {
            Log.e(TAG, "Rollback has been cancelled by PackageManager");
            this.deleteRollback(data);
            return null;
        }
        if (data.info.getPackages().size() != newRollback.packageSessionIds.length) {
            Log.e(TAG, "Failed to enable rollback for all packages in session.");
            this.deleteRollback(data);
            return null;
        }
        this.saveRollbackData(data);
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
            this.mRollbacks.add(data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRollbackAvailable(RollbackData data) {
        Object object = this.mLock;
        synchronized (object) {
            data.state = 1;
            data.timestamp = Instant.now();
        }
        this.saveRollbackData(data);
        ArrayList<String> packages = new ArrayList<String>();
        for (int i = 0; i < data.info.getPackages().size(); ++i) {
            packages.add(data.info.getPackages().get(i).getPackageName());
        }
        this.mPackageHealthObserver.startObservingHealth(packages, this.mRollbackLifetimeDurationInMillis);
        this.scheduleExpiration(this.mRollbackLifetimeDurationInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RollbackData getRollbackForId(int rollbackId) {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureRollbackDataLoadedLocked();
            for (int i = 0; i < this.mRollbacks.size(); ++i) {
                RollbackData data = this.mRollbacks.get(i);
                if (data.info.getRollbackId() != rollbackId) continue;
                return data;
            }
        }
        return null;
    }

    private static PackageRollbackInfo getPackageRollbackInfo(RollbackData data, String packageName) {
        for (PackageRollbackInfo info : data.info.getPackages()) {
            if (!info.getPackageName().equals(packageName)) continue;
            return info;
        }
        return null;
    }

    @GuardedBy(value={"mLock"})
    private int allocateRollbackIdLocked() {
        int n = 0;
        do {
            int rollbackId;
            if (this.mAllocatedRollbackIds.get(rollbackId = this.mRandom.nextInt(0x7FFFFFFE) + 1, false)) continue;
            this.mAllocatedRollbackIds.put(rollbackId, true);
            return rollbackId;
        } while (n++ < 32);
        throw new IllegalStateException("Failed to allocate rollback ID");
    }

    private void deleteRollback(RollbackData rollbackData) {
        for (PackageRollbackInfo info : rollbackData.info.getPackages()) {
            IntArray installedUsers = info.getInstalledUsers();
            for (int i = 0; i < installedUsers.size(); ++i) {
                int userId = installedUsers.get(i);
                this.mAppDataRollbackHelper.destroyAppDataSnapshot(rollbackData.info.getRollbackId(), info, userId);
            }
        }
        this.mRollbackStore.deleteRollbackData(rollbackData);
    }

    private void saveRollbackData(RollbackData rollbackData) {
        try {
            this.mRollbackStore.saveRollbackData(rollbackData);
        }
        catch (IOException ioe) {
            Log.e(TAG, "Unable to save rollback info for: " + rollbackData.info.getRollbackId(), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        Object object = this.mLock;
        synchronized (object) {
            for (RollbackData data : this.mRollbacks) {
                RollbackInfo info = data.info;
                ipw.println(info.getRollbackId() + ":");
                ipw.increaseIndent();
                ipw.println("-state: " + data.getStateAsString());
                ipw.println("-timestamp: " + data.timestamp);
                if (data.stagedSessionId != -1) {
                    ipw.println("-stagedSessionId: " + data.stagedSessionId);
                }
                ipw.println("-packages:");
                ipw.increaseIndent();
                for (PackageRollbackInfo pkg : info.getPackages()) {
                    ipw.println(pkg.getPackageName() + " " + pkg.getVersionRolledBackFrom().getLongVersionCode() + " -> " + pkg.getVersionRolledBackTo().getLongVersionCode());
                }
                ipw.decreaseIndent();
                if (data.state == 3) {
                    ipw.println("-causePackages:");
                    ipw.increaseIndent();
                    for (VersionedPackage cPkg : info.getCausePackages()) {
                        ipw.println(cPkg.getPackageName() + " " + cPkg.getLongVersionCode());
                    }
                    ipw.decreaseIndent();
                    ipw.println("-committedSessionId: " + info.getCommittedSessionId());
                }
                ipw.decreaseIndent();
            }
        }
    }

    private void enforceManageRollbacks(String message) {
        if (0 != this.mContext.checkCallingOrSelfPermission("android.permission.MANAGE_ROLLBACKS") && 0 != this.mContext.checkCallingOrSelfPermission("android.permission.TEST_MANAGE_ROLLBACKS")) {
            throw new SecurityException(message + " requires " + "android.permission.MANAGE_ROLLBACKS" + " or " + "android.permission.TEST_MANAGE_ROLLBACKS");
        }
    }

    NewRollback createNewRollbackLocked(PackageInstaller.SessionInfo parentSession) {
        int rollbackId = this.allocateRollbackIdLocked();
        int parentSessionId = parentSession.getSessionId();
        RollbackData data = parentSession.isStaged() ? this.mRollbackStore.createStagedRollback(rollbackId, parentSessionId) : this.mRollbackStore.createNonStagedRollback(rollbackId);
        int[] packageSessionIds = parentSession.isMultiPackage() ? parentSession.getChildSessionIds() : new int[]{parentSessionId};
        return new NewRollback(data, packageSessionIds);
    }

    NewRollback getNewRollbackForPackageSessionLocked(int packageSessionId) {
        for (NewRollback newRollbackData : this.mNewRollbacks) {
            for (int id2 : newRollbackData.packageSessionIds) {
                if (id2 != packageSessionId) continue;
                return newRollbackData;
            }
        }
        return null;
    }

    private static class NewRollback {
        public final RollbackData data;
        private final IntArray mTokens = new IntArray();
        public final int[] packageSessionIds;
        public boolean isCancelled = false;

        NewRollback(RollbackData data, int[] packageSessionIds) {
            this.data = data;
            this.packageSessionIds = packageSessionIds;
        }

        public void addToken(int token) {
            this.mTokens.add(token);
        }

        public boolean hasToken(int token) {
            return this.mTokens.indexOf(token) != -1;
        }
    }

    private class SessionCallback
    extends PackageInstaller.SessionCallback {
        private SessionCallback() {
        }

        @Override
        public void onCreated(int sessionId) {
        }

        @Override
        public void onBadgingChanged(int sessionId) {
        }

        @Override
        public void onActiveChanged(int sessionId, boolean active) {
        }

        @Override
        public void onProgressChanged(int sessionId, float progress) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFinished(int sessionId, boolean success) {
            RollbackData rollback;
            NewRollback newRollback;
            Object object = RollbackManagerServiceImpl.this.mLock;
            synchronized (object) {
                newRollback = RollbackManagerServiceImpl.this.getNewRollbackForPackageSessionLocked(sessionId);
                if (newRollback != null) {
                    RollbackManagerServiceImpl.this.mNewRollbacks.remove(newRollback);
                }
            }
            if (newRollback != null && (rollback = RollbackManagerServiceImpl.this.completeEnableRollback(newRollback, success)) != null && !rollback.isStaged()) {
                RollbackManagerServiceImpl.this.makeRollbackAvailable(rollback);
            }
        }
    }
}

