/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.rollback;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.VersionedPackage;
import android.content.rollback.PackageRollbackInfo;
import android.content.rollback.RollbackInfo;
import android.content.rollback.RollbackManager;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Slog;
import android.util.StatsLog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.PackageWatchdog;
import com.android.server.rollback.LocalIntentReceiver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;

public final class RollbackPackageHealthObserver
implements PackageWatchdog.PackageHealthObserver {
    private static final String TAG = "RollbackPackageHealthObserver";
    private static final String NAME = "rollback-observer";
    private static final int INVALID_ROLLBACK_ID = -1;
    private static final long NATIVE_CRASH_POLLING_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static final long NUMBER_OF_NATIVE_CRASH_POLLS = 10L;
    private final Context mContext;
    private final Handler mHandler;
    private final File mLastStagedRollbackIdFile;
    @GuardedBy(value={"mPendingStagedRollbackIds"})
    private final Set<Integer> mPendingStagedRollbackIds = new ArraySet<Integer>();
    private long mNumberOfNativeCrashPollsRemaining;

    RollbackPackageHealthObserver(Context context) {
        this.mContext = context;
        this.mNumberOfNativeCrashPollsRemaining = 10L;
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mHandler = handlerThread.getThreadHandler();
        File dataDir = new File(Environment.getDataDirectory(), NAME);
        dataDir.mkdirs();
        this.mLastStagedRollbackIdFile = new File(dataDir, "last-staged-rollback-id");
        PackageWatchdog.getInstance(this.mContext).registerHealthObserver(this);
    }

    @Override
    public int onHealthCheckFailed(VersionedPackage failedPackage) {
        if (this.getAvailableRollback(this.mContext.getSystemService(RollbackManager.class), failedPackage) == null) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean execute(VersionedPackage failedPackage) {
        RollbackManager rollbackManager = this.mContext.getSystemService(RollbackManager.class);
        VersionedPackage moduleMetadataPackage = this.getModuleMetadataPackage();
        RollbackInfo rollback = this.getAvailableRollback(rollbackManager, failedPackage);
        if (rollback == null) {
            Slog.w(TAG, "Expected rollback but no valid rollback found for package: [ " + failedPackage.getPackageName() + "] with versionCode: [" + failedPackage.getVersionCode() + "]");
            return false;
        }
        RollbackPackageHealthObserver.logEvent(moduleMetadataPackage, 1);
        LocalIntentReceiver rollbackReceiver = new LocalIntentReceiver(result -> {
            int status = result.getIntExtra("android.content.rollback.extra.STATUS", 1);
            if (status == 0) {
                if (rollback.isStaged()) {
                    int rollbackId = rollback.getRollbackId();
                    Set<Integer> set = this.mPendingStagedRollbackIds;
                    synchronized (set) {
                        this.mPendingStagedRollbackIds.add(rollbackId);
                    }
                    BroadcastReceiver listener = this.listenForStagedSessionReady(rollbackManager, rollbackId, moduleMetadataPackage);
                    this.handleStagedSessionChange(rollbackManager, rollbackId, listener, moduleMetadataPackage);
                } else {
                    RollbackPackageHealthObserver.logEvent(moduleMetadataPackage, 2);
                }
            } else {
                RollbackPackageHealthObserver.logEvent(moduleMetadataPackage, 3);
            }
        });
        this.mHandler.post(() -> rollbackManager.commitRollback(rollback.getRollbackId(), Collections.singletonList(failedPackage), rollbackReceiver.getIntentSender()));
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void startObservingHealth(List<String> packages, long durationMs) {
        PackageWatchdog.getInstance(this.mContext).startObservingHealth(this, packages, durationMs);
    }

    public void onBootCompletedAsync() {
        this.mHandler.post(() -> this.onBootCompleted());
    }

    private void onBootCompleted() {
        int n;
        PackageInstaller.SessionInfo sessionInfo;
        int rollbackId;
        RollbackManager rollbackManager = this.mContext.getSystemService(RollbackManager.class);
        PackageInstaller packageInstaller = this.mContext.getPackageManager().getPackageInstaller();
        String moduleMetadataPackageName = this.getModuleMetadataPackageName();
        VersionedPackage newModuleMetadataPackage = this.getModuleMetadataPackage();
        if (this.getAvailableRollback(rollbackManager, newModuleMetadataPackage) != null) {
            this.scheduleCheckAndMitigateNativeCrashes();
        }
        if ((rollbackId = this.popLastStagedRollbackId()) == -1) {
            return;
        }
        RollbackInfo rollback = null;
        for (RollbackInfo rollbackInfo : rollbackManager.getRecentlyCommittedRollbacks()) {
            if (rollbackId != rollbackInfo.getRollbackId()) continue;
            rollback = rollbackInfo;
            break;
        }
        if (rollback == null) {
            Slog.e(TAG, "rollback info not found for last staged rollback: " + rollbackId);
            return;
        }
        VersionedPackage oldModuleMetadataPackage = null;
        for (PackageRollbackInfo packageRollback : rollback.getPackages()) {
            if (!packageRollback.getPackageName().equals(moduleMetadataPackageName)) continue;
            oldModuleMetadataPackage = packageRollback.getVersionRolledBackFrom();
            break;
        }
        if ((sessionInfo = packageInstaller.getSessionInfo(n = rollback.getCommittedSessionId())) == null) {
            Slog.e(TAG, "On boot completed, could not load session id " + n);
            return;
        }
        if (sessionInfo.isStagedSessionApplied()) {
            RollbackPackageHealthObserver.logEvent(oldModuleMetadataPackage, 2);
        } else if (!sessionInfo.isStagedSessionReady()) {
            RollbackPackageHealthObserver.logEvent(oldModuleMetadataPackage, 3);
        }
    }

    private RollbackInfo getAvailableRollback(RollbackManager rollbackManager, VersionedPackage failedPackage) {
        for (RollbackInfo rollback : rollbackManager.getAvailableRollbacks()) {
            for (PackageRollbackInfo packageRollback : rollback.getPackages()) {
                boolean hasFailedPackage = packageRollback.getPackageName().equals(failedPackage.getPackageName()) && packageRollback.getVersionRolledBackFrom().getVersionCode() == failedPackage.getVersionCode();
                if (!hasFailedPackage) continue;
                return rollback;
            }
        }
        return null;
    }

    private String getModuleMetadataPackageName() {
        String packageName = this.mContext.getResources().getString(17039705);
        if (TextUtils.isEmpty(packageName)) {
            return null;
        }
        return packageName;
    }

    private VersionedPackage getModuleMetadataPackage() {
        String packageName = this.getModuleMetadataPackageName();
        if (packageName == null) {
            return null;
        }
        try {
            return new VersionedPackage(packageName, this.mContext.getPackageManager().getPackageInfo(packageName, 0).getLongVersionCode());
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(TAG, "Module metadata provider not found");
            return null;
        }
    }

    private BroadcastReceiver listenForStagedSessionReady(final RollbackManager rollbackManager, final int rollbackId, final VersionedPackage moduleMetadataPackage) {
        BroadcastReceiver sessionUpdatedReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                RollbackPackageHealthObserver.this.handleStagedSessionChange(rollbackManager, rollbackId, this, moduleMetadataPackage);
            }
        };
        IntentFilter sessionUpdatedFilter = new IntentFilter("android.content.pm.action.SESSION_UPDATED");
        this.mContext.registerReceiver(sessionUpdatedReceiver, sessionUpdatedFilter);
        return sessionUpdatedReceiver;
    }

    private void handleStagedSessionChange(RollbackManager rollbackManager, int rollbackId, BroadcastReceiver listener, VersionedPackage moduleMetadataPackage) {
        PackageInstaller packageInstaller = this.mContext.getPackageManager().getPackageInstaller();
        List<RollbackInfo> recentRollbacks = rollbackManager.getRecentlyCommittedRollbacks();
        for (int i = 0; i < recentRollbacks.size(); ++i) {
            RollbackInfo recentRollback = recentRollbacks.get(i);
            int sessionId = recentRollback.getCommittedSessionId();
            if (rollbackId != recentRollback.getRollbackId() || sessionId == -1) continue;
            PackageInstaller.SessionInfo sessionInfo = packageInstaller.getSessionInfo(sessionId);
            if (sessionInfo.isStagedSessionReady() && this.markStagedSessionHandled(rollbackId)) {
                this.mContext.unregisterReceiver(listener);
                this.saveLastStagedRollbackId(rollbackId);
                RollbackPackageHealthObserver.logEvent(moduleMetadataPackage, 4);
                this.mContext.getSystemService(PowerManager.class).reboot("Rollback staged install");
                continue;
            }
            if (!sessionInfo.isStagedSessionFailed() || !this.markStagedSessionHandled(rollbackId)) continue;
            RollbackPackageHealthObserver.logEvent(moduleMetadataPackage, 3);
            this.mContext.unregisterReceiver(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean markStagedSessionHandled(int rollbackId) {
        Set<Integer> set = this.mPendingStagedRollbackIds;
        synchronized (set) {
            return this.mPendingStagedRollbackIds.remove(rollbackId);
        }
    }

    private void saveLastStagedRollbackId(int stagedRollbackId) {
        try {
            FileOutputStream fos = new FileOutputStream(this.mLastStagedRollbackIdFile);
            PrintWriter pw = new PrintWriter(fos);
            pw.println(stagedRollbackId);
            pw.flush();
            FileUtils.sync(fos);
            pw.close();
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to save last staged rollback id", e);
            this.mLastStagedRollbackIdFile.delete();
        }
    }

    private int popLastStagedRollbackId() {
        int rollbackId = -1;
        if (!this.mLastStagedRollbackIdFile.exists()) {
            return rollbackId;
        }
        try {
            rollbackId = Integer.parseInt(IoUtils.readFileAsString(this.mLastStagedRollbackIdFile.getAbsolutePath()).trim());
        }
        catch (IOException | NumberFormatException e) {
            Slog.e(TAG, "Failed to retrieve last staged rollback id", e);
        }
        this.mLastStagedRollbackIdFile.delete();
        return rollbackId;
    }

    private static void logEvent(VersionedPackage moduleMetadataPackage, int type) {
        Slog.i(TAG, "Watchdog event occurred of type: " + type);
        if (moduleMetadataPackage != null) {
            StatsLog.logWatchdogRollbackOccurred(type, moduleMetadataPackage.getPackageName(), moduleMetadataPackage.getVersionCode());
        }
    }

    private void checkAndMitigateNativeCrashes() {
        --this.mNumberOfNativeCrashPollsRemaining;
        if ("1".equals(SystemProperties.get("ro.init.updatable_crashing"))) {
            this.execute(this.getModuleMetadataPackage());
        } else if (this.mNumberOfNativeCrashPollsRemaining > 0L) {
            this.mHandler.postDelayed(() -> this.checkAndMitigateNativeCrashes(), NATIVE_CRASH_POLLING_INTERVAL_MILLIS);
        }
    }

    private void scheduleCheckAndMitigateNativeCrashes() {
        Slog.i(TAG, "Scheduling " + this.mNumberOfNativeCrashPollsRemaining + " polls to check and mitigate native crashes");
        this.mHandler.post(() -> this.checkAndMitigateNativeCrashes());
    }
}

