/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.search;

import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.IActivityTaskManager;
import android.app.ISearchManager;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.search.Searchables;
import com.android.server.statusbar.StatusBarManagerInternal;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class SearchManagerService
extends ISearchManager.Stub {
    private static final String TAG = "SearchManagerService";
    final Handler mHandler;
    private final Context mContext;
    @GuardedBy(value={"mSearchables"})
    private final SparseArray<Searchables> mSearchables = new SparseArray();

    public SearchManagerService(Context context) {
        this.mContext = context;
        new MyPackageMonitor().register(context, null, UserHandle.ALL, true);
        new GlobalSearchProviderObserver(context.getContentResolver());
        this.mHandler = BackgroundThread.getHandler();
    }

    private Searchables getSearchables(int userId) {
        return this.getSearchables(userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Searchables getSearchables(int userId, boolean forceUpdate) {
        long token = Binder.clearCallingIdentity();
        try {
            UserManager um = this.mContext.getSystemService(UserManager.class);
            if (um.getUserInfo(userId) == null) {
                throw new IllegalStateException("User " + userId + " doesn't exist");
            }
            if (!um.isUserUnlockingOrUnlocked(userId)) {
                throw new IllegalStateException("User " + userId + " isn't unlocked");
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        SparseArray<Searchables> sparseArray = this.mSearchables;
        synchronized (sparseArray) {
            Searchables searchables = this.mSearchables.get(userId);
            if (searchables == null) {
                searchables = new Searchables(this.mContext, userId);
                searchables.updateSearchableList();
                this.mSearchables.append(userId, searchables);
            } else if (forceUpdate) {
                searchables.updateSearchableList();
            }
            return searchables;
        }
    }

    private void onUnlockUser(int userId) {
        try {
            this.getSearchables(userId, true);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCleanupUser(int userId) {
        SparseArray<Searchables> sparseArray = this.mSearchables;
        synchronized (sparseArray) {
            this.mSearchables.remove(userId);
        }
    }

    @Override
    public SearchableInfo getSearchableInfo(ComponentName launchActivity) {
        if (launchActivity == null) {
            Log.e(TAG, "getSearchableInfo(), activity == null");
            return null;
        }
        return this.getSearchables(UserHandle.getCallingUserId()).getSearchableInfo(launchActivity);
    }

    @Override
    public List<SearchableInfo> getSearchablesInGlobalSearch() {
        return this.getSearchables(UserHandle.getCallingUserId()).getSearchablesInGlobalSearchList();
    }

    @Override
    public List<ResolveInfo> getGlobalSearchActivities() {
        return this.getSearchables(UserHandle.getCallingUserId()).getGlobalSearchActivities();
    }

    @Override
    public ComponentName getGlobalSearchActivity() {
        return this.getSearchables(UserHandle.getCallingUserId()).getGlobalSearchActivity();
    }

    @Override
    public ComponentName getWebSearchActivity() {
        return this.getSearchables(UserHandle.getCallingUserId()).getWebSearchActivity();
    }

    @Override
    public void launchAssist(Bundle args) {
        StatusBarManagerInternal statusBarManager = LocalServices.getService(StatusBarManagerInternal.class);
        if (statusBarManager != null) {
            statusBarManager.startAssist(args);
        }
    }

    private ComponentName getLegacyAssistComponent(int userHandle) {
        try {
            userHandle = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userHandle, true, false, "getLegacyAssistComponent", null);
            PackageManager pm = this.mContext.getPackageManager();
            Intent intentAssistProbe = new Intent("android.service.voice.VoiceInteractionService");
            List<ResolveInfo> infoListVis = pm.queryIntentServicesAsUser(intentAssistProbe, 0x100000, userHandle);
            if (infoListVis == null || infoListVis.isEmpty()) {
                return null;
            }
            ResolveInfo rInfo = infoListVis.get(0);
            return new ComponentName(rInfo.serviceInfo.applicationInfo.packageName, rInfo.serviceInfo.name);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception in getLegacyAssistComponent: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean launchLegacyAssist(String hint, int userHandle, Bundle args) {
        ComponentName comp = this.getLegacyAssistComponent(userHandle);
        if (comp == null) {
            return false;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Intent intent = new Intent("android.service.voice.VoiceInteractionService");
            intent.setComponent(comp);
            IActivityTaskManager am = ActivityTaskManager.getService();
            if (args != null) {
                args.putInt("android.intent.extra.KEY_EVENT", 219);
            }
            intent.putExtras(args);
            boolean bl = am.launchAssistIntent(intent, 0, hint, userHandle, args);
            return bl;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        SparseArray<Searchables> sparseArray = this.mSearchables;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mSearchables.size(); ++i) {
                ipw.print("\nUser: ");
                ipw.println(this.mSearchables.keyAt(i));
                ipw.increaseIndent();
                this.mSearchables.valueAt(i).dump(fd, ipw, args);
                ipw.decreaseIndent();
            }
        }
    }

    class GlobalSearchProviderObserver
    extends ContentObserver {
        private final ContentResolver mResolver;

        public GlobalSearchProviderObserver(ContentResolver resolver) {
            super(null);
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Secure.getUriFor("search_global_search_activity"), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange) {
            SparseArray sparseArray = SearchManagerService.this.mSearchables;
            synchronized (sparseArray) {
                for (int i = 0; i < SearchManagerService.this.mSearchables.size(); ++i) {
                    ((Searchables)SearchManagerService.this.mSearchables.valueAt(i)).updateSearchableList();
                }
            }
            Intent intent = new Intent("android.search.action.GLOBAL_SEARCH_ACTIVITY_CHANGED");
            intent.addFlags(0x20000000);
            SearchManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        @Override
        public void onSomePackagesChanged() {
            this.updateSearchables();
        }

        @Override
        public void onPackageModified(String pkg) {
            this.updateSearchables();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSearchables() {
            int changingUserId = this.getChangingUserId();
            SparseArray sparseArray = SearchManagerService.this.mSearchables;
            synchronized (sparseArray) {
                for (int i = 0; i < SearchManagerService.this.mSearchables.size(); ++i) {
                    if (changingUserId != SearchManagerService.this.mSearchables.keyAt(i)) continue;
                    ((Searchables)SearchManagerService.this.mSearchables.valueAt(i)).updateSearchableList();
                    break;
                }
            }
            Intent intent = new Intent("android.search.action.SEARCHABLES_CHANGED");
            intent.addFlags(0x24000000);
            SearchManagerService.this.mContext.sendBroadcastAsUser(intent, new UserHandle(changingUserId));
        }
    }

    public static class Lifecycle
    extends SystemService {
        private SearchManagerService mService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mService = new SearchManagerService(this.getContext());
            this.publishBinderService("search", this.mService);
        }

        @Override
        public void onUnlockUser(final int userId) {
            this.mService.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mService.onUnlockUser(userId);
                }
            });
        }

        @Override
        public void onCleanupUser(int userHandle) {
            this.mService.onCleanupUser(userHandle);
        }
    }
}

