/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.security;

import android.os.SharedMemory;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Pair;
import android.util.Slog;
import android.util.apk.ApkSignatureVerifier;
import android.util.apk.ByteBufferFactory;
import android.util.apk.SignatureNotFoundException;
import android.util.apk.VerityBuilder;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import libcore.util.HexEncoding;
import sun.security.pkcs.PKCS7;

public abstract class VerityUtils {
    private static final String TAG = "VerityUtils";
    public static final String FSVERITY_SIGNATURE_FILE_EXTENSION = ".fsv_sig";
    private static final int MAX_SIGNATURE_FILE_SIZE_BYTES = 8192;
    private static final int COMMON_LINUX_PAGE_SIZE_IN_BYTES = 4096;
    private static final boolean DEBUG = false;

    public static boolean isFsveritySignatureFile(File file) {
        return file.getName().endsWith(FSVERITY_SIGNATURE_FILE_EXTENSION);
    }

    public static String getFsveritySignatureFilePath(String filePath) {
        return filePath + FSVERITY_SIGNATURE_FILE_EXTENSION;
    }

    public static void setUpFsverity(String filePath, String signaturePath) throws IOException, DigestException, NoSuchAlgorithmException {
        PKCS7 pkcs7 = new PKCS7(Files.readAllBytes(Paths.get(signaturePath, new String[0])));
        byte[] expectedMeasurement = pkcs7.getContentInfo().getContentBytes();
        TrackedBufferFactory bufferFactory = new TrackedBufferFactory();
        byte[] actualMeasurement = VerityUtils.generateFsverityMetadata(filePath, signaturePath, bufferFactory);
        try (RandomAccessFile raf = new RandomAccessFile(filePath, "rw");){
            long s;
            FileChannel ch = raf.getChannel();
            ch.position(VerityUtils.roundUpToNextMultiple(ch.size(), 4096L));
            ByteBuffer buffer = bufferFactory.getBuffer();
            long offset = buffer.position();
            for (long size = (long)buffer.limit(); offset < size; offset += s, size -= s) {
                s = ch.write(buffer);
            }
        }
        if (!Arrays.equals(expectedMeasurement, actualMeasurement)) {
            throw new SecurityException("fs-verity measurement mismatch: " + VerityUtils.bytesToString(actualMeasurement) + " != " + VerityUtils.bytesToString(expectedMeasurement));
        }
        int errno = VerityUtils.enableFsverityNative(filePath);
        if (errno != 0) {
            throw new IOException("Failed to enable fs-verity on " + filePath + ": " + Os.strerror(errno));
        }
    }

    public static boolean hasFsverity(String filePath) {
        int errno = VerityUtils.measureFsverityNative(filePath);
        if (errno != 0) {
            if (errno != OsConstants.ENODATA) {
                Slog.e(TAG, "Failed to measure fs-verity, errno " + errno + ": " + filePath);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SetupResult generateApkVeritySetupData(String apkPath) {
        try (SharedMemory shm = null;){
            byte[] signedVerityHash = ApkSignatureVerifier.getVerityRootHash(apkPath);
            if (signedVerityHash == null) {
                SetupResult setupResult = SetupResult.skipped();
                return setupResult;
            }
            Pair<SharedMemory, Integer> result = VerityUtils.generateFsVerityIntoSharedMemory(apkPath, signedVerityHash);
            shm = (SharedMemory)result.first;
            int contentSize = (Integer)result.second;
            FileDescriptor rfd = shm.getFileDescriptor();
            if (rfd == null || !rfd.valid()) {
                SetupResult setupResult = SetupResult.failed();
                return setupResult;
            }
            SetupResult setupResult = SetupResult.ok(Os.dup(rfd), contentSize);
            return setupResult;
        }
    }

    public static byte[] generateApkVerityRootHash(String apkPath) throws NoSuchAlgorithmException, DigestException, IOException {
        return ApkSignatureVerifier.generateApkVerityRootHash(apkPath);
    }

    public static byte[] getVerityRootHash(String apkPath) throws IOException, SignatureNotFoundException {
        return ApkSignatureVerifier.getVerityRootHash(apkPath);
    }

    private static byte[] generateFsverityMetadata(String filePath, String signaturePath, ByteBufferFactory trackedBufferFactory) throws IOException, DigestException, NoSuchAlgorithmException {
        try (RandomAccessFile file = new RandomAccessFile(filePath, "r");){
            VerityBuilder.VerityResult result = VerityBuilder.generateFsVerityTree(file, trackedBufferFactory);
            ByteBuffer buffer = result.verityData;
            buffer.position(result.merkleTreeSize);
            byte[] measurement = VerityUtils.generateFsverityDescriptorAndMeasurement(file, result.rootHash, signaturePath, buffer);
            buffer.flip();
            byte[] byArray = VerityUtils.constructFsveritySignedDataNative(measurement);
            return byArray;
        }
    }

    private static byte[] generateFsverityDescriptorAndMeasurement(RandomAccessFile file, byte[] rootHash, String pkcs7SignaturePath, ByteBuffer output) throws IOException, NoSuchAlgorithmException, DigestException {
        boolean kRootHashExtensionId = true;
        int kPkcs7SignatureExtensionId = 3;
        int origPosition = output.position();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] desc = VerityUtils.constructFsverityDescriptorNative(file.length());
        output.put(desc);
        md.update(desc);
        byte[] authExt = VerityUtils.constructFsverityExtensionNative((short)1, rootHash.length);
        output.put(authExt);
        output.put(rootHash);
        md.update(authExt);
        md.update(rootHash);
        ByteBuffer header = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        output.putShort((short)1);
        output.position(output.position() + 6);
        Path path = Paths.get(pkcs7SignaturePath, new String[0]);
        if (Files.size(path) > 8192L) {
            throw new IllegalArgumentException("Signature size is unexpectedly large: " + pkcs7SignaturePath);
        }
        byte[] pkcs7Signature = Files.readAllBytes(path);
        output.put(VerityUtils.constructFsverityExtensionNative((short)3, pkcs7Signature.length));
        output.put(pkcs7Signature);
        output.put(VerityUtils.constructFsverityFooterNative(output.position() - origPosition));
        return md.digest();
    }

    private static native int enableFsverityNative(String var0);

    private static native int measureFsverityNative(String var0);

    private static native byte[] constructFsveritySignedDataNative(byte[] var0);

    private static native byte[] constructFsverityDescriptorNative(long var0);

    private static native byte[] constructFsverityExtensionNative(short var0, int var1);

    private static native byte[] constructFsverityFooterNative(int var0);

    private static Pair<SharedMemory, Integer> generateFsVerityIntoSharedMemory(String apkPath, byte[] expectedRootHash) throws IOException, DigestException, NoSuchAlgorithmException, SignatureNotFoundException {
        TrackedShmBufferFactory shmBufferFactory = new TrackedShmBufferFactory();
        byte[] generatedRootHash = ApkSignatureVerifier.generateApkVerity(apkPath, shmBufferFactory);
        if (!Arrays.equals(expectedRootHash, generatedRootHash)) {
            throw new SecurityException("verity hash mismatch: " + VerityUtils.bytesToString(generatedRootHash) + " != " + VerityUtils.bytesToString(expectedRootHash));
        }
        int contentSize = shmBufferFactory.getBufferLimit();
        SharedMemory shm = shmBufferFactory.releaseSharedMemory();
        if (shm == null) {
            throw new IllegalStateException("Failed to generate verity tree into shared memory");
        }
        if (!shm.setProtect(OsConstants.PROT_READ)) {
            throw new SecurityException("Failed to set up shared memory correctly");
        }
        return Pair.create(shm, contentSize);
    }

    private static String bytesToString(byte[] bytes) {
        return HexEncoding.encodeToString(bytes);
    }

    private static long roundUpToNextMultiple(long number, long divisor) {
        if (number > Long.MAX_VALUE - divisor) {
            throw new IllegalArgumentException("arithmetic overflow");
        }
        return (number + (divisor - 1L)) / divisor * divisor;
    }

    private static class TrackedBufferFactory
    implements ByteBufferFactory {
        private ByteBuffer mBuffer;

        private TrackedBufferFactory() {
        }

        @Override
        public ByteBuffer create(int capacity) {
            if (this.mBuffer != null) {
                throw new IllegalStateException("Multiple instantiation from this factory");
            }
            this.mBuffer = ByteBuffer.allocate(capacity);
            return this.mBuffer;
        }

        public ByteBuffer getBuffer() {
            return this.mBuffer;
        }
    }

    private static class TrackedShmBufferFactory
    implements ByteBufferFactory {
        private SharedMemory mShm;
        private ByteBuffer mBuffer;

        private TrackedShmBufferFactory() {
        }

        @Override
        public ByteBuffer create(int capacity) {
            try {
                if (this.mBuffer != null) {
                    throw new IllegalStateException("Multiple instantiation from this factory");
                }
                this.mShm = SharedMemory.create("apkverity", capacity);
                if (!this.mShm.setProtect(OsConstants.PROT_READ | OsConstants.PROT_WRITE)) {
                    throw new SecurityException("Failed to set protection");
                }
                this.mBuffer = this.mShm.mapReadWrite();
                return this.mBuffer;
            }
            catch (ErrnoException e) {
                throw new SecurityException("Failed to set protection", e);
            }
        }

        public SharedMemory releaseSharedMemory() {
            if (this.mBuffer != null) {
                SharedMemory.unmap(this.mBuffer);
                this.mBuffer = null;
            }
            SharedMemory tmp = this.mShm;
            this.mShm = null;
            return tmp;
        }

        public int getBufferLimit() {
            return this.mBuffer == null ? -1 : this.mBuffer.limit();
        }
    }

    public static class SetupResult {
        private static final int RESULT_OK = 1;
        private static final int RESULT_SKIPPED = 2;
        private static final int RESULT_FAILED = 3;
        private final int mCode;
        private final FileDescriptor mFileDescriptor;
        private final int mContentSize;

        public static SetupResult ok(FileDescriptor fileDescriptor, int contentSize) {
            return new SetupResult(1, fileDescriptor, contentSize);
        }

        public static SetupResult skipped() {
            return new SetupResult(2, null, -1);
        }

        public static SetupResult failed() {
            return new SetupResult(3, null, -1);
        }

        private SetupResult(int code, FileDescriptor fileDescriptor, int contentSize) {
            this.mCode = code;
            this.mFileDescriptor = fileDescriptor;
            this.mContentSize = contentSize;
        }

        public boolean isFailed() {
            return this.mCode == 3;
        }

        public boolean isOk() {
            return this.mCode == 1;
        }

        public FileDescriptor getUnownedFileDescriptor() {
            return this.mFileDescriptor;
        }

        public int getContentSize() {
            return this.mContentSize;
        }
    }
}

