/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.slice;

import android.net.Uri;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.server.slice.DirtyTracker;
import com.android.server.slice.SlicePermissionManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class SliceClientPermissions
implements DirtyTracker,
DirtyTracker.Persistable {
    private static final String TAG = "SliceClientPermissions";
    static final String TAG_CLIENT = "client";
    private static final String TAG_AUTHORITY = "authority";
    private static final String TAG_PATH = "path";
    private static final String NAMESPACE = null;
    private static final String ATTR_PKG = "pkg";
    private static final String ATTR_AUTHORITY = "authority";
    private static final String ATTR_FULL_ACCESS = "fullAccess";
    private final SlicePermissionManager.PkgUser mPkg;
    private final ArrayMap<SlicePermissionManager.PkgUser, SliceAuthority> mAuths = new ArrayMap();
    private final DirtyTracker mTracker;
    private boolean mHasFullAccess;

    public SliceClientPermissions(SlicePermissionManager.PkgUser pkg, DirtyTracker tracker) {
        this.mPkg = pkg;
        this.mTracker = tracker;
    }

    public SlicePermissionManager.PkgUser getPkg() {
        return this.mPkg;
    }

    public synchronized Collection<SliceAuthority> getAuthorities() {
        return new ArrayList<SliceAuthority>(this.mAuths.values());
    }

    public synchronized SliceAuthority getOrCreateAuthority(SlicePermissionManager.PkgUser authority, SlicePermissionManager.PkgUser provider) {
        SliceAuthority ret = this.mAuths.get(authority);
        if (ret == null) {
            ret = new SliceAuthority(authority.getPkg(), provider, this);
            this.mAuths.put(authority, ret);
            this.onPersistableDirty(ret);
        }
        return ret;
    }

    public synchronized SliceAuthority getAuthority(SlicePermissionManager.PkgUser authority) {
        return this.mAuths.get(authority);
    }

    public boolean hasFullAccess() {
        return this.mHasFullAccess;
    }

    public void setHasFullAccess(boolean hasFullAccess) {
        if (this.mHasFullAccess == hasFullAccess) {
            return;
        }
        this.mHasFullAccess = hasFullAccess;
        this.mTracker.onPersistableDirty(this);
    }

    public void removeAuthority(String authority, int userId) {
        if (this.mAuths.remove(new SlicePermissionManager.PkgUser(authority, userId)) != null) {
            this.mTracker.onPersistableDirty(this);
        }
    }

    public synchronized boolean hasPermission(Uri uri, int userId) {
        if (!Objects.equals("content", uri.getScheme())) {
            return false;
        }
        SliceAuthority authority = this.getAuthority(new SlicePermissionManager.PkgUser(uri.getAuthority(), userId));
        return authority != null && authority.hasPermission(uri.getPathSegments());
    }

    public void grantUri(Uri uri, SlicePermissionManager.PkgUser providerPkg) {
        SliceAuthority authority = this.getOrCreateAuthority(new SlicePermissionManager.PkgUser(uri.getAuthority(), providerPkg.getUserId()), providerPkg);
        authority.addPath(uri.getPathSegments());
    }

    public void revokeUri(Uri uri, SlicePermissionManager.PkgUser providerPkg) {
        SliceAuthority authority = this.getOrCreateAuthority(new SlicePermissionManager.PkgUser(uri.getAuthority(), providerPkg.getUserId()), providerPkg);
        authority.removePath(uri.getPathSegments());
    }

    public void clear() {
        if (!this.mHasFullAccess && this.mAuths.isEmpty()) {
            return;
        }
        this.mHasFullAccess = false;
        this.mAuths.clear();
        this.onPersistableDirty(this);
    }

    @Override
    public void onPersistableDirty(DirtyTracker.Persistable obj) {
        this.mTracker.onPersistableDirty(this);
    }

    @Override
    public String getFileName() {
        return SliceClientPermissions.getFileName(this.mPkg);
    }

    @Override
    public synchronized void writeTo(XmlSerializer out) throws IOException {
        out.startTag(NAMESPACE, TAG_CLIENT);
        out.attribute(NAMESPACE, ATTR_PKG, this.mPkg.toString());
        out.attribute(NAMESPACE, ATTR_FULL_ACCESS, this.mHasFullAccess ? "1" : "0");
        int N = this.mAuths.size();
        for (int i = 0; i < N; ++i) {
            out.startTag(NAMESPACE, "authority");
            out.attribute(NAMESPACE, "authority", this.mAuths.valueAt(i).mAuthority);
            out.attribute(NAMESPACE, ATTR_PKG, this.mAuths.valueAt(i).mPkg.toString());
            this.mAuths.valueAt(i).writeTo(out);
            out.endTag(NAMESPACE, "authority");
        }
        out.endTag(NAMESPACE, TAG_CLIENT);
    }

    public static SliceClientPermissions createFrom(XmlPullParser parser, DirtyTracker tracker) throws XmlPullParserException, IOException {
        while (parser.getEventType() != 2 || !TAG_CLIENT.equals(parser.getName())) {
            parser.next();
        }
        int depth = parser.getDepth();
        SlicePermissionManager.PkgUser pkgUser = new SlicePermissionManager.PkgUser(parser.getAttributeValue(NAMESPACE, ATTR_PKG));
        SliceClientPermissions provider = new SliceClientPermissions(pkgUser, tracker);
        String fullAccess = parser.getAttributeValue(NAMESPACE, ATTR_FULL_ACCESS);
        if (fullAccess == null) {
            fullAccess = "0";
        }
        provider.mHasFullAccess = Integer.parseInt(fullAccess) != 0;
        parser.next();
        while (parser.getDepth() > depth) {
            if (parser.getEventType() == 2 && "authority".equals(parser.getName())) {
                try {
                    SlicePermissionManager.PkgUser pkg = new SlicePermissionManager.PkgUser(parser.getAttributeValue(NAMESPACE, ATTR_PKG));
                    SliceAuthority authority = new SliceAuthority(parser.getAttributeValue(NAMESPACE, "authority"), pkg, provider);
                    authority.readFrom(parser);
                    provider.mAuths.put(new SlicePermissionManager.PkgUser(authority.getAuthority(), pkg.getUserId()), authority);
                }
                catch (IllegalArgumentException e) {
                    Slog.e(TAG, "Couldn't read PkgUser", e);
                }
            }
            parser.next();
        }
        return provider;
    }

    public static String getFileName(SlicePermissionManager.PkgUser pkg) {
        return String.format("client_%s", pkg.toString());
    }

    public static class SliceAuthority
    implements DirtyTracker.Persistable {
        public static final String DELIMITER = "/";
        private final String mAuthority;
        private final DirtyTracker mTracker;
        private final SlicePermissionManager.PkgUser mPkg;
        private final ArraySet<String[]> mPaths = new ArraySet();

        public SliceAuthority(String authority, SlicePermissionManager.PkgUser pkg, DirtyTracker tracker) {
            this.mAuthority = authority;
            this.mPkg = pkg;
            this.mTracker = tracker;
        }

        public String getAuthority() {
            return this.mAuthority;
        }

        public SlicePermissionManager.PkgUser getPkg() {
            return this.mPkg;
        }

        void addPath(List<String> path) {
            String[] pathSegs = path.toArray(new String[path.size()]);
            for (int i = this.mPaths.size() - 1; i >= 0; --i) {
                String[] existing = this.mPaths.valueAt(i);
                if (this.isPathPrefixMatch(existing, pathSegs)) {
                    return;
                }
                if (!this.isPathPrefixMatch(pathSegs, existing)) continue;
                this.mPaths.removeAt(i);
            }
            this.mPaths.add(pathSegs);
            this.mTracker.onPersistableDirty(this);
        }

        void removePath(List<String> path) {
            boolean changed = false;
            String[] pathSegs = path.toArray(new String[path.size()]);
            for (int i = this.mPaths.size() - 1; i >= 0; --i) {
                String[] existing = this.mPaths.valueAt(i);
                if (!this.isPathPrefixMatch(pathSegs, existing)) continue;
                changed = true;
                this.mPaths.removeAt(i);
            }
            if (changed) {
                this.mTracker.onPersistableDirty(this);
            }
        }

        public synchronized Collection<String[]> getPaths() {
            return new ArraySet<String[]>(this.mPaths);
        }

        public boolean hasPermission(List<String> path) {
            for (String[] p : this.mPaths) {
                if (!this.isPathPrefixMatch(p, path.toArray(new String[path.size()]))) continue;
                return true;
            }
            return false;
        }

        private boolean isPathPrefixMatch(String[] prefix, String[] path) {
            int prefixSize = prefix.length;
            if (path.length < prefixSize) {
                return false;
            }
            for (int i = 0; i < prefixSize; ++i) {
                if (Objects.equals(path[i], prefix[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getFileName() {
            return null;
        }

        @Override
        public synchronized void writeTo(XmlSerializer out) throws IOException {
            int N = this.mPaths.size();
            for (int i = 0; i < N; ++i) {
                String[] segments = this.mPaths.valueAt(i);
                if (segments == null) continue;
                out.startTag(NAMESPACE, SliceClientPermissions.TAG_PATH);
                out.text(this.encodeSegments(segments));
                out.endTag(NAMESPACE, SliceClientPermissions.TAG_PATH);
            }
        }

        public synchronized void readFrom(XmlPullParser parser) throws IOException, XmlPullParserException {
            parser.next();
            int depth = parser.getDepth();
            while (parser.getDepth() >= depth) {
                if (parser.getEventType() == 2 && SliceClientPermissions.TAG_PATH.equals(parser.getName())) {
                    this.mPaths.add(this.decodeSegments(parser.nextText()));
                }
                parser.next();
            }
        }

        private String encodeSegments(String[] s) {
            Object[] out = new String[s.length];
            for (int i = 0; i < s.length; ++i) {
                out[i] = Uri.encode(s[i]);
            }
            return TextUtils.join((CharSequence)DELIMITER, out);
        }

        private String[] decodeSegments(String s) {
            String[] sets = s.split(DELIMITER, -1);
            for (int i = 0; i < sets.length; ++i) {
                sets[i] = Uri.decode(sets[i]);
            }
            return sets;
        }

        public boolean equals(Object obj) {
            if (!this.getClass().equals(obj != null ? obj.getClass() : null)) {
                return false;
            }
            SliceAuthority other = (SliceAuthority)obj;
            if (this.mPaths.size() != other.mPaths.size()) {
                return false;
            }
            ArrayList<String[]> p1 = new ArrayList<String[]>(this.mPaths);
            ArrayList<String[]> p2 = new ArrayList<String[]>(other.mPaths);
            p1.sort(Comparator.comparing(o -> TextUtils.join((CharSequence)",", o)));
            p2.sort(Comparator.comparing(o -> TextUtils.join((CharSequence)",", o)));
            for (int i = 0; i < p1.size(); ++i) {
                String[] a2;
                String[] a1 = p1.get(i);
                if (a1.length != (a2 = p2.get(i)).length) {
                    return false;
                }
                for (int j = 0; j < a1.length; ++j) {
                    if (Objects.equals(a1[j], a2[j])) continue;
                    return false;
                }
            }
            return Objects.equals(this.mAuthority, other.mAuthority) && Objects.equals(this.mPkg, other.mPkg);
        }

        public String toString() {
            return String.format("(%s, %s: %s)", this.mAuthority, this.mPkg.toString(), this.pathToString(this.mPaths));
        }

        private String pathToString(ArraySet<String[]> paths) {
            return TextUtils.join((CharSequence)", ", paths.stream().map(s -> TextUtils.join((CharSequence)DELIMITER, s)).collect(Collectors.toList()));
        }
    }
}

