/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.slice;

import android.app.AppOpsManager;
import android.app.slice.ISliceManager;
import android.app.slice.SliceSpec;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AssistUtils;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import com.android.server.slice.PinnedSliceState;
import com.android.server.slice.SlicePermissionManager;
import com.android.server.slice.SliceShellCommand;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class SliceManagerService
extends ISliceManager.Stub {
    private static final String TAG = "SliceManagerService";
    private final Object mLock = new Object();
    private final Context mContext;
    private final PackageManagerInternal mPackageManagerInternal;
    private final AppOpsManager mAppOps;
    private final AssistUtils mAssistUtils;
    @GuardedBy(value={"mLock"})
    private final ArrayMap<Uri, PinnedSliceState> mPinnedSlicesByUri = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private final SparseArray<PackageMatchingCache> mAssistantLookup = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final SparseArray<PackageMatchingCache> mHomeLookup = new SparseArray();
    private final Handler mHandler;
    private final SlicePermissionManager mPermissions;
    private final UsageStatsManagerInternal mAppUsageStats;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String pkg;
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                Slog.w(SliceManagerService.TAG, "Intent broadcast does not contain user handle: " + intent);
                return;
            }
            Uri data = intent.getData();
            String string2 = pkg = data != null ? data.getSchemeSpecificPart() : null;
            if (pkg == null) {
                Slog.w(SliceManagerService.TAG, "Intent broadcast does not contain package name: " + intent);
                return;
            }
            switch (intent.getAction()) {
                case "android.intent.action.PACKAGE_REMOVED": {
                    boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                    if (replacing) break;
                    SliceManagerService.this.mPermissions.removePkg(pkg, userId);
                    break;
                }
                case "android.intent.action.PACKAGE_DATA_CLEARED": {
                    SliceManagerService.this.mPermissions.removePkg(pkg, userId);
                }
            }
        }
    };

    public SliceManagerService(Context context) {
        this(context, SliceManagerService.createHandler().getLooper());
    }

    @VisibleForTesting
    SliceManagerService(Context context, Looper looper) {
        this.mContext = context;
        this.mPackageManagerInternal = Preconditions.checkNotNull(LocalServices.getService(PackageManagerInternal.class));
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mAssistUtils = new AssistUtils(context);
        this.mHandler = new Handler(looper);
        this.mAppUsageStats = LocalServices.getService(UsageStatsManagerInternal.class);
        this.mPermissions = new SlicePermissionManager(this.mContext, looper);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_DATA_CLEARED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
    }

    private void systemReady() {
    }

    private void onUnlockUser(int userId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStopUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPinnedSlicesByUri.values().removeIf(s -> ContentProvider.getUserIdFromUri(s.getUri()) == userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uri[] getPinnedSlices(String pkg) {
        this.verifyCaller(pkg);
        int callingUser = Binder.getCallingUserHandle().getIdentifier();
        ArrayList<Uri> ret = new ArrayList<Uri>();
        Object object = this.mLock;
        synchronized (object) {
            for (PinnedSliceState state : this.mPinnedSlicesByUri.values()) {
                Uri uri;
                int userId;
                if (!Objects.equals(pkg, state.getPkg()) || (userId = ContentProvider.getUserIdFromUri(uri = state.getUri(), callingUser)) != callingUser) continue;
                ret.add(ContentProvider.getUriWithoutUserId(uri));
            }
        }
        return ret.toArray(new Uri[ret.size()]);
    }

    @Override
    public void pinSlice(String pkg, Uri uri, SliceSpec[] specs, IBinder token) throws RemoteException {
        this.verifyCaller(pkg);
        this.enforceAccess(pkg, uri);
        int user = Binder.getCallingUserHandle().getIdentifier();
        uri = ContentProvider.maybeAddUserId(uri, user);
        String slicePkg = this.getProviderPkg(uri, user);
        this.getOrCreatePinnedSlice(uri, slicePkg).pin(pkg, specs, token);
        this.mHandler.post(() -> {
            if (slicePkg != null && !Objects.equals(pkg, slicePkg)) {
                this.mAppUsageStats.reportEvent(slicePkg, user, this.isAssistant(pkg, user) || this.isDefaultHomeApp(pkg, user) ? 13 : 14);
            }
        });
    }

    @Override
    public void unpinSlice(String pkg, Uri uri, IBinder token) throws RemoteException {
        this.verifyCaller(pkg);
        this.enforceAccess(pkg, uri);
        uri = ContentProvider.maybeAddUserId(uri, Binder.getCallingUserHandle().getIdentifier());
        if (this.getPinnedSlice(uri).unpin(pkg, token)) {
            this.removePinnedSlice(uri);
        }
    }

    @Override
    public boolean hasSliceAccess(String pkg) throws RemoteException {
        this.verifyCaller(pkg);
        return this.hasFullSliceAccess(pkg, Binder.getCallingUserHandle().getIdentifier());
    }

    @Override
    public SliceSpec[] getPinnedSpecs(Uri uri, String pkg) throws RemoteException {
        this.verifyCaller(pkg);
        this.enforceAccess(pkg, uri);
        uri = ContentProvider.maybeAddUserId(uri, Binder.getCallingUserHandle().getIdentifier());
        return this.getPinnedSlice(uri).getSpecs();
    }

    @Override
    public void grantSlicePermission(String pkg, String toPkg, Uri uri) throws RemoteException {
        this.verifyCaller(pkg);
        int user = Binder.getCallingUserHandle().getIdentifier();
        this.enforceOwner(pkg, uri, user);
        this.mPermissions.grantSliceAccess(toPkg, user, pkg, user, uri);
    }

    @Override
    public void revokeSlicePermission(String pkg, String toPkg, Uri uri) throws RemoteException {
        this.verifyCaller(pkg);
        int user = Binder.getCallingUserHandle().getIdentifier();
        this.enforceOwner(pkg, uri, user);
        this.mPermissions.revokeSliceAccess(toPkg, user, pkg, user, uri);
    }

    @Override
    public int checkSlicePermission(Uri uri, String callingPkg, String pkg, int pid, int uid, String[] autoGrantPermissions) {
        int userId = UserHandle.getUserId(uid);
        if (pkg == null) {
            for (String p : this.mContext.getPackageManager().getPackagesForUid(uid)) {
                if (this.checkSlicePermission(uri, callingPkg, p, pid, uid, autoGrantPermissions) != 0) continue;
                return 0;
            }
            return -1;
        }
        if (this.hasFullSliceAccess(pkg, userId)) {
            return 0;
        }
        if (this.mPermissions.hasPermission(pkg, userId, uri)) {
            return 0;
        }
        if (autoGrantPermissions != null && callingPkg != null) {
            this.enforceOwner(callingPkg, uri, userId);
            for (String perm : autoGrantPermissions) {
                if (this.mContext.checkPermission(perm, pid, uid) != 0) continue;
                int providerUser = ContentProvider.getUserIdFromUri(uri, userId);
                String providerPkg = this.getProviderPkg(uri, providerUser);
                this.mPermissions.grantSliceAccess(pkg, userId, providerPkg, providerUser, uri);
                return 0;
            }
        }
        if (this.mContext.checkUriPermission(uri, pid, uid, 2) == 0) {
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantPermissionFromUser(Uri uri, String pkg, String callingPkg, boolean allSlices) {
        this.verifyCaller(callingPkg);
        this.getContext().enforceCallingOrSelfPermission("android.permission.MANAGE_SLICE_PERMISSIONS", "Slice granting requires MANAGE_SLICE_PERMISSIONS");
        int userId = Binder.getCallingUserHandle().getIdentifier();
        if (allSlices) {
            this.mPermissions.grantFullAccess(pkg, userId);
        } else {
            Uri grantUri = uri.buildUpon().path("").build();
            int providerUser = ContentProvider.getUserIdFromUri(grantUri, userId);
            String providerPkg = this.getProviderPkg(grantUri, providerUser);
            this.mPermissions.grantSliceAccess(pkg, userId, providerPkg, providerUser, grantUri);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.getContentResolver().notifyChange(uri, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public byte[] getBackupPayload(int user) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Caller must be system");
        }
        if (user != 0) {
            Slog.w(TAG, "getBackupPayload: cannot backup policy for user " + user);
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XmlSerializer out = XmlPullParserFactory.newInstance().newSerializer();
            out.setOutput(baos, Xml.Encoding.UTF_8.name());
            this.mPermissions.writeBackup(out);
            out.flush();
            return baos.toByteArray();
        }
        catch (IOException | XmlPullParserException e) {
            Slog.w(TAG, "getBackupPayload: error writing payload for user " + user, e);
            return null;
        }
    }

    @Override
    public void applyRestore(byte[] payload, int user) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Caller must be system");
        }
        if (payload == null) {
            Slog.w(TAG, "applyRestore: no payload to restore for user " + user);
            return;
        }
        if (user != 0) {
            Slog.w(TAG, "applyRestore: cannot restore policy for user " + user);
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        try {
            XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput(bais, Xml.Encoding.UTF_8.name());
            this.mPermissions.readRestore(parser);
        }
        catch (IOException | NumberFormatException | XmlPullParserException e) {
            Slog.w(TAG, "applyRestore: error reading payload", e);
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new SliceShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    private void enforceOwner(String pkg, Uri uri, int user) {
        if (!Objects.equals(this.getProviderPkg(uri, user), pkg) || pkg == null) {
            throw new SecurityException("Caller must own " + uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePinnedSlice(Uri uri) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPinnedSlicesByUri.remove(uri).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PinnedSliceState getPinnedSlice(Uri uri) {
        Object object = this.mLock;
        synchronized (object) {
            PinnedSliceState manager = this.mPinnedSlicesByUri.get(uri);
            if (manager == null) {
                throw new IllegalStateException(String.format("Slice %s not pinned", uri.toString()));
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PinnedSliceState getOrCreatePinnedSlice(Uri uri, String pkg) {
        Object object = this.mLock;
        synchronized (object) {
            PinnedSliceState manager = this.mPinnedSlicesByUri.get(uri);
            if (manager == null) {
                manager = this.createPinnedSlice(uri, pkg);
                this.mPinnedSlicesByUri.put(uri, manager);
            }
            return manager;
        }
    }

    @VisibleForTesting
    protected PinnedSliceState createPinnedSlice(Uri uri, String pkg) {
        return new PinnedSliceState(this, uri, pkg);
    }

    public Object getLock() {
        return this.mLock;
    }

    public Context getContext() {
        return this.mContext;
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    protected int checkAccess(String pkg, Uri uri, int uid, int pid) {
        return this.checkSlicePermission(uri, null, pkg, pid, uid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProviderPkg(Uri uri, int user) {
        long ident = Binder.clearCallingIdentity();
        try {
            String providerName = ContentProvider.getUriWithoutUserId(uri).getAuthority();
            ProviderInfo provider = this.mContext.getPackageManager().resolveContentProviderAsUser(providerName, 0, ContentProvider.getUserIdFromUri(uri, user));
            String string2 = provider.packageName;
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void enforceCrossUser(String pkg, Uri uri) {
        int user = Binder.getCallingUserHandle().getIdentifier();
        if (ContentProvider.getUserIdFromUri(uri, user) != user) {
            this.getContext().enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "Slice interaction across users requires INTERACT_ACROSS_USERS_FULL");
        }
    }

    private void enforceAccess(String pkg, Uri uri) throws RemoteException {
        int userId;
        if (this.checkAccess(pkg, uri, Binder.getCallingUid(), Binder.getCallingPid()) != 0 && !Objects.equals(pkg, this.getProviderPkg(uri, userId = ContentProvider.getUserIdFromUri(uri, Binder.getCallingUserHandle().getIdentifier())))) {
            throw new SecurityException("Access to slice " + uri + " is required");
        }
        this.enforceCrossUser(pkg, uri);
    }

    private void verifyCaller(String pkg) {
        this.mAppOps.checkPackage(Binder.getCallingUid(), pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFullSliceAccess(String pkg, int userId) {
        long ident = Binder.clearCallingIdentity();
        try {
            boolean ret;
            boolean bl = ret = this.isDefaultHomeApp(pkg, userId) || this.isAssistant(pkg, userId) || this.isGrantedFullAccess(pkg, userId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private boolean isAssistant(String pkg, int userId) {
        return this.getAssistantMatcher(userId).matches(pkg);
    }

    private boolean isDefaultHomeApp(String pkg, int userId) {
        return this.getHomeMatcher(userId).matches(pkg);
    }

    private PackageMatchingCache getAssistantMatcher(int userId) {
        PackageMatchingCache matcher = this.mAssistantLookup.get(userId);
        if (matcher == null) {
            matcher = new PackageMatchingCache(() -> this.getAssistant(userId));
            this.mAssistantLookup.put(userId, matcher);
        }
        return matcher;
    }

    private PackageMatchingCache getHomeMatcher(int userId) {
        PackageMatchingCache matcher = this.mHomeLookup.get(userId);
        if (matcher == null) {
            matcher = new PackageMatchingCache(() -> this.getDefaultHome(userId));
            this.mHomeLookup.put(userId, matcher);
        }
        return matcher;
    }

    private String getAssistant(int userId) {
        ComponentName cn = this.mAssistUtils.getAssistComponentForUser(userId);
        if (cn == null) {
            return null;
        }
        return cn.getPackageName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected String getDefaultHome(int userId) {
        long token = Binder.clearCallingIdentity();
        try {
            ArrayList<ResolveInfo> allHomeCandidates = new ArrayList<ResolveInfo>();
            ComponentName defaultLauncher = this.mPackageManagerInternal.getHomeActivitiesAsUser(allHomeCandidates, userId);
            ComponentName detected = null;
            if (defaultLauncher != null) {
                detected = defaultLauncher;
            }
            if (detected == null) {
                int size = allHomeCandidates.size();
                int lastPriority = Integer.MIN_VALUE;
                for (int i = 0; i < size; ++i) {
                    ResolveInfo ri = (ResolveInfo)allHomeCandidates.get(i);
                    if (!ri.activityInfo.applicationInfo.isSystemApp() || ri.priority < lastPriority) continue;
                    detected = ri.activityInfo.getComponentName();
                    lastPriority = ri.priority;
                }
            }
            String string2 = detected != null ? detected.getPackageName() : null;
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private boolean isGrantedFullAccess(String pkg, int userId) {
        return this.mPermissions.hasFullAccess(pkg, userId);
    }

    private static ServiceThread createHandler() {
        ServiceThread handlerThread = new ServiceThread(TAG, 10, true);
        handlerThread.start();
        return handlerThread;
    }

    public String[] getAllPackagesGranted(String authority) {
        String pkg = this.getProviderPkg(new Uri.Builder().scheme("content").authority(authority).build(), 0);
        return this.mPermissions.getAllPackagesGranted(pkg);
    }

    private class SliceGrant {
        private final Uri mUri;
        private final String mPkg;
        private final int mUserId;

        public SliceGrant(Uri uri, String pkg, int userId) {
            this.mUri = uri;
            this.mPkg = pkg;
            this.mUserId = userId;
        }

        public int hashCode() {
            return this.mUri.hashCode() + this.mPkg.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SliceGrant)) {
                return false;
            }
            SliceGrant other = (SliceGrant)obj;
            return Objects.equals(other.mUri, this.mUri) && Objects.equals(other.mPkg, this.mPkg) && other.mUserId == this.mUserId;
        }
    }

    public static class Lifecycle
    extends SystemService {
        private SliceManagerService mService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mService = new SliceManagerService(this.getContext());
            this.publishBinderService("slice", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mService.systemReady();
            }
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mService.onUnlockUser(userHandle);
        }

        @Override
        public void onStopUser(int userHandle) {
            this.mService.onStopUser(userHandle);
        }
    }

    static class PackageMatchingCache {
        private final Supplier<String> mPkgSource;
        private String mCurrentPkg;

        public PackageMatchingCache(Supplier<String> pkgSource) {
            this.mPkgSource = pkgSource;
        }

        public boolean matches(String pkgCandidate) {
            if (pkgCandidate == null) {
                return false;
            }
            if (Objects.equals(pkgCandidate, this.mCurrentPkg)) {
                return true;
            }
            this.mCurrentPkg = this.mPkgSource.get();
            return Objects.equals(pkgCandidate, this.mCurrentPkg);
        }
    }
}

